/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: FNORM.C $
   $Locker:  $	$Name:  $	$State: Exp $

	_fnormalize(*seg, *ofs)

	Normalize the far pointer.

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifdef _MICROC_
#include <portable.h>

void _fnormalize_(unsigned *seg, unsigned *ofs)
{	*seg += *ofs >> 4;
	*ofs &= 0xf;
}

#else
#ifdef HI_TECH_C
#include <portable.h>
#include <dos.h>

void far *_fnormalize(void far *poi)
{	return	MK_FP(FP_SEG(poi) + (FP_OFF(poi) >> 4), FP_OFF(poi) & 0xF);
}

#endif

#endif
