/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: MCB_WALK.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int mcb_walk(mcb, fct, arg)

	fct is a pointer to a function of the type:
		int (*fct)(void *arg, unsigned mcb)
	where arg is arg of mcb_walk() and mcb is the current paragraph number.

	Common MCB walker. Runs down the MCB chain and calls fct() with
	each MCB paragraphe number, until the end of chain is reached
	or the fct() returns != 0.

	mcb is the mcb where to start, if 0, the walk starts over.

	Return:	 0: end of chain reached (function never hit).
			-1: chain is corrupted.
		  else: function cancelled walk process.

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#endif
#ifndef NDEBUG
#include <stdio.h>
#endif
#include <portable.h>
#include "mcb.h"
#include "suppl.h"

int mcb_walk(unsigned mcb, const MCB_WALKFUNC fct, void * const arg)
{	unsigned ofs;
	FLAG UMBLink;
	FLAG8 MCBtype;
	USEREGS

	if(!mcb) {		/* begin with the 1st MCB */
		_AH = 0x52;			/* get list of list */
		geninterrupt(0x21);
		ofs = _BX;			/* mcb:ofs := pointer to list of lists */
		mcb = _ES;

		if(ofs < 2) --mcb, ofs += 16;	/* Avoid the segment warp */

		mcb = peekw(mcb, ofs - 2);		/* 1st MCB */
	}

	/* for walking, link in UMB list */
	UMBLink = 1;		/* Don't unlink UMBs */
	if(_osmajor >= 5) {	/* UMBs since DOS 5 */
		_AX = 0x5802;	/* Get UMB Link state */
		geninterrupt(0x21);
		UMBLink = _AL;
		if(!_CFLAG && !UMBLink) {	/* There are UMBs && not linked, yet */
			_BX = 1;	/* Link them */
			_AX = 0x5803;	/* Set UMB Link state */
			geninterrupt(0x21);
		}
	}

	while(ofs = -1, (MCBtype = peekb(mcb, OFF_MCB_TYPE)) == 'M' || MCBtype == 'Z') {
		/* MCB seems to be valid */

		if((ofs = (*fct)(arg, mcb)) != 0	/* call fct & break if necessary */
		 || MCBtype == 'Z') break;	/* end of chain */
		mcb += peekw(mcb, OFF_MCB_SIZE) + 1;	/* advance to next MCB */
	}

	if(UMBLink == 0) {	/* unlink UMBs */
		_AX = 0x5803;
		_BX = 0;
		geninterrupt(0x21);
	}

	return ofs;
}

