/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: MEMCMPI.C $
   $Locker:  $	$Name:  $	$State: Exp $

	Defines the memicmp() function, a memcmp() ignoring
	the case of the letters.

	Returns:  >0 second block is greater
			 ==0 both are equal
			  <0 first block is greater

	Micro-C & Pacific C only.

*/

#include "initsupl.inc"

#ifdef _MICROC_
#define COMPILE
#else
#ifdef _PAC_NOCLIB_
#define COMPILE
#endif
#endif

#ifdef COMPILE

#include <ctype.h>

int memicmp(unsigned char *s, unsigned char *p, unsigned len)
{	int result;

	result = 0;
	while(len-- && !(result = toupper(*p++) - toupper(*s++)));
	return result;
}
#endif
