/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: PEEKDD.C $
   $Locker:  $	$Name:  $	$State: Exp $

	peekdd(word seg, word ofs, word *hi, word *lo)

	copying the two word values from the far memory.
	If hi or lo are NULL, the particular value is not copied.

	Return:	0: both hi and lo are zero
			1: hi is non-zero
			2: lo is non-zero
			3: both are non-zero

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#endif
#include <portable.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: PEEKDD.C 2.4 1998/08/19 02:40:21 ska Exp $";
#endif

peekdd(word segm, word ofs, word *hi, word *lo)
{ 	word h, l, res;

	res = !!(h = peekw(segm, ofs + 2));
	if((l = peekw(segm, ofs)) != 0)
		res |= 2;
	if(hi) *hi = h;
	if(lo) *lo = l;
	return res;
}
