/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: STRTOD.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int strtol(char *number, char **endp, int radix)

	Arguments:
		number: string of the number
		endp: pointer of the string pointer will be set to the end of
			the number
		radix: base of the number; if 0, use C-style

	Return:
		*endp: address of the character, terminating the scan
			if NULL, all characters of the string are used up.
		return value: number

	Micro-C only.

*/

#include "initsupl.inc"

#ifdef _MICROC_
#include <ctype.h>
#include <stdio.h>

#define endup { if(endp) *endp = nr; return negate? -i: i; }
int strtol(char *nr, char **endp, int radix)
{	int i, negate;
	register int c;

	i = 0;
	--nr;
	while(isspace(*++nr));
	if((negate = (c = *nr) == '-') || c == '+')
		while(isspace(*++nr));
	if(radix == 0) 
		if(*nr == '0') {
			if(tolower(nr[1]) == 'x') {
				radix = 16;
				nr += 2;	/* skip 0x */
			}
			else radix = 8;	/* don't skip '0', mayhap its only "0" */
		}
		else radix = 10;

	if(radix < 2 || radix > 36 || !*nr) endup
	--nr;
	do {
		if(isdigit(c = *++nr)) i = i * radix + c - '0';
		else if((c = tolower(c)) >= 'a' && c <= 'z') i = i * radix + c - 'a' + 10;
		else {
			while(isspace(*nr)) ++nr;
			if(*nr == '\0')
				nr = NULL;
			endup
		}
	} while(1);
}
#endif
