/*
 * Decompiled with CFR 0.152.
 */
package fpc.tools.javapp;

import fpc.tools.javapp.AttrData;
import fpc.tools.javapp.CPX;
import fpc.tools.javapp.CPX2;
import fpc.tools.javapp.FieldData;
import fpc.tools.javapp.InnerClassData;
import fpc.tools.javapp.MethodData;
import fpc.tools.javapp.RuntimeConstants;
import fpc.tools.javapp.Tables;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;

public class ClassData
implements RuntimeConstants {
    private int magic;
    private int minor_version;
    private int major_version;
    private int cpool_count;
    protected Object[] cpool;
    protected int access;
    private int this_class = 0;
    private int super_class;
    private int interfaces_count;
    private int[] interfaces = new int[0];
    private int fields_count;
    protected FieldData[] fields;
    private int methods_count;
    protected MethodData[] methods;
    protected InnerClassData[] innerClasses;
    private int attributes_count;
    private AttrData[] attrs;
    private String classname;
    private String superclassname;
    private int source_cpx = 0;
    protected byte[] tags;
    private Hashtable indexHashAscii = new Hashtable();
    private String pkgPrefix = "";
    private int pkgPrefixLen = 0;
    static final String hexString = "0123456789ABCDEF";
    public static char[] hexTable = "0123456789ABCDEF".toCharArray();

    public ClassData(InputStream infile) {
        try {
            this.read(new DataInputStream(infile));
        }
        catch (FileNotFoundException ee) {
            this.error("cant read file");
        }
        catch (Error ee) {
            ee.printStackTrace();
            this.error("fatal error");
        }
        catch (Exception ee) {
            ee.printStackTrace();
            this.error("fatal exception");
        }
    }

    protected InnerClassData NewInnerClassData() {
        return new InnerClassData(this);
    }

    public void read(DataInputStream in) throws IOException {
        this.magic = in.readInt();
        if (this.magic != -889275714) {
            throw new ClassFormatError("wrong magic: " + ClassData.toHex(this.magic) + ", expected " + ClassData.toHex(-889275714));
        }
        this.minor_version = in.readShort();
        this.major_version = in.readShort();
        this.readCP(in);
        this.access = in.readUnsignedShort();
        this.this_class = in.readUnsignedShort();
        this.super_class = in.readUnsignedShort();
        this.interfaces_count = in.readUnsignedShort();
        if (this.interfaces_count > 0) {
            this.interfaces = new int[this.interfaces_count];
        }
        int i = 0;
        while (i < this.interfaces_count) {
            this.interfaces[i] = in.readShort();
            ++i;
        }
        this.readFields(in);
        this.readMethods(in);
        this.attributes_count = in.readUnsignedShort();
        this.attrs = new AttrData[this.attributes_count];
        int k = 0;
        while (k < this.attributes_count) {
            AttrData attr;
            int name_cpx = in.readUnsignedShort();
            if (this.getTag(name_cpx) == 1 && this.getString(name_cpx).equals("SourceFile")) {
                if (in.readInt() != 2) {
                    throw new ClassFormatError("invalid attr length");
                }
                this.source_cpx = in.readUnsignedShort();
                attr = new AttrData(this);
                attr.read(name_cpx);
                this.attrs[k] = attr;
            } else if (this.getTag(name_cpx) == 1 && this.getString(name_cpx).equals("InnerClasses")) {
                int length = in.readInt();
                int num = in.readUnsignedShort();
                if (2 + num * 8 != length) {
                    throw new ClassFormatError("invalid attr length");
                }
                this.innerClasses = new InnerClassData[num];
                int j = 0;
                while (j < num) {
                    InnerClassData innerClass = this.NewInnerClassData();
                    innerClass.read(in);
                    this.innerClasses[j] = innerClass;
                    ++j;
                }
                AttrData attr2 = new AttrData(this);
                attr2.read(name_cpx);
                this.attrs[k] = attr2;
            } else {
                attr = new AttrData(this);
                attr.read(name_cpx, in);
                this.attrs[k] = attr;
            }
            ++k;
        }
        in.close();
    }

    void readCP(DataInputStream in) throws IOException {
        this.cpool_count = in.readUnsignedShort();
        this.tags = new byte[this.cpool_count];
        this.cpool = new Object[this.cpool_count];
        int i = 1;
        while (i < this.cpool_count) {
            byte tag;
            this.tags[i] = tag = in.readByte();
            switch (this.tags[i]) {
                case 1: {
                    String str = in.readUTF();
                    this.cpool[i] = str;
                    this.indexHashAscii.put(this.cpool[i], new Integer(i));
                    break;
                }
                case 3: {
                    this.cpool[i] = new Integer(in.readInt());
                    break;
                }
                case 4: {
                    this.cpool[i] = new Float(in.readFloat());
                    break;
                }
                case 5: {
                    this.cpool[i++] = new Long(in.readLong());
                    break;
                }
                case 6: {
                    this.cpool[i++] = new Double(in.readDouble());
                    break;
                }
                case 7: 
                case 8: {
                    this.cpool[i] = new CPX(in.readUnsignedShort());
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.cpool[i] = new CPX2(in.readUnsignedShort(), in.readUnsignedShort());
                    break;
                }
                default: {
                    throw new ClassFormatError("invalid constant type: " + this.tags[i]);
                }
            }
            ++i;
        }
    }

    protected void readFields(DataInputStream in) throws IOException {
        int fields_count = in.readUnsignedShort();
        this.fields = new FieldData[fields_count];
        int k = 0;
        while (k < fields_count) {
            FieldData field = new FieldData(this);
            field.read(in);
            this.fields[k] = field;
            ++k;
        }
    }

    protected void readMethods(DataInputStream in) throws IOException {
        int methods_count = in.readUnsignedShort();
        this.methods = new MethodData[methods_count];
        int k = 0;
        while (k < methods_count) {
            MethodData method = new MethodData(this);
            method.read(in);
            this.methods[k] = method;
            ++k;
        }
    }

    public String getString(int n) {
        return n == 0 ? null : (String)this.cpool[n];
    }

    public byte getTag(int n) {
        try {
            return this.tags[n];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 100;
        }
    }

    static String toHex(long val, int width) {
        StringBuffer s = new StringBuffer();
        int i = width - 1;
        while (i >= 0) {
            s.append(hexTable[(int)(val >> 4 * i) & 0xF]);
            --i;
        }
        return "0x" + s.toString();
    }

    static String toHex(long val) {
        int width = 16;
        while (width > 0) {
            if (val >> (width - 1) * 4 != 0L) break;
            --width;
        }
        return ClassData.toHex(val, width);
    }

    static String toHex(int val) {
        int width = 8;
        while (width > 0) {
            if (val >> (width - 1) * 4 != 0) break;
            --width;
        }
        return ClassData.toHex(val, width);
    }

    public void error(String msg) {
        System.err.println("ERROR:" + msg);
    }

    public String getClassName() {
        int tcpx;
        String res = null;
        if (this.this_class == 0) {
            return res;
        }
        try {
            if (this.tags[this.this_class] != 7) {
                return res;
            }
            tcpx = ((CPX)this.cpool[this.this_class]).cpx;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return res;
        }
        catch (Throwable e) {
            return res;
        }
        try {
            return (String)this.cpool[tcpx];
        }
        catch (ArrayIndexOutOfBoundsException e) {}
        catch (ClassCastException e) {}
        finally {
            return res;
        }
    }

    public String getClassName(int cpx) {
        int scpx;
        String res = "#" + cpx;
        if (cpx == 0) {
            return res;
        }
        try {
            if (this.tags[cpx] != 7) {
                return res;
            }
            scpx = ((CPX)this.cpool[cpx]).cpx;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return res;
        }
        catch (Throwable e) {
            return res;
        }
        res = "#" + scpx;
        try {
            return (String)this.cpool[scpx];
        }
        catch (ArrayIndexOutOfBoundsException e) {}
        catch (ClassCastException e) {}
        finally {
            return res;
        }
    }

    public boolean isClass() {
        return (this.access & 0x200) == 0;
    }

    public boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    public boolean isPublic() {
        return (this.access & 1) != 0;
    }

    public String[] getAccess() {
        Vector<String> v = new Vector<String>();
        if ((this.access & 1) != 0) {
            v.addElement("public");
        }
        if ((this.access & 0x10) != 0) {
            v.addElement("final");
        }
        if ((this.access & 0x400) != 0) {
            v.addElement("abstract");
        }
        Object[] accflags = new String[v.size()];
        v.copyInto(accflags);
        return accflags;
    }

    public InnerClassData[] getInnerClasses() {
        return this.innerClasses;
    }

    public AttrData[] getAttributes() {
        return this.attrs;
    }

    public boolean isSuperSet() {
        return (this.access & 0x20) != 0;
    }

    public String getSuperClassName() {
        int scpx;
        String res = null;
        if (this.super_class == 0) {
            return res;
        }
        try {
            if (this.tags[this.super_class] != 7) {
                return res;
            }
            scpx = ((CPX)this.cpool[this.super_class]).cpx;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return res;
        }
        catch (Throwable e) {
            return res;
        }
        try {
            return (String)this.cpool[scpx];
        }
        catch (ArrayIndexOutOfBoundsException e) {}
        catch (ClassCastException e) {}
        finally {
            return res;
        }
    }

    public String[] getSuperInterfaces() {
        String[] interfacenames = new String[this.interfaces.length];
        int interfacecpx = -1;
        int i = 0;
        while (i < this.interfaces.length) {
            interfacecpx = ((CPX)this.cpool[this.interfaces[i]]).cpx;
            interfacenames[i] = (String)this.cpool[interfacecpx];
            ++i;
        }
        return interfacenames;
    }

    public String getStringValue(int cpoolx) {
        try {
            return (String)this.cpool[cpoolx];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "//invalid constant pool index:" + cpoolx;
        }
        catch (ClassCastException e) {
            return "//invalid constant pool ref:" + cpoolx;
        }
    }

    public FieldData[] getFields() {
        return this.fields;
    }

    public MethodData[] getMethods() {
        return this.methods;
    }

    public CPX2 getCpoolEntry(int cpx) {
        return (CPX2)this.cpool[cpx];
    }

    public Object getCpoolEntryobj(int cpx) {
        return this.cpool[cpx];
    }

    public int getthis_cpx() {
        return this.this_class;
    }

    public String TagString(int tag) {
        String res = Tables.tagName(tag);
        if (res == null) {
            return "BOGUS_TAG:" + tag;
        }
        return res;
    }

    public String StringValue(int cpx) {
        Object x;
        byte tag;
        if (cpx == 0) {
            return "#0";
        }
        String suffix = "";
        try {
            tag = this.tags[cpx];
            x = this.cpool[cpx];
        }
        catch (IndexOutOfBoundsException e) {
            return "<Incorrect CP index:" + cpx + ">";
        }
        if (x == null) {
            return "<NULL>";
        }
        switch (tag) {
            case 1: {
                StringBuffer sb = new StringBuffer();
                String s = (String)x;
                int k = 0;
                while (k < s.length()) {
                    char c = s.charAt(k);
                    switch (c) {
                        case '\t': {
                            sb.append('\\').append('t');
                            break;
                        }
                        case '\n': {
                            sb.append('\\').append('n');
                            break;
                        }
                        case '\r': {
                            sb.append('\\').append('r');
                            break;
                        }
                        case '\"': {
                            sb.append('\\').append('\"');
                            break;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                    ++k;
                }
                return sb.toString();
            }
            case 6: {
                Double d = (Double)x;
                String sd = d.toString();
                return String.valueOf(sd) + "d";
            }
            case 4: {
                Float f = (Float)x;
                String sf = f.toString();
                return String.valueOf(sf) + "f";
            }
            case 5: {
                Long ln = (Long)x;
                return String.valueOf(ln.toString()) + 'l';
            }
            case 3: {
                Integer in = (Integer)x;
                return in.toString();
            }
            case 7: {
                return this.javaName(this.getClassName(cpx));
            }
            case 8: {
                return this.StringValue(((CPX)x).cpx);
            }
            case 9: 
            case 10: 
            case 11: {
                return String.valueOf(this.javaName(this.getClassName(((CPX2)x).cpx1))) + "." + this.StringValue(((CPX2)x).cpx2);
            }
            case 12: {
                return String.valueOf(this.getName(((CPX2)x).cpx1)) + ":" + this.StringValue(((CPX2)x).cpx2);
            }
        }
        return "UnknownTag";
    }

    public String javaName(String name) {
        block4: {
            if (name == null) {
                return "null";
            }
            int len = name.length();
            if (len == 0) {
                return "\"\"";
            }
            int cc = 47;
            int k = 0;
            while (k < len) {
                int cp = name.codePointAt(k);
                if (!(cc == 47 ? !Character.isJavaIdentifierStart(cp) : cp != 47 && !Character.isJavaIdentifierPart(cp))) {
                    cc = cp;
                    k += Character.charCount(cp);
                    continue;
                }
                break block4;
            }
            return name;
        }
        return "\"" + name + "\"";
    }

    public String getName(int cpx) {
        try {
            return this.javaName((String)this.cpool[cpx]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "<invalid constant pool index:" + cpx + ">";
        }
        catch (ClassCastException e) {
            return "<invalid constant pool ref:" + cpx + ">";
        }
    }

    public String getShortClassName(int cpx) {
        String classname = this.javaName(this.getClassName(cpx));
        this.pkgPrefixLen = classname.lastIndexOf("/") + 1;
        if (this.pkgPrefixLen != 0) {
            this.pkgPrefix = classname.substring(0, this.pkgPrefixLen);
            if (classname.startsWith(this.pkgPrefix)) {
                return classname.substring(this.pkgPrefixLen);
            }
        }
        return classname;
    }

    public String getSourceName() {
        return this.getName(this.source_cpx);
    }

    public String getPkgName() {
        String classname = this.getClassName(this.this_class);
        this.pkgPrefixLen = classname.lastIndexOf("/") + 1;
        if (this.pkgPrefixLen != 0) {
            this.pkgPrefix = classname.substring(0, this.pkgPrefixLen);
            return "package  " + this.pkgPrefix.substring(0, this.pkgPrefixLen - 1) + ";\n";
        }
        return null;
    }

    public int getCpoolCount() {
        return this.cpool_count;
    }

    public String StringTag(int cpx) {
        byte tag = 0;
        String str = null;
        try {
            if (cpx == 0) {
                throw new IndexOutOfBoundsException();
            }
            tag = this.tags[cpx];
            return this.TagString(tag);
        }
        catch (IndexOutOfBoundsException e) {
            str = "Incorrect CP index:" + cpx;
            return str;
        }
    }

    public int getMinor_version() {
        return this.minor_version;
    }

    public int getMajor_version() {
        return this.major_version;
    }
}

