/*
 * Decompiled with CFR 0.152.
 */
package fpc.tools.javapp;

import fpc.tools.javapp.JavapEnvironment;
import fpc.tools.javapp.JavapPrinter;
import fpc.tools.javapp.PascalClassData;
import fpc.tools.javapp.PascalUnit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class Main {
    private ArrayList<String> pkgList = new ArrayList();
    JavapEnvironment env = new JavapEnvironment();
    private static boolean errorOccurred = false;
    private static final String progname = "javapp";

    public static void main(String[] argv) {
        Main.entry(argv);
        if (errorOccurred) {
            System.exit(1);
        }
    }

    public static void entry(String[] argv) {
        Main jpmain = new Main();
        jpmain.perform(argv);
    }

    private void perform(String[] argv) {
        if (this.parseArguments(argv)) {
            this.displayResults();
        }
    }

    private void error(String msg) {
        errorOccurred = true;
        System.err.println(msg);
        System.err.flush();
    }

    private void usage() {
        PrintStream out = System.out;
        out.println("Usage: javapp <options> [<packages>] [<individual_classes>]");
        out.println("  Suffix package names with '.'");
        out.println();
        out.println("where options include:");
        out.println("   -a <class_or_pkgename>    Create empty skeleton versions of these classes");
        out.println("   -classpath <pathlist>     Specify where to find user class files");
        out.println("   -help                     Print this usage message");
        out.println("   -J<flag>                  Pass <flag> directly to the runtime system");
        out.println("   -i                        Generate include files instead of complete unit");
        out.println("   -l                        Print line number and local variable tables");
        out.println("   -o <output_base_name>     Base name of output unit (default: java");
        out.println("   -public                   Print only public classes and members");
        out.println("   -protected                Print protected/public classes and members");
        out.println("   -private                  Show all classes and members");
        out.println("   -x <class_or_pkgename>    Treat this class/package as defined in another unit (suffix package names with '.'");
        out.println("   -s                        Print internal type signatures");
        out.println("   -bootclasspath <pathlist> Override location of class files loaded");
        out.println("                             by the bootstrap class loader");
        out.println("   -verbose                  Print stack size, number of locals and args for methods");
        out.println("                             If verifying, print reasons for failure");
        out.println();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseArguments(String[] argv) {
        int i = 0;
        while (i < argv.length) {
            block17: {
                String arg;
                block18: {
                    block30: {
                        block29: {
                            block28: {
                                block27: {
                                    block26: {
                                        block25: {
                                            block24: {
                                                block23: {
                                                    block22: {
                                                        block21: {
                                                            block20: {
                                                                block19: {
                                                                    arg = argv[i];
                                                                    if (!arg.startsWith("-")) break block18;
                                                                    if (!arg.equals("-l")) break block19;
                                                                    this.env.showLineAndLocal = true;
                                                                    break block17;
                                                                }
                                                                if (!arg.equals("-private") && !arg.equals("-p")) break block20;
                                                                this.env.showAccess = 0;
                                                                break block17;
                                                            }
                                                            if (!arg.equals("-package")) break block21;
                                                            this.env.showAccess = 2;
                                                            break block17;
                                                        }
                                                        if (!arg.equals("-protected")) break block22;
                                                        this.env.showAccess = 1;
                                                        break block17;
                                                    }
                                                    if (!arg.equals("-public")) break block23;
                                                    this.env.showAccess = 3;
                                                    break block17;
                                                }
                                                if (!arg.equals("-verbose")) break block24;
                                                this.env.showVerbose = true;
                                                break block17;
                                            }
                                            if (!arg.equals("-v")) break block25;
                                            this.env.showVerbose = true;
                                            break block17;
                                        }
                                        if (!arg.equals("-i")) break block26;
                                        this.env.generateInclude = true;
                                        break block17;
                                    }
                                    if (arg.equals("-h")) {
                                        this.error("-h is no longer available - use the 'javah' program");
                                        return false;
                                    }
                                    if (arg.equals("-verify")) {
                                        this.error("-verify is no longer available - use 'java -verify'");
                                        return false;
                                    }
                                    if (arg.equals("-verify-verbose")) {
                                        this.error("-verify is no longer available - use 'java -verify'");
                                        return false;
                                    }
                                    if (arg.equals("-help")) {
                                        this.usage();
                                        return false;
                                    }
                                    if (!arg.equals("-classpath")) break block27;
                                    if (i + 1 >= argv.length) {
                                        this.error("-classpath requires argument");
                                        this.usage();
                                        return false;
                                    }
                                    this.env.classPathString = argv[++i];
                                    break block17;
                                }
                                if (!arg.equals("-bootclasspath")) break block28;
                                if (i + 1 >= argv.length) {
                                    this.error("-bootclasspath requires argument");
                                    this.usage();
                                    return false;
                                }
                                this.env.bootClassPathString = argv[++i];
                                break block17;
                            }
                            if (!arg.equals("-extdirs")) break block29;
                            if (i + 1 >= argv.length) {
                                this.error("-extdirs requires argument");
                                this.usage();
                                return false;
                            }
                            this.env.extDirsString = argv[++i];
                            break block17;
                        }
                        if (!arg.equals("-o")) break block30;
                        if (i + 1 >= argv.length) {
                            this.error("-o requires argument");
                            this.usage();
                            return false;
                        }
                        this.env.outputName = argv[++i];
                        break block17;
                    }
                    if (arg.equals("-x")) {
                        if (i + 1 >= argv.length) {
                            this.error("-x requires argument");
                            this.usage();
                            return false;
                        }
                        this.env.excludePrefixes.add(argv[++i].replace('.', '/'));
                        break block17;
                    } else if (arg.equals("-a")) {
                        if (i + 1 >= argv.length) {
                            this.error("-a requires argument");
                            this.usage();
                            return false;
                        }
                        this.env.skelPrefixes.add(argv[++i].replace('.', '/'));
                        break block17;
                    } else {
                        if (!arg.equals("-all")) {
                            this.error("invalid flag: " + arg);
                            this.usage();
                            return false;
                        }
                        this.env.showallAttr = true;
                    }
                    break block17;
                }
                this.pkgList.add(arg);
                this.env.nothingToDo = false;
            }
            ++i;
        }
        if (this.env.nothingToDo) {
            System.out.println("No classes were specified on the command line.  Try -help.");
            errorOccurred = true;
            return false;
        }
        return true;
    }

    private PrintWriter createFile(String fname) {
        PrintWriter res = null;
        try {
            res = new PrintWriter(new OutputStreamWriter(new PrintStream(new File(fname))));
        }
        catch (FileNotFoundException e) {
            System.out.println("Unable to create file " + fname + ", aborting...");
            e.printStackTrace();
            System.exit(1);
        }
        return res;
    }

    private void displayResults() {
        PascalUnit thisUnit;
        if (this.pkgList.isEmpty()) {
            return;
        }
        System.out.println("default charset: " + Charset.defaultCharset().toString());
        SortedSet<String> classes = this.env.getClassesList();
        Collections.sort(this.pkgList);
        ArrayList<String> dontPrintPrefixes = new ArrayList<String>(this.env.excludePrefixes.size() + this.env.skelPrefixes.size());
        dontPrintPrefixes.addAll(this.env.excludePrefixes);
        dontPrintPrefixes.addAll(this.env.skelPrefixes);
        Collections.sort(dontPrintPrefixes);
        String mainUnitName = this.env.generateInclude ? String.valueOf(this.env.outputName) + "h.inc" : String.valueOf(this.env.outputName) + ".pas";
        String includeName = String.valueOf(this.env.outputName) + ".inc";
        PrintWriter includeFile = this.createFile(includeName);
        PrintWriter mainUnitFile = this.createFile(mainUnitName);
        PascalClassData.currentUnit = thisUnit = new PascalUnit(mainUnitFile, this.env, this.pkgList, includeName);
        System.out.println("Determining short Pascal class names...");
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            thisUnit.registerClassName((String)iter.next());
        }
        Iterator classStepper = classes.iterator();
        Iterator<String> argStepper = this.pkgList.iterator();
        Iterator skipPkgsStepper = dontPrintPrefixes.iterator();
        HashSet<String> classesToPrintList = new HashSet<String>();
        SimpleDirectedGraph<String, DefaultEdge> classDependencies = new SimpleDirectedGraph<String, DefaultEdge>(DefaultEdge.class);
        try {
            JavapPrinter printer;
            InputStream classin;
            String currentPrefix;
            String currentExcludePkg = skipPkgsStepper.hasNext() ? (String)skipPkgsStepper.next() : ".......";
            currentPrefix = argStepper.hasNext() ? (!(currentPrefix = argStepper.next()).equals(".") ? currentPrefix.replace('.', '/') : "./") : ".......";
            System.out.println("Indexing classes under " + currentPrefix + "...");
            do {
                String currentClass = (String)classStepper.next();
                while (argStepper.hasNext() && !PascalUnit.classOrPackageInPrefix(currentClass, currentPrefix) && currentClass.compareTo(currentPrefix) > 0) {
                    String currentArg = argStepper.next();
                    currentPrefix = !currentArg.equals(".") ? (currentArg = currentArg.replace('.', '/')) : (currentArg = "./");
                    System.out.println("Indexing classes under " + currentPrefix + "...");
                    currentPrefix = currentArg;
                }
                boolean doPrintClass = false;
                if (PascalUnit.classOrPackageInPrefix(currentClass, currentPrefix)) {
                    while (skipPkgsStepper.hasNext() && !PascalUnit.classOrPackageInPrefix(currentClass, currentExcludePkg) && currentClass.compareTo(currentExcludePkg) > 0) {
                        currentExcludePkg = (String)skipPkgsStepper.next();
                    }
                    if (!PascalUnit.classOrPackageInPrefix(currentClass, currentExcludePkg)) {
                        doPrintClass = true;
                    }
                }
                classin = this.env.getFileInputStream(currentClass);
                printer = new JavapPrinter(classin, includeFile, this.env, "  ", null, doPrintClass, true);
                if (!doPrintClass) continue;
                if (!classDependencies.containsVertex(currentClass)) {
                    classDependencies.addVertex(currentClass);
                }
                HashSet<String> dependencies = printer.cls.getDependencies();
                for (String dep : dependencies) {
                    thisUnit.registerUsedClass(dep);
                    if (!classDependencies.containsVertex(dep)) {
                        classDependencies.addVertex(dep);
                    }
                    classDependencies.addEdge(dep, currentClass);
                }
                classesToPrintList.add(currentClass);
            } while (classStepper.hasNext());
            classes = null;
            this.pkgList = null;
            System.out.println("Printing classes...");
            TopologicalOrderIterator printerStepper = new TopologicalOrderIterator(classDependencies);
            while (printerStepper.hasNext()) {
                String currentClass = (String)printerStepper.next();
                if (!classesToPrintList.remove(currentClass)) continue;
                try {
                    classin = this.env.getFileInputStream(currentClass);
                    printer = new JavapPrinter(classin, includeFile, this.env, "  ", null, true, false);
                    printer.print();
                }
                catch (IllegalArgumentException exc) {
                    this.error(exc.getMessage());
                    exc.printStackTrace();
                    System.out.println("Error while processing class " + currentClass + ", aborting...");
                    includeFile.close();
                    System.exit(1);
                }
            }
            if (!classesToPrintList.isEmpty()) {
                Iterator leftOvers = classesToPrintList.iterator();
                System.out.println("Classes part of dependency cycles, or related to these classes:");
                CycleDetector<String, DefaultEdge> cycles = new CycleDetector<String, DefaultEdge>(classDependencies);
                while (leftOvers.hasNext()) {
                    String currentClass = (String)leftOvers.next();
                    System.out.println("  " + currentClass + " is part of cycle " + cycles.findCyclesContainingVertex(currentClass));
                    try {
                        InputStream classin2 = this.env.getFileInputStream(currentClass);
                        JavapPrinter printer2 = new JavapPrinter(classin2, includeFile, this.env, "  ", null, true, false);
                        printer2.print();
                    }
                    catch (IllegalArgumentException exc) {
                        this.error(exc.getMessage());
                        exc.printStackTrace();
                        System.out.println("Error while processing class " + currentClass + ", aborting...");
                        includeFile.close();
                        System.exit(1);
                    }
                }
            }
        }
        finally {
            includeFile.close();
            thisUnit.printUnit();
            mainUnitFile.close();
        }
        System.out.println("Done!");
    }
}

