/*
 * Decompiled with CFR 0.152.
 */
package fpc.tools.javapp;

import fpc.tools.javapp.JavapEnvironment;
import fpc.tools.javapp.PascalClassData;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PascalUnit {
    private PrintWriter unitFile;
    private String[] pkgPrefixes;
    private String[] excludePrefixes;
    private String[] skelPrefixes;
    private String includeName;
    private HashSet<String> registeredExternalClasses;
    private HashSet<String> registeredInternalClasses;
    private SortedSet<SkelItem> registeredSkelObjs;
    private HashSet<String> registeredExternalInterfaces;
    private HashSet<String> registeredInternalInterfaces;
    private HashMap<String, String> classShortToLong;
    private HashMap<String, String> classLongToShort;
    private JavapEnvironment env;

    public PascalUnit(PrintWriter unitFile, JavapEnvironment env, ArrayList<String> pkgPrefixes, String includeName) {
        this.unitFile = unitFile;
        this.env = env;
        this.pkgPrefixes = new String[pkgPrefixes.size()];
        int i = 0;
        while (i < pkgPrefixes.size()) {
            this.pkgPrefixes[i] = pkgPrefixes.get(i).replace('.', '/');
            ++i;
        }
        this.excludePrefixes = new String[env.excludePrefixes.size()];
        i = 0;
        while (i < env.excludePrefixes.size()) {
            this.excludePrefixes[i] = env.excludePrefixes.get(i).replace('.', '/');
            ++i;
        }
        this.skelPrefixes = new String[env.skelPrefixes.size()];
        i = 0;
        while (i < env.skelPrefixes.size()) {
            this.skelPrefixes[i] = env.skelPrefixes.get(i).replace('.', '/');
            ++i;
        }
        this.includeName = includeName;
        this.registeredExternalClasses = new HashSet();
        this.registeredInternalClasses = new HashSet();
        this.registeredExternalInterfaces = new HashSet();
        this.registeredInternalInterfaces = new HashSet();
        this.registeredSkelObjs = new TreeSet<SkelItem>();
        this.classShortToLong = new HashMap();
        this.classLongToShort = new HashMap();
    }

    public void registerClassName(String fullName) {
        String newClassShortName = this.getDefaultShortPascalName(fullName);
        String prevVal = this.classShortToLong.put(newClassShortName, fullName);
        while (prevVal != null) {
            this.classShortToLong.remove(newClassShortName);
            newClassShortName = "";
            String oldClassShortName = "";
            StringTokenizer name1tok = new StringTokenizer(fullName.replace("$", "__").replace('-', '_'), "/.");
            StringTokenizer name2tok = new StringTokenizer(prevVal.replace("$", "__").replace('-', '_'), "/.");
            String name1elem = "";
            String name2elem = "";
            while (name1tok.hasMoreTokens()) {
                name1elem = name1tok.nextToken();
                name2elem = name2tok.nextToken();
                if (!name1tok.hasMoreTokens() || !name2tok.hasMoreTokens()) break;
                newClassShortName = String.valueOf(newClassShortName) + Character.toUpperCase(name1elem.charAt(0));
                oldClassShortName = String.valueOf(oldClassShortName) + Character.toUpperCase(name2elem.charAt(0));
                if (name1elem.equals(name2elem)) continue;
                int minlen = Math.min(name1elem.length(), name2elem.length());
                int i = 1;
                while (i < minlen) {
                    if (name1elem.charAt(i) != name2elem.charAt(i)) {
                        newClassShortName = String.valueOf(newClassShortName) + name1elem.charAt(i);
                        oldClassShortName = String.valueOf(oldClassShortName) + name2elem.charAt(i);
                    }
                    ++i;
                }
                i = minlen;
                while (i < name1elem.length()) {
                    newClassShortName = String.valueOf(newClassShortName) + name1elem.charAt(i);
                    ++i;
                }
                i = minlen;
                while (i < name2elem.length()) {
                    oldClassShortName = String.valueOf(oldClassShortName) + name2elem.charAt(i);
                    ++i;
                }
            }
            newClassShortName = String.valueOf(newClassShortName) + name1elem.replace('.', '_');
            oldClassShortName = String.valueOf(oldClassShortName) + name2elem.replace('.', '_');
            assert (!newClassShortName.equals(oldClassShortName));
            this.classLongToShort.put(prevVal, oldClassShortName);
            prevVal = this.classShortToLong.put(oldClassShortName, prevVal);
            assert (prevVal == null);
            prevVal = this.classShortToLong.put(newClassShortName, fullName);
        }
        this.classLongToShort.put(fullName, newClassShortName);
    }

    private String getDefaultShortPascalName(String classname) {
        String shortname = PascalClassData.getShortClassName(classname);
        if (classname.indexOf(36) != -1) {
            return "Inner" + shortname;
        }
        if (shortname.equals(classname)) {
            return shortname;
        }
        String pkgname = PascalClassData.getClassPackageName(classname);
        String prefix = Character.toString(Character.toUpperCase(classname.charAt(0)));
        int i = 1;
        while (i < pkgname.length()) {
            if (pkgname.charAt(i) == '.') {
                prefix = String.valueOf(prefix) + Character.toUpperCase(pkgname.charAt(i + 1));
            }
            ++i;
        }
        return String.valueOf(prefix) + shortname;
    }

    public boolean isExternalInnerClass(String className) {
        return this.registeredExternalClasses.contains(className) || this.registeredExternalInterfaces.contains(className);
    }

    public String getShortPascalName(String className) {
        if (PascalClassData.isInnerClass(className)) {
            int nestedIndex = className.indexOf(36);
            String res = this.getShortPascalName(className.substring(0, nestedIndex));
            if (this.isExternalInnerClass(className)) {
                res = String.valueOf(res) + className.substring(nestedIndex);
                res = res.replace('.', '_').replace("$", "__");
            } else {
                StringTokenizer innerTypes = new StringTokenizer(className.substring(nestedIndex + 1), "$");
                while (innerTypes.hasMoreTokens()) {
                    res = String.valueOf(res) + "." + "Inner" + innerTypes.nextToken();
                }
            }
            return res;
        }
        String res = this.classLongToShort.get((className = className.replace("$", "__")).replace('.', '/'));
        if (res == null) {
            res = this.getDefaultShortPascalName(className);
        }
        return res;
    }

    public void registerInnerClassAsExternalClass(String className) {
        if (!this.registeredExternalClasses.contains(className)) {
            this.registerClassName(className);
            this.registeredExternalClasses.add(className);
        }
    }

    public static boolean classOrPackageInPrefix(String currentName, String currentPrefix) {
        boolean res = currentName.startsWith(currentPrefix);
        char lastPrefixChar = currentPrefix.charAt(currentPrefix.length() - 1);
        if (lastPrefixChar != '.' && lastPrefixChar != '/') {
            res &= currentName.length() == currentPrefix.length() || currentName.length() > currentPrefix.length() && currentName.charAt(currentPrefix.length()) == '$';
        }
        return res;
    }

    public void registerUsedClass(String className) {
        className = className.replace('.', '/');
        boolean isLocal = false;
        boolean isSkel = false;
        int i = 0;
        while (i < this.skelPrefixes.length) {
            if (PascalUnit.classOrPackageInPrefix(className, this.skelPrefixes[i])) {
                isSkel = true;
                break;
            }
            ++i;
        }
        if (!isSkel) {
            if (PascalClassData.isInnerClass(className)) {
                return;
            }
            i = 0;
            while (i < this.pkgPrefixes.length) {
                if (PascalUnit.classOrPackageInPrefix(className, this.pkgPrefixes[i])) {
                    boolean excluded = false;
                    int j = 0;
                    while (j < this.excludePrefixes.length) {
                        if (PascalUnit.classOrPackageInPrefix(className, this.excludePrefixes[j])) {
                            excluded = true;
                            break;
                        }
                        ++j;
                    }
                    if (!excluded) {
                        isLocal = true;
                        break;
                    }
                }
                ++i;
            }
        }
        StringTokenizer classComponents = new StringTokenizer(className, "$");
        String completeName = "";
        if (isSkel) {
            do {
                completeName = String.valueOf(completeName) + classComponents.nextToken();
                SkelItem item = new SkelItem(completeName, "");
                PascalClassData classData = new PascalClassData(this.env.getFileInputStream(completeName), null, this.env, false);
                if (this.registeredSkelObjs.contains(item)) {
                    completeName = String.valueOf(completeName) + "$";
                    continue;
                }
                boolean isClass = classData.isClass();
                item.kind = isClass ? "class" : "interface";
                this.registeredSkelObjs.add(item);
                completeName = String.valueOf(completeName) + "$";
            } while (classComponents.hasMoreTokens());
        } else {
            HashSet<String> pickedSet = null;
            do {
                PascalClassData classData;
                completeName = String.valueOf(completeName) + classComponents.nextToken();
                if (isLocal) {
                    if (this.registeredInternalClasses.contains(completeName) || this.registeredInternalInterfaces.contains(completeName)) continue;
                    if (pickedSet == null) {
                        classData = new PascalClassData(this.env.getFileInputStream(completeName), null, this.env, false);
                        pickedSet = classData.isClass() ? this.registeredInternalClasses : this.registeredInternalInterfaces;
                    }
                } else {
                    if (this.registeredInternalClasses.contains(completeName) || this.registeredInternalInterfaces.contains(completeName)) continue;
                    if (pickedSet == null) {
                        classData = new PascalClassData(this.env.getFileInputStream(completeName), null, this.env, false);
                        pickedSet = classData.isClass() ? this.registeredExternalClasses : this.registeredExternalInterfaces;
                    }
                }
                pickedSet.add(completeName);
                completeName = String.valueOf(completeName) + "$";
            } while (classComponents.hasMoreTokens());
        }
    }

    public boolean parentIsKnownInterface(String className) {
        className = className.substring(0, className.lastIndexOf(36));
        return this.registeredInternalInterfaces.contains(className = className.replace('.', '/')) || this.registeredExternalInterfaces.contains(className);
    }

    public static void printArrayTypes(PrintWriter out, String prefix, String shortName, String shortSafeName) {
        out.println(String.valueOf(prefix) + "Arr1" + shortName + " = array of " + shortSafeName + ";");
        out.println(String.valueOf(prefix) + "Arr2" + shortName + " = array of Arr1" + shortName + ";");
        out.println(String.valueOf(prefix) + "Arr3" + shortName + " = array of Arr2" + shortName + ";");
    }

    private void printArrayTypes(String prefix, String shortname) {
        PascalUnit.printArrayTypes(this.unitFile, prefix, shortname, shortname);
    }

    private String RealPkgName(String name) {
        if (name.equals("./")) {
            return "<nameless package>";
        }
        return name.replace('/', '.');
    }

    private void printInternalObjs(Enumeration<String> iterator, String kind) {
        while (iterator.hasMoreElements()) {
            String curClass = iterator.nextElement();
            this.unitFile.println("  " + this.getShortPascalName(curClass) + " = " + kind + ";");
            this.printArrayTypes("  ", this.getShortPascalName(curClass));
            this.unitFile.println();
        }
    }

    private void printExternalObjs(Enumeration<String> iterator, String kind) {
        while (iterator.hasMoreElements()) {
            String curClass = iterator.nextElement();
            String shortPascalName = this.getShortPascalName(curClass);
            String shortExternalName = PascalClassData.getExternalClassName(curClass);
            String pkgExternalName = PascalClassData.getClassPackageName(curClass).replace('/', '.');
            this.unitFile.println("  " + shortPascalName + " = " + kind + " external '" + pkgExternalName + "' name '" + shortExternalName + "';");
            this.printArrayTypes("  ", shortPascalName);
            this.unitFile.println();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void printSkelObjs(Enumeration<SkelItem> iterator) {
        prefix = "  ";
        nestedClasses = new ArrayList<String>();
        curClass = " ";
        if (iterator.hasMoreElements()) ** GOTO lbl32
        return;
lbl-1000:
        // 1 sources

        {
            curSkelItem = iterator.nextElement();
            curClass = curSkelItem.className;
            shortExternalName = PascalClassData.getExternalClassName(curClass);
            pkgExternalName = PascalClassData.getClassPackageName(curClass).replace('/', '.');
            if (nestedClasses.size() > 0) {
                while (nestedClasses.size() > 0 && !curClass.startsWith((String)nestedClasses.get(nestedClasses.size() - 1))) {
                    finishingName = (String)nestedClasses.get(nestedClasses.size() - 1);
                    finishingName = finishingName.substring(0, finishingName.length() - 1);
                    finishingName = nestedClasses.size() > 1 ? PascalClassData.getShortClassName(finishingName) : PascalClassData.getShortPascalClassName(finishingName);
                    this.unitFile.println(String.valueOf(prefix) + "end;");
                    this.printArrayTypes(prefix, finishingName);
                    nestedClasses.remove(nestedClasses.size() - 1);
                    if (prefix.length() <= 4) continue;
                    prefix = prefix.substring(4);
                }
            }
            if (nestedClasses.size() > 0) {
                this.unitFile.println(String.valueOf(prefix) + "  type");
                prefix = String.valueOf(prefix) + "    ";
                shortPascalName = PascalClassData.getShortClassName(curClass);
            } else {
                shortPascalName = PascalClassData.getShortPascalClassName(curClass);
                this.unitFile.println();
            }
            this.unitFile.println(String.valueOf(prefix) + shortPascalName + " = " + curSkelItem.kind + " external '" + pkgExternalName + "' name '" + shortExternalName + "'");
            nestedClasses.add(String.valueOf(curClass) + "$");
lbl32:
            // 2 sources

            ** while (iterator.hasMoreElements())
        }
lbl33:
        // 3 sources

        while (nestedClasses.size() > 0) {
            finishingName = (String)nestedClasses.get(nestedClasses.size() - 1);
            finishingName = finishingName.substring(0, finishingName.length() - 1);
            finishingName = nestedClasses.size() > 1 ? PascalClassData.getShortClassName(finishingName) : PascalClassData.getShortPascalClassName(finishingName);
            this.unitFile.println(String.valueOf(prefix) + "end;");
            this.printArrayTypes(prefix, finishingName);
            nestedClasses.remove(nestedClasses.size() - 1);
            if (prefix.length() <= 4) continue;
            prefix = prefix.substring(4);
        }
    }

    public void printUnit() {
        this.unitFile.print("{ Imports for Java packages/classes: " + this.RealPkgName(this.pkgPrefixes[0]));
        int i = 1;
        while (i < this.pkgPrefixes.length) {
            this.unitFile.print(", " + this.RealPkgName(this.pkgPrefixes[i]));
            ++i;
        }
        this.unitFile.println(" }");
        if (!this.env.generateInclude) {
            this.unitFile.println("unit " + this.env.outputName + ";");
            this.unitFile.println("{$mode delphi}");
            this.unitFile.println();
            this.unitFile.println("interface");
            this.unitFile.println();
        }
        this.unitFile.println("type");
        Enumeration<String> strIterator = Collections.enumeration(this.registeredInternalClasses);
        this.printInternalObjs(strIterator, "class");
        strIterator = Collections.enumeration(this.registeredInternalInterfaces);
        this.printInternalObjs(strIterator, "interface");
        strIterator = Collections.enumeration(this.registeredExternalClasses);
        this.printExternalObjs(strIterator, "class");
        strIterator = Collections.enumeration(this.registeredExternalInterfaces);
        this.printExternalObjs(strIterator, "interface");
        Enumeration<SkelItem> skelIterator = Collections.enumeration(this.registeredSkelObjs);
        this.printSkelObjs(skelIterator);
        this.unitFile.println();
        if (!this.env.generateInclude) {
            this.unitFile.println("{$include " + this.includeName + "}");
            this.unitFile.println();
            this.unitFile.println("implementation");
            this.unitFile.println();
            this.unitFile.println("end.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SkelItem
    implements Comparable<SkelItem> {
        String className;
        String kind;

        public SkelItem(String className, String kind) {
            this.className = className;
            this.kind = kind;
        }

        @Override
        public int compareTo(SkelItem o) {
            return this.className.compareTo(o.className);
        }

        public String toString() {
            return this.className;
        }
    }
}

