/* arm64-darwin.macho-entry.h
   created from arm64-darwin.macho-entry.bin, 4261 (0x10a5) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2016 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2016 Laszlo Molnar
   Copyright (C) 2000-2016 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_ARM64_DARWIN_MACHO_ENTRY_SIZE    4261
#define STUB_ARM64_DARWIN_MACHO_ENTRY_ADLER32 0x23e0ad20
#define STUB_ARM64_DARWIN_MACHO_ENTRY_CRC32   0xf305c3e9

unsigned char stub_arm64_darwin_macho_entry[4261] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,183,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0, 80, 11,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0, 13,  0, 10,  0,
/* 0x0040 */ 255, 19,  0,209,224,  7,177,169,226, 15,  1,169,228, 23,  2,169,
/* 0x0050 */ 230, 31,  3,169,232, 39,  4,169,234, 47,  5,169,236, 55,  6,169,
/* 0x0060 */ 238, 63,  7,169,240, 71,  8,169,242, 79,  9,169,244, 87, 10,169,
/* 0x0070 */ 246, 95, 11,169,248,103, 12,169,250,111, 13,169,252,119, 14,169,
/* 0x0080 */   0,  0,  0,148,226,143,190,169,254, 11,  0,249,  7, 64, 33,139,
/* 0x0090 */   5,  0,128, 18,  4,  0,176, 82, 29,  0,  0, 20,227, 19,193,168,
/* 0x00a0 */   0,  0,  7,203, 66,  0,  3,203,130,  0,  0,185,228,  3,  0,170,
/* 0x00b0 */ 224,  3,  3,170,225,  3,  2,170,224,  7,191,169, 35,  0,128, 82,
/* 0x00c0 */   8,  0,176, 82,  0, 16, 32,212,224,  7,193,168,  3,  0,128, 82,
/* 0x00d0 */   8,  0,176, 82,  0, 16, 32,212,224,  3,  4,170,254,135, 64,248,
/* 0x00e0 */ 192,  3, 95,214,132,  0,  4, 43, 68,  0,  0, 52,192,  3, 95,214,
/* 0x00f0 */   4, 20, 64, 56,132,  0,  4, 58,132, 32,  9, 83,132,  0,  4, 43,
/* 0x0100 */ 192,  3, 95,214,  3, 20, 64, 56, 67, 20,  0, 56,246,255,255,151,
/* 0x0110 */ 162,255,255, 84, 33,  0,128, 82,  4,  0,  0, 20, 33,  4,  0, 81,
/* 0x0120 */ 241,255,255,151, 33,  0,  1, 26,239,255,255,151, 33,  0,  1, 26,
/* 0x0130 */ 237,255,255,151, 67,255,255, 84, 35, 12,  0,113,  1,  0,128, 82,
/* 0x0140 */  35,  1,  0, 84,  5, 20, 64, 56,165, 32,  3, 42,229,  3, 37, 42,
/* 0x0150 */ 101,250,255, 52,191,  0,  0,114,165,124,  1, 19,161,  1,  0, 84,
/* 0x0160 */   3,  0,  0, 20,224,255,255,151, 66,  1,  0, 84, 33,  0,128, 82,
/* 0x0170 */ 221,255,255,151,226,  0,  0, 84,219,255,255,151, 33,  0,  1, 26,
/* 0x0180 */ 217,255,255,151,163,255,255, 84, 33, 16,  0, 17,  4,  0,  0, 20,
/* 0x0190 */ 213,255,255,151, 33,  0,  1, 26, 33,  8,  0, 17,191,  0, 20, 49,
/* 0x01a0 */  33, 52,129, 26, 67,192, 33,139, 99,240, 95, 56, 67,200,101, 56,
/* 0x01b0 */  67, 20,  0, 56, 33,  4,  0,113,161,255,255, 84,212,255,255, 23,
/* 0x01c0 */ 226,143,190,169,254, 11,  0,249,  7, 64, 33,139,  5,  0,128, 18,
/* 0x01d0 */   4,  0,176, 82, 29,  0,  0, 20,227, 19,193,168,  0,  0,  7,203,
/* 0x01e0 */  66,  0,  3,203,130,  0,  0,185,228,  3,  0,170,224,  3,  3,170,
/* 0x01f0 */ 225,  3,  2,170,224,  7,191,169, 35,  0,128, 82,  8,  0,176, 82,
/* 0x0200 */   0, 16, 32,212,224,  7,193,168,  3,  0,128, 82,  8,  0,176, 82,
/* 0x0210 */   0, 16, 32,212,224,  3,  4,170,254,135, 64,248,192,  3, 95,214,
/* 0x0220 */ 132,  0,  4, 43, 68,  0,  0, 52,192,  3, 95,214,  4, 20, 64, 56,
/* 0x0230 */ 132,  0,  4, 58,132, 32,  9, 83,132,  0,  4, 43,192,  3, 95,214,
/* 0x0240 */   3, 20, 64, 56, 67, 20,  0, 56,246,255,255,151,162,255,255, 84,
/* 0x0250 */  33,  0,128, 82,  4,  0,  0, 20, 33,  4,  0, 81,241,255,255,151,
/* 0x0260 */  33,  0,  1, 58,239,255,255,151, 33,  0,  1, 58,237,255,255,151,
/* 0x0270 */  67,255,255, 84, 35, 12,  0,113,  1,  0,128, 82, 35,  1,  0, 84,
/* 0x0280 */   5, 20, 64, 56,165, 32,  3, 42,229,  3, 37, 42,101,250,255, 52,
/* 0x0290 */ 163,  0,  1, 83,165,124,  1, 83, 99,  0,  3, 43,  2,  0,  0, 20,
/* 0x02a0 */ 224,255,255,151, 33,  0,  1, 58,222,255,255,151, 33,  0,  1, 58,
/* 0x02b0 */ 225,  0,  0, 84, 33,  0,128, 82,218,255,255,151, 33,  0,  1, 58,
/* 0x02c0 */ 216,255,255,151,163,255,255, 84, 33,  8,  0, 17, 33,  4,  0, 17,
/* 0x02d0 */ 191,  0, 20, 49, 33, 52,129, 26, 67,  0, 64, 57, 67,200,101, 56,
/* 0x02e0 */  67, 20,  0, 56, 33,  4,  0,113,161,255,255, 84,215,255,255, 23,
/* 0x02f0 */   1, 64, 33,139,225, 11,190,169,227,123,  1,169,  5,  0,128, 18,
/* 0x0300 */   4,  0,176, 82, 37,  0,  0, 20,228, 11, 64,249,225,143,193,168,
/* 0x0310 */   0,  0,  1,203, 66,  0,  3,203,130,  0,  0,185,228,  3,  0,170,
/* 0x0320 */ 224,  3,  3,170,225,  3,  2,170,224,  7,191,169, 35,  0,128, 82,
/* 0x0330 */   8,  0,176, 82,  0, 16, 32,212,224,  7,193,168,  3,  0,128, 82,
/* 0x0340 */   8,  0,176, 82,  0, 16, 32,212,224,  3,  4,170,254,135, 64,248,
/* 0x0350 */ 192,  3, 95,214,132,  0,  4, 43, 68,  0,  0, 52,192,  3, 95,214,
/* 0x0360 */   4, 20, 64, 56,132,  0,  4, 26,132, 32,  9, 83,132,  0,  4, 43,
/* 0x0370 */ 192,  3, 95,214, 33,  0,128, 82,240,  3, 30,170,246,255,255,151,
/* 0x0380 */  33,  0,  1, 58,244,255,255,151,163,255,255, 84,  0,  2, 31,214,
/* 0x0390 */   3, 20, 64, 56, 67, 20,  0, 56,239,255,255,151,162,255,255, 84,
/* 0x03a0 */ 245,255,255,151, 35, 12,  0,113,  1,  0,128, 82,163,  0,  0, 84,
/* 0x03b0 */   5, 20, 64, 56,165, 32,  3, 42,229,  3, 37, 42,101,250,255, 52,
/* 0x03c0 */ 229,255,255,151, 33,  0,  1, 58,227,255,255,151, 33,  0,  1, 58,
/* 0x03d0 */  97,  0,  0, 84,232,255,255,151, 33,  8,  0, 17,191,  0, 52, 49,
/* 0x03e0 */  33, 36,129, 26, 67,200,101, 56, 33,  4,  0,113, 67, 20,  0, 56,
/* 0x03f0 */ 162,255,255, 84,233,255,255, 23,230,123,191,169,227,147,190,169,
/* 0x0400 */ 229, 11,  0,249,232,  3,  1,170, 45, 64, 34,139,233,  3,  4,170,
/* 0x0410 */ 142, 64, 37,139,235,  3,  0,170,  6, 21, 64, 56,160,  5,128, 82,
/* 0x0420 */ 196,  8,192, 26,  0,124,  4, 27,198,  0,  0, 75, 32,  1,128, 82,
/* 0x0430 */ 197,  8,192, 26,  0,124,  5, 27,198,  0,  0, 75,174,  0,  6, 11,
/* 0x0440 */   7,  0,128, 18,229, 32,197, 26,229,  3, 37, 42,228, 32,196, 26,
/* 0x0450 */ 228,  3, 36, 42, 35,  0,128, 82, 34,  0,128, 82, 33,  0,128, 82,
/* 0x0460 */  32,  0,128, 82,  6,  0,128, 82,230, 31,  0,185,  2, 96,128, 82,
/* 0x0470 */ 192,230,128, 82, 66, 32,206, 26, 66,  0,  0, 11,  0,128,128,210,
/* 0x0480 */ 225,  3, 11,170,  0, 64,  0,170,  0,128,  0,170, 32,132,  0,248,
/* 0x0490 */  66, 16,  0,113,204,255,255, 84,  0, 21,  0,145,231,  0,  0,148,
/* 0x04a0 */  31,  0,  8,235,193,255,255, 84,227, 67, 66,248,226, 19, 64,185,
/* 0x04b0 */  36,  1,  3,203,128,  0,  2, 10,224, 47,  0,185,  0, 16,  6, 11,
/* 0x04c0 */  97,  1,  0,145,225,  0,  0,148,129,  5,  0, 84,227, 23, 64,185,
/* 0x04d0 */ 226, 27, 64,185, 99,  0,  4, 10,224,115, 64, 57, 99, 32,194, 26,
/* 0x04e0 */ 226,  3,  2, 75, 66, 32,  0, 17,  2, 36,194, 26, 99,  0,  2, 11,
/* 0x04f0 */ 106,177, 57,145, 99,  4,  3, 11,227,  3,  3, 42, 32,  0,128, 82,
/* 0x0500 */  74, 37,  3,139,223, 28,  0,113,  3,  2,  0, 84,227,125, 64,147,
/* 0x0510 */ 227,  3,  3,203, 37,105, 99, 56,165,120, 31, 83, 65,  1,  8,145,
/* 0x0520 */ 164,  0, 24, 18,227,  3,  4, 42, 33,  4,  3,139,201,  0,  0,148,
/* 0x0530 */   3,  0,  0, 18,127, 32, 68,107,193,  0,  0, 84, 31,  0,  4,113,
/* 0x0540 */ 195,254,255, 84,  5,  0,  0, 20,225,  3, 10,170,193,  0,  0,148,
/* 0x0550 */  31,  0,  4,113,163,255,255, 84, 98,  0,128, 82,195,  0,128, 82,
/* 0x0560 */ 223, 40,  0,113, 67, 48,131, 26,223, 16,  0,113,195, 48,131, 26,
/* 0x0570 */ 198,  0,  3, 75, 34,  0,  0, 20, 97,  1,  6,145,178,  0,  0,148,
/* 0x0580 */ 129,  1,  0, 84,227, 11, 64,185,226,  7, 64,185,227, 15,  0,185,
/* 0x0590 */ 226, 11,  0,185,239,  7,  0,185,  3,  0,128, 82,223, 28,  0,113,
/* 0x05a0 */ 102,  0,128, 82,102, 48,134, 26,106,145, 25,145, 42,  0,  0, 20,
/* 0x05b0 */  97, 97,  6,145,164,  0,  0,148, 97,  2,  0, 84,227, 47, 64,185,
/* 0x05c0 */  97,129,  7,145, 96, 16,  6, 11,160,  0,  0,148,161,  3,  0, 84,
/* 0x05d0 */  35,  1,128, 82,223, 28,  0,113,102,  1,128, 82,102, 48,134, 26,
/* 0x05e0 */ 227, 67, 66,248, 36,  1,  3,203,159,  0, 15,107,131, 17,  0, 84,
/* 0x05f0 */ 227,125, 64,147,227,  3,  3,203, 32,105, 99, 56, 32, 21,  0, 56,
/* 0x0600 */ 121,  0,  0, 20, 97,193,  6,145,143,  0,  0,148,228,  7, 64,185,
/* 0x0610 */  64,  1,  0, 84, 97, 33,  7,145,139,  0,  0,148,228, 11, 64,185,
/* 0x0620 */ 128,  0,  0, 84,227, 11, 64,185,228, 15, 64,185,227, 15,  0,185,
/* 0x0630 */ 227,  7, 64,185,227, 11,  0,185,239,  7,  0,185,239,  3,  4, 42,
/* 0x0640 */   3,  1,128, 82,223, 28,  0,113,102,  1,128, 82,102, 48,134, 26,
/* 0x0650 */ 106,161, 41,145, 65,  1,  0,145,125,  0,  0,148,  1,  1,  0, 84,
/* 0x0660 */ 227, 47, 64,185, 69, 17,  0,145,227,  3,  3, 42,  2,  0,128, 82,
/* 0x0670 */ 165, 16,  3,139,  4,  1,128, 82, 14,  0,  0, 20, 65,  9,  0,145,
/* 0x0680 */ 115,  0,  0,148,  1,  1,  0, 84,227, 47, 64,185, 69, 17,  4,145,
/* 0x0690 */ 227,  3,  3, 42,  2,  1,128, 82,165, 16,  3,139,  4,  1,128, 82,
/* 0x06a0 */   4,  0,  0, 20, 69, 17,  8,145,  2,  2,128, 82,  4, 32,128, 82,
/* 0x06b0 */ 226, 55,  0,185, 32,  0,128, 82,225,  3,  5,170,101,  0,  0,148,
/* 0x06c0 */   3,  0,  4,107,163,255,255, 84,229, 55, 64,185,165,  0,  3, 11,
/* 0x06d0 */ 229, 55,  0,185,223, 16,  0,113,194,  6,  0, 84,198, 28,  0, 17,
/* 0x06e0 */  99,  0,128, 82,191, 16,  0,113,101, 32,133, 26,227,  3,  5, 42,
/* 0x06f0 */ 101, 29,  3,139,165,128, 13,145, 32,  0,128, 82,  4,  8,128, 82,
/* 0x0700 */ 225,  3,  5,170, 83,  0,  0,148,  3,  0,  4,107,163,255,255, 84,
/* 0x0710 */ 227, 47,  0,185,127, 16,  0,113, 99,  4,  0, 84,100,124,  1, 83,
/* 0x0720 */ 132,  4,  0, 81,111,  0,  0, 18,239,  1, 31, 50,127, 56,  0,113,
/* 0x0730 */ 226,  0,  0, 84,239, 33,196, 26,106,121, 21,145,227,  1,  3, 75,
/* 0x0740 */ 227,  3,  3, 42, 74,  5,  3,139, 12,  0,  0, 20,132, 16,  0, 81,
/* 0x0750 */  53,  0,  0,148,231,124,  1, 83,131,  1,  7,107,108, 32,140, 26,
/* 0x0760 */ 239,  1, 15, 26,132,  4,  0,113, 65,255,255, 84,106, 17, 25,145,
/* 0x0770 */ 239,109, 28, 83,132,  0,128, 82, 37,  0,128, 82, 32,  0,128, 82,
/* 0x0780 */ 225,  3, 10,170, 51,  0,  0,148, 31,  0,  0,114, 64,  0,  0, 84,
/* 0x0790 */ 239,  1,  5, 42,165,120, 31, 83,132,  4,  0,113, 33,255,255, 84,
/* 0x07a0 */   2,  0,  0, 20,239, 47, 64,185,239,  5,  0, 49,229, 55, 64,185,
/* 0x07b0 */ 227, 67, 66,248,165,  8,  0, 17, 35,  1,  3,203,255,  1,  3,107,
/* 0x07c0 */ 232,  2,  0, 84,227,125, 64,147,227,  3,  3,203, 32,105, 99, 56,
/* 0x07d0 */  32, 21,  0, 56, 63,  1, 14,235,194,  0,  0, 84,165,  4,  0,113,
/* 0x07e0 */  97,255,255, 84,224,115,  0, 57, 63,  1, 14,235,227,229,255, 84,
/* 0x07f0 */  13,  0,  0,148,  0,  0,128, 82,226, 19, 64,249,  3,  1,  2,203,
/* 0x0800 */ 226, 31, 64,249, 67,  0,  0,185,226, 67, 66,248, 35,  1,  2,203,
/* 0x0810 */ 226, 55, 64,249, 67,  0,  0,185,255,243,  0,145, 32,  0,128, 82,
/* 0x0820 */ 246,255,255, 23,227,124, 24, 83,195,  0,  0, 53, 31,  1, 13,235,
/* 0x0830 */ 231, 92, 24, 83, 66,255,255, 84,  3, 21, 64, 56,108, 32, 12, 42,
/* 0x0840 */ 192,  3, 95,214,224,  3,  6, 42, 33, 68, 32,139,  0,  0,128, 82,
/* 0x0850 */  33, 68, 32,139,227,124, 24, 83,241,  3, 30,170, 94,  0,  0, 16,
/* 0x0860 */  99,254,255, 52, 35,  0, 64,121,226,124, 11, 83, 98,124,  2, 27,
/* 0x0870 */ 159,  1,  2,107,  2,  1,  0, 84,  2,  0,129, 82,231,  3,  2, 42,
/* 0x0880 */  66,  0,  3, 75,  0,  0,  0, 58, 99, 20, 66, 11, 35,  0,  0,121,
/* 0x0890 */  32,  2, 95,214,140,  1,  2, 75,231,  0,  2, 75, 99, 20, 67, 75,
/* 0x08a0 */   0,  0,  0, 58, 35,  0,  0,121, 32,  2, 95,214,195,  3, 64,185,
/* 0x08b0 */ 193,  7, 64,185,194, 67, 33,139, 66, 48,  0,145,192, 67, 35,139,
/* 0x08c0 */   0,  0,  3,145,228,  3,  1, 42, 73,204, 95,184,132, 16,  0, 81,
/* 0x08d0 */   9,204, 31,184,164,255,255, 53,196, 11, 64,185,222,  3,  2,145,
/* 0x08e0 */ 227,143, 31,184,227,  3,  0,145,226,  3, 30,170,171, 32,  1,209,
/* 0x08f0 */ 234,  3, 30,170,160,  0, 63,214, 64,  1, 31,214,229,  3, 30,170,
/* 0x0900 */ 235,255,255,151,102,105,108,101, 32,102,111,114,109, 97,116, 32,
/* 0x0910 */ 101,108,102, 54, 52, 45,108,105,116,116,108,101, 97, 97,114, 99,
/* 0x0920 */ 104, 54, 52, 10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,
/* 0x0930 */ 100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x0940 */  32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32,
/* 0x0950 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65,
/* 0x0960 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 70,
/* 0x0970 */ 105,108,101, 32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,
/* 0x0980 */ 108, 97,103,115, 10, 32, 32, 48, 32, 77, 65, 67, 72, 77, 65, 73,
/* 0x0990 */  78, 88, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 52, 52, 32,
/* 0x09a0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x09b0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x09c0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52, 48, 32, 32, 50,
/* 0x09d0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x09e0 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x09f0 */  32, 49, 32, 78, 82, 86, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32,
/* 0x0a00 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x0a10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x0a20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x0a30 */  48, 48, 48, 48, 48, 56, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x0a40 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x0a50 */  89, 10, 32, 32, 50, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32,
/* 0x0a60 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 51, 99, 32, 32, 48, 48,
/* 0x0a70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x0a80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0a90 */  32, 32, 48, 48, 48, 48, 48, 48, 56, 52, 32, 32, 50, 42, 42, 48,
/* 0x0aa0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x0ab0 */  79, 78, 76, 89, 10, 32, 32, 51, 32, 78, 82, 86, 50, 68, 32, 32,
/* 0x0ac0 */  32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 51, 48, 32,
/* 0x0ad0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0ae0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0af0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 99, 48, 32, 32, 50,
/* 0x0b00 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x0b10 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32, 78, 82, 86, 50,
/* 0x0b20 */  66, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49,
/* 0x0b30 */  48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0b40 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0b50 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,102, 48,
/* 0x0b60 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x0b70 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 53, 32, 78,
/* 0x0b80 */  82, 86, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x0b90 */  48, 48, 52, 98, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0ba0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x0bb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x0bc0 */  51,102, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x0bd0 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,
/* 0x0be0 */  54, 32, 77, 65, 67, 72, 77, 65, 73, 78, 89, 32, 32, 32, 32, 32,
/* 0x0bf0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x0c00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x0c10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x0c20 */  48, 48, 48, 56, 97, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x0c30 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x0c40 */  10, 32, 32, 55, 32, 77, 65, 67, 72, 77, 65, 73, 78, 90, 32, 32,
/* 0x0c50 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 53, 56, 32, 32, 48, 48, 48,
/* 0x0c60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x0c70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0c80 */  32, 48, 48, 48, 48, 48, 56, 97, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x0c90 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x0ca0 */  78, 76, 89, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69,
/* 0x0cb0 */  58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0cc0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 65, 67, 72, 77,
/* 0x0cd0 */  65, 73, 78, 90,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0ce0 */  48, 48, 48, 48, 48, 32, 77, 65, 67, 72, 77, 65, 73, 78, 90, 10,
/* 0x0cf0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0d00 */  32,108, 32, 32, 32, 32,100, 32, 32, 77, 65, 67, 72, 77, 65, 73,
/* 0x0d10 */  78, 88,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0d20 */  48, 48, 48, 32, 77, 65, 67, 72, 77, 65, 73, 78, 88, 10, 48, 48,
/* 0x0d30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x0d40 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68,  9,
/* 0x0d50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0d60 */  32, 78, 82, 86, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x0d70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x0d80 */ 100, 32, 32, 78, 82, 86, 50, 69,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x0d90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 69, 10,
/* 0x0da0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0db0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68,  9, 48,
/* 0x0dc0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0dd0 */  78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0de0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x0df0 */  82, 86, 50, 66,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0e00 */  48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48,
/* 0x0e10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x0e20 */  32, 32,100, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76,  9, 48, 48,
/* 0x0e30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x0e40 */  82, 86, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0e50 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x0e60 */  32, 77, 65, 67, 72, 77, 65, 73, 78, 89,  9, 48, 48, 48, 48, 48,
/* 0x0e70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 65, 67, 72,
/* 0x0e80 */  77, 65, 73, 78, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0e90 */  48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 77,
/* 0x0ea0 */  65, 67, 72, 77, 65, 73, 78, 88,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x0eb0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 95,115,116, 97,114,116,
/* 0x0ec0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0ed0 */  48, 32,103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 69,  9,
/* 0x0ee0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 51, 99,
/* 0x0ef0 */  32,117, 99,108, 95,110,114,118, 50,101, 95,100,101, 99,111,109,
/* 0x0f00 */ 112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0f10 */  48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70,
/* 0x0f20 */  32, 78, 82, 86, 50, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0f30 */  48, 48, 48, 48, 49, 51, 48, 32,117, 99,108, 95,110,114,118, 50,
/* 0x0f40 */ 100, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48,
/* 0x0f50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x0f60 */ 103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 66,  9, 48, 48,
/* 0x0f70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 48, 56, 32,117,
/* 0x0f80 */  99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,112,114,
/* 0x0f90 */ 101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0fa0 */  48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x0fb0 */  82, 86, 95, 84, 65, 73, 76,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0fc0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 76,122,109, 97, 68,101, 99,
/* 0x0fd0 */ 111,100,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x0fe0 */  48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 77, 65, 67,
/* 0x0ff0 */  72, 77, 65, 73, 78, 89,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1000 */  48, 48, 48, 48, 48, 48, 48, 32,101,110,100, 95,100,101, 99,111,
/* 0x1010 */ 109,112,114,101,115,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x1020 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x1030 */  77, 65, 67, 72, 77, 65, 73, 78, 88, 93, 58, 10, 79, 70, 70, 83,
/* 0x1040 */  69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80,
/* 0x1050 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x1060 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1070 */  48, 48, 48, 52, 48, 32, 82, 95, 65, 65, 82, 67, 72, 54, 52, 95,
/* 0x1080 */  67, 65, 76, 76, 50, 54, 32, 32, 77, 65, 67, 72, 77, 65, 73, 78,
/* 0x1090 */  90, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x10a0 */  48, 48, 53, 48, 10
};
