/* i086-dos16.exe.h
   created from i086-dos16.exe.bin, 30372 (0x76a4) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2016 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2016 Laszlo Molnar
   Copyright (C) 2000-2016 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_I086_DOS16_EXE_SIZE    30372
#define STUB_I086_DOS16_EXE_ADLER32 0x29ab064d
#define STUB_I086_DOS16_EXE_CRC32   0xb03687f8

unsigned char stub_i086_dos16_exe[30372] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */  12, 44,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */ 142,  0,139,  0,255,255,255,255,  0,  0, 12,  0,  0,  0,  0,  0,
/* 0x0040 */  14, 46,255, 54, 10,  0, 80, 83, 81, 82,140,200,  5,  0,  0,187,
/* 0x0050 */   0,  0,140,209,137,226,142,208,137,220, 81, 82, 86, 87, 85, 30,
/* 0x0060 */   6, 45, 16,  0,142,216,114,249,156, 22,  7,187,  0,128, 49,201,
/* 0x0070 */ 190,  0,  1,191, 16,  0,189,255,255,168,164,232, 12,  0,114,250,
/* 0x0080 */  65,232,  7,  0,227, 22,227, 21,115,  6,131,233,  3,114,  6,136,
/* 0x0090 */ 204,172,247,208,149, 49,201,232,  7,  0, 17,201,117,  8, 65,232,
/* 0x00a0 */   7,  0,115,251, 65, 65, 65,129,253,  0,243,131,209,  1,141,  3,
/* 0x00b0 */ 150, 38,243,164,150,235,  0,232,  2,  0, 17,201,  1,219,117,  4,
/* 0x00c0 */ 173, 17,192,147,195, 94,185,  0,  0,172, 44,232, 60,  1,119,249,
/* 0x00d0 */ 193,  4,  8, 41, 52,139, 28,134,223, 41,243,137, 28,173,226,  3,
/* 0x00e0 */ 176,232,176,233, 95,185,  0,  0,242,174,117, 21,117,  2,193,  5,
/* 0x00f0 */   8, 41, 61,139, 29,134,223, 41,251,137, 29,175,235,  3,185,  0,
/* 0x0100 */   0,190,  0,  0,137,247, 30,169,181,128,140,200,  5,  0,  0,142,
/* 0x0110 */ 216,  5,  0,  0,142,192,253,243,165,252, 46,128,172, 18,  0, 16,
/* 0x0120 */  46,128,108, 18, 16,115,  9,146,175,173, 14, 14, 14,  6, 31,  7,
/* 0x0130 */  22,189,  0,  0,187,  0,  0, 85,203, 85, 80, 88, 33,161,216,208,
/* 0x0140 */ 213,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0150 */   0,  0,  0, 45,164,  0,255,117,  3,232, 17,  0,114,246, 65,140,
/* 0x0160 */ 192,  1,255,115,  5,128,196,  8,142,192,209,239,232,  4,  0,227,
/* 0x0170 */   3,115,249, 73, 73,116,  8,  1,201,  1,201,  1,201,  1,201,193,
/* 0x0180 */ 225,  4,137,205,138, 28, 70,246,211, 49,201,232,  4,  0, 17,201,
/* 0x0190 */ 117,  8, 65,232,  4,  0,115,251, 65, 65,129,253,209,  0,131,217,
/* 0x01a0 */ 254, 41,232,114, 14,142,216,141,  1, 40,252,150,243,164,150,142,
/* 0x01b0 */ 218,235,  0,209,224,209,224,209,224,209,224, 80, 49,192,142,216,
/* 0x01c0 */  88,193,224,  4,106,  0, 31,  1,216,  1,248,235, 38,  0,255,117,
/* 0x01d0 */   3,232,  6,  0, 17,201,  0,255,117,  2,138, 60, 17,246,115,  5,
/* 0x01e0 */ 128,198,  8,142,218,209,238, 70, 16,255,195,164,  0,255,117,  3,
/* 0x01f0 */ 232, 17,  0,114,246, 65,140,192,  1,255,115,  5,128,196,  8,142,
/* 0x0200 */ 192,209,239,232,  4,  0,114, 10, 73,232, 13,  0, 17,201,121,243,
/* 0x0210 */ 235,  3, 73, 73,116, 12,  1,201,  1,201,  1,201,193,225,  3,137,
/* 0x0220 */ 205,138, 28, 70,246,211, 49,201,208,235,235,  3,232, 13,  0, 17,
/* 0x0230 */ 201,232, 13,  0, 17,201,117,  8, 65,232,  4,  0,115,251, 65, 65,
/* 0x0240 */ 131,253, 81,131,217,254, 41,232,114, 14,142,216,141,  1, 40,252,
/* 0x0250 */ 150,243,164,150,142,218,235,  0,209,224,209,224,209,224,209,224,
/* 0x0260 */  80, 49,192,142,216, 88,193,224,  4,106,  0, 31,  1,216,  1,248,
/* 0x0270 */ 235, 46,  0,255,117,  3,232,  6,  0, 17,201,  0,255,117,  2,138,
/* 0x0280 */  60, 17,246,115,  5,128,198,  8,142,218,209,238, 70, 16,255,195,
/* 0x0290 */ 164,  0,255,117,  3,232, 17,  0,114,246, 65,140,192,  1,255,115,
/* 0x02a0 */   5,128,196,  8,142,192,209,239,232,  4,  0,114, 10, 73,232, 13,
/* 0x02b0 */   0, 17,201,121,243,235,  3, 73, 73,116, 19,  1,201,  1,201,  1,
/* 0x02c0 */ 201,193,225,  3,137,205,138, 28, 70,246,211, 49,201,208,235,115,
/* 0x02d0 */  12,232, 13,  0, 17,201,235, 18,232, 13,  0,114,244, 65,232, 13,
/* 0x02e0 */   0,114,238,232,  4,  0,115,251, 65, 65,131,253, 81,131,217,253,
/* 0x02f0 */  41,232,114, 14,142,216,141,  1, 40,252,150,243,164,150,142,218,
/* 0x0300 */ 235,  0,209,224,209,224,209,224,209,224, 80, 49,192,142,216, 88,
/* 0x0310 */ 193,224,  4,106,  0, 31,  1,216,  1,248,235, 51,  0,255,117,  3,
/* 0x0320 */ 232,  6,  0, 17,201,  0,255,117,  2,138, 60, 17,246,115,  5,128,
/* 0x0330 */ 198,  8,142,218,209,238, 70, 16,255,195,137,229,141,158,  0,  0,
/* 0x0340 */ 137,220, 70, 70, 83,184,  0,  0, 80,184,  0,  0, 80,  6, 87,131,
/* 0x0350 */ 195,  4, 83,184,  0,  0, 80,184,  0,  0, 80, 30, 86,131,195,  4,
/* 0x0360 */  83, 30, 22, 31,199,  7,  0,  0,198, 71,  2,  0,  0,  0,  0,  0,
/* 0x0370 */   0,  0,  0,  0, 86, 87, 85,137,229,131,236,102,139,118,  8,141,
/* 0x0380 */  92,  4,137, 94,222, 49,192,137, 70,236,137, 70,238,198, 70,254,
/* 0x0390 */   0,138, 76,  2,184,  1,  0,211,224, 72,137, 70,168,138, 76,  1,
/* 0x03a0 */ 184,  1,  0,211,224, 72,153,137, 70,170,137, 86,172, 49,192,137,
/* 0x03b0 */  70,240,137, 70,156,137, 70,206,137, 70,202,137, 70,182,139, 94,
/* 0x03c0 */  18,137,  7,137, 71,  2,139, 94, 28,137,  7,137, 71,  2, 64,137,
/* 0x03d0 */  70,154,137, 70,204,137, 70,200,137, 70,188,138,  4,137, 70,178,
/* 0x03e0 */ 138, 84,  1, 48,246,137,193,  1,209,184,  0,  3, 48,210,227,  6,
/* 0x03f0 */ 209,224,209,210,226,250,137,198,129,198, 54,  7,137,209,131,209,
/* 0x0400 */   0, 49,210, 49,192, 57,200,114,  6,117, 23, 57,242,115, 19,137,
/* 0x0410 */ 211,209,227,  3, 94,222,199,  7,  0,  4,131,194,  1,131,208,  0,
/* 0x0420 */ 235,227,139, 94, 10,137, 94,244,139, 70, 12,137, 70,246,137,216,
/* 0x0430 */ 139, 86, 12,139, 94, 14,139, 78, 16,  1,216,131,209,  0,136,203,
/* 0x0440 */ 177,  4,210,227,  0,222,137, 70,226,137, 86,228, 49,192,137, 70,
/* 0x0450 */ 250,137, 70,252,190,255,255,137,247,137, 70,184,235, 64,196, 94,
/* 0x0460 */ 244, 38,138,  7,136, 70,166,198, 70,167,  0,139, 70,250,139, 86,
/* 0x0470 */ 252,136,214,136,226,136,196, 48,192,139, 94,166,  9,195,137, 94,
/* 0x0480 */ 250,137, 86,252,139, 70,244,140,194, 64,117,  3,128,198, 16,137,
/* 0x0490 */  70,244,137, 86,246,255, 70,184,131,126,184,  5,125, 26,139, 70,
/* 0x04a0 */ 244,139, 86,246,139, 94,226,139, 78,228, 57,216,117,176, 57,202,
/* 0x04b0 */ 117,172,184,  1,  0,233, 82, 16,139, 70,238, 59, 70, 26,114, 13,
/* 0x04c0 */ 116,  3,233, 69, 16,139, 70,236, 59, 70, 24,115,245,139, 70,236,
/* 0x04d0 */  35, 70,168,137, 70,198,177,  5,139, 86,240,211,226,  3, 86,222,
/* 0x04e0 */ 209,224,  1,194,137, 86,242,129,255,  0,  1,115, 91,139, 70,244,
/* 0x04f0 */ 139, 86,246,139, 94,226,139, 78,228, 57,202,117,  2, 57,216,116,
/* 0x0500 */ 177,137,251,137,241,136,223,136,235,136,205, 48,201,137,223,137,
/* 0x0510 */ 206,196, 94,244, 38,138,  7,136, 70,166,198, 70,167,  0,139, 70,
/* 0x0520 */ 250,139, 86,252,136,214,136,226,136,196, 48,192,139, 94,166,  9,
/* 0x0530 */ 195,137, 94,250,137, 86,252,139, 70,244,140,194, 64,117,  3,128,
/* 0x0540 */ 198, 16,137, 70,244,137, 86,246,137,250,137,240,177, 11,137,211,
/* 0x0550 */ 211,232,211,234,177,  5,211,227,  9,216,137, 86,160,137, 70,158,
/* 0x0560 */ 139, 94,242,139, 31,137,193,137,208,247,227,145,247,227,  1,202,
/* 0x0570 */ 137, 70,248,137, 86,162,139, 70,252, 57,208,114, 13,116,  3,233,
/* 0x0580 */   6,  3,139, 70,250, 59, 70,248,115,245,199, 70,230,  1,  0,139,
/* 0x0590 */ 118,248,137,215,184,  0,  8,139, 94,242, 43,  7,177,  5,211,232,
/* 0x05a0 */   1,  7,185,  8,  0, 43, 78,178,138, 70,254, 48,228,211,248,153,
/* 0x05b0 */ 137, 70,166,137,211,139, 70,236, 35, 70,170,139, 86,238, 35, 86,
/* 0x05c0 */ 172,139, 78,178,227,  6,209,224,209,210,226,250,  3, 70,166, 17,
/* 0x05d0 */ 218,209,224,209,210,137,209,137,195,209,224,209,210,  1,216, 17,
/* 0x05e0 */ 202,136,214,136,226,136,196, 48,192,139, 86,222,129,194,108, 14,
/* 0x05f0 */   1,194,137, 86,242,131,126,240,  7,125,  3,233, 64,  1,139, 94,
/* 0x0600 */ 236, 43, 94,154,139, 78,238, 27, 78,156,139, 70, 20,139, 86, 22,
/* 0x0610 */   1,216,131,209,  0,136,203,177,  4,210,227,  0,222,137,195,142,
/* 0x0620 */ 194, 38,138,  7, 48,228,137, 70,180,209,102,180,139, 70,180, 48,
/* 0x0630 */ 192,128,228,  1,137, 70,190,209,224,139, 86,242,128,198,  2,  1,
/* 0x0640 */ 194,139, 70,230,209,224,  1,194,137, 86,210,129,255,  0,  1,115,
/* 0x0650 */  94,139, 70,244,139, 86,246,139, 94,226,139, 78,228, 57,216,117,
/* 0x0660 */   7, 57,202,117,  3,233, 74,254,137,251,137,241,136,223,136,235,
/* 0x0670 */ 136,205, 48,201,137,223,137,206,196, 94,244, 38,138,  7,136, 70,
/* 0x0680 */ 166,198, 70,167,  0,139, 70,250,139, 86,252,136,214,136,226,136,
/* 0x0690 */ 196, 48,192,139, 94,166,  9,195,137, 94,250,137, 86,252,139, 70,
/* 0x06a0 */ 244,140,194, 64,117,  3,128,198, 16,137, 70,244,137, 86,246,137,
/* 0x06b0 */ 250,137,240,177, 11,137,211,211,232,211,234,177,  5,211,227,  9,
/* 0x06c0 */ 216,137, 86,160,137, 70,158,139, 94,210,139, 31,137,193,137,208,
/* 0x06d0 */ 247,227,145,247,227,  1,202,137, 70,248,137, 86,162,139, 70,252,
/* 0x06e0 */  57,208,114, 10,117, 38,139, 70,250, 59, 70,248,115, 30,139,118,
/* 0x06f0 */ 248,137,215,184,  0,  8,139, 94,210, 43,  7,177,  5,211,232,  1,
/* 0x0700 */   7,209,102,230,131,126,190,  0,117, 52,235, 40, 43,118,248, 25,
/* 0x0710 */ 215,139, 70,248, 41, 70,250, 25, 86,252,177,  5,139, 94,210,139,
/* 0x0720 */   7,211,232, 41,  7,139, 70,230,  1,192, 64,137, 70,230,131,126,
/* 0x0730 */ 190,  0,116, 10,129,126,230,  0,  1,125,  3,233,235,254,139, 70,
/* 0x0740 */ 230, 61,  0,  1,124,  3,233,235,  0,209,224,139, 94,242,  1,195,
/* 0x0750 */ 137, 94,216,129,255,  0,  1,115, 94,139, 70,244,139, 86,246,139,
/* 0x0760 */  94,226,139, 78,228, 57,216,117,  7, 57,202,117,  3,233, 66,253,
/* 0x0770 */ 137,251,137,241,136,223,136,235,136,205, 48,201,137,223,137,206,
/* 0x0780 */ 196, 94,244, 38,138,  7,136, 70,166,198, 70,167,  0,139, 70,250,
/* 0x0790 */ 139, 86,252,136,214,136,226,136,196, 48,192,139, 94,166,  9,195,
/* 0x07a0 */ 137, 94,250,137, 86,252,139, 70,244,140,194, 64,117,  3,128,198,
/* 0x07b0 */  16,137, 70,244,137, 86,246,137,250,137,240,177, 11,137,211,211,
/* 0x07c0 */ 232,211,234,177,  5,211,227,  9,216,137, 86,160,137, 70,158,139,
/* 0x07d0 */  94,216,139, 31,137,193,137,208,247,227,145,247,227,  1,202,137,
/* 0x07e0 */  70,248,137, 86,162,139, 70,252, 57,208,114, 10,117, 33,139, 70,
/* 0x07f0 */ 250, 59, 70,248,115, 25,139,118,248,137,215,184,  0,  8,139, 94,
/* 0x0800 */ 216, 43,  7,177,  5,211,232,  1,  7,209,102,230,233, 47,255, 43,
/* 0x0810 */ 118,248, 25,215,139, 70,248, 41, 70,250, 25, 86,252,177,  5,139,
/* 0x0820 */  94,216,139,  7,211,232, 41,  7,139, 70,230,  1,192, 64,137, 70,
/* 0x0830 */ 230,233, 10,255,138, 70,230,136, 70,254,139, 94,236,139, 78,238,
/* 0x0840 */ 131, 70,236,  1,131, 86,238,  0,139, 70, 20,139, 86, 22,  1,216,
/* 0x0850 */ 131,209,  0,136,203,177,  4,210,227,  0,222,137,195,142,194,138,
/* 0x0860 */  70,230, 38,136,  7,139, 70,240,131,248,  4,125,  8, 49,192,137,
/* 0x0870 */  70,240,233, 67,252,131,248, 10,125,  7,131,110,240,  3,233, 55,
/* 0x0880 */ 252,131,110,240,  6,233, 48,252, 43,118,248, 25,215,139, 70,248,
/* 0x0890 */  41, 70,250, 25, 86,252,177,  5,139, 94,242,139,  7,211,232, 41,
/* 0x08a0 */   7,139, 70,240,209,224,139, 86,222,129,194,128,  1,  1,194,137,
/* 0x08b0 */  86,242,129,255,  0,  1,115, 94,139, 70,244,139, 86,246,139, 94,
/* 0x08c0 */ 226,139, 78,228, 57,216,117,  7, 57,202,117,  3,233,227,251,137,
/* 0x08d0 */ 251,137,241,136,223,136,235,136,205, 48,201,137,223,137,206,196,
/* 0x08e0 */  94,244, 38,138,  7,136, 70,166,198, 70,167,  0,139, 70,250,139,
/* 0x08f0 */  86,252,136,214,136,226,136,196, 48,192,139, 94,166,  9,195,137,
/* 0x0900 */  94,250,137, 86,252,139, 70,244,140,194, 64,117,  3,128,198, 16,
/* 0x0910 */ 137, 70,244,137, 86,246,137,250,137,240,177, 11,137,211,211,232,
/* 0x0920 */ 211,234,177,  5,211,227,  9,216,137, 86,160,137, 70,158,139, 94,
/* 0x0930 */ 242,139, 31,137,193,137,208,247,227,145,247,227,  1,202,137, 70,
/* 0x0940 */ 248,137, 86,162,139, 70,252, 57,208,114, 10,117, 89,139, 70,250,
/* 0x0950 */  59, 70,248,115, 81,139,118,248,137,215,184,  0,  8,139, 94,242,
/* 0x0960 */  43,  7,177,  5,211,232,  1,  7,139, 70,200,137, 70,188,139, 70,
/* 0x0970 */ 202,137, 70,182,139, 70,204,137, 70,200,139, 70,206,137, 70,202,
/* 0x0980 */ 139, 70,154,137, 70,204,139, 70,156,137, 70,206,131,126,240,  7,
/* 0x0990 */ 125,  4, 49,192,235,  3,184,  3,  0,137, 70,240,139, 94,222,129,
/* 0x09a0 */ 195,100,  6,233,131,  4, 43,118,248, 25,215,139, 70,248, 41, 70,
/* 0x09b0 */ 250, 25, 86,252,177,  5,139, 94,242,139,  7,211,232, 41,  7,139,
/* 0x09c0 */  86,240,209,226,139, 70,222,  5,152,  1,  1,208,137, 70,242,129,
/* 0x09d0 */ 255,  0,  1,115, 94,139, 70,244,139, 86,246,139, 94,226,139, 78,
/* 0x09e0 */ 228, 57,216,117,  7, 57,202,117,  3,233,198,250,137,251,137,241,
/* 0x09f0 */ 136,223,136,235,136,205, 48,201,137,223,137,206,196, 94,244, 38,
/* 0x0a00 */ 138,  7,136, 70,166,198, 70,167,  0,139, 70,250,139, 86,252,136,
/* 0x0a10 */ 214,136,226,136,196, 48,192,139, 94,166,  9,195,137, 94,250,137,
/* 0x0a20 */  86,252,139, 70,244,140,194, 64,117,  3,128,198, 16,137, 70,244,
/* 0x0a30 */ 137, 86,246,137,250,137,240,177, 11,137,211,211,232,211,234,177,
/* 0x0a40 */   5,211,227,  9,216,137, 86,160,137, 70,158,139, 94,242,139, 31,
/* 0x0a50 */ 137,193,137,208,247,227,145,247,227,  1,202,137, 70,248,137, 86,
/* 0x0a60 */ 162,139, 70,244,139, 86,246, 64,117,  3,128,198, 16,137, 70,174,
/* 0x0a70 */ 137, 86,176,139, 70,252, 59, 70,162,114, 13,116,  3,233,121,  1,
/* 0x0a80 */ 139, 70,250, 59, 70,248,115,245,139,118,248,139,126,162,184,  0,
/* 0x0a90 */   8,139, 94,242, 43,  7,177,  5,211,232,  1,  7,139, 70,240,211,
/* 0x0aa0 */ 224,139, 86,222,129,194,224,  1,  1,194,139, 70,198,209,224,  1,
/* 0x0ab0 */ 194,137, 86,242,129,255,  0,  1,115, 89,139, 70,244,139, 86,246,
/* 0x0ac0 */ 139, 94,226,139, 78,228, 57,216,117,  7, 57,202,117,  3,233,225,
/* 0x0ad0 */ 249,137,240,137,251,136,223,136,227,136,196, 48,192,137,223,137,
/* 0x0ae0 */ 198,196, 94,244, 38,138,  7,136, 70,166,198, 70,167,  0,139, 70,
/* 0x0af0 */ 250,139, 86,252,136,214,136,226,136,196, 48,192,139, 94,166,  9,
/* 0x0b00 */ 195,137, 94,250,137, 86,252,139, 94,174,137, 94,244,139, 70,176,
/* 0x0b10 */ 137, 70,246,137,250,137,240,177, 11,137,211,211,232,211,234,177,
/* 0x0b20 */   5,211,227,  9,216,137, 86,160,137, 70,158,139, 94,242,139, 31,
/* 0x0b30 */ 137,193,137,208,247,227,145,247,227,  1,202,137, 70,248,137, 86,
/* 0x0b40 */ 162,139, 70,252, 57,208,114, 13,117, 52,139, 70,250, 59, 70,248,
/* 0x0b50 */ 114,  3,233,136,  0,139,118,248,137,215,184,  0,  8,139, 94,242,
/* 0x0b60 */  43,  7,177,  5,211,232,  1,  7,139, 70,238, 11, 70,236,117,  3,
/* 0x0b70 */ 233, 63,249,131,126,240,  7,125,  7,184,  9,  0,235,  5,235, 93,
/* 0x0b80 */ 184, 11,  0,137, 70,240,139, 94,236, 43, 94,154,139, 78,238, 27,
/* 0x0b90 */  78,156,139, 70, 20,139, 86, 22,  1,216,131,209,  0,136,203,177,
/* 0x0ba0 */   4,210,227,  0,222,137,195,142,194, 38,138,  7,136, 70,254,139,
/* 0x0bb0 */  94,236,139, 78,238,131, 70,236,  1,131, 86,238,  0,139, 70, 20,
/* 0x0bc0 */ 139, 86, 22,  1,216,131,209,  0,136,203,177,  4,210,227,  0,222,
/* 0x0bd0 */ 137,195,142,194,138, 70,254, 38,136,  7,233,219,248, 43,118,248,
/* 0x0be0 */  25,215,139, 70,248, 41, 70,250, 25, 86,252,177,  5,139, 94,242,
/* 0x0bf0 */ 139,  7,211,232, 41,  7,233, 24,  2, 43,118,248, 27,126,162,139,
/* 0x0c00 */  70,248, 41, 70,250,139, 70,162, 25, 70,252,177,  5,139, 94,242,
/* 0x0c10 */ 139,  7,211,232, 41,  7,139, 70,240,209,224,139, 86,222,129,194,
/* 0x0c20 */ 176,  1,  1,194,137, 86,242,129,255,  0,  1,115, 89,139, 70,244,
/* 0x0c30 */ 139, 86,246,139, 94,226,139, 78,228, 57,216,117,  7, 57,202,117,
/* 0x0c40 */   3,233,110,248,137,251,137,241,136,223,136,235,136,205, 48,201,
/* 0x0c50 */ 137,223,137,206,196, 94,244, 38,138,  7,136, 70,166,198, 70,167,
/* 0x0c60 */   0,139, 70,250,139, 86,252,136,214,136,226,136,196, 48,192,139,
/* 0x0c70 */  94,166,  9,195,137, 94,250,137, 86,252,139, 94,174,137, 94,244,
/* 0x0c80 */ 139, 70,176,137, 70,246,137,250,137,240,177, 11,137,211,211,232,
/* 0x0c90 */ 211,234,177,  5,211,227,  9,216,137, 86,160,137, 70,158,139, 94,
/* 0x0ca0 */ 242,139, 31,137,193,137,208,247,227,145,247,227,  1,202,137, 70,
/* 0x0cb0 */ 248,137, 86,162,139, 70,252, 57,208,114, 10,117, 36,139, 70,250,
/* 0x0cc0 */  59, 70,248,115, 28,139,118,248,137,215,184,  0,  8,139, 94,242,
/* 0x0cd0 */  43,  7,177,  5,211,232,  1,  7,139, 70,204,139, 78,206,233, 30,
/* 0x0ce0 */   1, 43,118,248, 25,215,139, 70,248, 41, 70,250, 25, 86,252,177,
/* 0x0cf0 */   5,139, 94,242,139,  7,211,232, 41,  7,139, 86,240,209,226,139,
/* 0x0d00 */  70,222,  5,200,  1,  1,208,137, 70,242,129,255,  0,  1,115, 94,
/* 0x0d10 */ 139, 70,244,139, 86,246,139, 94,226,139, 78,228, 57,216,117,  7,
/* 0x0d20 */  57,202,117,  3,233,139,247,137,251,137,241,136,223,136,235,136,
/* 0x0d30 */ 205, 48,201,137,223,137,206,196, 94,244, 38,138,  7,136, 70,166,
/* 0x0d40 */ 198, 70,167,  0,139, 70,250,139, 86,252,136,214,136,226,136,196,
/* 0x0d50 */  48,192,139, 94,166,  9,195,137, 94,250,137, 86,252,139, 70,244,
/* 0x0d60 */ 140,194, 64,117,  3,128,198, 16,137, 70,244,137, 86,246,137,250,
/* 0x0d70 */ 137,240,177, 11,137,211,211,232,211,234,177,  5,211,227,  9,216,
/* 0x0d80 */ 137, 86,160,137, 70,158,139, 94,242,139, 31,137,193,137,208,247,
/* 0x0d90 */ 227,145,247,227,  1,202,137, 70,248,137, 86,162,139, 70,252, 57,
/* 0x0da0 */ 208,114, 10,117, 35,139, 70,250, 59, 70,248,115, 27,139,118,248,
/* 0x0db0 */ 137,215,184,  0,  8,139, 94,242, 43,  7,177,  5,211,232,  1,  7,
/* 0x0dc0 */ 139, 70,200,139, 78,202,235, 43, 43,118,248, 25,215,139, 70,248,
/* 0x0dd0 */  41, 70,250, 25, 86,252,177,  5,139, 94,242,139,  7,211,232, 41,
/* 0x0de0 */   7,139, 70,188,139, 78,182,139, 86,200,137, 86,188,139, 86,202,
/* 0x0df0 */ 137, 86,182,139, 86,204,137, 86,200,139, 86,206,137, 86,202,139,
/* 0x0e00 */  86,154,137, 86,204,139, 86,156,137, 86,206,137, 70,154,137, 78,
/* 0x0e10 */ 156,131,126,240,  7,125,  5,184,  8,  0,235,  3,184, 11,  0,137,
/* 0x0e20 */  70,240,139, 94,222,129,195,104, 10,137, 94,242,139, 94,242,137,
/* 0x0e30 */  94,234,129,255,  0,  1,115, 94,139, 70,244,139, 86,246,139, 94,
/* 0x0e40 */ 226,139, 78,228, 57,216,117,  7, 57,202,117,  3,233, 99,246,137,
/* 0x0e50 */ 251,137,241,136,223,136,235,136,205, 48,201,137,223,137,206,196,
/* 0x0e60 */  94,244, 38,138,  7,136, 70,166,198, 70,167,  0,139, 70,250,139,
/* 0x0e70 */  86,252,136,214,136,226,136,196, 48,192,139, 94,166,  9,195,137,
/* 0x0e80 */  94,250,137, 86,252,139, 70,244,140,194, 64,117,  3,128,198, 16,
/* 0x0e90 */ 137, 70,244,137, 86,246,137,250,137,240,177, 11,137,211,211,232,
/* 0x0ea0 */ 211,234,177,  5,211,227,  9,216,137, 86,160,137, 70,158,139, 94,
/* 0x0eb0 */ 234,139, 31,137,193,137,208,247,227,145,247,227,  1,202,137, 70,
/* 0x0ec0 */ 248,137, 86,162,139, 70,252, 57,208,114, 10,117, 58,139, 70,250,
/* 0x0ed0 */  59, 70,248,115, 50,139,118,248,137,215,184,  0,  8,139, 94,234,
/* 0x0ee0 */  43,  7,177,  5,211,232,  1,  7,177,  4,139, 70,198,211,224,139,
/* 0x0ef0 */  86,242,131,194,  4,  1,194,137, 86,234, 49,192,137, 70,186,199,
/* 0x0f00 */  70,196,  3,  0,233, 31,  1, 43,118,248, 25,215,139, 70,248, 41,
/* 0x0f10 */  70,250, 25, 86,252,177,  5,139, 94,234,139,  7,211,232, 41,  7,
/* 0x0f20 */ 139, 94,242, 67, 67,137, 94,234,129,255,  0,  1,115, 94,139, 70,
/* 0x0f30 */ 244,139, 86,246,139, 94,226,139, 78,228, 57,216,117,  7, 57,202,
/* 0x0f40 */ 117,  3,233,109,245,137,251,137,241,136,223,136,235,136,205, 48,
/* 0x0f50 */ 201,137,223,137,206,196, 94,244, 38,138,  7,136, 70,166,198, 70,
/* 0x0f60 */ 167,  0,139, 70,250,139, 86,252,136,214,136,226,136,196, 48,192,
/* 0x0f70 */ 139, 94,166,  9,195,137, 94,250,137, 86,252,139, 70,244,140,194,
/* 0x0f80 */  64,117,  3,128,198, 16,137, 70,244,137, 86,246,137,250,137,240,
/* 0x0f90 */ 177, 11,137,211,211,232,211,234,177,  5,211,227,  9,216,137, 86,
/* 0x0fa0 */ 160,137, 70,158,139, 94,234,139, 31,137,193,137,208,247,227,145,
/* 0x0fb0 */ 247,227,  1,202,137, 70,248,137, 86,162,139, 70,252, 57,208,114,
/* 0x0fc0 */  10,117, 54,139, 70,250, 59, 70,248,115, 46,139,118,248,137,215,
/* 0x0fd0 */ 184,  0,  8,139, 94,234, 43,  7,177,  5,211,232,  1,  7,177,  4,
/* 0x0fe0 */ 139, 70,198,211,224,139, 86,242,129,194,  4,  1,  1,194,137, 86,
/* 0x0ff0 */ 234,199, 70,186,  8,  0,233,  6,255, 43,118,248, 25,215,139, 70,
/* 0x1000 */ 248, 41, 70,250, 25, 86,252,177,  5,139, 94,234,139,  7,211,232,
/* 0x1010 */  41,  7,139, 94,242,129,195,  4,  2,137, 94,234,199, 70,186, 16,
/* 0x1020 */   0,199, 70,196,  8,  0,139, 70,196,137, 70,194,199, 70,232,  1,
/* 0x1030 */   0,139, 70,232,209,224,139, 94,234,  1,195,137, 94,218,129,255,
/* 0x1040 */   0,  1,115, 94,139, 70,244,139, 86,246,139, 94,226,139, 78,228,
/* 0x1050 */  57,216,117,  7, 57,202,117,  3,233, 87,244,137,251,137,241,136,
/* 0x1060 */ 223,136,235,136,205, 48,201,137,223,137,206,196, 94,244, 38,138,
/* 0x1070 */   7,136, 70,166,198, 70,167,  0,139, 70,250,139, 86,252,136,214,
/* 0x1080 */ 136,226,136,196, 48,192,139, 94,166,  9,195,137, 94,250,137, 86,
/* 0x1090 */ 252,139, 70,244,140,194, 64,117,  3,128,198, 16,137, 70,244,137,
/* 0x10a0 */  86,246,137,250,137,240,177, 11,137,211,211,232,211,234,177,  5,
/* 0x10b0 */ 211,227,  9,216,137, 86,160,137, 70,158,139, 94,218,139, 31,137,
/* 0x10c0 */ 193,137,208,247,227,145,247,227,  1,202,137, 70,248,137, 86,162,
/* 0x10d0 */ 139, 70,252, 57,208,114, 10,117, 32,139, 70,250, 59, 70,248,115,
/* 0x10e0 */  24,139,118,248,137,215,184,  0,  8,139, 94,218, 43,  7,177,  5,
/* 0x10f0 */ 211,232,  1,  7,209,102,232,235, 34, 43,118,248, 25,215,139, 70,
/* 0x1100 */ 248, 41, 70,250, 25, 86,252,177,  5,139, 94,218,139,  7,211,232,
/* 0x1110 */  41,  7,139, 70,232,  1,192, 64,137, 70,232,255, 78,194,116,  3,
/* 0x1120 */ 233, 14,255,138, 78,196,184,  1,  0,211,224, 41, 70,232,139, 70,
/* 0x1130 */ 186,  1, 70,232,131,126,240,  4,124,  3,233, 64,  3,131, 70,240,
/* 0x1140 */   7,139, 70,232,131,248,  4,124,  3,184,  3,  0,177,  7,137,194,
/* 0x1150 */ 211,226,139, 70,222,  5, 96,  3,  1,208,137, 70,242,199, 70,164,
/* 0x1160 */   6,  0,199, 70,224,  1,  0,139, 70,224,209,224,139, 94,242,  1,
/* 0x1170 */ 195,137, 94,214,129,255,  0,  1,115, 94,139, 70,244,139, 86,246,
/* 0x1180 */ 139, 94,226,139, 78,228, 57,216,117,  7, 57,202,117,  3,233, 33,
/* 0x1190 */ 243,137,251,137,241,136,223,136,235,136,205, 48,201,137,223,137,
/* 0x11a0 */ 206,196, 94,244, 38,138,  7,136, 70,166,198, 70,167,  0,139, 70,
/* 0x11b0 */ 250,139, 86,252,136,214,136,226,136,196, 48,192,139, 94,166,  9,
/* 0x11c0 */ 195,137, 94,250,137, 86,252,139, 70,244,140,194, 64,117,  3,128,
/* 0x11d0 */ 198, 16,137, 70,244,137, 86,246,137,250,137,240,177, 11,137,211,
/* 0x11e0 */ 211,232,211,234,177,  5,211,227,  9,216,137, 86,160,137, 70,158,
/* 0x11f0 */ 139, 94,214,139, 31,137,193,137,208,247,227,145,247,227,  1,202,
/* 0x1200 */ 137, 70,248,137, 86,162,139, 70,252, 57,208,114, 10,117, 32,139,
/* 0x1210 */  70,250, 59, 70,248,115, 24,139,118,248,137,215,184,  0,  8,139,
/* 0x1220 */  94,214, 43,  7,177,  5,211,232,  1,  7,209,102,224,235, 34, 43,
/* 0x1230 */ 118,248, 25,215,139, 70,248, 41, 70,250, 25, 86,252,177,  5,139,
/* 0x1240 */  94,214,139,  7,211,232, 41,  7,139, 70,224,  1,192, 64,137, 70,
/* 0x1250 */ 224,255, 78,164,116,  3,233, 14,255,131,110,224, 64,139, 70,224,
/* 0x1260 */ 131,248,  4,124, 69,209,248, 72,137, 70,220,139, 70,224,131,224,
/* 0x1270 */   1, 12,  2,137, 70,154, 49,192,137, 70,156,131,126,224, 14,125,
/* 0x1280 */  44,139, 78,220,227,  8,209,102,154,209, 86,156,226,248,139, 86,
/* 0x1290 */ 154,209,226,139, 70,222,  5, 96,  5,  1,194,139, 70,224,209,224,
/* 0x12a0 */  41,194, 74, 74,137, 86,242,233,175,  0,233,182,  1,131,110,220,
/* 0x12b0 */   4,129,255,  0,  1,115, 94,139, 70,244,139, 86,246,139, 94,226,
/* 0x12c0 */ 139, 78,228, 57,216,117,  7, 57,202,117,  3,233,228,241,137,251,
/* 0x12d0 */ 137,241,136,223,136,235,136,205, 48,201,137,223,137,206,196, 94,
/* 0x12e0 */ 244, 38,138,  7,136, 70,166,198, 70,167,  0,139, 70,250,139, 86,
/* 0x12f0 */ 252,136,214,136,226,136,196, 48,192,139, 94,166,  9,195,137, 94,
/* 0x1300 */ 250,137, 86,252,139, 70,244,140,194, 64,117,  3,128,198, 16,137,
/* 0x1310 */  70,244,137, 86,246,209,239,209,222,209,102,154,209, 86,156,139,
/* 0x1320 */  70,252, 57,199,114,  7,117, 15, 59,118,250,119, 10, 41,118,250,
/* 0x1330 */  25,126,252,128, 78,154,  1,255, 78,220,116,  3,233,114,255,139,
/* 0x1340 */  94,222,129,195, 68,  6,137, 94,242,185,  4,  0,209,102,154,209,
/* 0x1350 */  86,156,226,248,199, 70,220,  4,  0,184,  1,  0,137, 70,192,137,
/* 0x1360 */  70,208,139, 70,208,209,224,139, 94,242,  1,195,137, 94,212,129,
/* 0x1370 */ 255,  0,  1,115, 94,139, 70,244,139, 86,246,139, 94,226,139, 78,
/* 0x1380 */ 228, 57,216,117,  7, 57,202,117,  3,233, 38,241,137,251,137,241,
/* 0x1390 */ 136,223,136,235,136,205, 48,201,137,223,137,206,196, 94,244, 38,
/* 0x13a0 */ 138,  7,136, 70,166,198, 70,167,  0,139, 70,250,139, 86,252,136,
/* 0x13b0 */ 214,136,226,136,196, 48,192,139, 94,166,  9,195,137, 94,250,137,
/* 0x13c0 */  86,252,139, 70,244,140,194, 64,117,  3,128,198, 16,137, 70,244,
/* 0x13d0 */ 137, 86,246,137,250,137,240,177, 11,137,211,211,232,211,234,177,
/* 0x13e0 */   5,211,227,  9,216,137, 86,160,137, 70,158,139, 94,212,139, 31,
/* 0x13f0 */ 137,193,137,208,247,227,145,247,227,  1,202,137, 70,248,137, 86,
/* 0x1400 */ 162,139, 70,252, 57,208,114, 10,117, 32,139, 70,250, 59, 70,248,
/* 0x1410 */ 115, 24,139,118,248,137,215,184,  0,  8,139, 94,212, 43,  7,177,
/* 0x1420 */   5,211,232,  1,  7,209,102,208,235, 44, 43,118,248, 25,215,139,
/* 0x1430 */  70,248, 41, 70,250, 25, 86,252,177,  5,139, 94,212,139,  7,211,
/* 0x1440 */ 232, 41,  7,139, 70,208,  1,192, 64,137, 70,208,139, 70,192,153,
/* 0x1450 */   9, 70,154,  9, 86,156,209,102,192,255, 78,220,116,  3,233,  1,
/* 0x1460 */ 255,235,  7,153,137, 70,154,137, 86,156,131, 70,154,  1,131, 86,
/* 0x1470 */ 156,  0,139, 70,156, 11, 70,154,117,  3,233,141,  0,131, 70,232,
/* 0x1480 */   2,139, 70,156, 59, 70,238,118,  3,233, 38,240,117,  8,139, 70,
/* 0x1490 */ 154, 59, 70,236,119,243,139, 94,236, 43, 94,154,139, 78,238, 27,
/* 0x14a0 */  78,156,139, 70, 20,139, 86, 22,  1,216,131,209,  0,136,203,177,
/* 0x14b0 */   4,210,227,  0,222,137,195,142,194, 38,138,  7,136, 70,254,139,
/* 0x14c0 */  94,236,139, 78,238,255, 78,232,131, 70,236,  1,131, 86,238,  0,
/* 0x14d0 */ 139, 70, 20,139, 86, 22,  1,216,131,209,  0,136,203,177,  4,210,
/* 0x14e0 */ 227,  0,222,137,195,142,194,138, 70,254, 38,136,  7,131,126,232,
/* 0x14f0 */   0,117,  3,233,194,239,139, 70,238, 59, 70, 26,114,152,117,243,
/* 0x1500 */ 139, 70,236, 59, 70, 24,114,142,235,233,137,236, 93, 95, 94, 86,
/* 0x1510 */  87, 85,137,229,131,236,102,139,118,  8,141, 92,  4,137, 94,222,
/* 0x1520 */  49,192,137, 70,236,137, 70,238,198, 70,254,  0,138, 76,  2,184,
/* 0x1530 */   1,  0,211,224, 72,137, 70,168,138, 76,  1,184,  1,  0,211,224,
/* 0x1540 */  72,153,137, 70,170,137, 86,172, 49,192,137, 70,240,137, 70,156,
/* 0x1550 */ 137, 70,206,137, 70,202,137, 70,182,139, 94, 18,137,  7,137, 71,
/* 0x1560 */   2,139, 94, 28,137,  7,137, 71,  2, 64,137, 70,154,137, 70,204,
/* 0x1570 */ 137, 70,200,137, 70,188,138,  4,137, 70,178,138, 84,  1, 48,246,
/* 0x1580 */ 137,193,  1,209,184,  0,  3, 48,210,227,  6,209,224,209,210,226,
/* 0x1590 */ 250,137,198,129,198, 54,  7,137,209,131,209,  0, 49,210, 49,192,
/* 0x15a0 */  57,200,114,  6,117, 23, 57,242,115, 19,137,211,209,227,  3, 94,
/* 0x15b0 */ 222,199,  7,  0,  4,131,194,  1,131,208,  0,235,227,139, 94, 10,
/* 0x15c0 */ 137, 94,244,139, 70, 12,137, 70,246,137,216,139, 86, 12,139, 94,
/* 0x15d0 */  14,139, 78, 16,  1,216,131,209,  0,208,225,208,225,208,225,208,
/* 0x15e0 */ 225,  0,206,137, 70,226,137, 86,228, 49,192,137, 70,250,137, 70,
/* 0x15f0 */ 252,190,255,255,137,247,137, 70,184,235, 68,196, 94,244, 38,138,
/* 0x1600 */   7,136, 70,166,198, 70,167,  0,139, 70,250,139, 86,252,136,214,
/* 0x1610 */ 136,226,136,196, 48,192,139, 94,166,  9,195,137, 94,250,137, 86,
/* 0x1620 */ 252,139, 70,244,140,194,131,192,  1, 24,219,128,227, 16,  0,222,
/* 0x1630 */ 137, 70,244,137, 86,246,255, 70,184,131,126,184,  5,125, 26,139,
/* 0x1640 */  70,244,139, 86,246,139, 94,226,139, 78,228, 57,216,117,172, 57,
/* 0x1650 */ 202,117,168,184,  1,  0,233,224, 16,139, 70,238, 59, 70, 26,114,
/* 0x1660 */  13,116,  3,233,211, 16,139, 70,236, 59, 70, 24,115,245,139, 70,
/* 0x1670 */ 236, 35, 70,168,137, 70,198,177,  5,139, 86,240,211,226,  3, 86,
/* 0x1680 */ 222,209,224,  1,194,137, 86,242,129,255,  0,  1,115, 95,139, 70,
/* 0x1690 */ 244,139, 86,246,139, 94,226,139, 78,228, 57,202,117,  2, 57,216,
/* 0x16a0 */ 116,177,137,251,137,241,136,223,136,235,136,205, 48,201,137,223,
/* 0x16b0 */ 137,206,196, 94,244, 38,138,  7,136, 70,166,198, 70,167,  0,139,
/* 0x16c0 */  70,250,139, 86,252,136,214,136,226,136,196, 48,192,139, 94,166,
/* 0x16d0 */   9,195,137, 94,250,137, 86,252,139, 70,244,140,194,131,192,  1,
/* 0x16e0 */  24,219,128,227, 16,  0,222,137, 70,244,137, 86,246,137,250,137,
/* 0x16f0 */ 240,136,224,136,212,136,242, 48,246,209,234,209,216,209,234,209,
/* 0x1700 */ 216,209,234,209,216,137, 86,160,137, 70,158,139, 94,242,139, 31,
/* 0x1710 */ 137,193,137,208,247,227,145,247,227,  1,202,137, 70,248,137, 86,
/* 0x1720 */ 162,139, 70,252, 57,208,114, 13,116,  3,233, 30,  3,139, 70,250,
/* 0x1730 */  59, 70,248,115,245,199, 70,230,  1,  0,139,118,248,137,215,184,
/* 0x1740 */   0,  8,139, 94,242, 43,  7,177,  5,211,232,  1,  7,185,  8,  0,
/* 0x1750 */  43, 78,178,138, 70,254, 48,228,211,248,153,137, 70,166,137,211,
/* 0x1760 */ 139, 70,236, 35, 70,170,139, 86,238, 35, 86,172,139, 78,178,227,
/* 0x1770 */   6,209,224,209,210,226,250,  3, 70,166, 17,218,209,224,209,210,
/* 0x1780 */ 137,209,137,195,209,224,209,210,  1,216, 17,202,136,214,136,226,
/* 0x1790 */ 136,196, 48,192,139, 86,222,129,194,108, 14,  1,194,137, 86,242,
/* 0x17a0 */ 131,126,240,  7,125,  3,233, 76,  1,139, 94,236, 43, 94,154,139,
/* 0x17b0 */  78,238, 27, 78,156,139, 70, 20,139, 86, 22,  1,216,131,209,  0,
/* 0x17c0 */ 208,225,208,225,208,225,208,225,  0,206,137,195,142,194, 38,138,
/* 0x17d0 */   7, 48,228,137, 70,180,209,102,180,139, 70,180, 48,192,128,228,
/* 0x17e0 */   1,137, 70,190,209,224,139, 86,242,128,198,  2,  1,194,139, 70,
/* 0x17f0 */ 230,209,224,  1,194,137, 86,210,129,255,  0,  1,115, 98,139, 70,
/* 0x1800 */ 244,139, 86,246,139, 94,226,139, 78,228, 57,216,117,  7, 57,202,
/* 0x1810 */ 117,  3,233, 62,254,137,251,137,241,136,223,136,235,136,205, 48,
/* 0x1820 */ 201,137,223,137,206,196, 94,244, 38,138,  7,136, 70,166,198, 70,
/* 0x1830 */ 167,  0,139, 70,250,139, 86,252,136,214,136,226,136,196, 48,192,
/* 0x1840 */ 139, 94,166,  9,195,137, 94,250,137, 86,252,139, 70,244,140,194,
/* 0x1850 */ 131,192,  1, 24,219,128,227, 16,  0,222,137, 70,244,137, 86,246,
/* 0x1860 */ 137,250,137,240,136,224,136,212,136,242, 48,246,209,234,209,216,
/* 0x1870 */ 209,234,209,216,209,234,209,216,137, 86,160,137, 70,158,139, 94,
/* 0x1880 */ 210,139, 31,137,193,137,208,247,227,145,247,227,  1,202,137, 70,
/* 0x1890 */ 248,137, 86,162,139, 70,252, 57,208,114, 10,117, 38,139, 70,250,
/* 0x18a0 */  59, 70,248,115, 30,139,118,248,137,215,184,  0,  8,139, 94,210,
/* 0x18b0 */  43,  7,177,  5,211,232,  1,  7,209,102,230,131,126,190,  0,117,
/* 0x18c0 */  52,235, 40, 43,118,248, 25,215,139, 70,248, 41, 70,250, 25, 86,
/* 0x18d0 */ 252,177,  5,139, 94,210,139,  7,211,232, 41,  7,139, 70,230,  1,
/* 0x18e0 */ 192, 64,137, 70,230,131,126,190,  0,116, 10,129,126,230,  0,  1,
/* 0x18f0 */ 125,  3,233,225,254,139, 70,230, 61,  0,  1,124,  3,233,245,  0,
/* 0x1900 */ 209,224,139, 94,242,  1,195,137, 94,216,129,255,  0,  1,115, 98,
/* 0x1910 */ 139, 70,244,139, 86,246,139, 94,226,139, 78,228, 57,216,117,  7,
/* 0x1920 */  57,202,117,  3,233, 44,253,137,251,137,241,136,223,136,235,136,
/* 0x1930 */ 205, 48,201,137,223,137,206,196, 94,244, 38,138,  7,136, 70,166,
/* 0x1940 */ 198, 70,167,  0,139, 70,250,139, 86,252,136,214,136,226,136,196,
/* 0x1950 */  48,192,139, 94,166,  9,195,137, 94,250,137, 86,252,139, 70,244,
/* 0x1960 */ 140,194,131,192,  1, 24,219,128,227, 16,  0,222,137, 70,244,137,
/* 0x1970 */  86,246,137,250,137,240,136,224,136,212,136,242, 48,246,209,234,
/* 0x1980 */ 209,216,209,234,209,216,209,234,209,216,137, 86,160,137, 70,158,
/* 0x1990 */ 139, 94,216,139, 31,137,193,137,208,247,227,145,247,227,  1,202,
/* 0x19a0 */ 137, 70,248,137, 86,162,139, 70,252, 57,208,114, 10,117, 33,139,
/* 0x19b0 */  70,250, 59, 70,248,115, 25,139,118,248,137,215,184,  0,  8,139,
/* 0x19c0 */  94,216, 43,  7,177,  5,211,232,  1,  7,209,102,230,233, 37,255,
/* 0x19d0 */  43,118,248, 25,215,139, 70,248, 41, 70,250, 25, 86,252,177,  5,
/* 0x19e0 */ 139, 94,216,139,  7,211,232, 41,  7,139, 70,230,  1,192, 64,137,
/* 0x19f0 */  70,230,233,  0,255,138, 70,230,136, 70,254,139, 94,236,139, 78,
/* 0x1a00 */ 238,131, 70,236,  1,131, 86,238,  0,139, 70, 20,139, 86, 22,  1,
/* 0x1a10 */ 216,131,209,  0,208,225,208,225,208,225,208,225,  0,206,137,195,
/* 0x1a20 */ 142,194,138, 70,230, 38,136,  7,139, 70,240,131,248,  4,125,  8,
/* 0x1a30 */  49,192,137, 70,240,233, 33,252,131,248, 10,125,  7,131,110,240,
/* 0x1a40 */   3,233, 21,252,131,110,240,  6,233, 14,252, 43,118,248, 25,215,
/* 0x1a50 */ 139, 70,248, 41, 70,250, 25, 86,252,177,  5,139, 94,242,139,  7,
/* 0x1a60 */ 211,232, 41,  7,139, 70,240,209,224,139, 86,222,129,194,128,  1,
/* 0x1a70 */   1,194,137, 86,242,129,255,  0,  1,115, 98,139, 70,244,139, 86,
/* 0x1a80 */ 246,139, 94,226,139, 78,228, 57,216,117,  7, 57,202,117,  3,233,
/* 0x1a90 */ 193,251,137,251,137,241,136,223,136,235,136,205, 48,201,137,223,
/* 0x1aa0 */ 137,206,196, 94,244, 38,138,  7,136, 70,166,198, 70,167,  0,139,
/* 0x1ab0 */  70,250,139, 86,252,136,214,136,226,136,196, 48,192,139, 94,166,
/* 0x1ac0 */   9,195,137, 94,250,137, 86,252,139, 70,244,140,194,131,192,  1,
/* 0x1ad0 */  24,219,128,227, 16,  0,222,137, 70,244,137, 86,246,137,250,137,
/* 0x1ae0 */ 240,136,224,136,212,136,242, 48,246,209,234,209,216,209,234,209,
/* 0x1af0 */ 216,209,234,209,216,137, 86,160,137, 70,158,139, 94,242,139, 31,
/* 0x1b00 */ 137,193,137,208,247,227,145,247,227,  1,202,137, 70,248,137, 86,
/* 0x1b10 */ 162,139, 70,252, 57,208,114, 10,117, 89,139, 70,250, 59, 70,248,
/* 0x1b20 */ 115, 81,139,118,248,137,215,184,  0,  8,139, 94,242, 43,  7,177,
/* 0x1b30 */   5,211,232,  1,  7,139, 70,200,137, 70,188,139, 70,202,137, 70,
/* 0x1b40 */ 182,139, 70,204,137, 70,200,139, 70,206,137, 70,202,139, 70,154,
/* 0x1b50 */ 137, 70,204,139, 70,156,137, 70,206,131,126,240,  7,125,  4, 49,
/* 0x1b60 */ 192,235,  3,184,  3,  0,137, 70,240,139, 94,222,129,195,100,  6,
/* 0x1b70 */ 233,171,  4, 43,118,248, 25,215,139, 70,248, 41, 70,250, 25, 86,
/* 0x1b80 */ 252,177,  5,139, 94,242,139,  7,211,232, 41,  7,139, 86,240,209,
/* 0x1b90 */ 226,139, 70,222,  5,152,  1,  1,208,137, 70,242,129,255,  0,  1,
/* 0x1ba0 */ 115, 98,139, 70,244,139, 86,246,139, 94,226,139, 78,228, 57,216,
/* 0x1bb0 */ 117,  7, 57,202,117,  3,233,154,250,137,251,137,241,136,223,136,
/* 0x1bc0 */ 235,136,205, 48,201,137,223,137,206,196, 94,244, 38,138,  7,136,
/* 0x1bd0 */  70,166,198, 70,167,  0,139, 70,250,139, 86,252,136,214,136,226,
/* 0x1be0 */ 136,196, 48,192,139, 94,166,  9,195,137, 94,250,137, 86,252,139,
/* 0x1bf0 */  70,244,140,194,131,192,  1, 24,219,128,227, 16,  0,222,137, 70,
/* 0x1c00 */ 244,137, 86,246,137,250,137,240,136,224,136,212,136,242, 48,246,
/* 0x1c10 */ 209,234,209,216,209,234,209,216,209,234,209,216,137, 86,160,137,
/* 0x1c20 */  70,158,139, 94,242,139, 31,137,193,137,208,247,227,145,247,227,
/* 0x1c30 */   1,202,137, 70,248,137, 86,162,139, 70,244,139, 86,246,131,192,
/* 0x1c40 */   1, 24,219,128,227, 16,  0,222,137, 70,174,137, 86,176,139, 70,
/* 0x1c50 */ 252, 59, 70,162,114, 13,116,  3,233,131,  1,139, 70,250, 59, 70,
/* 0x1c60 */ 248,115,245,139,118,248,139,126,162,184,  0,  8,139, 94,242, 43,
/* 0x1c70 */   7,177,  5,211,232,  1,  7,139, 70,240,211,224,139, 86,222,129,
/* 0x1c80 */ 194,224,  1,  1,194,139, 70,198,209,224,  1,194,137, 86,242,129,
/* 0x1c90 */ 255,  0,  1,115, 89,139, 70,244,139, 86,246,139, 94,226,139, 78,
/* 0x1ca0 */ 228, 57,216,117,  7, 57,202,117,  3,233,167,249,137,240,137,251,
/* 0x1cb0 */ 136,223,136,227,136,196, 48,192,137,223,137,198,196, 94,244, 38,
/* 0x1cc0 */ 138,  7,136, 70,166,198, 70,167,  0,139, 70,250,139, 86,252,136,
/* 0x1cd0 */ 214,136,226,136,196, 48,192,139, 94,166,  9,195,137, 94,250,137,
/* 0x1ce0 */  86,252,139, 94,174,137, 94,244,139, 70,176,137, 70,246,137,250,
/* 0x1cf0 */ 137,240,136,224,136,212,136,242, 48,246,209,234,209,216,209,234,
/* 0x1d00 */ 209,216,209,234,209,216,137, 86,160,137, 70,158,139, 94,242,139,
/* 0x1d10 */  31,137,193,137,208,247,227,145,247,227,  1,202,137, 70,248,137,
/* 0x1d20 */  86,162,139, 70,252, 57,208,114, 13,117, 52,139, 70,250, 59, 70,
/* 0x1d30 */ 248,114,  3,233,140,  0,139,118,248,137,215,184,  0,  8,139, 94,
/* 0x1d40 */ 242, 43,  7,177,  5,211,232,  1,  7,139, 70,238, 11, 70,236,117,
/* 0x1d50 */   3,233,255,248,131,126,240,  7,125,  7,184,  9,  0,235,  5,235,
/* 0x1d60 */  97,184, 11,  0,137, 70,240,139, 94,236, 43, 94,154,139, 78,238,
/* 0x1d70 */  27, 78,156,139, 70, 20,139, 86, 22,  1,216,131,209,  0,208,225,
/* 0x1d80 */ 208,225,208,225,208,225,  0,206,137,195,142,194, 38,138,  7,136,
/* 0x1d90 */  70,254,139, 94,236,139, 78,238,131, 70,236,  1,131, 86,238,  0,
/* 0x1da0 */ 139, 70, 20,139, 86, 22,  1,216,131,209,  0,208,225,208,225,208,
/* 0x1db0 */ 225,208,225,  0,206,137,195,142,194,138, 70,254, 38,136,  7,233,
/* 0x1dc0 */ 151,248, 43,118,248, 25,215,139, 70,248, 41, 70,250, 25, 86,252,
/* 0x1dd0 */ 177,  5,139, 94,242,139,  7,211,232, 41,  7,233, 40,  2, 43,118,
/* 0x1de0 */ 248, 27,126,162,139, 70,248, 41, 70,250,139, 70,162, 25, 70,252,
/* 0x1df0 */ 177,  5,139, 94,242,139,  7,211,232, 41,  7,139, 70,240,209,224,
/* 0x1e00 */ 139, 86,222,129,194,176,  1,  1,194,137, 86,242,129,255,  0,  1,
/* 0x1e10 */ 115, 89,139, 70,244,139, 86,246,139, 94,226,139, 78,228, 57,216,
/* 0x1e20 */ 117,  7, 57,202,117,  3,233, 42,248,137,251,137,241,136,223,136,
/* 0x1e30 */ 235,136,205, 48,201,137,223,137,206,196, 94,244, 38,138,  7,136,
/* 0x1e40 */  70,166,198, 70,167,  0,139, 70,250,139, 86,252,136,214,136,226,
/* 0x1e50 */ 136,196, 48,192,139, 94,166,  9,195,137, 94,250,137, 86,252,139,
/* 0x1e60 */  94,174,137, 94,244,139, 70,176,137, 70,246,137,250,137,240,136,
/* 0x1e70 */ 224,136,212,136,242, 48,246,209,234,209,216,209,234,209,216,209,
/* 0x1e80 */ 234,209,216,137, 86,160,137, 70,158,139, 94,242,139, 31,137,193,
/* 0x1e90 */ 137,208,247,227,145,247,227,  1,202,137, 70,248,137, 86,162,139,
/* 0x1ea0 */  70,252, 57,208,114, 10,117, 36,139, 70,250, 59, 70,248,115, 28,
/* 0x1eb0 */ 139,118,248,137,215,184,  0,  8,139, 94,242, 43,  7,177,  5,211,
/* 0x1ec0 */ 232,  1,  7,139, 70,204,139, 78,206,233, 40,  1, 43,118,248, 25,
/* 0x1ed0 */ 215,139, 70,248, 41, 70,250, 25, 86,252,177,  5,139, 94,242,139,
/* 0x1ee0 */   7,211,232, 41,  7,139, 86,240,209,226,139, 70,222,  5,200,  1,
/* 0x1ef0 */   1,208,137, 70,242,129,255,  0,  1,115, 98,139, 70,244,139, 86,
/* 0x1f00 */ 246,139, 94,226,139, 78,228, 57,216,117,  7, 57,202,117,  3,233,
/* 0x1f10 */  65,247,137,251,137,241,136,223,136,235,136,205, 48,201,137,223,
/* 0x1f20 */ 137,206,196, 94,244, 38,138,  7,136, 70,166,198, 70,167,  0,139,
/* 0x1f30 */  70,250,139, 86,252,136,214,136,226,136,196, 48,192,139, 94,166,
/* 0x1f40 */   9,195,137, 94,250,137, 86,252,139, 70,244,140,194,131,192,  1,
/* 0x1f50 */  24,219,128,227, 16,  0,222,137, 70,244,137, 86,246,137,250,137,
/* 0x1f60 */ 240,136,224,136,212,136,242, 48,246,209,234,209,216,209,234,209,
/* 0x1f70 */ 216,209,234,209,216,137, 86,160,137, 70,158,139, 94,242,139, 31,
/* 0x1f80 */ 137,193,137,208,247,227,145,247,227,  1,202,137, 70,248,137, 86,
/* 0x1f90 */ 162,139, 70,252, 57,208,114, 10,117, 35,139, 70,250, 59, 70,248,
/* 0x1fa0 */ 115, 27,139,118,248,137,215,184,  0,  8,139, 94,242, 43,  7,177,
/* 0x1fb0 */   5,211,232,  1,  7,139, 70,200,139, 78,202,235, 43, 43,118,248,
/* 0x1fc0 */  25,215,139, 70,248, 41, 70,250, 25, 86,252,177,  5,139, 94,242,
/* 0x1fd0 */ 139,  7,211,232, 41,  7,139, 70,188,139, 78,182,139, 86,200,137,
/* 0x1fe0 */  86,188,139, 86,202,137, 86,182,139, 86,204,137, 86,200,139, 86,
/* 0x1ff0 */ 206,137, 86,202,139, 86,154,137, 86,204,139, 86,156,137, 86,206,
/* 0x2000 */ 137, 70,154,137, 78,156,131,126,240,  7,125,  5,184,  8,  0,235,
/* 0x2010 */   3,184, 11,  0,137, 70,240,139, 94,222,129,195,104, 10,137, 94,
/* 0x2020 */ 242,139, 94,242,137, 94,234,129,255,  0,  1,115, 98,139, 70,244,
/* 0x2030 */ 139, 86,246,139, 94,226,139, 78,228, 57,216,117,  7, 57,202,117,
/* 0x2040 */   3,233, 15,246,137,251,137,241,136,223,136,235,136,205, 48,201,
/* 0x2050 */ 137,223,137,206,196, 94,244, 38,138,  7,136, 70,166,198, 70,167,
/* 0x2060 */   0,139, 70,250,139, 86,252,136,214,136,226,136,196, 48,192,139,
/* 0x2070 */  94,166,  9,195,137, 94,250,137, 86,252,139, 70,244,140,194,131,
/* 0x2080 */ 192,  1, 24,219,128,227, 16,  0,222,137, 70,244,137, 86,246,137,
/* 0x2090 */ 250,137,240,136,224,136,212,136,242, 48,246,209,234,209,216,209,
/* 0x20a0 */ 234,209,216,209,234,209,216,137, 86,160,137, 70,158,139, 94,234,
/* 0x20b0 */ 139, 31,137,193,137,208,247,227,145,247,227,  1,202,137, 70,248,
/* 0x20c0 */ 137, 86,162,139, 70,252, 57,208,114, 10,117, 58,139, 70,250, 59,
/* 0x20d0 */  70,248,115, 50,139,118,248,137,215,184,  0,  8,139, 94,234, 43,
/* 0x20e0 */   7,177,  5,211,232,  1,  7,177,  4,139, 70,198,211,224,139, 86,
/* 0x20f0 */ 242,131,194,  4,  1,194,137, 86,234, 49,192,137, 70,186,199, 70,
/* 0x2100 */ 196,  3,  0,233, 41,  1, 43,118,248, 25,215,139, 70,248, 41, 70,
/* 0x2110 */ 250, 25, 86,252,177,  5,139, 94,234,139,  7,211,232, 41,  7,139,
/* 0x2120 */  94,242, 67, 67,137, 94,234,129,255,  0,  1,115, 98,139, 70,244,
/* 0x2130 */ 139, 86,246,139, 94,226,139, 78,228, 57,216,117,  7, 57,202,117,
/* 0x2140 */   3,233, 15,245,137,251,137,241,136,223,136,235,136,205, 48,201,
/* 0x2150 */ 137,223,137,206,196, 94,244, 38,138,  7,136, 70,166,198, 70,167,
/* 0x2160 */   0,139, 70,250,139, 86,252,136,214,136,226,136,196, 48,192,139,
/* 0x2170 */  94,166,  9,195,137, 94,250,137, 86,252,139, 70,244,140,194,131,
/* 0x2180 */ 192,  1, 24,219,128,227, 16,  0,222,137, 70,244,137, 86,246,137,
/* 0x2190 */ 250,137,240,136,224,136,212,136,242, 48,246,209,234,209,216,209,
/* 0x21a0 */ 234,209,216,209,234,209,216,137, 86,160,137, 70,158,139, 94,234,
/* 0x21b0 */ 139, 31,137,193,137,208,247,227,145,247,227,  1,202,137, 70,248,
/* 0x21c0 */ 137, 86,162,139, 70,252, 57,208,114, 10,117, 54,139, 70,250, 59,
/* 0x21d0 */  70,248,115, 46,139,118,248,137,215,184,  0,  8,139, 94,234, 43,
/* 0x21e0 */   7,177,  5,211,232,  1,  7,177,  4,139, 70,198,211,224,139, 86,
/* 0x21f0 */ 242,129,194,  4,  1,  1,194,137, 86,234,199, 70,186,  8,  0,233,
/* 0x2200 */ 252,254, 43,118,248, 25,215,139, 70,248, 41, 70,250, 25, 86,252,
/* 0x2210 */ 177,  5,139, 94,234,139,  7,211,232, 41,  7,139, 94,242,129,195,
/* 0x2220 */   4,  2,137, 94,234,199, 70,186, 16,  0,199, 70,196,  8,  0,139,
/* 0x2230 */  70,196,137, 70,194,199, 70,232,  1,  0,139, 70,232,209,224,139,
/* 0x2240 */  94,234,  1,195,137, 94,218,129,255,  0,  1,115, 98,139, 70,244,
/* 0x2250 */ 139, 86,246,139, 94,226,139, 78,228, 57,216,117,  7, 57,202,117,
/* 0x2260 */   3,233,239,243,137,251,137,241,136,223,136,235,136,205, 48,201,
/* 0x2270 */ 137,223,137,206,196, 94,244, 38,138,  7,136, 70,166,198, 70,167,
/* 0x2280 */   0,139, 70,250,139, 86,252,136,214,136,226,136,196, 48,192,139,
/* 0x2290 */  94,166,  9,195,137, 94,250,137, 86,252,139, 70,244,140,194,131,
/* 0x22a0 */ 192,  1, 24,219,128,227, 16,  0,222,137, 70,244,137, 86,246,137,
/* 0x22b0 */ 250,137,240,136,224,136,212,136,242, 48,246,209,234,209,216,209,
/* 0x22c0 */ 234,209,216,209,234,209,216,137, 86,160,137, 70,158,139, 94,218,
/* 0x22d0 */ 139, 31,137,193,137,208,247,227,145,247,227,  1,202,137, 70,248,
/* 0x22e0 */ 137, 86,162,139, 70,252, 57,208,114, 10,117, 32,139, 70,250, 59,
/* 0x22f0 */  70,248,115, 24,139,118,248,137,215,184,  0,  8,139, 94,218, 43,
/* 0x2300 */   7,177,  5,211,232,  1,  7,209,102,232,235, 34, 43,118,248, 25,
/* 0x2310 */ 215,139, 70,248, 41, 70,250, 25, 86,252,177,  5,139, 94,218,139,
/* 0x2320 */   7,211,232, 41,  7,139, 70,232,  1,192, 64,137, 70,232,255, 78,
/* 0x2330 */ 194,116,  3,233,  4,255,138, 78,196,184,  1,  0,211,224, 41, 70,
/* 0x2340 */ 232,139, 70,186,  1, 70,232,131,126,240,  4,124,  3,233, 88,  3,
/* 0x2350 */ 131, 70,240,  7,139, 70,232,131,248,  4,124,  3,184,  3,  0,177,
/* 0x2360 */   7,137,194,211,226,139, 70,222,  5, 96,  3,  1,208,137, 70,242,
/* 0x2370 */ 199, 70,164,  6,  0,199, 70,224,  1,  0,139, 70,224,209,224,139,
/* 0x2380 */  94,242,  1,195,137, 94,214,129,255,  0,  1,115, 98,139, 70,244,
/* 0x2390 */ 139, 86,246,139, 94,226,139, 78,228, 57,216,117,  7, 57,202,117,
/* 0x23a0 */   3,233,175,242,137,251,137,241,136,223,136,235,136,205, 48,201,
/* 0x23b0 */ 137,223,137,206,196, 94,244, 38,138,  7,136, 70,166,198, 70,167,
/* 0x23c0 */   0,139, 70,250,139, 86,252,136,214,136,226,136,196, 48,192,139,
/* 0x23d0 */  94,166,  9,195,137, 94,250,137, 86,252,139, 70,244,140,194,131,
/* 0x23e0 */ 192,  1, 24,219,128,227, 16,  0,222,137, 70,244,137, 86,246,137,
/* 0x23f0 */ 250,137,240,136,224,136,212,136,242, 48,246,209,234,209,216,209,
/* 0x2400 */ 234,209,216,209,234,209,216,137, 86,160,137, 70,158,139, 94,214,
/* 0x2410 */ 139, 31,137,193,137,208,247,227,145,247,227,  1,202,137, 70,248,
/* 0x2420 */ 137, 86,162,139, 70,252, 57,208,114, 10,117, 32,139, 70,250, 59,
/* 0x2430 */  70,248,115, 24,139,118,248,137,215,184,  0,  8,139, 94,214, 43,
/* 0x2440 */   7,177,  5,211,232,  1,  7,209,102,224,235, 34, 43,118,248, 25,
/* 0x2450 */ 215,139, 70,248, 41, 70,250, 25, 86,252,177,  5,139, 94,214,139,
/* 0x2460 */   7,211,232, 41,  7,139, 70,224,  1,192, 64,137, 70,224,255, 78,
/* 0x2470 */ 164,116,  3,233,  4,255,131,110,224, 64,139, 70,224,131,248,  4,
/* 0x2480 */ 124, 69,209,248, 72,137, 70,220,139, 70,224,131,224,  1, 12,  2,
/* 0x2490 */ 137, 70,154, 49,192,137, 70,156,131,126,224, 14,125, 44,139, 78,
/* 0x24a0 */ 220,227,  8,209,102,154,209, 86,156,226,248,139, 86,154,209,226,
/* 0x24b0 */ 139, 70,222,  5, 96,  5,  1,194,139, 70,224,209,224, 41,194, 74,
/* 0x24c0 */  74,137, 86,242,233,179,  0,233,196,  1,131,110,220,  4,129,255,
/* 0x24d0 */   0,  1,115, 98,139, 70,244,139, 86,246,139, 94,226,139, 78,228,
/* 0x24e0 */  57,216,117,  7, 57,202,117,  3,233,104,241,137,251,137,241,136,
/* 0x24f0 */ 223,136,235,136,205, 48,201,137,223,137,206,196, 94,244, 38,138,
/* 0x2500 */   7,136, 70,166,198, 70,167,  0,139, 70,250,139, 86,252,136,214,
/* 0x2510 */ 136,226,136,196, 48,192,139, 94,166,  9,195,137, 94,250,137, 86,
/* 0x2520 */ 252,139, 70,244,140,194,131,192,  1, 24,219,128,227, 16,  0,222,
/* 0x2530 */ 137, 70,244,137, 86,246,209,239,209,222,209,102,154,209, 86,156,
/* 0x2540 */ 139, 70,252, 57,199,114,  7,117, 15, 59,118,250,119, 10, 41,118,
/* 0x2550 */ 250, 25,126,252,128, 78,154,  1,255, 78,220,116,  3,233,110,255,
/* 0x2560 */ 139, 94,222,129,195, 68,  6,137, 94,242,185,  4,  0,209,102,154,
/* 0x2570 */ 209, 86,156,226,248,199, 70,220,  4,  0,184,  1,  0,137, 70,192,
/* 0x2580 */ 137, 70,208,139, 70,208,209,224,139, 94,242,  1,195,137, 94,212,
/* 0x2590 */ 129,255,  0,  1,115, 98,139, 70,244,139, 86,246,139, 94,226,139,
/* 0x25a0 */  78,228, 57,216,117,  7, 57,202,117,  3,233,166,240,137,251,137,
/* 0x25b0 */ 241,136,223,136,235,136,205, 48,201,137,223,137,206,196, 94,244,
/* 0x25c0 */  38,138,  7,136, 70,166,198, 70,167,  0,139, 70,250,139, 86,252,
/* 0x25d0 */ 136,214,136,226,136,196, 48,192,139, 94,166,  9,195,137, 94,250,
/* 0x25e0 */ 137, 86,252,139, 70,244,140,194,131,192,  1, 24,219,128,227, 16,
/* 0x25f0 */   0,222,137, 70,244,137, 86,246,137,250,137,240,136,224,136,212,
/* 0x2600 */ 136,242, 48,246,209,234,209,216,209,234,209,216,209,234,209,216,
/* 0x2610 */ 137, 86,160,137, 70,158,139, 94,212,139, 31,137,193,137,208,247,
/* 0x2620 */ 227,145,247,227,  1,202,137, 70,248,137, 86,162,139, 70,252, 57,
/* 0x2630 */ 208,114, 10,117, 32,139, 70,250, 59, 70,248,115, 24,139,118,248,
/* 0x2640 */ 137,215,184,  0,  8,139, 94,212, 43,  7,177,  5,211,232,  1,  7,
/* 0x2650 */ 209,102,208,235, 44, 43,118,248, 25,215,139, 70,248, 41, 70,250,
/* 0x2660 */  25, 86,252,177,  5,139, 94,212,139,  7,211,232, 41,  7,139, 70,
/* 0x2670 */ 208,  1,192, 64,137, 70,208,139, 70,192,153,  9, 70,154,  9, 86,
/* 0x2680 */ 156,209,102,192,255, 78,220,116,  3,233,247,254,235,  7,153,137,
/* 0x2690 */  70,154,137, 86,156,131, 70,154,  1,131, 86,156,  0,139, 70,156,
/* 0x26a0 */  11, 70,154,117,  3,233,145,  0,131, 70,232,  2,139, 70,156, 59,
/* 0x26b0 */  70,238,118,  3,233,156,239,117,  8,139, 70,154, 59, 70,236,119,
/* 0x26c0 */ 243,139, 94,236, 43, 94,154,139, 78,238, 27, 78,156,139, 70, 20,
/* 0x26d0 */ 139, 86, 22,  1,216,131,209,  0,208,225,208,225,208,225,208,225,
/* 0x26e0 */   0,206,137,195,142,194, 38,138,  7,136, 70,254,139, 94,236,139,
/* 0x26f0 */  78,238,255, 78,232,131, 70,236,  1,131, 86,238,  0,139, 70, 20,
/* 0x2700 */ 139, 86, 22,  1,216,131,209,  0,208,225,208,225,208,225,208,225,
/* 0x2710 */   0,206,137,195,142,194,138, 70,254, 38,136,  7,131,126,232,  0,
/* 0x2720 */ 117,  3,233, 52,239,139, 70,238, 59, 70, 26,114,148,117,243,139,
/* 0x2730 */  70,236, 59, 70, 24,114,138,235,233,137,236, 93, 95, 94, 31,137,
/* 0x2740 */ 236,187,  0,  0, 49,192, 80, 57,220,117,251,137,236,191,  0,  0,
/* 0x2750 */  88, 80,  5,  0,  0,142,192, 93,140,192,128,236,  6,142,216,  6,
/* 0x2760 */  31,141,181,  0,  0,173, 91,145,173,146,173,151,173,  1,195,142,
/* 0x2770 */ 195, 49,192,  1,199, 38,  1, 45,172, 72,116,255, 64,117,244, 71,
/* 0x2780 */  71, 38,128, 61,154,117,249, 38, 57, 85,  3,119,243,176,  3,235,
/* 0x2790 */  17,129,199,254,  0,114,  8,226, 22,  7,  6, 31,157,114, 16,  7,
/* 0x27a0 */  31, 93, 95, 94, 91, 88,142,208,137,220, 90, 89, 91, 88,203,141,
/* 0x27b0 */ 134,  0,  0,142,208,188,  0,  0,234,  0,  0,  0,  0,129,197,  0,
/* 0x27c0 */   0, 85,184,  0,  0, 80,203,102,105,108,101, 32,102,111,114,109,
/* 0x27d0 */  97,116, 32,101,108,102, 51, 50, 45,105, 51, 56, 54, 10, 10, 83,
/* 0x27e0 */ 101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,
/* 0x27f0 */ 101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32,
/* 0x2800 */  32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2810 */  77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,
/* 0x2820 */ 102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32,
/* 0x2830 */  32, 48, 32, 68, 69, 86, 73, 67, 69, 69, 78, 84, 82, 89, 32, 32,
/* 0x2840 */  32, 48, 48, 48, 48, 48, 48, 50,100, 32, 32, 48, 48, 48, 48, 48,
/* 0x2850 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2860 */  48, 48, 48, 48, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2870 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x2880 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49, 32, 76, 90, 77,
/* 0x2890 */  65, 68, 69, 86, 73, 67, 69, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x28a0 */  48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x28b0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 54,
/* 0x28c0 */  49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x28d0 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x28e0 */  76, 89, 10, 32, 32, 50, 32, 68, 69, 86, 73, 67, 69, 69, 78, 84,
/* 0x28f0 */  82, 89, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48,
/* 0x2900 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2910 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 54, 54, 32, 32, 50, 42, 42,
/* 0x2920 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x2930 */  68, 79, 78, 76, 89, 10, 32, 32, 51, 32, 76, 90, 77, 65, 69, 78,
/* 0x2940 */  84, 82, 89, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 49,
/* 0x2950 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2960 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 54, 57, 32, 32,
/* 0x2970 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x2980 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x2990 */  32, 32, 52, 32, 78, 82, 86, 50, 66, 49, 54, 48, 32, 32, 32, 32,
/* 0x29a0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 97, 32, 32, 48, 48, 48, 48,
/* 0x29b0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x29c0 */  48, 48, 48, 48, 48, 48, 55, 97, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x29d0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x29e0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 53, 32, 78, 82,
/* 0x29f0 */  86, 68, 68, 79, 78, 69, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x2a00 */  48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2a10 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2a20 */  56, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2a30 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x2a40 */  78, 76, 89, 10, 32, 32, 54, 32, 78, 82, 86, 68, 82, 69, 84, 85,
/* 0x2a50 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32,
/* 0x2a60 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2a70 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 56, 54, 32, 32, 50, 42,
/* 0x2a80 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x2a90 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,
/* 0x2aa0 */  55, 32, 78, 82, 86, 68, 69, 67, 79, 49, 32, 32, 32, 32, 32, 32,
/* 0x2ab0 */  48, 48, 48, 48, 48, 48, 49,101, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2ac0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2ad0 */  48, 48, 48, 48, 56, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2ae0 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x2af0 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 56, 32, 78, 82, 86, 76,
/* 0x2b00 */  69, 68, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2b10 */  48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2b20 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 97, 54,
/* 0x2b30 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2b40 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 57, 32, 78,
/* 0x2b50 */  82, 86, 71, 84, 68, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x2b60 */  48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2b70 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2b80 */  48, 97, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2b90 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49,
/* 0x2ba0 */  48, 32, 78, 82, 86, 68, 69, 67, 79, 50, 32, 32, 32, 32, 32, 32,
/* 0x2bb0 */  48, 48, 48, 48, 48, 48, 49, 55, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2bc0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2bd0 */  48, 48, 48, 48, 97,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2be0 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x2bf0 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 67, 65, 76, 76,
/* 0x2c00 */  84, 82, 49, 54, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2c10 */  48, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2c20 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 99, 53,
/* 0x2c30 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2c40 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x2c50 */  89, 10, 32, 49, 50, 32, 67, 84, 49, 54, 73, 50, 56, 54, 32, 32,
/* 0x2c60 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48,
/* 0x2c70 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2c80 */  32, 32, 48, 48, 48, 48, 48, 48,100, 48, 32, 32, 50, 42, 42, 48,
/* 0x2c90 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x2ca0 */  79, 78, 76, 89, 10, 32, 49, 51, 32, 67, 84, 49, 54, 83, 85, 66,
/* 0x2cb0 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32,
/* 0x2cc0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2cd0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,100, 51, 32, 32, 50,
/* 0x2ce0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x2cf0 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 52, 32, 67, 84, 49, 54,
/* 0x2d00 */  73, 48, 56, 54, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2d10 */  48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2d20 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,100, 53,
/* 0x2d30 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2d40 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 53, 32, 67,
/* 0x2d50 */  65, 76, 76, 84, 82, 73, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x2d60 */  48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2d70 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2d80 */  48,100,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2d90 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x2da0 */  79, 78, 76, 89, 10, 32, 49, 54, 32, 67, 84, 49, 54, 69, 56, 48,
/* 0x2db0 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32,
/* 0x2dc0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2dd0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101, 48, 32, 32, 50,
/* 0x2de0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x2df0 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 55, 32, 67, 84, 49, 54,
/* 0x2e00 */  69, 57, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2e10 */  48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2e20 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101, 50,
/* 0x2e30 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2e40 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 56, 32, 67,
/* 0x2e50 */  65, 76, 76, 84, 82, 73, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x2e60 */  48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2e70 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2e80 */  48,101, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2e90 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x2ea0 */  79, 78, 76, 89, 10, 32, 49, 57, 32, 67, 84, 49, 54, 74, 69, 78,
/* 0x2eb0 */  68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32,
/* 0x2ec0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2ed0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101, 97, 32, 32, 50,
/* 0x2ee0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x2ef0 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x2f00 */  50, 48, 32, 67, 84, 49, 54, 74, 85, 76, 50, 32, 32, 32, 32, 32,
/* 0x2f10 */  32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48,
/* 0x2f20 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2f30 */  48, 48, 48, 48, 48,101, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2f40 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x2f50 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 49, 32, 67, 84, 49,
/* 0x2f60 */  54, 73, 50, 56, 55, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2f70 */  48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2f80 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101,
/* 0x2f90 */ 101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2fa0 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 50, 32,
/* 0x2fb0 */  67, 84, 49, 54, 83, 85, 66, 49, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x2fc0 */  48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2fd0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2fe0 */  48, 48,102, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2ff0 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x3000 */  50, 51, 32, 67, 84, 49, 54, 73, 48, 56, 55, 32, 32, 32, 32, 32,
/* 0x3010 */  32, 48, 48, 48, 48, 48, 48, 48, 56, 32, 32, 48, 48, 48, 48, 48,
/* 0x3020 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3030 */  48, 48, 48, 48, 48,102, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3040 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x3050 */  89, 10, 32, 50, 52, 32, 67, 65, 76, 76, 84, 82, 73, 54, 32, 32,
/* 0x3060 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48,
/* 0x3070 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3080 */  32, 32, 48, 48, 48, 48, 48, 48,102, 98, 32, 32, 50, 42, 42, 48,
/* 0x3090 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x30a0 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 53, 32,
/* 0x30b0 */  69, 88, 69, 69, 78, 84, 82, 89, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x30c0 */  48, 48, 48, 48, 49, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x30d0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x30e0 */  48, 48,102,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x30f0 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x3100 */  68, 79, 78, 76, 89, 10, 32, 50, 54, 32, 76, 79, 78, 71, 83, 85,
/* 0x3110 */  66, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54,
/* 0x3120 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3130 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 49, 97, 32, 32,
/* 0x3140 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3150 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3160 */  32, 50, 55, 32, 83, 72, 79, 82, 84, 83, 85, 66, 32, 32, 32, 32,
/* 0x3170 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32, 32, 48, 48, 48, 48,
/* 0x3180 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3190 */  48, 48, 48, 48, 48, 49, 50, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x31a0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x31b0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 56, 32, 74, 78,
/* 0x31c0 */  67, 68, 79, 67, 79, 80, 89, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x31d0 */  48, 48, 48, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x31e0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,
/* 0x31f0 */  50, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3200 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x3210 */  78, 76, 89, 10, 32, 50, 57, 32, 69, 88, 69, 82, 69, 76, 80, 85,
/* 0x3220 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49, 32, 32,
/* 0x3230 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x3240 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 50, 97, 32, 32, 50, 42,
/* 0x3250 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x3260 */  65, 68, 79, 78, 76, 89, 10, 32, 51, 48, 32, 69, 88, 69, 77, 65,
/* 0x3270 */  73, 78, 52, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3280 */  57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x3290 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 50, 98, 32,
/* 0x32a0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x32b0 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x32c0 */  10, 32, 51, 49, 32, 69, 88, 69, 77, 65, 73, 78, 52, 66, 32, 32,
/* 0x32d0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48,
/* 0x32e0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x32f0 */  32, 48, 48, 48, 48, 48, 49, 51, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x3300 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x3310 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 50, 32, 69,
/* 0x3320 */  88, 69, 77, 65, 73, 78, 52, 67, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x3330 */  48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3340 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x3350 */  49, 51, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3360 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51,
/* 0x3370 */  51, 32, 67, 79, 77, 80, 82, 69, 83, 83, 69, 68, 95, 76, 90, 77,
/* 0x3380 */  65, 95, 83, 84, 65, 82, 84, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3390 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x33a0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 51, 57, 32, 32,
/* 0x33b0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x33c0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 52, 32, 85, 80, 88,
/* 0x33d0 */  49, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x33e0 */  48, 49, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x33f0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 51,
/* 0x3400 */  57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3410 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 53, 32,
/* 0x3420 */  69, 88, 69, 67, 85, 84, 80, 79, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x3430 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3440 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3450 */  48, 49, 53, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3460 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x3470 */  51, 54, 32, 78, 82, 86, 50, 66, 49, 54, 83, 32, 32, 32, 32, 32,
/* 0x3480 */  32, 48, 48, 48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48,
/* 0x3490 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x34a0 */  48, 48, 48, 48, 49, 53, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x34b0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x34c0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 55, 32, 78, 50, 66,
/* 0x34d0 */  54, 52, 75, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x34e0 */  48, 48, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x34f0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 54,
/* 0x3500 */  49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3510 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 56, 32,
/* 0x3520 */  78, 82, 86, 50, 66, 69, 88, 49, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x3530 */  48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3540 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3550 */  48, 49, 54, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3560 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x3570 */  68, 79, 78, 76, 89, 10, 32, 51, 57, 32, 78, 50, 66, 88, 56, 54,
/* 0x3580 */  48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 56,
/* 0x3590 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x35a0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 55, 55, 32, 32,
/* 0x35b0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x35c0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 48, 32, 78, 50, 66,
/* 0x35d0 */  50, 56, 54, 48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x35e0 */  48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x35f0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 55,
/* 0x3600 */ 102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3610 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 49, 32,
/* 0x3620 */  78, 82, 86, 50, 66, 69, 88, 50, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x3630 */  48, 48, 48, 48, 51, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3640 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3650 */  48, 49, 56, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3660 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x3670 */  68, 79, 78, 76, 89, 10, 32, 52, 50, 32, 78, 50, 66, 88, 56, 54,
/* 0x3680 */  48, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,101,
/* 0x3690 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x36a0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 98, 51, 32, 32,
/* 0x36b0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x36c0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 51, 32, 78, 50, 66,
/* 0x36d0 */  50, 56, 54, 48, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x36e0 */  48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x36f0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 99,
/* 0x3700 */  49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3710 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 52, 32,
/* 0x3720 */  78, 82, 86, 50, 66, 69, 88, 51, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x3730 */  48, 48, 48, 48, 49, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3740 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3750 */  48, 49, 99, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3760 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x3770 */  68, 79, 78, 76, 89, 10, 32, 52, 53, 32, 78, 50, 66, 54, 52, 75,
/* 0x3780 */  48, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98,
/* 0x3790 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x37a0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,100, 99, 32, 32,
/* 0x37b0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x37c0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 54, 32, 78, 82, 86,
/* 0x37d0 */  50, 66, 69, 88, 57, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x37e0 */  48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x37f0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,101,
/* 0x3800 */  55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3810 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 55, 32,
/* 0x3820 */  78, 82, 86, 50, 68, 49, 54, 83, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x3830 */  48, 48, 48, 48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3840 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3850 */  48, 49,101, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3860 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x3870 */  68, 79, 78, 76, 89, 10, 32, 52, 56, 32, 78, 50, 68, 54, 52, 75,
/* 0x3880 */  48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98,
/* 0x3890 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x38a0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,102, 56, 32, 32,
/* 0x38b0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x38c0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 57, 32, 78, 82, 86,
/* 0x38d0 */  50, 68, 69, 88, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x38e0 */  48, 49, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x38f0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 48,
/* 0x3900 */  51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3910 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x3920 */  76, 89, 10, 32, 53, 48, 32, 78, 50, 68, 88, 56, 54, 48, 49, 32,
/* 0x3930 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48,
/* 0x3940 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3950 */  48, 32, 32, 48, 48, 48, 48, 48, 50, 49, 54, 32, 32, 50, 42, 42,
/* 0x3960 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x3970 */  68, 79, 78, 76, 89, 10, 32, 53, 49, 32, 78, 50, 68, 50, 56, 54,
/* 0x3980 */  48, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51,
/* 0x3990 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x39a0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 49, 99, 32, 32,
/* 0x39b0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x39c0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 50, 32, 78, 82, 86,
/* 0x39d0 */  50, 68, 69, 88, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x39e0 */  48, 51, 57, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x39f0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 49,
/* 0x3a00 */ 102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3a10 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x3a20 */  76, 89, 10, 32, 53, 51, 32, 78, 50, 68, 88, 56, 54, 48, 50, 32,
/* 0x3a30 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,101, 32, 32, 48,
/* 0x3a40 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a50 */  48, 32, 32, 48, 48, 48, 48, 48, 50, 53, 56, 32, 32, 50, 42, 42,
/* 0x3a60 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x3a70 */  68, 79, 78, 76, 89, 10, 32, 53, 52, 32, 78, 50, 68, 50, 56, 54,
/* 0x3a80 */  48, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54,
/* 0x3a90 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3aa0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 54, 54, 32, 32,
/* 0x3ab0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3ac0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 53, 32, 78, 82, 86,
/* 0x3ad0 */  50, 68, 69, 88, 51, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x3ae0 */  48, 49, 53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3af0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 54,
/* 0x3b00 */  99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3b10 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x3b20 */  76, 89, 10, 32, 53, 54, 32, 78, 50, 68, 54, 52, 75, 48, 50, 32,
/* 0x3b30 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48,
/* 0x3b40 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b50 */  48, 32, 32, 48, 48, 48, 48, 48, 50, 56, 49, 32, 32, 50, 42, 42,
/* 0x3b60 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x3b70 */  68, 79, 78, 76, 89, 10, 32, 53, 55, 32, 78, 82, 86, 50, 68, 69,
/* 0x3b80 */  88, 57, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x3b90 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3ba0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 56, 99, 32, 32,
/* 0x3bb0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3bc0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 53, 56, 32, 78, 82, 86,
/* 0x3bd0 */  50, 69, 49, 54, 83, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x3be0 */  48, 48,100, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x3bf0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 57,
/* 0x3c00 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3c10 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x3c20 */  76, 89, 10, 32, 53, 57, 32, 78, 50, 69, 54, 52, 75, 48, 49, 32,
/* 0x3c30 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48,
/* 0x3c40 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c50 */  48, 32, 32, 48, 48, 48, 48, 48, 50, 57,100, 32, 32, 50, 42, 42,
/* 0x3c60 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x3c70 */  68, 79, 78, 76, 89, 10, 32, 54, 48, 32, 78, 82, 86, 50, 69, 69,
/* 0x3c80 */  88, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 51,
/* 0x3c90 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3ca0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 97, 56, 32, 32,
/* 0x3cb0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3cc0 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3cd0 */  32, 54, 49, 32, 78, 50, 69, 88, 56, 54, 48, 49, 32, 32, 32, 32,
/* 0x3ce0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48,
/* 0x3cf0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3d00 */  48, 48, 48, 48, 48, 50, 98, 98, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3d10 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x3d20 */  76, 89, 10, 32, 54, 50, 32, 78, 50, 69, 50, 56, 54, 48, 49, 32,
/* 0x3d30 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 51, 32, 32, 48,
/* 0x3d40 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d50 */  48, 32, 32, 48, 48, 48, 48, 48, 50, 99, 49, 32, 32, 50, 42, 42,
/* 0x3d60 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x3d70 */  68, 79, 78, 76, 89, 10, 32, 54, 51, 32, 78, 82, 86, 50, 69, 69,
/* 0x3d80 */  88, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 51,101,
/* 0x3d90 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3da0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 99, 52, 32, 32,
/* 0x3db0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3dc0 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3dd0 */  32, 54, 52, 32, 78, 50, 69, 88, 56, 54, 48, 50, 32, 32, 32, 32,
/* 0x3de0 */  32, 32, 48, 48, 48, 48, 48, 48, 48,101, 32, 32, 48, 48, 48, 48,
/* 0x3df0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3e00 */  48, 48, 48, 48, 48, 51, 48, 50, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3e10 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x3e20 */  76, 89, 10, 32, 54, 53, 32, 78, 50, 69, 50, 56, 54, 48, 50, 32,
/* 0x3e30 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48,
/* 0x3e40 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e50 */  48, 32, 32, 48, 48, 48, 48, 48, 51, 49, 48, 32, 32, 50, 42, 42,
/* 0x3e60 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x3e70 */  68, 79, 78, 76, 89, 10, 32, 54, 54, 32, 78, 82, 86, 50, 69, 69,
/* 0x3e80 */  88, 51, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 53,
/* 0x3e90 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3ea0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 49, 54, 32, 32,
/* 0x3eb0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3ec0 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3ed0 */  32, 54, 55, 32, 78, 50, 69, 54, 52, 75, 48, 50, 32, 32, 32, 32,
/* 0x3ee0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48, 48,
/* 0x3ef0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3f00 */  48, 48, 48, 48, 48, 51, 50, 98, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3f10 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x3f20 */  76, 89, 10, 32, 54, 56, 32, 78, 82, 86, 50, 69, 69, 88, 57, 32,
/* 0x3f30 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48,
/* 0x3f40 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f50 */  48, 32, 32, 48, 48, 48, 48, 48, 51, 51, 54, 32, 32, 50, 42, 42,
/* 0x3f60 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x3f70 */  68, 79, 78, 76, 89, 10, 32, 54, 57, 32, 76, 90, 77, 65, 95, 68,
/* 0x3f80 */  69, 67, 48, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 51, 50,
/* 0x3f90 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x3fa0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 51, 97, 32, 32,
/* 0x3fb0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x3fc0 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x3fd0 */  32, 55, 48, 32,105,103,110,111,114,101, 95,114,101,108,111, 99,
/* 0x3fe0 */  95,111,118,101,114,102,108,111,119, 32, 48, 48, 48, 48, 48, 48,
/* 0x3ff0 */  48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x4000 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 54, 99,
/* 0x4010 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x4020 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x4030 */  89, 10, 32, 55, 49, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x4040 */  32, 32, 32, 32, 48, 48, 48, 48, 49, 49, 57, 98, 32, 32, 48, 48,
/* 0x4050 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4060 */  32, 32, 48, 48, 48, 48, 48, 51, 55, 52, 32, 32, 50, 42, 42, 48,
/* 0x4070 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x4080 */  79, 78, 76, 89, 10, 32, 55, 50, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x4090 */  67, 50, 48, 32, 32, 32, 32, 48, 48, 48, 48, 49, 50, 50,102, 32,
/* 0x40a0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x40b0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 53, 48,102, 32, 32, 50,
/* 0x40c0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x40d0 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 51, 32, 76, 90, 77, 65,
/* 0x40e0 */  95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x40f0 */  48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x4100 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 50, 55, 51,101,
/* 0x4110 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x4120 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 52, 32, 76,
/* 0x4130 */  90, 77, 65, 95, 68, 69, 67, 51, 49, 32, 32, 32, 32, 48, 48, 48,
/* 0x4140 */  48, 48, 48, 48, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4150 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 50,
/* 0x4160 */  55, 51,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x4170 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x4180 */  79, 78, 76, 89, 10, 32, 55, 53, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x4190 */  67, 51, 50, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32,
/* 0x41a0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x41b0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 50, 55, 52, 98, 32, 32, 50,
/* 0x41c0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x41d0 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x41e0 */  55, 54, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 51, 32, 32, 32,
/* 0x41f0 */  32, 48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48,
/* 0x4200 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x4210 */  48, 48, 48, 50, 55, 53, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x4220 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x4230 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 55, 32, 69, 88, 69,
/* 0x4240 */  77, 65, 73, 78, 53, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x4250 */  48, 48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x4260 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 50, 55, 53,
/* 0x4270 */  55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x4280 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 55, 56, 32,
/* 0x4290 */  69, 88, 69, 65, 68, 74, 85, 83, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x42a0 */  48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x42b0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x42c0 */  50, 55, 53, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x42d0 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x42e0 */  55, 57, 32, 69, 88, 69, 78, 79, 65, 68, 74, 32, 32, 32, 32, 32,
/* 0x42f0 */  32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48,
/* 0x4300 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x4310 */  48, 48, 48, 50, 55, 53,102, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x4320 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x4330 */  89, 10, 32, 56, 48, 32, 69, 88, 69, 82, 69, 76, 79, 49, 32, 32,
/* 0x4340 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49,101, 32, 32, 48, 48,
/* 0x4350 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4360 */  32, 32, 48, 48, 48, 48, 50, 55, 54, 49, 32, 32, 50, 42, 42, 48,
/* 0x4370 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x4380 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 49, 32,
/* 0x4390 */  69, 88, 69, 82, 69, 76, 57, 65, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x43a0 */  48, 48, 48, 48, 49, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x43b0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x43c0 */  50, 55, 55,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x43d0 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x43e0 */  68, 79, 78, 76, 89, 10, 32, 56, 50, 32, 69, 88, 69, 82, 69, 76,
/* 0x43f0 */  79, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x4400 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x4410 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 50, 55, 57, 49, 32, 32,
/* 0x4420 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x4430 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 51, 32, 69, 88, 69,
/* 0x4440 */  82, 69, 66, 73, 71, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x4450 */  48, 48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x4460 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 50, 55, 57,
/* 0x4470 */  53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x4480 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x4490 */  76, 89, 10, 32, 56, 52, 32, 69, 88, 69, 82, 69, 76, 79, 51, 32,
/* 0x44a0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48,
/* 0x44b0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x44c0 */  48, 32, 32, 48, 48, 48, 48, 50, 55, 57, 55, 32, 32, 50, 42, 42,
/* 0x44d0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x44e0 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 53,
/* 0x44f0 */  32, 69, 88, 69, 77, 65, 73, 78, 56, 32, 32, 32, 32, 32, 32, 48,
/* 0x4500 */  48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x4510 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x4520 */  48, 50, 55, 57, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x4530 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x4540 */  32, 56, 54, 32, 68, 69, 86, 73, 67, 69, 69, 78, 68, 32, 32, 32,
/* 0x4550 */  32, 32, 48, 48, 48, 48, 48, 48, 49, 51, 32, 32, 48, 48, 48, 48,
/* 0x4560 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x4570 */  48, 48, 48, 48, 50, 55, 57, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x4580 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x4590 */  76, 89, 10, 32, 56, 55, 32, 69, 88, 69, 83, 84, 65, 67, 75, 32,
/* 0x45a0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 54, 32, 32, 48,
/* 0x45b0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x45c0 */  48, 32, 32, 48, 48, 48, 48, 50, 55, 97,102, 32, 32, 50, 42, 42,
/* 0x45d0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x45e0 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 56, 56,
/* 0x45f0 */  32, 69, 88, 69, 83, 84, 65, 83, 80, 32, 32, 32, 32, 32, 32, 48,
/* 0x4600 */  48, 48, 48, 48, 48, 48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x4610 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x4620 */  48, 50, 55, 98, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x4630 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x4640 */  65, 68, 79, 78, 76, 89, 10, 32, 56, 57, 32, 69, 88, 69, 74, 85,
/* 0x4650 */  77, 80, 70, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x4660 */  53, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x4670 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 50, 55, 98, 56, 32,
/* 0x4680 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x4690 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x46a0 */  10, 32, 57, 48, 32, 69, 88, 69, 82, 67, 83, 80, 79, 32, 32, 32,
/* 0x46b0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48,
/* 0x46c0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x46d0 */  32, 48, 48, 48, 48, 50, 55, 98,100, 32, 32, 50, 42, 42, 48, 32,
/* 0x46e0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x46f0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 57, 49, 32, 69,
/* 0x4700 */  88, 69, 82, 69, 84, 73, 80, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x4710 */  48, 48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4720 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 50,
/* 0x4730 */  55, 99, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x4740 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x4750 */  79, 78, 76, 89, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76,
/* 0x4760 */  69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4770 */  32,100, 32, 32, 68, 69, 86, 73, 67, 69, 69, 78, 84, 82, 89,  9,
/* 0x4780 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 68, 69, 86, 73, 67, 69, 69,
/* 0x4790 */  78, 84, 82, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x47a0 */  32, 32, 32,100, 32, 32, 67, 79, 77, 80, 82, 69, 83, 83, 69, 68,
/* 0x47b0 */  95, 76, 90, 77, 65, 95, 83, 84, 65, 82, 84,  9, 48, 48, 48, 48,
/* 0x47c0 */  48, 48, 48, 48, 32, 67, 79, 77, 80, 82, 69, 83, 83, 69, 68, 95,
/* 0x47d0 */  76, 90, 77, 65, 95, 83, 84, 65, 82, 84, 10, 48, 48, 48, 48, 48,
/* 0x47e0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50,
/* 0x47f0 */  66, 49, 54, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82,
/* 0x4800 */  86, 50, 66, 49, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4810 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50,
/* 0x4820 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 68, 69, 67,
/* 0x4830 */  79, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4840 */  32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 54,  9, 48, 48, 48,
/* 0x4850 */  48, 48, 48, 48, 48, 32, 67, 65, 76, 76, 84, 82, 49, 54, 10, 48,
/* 0x4860 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4870 */  67, 65, 76, 76, 84, 82, 73, 53,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x4880 */  48, 32, 67, 65, 76, 76, 84, 82, 73, 53, 10, 48, 48, 48, 48, 48,
/* 0x4890 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76,
/* 0x48a0 */  84, 82, 73, 54,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 65,
/* 0x48b0 */  76, 76, 84, 82, 73, 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x48c0 */ 108, 32, 32, 32, 32,100, 32, 32, 69, 88, 69, 69, 78, 84, 82, 89,
/* 0x48d0 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 88, 69, 69, 78, 84,
/* 0x48e0 */  82, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x48f0 */  32,100, 32, 32, 78, 82, 86, 50, 66, 49, 54, 83,  9, 48, 48, 48,
/* 0x4900 */  48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 66, 49, 54, 83, 10, 48,
/* 0x4910 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4920 */  78, 82, 86, 50, 66, 69, 88, 50,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x4930 */  48, 32, 78, 82, 86, 50, 66, 69, 88, 50, 10, 48, 48, 48, 48, 48,
/* 0x4940 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50,
/* 0x4950 */  66, 69, 88, 51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82,
/* 0x4960 */  86, 50, 66, 69, 88, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4970 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66, 69, 88, 57,
/* 0x4980 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 66, 69,
/* 0x4990 */  88, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x49a0 */  32,100, 32, 32, 78, 82, 86, 50, 68, 49, 54, 83,  9, 48, 48, 48,
/* 0x49b0 */  48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 68, 49, 54, 83, 10, 48,
/* 0x49c0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x49d0 */  78, 82, 86, 50, 68, 69, 88, 50,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x49e0 */  48, 32, 78, 82, 86, 50, 68, 69, 88, 50, 10, 48, 48, 48, 48, 48,
/* 0x49f0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50,
/* 0x4a00 */  68, 69, 88, 51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82,
/* 0x4a10 */  86, 50, 68, 69, 88, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4a20 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68, 69, 88, 57,
/* 0x4a30 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 68, 69,
/* 0x4a40 */  88, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4a50 */  32,100, 32, 32, 78, 82, 86, 50, 69, 49, 54, 83,  9, 48, 48, 48,
/* 0x4a60 */  48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 69, 49, 54, 83, 10, 48,
/* 0x4a70 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4a80 */  78, 82, 86, 50, 69, 69, 88, 50,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x4a90 */  48, 32, 78, 82, 86, 50, 69, 69, 88, 50, 10, 48, 48, 48, 48, 48,
/* 0x4aa0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50,
/* 0x4ab0 */  69, 69, 88, 51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82,
/* 0x4ac0 */  86, 50, 69, 69, 88, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4ad0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69, 69, 88, 57,
/* 0x4ae0 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 69, 69,
/* 0x4af0 */  88, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4b00 */  32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48,  9, 48,
/* 0x4b10 */  48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x4b20 */  48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4b30 */  32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 50,  9, 48,
/* 0x4b40 */  48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x4b50 */  51, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4b60 */  32,100, 32, 32, 69, 88, 69, 82, 69, 76, 79, 49,  9, 48, 48, 48,
/* 0x4b70 */  48, 48, 48, 48, 48, 32, 69, 88, 69, 82, 69, 76, 79, 49, 10, 48,
/* 0x4b80 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4b90 */  69, 88, 69, 82, 69, 76, 79, 50,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ba0 */  48, 32, 69, 88, 69, 82, 69, 76, 79, 50, 10, 48, 48, 48, 48, 48,
/* 0x4bb0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x4bc0 */  68, 69, 86, 73, 67, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4bd0 */  76, 90, 77, 65, 68, 69, 86, 73, 67, 69, 10, 48, 48, 48, 48, 48,
/* 0x4be0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 68, 69, 86, 73,
/* 0x4bf0 */  67, 69, 69, 78, 84, 82, 89, 50,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c00 */  48, 32, 68, 69, 86, 73, 67, 69, 69, 78, 84, 82, 89, 50, 10, 48,
/* 0x4c10 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4c20 */  76, 90, 77, 65, 69, 78, 84, 82, 89,  9, 48, 48, 48, 48, 48, 48,
/* 0x4c30 */  48, 48, 32, 76, 90, 77, 65, 69, 78, 84, 82, 89, 10, 48, 48, 48,
/* 0x4c40 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82,
/* 0x4c50 */  86, 68, 68, 79, 78, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4c60 */  78, 82, 86, 68, 68, 79, 78, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c70 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 68, 82, 69,
/* 0x4c80 */  84, 85,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 68,
/* 0x4c90 */  82, 69, 84, 85, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4ca0 */  32, 32, 32,100, 32, 32, 78, 82, 86, 68, 69, 67, 79, 49,  9, 48,
/* 0x4cb0 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 68, 69, 67, 79, 49,
/* 0x4cc0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4cd0 */  32, 32, 78, 82, 86, 76, 69, 68, 48, 48,  9, 48, 48, 48, 48, 48,
/* 0x4ce0 */  48, 48, 48, 32, 78, 82, 86, 76, 69, 68, 48, 48, 10, 48, 48, 48,
/* 0x4cf0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82,
/* 0x4d00 */  86, 71, 84, 68, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4d10 */  78, 82, 86, 71, 84, 68, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d20 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 73, 50,
/* 0x4d30 */  56, 54,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54,
/* 0x4d40 */  73, 50, 56, 54, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4d50 */  32, 32, 32,100, 32, 32, 67, 84, 49, 54, 83, 85, 66, 48,  9, 48,
/* 0x4d60 */  48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54, 83, 85, 66, 48,
/* 0x4d70 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4d80 */  32, 32, 67, 84, 49, 54, 73, 48, 56, 54,  9, 48, 48, 48, 48, 48,
/* 0x4d90 */  48, 48, 48, 32, 67, 84, 49, 54, 73, 48, 56, 54, 10, 48, 48, 48,
/* 0x4da0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65,
/* 0x4db0 */  76, 76, 84, 82, 73, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4dc0 */  67, 65, 76, 76, 84, 82, 73, 50, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4dd0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 69, 56,
/* 0x4de0 */  48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54,
/* 0x4df0 */  69, 56, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4e00 */  32, 32, 32,100, 32, 32, 67, 84, 49, 54, 69, 57, 48, 48,  9, 48,
/* 0x4e10 */  48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54, 69, 57, 48, 48,
/* 0x4e20 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4e30 */  32, 32, 67, 84, 49, 54, 74, 69, 78, 68,  9, 48, 48, 48, 48, 48,
/* 0x4e40 */  48, 48, 48, 32, 67, 84, 49, 54, 74, 69, 78, 68, 10, 48, 48, 48,
/* 0x4e50 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,
/* 0x4e60 */  49, 54, 74, 85, 76, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4e70 */  67, 84, 49, 54, 74, 85, 76, 50, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4e80 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 49, 54, 73, 50,
/* 0x4e90 */  56, 55,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54,
/* 0x4ea0 */  73, 50, 56, 55, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x4eb0 */  32, 32, 32,100, 32, 32, 67, 84, 49, 54, 83, 85, 66, 49,  9, 48,
/* 0x4ec0 */  48, 48, 48, 48, 48, 48, 48, 32, 67, 84, 49, 54, 83, 85, 66, 49,
/* 0x4ed0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4ee0 */  32, 32, 67, 84, 49, 54, 73, 48, 56, 55,  9, 48, 48, 48, 48, 48,
/* 0x4ef0 */  48, 48, 48, 32, 67, 84, 49, 54, 73, 48, 56, 55, 10, 48, 48, 48,
/* 0x4f00 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 79,
/* 0x4f10 */  78, 71, 83, 85, 66,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,
/* 0x4f20 */  79, 78, 71, 83, 85, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4f30 */ 108, 32, 32, 32, 32,100, 32, 32, 83, 72, 79, 82, 84, 83, 85, 66,
/* 0x4f40 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 83, 72, 79, 82, 84, 83,
/* 0x4f50 */  85, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4f60 */  32,100, 32, 32, 74, 78, 67, 68, 79, 67, 79, 80, 89,  9, 48, 48,
/* 0x4f70 */  48, 48, 48, 48, 48, 48, 32, 74, 78, 67, 68, 79, 67, 79, 80, 89,
/* 0x4f80 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4f90 */  32, 32, 69, 88, 69, 82, 69, 76, 80, 85,  9, 48, 48, 48, 48, 48,
/* 0x4fa0 */  48, 48, 48, 32, 69, 88, 69, 82, 69, 76, 80, 85, 10, 48, 48, 48,
/* 0x4fb0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 88,
/* 0x4fc0 */  69, 77, 65, 73, 78, 52,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4fd0 */  69, 88, 69, 77, 65, 73, 78, 52, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4fe0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 88, 69, 77, 65, 73,
/* 0x4ff0 */  78, 52, 66,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 88, 69,
/* 0x5000 */  77, 65, 73, 78, 52, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5010 */ 108, 32, 32, 32, 32,100, 32, 32, 69, 88, 69, 77, 65, 73, 78, 52,
/* 0x5020 */  67,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 88, 69, 77, 65,
/* 0x5030 */  73, 78, 52, 67, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x5040 */  32, 32, 32,100, 32, 32, 85, 80, 88, 49, 72, 69, 65, 68,  9, 48,
/* 0x5050 */  48, 48, 48, 48, 48, 48, 48, 32, 85, 80, 88, 49, 72, 69, 65, 68,
/* 0x5060 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x5070 */  32, 32, 69, 88, 69, 67, 85, 84, 80, 79,  9, 48, 48, 48, 48, 48,
/* 0x5080 */  48, 48, 48, 32, 69, 88, 69, 67, 85, 84, 80, 79, 10, 48, 48, 48,
/* 0x5090 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x50a0 */  66, 54, 52, 75, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x50b0 */  78, 50, 66, 54, 52, 75, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x50c0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66, 69,
/* 0x50d0 */  88, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50,
/* 0x50e0 */  66, 69, 88, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x50f0 */  32, 32, 32,100, 32, 32, 78, 50, 66, 88, 56, 54, 48, 49,  9, 48,
/* 0x5100 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 88, 56, 54, 48, 49,
/* 0x5110 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x5120 */  32, 32, 78, 50, 66, 50, 56, 54, 48, 49,  9, 48, 48, 48, 48, 48,
/* 0x5130 */  48, 48, 48, 32, 78, 50, 66, 50, 56, 54, 48, 49, 10, 48, 48, 48,
/* 0x5140 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x5150 */  66, 88, 56, 54, 48, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5160 */  78, 50, 66, 88, 56, 54, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5170 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 50, 56, 54,
/* 0x5180 */  48, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 50,
/* 0x5190 */  56, 54, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x51a0 */  32, 32, 32,100, 32, 32, 78, 50, 66, 54, 52, 75, 48, 50,  9, 48,
/* 0x51b0 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 66, 54, 52, 75, 48, 50,
/* 0x51c0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x51d0 */  32, 32, 78, 50, 68, 54, 52, 75, 48, 49,  9, 48, 48, 48, 48, 48,
/* 0x51e0 */  48, 48, 48, 32, 78, 50, 68, 54, 52, 75, 48, 49, 10, 48, 48, 48,
/* 0x51f0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82,
/* 0x5200 */  86, 50, 68, 69, 88, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5210 */  78, 82, 86, 50, 68, 69, 88, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5220 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 88, 56, 54,
/* 0x5230 */  48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 88,
/* 0x5240 */  56, 54, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x5250 */  32, 32, 32,100, 32, 32, 78, 50, 68, 50, 56, 54, 48, 49,  9, 48,
/* 0x5260 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 50, 56, 54, 48, 49,
/* 0x5270 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x5280 */  32, 32, 78, 50, 68, 88, 56, 54, 48, 50,  9, 48, 48, 48, 48, 48,
/* 0x5290 */  48, 48, 48, 32, 78, 50, 68, 88, 56, 54, 48, 50, 10, 48, 48, 48,
/* 0x52a0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x52b0 */  68, 50, 56, 54, 48, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x52c0 */  78, 50, 68, 50, 56, 54, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x52d0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 54, 52, 75,
/* 0x52e0 */  48, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 68, 54,
/* 0x52f0 */  52, 75, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x5300 */  32, 32, 32,100, 32, 32, 78, 50, 69, 54, 52, 75, 48, 49,  9, 48,
/* 0x5310 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 54, 52, 75, 48, 49,
/* 0x5320 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x5330 */  32, 32, 78, 82, 86, 50, 69, 69, 88, 49,  9, 48, 48, 48, 48, 48,
/* 0x5340 */  48, 48, 48, 32, 78, 82, 86, 50, 69, 69, 88, 49, 10, 48, 48, 48,
/* 0x5350 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x5360 */  69, 88, 56, 54, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5370 */  78, 50, 69, 88, 56, 54, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5380 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 50, 56, 54,
/* 0x5390 */  48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 50,
/* 0x53a0 */  56, 54, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x53b0 */  32, 32, 32,100, 32, 32, 78, 50, 69, 88, 56, 54, 48, 50,  9, 48,
/* 0x53c0 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 50, 69, 88, 56, 54, 48, 50,
/* 0x53d0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x53e0 */  32, 32, 78, 50, 69, 50, 56, 54, 48, 50,  9, 48, 48, 48, 48, 48,
/* 0x53f0 */  48, 48, 48, 32, 78, 50, 69, 50, 56, 54, 48, 50, 10, 48, 48, 48,
/* 0x5400 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x5410 */  69, 54, 52, 75, 48, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5420 */  78, 50, 69, 54, 52, 75, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5430 */  48, 32,108, 32, 32, 32, 32,100, 32, 32,105,103,110,111,114,101,
/* 0x5440 */  95,114,101,108,111, 99, 95,111,118,101,114,102,108,111,119,  9,
/* 0x5450 */  48, 48, 48, 48, 48, 48, 48, 48, 32,105,103,110,111,114,101, 95,
/* 0x5460 */ 114,101,108,111, 99, 95,111,118,101,114,102,108,111,119, 10, 48,
/* 0x5470 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x5480 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48,
/* 0x5490 */  48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x54a0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x54b0 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48,
/* 0x54c0 */  48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x54d0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x54e0 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48, 48,
/* 0x54f0 */  48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48,
/* 0x5500 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x5510 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 49,  9, 48, 48, 48, 48, 48,
/* 0x5520 */  48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 49, 10, 48,
/* 0x5530 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x5540 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 51,  9, 48, 48, 48, 48, 48,
/* 0x5550 */  48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 51, 10, 48,
/* 0x5560 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x5570 */  69, 88, 69, 77, 65, 73, 78, 53,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x5580 */  48, 32, 69, 88, 69, 77, 65, 73, 78, 53, 10, 48, 48, 48, 48, 48,
/* 0x5590 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 88, 69, 65,
/* 0x55a0 */  68, 74, 85, 83,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 88,
/* 0x55b0 */  69, 65, 68, 74, 85, 83, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x55c0 */ 108, 32, 32, 32, 32,100, 32, 32, 69, 88, 69, 78, 79, 65, 68, 74,
/* 0x55d0 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 88, 69, 78, 79, 65,
/* 0x55e0 */  68, 74, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x55f0 */  32,100, 32, 32, 69, 88, 69, 82, 69, 76, 57, 65,  9, 48, 48, 48,
/* 0x5600 */  48, 48, 48, 48, 48, 32, 69, 88, 69, 82, 69, 76, 57, 65, 10, 48,
/* 0x5610 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x5620 */  69, 88, 69, 82, 69, 66, 73, 71,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x5630 */  48, 32, 69, 88, 69, 82, 69, 66, 73, 71, 10, 48, 48, 48, 48, 48,
/* 0x5640 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 88, 69, 82,
/* 0x5650 */  69, 76, 79, 51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 88,
/* 0x5660 */  69, 82, 69, 76, 79, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5670 */ 108, 32, 32, 32, 32,100, 32, 32, 69, 88, 69, 77, 65, 73, 78, 56,
/* 0x5680 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 88, 69, 77, 65, 73,
/* 0x5690 */  78, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x56a0 */  32,100, 32, 32, 68, 69, 86, 73, 67, 69, 69, 78, 68,  9, 48, 48,
/* 0x56b0 */  48, 48, 48, 48, 48, 48, 32, 68, 69, 86, 73, 67, 69, 69, 78, 68,
/* 0x56c0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x56d0 */  32, 32, 69, 88, 69, 83, 84, 65, 67, 75,  9, 48, 48, 48, 48, 48,
/* 0x56e0 */  48, 48, 48, 32, 69, 88, 69, 83, 84, 65, 67, 75, 10, 48, 48, 48,
/* 0x56f0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 88,
/* 0x5700 */  69, 83, 84, 65, 83, 80,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x5710 */  69, 88, 69, 83, 84, 65, 83, 80, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5720 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 88, 69, 74, 85, 77,
/* 0x5730 */  80, 70,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 88, 69, 74,
/* 0x5740 */  85, 77, 80, 70, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x5750 */  32, 32, 32,100, 32, 32, 69, 88, 69, 82, 67, 83, 80, 79,  9, 48,
/* 0x5760 */  48, 48, 48, 48, 48, 48, 48, 32, 69, 88, 69, 82, 67, 83, 80, 79,
/* 0x5770 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x5780 */  32, 32, 69, 88, 69, 82, 69, 84, 73, 80,  9, 48, 48, 48, 48, 48,
/* 0x5790 */  48, 48, 48, 32, 69, 88, 69, 82, 69, 84, 73, 80, 10, 48, 48, 48,
/* 0x57a0 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x57b0 */  78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 97,116,116,
/* 0x57c0 */ 114,105, 98,117,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x57d0 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,
/* 0x57e0 */  48, 48, 48, 48, 48, 48, 32,105,110,116,101,114,114,117,112,116,
/* 0x57f0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x5800 */  32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5810 */  32,111,114,105,103, 95,115,116,114, 97,116,101,103,121, 10, 48,
/* 0x5820 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5830 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,101,
/* 0x5840 */ 120,101, 95,115,116, 97, 99,107, 95,115,115, 10, 48, 48, 48, 48,
/* 0x5850 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x5860 */  68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,101,120,101, 95,
/* 0x5870 */ 115,116, 97, 99,107, 95,115,112, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5880 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,
/* 0x5890 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 99, 97,108,108,116,114,105,
/* 0x58a0 */  99,107, 95, 99, 97,108,108,115, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x58b0 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,
/* 0x58c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,119,111,114,100,115, 95,116,
/* 0x58d0 */ 111, 95, 99,111,112,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x58e0 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,
/* 0x58f0 */  48, 48, 48, 48, 48, 48, 32, 99,111,112,121, 95,111,102,102,115,
/* 0x5900 */ 101,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x5910 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x5920 */  48, 48, 32,115,111,117,114, 99,101, 95,115,101,103,109,101,110,
/* 0x5930 */ 116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x5940 */  32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x5950 */  48, 32,100,101,115,116,105,110, 97,116,105,111,110, 95,115,101,
/* 0x5960 */ 103,109,101,110,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x5970 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,
/* 0x5980 */  48, 48, 48, 48, 48, 32,100,101, 99,111,109,112,114,101,115,115,
/* 0x5990 */ 111,114, 95,101,110,116,114,121, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x59a0 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,
/* 0x59b0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 98,120, 95,109, 97,103,105,
/* 0x59c0 */  99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x59d0 */  32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x59e0 */  48, 32,108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,
/* 0x59f0 */ 117,115,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x5a00 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,
/* 0x5a10 */  48, 48, 48, 32,108,122,109, 97, 95,117, 95,108,101,110, 95,104,
/* 0x5a20 */ 105, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x5a30 */  32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x5a40 */  48, 32,108,122,109, 97, 95,117, 95,108,101,110, 10, 48, 48, 48,
/* 0x5a50 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x5a60 */  78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109,
/* 0x5a70 */  97, 95, 99, 95,108,101,110, 95,104,105, 10, 48, 48, 48, 48, 48,
/* 0x5a80 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x5a90 */  42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,122,109, 97, 95,
/* 0x5aa0 */  99, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x5ab0 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,
/* 0x5ac0 */  48, 48, 48, 48, 48, 32,108,122,109, 97, 95,112,114,111,112,101,
/* 0x5ad0 */ 114,116,105,101,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x5ae0 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,
/* 0x5af0 */  48, 48, 48, 48, 48, 32,108,122,109, 97, 95,112,114,111,112,101,
/* 0x5b00 */ 114,116,105,101,115, 95,104,105, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5b10 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,
/* 0x5b20 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 99,108,101, 97,114, 95,100,
/* 0x5b30 */ 105,114,116,121, 95,115,116, 97, 99,107, 95,108,111,119, 10, 48,
/* 0x5b40 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5b50 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x5b60 */ 122,109, 97, 95,117, 95,108,101,110, 95,115,101,103,109,101,110,
/* 0x5b70 */ 116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x5b80 */  32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x5b90 */  48, 32,114,101,108,111, 99, 95,115,105,122,101, 10, 48, 48, 48,
/* 0x5ba0 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x5bb0 */  78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,111,114,105,
/* 0x5bc0 */ 103,105,110, 97,108, 95,115,115, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5bd0 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,
/* 0x5be0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,111,114,105,103,105,110, 97,
/* 0x5bf0 */ 108, 95,115,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x5c00 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,
/* 0x5c10 */  48, 48, 48, 48, 32,111,114,105,103,105,110, 97,108, 95,105,112,
/* 0x5c20 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x5c30 */  32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5c40 */  32,111,114,105,103,105,110, 97,108, 95, 99,115, 10, 10, 82, 69,
/* 0x5c50 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x5c60 */  32, 70, 79, 82, 32, 91, 68, 69, 86, 73, 67, 69, 69, 78, 84, 82,
/* 0x5c70 */  89, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x5c80 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x5c90 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95,
/* 0x5ca0 */  51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5cb0 */  97,116,116,114,105, 98,117,116,101, 10, 48, 48, 48, 48, 48, 48,
/* 0x5cc0 */  48, 54, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32,
/* 0x5cd0 */  32, 32, 32, 32, 32, 68, 69, 86, 73, 67, 69, 69, 78, 84, 82, 89,
/* 0x5ce0 */  10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95,
/* 0x5cf0 */  49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,105,110,116,101,
/* 0x5d00 */ 114,114,117,112,116, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82,
/* 0x5d10 */  95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5d20 */  32,111,114,105,103, 95,115,116,114, 97,116,101,103,121, 10, 48,
/* 0x5d30 */  48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 51, 56, 54, 95, 49, 54,
/* 0x5d40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 68, 69, 86, 73, 67, 69,
/* 0x5d50 */  69, 78, 84, 82, 89, 10, 48, 48, 48, 48, 48, 48, 49, 57, 32, 82,
/* 0x5d60 */  95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5d70 */  32,101,120,101, 95,115,116, 97, 99,107, 95,115,115, 10, 48, 48,
/* 0x5d80 */  48, 48, 48, 48, 49, 99, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32,
/* 0x5d90 */  32, 32, 32, 32, 32, 32, 32, 32, 32,101,120,101, 95,115,116, 97,
/* 0x5da0 */  99,107, 95,115,112, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x5db0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76,
/* 0x5dc0 */  90, 77, 65, 68, 69, 86, 73, 67, 69, 93, 58, 10, 79, 70, 70, 83,
/* 0x5dd0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5de0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5df0 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32,
/* 0x5e00 */  32, 32, 32, 32, 32, 32, 32, 32,101,120,101, 95,115,116, 97, 99,
/* 0x5e10 */ 107, 95,115,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x5e20 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90,
/* 0x5e30 */  77, 65, 69, 78, 84, 82, 89, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x5e40 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5e50 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x5e60 */  48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32,
/* 0x5e70 */  32, 32, 32, 32, 32, 32, 67, 79, 77, 80, 82, 69, 83, 83, 69, 68,
/* 0x5e80 */  95, 76, 90, 77, 65, 95, 83, 84, 65, 82, 84, 10, 10, 82, 69, 76,
/* 0x5e90 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x5ea0 */  70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 49, 54, 48, 93, 58, 10,
/* 0x5eb0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x5ec0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x5ed0 */  10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95,
/* 0x5ee0 */  80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68,
/* 0x5ef0 */  69, 67, 79, 50, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95,
/* 0x5f00 */  51, 56, 54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5f10 */  78, 82, 86, 68, 69, 67, 79, 50, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x5f20 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x5f30 */  32, 91, 78, 82, 86, 68, 68, 79, 78, 69, 93, 58, 10, 79, 70, 70,
/* 0x5f40 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x5f50 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x5f60 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x5f70 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 68, 69, 67, 79,
/* 0x5f80 */  50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x5f90 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 68, 82,
/* 0x5fa0 */  69, 84, 85, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x5fb0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5fc0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x5fd0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5fe0 */  32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10, 10, 82, 69, 76, 79,
/* 0x5ff0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x6000 */  79, 82, 32, 91, 78, 82, 86, 68, 69, 67, 79, 49, 93, 58, 10, 79,
/* 0x6010 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x6020 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x6030 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x6040 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66,
/* 0x6050 */  49, 54, 48, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 51,
/* 0x6060 */  56, 54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x6070 */  82, 86, 68, 69, 67, 79, 50, 10, 48, 48, 48, 48, 48, 48, 49, 56,
/* 0x6080 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32,
/* 0x6090 */  32, 32, 32, 78, 82, 86, 68, 69, 67, 79, 50, 10, 10, 82, 69, 76,
/* 0x60a0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x60b0 */  70, 79, 82, 32, 91, 78, 82, 86, 68, 69, 67, 79, 50, 93, 58, 10,
/* 0x60c0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x60d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x60e0 */  10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95,
/* 0x60f0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x6100 */  66, 49, 54, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x6110 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65,
/* 0x6120 */  76, 76, 84, 82, 49, 54, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x6130 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6140 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x6150 */  48, 50, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32,
/* 0x6160 */  32, 32, 32, 32, 32, 99, 97,108,108,116,114,105, 99,107, 95, 99,
/* 0x6170 */  97,108,108,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x6180 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65,
/* 0x6190 */  76, 76, 84, 82, 73, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x61a0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x61b0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x61c0 */  48, 50, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x61d0 */  32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 54, 10, 10, 82,
/* 0x61e0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x61f0 */  83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 73, 53, 93,
/* 0x6200 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x6210 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x6220 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56,
/* 0x6230 */  54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99, 97,
/* 0x6240 */ 108,108,116,114,105, 99,107, 95, 99, 97,108,108,115, 10, 10, 82,
/* 0x6250 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x6260 */  83, 32, 70, 79, 82, 32, 91, 67, 84, 49, 54, 74, 69, 78, 68, 93,
/* 0x6270 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x6280 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x6290 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56,
/* 0x62a0 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x62b0 */  86, 68, 69, 67, 79, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x62c0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x62d0 */  67, 84, 49, 54, 74, 85, 76, 50, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x62e0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x62f0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x6300 */  48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x6310 */  32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 73, 54, 10,
/* 0x6320 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x6330 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 73,
/* 0x6340 */  54, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x6350 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x6360 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95,
/* 0x6370 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6380 */  67, 65, 76, 76, 84, 82, 73, 53, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x6390 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x63a0 */  32, 91, 69, 88, 69, 69, 78, 84, 82, 89, 93, 58, 10, 79, 70, 70,
/* 0x63b0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x63c0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x63d0 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32,
/* 0x63e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32,119,111,114,100,115, 95,116,
/* 0x63f0 */ 111, 95, 99,111,112,121, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32,
/* 0x6400 */  82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6410 */  32, 32, 99,111,112,121, 95,111,102,102,115,101,116, 10, 48, 48,
/* 0x6420 */  48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32,
/* 0x6430 */  32, 32, 32, 32, 32, 32, 32, 32, 32,115,111,117,114, 99,101, 95,
/* 0x6440 */ 115,101,103,109,101,110,116, 10, 48, 48, 48, 48, 48, 48, 49, 52,
/* 0x6450 */  32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32,
/* 0x6460 */  32, 32, 32,100,101,115,116,105,110, 97,116,105,111,110, 95,115,
/* 0x6470 */ 101,103,109,101,110,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x6480 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x6490 */  76, 79, 78, 71, 83, 85, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x64a0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x64b0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x64c0 */  48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32,
/* 0x64d0 */  32, 32, 32, 32, 32, 32, 69, 88, 69, 69, 78, 84, 82, 89, 10, 10,
/* 0x64e0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x64f0 */  68, 83, 32, 70, 79, 82, 32, 91, 83, 72, 79, 82, 84, 83, 85, 66,
/* 0x6500 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x6510 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x6520 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51,
/* 0x6530 */  56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x6540 */  88, 69, 69, 78, 84, 82, 89, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x6550 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x6560 */  91, 74, 78, 67, 68, 79, 67, 79, 80, 89, 93, 58, 10, 79, 70, 70,
/* 0x6570 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x6580 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x6590 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x65a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 69, 88, 69, 69, 78, 84, 82,
/* 0x65b0 */  89, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x65c0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 88, 69, 77, 65,
/* 0x65d0 */  73, 78, 52, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x65e0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x65f0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 55, 32,
/* 0x6600 */  82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6610 */  32, 32,100,101, 99,111,109,112,114,101,115,115,111,114, 95,101,
/* 0x6620 */ 110,116,114,121, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x6630 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 88,
/* 0x6640 */  69, 77, 65, 73, 78, 52, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x6650 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6660 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x6670 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32,
/* 0x6680 */  32, 32, 32, 32, 32, 32, 98,120, 95,109, 97,103,105, 99, 10, 10,
/* 0x6690 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x66a0 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 49, 54, 83,
/* 0x66b0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x66c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x66d0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51,
/* 0x66e0 */  56, 54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x66f0 */  82, 86, 50, 66, 69, 88, 51, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x6700 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x6710 */  91, 78, 82, 86, 50, 66, 69, 88, 49, 93, 58, 10, 79, 70, 70, 83,
/* 0x6720 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x6730 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x6740 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54,
/* 0x6750 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 69, 88, 51,
/* 0x6760 */  10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95,
/* 0x6770 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x6780 */  66, 69, 88, 57, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95,
/* 0x6790 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x67a0 */  78, 82, 86, 50, 66, 69, 88, 50, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x67b0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x67c0 */  32, 91, 78, 82, 86, 50, 66, 69, 88, 50, 93, 58, 10, 79, 70, 70,
/* 0x67d0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x67e0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x67f0 */  48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49,
/* 0x6800 */  54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 69, 88,
/* 0x6810 */  51, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54,
/* 0x6820 */  95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x6830 */  50, 66, 69, 88, 51, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82,
/* 0x6840 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6850 */  32, 78, 82, 86, 50, 66, 49, 54, 83, 10, 10, 82, 69, 76, 79, 67,
/* 0x6860 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x6870 */  82, 32, 91, 78, 82, 86, 50, 66, 69, 88, 51, 93, 58, 10, 79, 70,
/* 0x6880 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x6890 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x68a0 */  48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x68b0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 69,
/* 0x68c0 */  88, 50, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56,
/* 0x68d0 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x68e0 */  86, 50, 66, 69, 88, 57, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x68f0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x6900 */  78, 82, 86, 50, 68, 49, 54, 83, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x6910 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6920 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x6930 */  48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32,
/* 0x6940 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 69, 88, 51, 10,
/* 0x6950 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x6960 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 69, 88,
/* 0x6970 */  49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x6980 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x6990 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,
/* 0x69a0 */  51, 56, 54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x69b0 */  78, 82, 86, 50, 68, 69, 88, 51, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x69c0 */  55, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32, 32, 32, 32,
/* 0x69d0 */  32, 32, 32, 32, 78, 82, 86, 50, 68, 69, 88, 51, 10, 48, 48, 48,
/* 0x69e0 */  48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x69f0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 69, 88, 57,
/* 0x6a00 */  10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95,
/* 0x6a10 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x6a20 */  68, 69, 88, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x6a30 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82,
/* 0x6a40 */  86, 50, 68, 69, 88, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x6a50 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6a60 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x6a70 */  48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32, 32, 32,
/* 0x6a80 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 69, 88, 51, 10, 48, 48,
/* 0x6a90 */  48, 48, 48, 48, 49, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49,
/* 0x6aa0 */  54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 69, 88,
/* 0x6ab0 */  51, 10, 48, 48, 48, 48, 48, 48, 49, 98, 32, 82, 95, 51, 56, 54,
/* 0x6ac0 */  95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x6ad0 */  50, 68, 69, 88, 51, 10, 48, 48, 48, 48, 48, 48, 51, 56, 32, 82,
/* 0x6ae0 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6af0 */  32, 78, 82, 86, 50, 68, 49, 54, 83, 10, 10, 82, 69, 76, 79, 67,
/* 0x6b00 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x6b10 */  82, 32, 91, 78, 82, 86, 50, 68, 69, 88, 51, 93, 58, 10, 79, 70,
/* 0x6b20 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x6b30 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x6b40 */  48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x6b50 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 69,
/* 0x6b60 */  88, 50, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56,
/* 0x6b70 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x6b80 */  86, 50, 68, 69, 88, 57, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x6b90 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x6ba0 */  78, 82, 86, 50, 69, 49, 54, 83, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x6bb0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6bc0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x6bd0 */  48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32,
/* 0x6be0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 69, 88, 51, 10,
/* 0x6bf0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x6c00 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69, 69, 88,
/* 0x6c10 */  49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x6c20 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x6c30 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95,
/* 0x6c40 */  51, 56, 54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6c50 */  78, 82, 86, 50, 69, 69, 88, 51, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x6c60 */  55, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32, 32, 32, 32,
/* 0x6c70 */  32, 32, 32, 32, 78, 82, 86, 50, 69, 69, 88, 51, 10, 48, 48, 48,
/* 0x6c80 */  48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x6c90 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 69, 88, 57,
/* 0x6ca0 */  10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95,
/* 0x6cb0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x6cc0 */  69, 69, 88, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x6cd0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82,
/* 0x6ce0 */  86, 50, 69, 69, 88, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x6cf0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6d00 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x6d10 */  48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49, 54, 32, 32, 32,
/* 0x6d20 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 69, 88, 51, 10, 48, 48,
/* 0x6d30 */  48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 49,
/* 0x6d40 */  54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 69, 88,
/* 0x6d50 */  51, 10, 48, 48, 48, 48, 48, 48, 49, 98, 32, 82, 95, 51, 56, 54,
/* 0x6d60 */  95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x6d70 */  50, 69, 69, 88, 51, 10, 48, 48, 48, 48, 48, 48, 50, 48, 32, 82,
/* 0x6d80 */  95, 51, 56, 54, 95, 80, 67, 49, 54, 32, 32, 32, 32, 32, 32, 32,
/* 0x6d90 */  32, 78, 82, 86, 50, 69, 69, 88, 51, 10, 48, 48, 48, 48, 48, 48,
/* 0x6da0 */  51,100, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x6db0 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 49, 54, 83, 10, 10, 82,
/* 0x6dc0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x6dd0 */  83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69, 69, 88, 51, 93,
/* 0x6de0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x6df0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x6e00 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56,
/* 0x6e10 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x6e20 */  86, 50, 69, 69, 88, 50, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32,
/* 0x6e30 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x6e40 */  32, 32, 78, 82, 86, 50, 69, 69, 88, 57, 10, 10, 82, 69, 76, 79,
/* 0x6e50 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x6e60 */  79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 93, 58,
/* 0x6e70 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x6e80 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x6e90 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54,
/* 0x6ea0 */  95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109,
/* 0x6eb0 */  97, 95,115,116, 97, 99,107, 95, 97,100,106,117,115,116, 10, 48,
/* 0x6ec0 */  48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 49, 54,
/* 0x6ed0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,117,
/* 0x6ee0 */  95,108,101,110, 95,104,105, 10, 48, 48, 48, 48, 48, 48, 49, 48,
/* 0x6ef0 */  32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32,
/* 0x6f00 */  32, 32, 32,108,122,109, 97, 95,117, 95,108,101,110, 10, 48, 48,
/* 0x6f10 */  48, 48, 48, 48, 49, 97, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32,
/* 0x6f20 */  32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95, 99, 95,
/* 0x6f30 */ 108,101,110, 95,104,105, 10, 48, 48, 48, 48, 48, 48, 49,101, 32,
/* 0x6f40 */  82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6f50 */  32, 32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48,
/* 0x6f60 */  48, 48, 48, 50, 99, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32,
/* 0x6f70 */  32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,112,114,111,
/* 0x6f80 */ 112,101,114,116,105,101,115, 10, 48, 48, 48, 48, 48, 48, 51, 49,
/* 0x6f90 */  32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6fa0 */  32, 32, 32,108,122,109, 97, 95,112,114,111,112,101,114,116,105,
/* 0x6fb0 */ 101,115, 95,104,105, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x6fc0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,105,
/* 0x6fd0 */ 103,110,111,114,101, 95,114,101,108,111, 99, 95,111,118,101,114,
/* 0x6fe0 */ 102,108,111,119, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x6ff0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7000 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x7010 */  32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7020 */  32, 32, 32,108,122,109, 97, 95,117, 95,108,101,110, 10, 48, 48,
/* 0x7030 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32,
/* 0x7040 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x7050 */  67, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51,
/* 0x7060 */  56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,
/* 0x7070 */ 122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48,
/* 0x7080 */  48, 51, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32,
/* 0x7090 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 10,
/* 0x70a0 */  48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 56,
/* 0x70b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,
/* 0x70c0 */ 112,114,111,112,101,114,116,105,101,115, 10, 48, 48, 48, 48, 48,
/* 0x70d0 */  48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32,
/* 0x70e0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48,
/* 0x70f0 */  10, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51, 56, 54, 95,
/* 0x7100 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97,
/* 0x7110 */  95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 55, 32,
/* 0x7120 */  82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7130 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 50, 10, 10, 82, 69,
/* 0x7140 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x7150 */  32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 51, 49,
/* 0x7160 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x7170 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x7180 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51,
/* 0x7190 */  56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,
/* 0x71a0 */ 108,101, 97,114, 95,100,105,114,116,121, 95,115,116, 97, 99,107,
/* 0x71b0 */  95,108,111,119, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x71c0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90,
/* 0x71d0 */  77, 65, 95, 68, 69, 67, 51, 50, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x71e0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x71f0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x7200 */  48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32,
/* 0x7210 */  32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,117, 95,108,101,
/* 0x7220 */ 110, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x7230 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95,
/* 0x7240 */  68, 69, 67, 51, 51, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x7250 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7260 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x7270 */  51, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32,
/* 0x7280 */  32, 32, 32, 32,108,122,109, 97, 95,117, 95,108,101,110, 95,115,
/* 0x7290 */ 101,103,109,101,110,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x72a0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x72b0 */  69, 88, 69, 82, 69, 76, 79, 49, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x72c0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x72d0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x72e0 */  48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32, 32,
/* 0x72f0 */  32, 32, 32, 32, 32, 32, 32,114,101,108,111, 99, 95,115,105,122,
/* 0x7300 */ 101, 10, 48, 48, 48, 48, 48, 48, 49, 97, 32, 82, 95, 51, 56, 54,
/* 0x7310 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 69, 88, 69,
/* 0x7320 */  82, 69, 76, 79, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x7330 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69,
/* 0x7340 */  88, 69, 82, 69, 76, 57, 65, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x7350 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x7360 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x7370 */  48, 49, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x7380 */  32, 32, 32, 32, 32, 32, 69, 88, 69, 82, 69, 76, 79, 49, 10, 10,
/* 0x7390 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x73a0 */  68, 83, 32, 70, 79, 82, 32, 91, 69, 88, 69, 82, 69, 66, 73, 71,
/* 0x73b0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x73c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x73d0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,
/* 0x73e0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x73f0 */  88, 69, 82, 69, 76, 79, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x7400 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x7410 */  91, 69, 88, 69, 82, 69, 76, 79, 51, 93, 58, 10, 79, 70, 70, 83,
/* 0x7420 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x7430 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x7440 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x7450 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 88, 69, 82, 69, 76, 79, 49,
/* 0x7460 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x7470 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 88, 69, 83, 84, 65,
/* 0x7480 */  67, 75, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x7490 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x74a0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82,
/* 0x74b0 */  95, 51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x74c0 */  32,111,114,105,103,105,110, 97,108, 95,115,115, 10, 10, 82, 69,
/* 0x74d0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x74e0 */  32, 70, 79, 82, 32, 91, 69, 88, 69, 83, 84, 65, 83, 80, 93, 58,
/* 0x74f0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x7500 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x7510 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x7520 */  95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,111,114,105,
/* 0x7530 */ 103,105,110, 97,108, 95,115,112, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x7540 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x7550 */  32, 91, 69, 88, 69, 74, 85, 77, 80, 70, 93, 58, 10, 79, 70, 70,
/* 0x7560 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x7570 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x7580 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32,
/* 0x7590 */  32, 32, 32, 32, 32, 32, 32, 32, 32,111,114,105,103,105,110, 97,
/* 0x75a0 */ 108, 95,105,112, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95,
/* 0x75b0 */  51, 56, 54, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x75c0 */ 111,114,105,103,105,110, 97,108, 95, 99,115, 10, 10, 82, 69, 76,
/* 0x75d0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x75e0 */  70, 79, 82, 32, 91, 69, 88, 69, 82, 67, 83, 80, 79, 93, 58, 10,
/* 0x75f0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x7600 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x7610 */  10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95,
/* 0x7620 */  49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,111,114,105,103,
/* 0x7630 */ 105,110, 97,108, 95, 99,115, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x7640 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x7650 */  91, 69, 88, 69, 82, 69, 84, 73, 80, 93, 58, 10, 79, 70, 70, 83,
/* 0x7660 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x7670 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x7680 */  48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 49, 54, 32, 32,
/* 0x7690 */  32, 32, 32, 32, 32, 32, 32, 32,111,114,105,103,105,110, 97,108,
/* 0x76a0 */  95,105,112, 10
};
