/* powerpc64le-darwin.dylib-entry.h
   created from powerpc64le-darwin.dylib-entry.bin, 9867 (0x268b) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2016 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2016 Laszlo Molnar
   Copyright (C) 2000-2016 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_POWERPC64LE_DARWIN_DYLIB_ENTRY_SIZE    9867
#define STUB_POWERPC64LE_DARWIN_DYLIB_ENTRY_ADLER32 0xc87a5b7f
#define STUB_POWERPC64LE_DARWIN_DYLIB_ENTRY_CRC32   0x1f770f24

unsigned char stub_powerpc64le_darwin_dylib_entry[9867] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 21,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0,168, 29,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0, 22,  0, 19,  0,
/* 0x0040 */ 166,  2, 72,124,  1,  0,  0, 72,236, 41,  0,124,166,  2,168,125,
/* 0x0050 */   8,  0,  7, 40, 92,  1,130, 64,  0,  0,166,248, 20, 26,132,124,
/* 0x0060 */   0,128,  0, 60,198,  7,  0,120,  0,128, 32, 61,198,  7, 41,121,
/* 0x0070 */ 255,255, 99, 56,255,255,165, 56,255,255, 64, 57, 36,  1,  0, 72,
/* 0x0080 */   1,  0, 32, 57, 46, 24, 41,125,  4,  0, 99, 56,198,  7, 41,121,
/* 0x0090 */  64,  0, 41,124, 20, 72, 41,125,  1,  0,128, 57,198,  7,140,121,
/* 0x00a0 */ 120, 99, 41,125, 32,  0,128, 78,  1,  0,  3,141,  1,  0,  5,157,
/* 0x00b0 */  64,  0, 41,124, 20, 74, 41,125,201,255,194, 65,236,255,225, 65,
/* 0x00c0 */   1,  0,224, 56, 20,  0,  0, 72,255,255,231, 56, 21, 72, 41,125,
/* 0x00d0 */ 177,255,194, 65, 20, 57,231,124, 21, 72, 41,125,165,255,194, 65,
/* 0x00e0 */  20, 57,231,124, 64,  0, 41,124, 20, 74, 41,125,149,255,194, 65,
/* 0x00f0 */ 216,255,192, 65,  0,  0,  0, 57,253,255,231, 52, 46, 64,231, 84,
/* 0x0100 */ 255,255,128, 57,198,  7,140,121,120, 99,231,124, 32,  0,192, 65,
/* 0x0110 */   1,  0, 67,140,249, 16,234,124,112, 14, 74,125,  0,  0,194, 65,
/* 0x0120 */   1,  0, 66,112, 80,  0,226, 65, 20,  0,  0, 72, 64,  0, 41,124,
/* 0x0130 */  20, 74, 41,125, 77,255,194, 65, 60,  0,225, 65,  1,  0,  0, 57,
/* 0x0140 */  64,  0, 41,124, 20, 74, 41,125, 57,255,194, 65, 40,  0,225, 65,
/* 0x0150 */  21, 72, 41,125, 45,255,194, 65, 20, 65,  8,125, 64,  0, 41,124,
/* 0x0160 */  20, 74, 41,125, 29,255,194, 65,232,255,192, 65,  2,  0,  8, 57,
/* 0x0170 */  16,  0,  0, 72, 21, 72, 41,125,  9,255,194, 65, 20, 65,  8,125,
/* 0x0180 */ 255,250,234, 32,  2,  0,  8, 57,148,  1,  8,125, 20, 42,234,124,
/* 0x0190 */ 166,  3,  9,125,  1,  0,  7,141,  1,  0,  5,157,248,255, 32, 67,
/* 0x01a0 */   0,  1,224, 56,236, 41,  7,124, 44, 26,  7,124,  4,255,255, 75,
/* 0x01b0 */ 236, 41,  0,124,166,  2,168,125,  5,  0,  7, 40, 56,  1,130, 64,
/* 0x01c0 */   0,  0,166,248, 20, 26,132,124,  0,128,  0, 60,198,  7,  0,120,
/* 0x01d0 */   0,128, 32, 61,198,  7, 41,121,255,255, 99, 56,255,255,165, 56,
/* 0x01e0 */ 255,255, 64, 57,  0,  1,  0, 72,  1,  0, 32, 57, 46, 24, 41,125,
/* 0x01f0 */   4,  0, 99, 56,198,  7, 41,121, 64,  0, 41,124, 20, 72, 41,125,
/* 0x0200 */   1,  0,128, 57,198,  7,140,121,120, 99, 41,125, 32,  0,128, 78,
/* 0x0210 */   1,  0,  3,141,  1,  0,  5,157, 64,  0, 41,124, 20, 74, 41,125,
/* 0x0220 */ 201,255,194, 65,236,255,225, 65,  1,  0,224, 56, 20,  0,  0, 72,
/* 0x0230 */ 255,255,231, 56, 21, 72, 41,125,177,255,194, 65, 21, 57,231,124,
/* 0x0240 */  21, 72, 41,125,165,255,194, 65, 21, 57,231,124, 64,  0, 41,124,
/* 0x0250 */  20, 74, 41,125,149,255,194, 65,216,255,192, 65,  0,  0,  0, 57,
/* 0x0260 */ 253,255,231, 52, 46, 64,231, 84, 28,  0,192, 65,  1,  0, 67,140,
/* 0x0270 */ 249, 16,234,124,112, 14, 74,125,  0,  0, 42, 44,  0,  0,194, 65,
/* 0x0280 */  12,  0,  0, 72, 21, 72, 41,125, 97,255,194, 65, 21, 65,  8,125,
/* 0x0290 */  21, 72, 41,125, 85,255,194, 65, 21, 65,  8,125, 40,  0,130, 64,
/* 0x02a0 */   1,  0,  0, 57, 21, 72, 41,125, 65,255,194, 65, 21, 65,  8,125,
/* 0x02b0 */  64,  0, 41,124, 20, 74, 41,125, 49,255,194, 65,232,255,192, 65,
/* 0x02c0 */   2,  0,  8, 57,255,250,234, 32,  1,  0,  8, 57,148,  1,  8,125,
/* 0x02d0 */  20, 42,234,124,166,  3,  9,125,  1,  0,  7,141,  1,  0,  5,157,
/* 0x02e0 */ 248,255, 32, 67,  0,  1,224, 56,236, 41,  7,124, 44, 26,  7,124,
/* 0x02f0 */  40,255,255, 75,236, 41,  0,124,166,  2,168,125,  2,  0,  7, 40,
/* 0x0300 */  12,  1,130, 64,  0,  0,166,248, 20, 26,132,124,  0,128,  0, 60,
/* 0x0310 */ 198,  7,  0,120,  0,128, 32, 61,198,  7, 41,121,255,255, 99, 56,
/* 0x0320 */ 255,255,165, 56,255,255, 64, 57,212,  0,  0, 72, 64,  0, 41,124,
/* 0x0330 */  20, 72, 41,125, 32,  0,226, 76,  0,  0,128, 57, 20, 97,140,125,
/* 0x0340 */ 198,  7,140,121,  1,  0, 32, 57, 46, 24, 41,125,  4,  0, 99, 56,
/* 0x0350 */ 198,  7, 41,121, 64,  0, 41,124, 20, 72, 41,125, 20, 98, 41,125,
/* 0x0360 */  32,  0,128, 78,  1,  0,  3,141,  1,  0,  5,157,193,255,255, 75,
/* 0x0370 */ 244,255,225, 65,  1,  0,224, 56,181,255,255, 75, 21, 57,231,124,
/* 0x0380 */ 173,255,255, 75,244,255,192, 65,253,255,231, 52,  0,  0,  0, 57,
/* 0x0390 */  32,  0,192, 65, 46, 64,231, 84,  1,  0, 67,140,249, 16,234,124,
/* 0x03a0 */ 255,255,128, 57,198,  7,140,121,  0, 96, 42,124,  0,  0,194, 65,
/* 0x03b0 */ 125,255,255, 75, 21, 65,  8,125,117,255,255, 75, 21, 65,  8,125,
/* 0x03c0 */   1,  0,224, 56, 28,  0,194, 64,  3,  0,224, 56,  1,  0,  0, 57,
/* 0x03d0 */  93,255,255, 75, 21, 65,  8,125, 85,255,255, 75,244,255,192, 65,
/* 0x03e0 */ 255,242, 74, 32, 20, 57,  8,125, 20, 42,234,124,166,  3,  9,125,
/* 0x03f0 */   1,  0,  7,141,  1,  0,  5,157,248,255, 32, 67,  0,  1,224, 56,
/* 0x0400 */ 236, 41,  7,124, 44, 26,  7,124,100,255,255, 75, 14,  0,  7, 40,
/* 0x0410 */   0,  0,130, 64,166,  2,  8,124,120, 51,201,124,  0,  0,  6,129,
/* 0x0420 */ 120, 43,167,124,254,255,164, 56,  2,  0,131, 56, 48,  0,  1,248,
/* 0x0430 */   0,  0,  3,136,254,232, 11, 84,126,  7,  2, 84,  0,250, 96, 56,
/* 0x0440 */  48, 88, 99,124,124,241, 99, 56,120, 11, 38,124, 20, 26, 33,124,
/* 0x0450 */  52,  0, 33, 84,  0,  0,  0, 56,120, 51,195,124,  0,  0,  9,144,
/* 0x0460 */ 252,255,  3,148, 64, 24,  1,124,248,255,128, 65,  0,  0,193,144,
/* 0x0470 */ 255,255,  4,136,  8,  0,225,144, 16,  0,193, 56, 12,  0, 33,145,
/* 0x0480 */  20,  0, 97, 56, 62,225, 11, 84, 62,  7,  0, 84,  2,  0, 67,152,
/* 0x0490 */   1,  0, 99,153,  0,  0,  3,152,124,  8,  2,166,148, 33,255,160,
/* 0x04a0 */ 189,193,  0, 24,144,  1,  0,100, 59, 32,  0,  0,137, 67,  0,  2,
/* 0x04b0 */ 137, 99,  0,  1,138, 67,  0,  0,147, 38,  0,  0,147, 41,  0,  0,
/* 0x04c0 */ 136,  3,  0,  1,125, 40,  3,166,124, 18,  2, 20, 57, 32,  3,  0,
/* 0x04d0 */ 125, 41,  0, 48, 56,  9,  7, 54,127,153,  0, 64, 57, 32,  0,  1,
/* 0x04e0 */ 125, 43, 88, 48,125, 41, 80, 48, 57, 41,255,255, 57,107,255,255,
/* 0x04f0 */ 145, 33,  0,  8,124,206, 51,120,124,147, 35,120,124,245, 59,120,
/* 0x0500 */ 125, 20, 67,120,145, 97,  0, 12, 59,  3,  0,  4, 59,224,  0,  0,
/* 0x0510 */  58,224,  0,  0, 59, 64,  0,  1, 58, 32,  0,  1, 58,  0,  0,  1,
/* 0x0520 */  57,224,  0,  1, 57, 32,  0,  0, 64,156,  0, 28,124,  9,  3,166,
/* 0x0530 */  57, 96,  4,  0, 85, 32,  8, 60,125,120,  3, 46, 57, 41,  0,  1,
/* 0x0540 */  66,  0,255,244,127,179, 42, 20,126,108,155,120, 56,160,  0,  0,
/* 0x0550 */  57,  0,255,255, 57, 96,  0,  0,127,140,232,  0, 57,107,  0,  1,
/* 0x0560 */  47, 11,  0,  4, 84,169, 64, 46, 65,158,  8,156,136, 12,  0,  0,
/* 0x0570 */  57,140,  0,  1,125, 37,  3,120, 64,153,255,224,127,153,160, 64,
/* 0x0580 */  64,156,  8,100, 62,192,  0,255, 98,214,255,255,128,  1,  0,  8,
/* 0x0590 */ 127,136,176, 64,127, 35,  0, 56, 86,224, 32, 54,124,  0, 26, 20,
/* 0x05a0 */  84,  6,  8, 60, 65,157,  0, 32,127,140,232,  0, 65,158,  8, 88,
/* 0x05b0 */ 137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46,
/* 0x05c0 */  57,140,  0,  1,124,230,194, 46, 85,  0,170,254,125, 64, 57,214,
/* 0x05d0 */ 127,133, 80, 64, 64,156,  1,172,128,  1,  0, 12, 47,151,  0,  6,
/* 0x05e0 */ 127, 41,  0, 56, 32, 18,  0,  8,127,224,  6, 48,125, 41,144, 48,
/* 0x05f0 */ 125, 41,  2, 20, 29, 41,  6,  0, 32,  7,  8,  0,124,  0, 46,112,
/* 0x0600 */ 124,  7,  2, 20,125, 56, 74, 20,124,  6,195, 46,125, 72, 83,120,
/* 0x0610 */  56,201, 14,108, 56, 96,  0,  1, 64,157,  0,180,124, 26,200, 80,
/* 0x0620 */  63, 96,  0,255,127,245,  0,174, 99,123,255,255, 87,255,  8, 60,
/* 0x0630 */  87,252,  5,238,127,136,216, 64, 87,128,  8, 60, 84,100,  8, 60,
/* 0x0640 */ 124,  6,  2, 20,127, 12,232,  0, 84,169, 64, 46,124,224, 34, 20,
/* 0x0650 */  65,157,  0, 24, 65,154,  7,176,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x0660 */  57,140,  0,  1,125, 37,  3,120,161,103,  2,  0, 85,  0,170,254,
/* 0x0670 */ 125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112,
/* 0x0680 */  85,105,217,126,124, 11,  2, 20, 47, 28,  0,  0,125,105, 88, 80,
/* 0x0690 */ 124,131, 35,120,125, 10, 64, 80, 64,156,  0, 20,176,  7,  2,  0,
/* 0x06a0 */ 125, 72, 83,120, 65,186,  0, 24, 72,  0,  0, 28,177,103,  2,  0,
/* 0x06b0 */ 124,170, 40, 80, 56,100,  0,  1, 65,154,  0, 12, 47,131,  0,255,
/* 0x06c0 */  64,157,255,108, 47,131,  0,255, 65,157,  0,132, 63,224,  0,255,
/* 0x06d0 */  99,255,255,255,127,136,248, 64, 84,103,  8, 60,127, 12,232,  0,
/* 0x06e0 */  84,169, 64, 46,124,227, 59,120, 65,157,  0, 24, 65,154,  7, 24,
/* 0x06f0 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x0700 */ 125,102, 58, 46, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,
/* 0x0710 */ 127,133, 80, 64,124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,
/* 0x0720 */ 125, 10, 64, 80,125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,
/* 0x0730 */ 124,  6, 59, 46, 72,  0,  0, 16,124,170, 40, 80,125,102, 59, 46,
/* 0x0740 */  56,103,  0,  1, 47,131,  0,255, 64,157,255,140, 47,151,  0,  3,
/* 0x0750 */  84,127,  6, 62,127,249,169,174, 59, 57,  0,  1, 65,157,  0, 12,
/* 0x0760 */  58,224,  0,  0, 72,  0,  6,120, 47,151,  0,  9, 65,157,  0, 12,
/* 0x0770 */  58,247,255,253, 72,  0,  6,104, 58,247,255,250, 72,  0,  6, 96,
/* 0x0780 */ 125, 10, 64, 80,127,136,176, 64, 84,224,217,126,124,  0, 56, 80,
/* 0x0790 */  86,233,  8, 60,124,  6,195, 46,124,170, 40, 80,124,248, 74, 20,
/* 0x07a0 */  65,157,  0, 32,127,140,232,  0, 65,158,  6, 92,137, 44,  0,  0,
/* 0x07b0 */  84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x07c0 */ 161,103,  1,128, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x07d0 */  64,156,  0, 64, 32, 11,  8,  0, 47,151,  0,  6,124,  0, 46,112,
/* 0x07e0 */ 124, 11,  2, 20,176,  7,  1,128,126, 15,131,120,125, 72, 83,120,
/* 0x07f0 */ 126, 48,139,120, 56,  0,  0,  0,127, 81,211,120, 64,157,  0,  8,
/* 0x0800 */  56,  0,  0,  3,124, 23,  3,120, 56,216,  6,100, 72,  0,  2, 24,
/* 0x0810 */ 125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,
/* 0x0820 */ 124,170, 40, 80,176,  7,  1,128, 65,157,  0, 32,127,140,232,  0,
/* 0x0830 */  65,158,  5,212,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,
/* 0x0840 */  85,  8, 64, 46, 57,140,  0,  1,161,103,  1,152, 85,  0,170,254,
/* 0x0850 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0,188, 32, 11,  8,  0,
/* 0x0860 */ 127,138,176, 64,124,  0, 46,112, 86,233, 40, 52,124, 11,  2, 20,
/* 0x0870 */ 125, 56, 74, 20, 84,107,  8, 60,176,  7,  1,152,125, 72, 83,120,
/* 0x0880 */ 124,233, 90, 20, 65,157,  0, 32,127,140,232,  0, 65,158,  5,120,
/* 0x0890 */ 137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85, 72, 64, 46,
/* 0x08a0 */  57,140,  0,  1,161,103,  1,224, 85,  0,170,254,125, 64, 89,214,
/* 0x08b0 */ 127,133, 80, 64, 64,156,  0, 72, 32, 11,  8,  0, 47,153,  0,  0,
/* 0x08c0 */ 124,  0, 46,112,124, 11,  2, 20,176,  7,  1,224,125, 72, 83,120,
/* 0x08d0 */  65,158,  5, 52, 47,151,  0,  6, 57, 32,  0,  9, 64,157,  0,  8,
/* 0x08e0 */  57, 32,  0, 11,124, 26,200, 80,127,245,  0,174,125, 55, 75,120,
/* 0x08f0 */ 127,249,169,174, 59, 57,  0,  1, 72,  0,  4,228, 85, 96,217,126,
/* 0x0900 */ 124,  0, 88, 80,124,170, 40, 80,125, 10, 64, 80,176,  7,  1,224,
/* 0x0910 */  72,  0,  0,252,125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,
/* 0x0920 */ 124,  0, 88, 80,124,170, 40, 80,176,  7,  1,152, 65,157,  0, 32,
/* 0x0930 */ 127,140,232,  0, 65,158,  4,208,137, 44,  0,  0, 84,160, 64, 46,
/* 0x0940 */ 124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,161,103,  1,176,
/* 0x0950 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 32,
/* 0x0960 */  32, 11,  8,  0,124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120,
/* 0x0970 */ 126, 41,139,120,176,  7,  1,176, 72,  0,  0,140,125, 10, 64, 80,
/* 0x0980 */ 127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,
/* 0x0990 */ 176,  7,  1,176, 65,157,  0, 32,127,140,232,  0, 65,158,  4,104,
/* 0x09a0 */ 137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46,
/* 0x09b0 */  57,140,  0,  1,161,103,  1,200, 85,  0,170,254,125, 64, 89,214,
/* 0x09c0 */ 127,133, 80, 64, 64,156,  0, 32, 32, 11,  8,  0,124,  0, 46,112,
/* 0x09d0 */ 124, 11,  2, 20,125, 72, 83,120,126,  9,131,120,176,  7,  1,200,
/* 0x09e0 */  72,  0,  0, 32, 85, 96,217,126,124,  0, 88, 80,125,233,123,120,
/* 0x09f0 */ 176,  7,  1,200,124,170, 40, 80,125, 10, 64, 80,126, 15,131,120,
/* 0x0a00 */ 126, 48,139,120,127, 81,211,120,125, 58, 75,120, 47,151,  0,  6,
/* 0x0a10 */  56,  0,  0,  8, 64,157,  0,  8, 56,  0,  0, 11,124, 23,  3,120,
/* 0x0a20 */  56,216, 10,104,127,136,176, 64, 65,157,  0, 32,127,140,232,  0,
/* 0x0a30 */  65,158,  3,212,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,
/* 0x0a40 */  85,  8, 64, 46, 57,140,  0,  1,161,102,  0,  0, 85,  0,170,254,
/* 0x0a50 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 48, 32, 11,  8,  0,
/* 0x0a60 */  84,105, 32, 54,125, 38, 74, 20,124,  0, 46,112,124, 11,  2, 20,
/* 0x0a70 */ 125, 72, 83,120, 56,137,  0,  4, 59,128,  0,  0, 59, 96,  0,  3,
/* 0x0a80 */ 176,  6,  0,  0, 72,  0,  0,156,125, 10, 64, 80,127,136,176, 64,
/* 0x0a90 */  85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,176,  6,  0,  0,
/* 0x0aa0 */  65,157,  0, 32,127,140,232,  0, 65,158,  3, 92,137, 44,  0,  0,
/* 0x0ab0 */  84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0ac0 */ 161,102,  0,  2, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x0ad0 */  64,156,  0, 48, 32, 11,  8,  0, 84,105, 32, 54,125, 38, 74, 20,
/* 0x0ae0 */ 124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120, 56,137,  1,  4,
/* 0x0af0 */  59,128,  0,  8, 59, 96,  0,  3,176,  6,  0,  2, 72,  0,  0, 36,
/* 0x0b00 */  85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,176,  6,  0,  2,
/* 0x0b10 */ 125, 10, 64, 80, 56,134,  2,  4, 59,128,  0, 16, 59, 96,  0,  8,
/* 0x0b20 */ 127,105,  3,166, 63,224,  0,255, 99,255,255,255, 56, 96,  0,  1,
/* 0x0b30 */ 127,136,248, 64, 84,103,  8, 60,127, 12,232,  0, 84,169, 64, 46,
/* 0x0b40 */ 124,227, 59,120, 65,157,  0, 24, 65,154,  2,188,136, 12,  0,  0,
/* 0x0b50 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,125,100, 58, 46,
/* 0x0b60 */  85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,
/* 0x0b70 */ 124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,
/* 0x0b80 */ 125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,124,  4, 59, 46,
/* 0x0b90 */  72,  0,  0, 16,124,170, 40, 80, 56,103,  0,  1,125,100, 59, 46,
/* 0x0ba0 */  66,  0,255,144, 56,  0,  0,  1, 47,151,  0,  3,124,  0,216, 48,
/* 0x0bb0 */ 124, 96, 24, 80,124, 99,226, 20, 65,157,  1,232, 47,131,  0,  3,
/* 0x0bc0 */  58,247,  0,  7,124,105, 27,120, 64,157,  0,  8, 57, 32,  0,  3,
/* 0x0bd0 */  85, 41, 56, 48,125, 56, 74, 20, 56,201,  3, 96, 57, 32,  0,  6,
/* 0x0be0 */ 125, 41,  3,166, 63,224,  0,255, 99,255,255,255, 56,128,  0,  1,
/* 0x0bf0 */ 127,136,248, 64, 84,135,  8, 60,127, 12,232,  0, 84,169, 64, 46,
/* 0x0c00 */ 124,228, 59,120, 65,157,  0, 24, 65,154,  1,252,136, 12,  0,  0,
/* 0x0c10 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,125,102, 58, 46,
/* 0x0c20 */  85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,
/* 0x0c30 */ 124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,
/* 0x0c40 */ 125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46,
/* 0x0c50 */  72,  0,  0, 16,124,170, 40, 80, 56,135,  0,  1,125,102, 59, 46,
/* 0x0c60 */  66,  0,255,144, 56,132,255,192, 47,132,  0,  3,124,154, 35,120,
/* 0x0c70 */  64,157,  1, 40, 47,132,  0, 13,124,137, 14,112, 84,128,  7,254,
/* 0x0c80 */  57,105,255,255, 96, 26,  0,  2,125,105,  3,166, 65,157,  0, 32,
/* 0x0c90 */ 127, 90, 88, 48, 87, 73,  8, 60,125, 56, 74, 20, 84,128,  8, 60,
/* 0x0ca0 */ 125, 32, 72, 80, 56,201,  5, 94, 72,  0,  0,100, 57, 41,255,251,
/* 0x0cb0 */ 125, 41,  3,166, 61, 96,  0,255, 97,107,255,255,127,136, 88, 64,
/* 0x0cc0 */ 127, 12,232,  0, 84,169, 64, 46, 87, 90,  8, 60, 65,157,  0, 24,
/* 0x0cd0 */  65,154,  1, 52,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0ce0 */ 125, 37,  3,120, 85,  8,248,126,127,133, 64, 64, 65,156,  0, 12,
/* 0x0cf0 */ 124,168, 40, 80, 99, 90,  0,  1, 66,  0,255,196, 56,  0,  0,  4,
/* 0x0d00 */ 124,  9,  3,166, 87, 90, 32, 54, 56,216,  6, 68, 60,128,  0,255,
/* 0x0d10 */  96,132,255,255, 59,128,  0,  1, 59,224,  0,  1,127,136, 32, 64,
/* 0x0d20 */  87,231,  8, 60,127, 12,232,  0, 84,169, 64, 46,124,255, 59,120,
/* 0x0d30 */  65,157,  0, 24, 65,154,  0,208,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x0d40 */  57,140,  0,  1,125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,
/* 0x0d50 */ 125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112,
/* 0x0d60 */  85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80,
/* 0x0d70 */  64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 20,
/* 0x0d80 */ 124,170, 40, 80, 59,231,  0,  1,125,102, 59, 46,127, 90,227,120,
/* 0x0d90 */  87,156,  8, 60, 66,  0,255,136, 55, 90,  0,  1, 65,130,  0, 72,
/* 0x0da0 */ 127,154,200, 64, 56, 99,  0,  2, 65,157,  0, 92,124, 26,200, 80,
/* 0x0db0 */ 127,245,  0,174, 56, 99,255,255,127,249,169,174, 59, 57,  0,  1,
/* 0x0dc0 */  49, 99,255,255,125, 43, 25, 16,124, 20,200, 16,124,  0,  1, 16,
/* 0x0dd0 */ 124,  0,  0,208,125, 43,  0, 57, 64,130,255,212,127,153,160, 64,
/* 0x0de0 */  65,156,247,172, 60,  0,  0,255, 96,  0,255,255,127,136,  0, 64,
/* 0x0df0 */  65,157,  0, 32,127,140,232,  0, 56, 96,  0,  1, 65,158,  0, 40,
/* 0x0e00 */  72,  0,  0, 12, 56, 96,  0,  1, 72,  0,  0, 28, 57,140,  0,  1,
/* 0x0e10 */ 125, 40,  2,166,124, 19, 96, 80,144, 14,  0,  0, 56, 96,  0,  0,
/* 0x0e20 */ 147, 41,  0,  0,128,  1,  0,100,185,193,  0, 24,124,  8,  3,166,
/* 0x0e30 */  56, 33,  0, 96,124,  8,  2,166,148, 33,255,160,189,193,  0, 24,
/* 0x0e40 */ 144,  1,  0,100, 59, 32,  0,  0,137, 67,  0,  2,137, 99,  0,  1,
/* 0x0e50 */ 138, 67,  0,  0,147, 38,  0,  0,147, 41,  0,  0,136,  3,  0,  1,
/* 0x0e60 */ 125, 40,  3,166,124, 18,  2, 20, 57, 32,  3,  0,125, 41,  0, 48,
/* 0x0e70 */  56,  9,  7, 54,127,153,  0, 64, 57, 32,  0,  1,125, 43, 88, 48,
/* 0x0e80 */ 125, 41, 80, 48, 57, 41,255,255, 57,107,255,255,145, 33,  0,  8,
/* 0x0e90 */ 124,206, 51,120,124,147, 35,120,124,245, 59,120,125, 20, 67,120,
/* 0x0ea0 */ 145, 97,  0, 12, 59,  3,  0,  4, 59,224,  0,  0, 58,224,  0,  0,
/* 0x0eb0 */  59, 64,  0,  1, 58, 32,  0,  1, 58,  0,  0,  1, 57,224,  0,  1,
/* 0x0ec0 */  57, 32,  0,  0, 64,156,  0, 28,124,  9,  3,166, 57, 96,  4,  0,
/* 0x0ed0 */  85, 32,  8, 60,125,120,  3, 46, 57, 41,  0,  1, 66,  0,255,244,
/* 0x0ee0 */ 127,179, 42, 20,126,108,155,120, 56,160,  0,  0, 57,  0,255,255,
/* 0x0ef0 */  57, 96,  0,  0,127,140,232,  0, 57,107,  0,  1, 47, 11,  0,  4,
/* 0x0f00 */  84,169, 64, 46, 65,158,  8,156,136, 12,  0,  0, 57,140,  0,  1,
/* 0x0f10 */ 125, 37,  3,120, 64,153,255,224,127,153,160, 64, 64,156,  8,100,
/* 0x0f20 */  62,192,  0,255, 98,214,255,255,128,  1,  0,  8,127,136,176, 64,
/* 0x0f30 */ 127, 35,  0, 56, 86,224, 32, 54,124,  0, 26, 20, 84,  6,  8, 60,
/* 0x0f40 */  65,157,  0, 32,127,140,232,  0, 65,158,  8, 88,137, 44,  0,  0,
/* 0x0f50 */  84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0f60 */ 124,230,194, 46, 85,  0,170,254,125, 64, 57,214,127,133, 80, 64,
/* 0x0f70 */  64,156,  1,172,128,  1,  0, 12, 47,151,  0,  6,127, 41,  0, 56,
/* 0x0f80 */  32, 18,  0,  8,127,224,  6, 48,125, 41,144, 48,125, 41,  2, 20,
/* 0x0f90 */  29, 41,  6,  0, 32,  7,  8,  0,124,  0, 46,112,124,  7,  2, 20,
/* 0x0fa0 */ 125, 56, 74, 20,124,  6,195, 46,125, 72, 83,120, 56,201, 14,108,
/* 0x0fb0 */  56, 96,  0,  1, 64,157,  0,180,124, 26,200, 80, 63, 96,  0,255,
/* 0x0fc0 */ 127,245,  0,174, 99,123,255,255, 87,255,  8, 60, 87,252,  5,238,
/* 0x0fd0 */ 127,136,216, 64, 87,128,  8, 60, 84,100,  8, 60,124,  6,  2, 20,
/* 0x0fe0 */ 127, 12,232,  0, 84,169, 64, 46,124,224, 34, 20, 65,157,  0, 24,
/* 0x0ff0 */  65,154,  7,176,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x1000 */ 125, 37,  3,120,161,103,  2,  0, 85,  0,170,254,125, 64, 89,214,
/* 0x1010 */  32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112, 85,105,217,126,
/* 0x1020 */ 124, 11,  2, 20, 47, 28,  0,  0,125,105, 88, 80,124,131, 35,120,
/* 0x1030 */ 125, 10, 64, 80, 64,156,  0, 20,176,  7,  2,  0,125, 72, 83,120,
/* 0x1040 */  65,186,  0, 24, 72,  0,  0, 28,177,103,  2,  0,124,170, 40, 80,
/* 0x1050 */  56,100,  0,  1, 65,154,  0, 12, 47,131,  0,255, 64,157,255,108,
/* 0x1060 */  47,131,  0,255, 65,157,  0,132, 63,224,  0,255, 99,255,255,255,
/* 0x1070 */ 127,136,248, 64, 84,103,  8, 60,127, 12,232,  0, 84,169, 64, 46,
/* 0x1080 */ 124,227, 59,120, 65,157,  0, 24, 65,154,  7, 24,136, 12,  0,  0,
/* 0x1090 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,125,102, 58, 46,
/* 0x10a0 */  85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,
/* 0x10b0 */ 124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,
/* 0x10c0 */ 125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46,
/* 0x10d0 */  72,  0,  0, 16,124,170, 40, 80,125,102, 59, 46, 56,103,  0,  1,
/* 0x10e0 */  47,131,  0,255, 64,157,255,140, 47,151,  0,  3, 84,127,  6, 62,
/* 0x10f0 */ 127,249,169,174, 59, 57,  0,  1, 65,157,  0, 12, 58,224,  0,  0,
/* 0x1100 */  72,  0,  6,120, 47,151,  0,  9, 65,157,  0, 12, 58,247,255,253,
/* 0x1110 */  72,  0,  6,104, 58,247,255,250, 72,  0,  6, 96,125, 10, 64, 80,
/* 0x1120 */ 127,136,176, 64, 84,224,217,126,124,  0, 56, 80, 86,233,  8, 60,
/* 0x1130 */ 124,  6,195, 46,124,170, 40, 80,124,248, 74, 20, 65,157,  0, 32,
/* 0x1140 */ 127,140,232,  0, 65,158,  6, 92,137, 44,  0,  0, 84,160, 64, 46,
/* 0x1150 */ 124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,161,103,  1,128,
/* 0x1160 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 64,
/* 0x1170 */  32, 11,  8,  0, 47,151,  0,  6,124,  0, 46,112,124, 11,  2, 20,
/* 0x1180 */ 176,  7,  1,128,126, 15,131,120,125, 72, 83,120,126, 48,139,120,
/* 0x1190 */  56,  0,  0,  0,127, 81,211,120, 64,157,  0,  8, 56,  0,  0,  3,
/* 0x11a0 */ 124, 23,  3,120, 56,216,  6,100, 72,  0,  2, 24,125, 10, 64, 80,
/* 0x11b0 */ 127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,
/* 0x11c0 */ 176,  7,  1,128, 65,157,  0, 32,127,140,232,  0, 65,158,  5,212,
/* 0x11d0 */ 137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46,
/* 0x11e0 */  57,140,  0,  1,161,103,  1,152, 85,  0,170,254,125, 64, 89,214,
/* 0x11f0 */ 127,133, 80, 64, 64,156,  0,188, 32, 11,  8,  0,127,138,176, 64,
/* 0x1200 */ 124,  0, 46,112, 86,233, 40, 52,124, 11,  2, 20,125, 56, 74, 20,
/* 0x1210 */  84,107,  8, 60,176,  7,  1,152,125, 72, 83,120,124,233, 90, 20,
/* 0x1220 */  65,157,  0, 32,127,140,232,  0, 65,158,  5,120,137, 44,  0,  0,
/* 0x1230 */  84,160, 64, 46,124,  5, 75,120, 85, 72, 64, 46, 57,140,  0,  1,
/* 0x1240 */ 161,103,  1,224, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x1250 */  64,156,  0, 72, 32, 11,  8,  0, 47,153,  0,  0,124,  0, 46,112,
/* 0x1260 */ 124, 11,  2, 20,176,  7,  1,224,125, 72, 83,120, 65,158,  5, 52,
/* 0x1270 */  47,151,  0,  6, 57, 32,  0,  9, 64,157,  0,  8, 57, 32,  0, 11,
/* 0x1280 */ 124, 26,200, 80,127,245,  0,174,125, 55, 75,120,127,249,169,174,
/* 0x1290 */  59, 57,  0,  1, 72,  0,  4,228, 85, 96,217,126,124,  0, 88, 80,
/* 0x12a0 */ 124,170, 40, 80,125, 10, 64, 80,176,  7,  1,224, 72,  0,  0,252,
/* 0x12b0 */ 125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,
/* 0x12c0 */ 124,170, 40, 80,176,  7,  1,152, 65,157,  0, 32,127,140,232,  0,
/* 0x12d0 */  65,158,  4,208,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,
/* 0x12e0 */  85,  8, 64, 46, 57,140,  0,  1,161,103,  1,176, 85,  0,170,254,
/* 0x12f0 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 32, 32, 11,  8,  0,
/* 0x1300 */ 124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120,126, 41,139,120,
/* 0x1310 */ 176,  7,  1,176, 72,  0,  0,140,125, 10, 64, 80,127,136,176, 64,
/* 0x1320 */  85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,176,  7,  1,176,
/* 0x1330 */  65,157,  0, 32,127,140,232,  0, 65,158,  4,104,137, 44,  0,  0,
/* 0x1340 */  84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x1350 */ 161,103,  1,200, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x1360 */  64,156,  0, 32, 32, 11,  8,  0,124,  0, 46,112,124, 11,  2, 20,
/* 0x1370 */ 125, 72, 83,120,126,  9,131,120,176,  7,  1,200, 72,  0,  0, 32,
/* 0x1380 */  85, 96,217,126,124,  0, 88, 80,125,233,123,120,176,  7,  1,200,
/* 0x1390 */ 124,170, 40, 80,125, 10, 64, 80,126, 15,131,120,126, 48,139,120,
/* 0x13a0 */ 127, 81,211,120,125, 58, 75,120, 47,151,  0,  6, 56,  0,  0,  8,
/* 0x13b0 */  64,157,  0,  8, 56,  0,  0, 11,124, 23,  3,120, 56,216, 10,104,
/* 0x13c0 */ 127,136,176, 64, 65,157,  0, 32,127,140,232,  0, 65,158,  3,212,
/* 0x13d0 */ 137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46,
/* 0x13e0 */  57,140,  0,  1,161,102,  0,  0, 85,  0,170,254,125, 64, 89,214,
/* 0x13f0 */ 127,133, 80, 64, 64,156,  0, 48, 32, 11,  8,  0, 84,105, 32, 54,
/* 0x1400 */ 125, 38, 74, 20,124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120,
/* 0x1410 */  56,137,  0,  4, 59,128,  0,  0, 59, 96,  0,  3,176,  6,  0,  0,
/* 0x1420 */  72,  0,  0,156,125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,
/* 0x1430 */ 124,  0, 88, 80,124,170, 40, 80,176,  6,  0,  0, 65,157,  0, 32,
/* 0x1440 */ 127,140,232,  0, 65,158,  3, 92,137, 44,  0,  0, 84,160, 64, 46,
/* 0x1450 */ 124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,161,102,  0,  2,
/* 0x1460 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 48,
/* 0x1470 */  32, 11,  8,  0, 84,105, 32, 54,125, 38, 74, 20,124,  0, 46,112,
/* 0x1480 */ 124, 11,  2, 20,125, 72, 83,120, 56,137,  1,  4, 59,128,  0,  8,
/* 0x1490 */  59, 96,  0,  3,176,  6,  0,  2, 72,  0,  0, 36, 85, 96,217,126,
/* 0x14a0 */ 124,  0, 88, 80,124,170, 40, 80,176,  6,  0,  2,125, 10, 64, 80,
/* 0x14b0 */  56,134,  2,  4, 59,128,  0, 16, 59, 96,  0,  8,127,105,  3,166,
/* 0x14c0 */  63,224,  0,255, 99,255,255,255, 56, 96,  0,  1,127,136,248, 64,
/* 0x14d0 */  84,103,  8, 60,127, 12,232,  0, 84,169, 64, 46,124,227, 59,120,
/* 0x14e0 */  65,157,  0, 24, 65,154,  2,188,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x14f0 */  57,140,  0,  1,125, 37,  3,120,125,100, 58, 46, 85,  0,170,254,
/* 0x1500 */ 125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112,
/* 0x1510 */  85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80,
/* 0x1520 */  64,156,  0, 16,125, 72, 83,120,124,  4, 59, 46, 72,  0,  0, 16,
/* 0x1530 */ 124,170, 40, 80, 56,103,  0,  1,125,100, 59, 46, 66,  0,255,144,
/* 0x1540 */  56,  0,  0,  1, 47,151,  0,  3,124,  0,216, 48,124, 96, 24, 80,
/* 0x1550 */ 124, 99,226, 20, 65,157,  1,232, 47,131,  0,  3, 58,247,  0,  7,
/* 0x1560 */ 124,105, 27,120, 64,157,  0,  8, 57, 32,  0,  3, 85, 41, 56, 48,
/* 0x1570 */ 125, 56, 74, 20, 56,201,  3, 96, 57, 32,  0,  6,125, 41,  3,166,
/* 0x1580 */  63,224,  0,255, 99,255,255,255, 56,128,  0,  1,127,136,248, 64,
/* 0x1590 */  84,135,  8, 60,127, 12,232,  0, 84,169, 64, 46,124,228, 59,120,
/* 0x15a0 */  65,157,  0, 24, 65,154,  1,252,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x15b0 */  57,140,  0,  1,125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,
/* 0x15c0 */ 125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112,
/* 0x15d0 */  85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80,
/* 0x15e0 */  64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 16,
/* 0x15f0 */ 124,170, 40, 80, 56,135,  0,  1,125,102, 59, 46, 66,  0,255,144,
/* 0x1600 */  56,132,255,192, 47,132,  0,  3,124,154, 35,120, 64,157,  1, 40,
/* 0x1610 */  47,132,  0, 13,124,137, 14,112, 84,128,  7,254, 57,105,255,255,
/* 0x1620 */  96, 26,  0,  2,125,105,  3,166, 65,157,  0, 32,127, 90, 88, 48,
/* 0x1630 */  87, 73,  8, 60,125, 56, 74, 20, 84,128,  8, 60,125, 32, 72, 80,
/* 0x1640 */  56,201,  5, 94, 72,  0,  0,100, 57, 41,255,251,125, 41,  3,166,
/* 0x1650 */  61, 96,  0,255, 97,107,255,255,127,136, 88, 64,127, 12,232,  0,
/* 0x1660 */  84,169, 64, 46, 87, 90,  8, 60, 65,157,  0, 24, 65,154,  1, 52,
/* 0x1670 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x1680 */  85,  8,248,126,127,133, 64, 64, 65,156,  0, 12,124,168, 40, 80,
/* 0x1690 */  99, 90,  0,  1, 66,  0,255,196, 56,  0,  0,  4,124,  9,  3,166,
/* 0x16a0 */  87, 90, 32, 54, 56,216,  6, 68, 60,128,  0,255, 96,132,255,255,
/* 0x16b0 */  59,128,  0,  1, 59,224,  0,  1,127,136, 32, 64, 87,231,  8, 60,
/* 0x16c0 */ 127, 12,232,  0, 84,169, 64, 46,124,255, 59,120, 65,157,  0, 24,
/* 0x16d0 */  65,154,  0,208,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x16e0 */ 125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,125, 64, 89,214,
/* 0x16f0 */  32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112, 85,105,217,126,
/* 0x1700 */ 124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80, 64,156,  0, 16,
/* 0x1710 */ 125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 20,124,170, 40, 80,
/* 0x1720 */  59,231,  0,  1,125,102, 59, 46,127, 90,227,120, 87,156,  8, 60,
/* 0x1730 */  66,  0,255,136, 55, 90,  0,  1, 65,130,  0, 72,127,154,200, 64,
/* 0x1740 */  56, 99,  0,  2, 65,157,  0, 92,124, 26,200, 80,127,245,  0,174,
/* 0x1750 */  56, 99,255,255,127,249,169,174, 59, 57,  0,  1, 49, 99,255,255,
/* 0x1760 */ 125, 43, 25, 16,124, 20,200, 16,124,  0,  1, 16,124,  0,  0,208,
/* 0x1770 */ 125, 43,  0, 57, 64,130,255,212,127,153,160, 64, 65,156,247,172,
/* 0x1780 */  60,  0,  0,255, 96,  0,255,255,127,136,  0, 64, 65,157,  0, 32,
/* 0x1790 */ 127,140,232,  0, 56, 96,  0,  1, 65,158,  0, 40, 72,  0,  0, 12,
/* 0x17a0 */  56, 96,  0,  1, 72,  0,  0, 28, 57,140,  0,  1,125, 40,  2,166,
/* 0x17b0 */ 124, 19, 96, 80,144, 14,  0,  0, 56, 96,  0,  0,147, 41,  0,  0,
/* 0x17c0 */ 128,  1,  0,100,185,193,  0, 24,124,  8,  3,166, 56, 33,  0, 96,
/* 0x17d0 */  12,  0,161,128,  8,  0,225,128,  0,  0,165,128,  0,  0, 33,128,
/* 0x17e0 */  20, 58,165,124, 48,  0,  1,128,255,255,165, 56,166,  3,  8,124,
/* 0x17f0 */   0,  0,230,232,166,  3,168,125, 80, 24,100,124, 80, 40,135,124,
/* 0x1800 */   1,  0, 99, 56,  1,  0,132, 56,  0,  0,134,248, 31,  0,231, 96,
/* 0x1810 */ 108, 56,  0,124, 64, 40,  7,124,172, 63,  0,124, 32,  0,231, 56,
/* 0x1820 */ 240,255,128, 65,172,  4,  0,124, 44,  1,  0, 76, 32,  0,128, 78,
/* 0x1830 */  17,255, 65,248,  8,  0, 97,248, 16,  0,129,248, 24,  0,161,248,
/* 0x1840 */  32,  0,193,248, 40,  0,225,248, 48,  0,  1,249, 56,  0, 33,249,
/* 0x1850 */  64,  0, 65,249, 72,  0, 97,249, 80,  0,129,249, 88,  0,161,249,
/* 0x1860 */  96,  0,193,249,104,  0,225,249,112,  0,  1,250,120,  0, 33,250,
/* 0x1870 */ 128,  0, 65,250,136,  0, 97,250,144,  0,129,250,152,  0,161,250,
/* 0x1880 */ 160,  0,193,250,168,  0,225,250,176,  0,  1,251,184,  0, 33,251,
/* 0x1890 */ 192,  0, 65,251,200,  0, 97,251,208,  0,129,251,216,  0,161,251,
/* 0x18a0 */ 224,  0,193,251,232,  0,225,251,166,  2,232,127,252,255,191,130,
/* 0x18b0 */ 244,255,191,131,186,  1,181, 86, 20,170,189,127,252,255,181, 58,
/* 0x18c0 */   0,  0, 96, 56,120,235,164,127,  3,  0,160, 56,  2, 16,192, 56,
/* 0x18d0 */ 255,255,224, 56,  0,  0,  0, 57,  0,  0, 32, 57,197,  0,  0, 56,
/* 0x18e0 */   2,  0,  0, 68,255,255, 96, 56,120, 27,124,124,252,  1,160, 56,
/* 0x18f0 */ 166,  3,169,124, 20,234,131,124, 20,250,117,124,255,255,  3,140,
/* 0x1900 */ 255,255,  4,156,248,255, 32, 67, 80,232,165,124,166,  3,136,124,
/* 0x1910 */ 166,  3,169,124, 32,  0,128, 78,255,255,  3,140,255,255,  4,156,
/* 0x1920 */ 248,255, 32, 67,232,255,223,131, 80,248,227,127, 20,250,228,127,
/* 0x1930 */  20, 26,222,127,236,255, 95,128, 20, 18, 68,127, 20, 18, 99,127,
/* 0x1940 */ 232,255,123, 59,  4,  0, 90,128, 12,  0, 90, 59, 20, 18, 90,127,
/* 0x1950 */ 120,211, 88,127,120,219,121,127,  0,  0,122, 56, 49,  1,  0, 72,
/* 0x1960 */ 104,  0,130, 65, 20, 26,123,127,120, 27,119,124,  4,  0,122, 56,
/* 0x1970 */  29,  1,  0, 72, 20, 26, 90,127,120, 27,118,124, 12,  0, 90, 59,
/* 0x1980 */ 249,255,225,250,166,  3,232,127, 12,  0,120, 56,120,179,196,126,
/* 0x1990 */ 120,203, 37,127,120, 11, 38,124,  8,  0,248,136,208,255, 33, 56,
/* 0x19a0 */  33,  0,128, 78, 56,  0, 33, 56,  9,  0,216,136,  0,  0,  6, 40,
/* 0x19b0 */ 160,255,130, 65, 10,  0,184,136,  0,  0,152,232,120,203, 35,127,
/* 0x19c0 */ 241,  0,  0, 72,140,255,255, 75,145,  0,  0, 72,  2,  0,  0, 68,
/* 0x19d0 */ 255,255, 96, 56,  0,  0, 65,232,  8,  0, 97,232, 16,  0,129,232,
/* 0x19e0 */  24,  0,161,232, 32,  0,193,232, 40,  0,225,232, 48,  0,  1,233,
/* 0x19f0 */  56,  0, 33,233, 64,  0, 65,233, 72,  0, 97,233, 80,  0,129,233,
/* 0x1a00 */  88,  0,161,233, 96,  0,193,233,104,  0,225,233,112,  0,  1,234,
/* 0x1a10 */ 120,  0, 33,234,128,  0, 65,234,136,  0, 97,234,144,  0,129,234,
/* 0x1a20 */ 152,  0,161,234,160,  0,193,234,168,  0,225,234,176,  0,  1,235,
/* 0x1a30 */ 184,  0, 33,235,192,  0, 65,235,200,  0, 97,235,208,  0,129,235,
/* 0x1a40 */ 216,  0,161,235,224,  0,193,235,232,  0,225,235,240,  0, 33, 56,
/* 0x1a50 */ 166,  3, 72,124, 32,  4,128, 78, 35,  0, 64, 56,166,  2,104,124,
/* 0x1a60 */ 140,  0, 99, 56,166,  3, 73,124,252,255, 67,132,252,255, 89,148,
/* 0x1a70 */ 248,255, 32, 67,166,  3, 40,127,166,  3,201,127,120,227,131,127,
/* 0x1a80 */ 120,235,164,127, 73,  0,  0, 56, 32,  0,128, 78,  3,  0, 67,136,
/* 0x1a90 */   2,  0, 99,137, 46, 68, 98, 81,  1,  0, 99,137, 30,130, 98, 81,
/* 0x1aa0 */   0,  0, 99,137, 14,192, 98, 81,121, 19, 67,124, 32,  0,128, 78,
/* 0x1ab0 */ 208,  0,  6, 40, 32,  0,194, 76,191,240,132, 84, 32,  0,194, 77,
/* 0x1ac0 */  16,  0,  0, 60, 64,  0,  4,124,  8,  0,128, 65,120,  3,  4,124,
/* 0x1ad0 */  32,  1,165, 56,120, 27,103,124,252,255, 99, 56,166,  3,137,124,
/* 0x1ae0 */  28,  0,  0, 72,186,  2, 75, 84, 80, 88, 99,125, 20, 58,107,125,
/* 0x1af0 */ 186,  1, 98, 81,  0,  0, 67,144, 32,  0, 64, 79,  4,  0, 67,132,
/* 0x1b00 */ 190, 85, 75, 84, 64, 40, 11,124,220,255,194, 65,240,255, 32, 67,
/* 0x1b10 */  32,  0,128, 78, 28,253,255, 75,102,105,108,101, 32,102,111,114,
/* 0x1b20 */ 109, 97,116, 32,101,108,102, 54, 52, 45,112,111,119,101,114,112,
/* 0x1b30 */  99,108,101, 10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,
/* 0x1b40 */ 100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1b50 */  32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32,
/* 0x1b60 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65,
/* 0x1b70 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 70,
/* 0x1b80 */ 105,108,101, 32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,
/* 0x1b90 */ 108, 97,103,115, 10, 32, 32, 48, 32, 77, 65, 67, 79, 83, 48, 48,
/* 0x1ba0 */  48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 56, 32,
/* 0x1bb0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1bc0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1bd0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52, 48, 32, 32, 50,
/* 0x1be0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x1bf0 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x1c00 */  32, 49, 32, 78, 82, 86, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32,
/* 0x1c10 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1c20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1c30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1c40 */  48, 48, 48, 48, 48, 52, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1c50 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x1c60 */  89, 10, 32, 32, 50, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32,
/* 0x1c70 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 54, 56, 32, 32, 48, 48,
/* 0x1c80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1c90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ca0 */  32, 32, 48, 48, 48, 48, 48, 48, 52, 56, 32, 32, 50, 42, 42, 48,
/* 0x1cb0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x1cc0 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 51, 32,
/* 0x1cd0 */  78, 82, 86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x1ce0 */  48, 48, 48, 49, 52, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1cf0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1d00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1d10 */  48, 49, 98, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1d20 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x1d30 */  68, 79, 78, 76, 89, 10, 32, 32, 52, 32, 78, 82, 86, 50, 66, 32,
/* 0x1d40 */  32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 49, 56,
/* 0x1d50 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d60 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d70 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50,102, 52, 32, 32,
/* 0x1d80 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x1d90 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1da0 */  32, 32, 53, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32,
/* 0x1db0 */  32, 32, 48, 48, 48, 48, 48, 48, 56, 99, 32, 32, 48, 48, 48, 48,
/* 0x1dc0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1dd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1de0 */  48, 48, 48, 48, 48, 52, 48, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1df0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x1e00 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 76, 90,
/* 0x1e10 */  77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1e20 */  48, 57, 57, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e30 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e40 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52,
/* 0x1e50 */  57, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1e60 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55,
/* 0x1e70 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48,
/* 0x1e80 */  48, 48, 48, 48, 57, 57, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1ea0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1eb0 */  48, 48,101, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1ec0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1ed0 */  32, 32, 56, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32,
/* 0x1ee0 */  32, 32, 48, 48, 48, 48, 48, 48, 50, 48, 32, 32, 48, 48, 48, 48,
/* 0x1ef0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1f00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1f10 */  48, 48, 48, 48, 49, 55,100, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1f20 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1f30 */  76, 89, 10, 32, 32, 57, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32,
/* 0x1f40 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 99, 32, 32, 48,
/* 0x1f50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1f60 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f70 */  48, 32, 32, 48, 48, 48, 48, 49, 55,102, 48, 32, 32, 50, 42, 42,
/* 0x1f80 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x1f90 */  68, 79, 78, 76, 89, 10, 32, 49, 48, 32, 67, 70, 76, 85, 83, 72,
/* 0x1fa0 */  32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 52,
/* 0x1fb0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1fc0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1fd0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56, 48, 99, 32, 32,
/* 0x1fe0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x1ff0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 69, 76, 70,
/* 0x2000 */  77, 65, 73, 78, 89, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2010 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2020 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2030 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56, 51,
/* 0x2040 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2050 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 50, 32,
/* 0x2060 */  69, 76, 70, 77, 65, 73, 78, 90, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x2070 */  48, 48, 48, 50,101, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2080 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2090 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x20a0 */  49, 56, 51, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x20b0 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 83,
/* 0x20c0 */  89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48,
/* 0x20d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x20e0 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x20f0 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2100 */  48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48,
/* 0x2110 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x2120 */  32, 32, 32,100, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76,  9, 48,
/* 0x2130 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2140 */  78, 82, 86, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2150 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x2160 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 90,  9, 48, 48, 48, 48, 48,
/* 0x2170 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 76, 70, 77,
/* 0x2180 */  65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2190 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77, 65,
/* 0x21a0 */  67, 79, 83, 48, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x21b0 */  48, 48, 48, 48, 48, 48, 48, 32, 77, 65, 67, 79, 83, 48, 48, 48,
/* 0x21c0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x21d0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95, 72, 69,
/* 0x21e0 */  65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x21f0 */  48, 48, 48, 32, 78, 82, 86, 95, 72, 69, 65, 68, 10, 48, 48, 48,
/* 0x2200 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x2210 */  32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69,  9, 48, 48, 48, 48,
/* 0x2220 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86,
/* 0x2230 */  50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2240 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50,
/* 0x2250 */  68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2260 */  48, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2270 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x2280 */  32, 32, 78, 82, 86, 50, 66,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2290 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 66, 10, 48,
/* 0x22a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x22b0 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70,
/* 0x22c0 */  48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x22d0 */  48, 48, 48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48,
/* 0x22e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x22f0 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2300 */  49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2310 */  48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x2320 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2330 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2340 */  50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2350 */  48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x2360 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2370 */ 108, 32, 32, 32, 32,100, 32, 32, 67, 70, 76, 85, 83, 72,  9, 48,
/* 0x2380 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2390 */  67, 70, 76, 85, 83, 72, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x23a0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x23b0 */  69, 76, 70, 77, 65, 73, 78, 89,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x23c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73,
/* 0x23d0 */  78, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x23e0 */  48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 77, 65, 67, 79,
/* 0x23f0 */  83, 48, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2400 */  48, 48, 48, 48, 48, 32, 95,115,116, 97,114,116, 10, 10, 82, 69,
/* 0x2410 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x2420 */  32, 70, 79, 82, 32, 91, 77, 65, 67, 79, 83, 48, 48, 48, 93, 58,
/* 0x2430 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2440 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2450 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x2460 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 80, 80, 67,
/* 0x2470 */  54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x2480 */  77, 65, 73, 78, 90, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2490 */  48, 48, 48, 48, 48, 50,101, 52, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x24a0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x24b0 */  32, 91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x24c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x24d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x24e0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x24f0 */  48,100, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 49,
/* 0x2500 */  52, 32, 32, 32, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 10,
/* 0x2510 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x2520 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93, 58, 10,
/* 0x2530 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2540 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2550 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2560 */  48, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82, 95, 80, 80, 67, 54,
/* 0x2570 */  52, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 78, 82, 86, 95,
/* 0x2580 */  84, 65, 73, 76, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x2590 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82,
/* 0x25a0 */  86, 50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x25b0 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x25c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x25d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98, 56, 32,
/* 0x25e0 */  82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 49, 52, 32, 32, 32,
/* 0x25f0 */  32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 10, 82, 69, 76, 79,
/* 0x2600 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x2610 */  79, 82, 32, 91, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 93, 58,
/* 0x2620 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2630 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2640 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x2650 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 80, 80, 67,
/* 0x2660 */  54, 52, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2670 */  65, 95, 68, 69, 67, 51, 48, 43, 48,120, 48, 48, 48, 48, 48, 48,
/* 0x2680 */  48, 48, 48, 48, 48, 48, 48, 48, 50, 48, 10
};
