/* powerpc64le-linux.kernel.vmlinux.h
   created from powerpc64le-linux.kernel.vmlinux.bin, 9840 (0x2670) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2016 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2016 Laszlo Molnar
   Copyright (C) 2000-2016 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_POWERPC64LE_LINUX_KERNEL_VMLINUX_SIZE    9840
#define STUB_POWERPC64LE_LINUX_KERNEL_VMLINUX_ADLER32 0x6930c592
#define STUB_POWERPC64LE_LINUX_KERNEL_VMLINUX_CRC32   0xcb40735a

unsigned char stub_powerpc64le_linux_kernel_vmlinux[9840] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 21,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0,120, 25,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0, 25,  0, 22,  0,
/* 0x0040 */   0,  0,  0, 72,  0,  0,  0, 72,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0050 */ 208,  0,  6, 40, 32,  0,194, 76,191,240,132, 84, 32,  0,194, 77,
/* 0x0060 */  16,  0,  0, 60, 64,  0,  4,124,  8,  0,128, 65,120,  3,  4,124,
/* 0x0070 */  32,  1,165, 56,120, 27,103,124,252,255, 99, 56,166,  3,137,124,
/* 0x0080 */  28,  0,  0, 72,186,  2, 75, 84, 80, 88, 99,125, 20, 58,107,125,
/* 0x0090 */ 186,  1, 98, 81,  0,  0, 67,144, 32,  0, 64, 79,  4,  0, 67,132,
/* 0x00a0 */ 190, 85, 75, 84, 64, 40, 11,124,220,255,194, 65,240,255, 32, 67,
/* 0x00b0 */  32,  0,128, 78,236, 41,  0,124,166,  2,168,125,  2,  0,  7, 40,
/* 0x00c0 */  12,  1,130, 64,  0,  0,166,248, 20, 26,132,124,  0,128,  0, 60,
/* 0x00d0 */ 198,  7,  0,120,  0,128, 32, 61,198,  7, 41,121,255,255, 99, 56,
/* 0x00e0 */ 255,255,165, 56,255,255, 64, 57,212,  0,  0, 72, 64,  0, 41,124,
/* 0x00f0 */  20, 72, 41,125, 32,  0,226, 76,  0,  0,128, 57, 20, 97,140,125,
/* 0x0100 */ 198,  7,140,121,  1,  0, 32, 57, 46, 24, 41,125,  4,  0, 99, 56,
/* 0x0110 */ 198,  7, 41,121, 64,  0, 41,124, 20, 72, 41,125, 20, 98, 41,125,
/* 0x0120 */  32,  0,128, 78,  1,  0,  3,141,  1,  0,  5,157,193,255,255, 75,
/* 0x0130 */ 244,255,225, 65,  1,  0,224, 56,181,255,255, 75, 21, 57,231,124,
/* 0x0140 */ 173,255,255, 75,244,255,192, 65,253,255,231, 52,  0,  0,  0, 57,
/* 0x0150 */  32,  0,192, 65, 46, 64,231, 84,  1,  0, 67,140,249, 16,234,124,
/* 0x0160 */ 255,255,128, 57,198,  7,140,121,  0, 96, 42,124,  0,  0,194, 65,
/* 0x0170 */ 125,255,255, 75, 21, 65,  8,125,117,255,255, 75, 21, 65,  8,125,
/* 0x0180 */   1,  0,224, 56, 28,  0,194, 64,  3,  0,224, 56,  1,  0,  0, 57,
/* 0x0190 */  93,255,255, 75, 21, 65,  8,125, 85,255,255, 75,244,255,192, 65,
/* 0x01a0 */ 255,242, 74, 32, 20, 57,  8,125, 20, 42,234,124,166,  3,  9,125,
/* 0x01b0 */   1,  0,  7,141,  1,  0,  5,157,248,255, 32, 67,  0,  1,224, 56,
/* 0x01c0 */ 236, 41,  7,124, 44, 26,  7,124,100,255,255, 75,236, 41,  0,124,
/* 0x01d0 */ 166,  2,168,125,  5,  0,  7, 40, 56,  1,130, 64,  0,  0,166,248,
/* 0x01e0 */  20, 26,132,124,  0,128,  0, 60,198,  7,  0,120,  0,128, 32, 61,
/* 0x01f0 */ 198,  7, 41,121,255,255, 99, 56,255,255,165, 56,255,255, 64, 57,
/* 0x0200 */   0,  1,  0, 72,  1,  0, 32, 57, 46, 24, 41,125,  4,  0, 99, 56,
/* 0x0210 */ 198,  7, 41,121, 64,  0, 41,124, 20, 72, 41,125,  1,  0,128, 57,
/* 0x0220 */ 198,  7,140,121,120, 99, 41,125, 32,  0,128, 78,  1,  0,  3,141,
/* 0x0230 */   1,  0,  5,157, 64,  0, 41,124, 20, 74, 41,125,201,255,194, 65,
/* 0x0240 */ 236,255,225, 65,  1,  0,224, 56, 20,  0,  0, 72,255,255,231, 56,
/* 0x0250 */  21, 72, 41,125,177,255,194, 65, 21, 57,231,124, 21, 72, 41,125,
/* 0x0260 */ 165,255,194, 65, 21, 57,231,124, 64,  0, 41,124, 20, 74, 41,125,
/* 0x0270 */ 149,255,194, 65,216,255,192, 65,  0,  0,  0, 57,253,255,231, 52,
/* 0x0280 */  46, 64,231, 84, 28,  0,192, 65,  1,  0, 67,140,249, 16,234,124,
/* 0x0290 */ 112, 14, 74,125,  0,  0, 42, 44,  0,  0,194, 65, 12,  0,  0, 72,
/* 0x02a0 */  21, 72, 41,125, 97,255,194, 65, 21, 65,  8,125, 21, 72, 41,125,
/* 0x02b0 */  85,255,194, 65, 21, 65,  8,125, 40,  0,130, 64,  1,  0,  0, 57,
/* 0x02c0 */  21, 72, 41,125, 65,255,194, 65, 21, 65,  8,125, 64,  0, 41,124,
/* 0x02d0 */  20, 74, 41,125, 49,255,194, 65,232,255,192, 65,  2,  0,  8, 57,
/* 0x02e0 */ 255,250,234, 32,  1,  0,  8, 57,148,  1,  8,125, 20, 42,234,124,
/* 0x02f0 */ 166,  3,  9,125,  1,  0,  7,141,  1,  0,  5,157,248,255, 32, 67,
/* 0x0300 */   0,  1,224, 56,236, 41,  7,124, 44, 26,  7,124, 40,255,255, 75,
/* 0x0310 */ 236, 41,  0,124,166,  2,168,125,  8,  0,  7, 40, 92,  1,130, 64,
/* 0x0320 */   0,  0,166,248, 20, 26,132,124,  0,128,  0, 60,198,  7,  0,120,
/* 0x0330 */   0,128, 32, 61,198,  7, 41,121,255,255, 99, 56,255,255,165, 56,
/* 0x0340 */ 255,255, 64, 57, 36,  1,  0, 72,  1,  0, 32, 57, 46, 24, 41,125,
/* 0x0350 */   4,  0, 99, 56,198,  7, 41,121, 64,  0, 41,124, 20, 72, 41,125,
/* 0x0360 */   1,  0,128, 57,198,  7,140,121,120, 99, 41,125, 32,  0,128, 78,
/* 0x0370 */   1,  0,  3,141,  1,  0,  5,157, 64,  0, 41,124, 20, 74, 41,125,
/* 0x0380 */ 201,255,194, 65,236,255,225, 65,  1,  0,224, 56, 20,  0,  0, 72,
/* 0x0390 */ 255,255,231, 56, 21, 72, 41,125,177,255,194, 65, 20, 57,231,124,
/* 0x03a0 */  21, 72, 41,125,165,255,194, 65, 20, 57,231,124, 64,  0, 41,124,
/* 0x03b0 */  20, 74, 41,125,149,255,194, 65,216,255,192, 65,  0,  0,  0, 57,
/* 0x03c0 */ 253,255,231, 52, 46, 64,231, 84,255,255,128, 57,198,  7,140,121,
/* 0x03d0 */ 120, 99,231,124, 32,  0,192, 65,  1,  0, 67,140,249, 16,234,124,
/* 0x03e0 */ 112, 14, 74,125,  0,  0,194, 65,  1,  0, 66,112, 80,  0,226, 65,
/* 0x03f0 */  20,  0,  0, 72, 64,  0, 41,124, 20, 74, 41,125, 77,255,194, 65,
/* 0x0400 */  60,  0,225, 65,  1,  0,  0, 57, 64,  0, 41,124, 20, 74, 41,125,
/* 0x0410 */  57,255,194, 65, 40,  0,225, 65, 21, 72, 41,125, 45,255,194, 65,
/* 0x0420 */  20, 65,  8,125, 64,  0, 41,124, 20, 74, 41,125, 29,255,194, 65,
/* 0x0430 */ 232,255,192, 65,  2,  0,  8, 57, 16,  0,  0, 72, 21, 72, 41,125,
/* 0x0440 */   9,255,194, 65, 20, 65,  8,125,255,250,234, 32,  2,  0,  8, 57,
/* 0x0450 */ 148,  1,  8,125, 20, 42,234,124,166,  3,  9,125,  1,  0,  7,141,
/* 0x0460 */   1,  0,  5,157,248,255, 32, 67,  0,  1,224, 56,236, 41,  7,124,
/* 0x0470 */  44, 26,  7,124,  4,255,255, 75,  0,  0,230,232,166,  3,168,125,
/* 0x0480 */  80, 24,100,124, 80, 40,135,124,  1,  0, 99, 56,  1,  0,132, 56,
/* 0x0490 */   0,  0,134,248, 31,  0,231, 96,108, 56,  0,124, 64, 40,  7,124,
/* 0x04a0 */ 172, 63,  0,124, 32,  0,231, 56,240,255,128, 65,172,  4,  0,124,
/* 0x04b0 */  44,  1,  0, 76, 32,  0,128, 78, 14,  0,  7, 40,  0,  0,130, 64,
/* 0x04c0 */ 166,  2,  8,124,120, 51,201,124,  0,  0,  6,129,120, 43,167,124,
/* 0x04d0 */ 254,255,164, 56,  2,  0,131, 56, 48,  0,  1,248,  0,  0,  3,136,
/* 0x04e0 */ 254,232, 11, 84,126,  7,  2, 84,  0,250, 96, 56, 48, 88, 99,124,
/* 0x04f0 */ 124,241, 99, 56,120, 11, 38,124, 20, 26, 33,124, 52,  0, 33, 84,
/* 0x0500 */   0,  0,  0, 56,120, 51,195,124,  0,  0,  9,144,252,255,  3,148,
/* 0x0510 */  64, 24,  1,124,248,255,128, 65,  0,  0,193,144,255,255,  4,136,
/* 0x0520 */   8,  0,225,144, 16,  0,193, 56, 12,  0, 33,145, 20,  0, 97, 56,
/* 0x0530 */  62,225, 11, 84, 62,  7,  0, 84,  2,  0, 67,152,  1,  0, 99,153,
/* 0x0540 */   0,  0,  3,152,124,  8,  2,166,148, 33,255,160,189,193,  0, 24,
/* 0x0550 */ 144,  1,  0,100, 59, 32,  0,  0,137, 67,  0,  2,137, 99,  0,  1,
/* 0x0560 */ 138, 67,  0,  0,147, 38,  0,  0,147, 41,  0,  0,136,  3,  0,  1,
/* 0x0570 */ 125, 40,  3,166,124, 18,  2, 20, 57, 32,  3,  0,125, 41,  0, 48,
/* 0x0580 */  56,  9,  7, 54,127,153,  0, 64, 57, 32,  0,  1,125, 43, 88, 48,
/* 0x0590 */ 125, 41, 80, 48, 57, 41,255,255, 57,107,255,255,145, 33,  0,  8,
/* 0x05a0 */ 124,206, 51,120,124,147, 35,120,124,245, 59,120,125, 20, 67,120,
/* 0x05b0 */ 145, 97,  0, 12, 59,  3,  0,  4, 59,224,  0,  0, 58,224,  0,  0,
/* 0x05c0 */  59, 64,  0,  1, 58, 32,  0,  1, 58,  0,  0,  1, 57,224,  0,  1,
/* 0x05d0 */  57, 32,  0,  0, 64,156,  0, 28,124,  9,  3,166, 57, 96,  4,  0,
/* 0x05e0 */  85, 32,  8, 60,125,120,  3, 46, 57, 41,  0,  1, 66,  0,255,244,
/* 0x05f0 */ 127,179, 42, 20,126,108,155,120, 56,160,  0,  0, 57,  0,255,255,
/* 0x0600 */  57, 96,  0,  0,127,140,232,  0, 57,107,  0,  1, 47, 11,  0,  4,
/* 0x0610 */  84,169, 64, 46, 65,158,  8,156,136, 12,  0,  0, 57,140,  0,  1,
/* 0x0620 */ 125, 37,  3,120, 64,153,255,224,127,153,160, 64, 64,156,  8,100,
/* 0x0630 */  62,192,  0,255, 98,214,255,255,128,  1,  0,  8,127,136,176, 64,
/* 0x0640 */ 127, 35,  0, 56, 86,224, 32, 54,124,  0, 26, 20, 84,  6,  8, 60,
/* 0x0650 */  65,157,  0, 32,127,140,232,  0, 65,158,  8, 88,137, 44,  0,  0,
/* 0x0660 */  84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0670 */ 124,230,194, 46, 85,  0,170,254,125, 64, 57,214,127,133, 80, 64,
/* 0x0680 */  64,156,  1,172,128,  1,  0, 12, 47,151,  0,  6,127, 41,  0, 56,
/* 0x0690 */  32, 18,  0,  8,127,224,  6, 48,125, 41,144, 48,125, 41,  2, 20,
/* 0x06a0 */  29, 41,  6,  0, 32,  7,  8,  0,124,  0, 46,112,124,  7,  2, 20,
/* 0x06b0 */ 125, 56, 74, 20,124,  6,195, 46,125, 72, 83,120, 56,201, 14,108,
/* 0x06c0 */  56, 96,  0,  1, 64,157,  0,180,124, 26,200, 80, 63, 96,  0,255,
/* 0x06d0 */ 127,245,  0,174, 99,123,255,255, 87,255,  8, 60, 87,252,  5,238,
/* 0x06e0 */ 127,136,216, 64, 87,128,  8, 60, 84,100,  8, 60,124,  6,  2, 20,
/* 0x06f0 */ 127, 12,232,  0, 84,169, 64, 46,124,224, 34, 20, 65,157,  0, 24,
/* 0x0700 */  65,154,  7,176,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0710 */ 125, 37,  3,120,161,103,  2,  0, 85,  0,170,254,125, 64, 89,214,
/* 0x0720 */  32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112, 85,105,217,126,
/* 0x0730 */ 124, 11,  2, 20, 47, 28,  0,  0,125,105, 88, 80,124,131, 35,120,
/* 0x0740 */ 125, 10, 64, 80, 64,156,  0, 20,176,  7,  2,  0,125, 72, 83,120,
/* 0x0750 */  65,186,  0, 24, 72,  0,  0, 28,177,103,  2,  0,124,170, 40, 80,
/* 0x0760 */  56,100,  0,  1, 65,154,  0, 12, 47,131,  0,255, 64,157,255,108,
/* 0x0770 */  47,131,  0,255, 65,157,  0,132, 63,224,  0,255, 99,255,255,255,
/* 0x0780 */ 127,136,248, 64, 84,103,  8, 60,127, 12,232,  0, 84,169, 64, 46,
/* 0x0790 */ 124,227, 59,120, 65,157,  0, 24, 65,154,  7, 24,136, 12,  0,  0,
/* 0x07a0 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,125,102, 58, 46,
/* 0x07b0 */  85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,
/* 0x07c0 */ 124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,
/* 0x07d0 */ 125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46,
/* 0x07e0 */  72,  0,  0, 16,124,170, 40, 80,125,102, 59, 46, 56,103,  0,  1,
/* 0x07f0 */  47,131,  0,255, 64,157,255,140, 47,151,  0,  3, 84,127,  6, 62,
/* 0x0800 */ 127,249,169,174, 59, 57,  0,  1, 65,157,  0, 12, 58,224,  0,  0,
/* 0x0810 */  72,  0,  6,120, 47,151,  0,  9, 65,157,  0, 12, 58,247,255,253,
/* 0x0820 */  72,  0,  6,104, 58,247,255,250, 72,  0,  6, 96,125, 10, 64, 80,
/* 0x0830 */ 127,136,176, 64, 84,224,217,126,124,  0, 56, 80, 86,233,  8, 60,
/* 0x0840 */ 124,  6,195, 46,124,170, 40, 80,124,248, 74, 20, 65,157,  0, 32,
/* 0x0850 */ 127,140,232,  0, 65,158,  6, 92,137, 44,  0,  0, 84,160, 64, 46,
/* 0x0860 */ 124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,161,103,  1,128,
/* 0x0870 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 64,
/* 0x0880 */  32, 11,  8,  0, 47,151,  0,  6,124,  0, 46,112,124, 11,  2, 20,
/* 0x0890 */ 176,  7,  1,128,126, 15,131,120,125, 72, 83,120,126, 48,139,120,
/* 0x08a0 */  56,  0,  0,  0,127, 81,211,120, 64,157,  0,  8, 56,  0,  0,  3,
/* 0x08b0 */ 124, 23,  3,120, 56,216,  6,100, 72,  0,  2, 24,125, 10, 64, 80,
/* 0x08c0 */ 127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,
/* 0x08d0 */ 176,  7,  1,128, 65,157,  0, 32,127,140,232,  0, 65,158,  5,212,
/* 0x08e0 */ 137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46,
/* 0x08f0 */  57,140,  0,  1,161,103,  1,152, 85,  0,170,254,125, 64, 89,214,
/* 0x0900 */ 127,133, 80, 64, 64,156,  0,188, 32, 11,  8,  0,127,138,176, 64,
/* 0x0910 */ 124,  0, 46,112, 86,233, 40, 52,124, 11,  2, 20,125, 56, 74, 20,
/* 0x0920 */  84,107,  8, 60,176,  7,  1,152,125, 72, 83,120,124,233, 90, 20,
/* 0x0930 */  65,157,  0, 32,127,140,232,  0, 65,158,  5,120,137, 44,  0,  0,
/* 0x0940 */  84,160, 64, 46,124,  5, 75,120, 85, 72, 64, 46, 57,140,  0,  1,
/* 0x0950 */ 161,103,  1,224, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x0960 */  64,156,  0, 72, 32, 11,  8,  0, 47,153,  0,  0,124,  0, 46,112,
/* 0x0970 */ 124, 11,  2, 20,176,  7,  1,224,125, 72, 83,120, 65,158,  5, 52,
/* 0x0980 */  47,151,  0,  6, 57, 32,  0,  9, 64,157,  0,  8, 57, 32,  0, 11,
/* 0x0990 */ 124, 26,200, 80,127,245,  0,174,125, 55, 75,120,127,249,169,174,
/* 0x09a0 */  59, 57,  0,  1, 72,  0,  4,228, 85, 96,217,126,124,  0, 88, 80,
/* 0x09b0 */ 124,170, 40, 80,125, 10, 64, 80,176,  7,  1,224, 72,  0,  0,252,
/* 0x09c0 */ 125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,
/* 0x09d0 */ 124,170, 40, 80,176,  7,  1,152, 65,157,  0, 32,127,140,232,  0,
/* 0x09e0 */  65,158,  4,208,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,
/* 0x09f0 */  85,  8, 64, 46, 57,140,  0,  1,161,103,  1,176, 85,  0,170,254,
/* 0x0a00 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 32, 32, 11,  8,  0,
/* 0x0a10 */ 124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120,126, 41,139,120,
/* 0x0a20 */ 176,  7,  1,176, 72,  0,  0,140,125, 10, 64, 80,127,136,176, 64,
/* 0x0a30 */  85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,176,  7,  1,176,
/* 0x0a40 */  65,157,  0, 32,127,140,232,  0, 65,158,  4,104,137, 44,  0,  0,
/* 0x0a50 */  84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0a60 */ 161,103,  1,200, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x0a70 */  64,156,  0, 32, 32, 11,  8,  0,124,  0, 46,112,124, 11,  2, 20,
/* 0x0a80 */ 125, 72, 83,120,126,  9,131,120,176,  7,  1,200, 72,  0,  0, 32,
/* 0x0a90 */  85, 96,217,126,124,  0, 88, 80,125,233,123,120,176,  7,  1,200,
/* 0x0aa0 */ 124,170, 40, 80,125, 10, 64, 80,126, 15,131,120,126, 48,139,120,
/* 0x0ab0 */ 127, 81,211,120,125, 58, 75,120, 47,151,  0,  6, 56,  0,  0,  8,
/* 0x0ac0 */  64,157,  0,  8, 56,  0,  0, 11,124, 23,  3,120, 56,216, 10,104,
/* 0x0ad0 */ 127,136,176, 64, 65,157,  0, 32,127,140,232,  0, 65,158,  3,212,
/* 0x0ae0 */ 137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46,
/* 0x0af0 */  57,140,  0,  1,161,102,  0,  0, 85,  0,170,254,125, 64, 89,214,
/* 0x0b00 */ 127,133, 80, 64, 64,156,  0, 48, 32, 11,  8,  0, 84,105, 32, 54,
/* 0x0b10 */ 125, 38, 74, 20,124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120,
/* 0x0b20 */  56,137,  0,  4, 59,128,  0,  0, 59, 96,  0,  3,176,  6,  0,  0,
/* 0x0b30 */  72,  0,  0,156,125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,
/* 0x0b40 */ 124,  0, 88, 80,124,170, 40, 80,176,  6,  0,  0, 65,157,  0, 32,
/* 0x0b50 */ 127,140,232,  0, 65,158,  3, 92,137, 44,  0,  0, 84,160, 64, 46,
/* 0x0b60 */ 124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,161,102,  0,  2,
/* 0x0b70 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 48,
/* 0x0b80 */  32, 11,  8,  0, 84,105, 32, 54,125, 38, 74, 20,124,  0, 46,112,
/* 0x0b90 */ 124, 11,  2, 20,125, 72, 83,120, 56,137,  1,  4, 59,128,  0,  8,
/* 0x0ba0 */  59, 96,  0,  3,176,  6,  0,  2, 72,  0,  0, 36, 85, 96,217,126,
/* 0x0bb0 */ 124,  0, 88, 80,124,170, 40, 80,176,  6,  0,  2,125, 10, 64, 80,
/* 0x0bc0 */  56,134,  2,  4, 59,128,  0, 16, 59, 96,  0,  8,127,105,  3,166,
/* 0x0bd0 */  63,224,  0,255, 99,255,255,255, 56, 96,  0,  1,127,136,248, 64,
/* 0x0be0 */  84,103,  8, 60,127, 12,232,  0, 84,169, 64, 46,124,227, 59,120,
/* 0x0bf0 */  65,157,  0, 24, 65,154,  2,188,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x0c00 */  57,140,  0,  1,125, 37,  3,120,125,100, 58, 46, 85,  0,170,254,
/* 0x0c10 */ 125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112,
/* 0x0c20 */  85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80,
/* 0x0c30 */  64,156,  0, 16,125, 72, 83,120,124,  4, 59, 46, 72,  0,  0, 16,
/* 0x0c40 */ 124,170, 40, 80, 56,103,  0,  1,125,100, 59, 46, 66,  0,255,144,
/* 0x0c50 */  56,  0,  0,  1, 47,151,  0,  3,124,  0,216, 48,124, 96, 24, 80,
/* 0x0c60 */ 124, 99,226, 20, 65,157,  1,232, 47,131,  0,  3, 58,247,  0,  7,
/* 0x0c70 */ 124,105, 27,120, 64,157,  0,  8, 57, 32,  0,  3, 85, 41, 56, 48,
/* 0x0c80 */ 125, 56, 74, 20, 56,201,  3, 96, 57, 32,  0,  6,125, 41,  3,166,
/* 0x0c90 */  63,224,  0,255, 99,255,255,255, 56,128,  0,  1,127,136,248, 64,
/* 0x0ca0 */  84,135,  8, 60,127, 12,232,  0, 84,169, 64, 46,124,228, 59,120,
/* 0x0cb0 */  65,157,  0, 24, 65,154,  1,252,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x0cc0 */  57,140,  0,  1,125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,
/* 0x0cd0 */ 125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112,
/* 0x0ce0 */  85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80,
/* 0x0cf0 */  64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 16,
/* 0x0d00 */ 124,170, 40, 80, 56,135,  0,  1,125,102, 59, 46, 66,  0,255,144,
/* 0x0d10 */  56,132,255,192, 47,132,  0,  3,124,154, 35,120, 64,157,  1, 40,
/* 0x0d20 */  47,132,  0, 13,124,137, 14,112, 84,128,  7,254, 57,105,255,255,
/* 0x0d30 */  96, 26,  0,  2,125,105,  3,166, 65,157,  0, 32,127, 90, 88, 48,
/* 0x0d40 */  87, 73,  8, 60,125, 56, 74, 20, 84,128,  8, 60,125, 32, 72, 80,
/* 0x0d50 */  56,201,  5, 94, 72,  0,  0,100, 57, 41,255,251,125, 41,  3,166,
/* 0x0d60 */  61, 96,  0,255, 97,107,255,255,127,136, 88, 64,127, 12,232,  0,
/* 0x0d70 */  84,169, 64, 46, 87, 90,  8, 60, 65,157,  0, 24, 65,154,  1, 52,
/* 0x0d80 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x0d90 */  85,  8,248,126,127,133, 64, 64, 65,156,  0, 12,124,168, 40, 80,
/* 0x0da0 */  99, 90,  0,  1, 66,  0,255,196, 56,  0,  0,  4,124,  9,  3,166,
/* 0x0db0 */  87, 90, 32, 54, 56,216,  6, 68, 60,128,  0,255, 96,132,255,255,
/* 0x0dc0 */  59,128,  0,  1, 59,224,  0,  1,127,136, 32, 64, 87,231,  8, 60,
/* 0x0dd0 */ 127, 12,232,  0, 84,169, 64, 46,124,255, 59,120, 65,157,  0, 24,
/* 0x0de0 */  65,154,  0,208,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0df0 */ 125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,125, 64, 89,214,
/* 0x0e00 */  32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112, 85,105,217,126,
/* 0x0e10 */ 124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80, 64,156,  0, 16,
/* 0x0e20 */ 125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 20,124,170, 40, 80,
/* 0x0e30 */  59,231,  0,  1,125,102, 59, 46,127, 90,227,120, 87,156,  8, 60,
/* 0x0e40 */  66,  0,255,136, 55, 90,  0,  1, 65,130,  0, 72,127,154,200, 64,
/* 0x0e50 */  56, 99,  0,  2, 65,157,  0, 92,124, 26,200, 80,127,245,  0,174,
/* 0x0e60 */  56, 99,255,255,127,249,169,174, 59, 57,  0,  1, 49, 99,255,255,
/* 0x0e70 */ 125, 43, 25, 16,124, 20,200, 16,124,  0,  1, 16,124,  0,  0,208,
/* 0x0e80 */ 125, 43,  0, 57, 64,130,255,212,127,153,160, 64, 65,156,247,172,
/* 0x0e90 */  60,  0,  0,255, 96,  0,255,255,127,136,  0, 64, 65,157,  0, 32,
/* 0x0ea0 */ 127,140,232,  0, 56, 96,  0,  1, 65,158,  0, 40, 72,  0,  0, 12,
/* 0x0eb0 */  56, 96,  0,  1, 72,  0,  0, 28, 57,140,  0,  1,125, 40,  2,166,
/* 0x0ec0 */ 124, 19, 96, 80,144, 14,  0,  0, 56, 96,  0,  0,147, 41,  0,  0,
/* 0x0ed0 */ 128,  1,  0,100,185,193,  0, 24,124,  8,  3,166, 56, 33,  0, 96,
/* 0x0ee0 */ 124,  8,  2,166,148, 33,255,160,189,193,  0, 24,144,  1,  0,100,
/* 0x0ef0 */  59, 32,  0,  0,137, 67,  0,  2,137, 99,  0,  1,138, 67,  0,  0,
/* 0x0f00 */ 147, 38,  0,  0,147, 41,  0,  0,136,  3,  0,  1,125, 40,  3,166,
/* 0x0f10 */ 124, 18,  2, 20, 57, 32,  3,  0,125, 41,  0, 48, 56,  9,  7, 54,
/* 0x0f20 */ 127,153,  0, 64, 57, 32,  0,  1,125, 43, 88, 48,125, 41, 80, 48,
/* 0x0f30 */  57, 41,255,255, 57,107,255,255,145, 33,  0,  8,124,206, 51,120,
/* 0x0f40 */ 124,147, 35,120,124,245, 59,120,125, 20, 67,120,145, 97,  0, 12,
/* 0x0f50 */  59,  3,  0,  4, 59,224,  0,  0, 58,224,  0,  0, 59, 64,  0,  1,
/* 0x0f60 */  58, 32,  0,  1, 58,  0,  0,  1, 57,224,  0,  1, 57, 32,  0,  0,
/* 0x0f70 */  64,156,  0, 28,124,  9,  3,166, 57, 96,  4,  0, 85, 32,  8, 60,
/* 0x0f80 */ 125,120,  3, 46, 57, 41,  0,  1, 66,  0,255,244,127,179, 42, 20,
/* 0x0f90 */ 126,108,155,120, 56,160,  0,  0, 57,  0,255,255, 57, 96,  0,  0,
/* 0x0fa0 */ 127,140,232,  0, 57,107,  0,  1, 47, 11,  0,  4, 84,169, 64, 46,
/* 0x0fb0 */  65,158,  8,156,136, 12,  0,  0, 57,140,  0,  1,125, 37,  3,120,
/* 0x0fc0 */  64,153,255,224,127,153,160, 64, 64,156,  8,100, 62,192,  0,255,
/* 0x0fd0 */  98,214,255,255,128,  1,  0,  8,127,136,176, 64,127, 35,  0, 56,
/* 0x0fe0 */  86,224, 32, 54,124,  0, 26, 20, 84,  6,  8, 60, 65,157,  0, 32,
/* 0x0ff0 */ 127,140,232,  0, 65,158,  8, 88,137, 44,  0,  0, 84,160, 64, 46,
/* 0x1000 */ 124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,124,230,194, 46,
/* 0x1010 */  85,  0,170,254,125, 64, 57,214,127,133, 80, 64, 64,156,  1,172,
/* 0x1020 */ 128,  1,  0, 12, 47,151,  0,  6,127, 41,  0, 56, 32, 18,  0,  8,
/* 0x1030 */ 127,224,  6, 48,125, 41,144, 48,125, 41,  2, 20, 29, 41,  6,  0,
/* 0x1040 */  32,  7,  8,  0,124,  0, 46,112,124,  7,  2, 20,125, 56, 74, 20,
/* 0x1050 */ 124,  6,195, 46,125, 72, 83,120, 56,201, 14,108, 56, 96,  0,  1,
/* 0x1060 */  64,157,  0,180,124, 26,200, 80, 63, 96,  0,255,127,245,  0,174,
/* 0x1070 */  99,123,255,255, 87,255,  8, 60, 87,252,  5,238,127,136,216, 64,
/* 0x1080 */  87,128,  8, 60, 84,100,  8, 60,124,  6,  2, 20,127, 12,232,  0,
/* 0x1090 */  84,169, 64, 46,124,224, 34, 20, 65,157,  0, 24, 65,154,  7,176,
/* 0x10a0 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x10b0 */ 161,103,  2,  0, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,
/* 0x10c0 */ 127,133, 80, 64,124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,
/* 0x10d0 */  47, 28,  0,  0,125,105, 88, 80,124,131, 35,120,125, 10, 64, 80,
/* 0x10e0 */  64,156,  0, 20,176,  7,  2,  0,125, 72, 83,120, 65,186,  0, 24,
/* 0x10f0 */  72,  0,  0, 28,177,103,  2,  0,124,170, 40, 80, 56,100,  0,  1,
/* 0x1100 */  65,154,  0, 12, 47,131,  0,255, 64,157,255,108, 47,131,  0,255,
/* 0x1110 */  65,157,  0,132, 63,224,  0,255, 99,255,255,255,127,136,248, 64,
/* 0x1120 */  84,103,  8, 60,127, 12,232,  0, 84,169, 64, 46,124,227, 59,120,
/* 0x1130 */  65,157,  0, 24, 65,154,  7, 24,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x1140 */  57,140,  0,  1,125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,
/* 0x1150 */ 125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112,
/* 0x1160 */  85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80,
/* 0x1170 */  64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 16,
/* 0x1180 */ 124,170, 40, 80,125,102, 59, 46, 56,103,  0,  1, 47,131,  0,255,
/* 0x1190 */  64,157,255,140, 47,151,  0,  3, 84,127,  6, 62,127,249,169,174,
/* 0x11a0 */  59, 57,  0,  1, 65,157,  0, 12, 58,224,  0,  0, 72,  0,  6,120,
/* 0x11b0 */  47,151,  0,  9, 65,157,  0, 12, 58,247,255,253, 72,  0,  6,104,
/* 0x11c0 */  58,247,255,250, 72,  0,  6, 96,125, 10, 64, 80,127,136,176, 64,
/* 0x11d0 */  84,224,217,126,124,  0, 56, 80, 86,233,  8, 60,124,  6,195, 46,
/* 0x11e0 */ 124,170, 40, 80,124,248, 74, 20, 65,157,  0, 32,127,140,232,  0,
/* 0x11f0 */  65,158,  6, 92,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,
/* 0x1200 */  85,  8, 64, 46, 57,140,  0,  1,161,103,  1,128, 85,  0,170,254,
/* 0x1210 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 64, 32, 11,  8,  0,
/* 0x1220 */  47,151,  0,  6,124,  0, 46,112,124, 11,  2, 20,176,  7,  1,128,
/* 0x1230 */ 126, 15,131,120,125, 72, 83,120,126, 48,139,120, 56,  0,  0,  0,
/* 0x1240 */ 127, 81,211,120, 64,157,  0,  8, 56,  0,  0,  3,124, 23,  3,120,
/* 0x1250 */  56,216,  6,100, 72,  0,  2, 24,125, 10, 64, 80,127,136,176, 64,
/* 0x1260 */  85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,176,  7,  1,128,
/* 0x1270 */  65,157,  0, 32,127,140,232,  0, 65,158,  5,212,137, 44,  0,  0,
/* 0x1280 */  84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x1290 */ 161,103,  1,152, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x12a0 */  64,156,  0,188, 32, 11,  8,  0,127,138,176, 64,124,  0, 46,112,
/* 0x12b0 */  86,233, 40, 52,124, 11,  2, 20,125, 56, 74, 20, 84,107,  8, 60,
/* 0x12c0 */ 176,  7,  1,152,125, 72, 83,120,124,233, 90, 20, 65,157,  0, 32,
/* 0x12d0 */ 127,140,232,  0, 65,158,  5,120,137, 44,  0,  0, 84,160, 64, 46,
/* 0x12e0 */ 124,  5, 75,120, 85, 72, 64, 46, 57,140,  0,  1,161,103,  1,224,
/* 0x12f0 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 72,
/* 0x1300 */  32, 11,  8,  0, 47,153,  0,  0,124,  0, 46,112,124, 11,  2, 20,
/* 0x1310 */ 176,  7,  1,224,125, 72, 83,120, 65,158,  5, 52, 47,151,  0,  6,
/* 0x1320 */  57, 32,  0,  9, 64,157,  0,  8, 57, 32,  0, 11,124, 26,200, 80,
/* 0x1330 */ 127,245,  0,174,125, 55, 75,120,127,249,169,174, 59, 57,  0,  1,
/* 0x1340 */  72,  0,  4,228, 85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,
/* 0x1350 */ 125, 10, 64, 80,176,  7,  1,224, 72,  0,  0,252,125, 10, 64, 80,
/* 0x1360 */ 127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,
/* 0x1370 */ 176,  7,  1,152, 65,157,  0, 32,127,140,232,  0, 65,158,  4,208,
/* 0x1380 */ 137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46,
/* 0x1390 */  57,140,  0,  1,161,103,  1,176, 85,  0,170,254,125, 64, 89,214,
/* 0x13a0 */ 127,133, 80, 64, 64,156,  0, 32, 32, 11,  8,  0,124,  0, 46,112,
/* 0x13b0 */ 124, 11,  2, 20,125, 72, 83,120,126, 41,139,120,176,  7,  1,176,
/* 0x13c0 */  72,  0,  0,140,125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,
/* 0x13d0 */ 124,  0, 88, 80,124,170, 40, 80,176,  7,  1,176, 65,157,  0, 32,
/* 0x13e0 */ 127,140,232,  0, 65,158,  4,104,137, 44,  0,  0, 84,160, 64, 46,
/* 0x13f0 */ 124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,161,103,  1,200,
/* 0x1400 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 32,
/* 0x1410 */  32, 11,  8,  0,124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120,
/* 0x1420 */ 126,  9,131,120,176,  7,  1,200, 72,  0,  0, 32, 85, 96,217,126,
/* 0x1430 */ 124,  0, 88, 80,125,233,123,120,176,  7,  1,200,124,170, 40, 80,
/* 0x1440 */ 125, 10, 64, 80,126, 15,131,120,126, 48,139,120,127, 81,211,120,
/* 0x1450 */ 125, 58, 75,120, 47,151,  0,  6, 56,  0,  0,  8, 64,157,  0,  8,
/* 0x1460 */  56,  0,  0, 11,124, 23,  3,120, 56,216, 10,104,127,136,176, 64,
/* 0x1470 */  65,157,  0, 32,127,140,232,  0, 65,158,  3,212,137, 44,  0,  0,
/* 0x1480 */  84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x1490 */ 161,102,  0,  0, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x14a0 */  64,156,  0, 48, 32, 11,  8,  0, 84,105, 32, 54,125, 38, 74, 20,
/* 0x14b0 */ 124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120, 56,137,  0,  4,
/* 0x14c0 */  59,128,  0,  0, 59, 96,  0,  3,176,  6,  0,  0, 72,  0,  0,156,
/* 0x14d0 */ 125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,
/* 0x14e0 */ 124,170, 40, 80,176,  6,  0,  0, 65,157,  0, 32,127,140,232,  0,
/* 0x14f0 */  65,158,  3, 92,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,
/* 0x1500 */  85,  8, 64, 46, 57,140,  0,  1,161,102,  0,  2, 85,  0,170,254,
/* 0x1510 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 48, 32, 11,  8,  0,
/* 0x1520 */  84,105, 32, 54,125, 38, 74, 20,124,  0, 46,112,124, 11,  2, 20,
/* 0x1530 */ 125, 72, 83,120, 56,137,  1,  4, 59,128,  0,  8, 59, 96,  0,  3,
/* 0x1540 */ 176,  6,  0,  2, 72,  0,  0, 36, 85, 96,217,126,124,  0, 88, 80,
/* 0x1550 */ 124,170, 40, 80,176,  6,  0,  2,125, 10, 64, 80, 56,134,  2,  4,
/* 0x1560 */  59,128,  0, 16, 59, 96,  0,  8,127,105,  3,166, 63,224,  0,255,
/* 0x1570 */  99,255,255,255, 56, 96,  0,  1,127,136,248, 64, 84,103,  8, 60,
/* 0x1580 */ 127, 12,232,  0, 84,169, 64, 46,124,227, 59,120, 65,157,  0, 24,
/* 0x1590 */  65,154,  2,188,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x15a0 */ 125, 37,  3,120,125,100, 58, 46, 85,  0,170,254,125, 64, 89,214,
/* 0x15b0 */  32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112, 85,105,217,126,
/* 0x15c0 */ 124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80, 64,156,  0, 16,
/* 0x15d0 */ 125, 72, 83,120,124,  4, 59, 46, 72,  0,  0, 16,124,170, 40, 80,
/* 0x15e0 */  56,103,  0,  1,125,100, 59, 46, 66,  0,255,144, 56,  0,  0,  1,
/* 0x15f0 */  47,151,  0,  3,124,  0,216, 48,124, 96, 24, 80,124, 99,226, 20,
/* 0x1600 */  65,157,  1,232, 47,131,  0,  3, 58,247,  0,  7,124,105, 27,120,
/* 0x1610 */  64,157,  0,  8, 57, 32,  0,  3, 85, 41, 56, 48,125, 56, 74, 20,
/* 0x1620 */  56,201,  3, 96, 57, 32,  0,  6,125, 41,  3,166, 63,224,  0,255,
/* 0x1630 */  99,255,255,255, 56,128,  0,  1,127,136,248, 64, 84,135,  8, 60,
/* 0x1640 */ 127, 12,232,  0, 84,169, 64, 46,124,228, 59,120, 65,157,  0, 24,
/* 0x1650 */  65,154,  1,252,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x1660 */ 125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,125, 64, 89,214,
/* 0x1670 */  32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112, 85,105,217,126,
/* 0x1680 */ 124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80, 64,156,  0, 16,
/* 0x1690 */ 125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 16,124,170, 40, 80,
/* 0x16a0 */  56,135,  0,  1,125,102, 59, 46, 66,  0,255,144, 56,132,255,192,
/* 0x16b0 */  47,132,  0,  3,124,154, 35,120, 64,157,  1, 40, 47,132,  0, 13,
/* 0x16c0 */ 124,137, 14,112, 84,128,  7,254, 57,105,255,255, 96, 26,  0,  2,
/* 0x16d0 */ 125,105,  3,166, 65,157,  0, 32,127, 90, 88, 48, 87, 73,  8, 60,
/* 0x16e0 */ 125, 56, 74, 20, 84,128,  8, 60,125, 32, 72, 80, 56,201,  5, 94,
/* 0x16f0 */  72,  0,  0,100, 57, 41,255,251,125, 41,  3,166, 61, 96,  0,255,
/* 0x1700 */  97,107,255,255,127,136, 88, 64,127, 12,232,  0, 84,169, 64, 46,
/* 0x1710 */  87, 90,  8, 60, 65,157,  0, 24, 65,154,  1, 52,136, 12,  0,  0,
/* 0x1720 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120, 85,  8,248,126,
/* 0x1730 */ 127,133, 64, 64, 65,156,  0, 12,124,168, 40, 80, 99, 90,  0,  1,
/* 0x1740 */  66,  0,255,196, 56,  0,  0,  4,124,  9,  3,166, 87, 90, 32, 54,
/* 0x1750 */  56,216,  6, 68, 60,128,  0,255, 96,132,255,255, 59,128,  0,  1,
/* 0x1760 */  59,224,  0,  1,127,136, 32, 64, 87,231,  8, 60,127, 12,232,  0,
/* 0x1770 */  84,169, 64, 46,124,255, 59,120, 65,157,  0, 24, 65,154,  0,208,
/* 0x1780 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x1790 */ 125,102, 58, 46, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,
/* 0x17a0 */ 127,133, 80, 64,124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,
/* 0x17b0 */ 125, 10, 64, 80,125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,
/* 0x17c0 */ 124,  6, 59, 46, 72,  0,  0, 20,124,170, 40, 80, 59,231,  0,  1,
/* 0x17d0 */ 125,102, 59, 46,127, 90,227,120, 87,156,  8, 60, 66,  0,255,136,
/* 0x17e0 */  55, 90,  0,  1, 65,130,  0, 72,127,154,200, 64, 56, 99,  0,  2,
/* 0x17f0 */  65,157,  0, 92,124, 26,200, 80,127,245,  0,174, 56, 99,255,255,
/* 0x1800 */ 127,249,169,174, 59, 57,  0,  1, 49, 99,255,255,125, 43, 25, 16,
/* 0x1810 */ 124, 20,200, 16,124,  0,  1, 16,124,  0,  0,208,125, 43,  0, 57,
/* 0x1820 */  64,130,255,212,127,153,160, 64, 65,156,247,172, 60,  0,  0,255,
/* 0x1830 */  96,  0,255,255,127,136,  0, 64, 65,157,  0, 32,127,140,232,  0,
/* 0x1840 */  56, 96,  0,  1, 65,158,  0, 40, 72,  0,  0, 12, 56, 96,  0,  1,
/* 0x1850 */  72,  0,  0, 28, 57,140,  0,  1,125, 40,  2,166,124, 19, 96, 80,
/* 0x1860 */ 144, 14,  0,  0, 56, 96,  0,  0,147, 41,  0,  0,128,  1,  0,100,
/* 0x1870 */ 185,193,  0, 24,124,  8,  3,166, 56, 33,  0, 96, 12,  0,161,128,
/* 0x1880 */   8,  0,225,128,  0,  0,165,128,  0,  0, 33,128, 20, 58,165,124,
/* 0x1890 */  48,  0,  1,128,255,255,165, 56,166,  3,  8,124, 85, 80, 88, 33,
/* 0x18a0 */ 161,216,208,213,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x18b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,102,105,108,101,
/* 0x18c0 */  32,102,111,114,109, 97,116, 32,101,108,102, 54, 52, 45,112,111,
/* 0x18d0 */ 119,101,114,112, 99,108,101, 10, 10, 83,101, 99,116,105,111,110,
/* 0x18e0 */ 115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32,
/* 0x18f0 */  32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86,
/* 0x1900 */  77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1910 */  32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1920 */  32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,
/* 0x1930 */ 110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 76, 73, 78,
/* 0x1940 */  85, 88, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1950 */  48, 48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1960 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1970 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52,
/* 0x1980 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1990 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x19a0 */  76, 89, 10, 32, 32, 49, 32, 76, 73, 78, 85, 88, 48, 49, 48, 32,
/* 0x19b0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 56, 32, 32, 48,
/* 0x19c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x19d0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x19e0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 52, 56, 32, 32, 50, 42, 42,
/* 0x19f0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x1a00 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50,
/* 0x1a10 */  32, 76, 73, 78, 85, 88, 48, 50, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x1a20 */  48, 48, 48, 48, 48, 54, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1a40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1a50 */  48, 48, 48, 53, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1a60 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1a70 */  32, 32, 51, 32, 76, 73, 78, 85, 88, 48, 51, 48, 32, 32, 32, 32,
/* 0x1a80 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1a90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1aa0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1ab0 */  48, 48, 48, 48, 48, 48, 98, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1ac0 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1ad0 */  76, 89, 10, 32, 32, 52, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32,
/* 0x1ae0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 49, 56, 32, 32, 48,
/* 0x1af0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1b00 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b10 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 98, 52, 32, 32, 50, 42, 42,
/* 0x1b20 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x1b30 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 53,
/* 0x1b40 */  32, 78, 82, 86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48,
/* 0x1b50 */  48, 48, 48, 48, 49, 52, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1b70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1b80 */  48, 48, 49, 99, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1b90 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x1ba0 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 78, 82, 86, 50, 69,
/* 0x1bb0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 54,
/* 0x1bc0 */  56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1bd0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1be0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 49, 48, 32,
/* 0x1bf0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x1c00 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x1c10 */  10, 32, 32, 55, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 32, 32,
/* 0x1c20 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 99, 32, 32, 48, 48, 48,
/* 0x1c30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1c40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1c50 */  32, 48, 48, 48, 48, 48, 52, 55, 56, 32, 32, 50, 42, 42, 48, 32,
/* 0x1c60 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x1c70 */  78, 76, 89, 10, 32, 32, 56, 32, 67, 70, 76, 85, 83, 72, 32, 32,
/* 0x1c80 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 52, 32, 32,
/* 0x1c90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ca0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1cb0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 57, 52, 32, 32, 50, 42,
/* 0x1cc0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1cd0 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 57, 32, 76, 90, 77, 65, 32,
/* 0x1ce0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1cf0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d00 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d10 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 98, 56, 32,
/* 0x1d20 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x1d30 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 48, 32, 76, 90,
/* 0x1d40 */  77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1d50 */  48, 48, 56, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d60 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d70 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52,
/* 0x1d80 */  98, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1d90 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x1da0 */  78, 76, 89, 10, 32, 49, 49, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x1db0 */  49, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 57, 57, 99, 32, 32,
/* 0x1dc0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1dd0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1de0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 53, 52, 52, 32, 32, 50, 42,
/* 0x1df0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1e00 */  65, 68, 79, 78, 76, 89, 10, 32, 49, 50, 32, 76, 90, 77, 65, 95,
/* 0x1e10 */  68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 57, 57,
/* 0x1e20 */  99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e30 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e40 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,101,101, 48, 32,
/* 0x1e50 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x1e60 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 51, 32, 76, 90,
/* 0x1e70 */  77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1e80 */  48, 48, 50, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e90 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ea0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56,
/* 0x1eb0 */  55, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1ec0 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 52,
/* 0x1ed0 */  32, 85, 80, 88, 49, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48,
/* 0x1ee0 */  48, 48, 48, 48, 48, 50, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ef0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1f00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1f10 */  48, 49, 56, 57, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1f20 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1f30 */  83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48,
/* 0x1f40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1f50 */  32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 88, 48, 50, 48,  9,
/* 0x1f60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f70 */  32, 76, 73, 78, 85, 88, 48, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x1f80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1f90 */ 100, 32, 32, 76, 73, 78, 85, 88, 48, 51, 48,  9, 48, 48, 48, 48,
/* 0x1fa0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78,
/* 0x1fb0 */  85, 88, 48, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1fc0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x1fd0 */  82, 86, 95, 84, 65, 73, 76,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1fe0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 95, 84, 65, 73,
/* 0x1ff0 */  76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2000 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,
/* 0x2010 */  68, 69, 67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2020 */  48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,
/* 0x2030 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2040 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 88,
/* 0x2050 */  48, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2060 */  48, 48, 48, 48, 32, 76, 73, 78, 85, 88, 48, 48, 48, 10, 48, 48,
/* 0x2070 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x2080 */  32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 88, 48, 49, 48,  9,
/* 0x2090 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x20a0 */  32, 76, 73, 78, 85, 88, 48, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x20b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x20c0 */ 100, 32, 32, 78, 82, 86, 50, 66,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x20d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 66, 10,
/* 0x20e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x20f0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68,  9, 48,
/* 0x2100 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2110 */  78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2120 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x2130 */  82, 86, 50, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2140 */  48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,
/* 0x2150 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x2160 */  32, 32,100, 32, 32, 67, 70, 76, 85, 83, 72,  9, 48, 48, 48, 48,
/* 0x2170 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 70, 76,
/* 0x2180 */  85, 83, 72, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2190 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77,
/* 0x21a0 */  65,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x21b0 */  48, 48, 32, 76, 90, 77, 65, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x21c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x21d0 */  32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  9, 48, 48, 48, 48,
/* 0x21e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77,
/* 0x21f0 */  65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2200 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x2210 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48,
/* 0x2220 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77,
/* 0x2230 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2240 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x2250 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48,
/* 0x2260 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77,
/* 0x2270 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2280 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x2290 */  32, 85, 80, 88, 49, 72, 69, 65, 68,  9, 48, 48, 48, 48, 48, 48,
/* 0x22a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 85, 80, 88, 49, 72,
/* 0x22b0 */  69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x22c0 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x22d0 */  68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x22e0 */  48, 48, 48, 32,102,105,108,116,101,114, 95,108,101,110,103,116,
/* 0x22f0 */ 104, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2300 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x2310 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2320 */  48, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 10, 82, 69,
/* 0x2330 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x2340 */  32, 70, 79, 82, 32, 91, 76, 73, 78, 85, 88, 48, 48, 48, 93, 58,
/* 0x2350 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2360 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2370 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x2380 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 80, 80, 67,
/* 0x2390 */  54, 52, 95, 82, 69, 76, 50, 52, 32, 32, 32, 32, 32, 76, 73, 78,
/* 0x23a0 */  85, 88, 48, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x23b0 */  48, 48, 48, 48, 48, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82,
/* 0x23c0 */  69, 76, 50, 52, 32, 32, 32, 32, 32, 76, 73, 78, 85, 88, 48, 50,
/* 0x23d0 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x23e0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 73, 78, 85, 88,
/* 0x23f0 */  48, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x2400 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x2410 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x2420 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2430 */  82, 95, 80, 80, 67, 54, 52, 95, 65, 68, 68, 82, 51, 50, 32, 32,
/* 0x2440 */  32, 32,102,105,108,116,101,114, 95,108,101,110,103,116,104, 10,
/* 0x2450 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x2460 */  32, 82, 95, 80, 80, 67, 54, 52, 95, 65, 68, 68, 82, 51, 50, 32,
/* 0x2470 */  32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 10, 82,
/* 0x2480 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x2490 */  83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 93, 58, 10, 79,
/* 0x24a0 */  70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x24b0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x24c0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x24d0 */  48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 80, 80, 67, 54, 52,
/* 0x24e0 */  95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 78, 82, 86, 95, 84,
/* 0x24f0 */  65, 73, 76, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x2500 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86,
/* 0x2510 */  50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32,
/* 0x2520 */  32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x2530 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x2540 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82,
/* 0x2550 */  95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32,
/* 0x2560 */  32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 10, 82, 69, 76, 79, 67,
/* 0x2570 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x2580 */  82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x2590 */  84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69,
/* 0x25a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x25b0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x25c0 */  48, 48,100, 52, 32, 82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76,
/* 0x25d0 */  49, 52, 32, 32, 32, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10,
/* 0x25e0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x25f0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 69, 76,
/* 0x2600 */  70, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x2610 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x2620 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x2630 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 32,
/* 0x2640 */  82, 95, 80, 80, 67, 54, 52, 95, 82, 69, 76, 49, 52, 32, 32, 32,
/* 0x2650 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 43, 48,120, 48,
/* 0x2660 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 48, 10
};
