/* arm.v5a-linux.shlib-init.h
   created from arm.v5a-linux.shlib-init.bin, 15734 (0x3d76) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2022 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2022 Laszlo Molnar
   Copyright (C) 2000-2022 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_ARM_V5A_LINUX_SHLIB_INIT_SIZE    15734
#define STUB_ARM_V5A_LINUX_SHLIB_INIT_ADLER32 0x69ff57ca
#define STUB_ARM_V5A_LINUX_SHLIB_INIT_CRC32   0xe02a78d2

unsigned char stub_arm_v5a_linux_shlib_init[15734] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 40,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 248, 21,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0,  0,  0,160,225,247,200, 45,233, 13,176,160,225,
/* 0x0040 */  36,224,139,229,254,255,255,235,252, 64, 45,233,  0,112,129,224,
/* 0x0050 */   0, 80,224,227,  2, 65,160,227, 24,  0,  0,234, 24,  0,189,232,
/* 0x0060 */   7,  0, 64,224,  3, 32, 66,224,  0, 32,132,229,  0, 64,160,225,
/* 0x0070 */   3,  0,160,225,  2, 16,131,224,  0, 32,160,227,  7,192,160,225,
/* 0x0080 */   2,112,160,227, 15,120,135,227,  0,  0,  0,239, 12,112,160,225,
/* 0x0090 */   4,  0,160,225,240,128,189,232,  1, 64,208,228,  4, 64,164,224,
/* 0x00a0 */   4, 76,176,225, 14,240,160,225,  1, 48,208,228,  1, 48,194,228,
/* 0x00b0 */   4, 64,148,224, 18,  0,  0, 11, 22,  0,  0, 42,  1, 16,160,227,
/* 0x00c0 */  33,  0,  0,234,  1, 16, 65,226,  4, 64,148,224, 18,  0,  0, 11,
/* 0x00d0 */   1, 16,161,224,  4, 64,148,224, 18,  0,  0, 11,  1, 16,161,224,
/* 0x00e0 */   4, 64,148,224, 18,  0,  0, 11, 29,  0,  0, 58,  3, 48, 81,226,
/* 0x00f0 */   0, 16,160,227, 49,  0,  0, 58,  1, 80,208,228,  3, 84,133,225,
/* 0x0100 */   5, 80,240,225,  3,  0,  0, 10,197, 80,176,225, 64,  0,  0, 42,
/* 0x0110 */  52,  0,  0,234,  4, 64,148,224, 18,  0,  0, 11, 64,  0,  0, 42,
/* 0x0120 */   1, 16,160,227,  4, 64,148,224, 18,  0,  0, 11, 64,  0,  0, 42,
/* 0x0130 */   4, 64,148,224, 18,  0,  0, 11,  1, 16,161,224,  4, 64,148,224,
/* 0x0140 */  18,  0,  0, 11, 56,  0,  0, 58,  4, 16,129,226, 68,  0,  0,234,
/* 0x0150 */   4, 64,148,224, 18,  0,  0, 11,  1, 16,161,224,  2, 16,129,226,
/* 0x0160 */   5, 12,117,227,  1, 16,129, 50,  1, 48,130,224,  1, 48, 83,229,
/* 0x0170 */   5, 48,210,231,  1, 48,194,228,  1, 16, 81,226, 72,  0,  0, 26,
/* 0x0180 */  24,  0,  0,234,252, 64, 45,233,  0,112,129,224,  0, 80,224,227,
/* 0x0190 */   2, 65,160,227, 24,  0,  0,234, 24,  0,189,232,  7,  0, 64,224,
/* 0x01a0 */   3, 32, 66,224,  0, 32,132,229,  0, 64,160,225,  3,  0,160,225,
/* 0x01b0 */   2, 16,131,224,  0, 32,160,227,  7,192,160,225,  2,112,160,227,
/* 0x01c0 */  15,120,135,227,  0,  0,  0,239, 12,112,160,225,  4,  0,160,225,
/* 0x01d0 */ 240,128,189,232,  1, 64,208,228,  4, 64,164,224,  4, 76,176,225,
/* 0x01e0 */  14,240,160,225,  1, 48,208,228,  1, 48,194,228,  4, 64,148,224,
/* 0x01f0 */  18,  0,  0, 11, 22,  0,  0, 42,  1, 16,160,227, 33,  0,  0,234,
/* 0x0200 */   1, 16, 65,226,  4, 64,148,224, 18,  0,  0, 11,  1, 16,177,224,
/* 0x0210 */   4, 64,148,224, 18,  0,  0, 11,  1, 16,177,224,  4, 64,148,224,
/* 0x0220 */  18,  0,  0, 11, 29,  0,  0, 58,  3, 48, 81,226,  0, 16,160,227,
/* 0x0230 */  48,  0,  0, 58,  1, 80,208,228,  3, 84,133,225,  5, 80,240,225,
/* 0x0240 */   3,  0,  0, 10,197, 80,176,225, 50,  0,  0,234,  4, 64,148,224,
/* 0x0250 */  18,  0,  0, 11,  1, 16,177,224,  4, 64,148,224, 18,  0,  0, 11,
/* 0x0260 */   1, 16,177,224, 63,  0,  0, 26,  1, 16,160,227,  4, 64,148,224,
/* 0x0270 */  18,  0,  0, 11,  1, 16,177,224,  4, 64,148,224, 18,  0,  0, 11,
/* 0x0280 */  56,  0,  0, 58,  2, 16,129,226,  1, 16,129,226,  5, 12,117,227,
/* 0x0290 */   1, 16,129, 50,  0, 48,210,229,  5, 48,210,231,  1, 48,194,228,
/* 0x02a0 */   1, 16, 81,226, 67,  0,  0, 26, 24,  0,  0,234,  0, 16,129,224,
/* 0x02b0 */  62, 64, 45,233,  0, 80,224,227,  2, 65,160,227, 33,  0,  0,234,
/* 0x02c0 */  26,  0,189,232,  1,  0, 64,224,  3, 32, 66,224,  0, 32,132,229,
/* 0x02d0 */   0, 64,160,225,  3,  0,160,225,  2, 16,131,224,  0, 32,160,227,
/* 0x02e0 */   7,192,160,225,  2,112,160,227, 15,120,135,227,  0,  0,  0,239,
/* 0x02f0 */  12,112,160,225,  4,  0,160,225, 48,128,189,232,  4, 64,148,224,
/* 0x0300 */  14,240,160, 17,  1, 64,208,228,  4, 64,164,224,  4, 76,176,225,
/* 0x0310 */  14,240,160,225,  1, 16,160,227, 14,192,160,225, 18,  0,  0,235,
/* 0x0320 */   1, 16,177,224, 18,  0,  0,235, 26,  0,  0, 58, 12,240,160,225,
/* 0x0330 */   1, 48,208,228,  1, 48,194,228, 18,  0,  0,235, 31,  0,  0, 42,
/* 0x0340 */  24,  0,  0,235,  3, 48, 81,226,  0, 16,160,227, 43,  0,  0, 58,
/* 0x0350 */   1, 80,208,228,  3, 84,133,225,  5, 80,240,225,  3,  0,  0, 10,
/* 0x0360 */  18,  0,  0,235,  1, 16,177,224, 18,  0,  0,235,  1, 16,177,224,
/* 0x0370 */  50,  0,  0, 26, 24,  0,  0,235,  2, 16,129,226, 13, 12,117,227,
/* 0x0380 */   1, 16,129, 50,  5, 48,210,231,  1, 16, 81,226,  1, 48,194,228,
/* 0x0390 */  52,  0,  0, 42, 33,  0,  0,234,  0,192,157,229, 14,  0, 92,227,
/* 0x03a0 */  44,  0,  0, 26, 12, 72, 45,233,  0,176,208,229,  6,204,160,227,
/* 0x03b0 */ 171,177,160,225, 28,203,160,225, 13,176,160,225, 58,205,140,226,
/* 0x03c0 */  12,208, 77,224,  0,192,147,229,  8, 48,141,229,  4,192,141,229,
/* 0x03d0 */   0, 32,141,229, 12, 48,141,226,  0,192,160,227,  4,192,131,228,
/* 0x03e0 */  11,  0, 83,225, 15,  0,  0, 26, 12, 48,141,226,  2, 32, 65,226,
/* 0x03f0 */   0, 16,160,225,  1,192,209,228,  7,192, 12,226, 18,192,205,229,
/* 0x0400 */   1,192,209,228, 44,  2,160,225, 17,  0,205,229, 15,192, 12,226,
/* 0x0410 */  16,192,205,229, 16,  0,141,226, 45,  0,  0,235, 11,208,160,225,
/* 0x0420 */   0, 48,160,225,  3,  0,189,232,  0, 16,145,229,  0, 16,129,224,
/* 0x0430 */   0, 32,160,227,  7,192,160,225,  2,112,160,227, 15,120,135,227,
/* 0x0440 */   0,  0,  0,239, 12,112,160,225,  3,  0,160,225,  0,136,189,232,
/* 0x0450 */ 240,  1,240,231,240, 79, 45,233, 48,208, 77,226,  0, 48,141,229,
/* 0x0460 */   0, 48,208,229,  2, 80,208,229,  1,224,208,229,  0,192,157,229,
/* 0x0470 */  20, 48,141,229, 92, 48,157,229,  0, 64,160,227,  0, 64,140,229,
/* 0x0480 */   0, 64,131,229, 20,192,157,229,  1, 48,208,229,  3, 48,140,224,
/* 0x0490 */   3,204,160,227, 28,195,160,225,  1, 48,160,227, 19,238,160,225,
/* 0x04a0 */  19, 53,160,225,115,206,140,226,  1, 48, 67,226,  1,224, 78,226,
/* 0x04b0 */   4,  0,128,226,  6,192,140,226,  4, 16,141,229, 12, 48,141,229,
/* 0x04c0 */  16,224,141,229,  8,  0,141,229, 31,  0,  0,234,  8,  0,157,229,
/* 0x04d0 */   1, 27,160,227,176, 16,131,225, 12,  0, 84,225,132, 48,160,225,
/* 0x04e0 */   1, 64,132,226, 28,  0,  0, 26,  4, 48,157,229,  0, 96,160,227,
/* 0x04f0 */   2,144,131,224,  3,224,160,225,  6, 32,160,225,  4, 80,157,229,
/* 0x0500 */   9, 48,101,224,  3,  0, 82,225,  1,224,142,226, 73,  2,  0, 10,
/* 0x0510 */   5, 48,210,231,  1, 32,130,226,  5,  0, 82,227,  6,100,131,225,
/* 0x0520 */  40,  0,  0, 26,  0,176,160,227,  1,192,160,227, 11,112,160,225,
/* 0x0530 */   0,  0,224,227, 44,192,141,229, 24,176,141,229, 28,192,141,229,
/* 0x0540 */  32,192,141,229, 36,192,141,229, 57,  2,  0,234,255,132,224,227,
/* 0x0550 */   8,  0, 80,225, 68,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,
/* 0x0560 */   1, 48,222,228,  0,  4,160,225,  6,100,131,225, 12, 16,157,229,
/* 0x0570 */  24, 32,157,229,  1,160, 11,224,  2, 18,160,225,  1, 48,138,224,
/* 0x0580 */ 131, 80,160,225,  8, 48,157,229,181,192,147,225,160, 53,160,225,
/* 0x0590 */ 156,  3,  4,224,  4,  0, 86,225,185,  0,  0, 42, 20,  0,157,229,
/* 0x05a0 */   8, 48, 96,226, 87, 51,160,225, 16, 16,157,229,  1, 32, 11,224,
/* 0x05b0 */  18, 48,131,224,  8,  0,157,229,  6, 44,160,227,147,  2, 34,224,
/* 0x05c0 */  24, 16,157,229,  2, 59,108,226,  6,  0, 81,227,195, 50,140,224,
/* 0x05d0 */ 230,142,130,226,181, 48,128,225, 12,128,136,226,  4,  0,160,209,
/* 0x05e0 */   1, 16,160,211,164,  0,  0,218, 44, 32,157,229, 84, 80,157,229,
/* 0x05f0 */  11, 48, 98,224,  3,112,213,231,  4,  0,160,225,  1, 16,160,227,
/* 0x0600 */ 135,112,160,225,  1, 92,  7,226,129,160,160,225,133, 48,136,224,
/* 0x0610 */  10, 48,131,224,  1,  4, 80,227,  2, 76,131,226,  1,192,129,226,
/* 0x0620 */ 119,  0,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,
/* 0x0630 */   1, 48,222,228,  6,100,131,225,176, 48,212,225,160, 37,160,225,
/* 0x0640 */  12, 16,129,224,147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,
/* 0x0650 */ 194, 34,131,224,163, 50, 67,224,135,  0,  0, 42,  0,  0, 85,227,
/* 0x0660 */  12,  0,160,225,176, 32,196,225, 10, 16,160,225,140,  0,  0, 10,
/* 0x0670 */  12,  0,160,225,164,  0,  0,234,  0,  0, 85,227,176, 48,196,225,
/* 0x0680 */   6, 96,108,224,  0,  0,108,224,164,  0,  0, 10,255,  0, 81,227,
/* 0x0690 */ 168,  0,  0,202,105,  0,  0,234,  1,  4, 80,227,  3, 16,129,224,
/* 0x06a0 */ 151,  0,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,
/* 0x06b0 */   1, 48,222,228,  6,100,131,225,180, 48,152,225,160, 37,160,225,
/* 0x06c0 */ 147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,163, 82, 67,224,
/* 0x06d0 */ 194, 50,131,224,180, 48,136, 49,180, 80,136, 33,  0,  0,108,224,
/* 0x06e0 */   4, 16,160, 49, 12,  0,160, 49,  6, 96,108, 32,255,  0, 81,227,
/* 0x06f0 */ 129, 64,160,225,  1, 48,129,226,143,  0,  0,218, 24,192,157,229,
/* 0x0700 */ 255,112,  1,226,  3,  0, 92,227, 84, 16,157,229,  0, 32,160,211,
/* 0x0710 */  11,112,193,231,  1,176,139,226, 24, 32,141,213, 57,  2,  0,218,
/* 0x0720 */  24, 48,157,229,  9,  0, 83,227, 24, 80,157,197,  3, 48, 67,210,
/* 0x0730 */   6, 80, 69,194, 24, 48,141,213, 24, 80,141,197, 57,  2,  0,234,
/* 0x0740 */ 172, 50, 76,224,  0, 32,100,224,  8,192,157,229,  8,  0, 82,225,
/* 0x0750 */ 181, 48,140,225,  6, 96,100,224,197,  0,  0,138,  9,  0, 94,225,
/* 0x0760 */  73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,  6,100,131,225,
/* 0x0770 */   8,  0,157,229, 24, 48,157,229,131,112,128,224,  6, 13,135,226,
/* 0x0780 */ 176,192,208,225,162, 53,160,225,156,  3,  4,224,  4,  0, 86,225,
/* 0x0790 */ 225,  0,  0, 42, 24, 32,157,229,  8, 80,157,229,  6,  0, 82,227,
/* 0x07a0 */   2, 59,108,226,102, 30,133,226,  3, 32,160,195, 32, 80,157,229,
/* 0x07b0 */   0, 32,160,211,195, 50,140,224, 24, 32,141,229, 28,192,157,229,
/* 0x07c0 */  44, 32,157,229, 36, 80,141,229,  4, 16,129,226,  4, 80,160,225,
/* 0x07d0 */  32,192,141,229, 28, 32,141,229,176, 48,192,225, 98,  1,  0,234,
/* 0x07e0 */   2, 32,100,224,172, 50, 76,224,  8,  0, 82,225,176, 48,192,225,
/* 0x07f0 */   6, 96,100,224,236,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,
/* 0x0800 */   1, 48,222,228,  2, 36,160,225,  6,100,131,225,102, 95,135,226,
/* 0x0810 */ 176,192,213,225,162, 53,160,225,156,  3,  4,224,  4,  0, 86,225,
/* 0x0820 */  26,  1,  0, 42,  2, 59,108,226,195, 50,140,224,  8,  0, 84,225,
/* 0x0830 */ 176, 48,197,225,252,  0,  0,138,  9,  0, 94,225, 73,  2,  0, 10,
/* 0x0840 */   1, 48,222,228,  4, 68,160,225,  6,100,131,225,  8, 80,157,229,
/* 0x0850 */ 129, 48,133,224,138, 48,131,224, 30, 30,131,226,176,192,209,225,
/* 0x0860 */ 164, 53,160,225,156,  3,  2,224,  2,  0, 86,225,  6, 96, 98, 32,
/* 0x0870 */ 172, 50, 76, 32,  4, 80, 98, 32, 50,  1,  0, 42,  2, 59,108,226,
/* 0x0880 */ 195, 50,140,224,  0,  0, 91,227,176, 48,193,225, 73,  2,  0, 10,
/* 0x0890 */  44,192,157,229, 24, 16,157,229, 84,  0,157,229, 11, 48,108,224,
/* 0x08a0 */   3,112,208,231,  6,  0, 81,227, 11, 16,160,195,  9, 16,160,211,
/* 0x08b0 */  24, 16,141,229, 11,112,192,231,  2,  0,160,225,  1,176,139,226,
/* 0x08c0 */  57,  2,  0,234,  2, 32,100,224,172, 50, 76,224,  8,  0, 82,225,
/* 0x08d0 */ 176, 48,197,225,  6, 96,100,224, 37,  1,  0,138,  9,  0, 94,225,
/* 0x08e0 */  73,  2,  0, 10,  1, 48,222,228,  2, 36,160,225,  6,100,131,225,
/* 0x08f0 */  27, 30,135,226,176,192,209,225,162, 53,160,225,156,  3,  4,224,
/* 0x0900 */   4,  0, 86,225, 52,  1,  0, 42, 44, 80,157,229,  2, 59,108,226,
/* 0x0910 */  28, 32,157,229,195, 50,140,224, 28, 80,141,229,  4, 80,160,225,
/* 0x0920 */  44, 32,141,229,176, 48,193,225, 90,  1,  0,234,  2, 32,100,224,
/* 0x0930 */ 172, 50, 76,224,  8,  0, 82,225,176, 48,193,225,  6, 96,100,224,
/* 0x0940 */  63,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x0950 */   2, 36,160,225,  6,100,131,225,114, 31,135,226,176,192,209,225,
/* 0x0960 */ 162, 53,160,225,156,  3,  4,224,  4,  0, 86,225, 78,  1,  0, 42,
/* 0x0970 */   2, 59,108,226, 32, 32,157,229,195, 50,140,224, 44,  0,157,229,
/* 0x0980 */  28,192,157,229,  4, 80,160,225, 32,192,141,229, 28,  0,141,229,
/* 0x0990 */  49,  1,  0,234,172, 50, 76,224,176, 48,193,225, 44,192,157,229,
/* 0x09a0 */  32, 16,141,226, 10,  0,145,232,  2, 80,100,224, 28, 32,157,229,
/* 0x09b0 */  36, 16,141,229, 32, 32,141,229, 28,192,141,229, 44, 48,141,229,
/* 0x09c0 */   6, 96,100,224, 24, 32,157,229,  8,  0,157,229,  6,  0, 82,227,
/* 0x09d0 */  11, 32,160,195,  8, 32,160,211,166, 30,128,226, 24, 32,141,229,
/* 0x09e0 */   8, 16,129,226,255,116,224,227,  7,  0, 85,225,106,  1,  0,138,
/* 0x09f0 */   9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,  5, 84,160,225,
/* 0x0a00 */   6,100,131,225,176,192,209,225,165, 53,160,225,156,  3,  4,224,
/* 0x0a10 */   4,  0, 86,225,120,  1,  0, 42, 10, 34,129,224,  2, 59,108,226,
/* 0x0a20 */ 195, 50,140,224,  4, 80,130,226,  4,  0,160,225,  3,160,160,227,
/* 0x0a30 */   0,128,160,227,176, 48,193,225,152,  1,  0,234,  5, 32,100,224,
/* 0x0a40 */ 172, 50, 76,224,  7,  0, 82,225,  6, 96,100,224,176, 48,193,225,
/* 0x0a50 */ 131,  1,  0,138,  9,  0, 94,225, 73,  2,  0, 10,  1, 48,222,228,
/* 0x0a60 */   2, 36,160,225,  6,100,131,225,178,192,209,225,162, 53,160,225,
/* 0x0a70 */ 156,  3,  4,224,  4,  0, 86,225,145,  1,  0, 42, 10, 34,129,224,
/* 0x0a80 */   2, 59,108,226,195, 50,140,224, 65, 95,130,226,  4,  0,160,225,
/* 0x0a90 */   3,160,160,227,  8,128,160,227,178, 48,193,225,152,  1,  0,234,
/* 0x0aa0 */ 172, 50, 76,224,178, 48,193,225,  6, 96,100,224,  2,  0,100,224,
/* 0x0ab0 */ 129, 95,129,226,  8,160,160,227, 16,128,160,227, 10,112,160,225,
/* 0x0ac0 */   1, 16,160,227,  1, 48,129,226,  1,  4, 80,227,129, 64,160,225,
/* 0x0ad0 */   3, 16,129,224,164,  1,  0, 42,  9,  0, 94,225,  0,  4,160,225,
/* 0x0ae0 */  73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,180, 48,149,225,
/* 0x0af0 */ 160, 37,160,225,147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,
/* 0x0b00 */ 194, 34,131,224,163, 50, 67,224,  0,  0,108,224,  4, 16,160, 49,
/* 0x0b10 */  12,  0,160, 49,180, 32,133, 49,  6, 96,108, 32,180, 48,133, 33,
/* 0x0b20 */   1,112, 87,226,154,  1,  0, 26,  1, 32,160,227, 18, 58, 65,224,
/* 0x0b30 */  24, 80,157,229,  8, 48,131,224,  3,  0, 85,227, 40, 48,141,229,
/* 0x0b40 */  36,  2,  0,202,  8,192,157,229,  3,  0, 83,227,  3, 48,160,163,
/* 0x0b50 */ 131, 51,140,224, 54, 94,131,226,  2,112,160,225,  6,128,160,227,
/* 0x0b60 */   1, 48,135,226,  1,  4, 80,227,135, 64,160,225,  3,112,135,224,
/* 0x0b70 */ 203,  1,  0, 42,  9,  0, 94,225,  0,  4,160,225, 73,  2,  0, 10,
/* 0x0b80 */   1, 48,222,228,  6,100,131,225,180, 48,149,225,160, 37,160,225,
/* 0x0b90 */ 147,  2, 12,224,  2, 43, 99,226, 12,  0, 86,225,194, 34,131,224,
/* 0x0ba0 */ 163, 50, 67,224,  0,  0,108,224,  4,112,160, 49, 12,  0,160, 49,
/* 0x0bb0 */ 180, 32,133, 49,  6, 96,108, 32,180, 48,133, 33,  1,128, 88,226,
/* 0x0bc0 */ 193,  1,  0, 26, 64, 32, 71,226,  3,  0, 82,227,  2, 80,160,209,
/* 0x0bd0 */  30,  2,  0,218,194, 64,160,225, 13,  0, 82,227,  1, 48,  2,226,
/* 0x0be0 */   1,112, 68,226,  2,192,131,227,  5, 64, 68,194,  8, 32,160,193,
/* 0x0bf0 */ 237,  1,  0,202, 28, 87,160,225,  8, 16,157,229,133, 48,129,224,
/* 0x0c00 */ 130, 48, 67,224, 85, 78,131,226, 14, 64,132,226,  1,  2,  0,234,
/* 0x0c10 */   1,  4, 80,227,  1, 32,130,226,245,  1,  0, 42,  9,  0, 94,225,
/* 0x0c20 */   0,  4,160,225, 73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,
/* 0x0c30 */ 160,  0,160,225,  0,  0, 86,225,140,192,160,225,  6, 96, 96, 32,
/* 0x0c40 */   1,192,140, 35,  4,  0, 82,225,237,  1,  0, 26,  8, 32,157,229,
/* 0x0c50 */  25, 77,130,226,  4, 64,132,226, 12, 82,160,225,  4,112,160,227,
/* 0x0c60 */   1,160,160,227, 10,128,160,225,  1,  4, 80,227,136, 16,160,225,
/* 0x0c70 */   1,192,136,226, 12,  2,  0, 42,  9,  0, 94,225,  0,  4,160,225,
/* 0x0c80 */  73,  2,  0, 10,  1, 48,222,228,  6,100,131,225,177, 48,148,225,
/* 0x0c90 */ 160, 37,160,225, 12,128,136,224,147,  2, 12,224,  2, 43, 99,226,
/* 0x0ca0 */  12,  0, 86,225,194, 34,131,224,163, 50, 67,224, 10, 80,133, 33,
/* 0x0cb0 */   1,128,160, 49, 12,  0,160, 49,177, 32,132, 49,177, 48,132, 33,
/* 0x0cc0 */   6, 96,108, 32,  0,  0,108, 32,  1,112, 87,226,138,160,160,225,
/* 0x0cd0 */   3,  2,  0, 26,  1, 80,149,226, 44, 80,141,229, 60,  2,  0, 10,
/* 0x0ce0 */  24, 48,157,229,  7, 48,131,226, 24, 48,141,229, 44, 80,157,229,
/* 0x0cf0 */  11,  0, 85,225, 73,  2,  0,138, 40,192,157,229, 84, 16,157,229,
/* 0x0d00 */  11, 48,101,224,  2, 32,140,226,  3, 64,129,224, 11,192,129,224,
/* 0x0d10 */   1, 32, 82,226, 88, 80,157,229,  0, 48,160,  3,  1, 48,160, 19,
/* 0x0d20 */   1,176,139,226,  5,  0, 91,225,  0, 48,160, 35,  1, 48,  3, 50,
/* 0x0d30 */   1,112,212,228,  0,  0, 83,227,  1,112,204,228, 45,  2,  0, 26,
/* 0x0d40 */  88,192,157,229, 12,  0, 91,225, 60,  0,  0, 58,  1,  4, 80,227,
/* 0x0d50 */  65,  2,  0, 42,  9,  0, 94,225, 73,  2,  0, 10,  1,224,142,226,
/* 0x0d60 */   4,  0,157,229,  0, 16,157,229, 92, 32,157,229, 14, 48, 96,224,
/* 0x0d70 */   0,  0,160,227,  0, 48,129,229,  0,176,130,229, 74,  2,  0,234,
/* 0x0d80 */   1,  0,160,227, 48,208,141,226,240,143,189,232,248, 79, 45,233,
/* 0x0d90 */   1,192,130,224, 40,144,157,229, 44,112,157,229,  1,128,160,225,
/* 0x0da0 */   9,160,135,224,  4,176,128,226,  0, 96,208,229,  1, 80,208,229,
/* 0x0db0 */   2, 64,208,229,  6,224,133,224,  0,112,224,227, 23, 85,224,225,
/* 0x0dc0 */  23, 68,224,225,  1, 48,160,227,  1, 32,160,227,  1, 16,160,227,
/* 0x0dd0 */   1,  0,160,227,255, 95, 45,233,  0, 96,160,227, 28, 96,141,229,
/* 0x0de0 */   3, 44,160,227, 18, 46,160,225, 54, 32,130,226,  7, 44,130,226,
/* 0x0df0 */  11, 16,160,225,  1, 11,160,227,  1,  3,128,227,  4,  0,129,228,
/* 0x0e00 */   2, 32, 82,226, 26,  0,  0,202,  5,  0,136,226,  5,  1,  0,235,
/* 0x0e10 */   8,  0, 80,225, 30,  0,  0, 26, 36, 48,157,229, 16, 32,157,229,
/* 0x0e20 */   3, 64, 73,224,  2,  0,  4,224, 44,  0,141,229,  6,  2,128,224,
/* 0x0e30 */   0, 16,139,226,  9,  1,  0,235, 80,  0,  0, 26, 20, 48,157,229,
/* 0x0e40 */  24, 32,157,229,  4, 48,  3,224, 28,  0,221,229, 19, 50,160,225,
/* 0x0e50 */   8, 32, 98,226, 48, 50,131,224,108,160,139,226,131, 48,131,224,
/* 0x0e60 */  14,172,138,226,  1,  0,160,227,131,164,138,224,  7,  0, 86,227,
/* 0x0e70 */  69,  0,  0, 58,  0, 16,157,229,  1, 80, 89,231,133, 80,160,225,
/* 0x0e80 */   2, 28,138,226,  1, 76,  5,226,132, 16,129,224, 11,  1,  0,235,
/* 0x0e90 */   1, 48,  0,226, 36,  4, 83,225, 71,  0,  0, 26,  1, 12, 80,227,
/* 0x0ea0 */  58,  0,  0, 58, 73,  0,  0,234, 10, 16,160,225, 11,  1,  0,235,
/* 0x0eb0 */   1, 12, 80,227, 69,  0,  0, 58,  6, 48,160,227, 10,  0, 86,227,
/* 0x0ec0 */   3, 48,160, 51,  4,  0, 86,227,  6, 48,160, 49,  3, 96, 70,224,
/* 0x0ed0 */ 112,  0,  0,234,  6, 29,139,226,  8,  1,  0,235, 95,  0,  0, 26,
/* 0x0ee0 */   8, 48,157,229,  4, 32,157,229,  0, 16,157,229, 12, 48,141,229,
/* 0x0ef0 */   8, 32,141,229,  4, 16,141,229,  7,  0, 86,227,  3, 96,160,227,
/* 0x0f00 */   0, 96,160, 51,100,160,139,226,  6,172,138,226,135,  0,  0,234,
/* 0x0f10 */ 102, 31,139,226,  8,  1,  0,235,114,  0,  0, 26, 44, 48,157,229,
/* 0x0f20 */  30, 30,139,226,  6,  2,131,224,  9,  1,  0,235,130,  0,  0, 26,
/* 0x0f30 */   7,  0, 86,227, 11, 96,160,227,  9, 96,160, 51, 36, 48,157,229,
/* 0x0f40 */   0, 16,157,229,  3, 64, 73,224,  1,  0, 84,225,253,  0,  0, 58,
/* 0x0f50 */   1,  0, 89,231,  1,  0,201,228,237,  0,  0,234, 27, 30,139,226,
/* 0x0f60 */   8,  1,  0,235,  4, 64,157,229,127,  0,  0, 10,114, 31,139,226,
/* 0x0f70 */   8,  1,  0,235,  8, 64,157,229,125,  0,  0, 10,  8, 48,157,229,
/* 0x0f80 */  12, 64,157,229, 12, 48,141,229,  4, 48,157,229,  8, 48,141,229,
/* 0x0f90 */   0, 16,157,229,  0, 64,141,229,  4, 16,141,229,  7,  0, 86,227,
/* 0x0fa0 */  11, 96,160,227,  8, 96,160, 51,104,160,139,226, 10,172,138,226,
/* 0x0fb0 */   0, 16,138,226, 10,  1,  0,235,144,  0,  0, 26, 44, 48,157,229,
/* 0x0fc0 */   4, 80,138,226,  0, 32,160,227,  3, 82,133,224,  8, 64,160,227,
/* 0x0fd0 */ 156,  0,  0,234,  2, 16,138,226, 10,  1,  0,235,153,  0,  0, 26,
/* 0x0fe0 */  44, 48,157,229, 65, 95,138,226,  8, 32,160,227,  3, 82,133,224,
/* 0x0ff0 */   8, 64,160,227,156,  0,  0,234,129, 95,138,226, 16, 32,160,227,
/* 0x1000 */   1, 76,160,227, 52, 32,141,229,  1,  0,160,227,  5, 16,160,225,
/* 0x1010 */  11,  1,  0,235,  4, 48, 80,224,158,  0,  0, 58, 52, 80,157,229,
/* 0x1020 */   3, 80,133,224, 52, 80,141,229,  0, 16,157,229,  4,  0, 86,227,
/* 0x1030 */ 225,  0,  0, 42,  7, 96,134,226,  4,  0, 85,227,  3, 80,160, 35,
/* 0x1040 */ 133, 83,139,224, 54, 94,133,226,  1,  0,160,227, 64, 64,160,227,
/* 0x1050 */   5, 16,160,225, 11,  1,  0,235,  4, 48, 80,224,175,  0,  0, 58,
/* 0x1060 */  44, 48,141,229,  4,  0, 83,227,221,  0,  0, 58,163, 64,160,225,
/* 0x1070 */   1, 64, 68,226,  1, 16,  3,226,  2, 16,129,227, 14,  0, 83,227,
/* 0x1080 */ 194,  0,  0, 42, 17, 20,160,225, 94,160,139,226,  3, 48, 65,224,
/* 0x1090 */   5,172,138,226,131,160,138,224,206,  0,  0,234,  4, 64, 68,226,
/* 0x10a0 */ 255,  0,  0,235,167,112,160,225,  7,  0, 92,225,  7,192, 76, 32,
/* 0x10b0 */   1, 16,161,224,  1, 64, 84,226,195,  0,  0, 26, 68,160,139,226,
/* 0x10c0 */   6,172,138,226,  1, 18,160,225,  4, 64,160,227,  0, 16,141,229,
/* 0x10d0 */   1, 80,160,227,  1,  0,160,227, 10, 16,160,225, 11,  1,  0,235,
/* 0x10e0 */   1,  0, 16,227,216,  0,  0, 10,  0, 16,157,229,  5, 16,129,225,
/* 0x10f0 */   0, 16,141,229,133, 80,160,225,  1, 64, 84,226,209,  0,  0, 26,
/* 0x1100 */   0, 16,157,229,222,  0,  0,234, 44, 16,157,229,  1, 16,145,226,
/* 0x1110 */   0, 16,141,229, 52, 80,157,229, 36, 48,157,229,  2, 80,133,226,
/* 0x1120 */   3, 48, 73,224,  3,  0, 81,225,253,  0,  0,138, 40, 32,157,229,
/* 0x1130 */   1,  0, 89,231,  1,  0,201,228,  2,  0, 89,225,241,  0,  0, 42,
/* 0x1140 */   1, 80, 85,226,231,  0,  0, 26, 28,  0,205,229, 40, 32,157,229,
/* 0x1150 */   2,  0, 89,225, 33,  0,  0, 58,255,  0,  0,235,  0,  0,160,227,
/* 0x1160 */  32, 32,157,229,  2, 48, 72,224, 56, 32,157,229,  0, 48,130,229,
/* 0x1170 */  36, 32,157,229,  2, 48, 73,224,104, 32,157,229,  0, 48,130,229,
/* 0x1180 */  60,208,141,226,240,143,189,232,  1,  0,160,227,243,  0,  0,234,
/* 0x1190 */   1,  4, 87,227, 14,240,160, 33, 48, 48,157,229,  7,116,160,225,
/* 0x11a0 */   8,  0, 83,225,253,  0,  0, 10,  1, 48,216,228, 12,196,131,225,
/* 0x11b0 */  14,240,160,225,  6,  0,160,225,128, 16,129,224,  0,  0,160,227,
/* 0x11c0 */ 128, 16,129,224,  1,  4, 87,227, 14, 32,160,225,  1,  1,  0, 59,
/* 0x11d0 */ 176, 48,209,225,167,229,160,225,147, 14, 14,224, 14,  0, 92,225,
/* 0x11e0 */  14,112,160, 49, 14,112, 71, 32,  2,235, 99, 50, 14,192, 76, 32,
/* 0x11f0 */ 174, 50,131, 48,163, 50, 67, 32,  0,  0,176,224,176, 48,193,225,
/* 0x1200 */   2,240,160,225, 30, 32,160,227, 20, 16,143,226,  2,  0,160,227,
/* 0x1210 */   4,112,160,227,  0,  0,  0,239,127,  0,160,227,  1,112,160,227,
/* 0x1220 */   0,  0,  0,239, 80, 82, 79, 84, 95, 69, 88, 69, 67,124, 80, 82,
/* 0x1230 */  79, 84, 95, 87, 82, 73, 84, 69, 32,102, 97,105,108,101,100, 46,
/* 0x1240 */  10,  0, 14, 32,160,225, 40, 16, 66,226,  4, 64,145,228,  4, 48,
/* 0x1250 */ 160,225,  1, 80,160,225,  4, 64,145,228,  4, 80, 69,224,  3, 48,
/* 0x1260 */  65,224,  4, 64,145,228,  0,  0, 84,227, 11,  0,  0, 10,  4, 64,
/* 0x1270 */ 133,224, 36, 64,139,229,  4, 64,145,228,  4, 64,133,224,  4, 64,
/* 0x1280 */  45,229,  4, 64,145,228,  4,  0,133,224,  3, 16,160,225,  8,208,
/* 0x1290 */  77,226,  4, 64,145,229, 12, 16,129,226,  4, 16,129,224,181,  0,
/* 0x12a0 */   0,235,  0, 90,160,225, 37, 91,160,225,  5, 65,132,224,  4, 64,
/* 0x12b0 */  45,229,  5,  1, 64,224,  4,  0, 45,229,  5, 65, 68,224,  5,  1,
/* 0x12c0 */ 128,224,  4, 80, 45,229, 51,  0,  0,235,255, 48,  3,226, 80,  0,
/* 0x12d0 */  83,227, 14,240,160, 17, 33, 17,176,225,  0,  0, 80, 19, 14,240,
/* 0x12e0 */ 160,  1,  1, 16, 65,226,  1, 33,144,231, 15, 52,  2,226, 11,  4,
/* 0x12f0 */  83,227, 48,  0,  0, 26,255, 52,  2,226,  1, 32, 66,224,255, 36,
/* 0x1300 */ 194,227,  3, 32,130,225,  1, 33,128,231,  0,  0, 81,227, 38,  0,
/* 0x1310 */   0, 26, 30,255, 47,225,  4,224, 45,229,  5, 48,209,229,  4, 48,
/* 0x1320 */  45,229,  6, 48,209,229,  4, 48, 45,229,  4, 64, 45,229,  4,  0,
/* 0x1330 */  45,229,181,  0,  0,235,  4, 80,160,225,181,  0,  0,235,  4, 64,
/* 0x1340 */  45,229,  4, 32, 45,229, 40, 48, 75,226,  4, 48, 45,229,  4,  0,
/* 0x1350 */  45,229,  4, 80, 45,229,  4, 16, 45,229,  3, 48,  1,226,  3, 80,
/* 0x1360 */ 133,226,  3, 80,133,224, 24, 48, 27,229, 37, 33,131,224, 52, 48,
/* 0x1370 */  27,229,189,  0,  0,235, 28, 48, 27,229,189,  0,  0,235,136,  0,
/* 0x1380 */   0,235,  0, 64,224,227, 50, 48,160,227,  3, 32,160,227, 16, 16,
/* 0x1390 */  27,229, 20,  0, 27,229,  0, 96,160,225,192,112,160,227,  0,  0,
/* 0x13a0 */   0,239,  6,  0, 80,225, 89,  0,  0, 10,240,  1,240,231, 24, 80,
/* 0x13b0 */  27,229, 12, 16, 27,229,125,  0,  0,235, 31,  0,189,232, 52,255,
/* 0x13c0 */  47,225,  4,208,141,226, 98,  0,  0,235,  0,  0,  0,239,247,200,
/* 0x13d0 */ 189,232,  4, 64, 27,229,  3,  0,158,232,  3,  0,132,232, 31, 16,
/* 0x13e0 */ 189,232,  3,  0, 19,225,105,  0,  0, 10, 52,255, 47,225,  0,  0,
/* 0x13f0 */ 157,229,  4, 16,157,229,  0, 32,160,227,  0, 16,129,224,  8, 16,
/* 0x1400 */ 129,226,  2,112,160,227, 15,120,135,227,  0,  0,  0,239,  3,  0,
/* 0x1410 */ 189,232,  5, 32,160,227,125,112,160,227,  0,  0,  0,239, 91,112,
/* 0x1420 */ 160,227,  3,128,189,232,  4, 80, 17,229,255, 84,197,227,  1, 80,
/* 0x1430 */ 133,226,  4, 48,145,228,  1, 80, 69,226,  4, 48,128,228,  7,  0,
/* 0x1440 */  21,227,122,  0,  0, 26,165, 81,176,225,135,  0,  0, 10,212,  3,
/* 0x1450 */  45,233,220, 19,177,232,  1, 80, 85,226,220, 19,160,232,130,  0,
/* 0x1460 */   0, 26,212,  3,189,232, 30,255, 47,225,  4,224, 45,229, 14, 48,
/* 0x1470 */ 160,225,189,  0,  0,235,  2, 17,160,225,  0, 64,224,227, 34, 48,
/* 0x1480 */ 160,227,  7, 32,160,227,  8, 16, 11,229,  0,  0,160,227,192,112,
/* 0x1490 */ 160,227,  0,  0,  0,239,  1, 10,112,227,150,  0,  0, 58,240,  1,
/* 0x14a0 */ 240,231, 12,  0, 11,229, 20, 16, 27,229, 24, 80, 27,229,125,  0,
/* 0x14b0 */   0,235, 68, 16, 27,229, 64, 80, 27,229,  3, 48,  1,226,  3, 16,
/* 0x14c0 */  65,224,  3, 80,133,224,  0, 48,131,224, 68, 48, 11,229,  3, 80,
/* 0x14d0 */ 133,226, 37, 81,160,225,125,  0,  0,235,  0, 32,160,225, 52, 16,
/* 0x14e0 */  27,229, 52,  0, 11,229,119,  0,  0,235, 28, 16, 27,229, 28,  0,
/* 0x14f0 */  11,229,119,  0,  0,235,  4, 16,157,228,  4,  0, 45,229,119,  0,
/* 0x1500 */   0,235,  0, 16,160,225,  2,  0,160,225,  0, 32,160,227,  2,112,
/* 0x1510 */ 160,227, 15,120,135,227,  0,  0,  0,239,  4,240,157,228,  1, 64,
/* 0x1520 */ 209,228,  1, 48,209,228,  3, 68,132,225,  1, 48,209,228,  3, 72,
/* 0x1530 */ 132,225,  1, 48,209,228,  3, 76,132,225, 30,255, 47,225,  4, 48,
/* 0x1540 */  19,229,255, 52,195,227,  1, 48,131,226,  3, 32,130,224, 30,255,
/* 0x1550 */  47,225,102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,
/* 0x1560 */ 102, 51, 50, 45,108,105,116,116,108,101, 97,114,109, 10, 10, 83,
/* 0x1570 */ 101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,
/* 0x1580 */ 101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32,
/* 0x1590 */  32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x15a0 */  77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,
/* 0x15b0 */ 102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32,
/* 0x15c0 */  32, 48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 32, 32, 32, 32,
/* 0x15d0 */  32, 48, 48, 48, 48, 48, 48, 49, 52, 32, 32, 48, 48, 48, 48, 48,
/* 0x15e0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x15f0 */  48, 48, 48, 48, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1600 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x1610 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49, 32, 78, 82, 86,
/* 0x1620 */  95, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1630 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1640 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52,
/* 0x1650 */  56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1660 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 50, 32,
/* 0x1670 */  78, 82, 86, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x1680 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1690 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x16a0 */  48, 48, 52, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x16b0 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x16c0 */  32, 51, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x16d0 */  32, 48, 48, 48, 48, 48, 49, 51, 99, 32, 32, 48, 48, 48, 48, 48,
/* 0x16e0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x16f0 */  48, 48, 48, 48, 48, 52, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1700 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x1710 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32, 78, 82, 86,
/* 0x1720 */  50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1730 */  49, 50, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1740 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 56,
/* 0x1750 */  52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1760 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1770 */  76, 89, 10, 32, 32, 53, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32,
/* 0x1780 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,101, 99, 32, 32, 48,
/* 0x1790 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x17a0 */  48, 32, 32, 48, 48, 48, 48, 48, 50, 97, 99, 32, 32, 50, 42, 42,
/* 0x17b0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x17c0 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 54,
/* 0x17d0 */  32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48,
/* 0x17e0 */  48, 48, 48, 48, 48, 98, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x17f0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1800 */  48, 48, 51, 57, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1810 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x1820 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 55, 32, 76, 90, 77, 65, 95,
/* 0x1830 */  68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 57, 51,
/* 0x1840 */  56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1850 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 53, 52, 32,
/* 0x1860 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x1870 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x1880 */  10, 32, 32, 56, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32,
/* 0x1890 */  32, 32, 32, 48, 48, 48, 48, 48, 52, 55, 56, 32, 32, 48, 48, 48,
/* 0x18a0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x18b0 */  32, 48, 48, 48, 48, 48,100, 56, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x18c0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x18d0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 57, 32, 76,
/* 0x18e0 */  90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 48, 48,
/* 0x18f0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1900 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x1910 */  50, 48, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1920 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49,
/* 0x1930 */  48, 32, 69, 76, 70, 77, 65, 73, 78, 89, 32, 32, 32, 32, 32, 32,
/* 0x1940 */  48, 48, 48, 48, 48, 48, 51,101, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1950 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1960 */  48, 48, 49, 50, 48, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1970 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x1980 */  10, 32, 49, 49, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 32, 32,
/* 0x1990 */  32, 32, 32, 48, 48, 48, 48, 48, 51, 49, 48, 32, 32, 48, 48, 48,
/* 0x19a0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x19b0 */  32, 48, 48, 48, 48, 49, 50, 52, 50, 32, 32, 50, 42, 42, 48, 32,
/* 0x19c0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x19d0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66, 79,
/* 0x19e0 */  76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x19f0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69,  9,
/* 0x1a00 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x1a10 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x1a20 */  78, 82, 86, 50, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x1a30 */  82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x1a40 */  32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66,  9, 48, 48, 48, 48,
/* 0x1a50 */  48, 48, 48, 48, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48,
/* 0x1a60 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x1a70 */  95, 69, 76, 70, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1a80 */  76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48,
/* 0x1a90 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x1aa0 */  95, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1ab0 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x1ac0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x1ad0 */  95, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1ae0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x1af0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77,
/* 0x1b00 */  65, 73, 78, 90,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 76,
/* 0x1b10 */  70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1b20 */ 108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x1b30 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73,
/* 0x1b40 */  78, 88, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1b50 */  32,100, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68,  9, 48, 48, 48,
/* 0x1b60 */  48, 48, 48, 48, 48, 32, 78, 82, 86, 95, 72, 69, 65, 68, 10, 48,
/* 0x1b70 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x1b80 */  78, 82, 86, 95, 84, 65, 73, 76,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b90 */  48, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48,
/* 0x1ba0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x1bb0 */  95, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1bc0 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x1bd0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77,
/* 0x1be0 */  65, 73, 78, 89,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 76,
/* 0x1bf0 */  70, 77, 65, 73, 78, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1c00 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x1c10 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 95,115,116, 97,114,116,
/* 0x1c20 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x1c30 */  70, 32, 78, 82, 86, 50, 69,  9, 48, 48, 48, 48, 48, 49, 51, 99,
/* 0x1c40 */  32,117, 99,108, 95,110,114,118, 50,101, 95,100,101, 99,111,109,
/* 0x1c50 */ 112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1c60 */  32,103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 68,  9, 48,
/* 0x1c70 */  48, 48, 48, 48, 49, 50, 56, 32,117, 99,108, 95,110,114,118, 50,
/* 0x1c80 */ 100, 95,100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48,
/* 0x1c90 */  48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32,
/* 0x1ca0 */  78, 82, 86, 50, 66,  9, 48, 48, 48, 48, 48, 48,101, 99, 32,117,
/* 0x1cb0 */  99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,112,114,
/* 0x1cc0 */ 101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103,
/* 0x1cd0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x1ce0 */  48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,122,109, 97, 68,
/* 0x1cf0 */ 101, 99,111,100,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103,
/* 0x1d00 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89,  9,
/* 0x1d10 */  48, 48, 48, 48, 48, 48, 48, 48, 32,101,110,100, 95,100,101, 99,
/* 0x1d20 */ 111,109,112,114,101,115,115, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x1d30 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x1d40 */  91, 69, 76, 70, 77, 65, 73, 78, 88, 93, 58, 10, 79, 70, 70, 83,
/* 0x1d50 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x1d60 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x1d70 */  48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1d80 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x1d90 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x1da0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69, 93,
/* 0x1db0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x1dc0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x1dd0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82,
/* 0x1de0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x1df0 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 54, 99, 32, 82, 95, 65,
/* 0x1e00 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x1e10 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 55, 48, 32, 82, 95,
/* 0x1e20 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e30 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82,
/* 0x1e40 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e50 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 56, 52, 32,
/* 0x1e60 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x1e70 */  32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 57, 48,
/* 0x1e80 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x1e90 */  32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 57,
/* 0x1ea0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x1eb0 */  32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x1ec0 */  97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1ed0 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,
/* 0x1ee0 */  48, 97, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1ef0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,
/* 0x1f00 */  48, 48, 98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1f10 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,
/* 0x1f20 */  48, 48, 48, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1f30 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,
/* 0x1f40 */  48, 48, 48, 48, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1f50 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x1f60 */  48, 48, 48, 48, 48,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1f70 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,
/* 0x1f80 */  48, 48, 48, 48, 48, 48,100, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x1f90 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,
/* 0x1fa0 */  10, 48, 48, 48, 48, 48, 48,101, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x1fb0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x1fc0 */  69, 10, 48, 48, 48, 48, 48, 48,101, 52, 32, 82, 95, 65, 82, 77,
/* 0x1fd0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x1fe0 */  50, 69, 10, 48, 48, 48, 48, 48, 48,101, 99, 32, 82, 95, 65, 82,
/* 0x1ff0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x2000 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 48,102, 56, 32, 82, 95, 65,
/* 0x2010 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x2020 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,102, 99, 32, 82, 95,
/* 0x2030 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2040 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 49, 48, 52, 32, 82,
/* 0x2050 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2060 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 49, 48, 99, 32,
/* 0x2070 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2080 */  32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 49, 51, 52,
/* 0x2090 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x20a0 */  32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 49, 51,
/* 0x20b0 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x20c0 */  32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 10, 82, 69, 76, 79, 67,
/* 0x20d0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x20e0 */  82, 32, 91, 78, 82, 86, 50, 68, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x20f0 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2100 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x2110 */  48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2120 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,
/* 0x2130 */  48, 48, 48, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2140 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48,
/* 0x2150 */  48, 48, 48, 48, 55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2160 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48,
/* 0x2170 */  48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2180 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10,
/* 0x2190 */  48, 48, 48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x21a0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68,
/* 0x21b0 */  10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x21c0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x21d0 */  68, 10, 48, 48, 48, 48, 48, 48, 57, 99, 32, 82, 95, 65, 82, 77,
/* 0x21e0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x21f0 */  50, 68, 10, 48, 48, 48, 48, 48, 48, 97, 48, 32, 82, 95, 65, 82,
/* 0x2200 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x2210 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95, 65,
/* 0x2220 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x2230 */  82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 98, 99, 32, 82, 95,
/* 0x2240 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2250 */  78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 99, 52, 32, 82,
/* 0x2260 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2270 */  32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32,
/* 0x2280 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2290 */  32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,100, 56,
/* 0x22a0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x22b0 */  32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,101,
/* 0x22c0 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x22d0 */  32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x22e0 */ 101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x22f0 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,
/* 0x2300 */  48,102, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2310 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,
/* 0x2320 */  48, 48,102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2330 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,
/* 0x2340 */  48, 48, 49, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2350 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48,
/* 0x2360 */  48, 48, 48, 49, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2370 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 10,
/* 0x2380 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x2390 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 66, 93, 58, 10,
/* 0x23a0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x23b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x23c0 */  10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x23d0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x23e0 */  66, 10, 48, 48, 48, 48, 48, 48, 55, 48, 32, 82, 95, 65, 82, 77,
/* 0x23f0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x2400 */  50, 66, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82,
/* 0x2410 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x2420 */  86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 55, 99, 32, 82, 95, 65,
/* 0x2430 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x2440 */  82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 56, 99, 32, 82, 95,
/* 0x2450 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2460 */  78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82,
/* 0x2470 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2480 */  32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 57, 52, 32,
/* 0x2490 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x24a0 */  32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 97, 48,
/* 0x24b0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x24c0 */  32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 98,
/* 0x24d0 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x24e0 */  32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,
/* 0x24f0 */  98, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2500 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48,
/* 0x2510 */  48, 98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2520 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48,
/* 0x2530 */  48, 48, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2540 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48,
/* 0x2550 */  48, 48, 48, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2560 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48,
/* 0x2570 */  48, 48, 48, 48,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2580 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48,
/* 0x2590 */  48, 48, 48, 48, 48,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x25a0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10,
/* 0x25b0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x25c0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 69, 76,
/* 0x25d0 */  70, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x25e0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x25f0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32,
/* 0x2600 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2610 */  32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48,
/* 0x2620 */  48, 48, 48, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2630 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70,
/* 0x2640 */  48, 48, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65, 82,
/* 0x2650 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2660 */  77, 65, 95, 69, 76, 70, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x2670 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x2680 */  32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 93, 58, 10, 79,
/* 0x2690 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x26a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x26b0 */  48, 48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x26c0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x26d0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 57, 48, 32, 82,
/* 0x26e0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x26f0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2700 */  48, 48, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2710 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2720 */  48, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82, 95, 65, 82, 77,
/* 0x2730 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2740 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48,102, 52,
/* 0x2750 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2760 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2770 */  48, 48, 48, 49, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2780 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2790 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 48, 56, 32, 82, 95, 65,
/* 0x27a0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x27b0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49,
/* 0x27c0 */  52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x27d0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x27e0 */  48, 48, 48, 48, 48, 49, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x27f0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2800 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 99, 99, 32, 82,
/* 0x2810 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2820 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2830 */  48, 49,100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2840 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2850 */  48, 10, 48, 48, 48, 48, 48, 50, 48, 52, 32, 82, 95, 65, 82, 77,
/* 0x2860 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2870 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 49, 56,
/* 0x2880 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2890 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x28a0 */  48, 48, 48, 50, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x28b0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x28c0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 51, 52, 32, 82, 95, 65,
/* 0x28d0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x28e0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50,
/* 0x28f0 */  51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2900 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2910 */  48, 48, 48, 48, 48, 50, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2920 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2930 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 52, 99, 32, 82,
/* 0x2940 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2950 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2960 */  48, 50, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2970 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2980 */  48, 10, 48, 48, 48, 48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77,
/* 0x2990 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x29a0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 99, 56,
/* 0x29b0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x29c0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x29d0 */  48, 48, 48, 50,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x29e0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x29f0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 48, 52, 32, 82, 95, 65,
/* 0x2a00 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2a10 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51,
/* 0x2a20 */  48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2a30 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2a40 */  48, 48, 48, 48, 48, 51, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2a50 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2a60 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 56, 56, 32, 82,
/* 0x2a70 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2a80 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2a90 */  48, 51, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2aa0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2ab0 */  48, 10, 48, 48, 48, 48, 48, 51, 97, 56, 32, 82, 95, 65, 82, 77,
/* 0x2ac0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2ad0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 99, 99,
/* 0x2ae0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2af0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2b00 */  48, 48, 48, 51,101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2b10 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2b20 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 51,101, 56, 32, 82, 95, 65,
/* 0x2b30 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2b40 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,
/* 0x2b50 */  50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2b60 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2b70 */  48, 48, 48, 48, 48, 52, 51, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2b80 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2b90 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 54, 99, 32, 82,
/* 0x2ba0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2bb0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2bc0 */  48, 52, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2bd0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2be0 */  48, 10, 48, 48, 48, 48, 48, 52, 56, 99, 32, 82, 95, 65, 82, 77,
/* 0x2bf0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2c00 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 98, 48,
/* 0x2c10 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2c20 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2c30 */  48, 48, 48, 52,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2c40 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2c50 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 52,101, 99, 32, 82, 95, 65,
/* 0x2c60 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2c70 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,
/* 0x2c80 */ 102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2c90 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2ca0 */  48, 48, 48, 48, 48, 53, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2cb0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2cc0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 51, 99, 32, 82,
/* 0x2cd0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2ce0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2cf0 */  48, 53, 57, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2d00 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2d10 */  48, 10, 48, 48, 48, 48, 48, 53, 97, 48, 32, 82, 95, 65, 82, 77,
/* 0x2d20 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2d30 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 99, 48,
/* 0x2d40 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2d50 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2d60 */  48, 48, 48, 53,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2d70 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2d80 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 53,102, 99, 32, 82, 95, 65,
/* 0x2d90 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2da0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54,
/* 0x2db0 */  48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2dc0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2dd0 */  48, 48, 48, 48, 48, 54, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2de0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2df0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 52, 56, 32, 82,
/* 0x2e00 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2e10 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2e20 */  48, 54, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2e30 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2e40 */  48, 10, 48, 48, 48, 48, 48, 54, 56, 99, 32, 82, 95, 65, 82, 77,
/* 0x2e50 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2e60 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54,100, 48,
/* 0x2e70 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2e80 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2e90 */  48, 48, 48, 54,101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2ea0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2eb0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 49, 99, 32, 82, 95, 65,
/* 0x2ec0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x2ed0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55,
/* 0x2ee0 */  50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2ef0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x2f00 */  48, 48, 48, 48, 48, 55, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2f10 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x2f20 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 55, 99, 32, 82,
/* 0x2f30 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2f40 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x2f50 */  48, 55, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2f60 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x2f70 */  48, 10, 48, 48, 48, 48, 48, 55, 98, 56, 32, 82, 95, 65, 82, 77,
/* 0x2f80 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x2f90 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 99, 52,
/* 0x2fa0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2fb0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x2fc0 */  48, 48, 48, 55,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2fd0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2fe0 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 55,102, 52, 32, 82, 95, 65,
/* 0x2ff0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3000 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,
/* 0x3010 */  50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3020 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x3030 */  48, 48, 48, 48, 48, 56, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3040 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3050 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 55, 99, 32, 82,
/* 0x3060 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3070 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48,
/* 0x3080 */  48, 56, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3090 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50,
/* 0x30a0 */  48, 10, 48, 48, 48, 48, 48, 56, 97, 48, 32, 82, 95, 65, 82, 77,
/* 0x30b0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x30c0 */  65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,101, 56,
/* 0x30d0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x30e0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x30f0 */  48, 48, 48, 56,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3100 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3110 */  67, 50, 48, 10, 48, 48, 48, 48, 48, 56,102, 99, 32, 82, 95, 65,
/* 0x3120 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3130 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 57,
/* 0x3140 */  48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3150 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10,
/* 0x3160 */  48, 48, 48, 48, 48, 57, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3170 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3180 */  68, 69, 67, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x3190 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76,
/* 0x31a0 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x31b0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x31c0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x31d0 */  48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x31e0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x31f0 */  49, 48, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65, 82,
/* 0x3200 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3210 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 56,
/* 0x3220 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3230 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3240 */  48, 48, 48, 48, 48, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3250 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3260 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 97, 99, 32, 82, 95,
/* 0x3270 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3280 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3290 */  48,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x32a0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x32b0 */  10, 48, 48, 48, 48, 48, 49, 48, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x32c0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x32d0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 48, 99, 32,
/* 0x32e0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x32f0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3300 */  48, 48, 49, 49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3310 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3320 */  49, 48, 10, 48, 48, 48, 48, 48, 49, 49, 56, 32, 82, 95, 65, 82,
/* 0x3330 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3340 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 50,
/* 0x3350 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3360 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3370 */  48, 48, 48, 48, 49, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3380 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3390 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 52, 52, 32, 82, 95,
/* 0x33a0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x33b0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x33c0 */  49, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x33d0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x33e0 */  10, 48, 48, 48, 48, 48, 49, 53, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x33f0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3400 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 56, 48, 32,
/* 0x3410 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3420 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3430 */  48, 48, 49, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3440 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3450 */  49, 48, 10, 48, 48, 48, 48, 48, 49, 56, 99, 32, 82, 95, 65, 82,
/* 0x3460 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3470 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 57,
/* 0x3480 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3490 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x34a0 */  48, 48, 48, 48, 49, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x34b0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x34c0 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 99, 48, 32, 82, 95,
/* 0x34d0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x34e0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x34f0 */  49, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3500 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3510 */  10, 48, 48, 48, 48, 48, 49,100, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x3520 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3530 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,100, 99, 32,
/* 0x3540 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3550 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3560 */  48, 48, 49,101, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3570 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3580 */  49, 48, 10, 48, 48, 48, 48, 48, 49,101, 99, 32, 82, 95, 65, 82,
/* 0x3590 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x35a0 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 50,
/* 0x35b0 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x35c0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x35d0 */  48, 48, 48, 48, 50, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x35e0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x35f0 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 52, 52, 32, 82, 95,
/* 0x3600 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3610 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3620 */  50, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3630 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3640 */  10, 48, 48, 48, 48, 48, 50, 53, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x3650 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3660 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 54, 56, 32,
/* 0x3670 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3680 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x3690 */  48, 48, 50, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x36a0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x36b0 */  49, 48, 10, 48, 48, 48, 48, 48, 50, 56, 99, 32, 82, 95, 65, 82,
/* 0x36c0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x36d0 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 97,
/* 0x36e0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x36f0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3700 */  48, 48, 48, 48, 50, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3710 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3720 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50,100, 48, 32, 82, 95,
/* 0x3730 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3740 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3750 */  50,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3760 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3770 */  10, 48, 48, 48, 48, 48, 50,102, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x3780 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3790 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 48, 99, 32,
/* 0x37a0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x37b0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x37c0 */  48, 48, 51, 49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x37d0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x37e0 */  49, 48, 10, 48, 48, 48, 48, 48, 51, 50, 99, 32, 82, 95, 65, 82,
/* 0x37f0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3800 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 53,
/* 0x3810 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3820 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3830 */  48, 48, 48, 48, 51, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3840 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3850 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 55, 48, 32, 82, 95,
/* 0x3860 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3870 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x3880 */  51, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3890 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x38a0 */  10, 48, 48, 48, 48, 48, 51, 57, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x38b0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x38c0 */  95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 98, 48, 32,
/* 0x38d0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x38e0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x38f0 */  48, 48, 51, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3900 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3910 */  49, 48, 10, 48, 48, 48, 48, 48, 51, 99, 56, 32, 82, 95, 65, 82,
/* 0x3920 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3930 */  77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 99,
/* 0x3940 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3950 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48,
/* 0x3960 */  48, 48, 48, 48, 52, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3970 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3980 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 49, 56, 32, 82, 95,
/* 0x3990 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x39a0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x39b0 */  52, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x39c0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x39d0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x39e0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73,
/* 0x39f0 */  78, 90, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x3a00 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3a10 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 50, 56, 32, 82,
/* 0x3a20 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3a30 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48,
/* 0x3a40 */  53, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3a50 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48,
/* 0x3a60 */  48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3a70 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x3a80 */  90, 10, 48, 48, 48, 48, 48, 48, 98, 48, 32, 82, 95, 65, 82, 77,
/* 0x3a90 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x3aa0 */  77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 99, 99, 32, 82,
/* 0x3ab0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3ac0 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48,
/* 0x3ad0 */ 102, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3ae0 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48,
/* 0x3af0 */  48, 48, 48, 48,102, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3b00 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x3b10 */  90, 10, 48, 48, 48, 48, 48, 49, 51, 48, 32, 82, 95, 65, 82, 77,
/* 0x3b20 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x3b30 */  77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 49, 51, 56, 32, 82,
/* 0x3b40 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3b50 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 49,
/* 0x3b60 */  51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3b70 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48,
/* 0x3b80 */  48, 48, 48, 49, 54, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3b90 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x3ba0 */  90, 10, 48, 48, 48, 48, 48, 49, 55, 52, 32, 82, 95, 65, 82, 77,
/* 0x3bb0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x3bc0 */  77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 49, 56, 52, 32, 82,
/* 0x3bd0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3be0 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 49,
/* 0x3bf0 */  97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3c00 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48,
/* 0x3c10 */  48, 48, 48, 50, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3c20 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x3c30 */  90, 10, 48, 48, 48, 48, 48, 50, 48, 56, 32, 82, 95, 65, 82, 77,
/* 0x3c40 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x3c50 */  77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 50, 49, 99, 32, 82,
/* 0x3c60 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3c70 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 50,
/* 0x3c80 */  51, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3c90 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48,
/* 0x3ca0 */  48, 48, 48, 50, 53, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3cb0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x3cc0 */  90, 10, 48, 48, 48, 48, 48, 50, 54, 99, 32, 82, 95, 65, 82, 77,
/* 0x3cd0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x3ce0 */  77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 50, 57, 52, 32, 82,
/* 0x3cf0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3d00 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 50,
/* 0x3d10 */  97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3d20 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48,
/* 0x3d30 */  48, 48, 48, 50, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3d40 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x3d50 */  90, 10, 48, 48, 48, 48, 48, 50, 98, 99, 32, 82, 95, 65, 82, 77,
/* 0x3d60 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x3d70 */  77, 65, 73, 78, 90, 10
};
