/*
 * EW Snake - Versione 0.5
 * Copyright (C) 2001 di Federico Marverti (yfede)
 *
 * Questo programma e` distribuito secondo i termini della Licenza
 * Pubblica Generica GNU (GNU GPL: GNU General Public License).
 * Per maggiori informazioni e riguardo leggere il file README.TXT
 * allegato alla distribuzione del presente codice sorgente.
 */

/* --- Inizio di gfx.c --- */

#include "defs.h"
#include <allegro.h>

int set_gfx( struct st_config *cfg );   /* Imposta il video e disegna le bitmap */
void unset_gfx( struct st_config *cfg );    /* Distrugge le bitmap */
void reset_colors( struct st_config *cfg ); /* Reimposta i colori */
void reset_screen( void );  /* Cancella lo schermo e colora lo sfondo */
void draw_wall( struct st_config *cfg, struct st_game *game );   /* Disegna il muro */
void draw_goal( struct st_config *cfg, struct st_game *game );   /* Disegna l'obiettivo */
void draw_snake( struct st_config *cfg, struct st_game *game );  /* Disegna il serpente */
void redraw_snake( struct st_config *cfg, struct st_game *game );   /* Disegna la testa del serpente e toglie la coda */

int set_gfx( struct st_config *cfg )
{
    set_color_depth( DE_COLOR_DEPTH );  /* Imposta la profondita` di colore */

    if( set_gfx_mode( GFX_AUTODETECT, cfg->resx, cfg->resy, 0, 0 ) < 0 )
        return R_ERR;           /* Se non riesce a impostare la modalita` video richiesta ritorna errore */

    gui_fg_color = CL_GUI;      /* Imposta i colori delle gui */
    gui_bg_color = CL_BACKGROUND;

    cfg->cellsize = (cfg->resx) / HCELLS;   /* Calcola il lato delle celle */

    cfg->bm_snake = create_bitmap( cfg->cellsize, cfg->cellsize );  /* Crea la bitmap per il serpente */
    clear( cfg->bm_snake );
    rectfill( cfg->bm_snake, 0, 0, (cfg->cellsize)-1, (cfg->cellsize)-1, CL_SNAKE );

    cfg->bm_goal = create_bitmap( cfg->cellsize, cfg->cellsize );   /* Crea la bitmap per l'obiettivo */
    clear( cfg->bm_goal );
    circlefill( cfg->bm_goal, ((cfg->cellsize)-1)/2, ((cfg->cellsize)-1)/2, (cfg->cellsize)/2-1, CL_GOAL );

    cfg->bm_empty = create_bitmap( cfg->cellsize, cfg->cellsize );  /* Crea la bitmap per una cella vuota */
    clear( cfg->bm_empty );
    rectfill( cfg->bm_empty, 0, 0, (cfg->cellsize)-1, (cfg->cellsize)-1, CL_BACKGROUND );

    cfg->bm_wall = create_bitmap( cfg->cellsize, cfg->cellsize );   /* Crea la bitmap per il muro */
    clear( cfg->bm_wall );
    rectfill( cfg->bm_wall, 0, 0, (cfg->cellsize)-1, (cfg->cellsize)-1, CL_WALL );

    return R_OK;
}

void unset_gfx( struct st_config *cfg )
{
    destroy_bitmap( cfg->bm_snake );    /* Distrugge le bitmap usate */
    destroy_bitmap( cfg->bm_goal );
    destroy_bitmap( cfg->bm_wall );
    destroy_bitmap( cfg->bm_empty );
}

void reset_colors( struct st_config *cfg )
{
    vsync();                    /* Attende la fine del retrace */
    set_color( CL_BACKGROUND, &(cfg->c_background) );   /* Imposta il colore di sfondo */
    set_color( CL_SNAKE, &(cfg->c_snake) );             /* Imposta il colore del serpente */
    set_color( CL_GOAL, &(cfg->c_goal) );               /* Imposta il colore dell'obiettivo */
    set_color( CL_WALL, &(cfg->c_wall) );               /* Imposta il colore del muro */
    set_color( CL_GUI, &(cfg->c_gui) );                 /* Imposta il colore delle gui */
    set_color( CL_TEXT, &(cfg->c_text) );               /* Imposta il colore del testo */
    set_color( CL_MOUSE, &(cfg->c_mouse) );             /* Imposta il colore del cursore del mouse */
    set_color( CL_NEW, &(cfg->c_new) );                 /* Imposta il colore di test */
}

void reset_screen( void )
{
    clear_to_color( screen, CL_BACKGROUND );    /* Cancella lo schermo */
}

void draw_wall( struct st_config *cfg, struct st_game *game )
{
    int i, j;

    for( i = 0; i < VCELLS; i++ )
        for( j = 0; j < HCELLS; j++ )   /* Per ogni cella dello schermo */
            if( (game->wall)[j][i] == W_WALL )  /* Se e` una cella del muro ci disegna lo sprite */
                draw_sprite( screen, cfg->bm_wall, j*(cfg->cellsize), i*(cfg->cellsize) );
}

void draw_goal( struct st_config *cfg, struct st_game *game )
{
    /* Disegna l'obiettivo nella posizione specificata */
    draw_sprite( screen, cfg->bm_goal, (game->goal_x)*(cfg->cellsize), (game->goal_y)*(cfg->cellsize) );
}

void draw_snake( struct st_config *cfg, struct st_game *game )
{
    int i;

    for( i = 0; i < (game->size); i++ ) /* Per ogni blocco del serpente disegna il relativo sprite */
        draw_sprite( screen, cfg->bm_snake, (game->x)[i]*(cfg->cellsize), (game->y)[i]*(cfg->cellsize) );
}

void redraw_snake( struct st_config *cfg, struct st_game *game )
{
    int hide_x = (game->x)[game->size]; /* Coordinate del blocco da cancellare */
    int hide_y = (game->y)[game->size];
    int head_x = (game->x)[0];  /* Coordinate della testa */
    int head_y = (game->y)[0];

    draw_sprite( screen, cfg->bm_snake, head_x*(cfg->cellsize), head_y*(cfg->cellsize) );   /* Disegna la testa */

 /* Se( (il blocco e` da cancellare)  e (      non cancella la testa         ) ) */
    if( (hide_x >= 0 && hide_y >= 0) && (hide_x != head_x || hide_y != head_y) )
            draw_sprite( screen, cfg->bm_empty, hide_x*(cfg->cellsize), hide_y*(cfg->cellsize) );   /* Cancella */
}
/* --- Fine di gfx.c --- */