/*****************************************************************************
*   SETTINGS.APP - settings program for FreeGEM                              *
*   Copyright 1999, 2005 John Elliott                                        *
*                                                                            *
* This program is free software; you can redistribute it and/or              *
* modify it under the terms of the GNU General Public License                *
* as published by the Free Software Foundation; either version 2             *
* of the License, or (at your option) any later version.                     *
*                                                                            *
* This program is distributed in the hope that it will be useful,            *
* but WITHOUT ANY WARRANTY; without even the implied warranty of             *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
* GNU General Public License for more details.                               *
*                                                                            *
* You should have received a copy of the GNU General Public License          *
* along with this program; if not, write to the Free Software                *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.*
*                                                                           *
******************************************************************************/


#include "settings.h"
#include <stdio.h>

//WORD round;
#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif

extern PPDUBLK col_ublk[16];
extern PPDUBLK id_ublk[16];
extern PPDUBLK stl_ublk[4];
extern PPDUBLK idx_ublk[24];
extern PPDUBLK pre_ublk[7];
extern PPDUBLK scheme_ublk[11];


MLOCAL CLRCAT desk_col;
MLOCAL CLRCAT gem_col;


VOID set_clip(WORD clip_flag, GRECT *s_area);




WORD paint_all(LPPARM lp);
WORD paint_style(LPPARM lp);
WORD paint_mindex(LPPARM lp)
{
	PARMBLK pb;
	WORD index;
	WORD dotext;

	char str[3];
	LBCOPY((LPBYTE)ADDR(&pb), (LPBYTE)lp ,sizeof(PARMBLK));

	set_clip(TRUE, (GRECT *) &pb.pb_xc);

	index  =  (WORD)pb.pb_parm & 0xFFFF;
	dotext = ((LONG)pb.pb_parm & 0x10000L) ? 1 : 0;
    
	filled_rect((GRECT *)(&pb.pb_x), BLACK, WHITE, desk_col.cc_style, 
			index);
    
	if (pb.pb_currstate & SELECTED)
	{
	  	vsl_color(vdi_handle, 3);
		vsl_width(vdi_handle, 2);
		vsl_type(vdi_handle, FIS_SOLID);

		pb.pb_x+=2;
		pb.pb_y+=2;
		pb.pb_w-=4;
		pb.pb_h-=4;
		draw_rect((GRECT *) &pb.pb_x);
		pb.pb_x-=2;
		pb.pb_y-=2;
		pb.pb_w+=4;
		pb.pb_h+=4;
	}  
	if (dotext)
	{
		sprintf(str, "%d", index);

		vswr_mode(vdi_handle, 1);
		vst_color(vdi_handle, BLACK);
		v_gtext(vdi_handle, pb.pb_x + (pb.pb_w/4), pb.pb_y + (pb.pb_h/2), str);
	}
	vsl_width(vdi_handle, 1);
	vsl_color(vdi_handle, BLACK);
	draw_rect((GRECT *) &pb.pb_x);
		
	set_clip(FALSE, (GRECT *)&pb.pb_xc);

	return 0;
}





static VOID userdef(LPTREE tree)
{
	pre_ublk[0].ub_code = paint_colour;
	pre_ublk[1].ub_code = paint_colour;
	pre_ublk[2].ub_code = paint_style;
	pre_ublk[3].ub_code = paint_mindex;
	pre_ublk[4].ub_code = paint_all;
	
	pre_ublk[0].ub_parm = desk_col.cc_foreground;
	pre_ublk[1].ub_parm = desk_col.cc_background;
	pre_ublk[2].ub_parm = desk_col.cc_style;
	pre_ublk[3].ub_parm = desk_col.cc_pattern;
	pre_ublk[4].ub_parm = (LONG)(ADDR(&desk_col));
}


WORD do_drop(LPTREE tr, WORD ob, WORD rsc);
WORD do_clrdrop(LPTREE tr, WORD ob);
WORD do_stldrop(LPTREE tr, WORD ob, WORD rsc);
WORD do_midxdrop(LPTREE tr, WORD ob)
{
	LPTREE tr2;
	WORD n, rsc, maxn;

	maxn = 8;
	rsc = DDMINDEX;
	rsrc_gaddr(R_TREE, rsc, (LPVOID *)&tr2);
	
	for (n = 0; n < maxn; n++)
	{
		tr2[n + 1].ob_state &= ~SELECTED;
		tr2[n + 1].ob_flags |= SELECTABLE | TOUCHEXIT; 

		idx_ublk[n].ub_parm = 0x10000L | (n+1);
		idx_ublk[n].ub_code = paint_mindex;
		ppd_userdef(tr2, n+1, &idx_ublk[n]);
	}
	return do_drop(tr, ob, rsc);
}

WORD LSTCPY(LPBYTE d, LPBYTE s)
{
	while (*s) { *d++ = *s++; }
	*d++ = 0;
}



WORD rw_deskpat(CLRCAT *pcc, int write)
{
	FILE *fprsc;
	RSHDR rshdr;
	LONG ltree;
	OBJECT ob;
	LONG far *lspec = (LONG far *)&ob.ob_spec;

	if (!write)
	{
		pcc->cc_foreground = 4;
		pcc->cc_background = 0;
		pcc->cc_style      = 2;
		pcc->cc_pattern    = 4;	/* Default blue/white */
	}
	fprsc = rsc_open(write ? "r+b" : "rb");
	if (!fprsc) return 0;

	if (fread(&rshdr, 1, sizeof(rshdr), fprsc) != sizeof(rshdr))
	{
		fclose(fprsc);
		rsrc_alert(1, NORSC);
		return 0;
	}	
	fseek(fprsc, rshdr.rsh_trindex + 8, SEEK_SET);
	if (fread(&ltree, 1, sizeof(ltree), fprsc) != sizeof(ltree))
	{
		fclose(fprsc);
		rsrc_alert(1, NORSC);
		return 0;
	}
	fseek(fprsc, ltree, SEEK_SET);
	if (fread(&ob, 1, sizeof(ob), fprsc) != sizeof(ob))
	{
		fclose(fprsc);
		rsrc_alert(1, NORSC);
		return 0;
	}
	if (write)
	{
		lspec[0] &= 0xFFFFFF00L;
		lspec[0] |= (pcc->cc_foreground & 0x0F);
		lspec[0] |= (pcc->cc_pattern & 7) << 4;
		fseek(fprsc, ltree, SEEK_SET);
		fwrite(&ob, 1, sizeof(ob), fprsc);
	}
	else
	{
		pcc->cc_foreground = lspec[0] & 0x0F;
		pcc->cc_background = 0;
		pcc->cc_style      = 2;
		pcc->cc_pattern    = (lspec[0] >> 4) & 7;
	}
	fclose(fprsc);	

	return 1;
}



VOID set_desktop(LPTREE tr, WORD o)
{
	LPTREE  tree;
	GRECT	or;
	WORD	xdial, ydial, wdial, hdial, exitobj, indial;
	WORD	xo;

	clr_vdi_handle(vdi_handle);	
	indial  = 1;
	
	rsrc_gaddr(R_TREE, DESKTOP, (LPVOID *)&tree);

	rw_deskpat(&desk_col, 0);
	memcpy(&gem_col, &desk_col, sizeof(gem_col));
	ppd_userdef(tree, CHOICE4,  &pre_ublk[0]);
	ppd_userdef(tree, CHOICE5,  &pre_ublk[3]);
	ppd_userdef(tree, SAMPLE2, &pre_ublk[4]);

	userdef(tree);
	
	ob_xywh(tr, o, &or);
	
	form_center(tree, &xdial, &ydial, &wdial, &hdial);
	form_dial(0, or.g_x, or.g_y, or.g_w, or.g_h, xdial, ydial, wdial, hdial);
	form_dial(1, or.g_x, or.g_y, or.g_w, or.g_h, xdial, ydial, wdial, hdial);
	
	objc_draw(tree, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial);

	while (indial)
	{
		tree[DROP4].ob_state &= ~DISABLED;
		tree[DROP5].ob_state &= ~DISABLED;

		for (xo = 0; !(tree[xo].ob_flags & LASTOB); xo++)
		{
			if ((tree[xo].ob_type >> 8) == 1)
				objc_draw(tree, xo, 1, xdial, ydial, wdial, hdial);
		}

		exitobj = form_do(tree, 0) & 0x7FFF;

		switch(exitobj)
		{
			case DROP4:	xo = do_clrdrop(tree, exitobj);
					if (xo >= 1)
					{
						desk_col.cc_foreground = xo - 1;
						userdef(tree);
					}
					break;
						
			case DROP5:	xo = do_midxdrop(tree, exitobj);
					if (xo >= 1)
					{
						desk_col.cc_pattern = xo;
						userdef(tree);
					}
					break;
			case DESKHELP:
					rsrc_alert(1, HELPDESK);
					break;
		
			case DESKOKAY:
			case DESKCNCL:
					indial = 0;		
					break;
		}
		tree[exitobj].ob_state &= ~SELECTED;
		objc_draw(tree, exitobj, 1, xdial, ydial, wdial, hdial);
		
	}

	if (exitobj == DESKOKAY)
	{
		GRECT gr_full;
		
		rw_deskpat(&desk_col, 1);
		
		gr_full.g_x = 0;
		gr_full.g_y = 0;
		gr_full.g_w = work_out[0];
		gr_full.g_h = work_out[1];
		send_redraw(0, &gr_full);		
	}


	form_dial(2, or.g_x, or.g_y, or.g_w, or.g_h, xdial, ydial, wdial, hdial);
	form_dial(3, or.g_x, or.g_y, or.g_w, or.g_h, xdial, ydial, wdial, hdial);

	
}



