/************************************************************************

    SETTINGS.APP - settings program for FreeGEM   

    Copyright (C) 1998,2005  John Elliott <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/



#include "settings.h"



UWORD x_mx, x_my, x_mb;
extern WORD xedit, yedit, wedit, hedit;

void frob_bitmap(CURSOR *pc, WORD cur_col, LPTREE tree)
{
     	WORD dx, dy, x, y; 
	GRECT rc;
	WORD mask;

	objc_offset(tree, CURSEDIT, &rc.g_x, &rc.g_y);
	rc.g_w = tree[CURSEDIT].ob_width;
	rc.g_h = tree[CURSEDIT].ob_height;
	dx = tree[CURSEDIT].ob_width / 16;
	dy = tree[CURSEDIT].ob_height / 16;

	x = ((WORD)x_mx - rc.g_x) / dx;
	y = ((WORD)x_my - rc.g_y) / dy;

	if (x < 0 || x > 15 || y < 0 || y > 15) return;

	graf_mouse(M_OFF, 0x0L);
	mask = 0x8000 >> x;
	switch(cur_col)
	{
		case 0: pc->mask[y] &= ~mask;
			pc->data[y] &= ~mask;
			draw_cell(pc, &rc, x, y);
			break;
		case 1: pc->mask[y] |= mask;
			pc->data[y] |= mask;
			draw_cell(pc, &rc, x, y);
			break;
		case 2: pc->mask[y] |= mask;
			pc->data[y] &= ~mask;
			draw_cell(pc, &rc, x, y);
			break;
		case 3:	
			draw_cell(pc, &rc, pc->xhot, pc->yhot);		
			pc->xhot = x;
			pc->yhot = y;
			draw_hotspot(pc, &rc, x, y);
			break;

	}
	graf_mouse(M_ON, 0x0L);
}

void y_frob_bitmap(BITBLK *pb, WORD cur_col, LPTREE tree)
{
     	WORD dx, dy, x, y; 
	GRECT rc;
	WORD mask;
	LPWORD data = (LPWORD)(pb->bi_pdata);

	objc_offset(tree, ICONEDIT, &rc.g_x, &rc.g_y);
	rc.g_w = tree[ICONEDIT].ob_width;
	rc.g_h = tree[ICONEDIT].ob_height;
	dx = tree[ICONEDIT].ob_width / 32;
	dy = tree[ICONEDIT].ob_height / 32;

	x = ((WORD)x_mx - rc.g_x) / dx;
	y = ((WORD)x_my - rc.g_y) / dy;

	if (x < 0 || x > 31 || y < 0 || y > 31) return;

	mask = 0x8000 >> (x % 16);
	graf_mouse(M_OFF, 0x0L);
	switch(cur_col)
	{
		case 0: data[y*2 + x/16] &= ~mask;
			break;
		case 1: data[y*2 + x/16] |= mask;
			break;
	}
	draw_syscell(pb, &rc, x, y);
	graf_mouse(M_ON, 0x0L);
}


	WORD
find_obj(tree, start_obj, which)       /* routine to find the next editable */
	REG LPTREE	tree;          /* text field, or a field that is as */
	WORD		start_obj;     /* marked as a default return field. */
	WORD		which;
{
	REG WORD	obj, flag, theflag, inc;

	obj = 0;
	flag = EDITABLE;
	inc = 1;
	switch(which)
	{
	  case FMD_BACKWARD:
		inc = -1;
						/* fall thru		*/
	  case FMD_FORWARD:
		obj = start_obj + inc;
		break;
	  case FMD_DEFLT:
		flag = DEFAULT;
		break;
	}

	while ( obj >= 0 )
	{
	  theflag = tree[obj].ob_flags;
	  if (theflag & flag)
	    return(obj);
	  if (theflag & LASTOB)
	    obj = -1;
	  else
	    obj += inc;
	}
	return(start_obj);
}


	WORD
fm_inifld(tree, start_fld)
	LONG		tree;
	WORD		start_fld;
{
						/* position cursor on	*/
						/*   the starting field	*/
	if (start_fld == 0)
	  start_fld = find_obj(tree, 0, FMD_FORWARD);
	return( start_fld );
}


WORD x_form_do(REG LPTREE tree, WORD start_fld, WORD cur_col, CURSOR *pc)
{
	REG WORD	edit_obj;
	WORD		next_obj;
	WORD		which, cont;
	WORD		idx;
	UWORD		ks, kr, br;

	wind_update(1);
	wind_update(3);
						/* set starting field	*/
						/*   to edit, if want	*/
						/*   first editing field*/
						/*   then walk tree	*/
	next_obj = fm_inifld(tree, start_fld);
	edit_obj = 0;
						/* interact with user	*/
	cont = TRUE;
	while(cont)
	{
						/* position cursor on	*/
						/*   the selected 	*/
						/*   editting field	*/
	  if ( (next_obj != 0) &&
	       (edit_obj != next_obj) )
	  {
	    edit_obj = next_obj;
	    next_obj = 0;
	    objc_edit(tree, edit_obj, 0, &idx, EDINIT);
	  }
						/* wait for mouse or key */
	  which = evnt_multi(MU_KEYBD | MU_BUTTON, 
			0x02, 0x01, 0x01, 
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,
			0x0L,
			0, 0,
			&x_mx, &x_my, &x_mb, 
			&ks,   &kr,   &br);
						/* handle keyboard event*/
	  if (which & MU_KEYBD)
	  {
	    cont = form_keybd(tree, edit_obj, next_obj, kr, &next_obj, (WORD *)&kr);
	    if (kr)
	      objc_edit(tree, edit_obj, kr, &idx, EDCHAR);
	  }
						/* handle button event	*/
	  if (which & MU_BUTTON)
	  {
	    next_obj = objc_find(tree, ROOT, MAX_DEPTH, x_mx, x_my);
 	    if (next_obj == NIL)
	    {
	      /* sound(TRUE, 440, 2); */
	      next_obj = 0;
	    }
	    else
	    {
		/* [JCE] handle clicks on the edit panel entirely ourselves */
		  if (next_obj == CURSEDIT) 
		  {
			  frob_bitmap(pc, cur_col, tree);
			  /* It crashes if I don't dispatch the event with form_button()
			   * so I'll send it to something harmless */
			  cont = form_button(tree, CURSTITL, br, &next_obj); 
		  }   
	      else cont = form_button(tree, next_obj, br, &next_obj);
	    }
	  }
						/* handle end of field	*/
						/*   clean up		*/
	  if ( (!cont) ||
	       ((next_obj != 0) && 
		(next_obj != edit_obj)) )

	  {
	    objc_edit(tree, edit_obj, 0, &idx, EDEND);
	  }
	}

	wind_update(2);
	wind_update(0);
						/* return exit object	*/
						/*   hi bit may be set	*/
						/*   if exit obj. was	*/
						/*   double-clicked	*/
	return(next_obj);
}



WORD y_form_do(REG LPTREE tree, WORD start_fld, WORD cur_col, BITBLK *pb)
{
	REG WORD	edit_obj;
	WORD		next_obj;
	WORD		which, cont;
	WORD		idx;
	UWORD		ks, kr, br;

	wind_update(1);
	wind_update(3);
						/* set starting field	*/
						/*   to edit, if want	*/
						/*   first editing field*/
						/*   then walk tree	*/
	next_obj = fm_inifld(tree, start_fld);
	edit_obj = 0;
						/* interact with user	*/
	cont = TRUE;
	while(cont)
	{
						/* position cursor on	*/
						/*   the selected 	*/
						/*   editting field	*/
	  if ( (next_obj != 0) &&
	       (edit_obj != next_obj) )
	  {
	    edit_obj = next_obj;
	    next_obj = 0;
	    objc_edit(tree, edit_obj, 0, &idx, EDINIT);
	  }
						/* wait for mouse or key */
	  which = evnt_multi(MU_KEYBD | MU_BUTTON, 
			0x02, 0x01, 0x01, 
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,
			0x0L,
			0, 0,
			&x_mx, &x_my, &x_mb, 
			&ks,   &kr,   &br);
						/* handle keyboard event*/
	  if (which & MU_KEYBD)
	  {
	    cont = form_keybd(tree, edit_obj, next_obj, kr, &next_obj, (WORD *)&kr);
	    if (kr)
	      objc_edit(tree, edit_obj, kr, &idx, EDCHAR);
	  }
						/* handle button event	*/
	  if (which & MU_BUTTON)
	  {
	    next_obj = objc_find(tree, ROOT, MAX_DEPTH, x_mx, x_my);
 	    if (next_obj == NIL)
	    {
	      /* sound(TRUE, 440, 2); */
	      next_obj = 0;
	    }
	    else
	    {
		/* [JCE] handle clicks on the edit panel entirely ourselves */
		  if (next_obj == ICONEDIT) 
		  {
			  y_frob_bitmap(pb, cur_col, tree);
			  /* It crashes if I don't dispatch the event with form_button()
			   * so I'll send it to something harmless */
			  cont = form_button(tree, ICONTTL, br, &next_obj); 
		  }   
	      else cont = form_button(tree, next_obj, br, &next_obj);
	    }
	  }
						/* handle end of field	*/
						/*   clean up		*/
	  if ( (!cont) ||
	       ((next_obj != 0) && 
		(next_obj != edit_obj)) )

	  {
	    objc_edit(tree, edit_obj, 0, &idx, EDEND);
	  }
	}

	wind_update(2);
	wind_update(0);
						/* return exit object	*/
						/*   hi bit may be set	*/
						/*   if exit obj. was	*/
						/*   double-clicked	*/
	return(next_obj);
}





