/***************************************************
	mined keyboard mapping table
	* generated with mkkbmap (mkkmuhan)
	  from Unihan database, kCangjie entries
	* supplemented with additional mappings
	* generated with mkkmhkscs
	  from HKSCS Changjie table etc/charmaps/hkscs/hkscs-2004-cj.txt
	* supplemented with punctuation mappings
*/
struct keymap keymap_Cangjie [] = {
	{"!", "！"},
	{"#", "〃 々 〆 〇 〜 ￦"},
	{"$", "￥"},
	{"&", "―"},
	{"(", "（"},
	{")", "）"},
	{",", "，"},
	{".", "。"},
	{":", "："},
	{";", "；"},
	{"<", "〈"},
	{"<<", "《"},
	{">", "〉"},
	{">>", "》"},
	{"?", "？"},
	{"@", "・"},
	{"[", "【 〖 〔 「 『"},
	{"\\", "、"},
	{"]", "】 〗 〕 」 』"},
	{"^", "……"},
	{"_", "――"},
	{"«", "《"},
	{"»", "》"},
	{"€", "€ ＄ ￥ ￦ ￡ ￠ ￢ ￣"},

	{"a", "日 曰"},
	{"aa", "昌 昍"},
	{"aaa", "晶"},
	{"aaaa", "𣊫 𣊭"},
	{"aaah", "曑"},
	{"aaam", "曡 㬪"},
	{"aaav", "曟"},
	{"aabt", "㬈"},
	{"aabuu", "覸"},
	{"aaf", "焸"},
	{"aahaf", "鷼 𪂇"},
	{"aahm", "暒"},
	{"aahml", "㫀"},
	{"aahu", "𣈲"},
	{"aaja", "龧"},
	{"aajv", "暥"},
	{"aam", "㫜"},
	{"aamg", "𤦉"},
	{"aamh", "暘"},
	{"aamj", "晘"},
	{"aamu", "㫯"},
	{"aaph", "晹"},
	{"aapv", "暍"},
	{"aate", "曝"},
	{"aavf", "㬤"},
	{"aayf", "暻"},
	{"ab", "明"},
	{"abac", "暝"},
	{"abbe", "曖"},
	{"abbq", "𣊬"},
	{"abbt", "盟"},
	{"abbuu", "覵"},
	{"abf", "焽"},
	{"abgr", "晭"},
	{"abha", "㿢"},
	{"abhaf", "鷳"},
	{"abhf", "䳟"},
	{"abik", "猒"},
	{"abjcm", "曌"},
	{"abjj", "暈 暉"},
	{"abkf", "㬗"},
	{"abkq", "晕"},
	{"abme", "暖 㬊"},
	{"abmgi", "琞"},
	{"abmr", "晍"},
	{"abms", "勗"},
	{"abof", "暩"},
	{"abou", "暚"},
	{"abt", "昷"},
	{"abu", "冒"},
	{"abug", "㬬"},
	{"abuu", "晛 㒻"},
	{"abwi", "㬭"},
	{"aci", "昖"},
	{"acim", "暡"},
	{"acmbc", "顕"},
	{"acnh", "晜"},
	{"acsh", "昐"},
	{"acwa", "㬝"},
	{"ad", "杲"},
	{"add", "晽"},
	{"adhaf", "鷴"},
	{"adhl", "晰"},
	{"adi", "时"},
	{"adj", "昩"},
	{"admq", "暐"},
	{"adwf", "暕"},
	{"aedhe", "㿺"},
	{"aenl", "鄤"},
	{"aeor", "㬁"},
	{"af", "炅 炚"},
	{"afbf", "曭"},
	{"afbr", "㫾"},
	{"afd", "㫧"},
	{"afdq", "暽"},
	{"aff", "晱"},
	{"afhhh", "影"},
	{"afln", "㔀"},
	{"afmbc", "顥 顯"},
	{"afmbo", "颢"},
	{"afmm", "𣉖"},
	{"afmu", "晃 晄"},
	{"afno", "歞"},
	{"afq", "㫠"},
	{"afqu", "㒽"},
	{"afshr", "㷖"},
	{"afyrb", "䯫"},
	{"ag", "圼"},
	{"agbt", "曀"},
	{"agcc", "㬨"},
	{"agdi", "時 㫭"},
	{"agg", "晆"},
	{"aggu", "曉"},
	{"agi", "㫢"},
	{"aglc", "㫱"},
	{"agrr", "暿"},
	{"ahaj", "暤 暭"},
	{"ahbn", "㫼"},
	{"ahbr", "晌 晑"},
	{"ahbu", "眉"},
	{"ahe", "昄"},
	{"ahey", "昸 㫡"},
	{"ahf", "𤋁"},
	{"ahgf", "曛"},
	{"ahgr", "晧"},
	{"ahhaf", "鶍"},
	{"ahhd", "𥟟"},
	{"ahhl", "昴"},
	{"ahhni", "䬗"},
	{"ahi", "㦹"},
	{"ahkr", "㬖"},
	{"ahln", "剔"},
	{"ahml", "昕"},
	{"ahnr", "㫟"},
	{"ahog", "暀"},
	{"ahok", "敭"},
	{"ahoo", "暰"},
	{"ahor", "晷"},
	{"ahp", "惖"},
	{"ahqm", "星"},
	{"ahqo", "昳"},
	{"ahs", "昈 昨"},
	{"ahsk", "曒"},
	{"ahsl", "㫹"},
	{"aht", "昇"},
	{"ahud", "暞"},
	{"ahuj", "曍"},
	{"ahum", "𣊊"},
	{"ahvi", "㫝"},
	{"ahvl", "昂"},
	{"ahxu", "晲"},
	{"ahye", "敡"},
	{"ai", "旷"},
	{"aiav", "㫰"},
	{"aibi", "㬍"},
	{"aice", "晙"},
	{"aifq", "㬕"},
	{"aihs", "晟"},
	{"aii", "昿"},
	{"aijb", "晡"},
	{"aikf", "㬙"},
	{"aikp", "昽"},
	{"aimbc", "䫀"},
	{"aimu", "𣇈"},
	{"aimvu", "既"},
	{"aine", "昹"},
	{"airf", "㬃"},
	{"aisl", "即"},
	{"aislf", "䳭"},
	{"ait", "昪"},
	{"aitc", "曠"},
	{"aj", "早"},
	{"ajb", "昁"},
	{"ajbd", "㫲"},
	{"ajbj", "暔"},
	{"ajd", "昧"},
	{"ajhaf", "䳚"},
	{"ajii", "暷"},
	{"ajka", "暑"},
	{"ajkd", "㫴"},
	{"ajkf", "曢"},
	{"ajlo", "㫸"},
	{"ajmm", "暄"},
	{"ajmu", "晥"},
	{"ajnu", "晼"},
	{"ajtu", "暁"},
	{"ajv", "晏 㫨"},
	{"ajye", "㪋"},
	{"ak", "旲"},
	{"akcf", "暸"},
	{"akkb", "晞"},
	{"akll", "昦"},
	{"aklu", "晻"},
	{"akms", "晇"},
	{"akn", "旯"},
	{"akp", "㦔"},
	{"aks", "㫑"},
	{"al", "曱"},
	{"albk", "映"},
	{"albo", "𣋡"},
	{"alg", "堲"},
	{"alln", "昲"},
	{"almo", "晁"},
	{"almy", "暃 㫵"},
	{"alnc", "曊"},
	{"alwu", "㫣"},
	{"alx", "㬘"},
	{"am", "旦"},
	{"amam", "晅"},
	{"ambb", "曘"},
	{"ambc", "暊"},
	{"ambe", "𣌊"},
	{"ambg", "曤"},
	{"ambi", "曇 曧 㬡"},
	{"ambk", "㬉"},
	{"ambm", "𣌟"},
	{"ambuu", "𧡰"},
	{"amcw", "晒"},
	{"amd", "旴"},
	{"amdi", "㝵"},
	{"amg", "旺"},
	{"amgc", "㬄"},
	{"amhaf", "鴠"},
	{"amhqu", "毾"},
	{"ami", "戥"},
	{"amia", "㬐"},
	{"amig", "晊"},
	{"amj", "旰 旱"},
	{"amk", "昊"},
	{"amks", "昮"},
	{"amlk", "𣆳"},
	{"ammi", "昙"},
	{"ammk", "晸"},
	{"ammp", "曬"},
	{"ammr", "晤"},
	{"ammv", "晨"},
	{"amne", "㫤"},
	{"amo", "昃"},
	{"amob", "昞 昺"},
	{"amrb", "㬏"},
	{"amrxu", "鼂"},
	{"amsh", "昜"},
	{"amsl", "昻"},
	{"amtb", "曞"},
	{"amtc", "㫫"},
	{"amu", "㫕"},
	{"amwf", "㬓"},
	{"amwg", "量"},
	{"amwj", "曋"},
	{"amym", "昰"},
	{"amyo", "是"},
	{"an", "門"},
	{"ana", "間"},
	{"anaa", "閶"},
	{"anam", "䦔"},
	{"anan", "闁"},
	{"anapv", "䦪"},
	{"anasm", "闒"},
	{"anau", "冕 晚"},
	{"anav", "䦘"},
	{"anayk", "閺"},
	{"anb", "閒"},
	{"anbbe", "閿"},
	{"anbck", "闝"},
	{"anbk", "㬇"},
	{"anbuc", "閴"},
	{"anbue", "闅 䦩"},
	{"anbuk", "闃"},
	{"anc", "䦦"},
	{"ancr", "曕"},
	{"ancru", "閱"},
	{"and", "閑 㫗"},
	{"andd", "䦥"},
	{"andh", "閉"},
	{"andk", "䦑"},
	{"andmq", "闈"},
	{"andw", "䦨"},
	{"andwf", "闌"},
	{"ane", "閖"},
	{"aneee", "䦤"},
	{"anefh", "閯"},
	{"anegi", "䦢"},
	{"anehr", "闊"},
	{"anemg", "䦞"},
	{"anf", "焛 𨳒"},
	{"anfbg", "闛"},
	{"anfbw", "闣"},
	{"anfqu", "闂"},
	{"ang", "䦌"},
	{"angdi", "䦙"},
	{"angg", "閨"},
	{"angit", "闔"},
	{"anglc", "䦝"},
	{"angr", "䦖"},
	{"anh", "閁"},
	{"anhae", "闎"},
	{"anhbt", "䦗"},
	{"anhda", "䦭"},
	{"anhe", "昅"},
	{"anher", "閣"},
	{"anhjr", "䦚"},
	{"anhni", "闏"},
	{"anhpa", "閽"},
	{"anhqu", "閐"},
	{"anhud", "闑"},
	{"anhx", "閰"},
	{"anhxh", "𨉖"},
	{"anhxu", "䦧"},
	{"aniav", "閬"},
	{"anibp", "𨶙"},
	{"anikf", "䦱"},
	{"aniq", "曻"},
	{"anir", "㫥"},
	{"anirk", "闙"},
	{"anirm", "閾"},
	{"anit", "閞"},
	{"anjbc", "闐"},
	{"anjka", "闍"},
	{"anjrr", "䦡"},
	{"anjwj", "閳"},
	{"ankf", "㬠"},
	{"anki", "閎"},
	{"anklu", "閹"},
	{"ankn", "𨳊"},
	{"anlmc", "闠"},
	{"anlmi", "閩"},
	{"anm", "閂"},
	{"anmcw", "閪"},
	{"anmfb", "䦵"},
	{"anmfj", "閛"},
	{"anmg", "閏"},
	{"anmgi", "閠"},
	{"anmgk", "䦯"},
	{"anmj", "閈"},
	{"anmjk", "闞"},
	{"anmlm", "閸"},
	{"anmmm", "閆"},
	{"anmmr", "䦜"},
	{"anmmu", "䦎"},
	{"anmn", "閅"},
	{"anmnr", "閜"},
	{"anmr", "䦒"},
	{"anmso", "䦠"},
	{"anmt", "開"},
	{"anmti", "闘"},
	{"anmvh", "閕"},
	{"anmwg", "闉"},
	{"anmwv", "闄"},
	{"anmy", "閇"},
	{"anncr", "䦲"},
	{"annhx", "閻"},
	{"annkg", "閮"},
	{"annok", "闋"},
	{"annsd", "䦛"},
	{"annwu", "䦰"},
	{"ano", "欥 閃"},
	{"anog", "閵"},
	{"anoi", "閥"},
	{"anoii", "閝"},
	{"anok", "暌"},
	{"anoll", "䦏"},
	{"anomc", "𨴴"},
	{"anomm", "闟"},
	{"anomr", "閤"},
	{"anon", "䦍"},
	{"anoog", "䦟"},
	{"anooo", "閦"},
	{"anp", "悶 𨳍"},
	{"anph", "閟"},
	{"anq", "䦐"},
	{"anqhk", "䦬"},
	{"anqka", "䦮"},
	{"anqou", "闚"},
	{"anr", "問"},
	{"anrhr", "閭"},
	{"anrrj", "闡"},
	{"anrrr", "闆"},
	{"ansh", "旸"},
	{"ansj", "聞"},
	{"ansqf", "闖"},
	{"ansrj", "闢"},
	{"antc", "閧"},
	{"antcu", "闀"},
	{"antk", "関"},
	{"antlk", "䦫"},
	{"antt", "䦕"},
	{"antuo", "闕"},
	{"antwt", "闦"},
	{"anu", "閊"},
	{"anumt", "闓"},
	{"anus", "𣈳"},
	{"anvff", "𨶹"},
	{"anvhl", "䦳"},
	{"anvif", "闗"},
	{"anvit", "關"},
	{"anwd", "閫"},
	{"anwl", "閘"},
	{"anwlj", "䦴"},
	{"anwlv", "闤"},
	{"anygq", "闥"},
	{"anygv", "闧"},
	{"anyhn", "閌"},
	{"anyhs", "閍"},
	{"anyj", "閗"},
	{"anyk", "閔"},
	{"anylb", "閙"},
	{"anymr", "誾"},
	{"anyr", "䦓"},
	{"anysy", "閼"},
	{"anyt", "閚"},
	{"anyta", "闇"},
	{"anytr", "䦣"},
	{"anyvo", "閡"},
	{"aodmq", "韙"},
	{"aofh", "尟"},
	{"aog", "㫿"},
	{"aohaf", "鶗"},
	{"aohh", "昣"},
	{"aoii", "昤"},
	{"aoin", "昑"},
	{"aoir", "晗"},
	{"aoj", "旿"},
	{"aoln", "㓳"},
	{"aomb", "㫻"},
	{"aombc", "題"},
	{"aombo", "题"},
	{"aomn", "𣈥 𣈯"},
	{"aomvn", "㼵"},
	{"aon", "㫓"},
	{"aond", "暣"},
	{"aonk", "㬋"},
	{"aop", "匙"},
	{"aopj", "晔"},
	{"aoqs", "韪"},
	{"aorm", "㬛"},
	{"aowy", "晦"},
	{"ap", "㫐"},
	{"apa", "㫬"},
	{"aphaf", "鵾"},
	{"aphh", "昒 易"},
	{"aphu", "晓"},
	{"api", "旳"},
	{"apim", "昀"},
	{"apmm", "暅"},
	{"app", "昆"},
	{"appym", "鹍"},
	{"apr", "昫"},
	{"apu", "旽"},
	{"apvo", "曷"},
	{"aqhl", "晣"},
	{"aqjm", "暳"},
	{"aqjp", "㬩"},
	{"aqka", "暙"},
	{"aqmb", "晴"},
	{"aqo", "㫙"},
	{"arf", "煦 照"},
	{"arhu", "㫛"},
	{"armd", "冔"},
	{"arpa", "㬆"},
	{"arrj", "暺"},
	{"arrk", "曮"},
	{"arye", "暇"},
	{"asei", "曯"},
	{"asf", "煝"},
	{"ash", "旫"},
	{"ashr", "昭"},
	{"asje", "最"},
	{"asjs", "朂"},
	{"askr", "𣇉"},
	{"asmb", "㫶"},
	{"asmg", "曜"},
	{"asmh", "㬔"},
	{"asp", "昵"},
	{"ass", "昛"},
	{"astr", "暱"},
	{"at", "㫒"},
	{"ata", "𣈏"},
	{"atak", "暯"},
	{"atbc", "晪"},
	{"atbo", "曚"},
	{"atc", "显"},
	{"atcd", "曗"},
	{"atce", "暴"},
	{"atcr", "謈"},
	{"atgi", "㬢 㬣"},
	{"atgs", "曦 𣌀"},
	{"atit", "㬒"},
	{"atlb", "暪"},
	{"atlc", "曂"},
	{"atlf", "曣"},
	{"atlk", "暎"},
	{"atlo", "暵"},
	{"atmj", "曄"},
	{"atnk", "𣋒"},
	{"atoe", "㬦"},
	{"atog", "㬮"},
	{"atqm", "暛"},
	{"atrk", "曔"},
	{"atw", "𣈴"},
	{"atys", "𣇷"},
	{"au", "巴 旵"},
	{"auam", "暨"},
	{"auav", "㬞"},
	{"aub", "䐴"},
	{"aubt", "䀈"},
	{"aud", "槩 㮣"},
	{"aue", "㫞"},
	{"aufd", "䊠"},
	{"aug", "塈"},
	{"auhaf", "鶥"},
	{"auhqu", "毷"},
	{"auks", "勖"},
	{"aumt", "暟"},
	{"aunl", "郿"},
	{"aunwf", "鱀"},
	{"aupym", "鹛"},
	{"aurp", "巼"},
	{"auu", "岊 昢 𣅽"},
	{"auud", "㬥"},
	{"auuf", "㬧"},
	{"auuj", "曓"},
	{"auye", "㪞"},
	{"auyt", "䇒"},
	{"av", "妟 艮"},
	{"avg", "垦"},
	{"avhaf", "鶡 鷃 鷐 䳛"},
	{"avhl", "曏"},
	{"avhqu", "毼"},
	{"avif", "㬎"},
	{"avii", "𣊉"},
	{"avks", "㔠"},
	{"avln", "㓭"},
	{"avmbc", "䫘"},
	{"avne", "㫽"},
	{"avno", "歇"},
	{"avog", "䨃"},
	{"avp", "恳"},
	{"avpym", "鹖"},
	{"awla", "曙"},
	{"awlb", "㬂"},
	{"awle", "曼"},
	{"awlg", "曪"},
	{"awlj", "曎"},
	{"awls", "㬅"},
	{"ayaf", "㬌"},
	{"ayaj", "晫"},
	{"aybg", "㒿"},
	{"aybk", "㬚"},
	{"aybp", "曨"},
	{"ayc", "昗"},
	{"ayck", "晈"},
	{"aydk", "暾"},
	{"aydl", "㬑"},
	{"ayfd", "𣉢"},
	{"ayhs", "昉 昘"},
	{"ayk", "旻 旼"},
	{"ayle", "曃"},
	{"aym", "㫔"},
	{"aynq", "㬯"},
	{"ayoj", "晬"},
	{"aypt", "曥"},
	{"ayrb", "暠"},
	{"ayrd", "㬀"},
	{"ayrf", "景 晾"},
	{"ayrv", "曩"},
	{"aysd", "暆 㒾"},
	{"ayso", "暶"},
	{"ayt", "昱"},
	{"ayta", "暗"},
	{"aytg", "曈"},
	{"aytj", "暲"},
	{"ayvi", "昡 𣆂"},
	{"ayvo", "晐"},
	{"ayx", "𣋠"},
	{"b", "月"},
	{"ba", "㸓"},
	{"babt", "腽"},
	{"bahm", "腥"},
	{"bail", "䐚"},
	{"bakb", "幂"},
	{"bam", "胆"},
	{"bamh", "腸"},
	{"bamj", "䏷"},
	{"bamo", "䐎"},
	{"bang", "膶"},
	{"banw", "䑌"},
	{"bapp", "䐊"},
	{"bate", "𦢊"},
	{"bau", "肥"},
	{"bayc", "冥"},
	{"bb", "朋"},
	{"bbaph", "䯜"},
	{"bbavf", "䯥"},
	{"bbb", "骨 ⻣"},
	{"bbbb", "朤"},
	{"bbbbr", "䯞"},
	{"bbbr", "腡"},
	{"bbbuu", "覶"},
	{"bbbv", "骽"},
	{"bbcv", "䑍"},
	{"bbd", "䐆"},
	{"bbdhe", "骳"},
	{"bbdi", "脟"},
	{"bbdm", "骵"},
	{"bbe", "受"},
	{"bbfdv", "髅"},
	{"bbfmu", "䯑"},
	{"bbgg", "䯓"},
	{"bbggu", "髐"},
	{"bbhaf", "鶻"},
	{"bbher", "骼"},
	{"bbhf", "鵬"},
	{"bbhhj", "髀"},
	{"bbhjr", "䯏"},
	{"bbhmr", "骺"},
	{"bbhne", "骰"},
	{"bbhni", "骪"},
	{"bbhon", "䯒"},
	{"bbhpm", "骶"},
	{"bbhu", "觅"},
	{"bbiav", "䯖"},
	{"bbibi", "髆"},
	{"bbijb", "䯙"},
	{"bbijc", "髍"},
	{"bbikk", "䯋"},
	{"bbip", "骮"},
	{"bbjhp", "䯔"},
	{"bbjhr", "髂"},
	{"bbjj", "腪"},
	{"bbjmc", "髕"},
	{"bbjmu", "䯘"},
	{"bbjnu", "䯛"},
	{"bbjoc", "髌"},
	{"bbjr", "骷"},
	{"bbjti", "髖"},
	{"bbjtu", "髋"},
	{"bbke", "爱"},
	{"bbkmb", "䯝"},
	{"bbkms", "骻"},
	{"bbkn", "骩"},
	{"bbkni", "骫"},
	{"bbks", "䯇"},
	{"bblmc", "䯣"},
	{"bbln", "剮"},
	{"bblws", "𩩍"},
	{"bblwv", "髏"},
	{"bbm", "册 䏣"},
	{"bbmbc", "顝 䫚"},
	{"bbmd", "骬"},
	{"bbme", "䐘"},
	{"bbmj", "骭"},
	{"bbmlk", "骾"},
	{"bbmmu", "䯈"},
	{"bbmnr", "䯊"},
	{"bbmr", "胴"},
	{"bbmvu", "旤"},
	{"bbnd", "脬"},
	{"bbnkg", "䯕"},
	{"bbno", "歄 㽰 䯉"},
	{"bbnq", "舜"},
	{"bbobg", "髉"},
	{"bbobo", "䯐"},
	{"bboii", "䯍"},
	{"bboll", "骱"},
	{"bboma", "䯤"},
	{"bbomj", "䯎"},
	{"bbpe", "愛"},
	{"bbpm", "鹏"},
	{"bbpp", "𩨨"},
	{"bbppg", "䯗"},
	{"bbpru", "骲"},
	{"bbpym", "鹘"},
	{"bbr", "咼"},
	{"bbsd", "㬹"},
	{"bbskn", "䯌"},
	{"bbsmh", "髎"},
	{"bbtmt", "髒"},
	{"bbtpo", "䯟"},
	{"bbtqm", "髊"},
	{"bbtwi", "䯦"},
	{"bbtwt", "體"},
	{"bbtxc", "䯡"},
	{"bbu", "亂 䯆"},
	{"bbug", "臞"},
	{"bbul", "鼏"},
	{"bbuu", "覓 䏹"},
	{"bbv", "脮"},
	{"bbvib", "䯚"},
	{"bbvk", "膎"},
	{"bbwd", "髁"},
	{"bbwlb", "髃"},
	{"bbwli", "髑"},
	{"bbwot", "䯠"},
	{"bbybs", "髈"},
	{"bbyck", "骹"},
	{"bbyhn", "骯"},
	{"bbykb", "髓"},
	{"bbymp", "骴"},
	{"bbypt", "髗"},
	{"bbyrb", "髇"},
	{"bbytj", "辭"},
	{"bbyvo", "骸"},
	{"bc", "㓁 𦉪"},
	{"bcabu", "賵"},
	{"bcamh", "𧶽"},
	{"bcaph", "賜"},
	{"bcbcc", "贔"},
	{"bcbcd", "賝"},
	{"bcbcf", "䴍"},
	{"bcbgr", "賙"},
	{"bcbjj", "賱"},
	{"bcbsd", "𧶄"},
	{"bcbuc", "賏"},
	{"bcbuu", "覭"},
	{"bcc", "鑍"},
	{"bccim", "𧷜"},
	{"bccw", "䐉"},
	{"bccwa", "贈"},
	{"bcd", "罙"},
	{"bcdh", "財"},
	{"bcdhe", "貱"},
	{"bcfbc", "贘 䞆"},
	{"bcff", "賧"},
	{"bcfmu", "𧵦"},
	{"bcfqc", "䞉"},
	{"bcgdi", "䝰"},
	{"bcgwc", "贖"},
	{"bchaf", "鵙 鸎"},
	{"bchbt", "賉"},
	{"bche", "販"},
	{"bcher", "賂"},
	{"bchio", "貶"},
	{"bchjr", "𧵳"},
	{"bchpm", "貾"},
	{"bchqm", "貹"},
	{"bchqu", "㲘"},
	{"bchuc", "𧹏"},
	{"bci", "戝"},
	{"bcibi", "賻"},
	{"bcice", "賐"},
	{"bcig", "賍"},
	{"bcigi", "賘"},
	{"bcii", "賤"},
	{"bciih", "贂"},
	{"bcij", "賊"},
	{"bcijb", "䝵"},
	{"bcije", "賕"},
	{"bcikf", "䞈"},
	{"bcikk", "贆"},
	{"bcim", "䐥"},
	{"bcims", "贓"},
	{"bcip", "䐋"},
	{"bciq", "賎"},
	{"bcir", "貽"},
	{"bcj", "肸"},
	{"bcjir", "賳"},
	{"bcjka", "賭"},
	{"bcjmf", "賩"},
	{"bcjmn", "貯"},
	{"bcjnu", "䝹"},
	{"bckb", "賄"},
	{"bcll", "賗"},
	{"bcllp", "贃"},
	{"bclmt", "贐"},
	{"bcln", "則"},
	{"bcmbc", "䫤"},
	{"bcmbk", "䞂"},
	{"bcmgg", "䝽"},
	{"bcmgk", "䞃"},
	{"bcmj", "罕"},
	{"bcmmu", "貦"},
	{"bcmmv", "賑"},
	{"bcmpm", "賦"},
	{"bcms", "肹"},
	{"bcmvn", "甖"},
	{"bcmvr", "䞅"},
	{"bcmwj", "贉"},
	{"bcnau", "䒌"},
	{"bcncr", "贍"},
	{"bcnd", "𧴯"},
	{"bcnh", "䏲"},
	{"bcnl", "郥 鄍"},
	{"bcnyo", "䝪"},
	{"bcohh", "䝩"},
	{"bcoir", "賶"},
	{"bcoju", "罌"},
	{"bcok", "敗"},
	{"bcomd", "賖"},
	{"bcomf", "賒"},
	{"bconk", "䞀"},
	{"bcopd", "䝯"},
	{"bcos", "䝫"},
	{"bcpad", "賯"},
	{"bcpd", "貤"},
	{"bcpmm", "䝧"},
	{"bcpr", "䝭"},
	{"bcqka", "賰"},
	{"bcqmb", "䝼"},
	{"bcr", "冏"},
	{"bcrhu", "貺"},
	{"bcrl", "腳"},
	{"bcru", "脫 脱"},
	{"bcrxu", "鼆"},
	{"bcsav", "䞁"},
	{"bcsh", "朌"},
	{"bcshr", "𧵓"},
	{"bcsjr", "䝻"},
	{"bcsmh", "賿"},
	{"bcsmv", "賬"},
	{"bcsoy", "䝲"},
	{"bctbc", "賟"},
	{"bctco", "贌"},
	{"bctct", "賹"},
	{"bctis", "贜"},
	{"bctje", "䝸"},
	{"bctt", "賆"},
	{"bcttb", "購"},
	{"bctwb", "贎"},
	{"bctxc", "賺"},
	{"bcv", "嬰"},
	{"bcyaj", "𦋐"},
	{"bcybp", "贚"},
	{"bcyck", "賋"},
	{"bcydu", "䞋"},
	{"bcyg", "䝬"},
	{"bcyhn", "貥"},
	{"bcymr", "譻"},
	{"bcyoj", "賥"},
	{"bcypu", "䞊"},
	{"bcyr", "貼"},
	{"bcyrf", "䝶"},
	{"bcytr", "賠"},
	{"bcyvi", "䝮"},
	{"bcyvo", "賅"},
	{"bd", "采"},
	{"bdd", "冧"},
	{"bddf", "𦡞"},
	{"bdhaf", "䳕"},
	{"bdhe", "䏢"},
	{"bdher", "嗠"},
	{"bdhhh", "彩"},
	{"bdhqu", "㲗"},
	{"bdi", "肘"},
	{"bdk", "䏐"},
	{"bdks", "㔜"},
	{"bdl", "脨"},
	{"bdnl", "郛"},
	{"bdoe", "膝"},
	{"bdu", "乳"},
	{"bdw", "腖"},
	{"beee", "腏 𠖎"},
	{"behaf", "鶢 䳮"},
	{"bei", "肞"},
	{"benl", "䣤"},
	{"beytj", "辤"},
	{"bf", "炙"},
	{"bfb", "䏴"},
	{"bfbc", "䐝"},
	{"bfbg", "膛"},
	{"bfcb", "膌"},
	{"bfd", "冞 脒"},
	{"bfdq", "膦"},
	{"bff", "腅"},
	{"bffs", "朥"},
	{"bfh", "䏚"},
	{"bfhaf", "䳿"},
	{"bfhdw", "㸋"},
	{"bfhvf", "縣"},
	{"bfkcf", "爒"},
	{"bfmu", "胱"},
	{"bfp", "懸"},
	{"bfq", "胖"},
	{"bfqb", "幐 㬺"},
	{"bfqc", "賸"},
	{"bfqd", "榺"},
	{"bfqe", "滕"},
	{"bfqf", "縢 騰 黱"},
	{"bfqg", "塍"},
	{"bfqi", "螣"},
	{"bfqm", "腾 䲢"},
	{"bfqr", "謄"},
	{"bfqs", "勝"},
	{"bfqu", "腃"},
	{"bfqv", "媵"},
	{"bfu", "乿"},
	{"bfuk", "脳"},
	{"bg", "肚"},
	{"bgb", "爯 䏥"},
	{"bgg", "胿"},
	{"bggu", "膮"},
	{"bghaf", "鸜"},
	{"bghqu", "氍"},
	{"bgi", "胠"},
	{"bgil", "脚"},
	{"bgit", "䐦"},
	{"bgp", "㦟 䏯"},
	{"bgr", "周"},
	{"bgrt", "䐍"},
	{"bgte", "臌"},
	{"bgth", "膨"},
	{"bha", "胉"},
	{"bhae", "腺"},
	{"bhamj", "貋"},
	{"bhap", "冟"},
	{"bhav", "貇"},
	{"bhawe", "䝢"},
	{"bhbk", "䐿"},
	{"bhbue", "貜"},
	{"bhbv", "脓"},
	{"bhbvk", "貕"},
	{"bhd", "䝗"},
	{"bhdf", "䐐"},
	{"bhdh", "豺"},
	{"bhdhe", "䝛"},
	{"bhdn", "脷"},
	{"bhdv", "腇"},
	{"bhdw", "膰"},
	{"bhej", "䏺"},
	{"bheq", "胮"},
	{"bher", "胳"},
	{"bhesd", "䝣"},
	{"bhfn", "爳"},
	{"bhfr", "噕"},
	{"bhg", "㸒"},
	{"bhgf", "臐"},
	{"bhha", "貃"},
	{"bhhau", "貌"},
	{"bhhby", "貈"},
	{"bhher", "貉"},
	{"bhhh", "肜"},
	{"bhhhj", "貏"},
	{"bhhj", "脾"},
	{"bhhlo", "䝖"},
	{"bhhne", "䝘"},
	{"bhhuj", "䝥"},
	{"bhhv", "脈"},
	{"bhhwp", "貔"},
	{"bhhxu", "貎"},
	{"bhi", "𦞙"},
	{"bhice", "䝜"},
	{"bhjc", "貁"},
	{"bhjd", "䏭"},
	{"bhje", "腶"},
	{"bhjg", "腫"},
	{"bhjlk", "𧳅"},
	{"bhjm", "腄"},
	{"bhjr", "䏦"},
	{"bhju", "腯"},
	{"bhkcf", "䝤"},
	{"bhkmr", "䝝"},
	{"bhlbk", "𧲱"},
	{"bhlc", "䑇"},
	{"bhlq", "貄"},
	{"bhlwv", "貗"},
	{"bhma", "貊"},
	{"bhmam", "貆"},
	{"bhmbc", "䫉"},
	{"bhmfm", "豾"},
	{"bhmhf", "䝠"},
	{"bhmj", "豻"},
	{"bhml", "肵"},
	{"bhmo", "㭀"},
	{"bhn", "冗 肌"},
	{"bhne", "股"},
	{"bhnf", "爲"},
	{"bhni", "䏎"},
	{"bhob", "豽"},
	{"bhod", "貅"},
	{"bhomn", "貐"},
	{"bhon", "胻"},
	{"bhoo", "䐫"},
	{"bhpi", "豹"},
	{"bhpm", "胝"},
	{"bhpp", "豼"},
	{"bhpr", "豿"},
	{"bhqhk", "䝟"},
	{"bhqm", "胜"},
	{"bhqo", "胅"},
	{"bhqr", "㬶"},
	{"bhrr", "䏨"},
	{"bhrrj", "貚"},
	{"bhrye", "貑"},
	{"bhs", "胙"},
	{"bhshr", "貂"},
	{"bhsk", "䝙"},
	{"bhsp", "䝚"},
	{"bhsrr", "貙"},
	{"bhtak", "貘"},
	{"bhtct", "貖"},
	{"bhtlb", "䝡"},
	{"bhtrg", "貛"},
	{"bhtw", "貓"},
	{"bhuc", "臢"},
	{"bhul", "䑄"},
	{"bhumb", "貒"},
	{"bhuo", "臜"},
	{"bhuu", "膬 貀"},
	{"bhvo", "胍"},
	{"bhwg", "貍"},
	{"bhwlo", "䝦"},
	{"bhwp", "膍"},
	{"bhx", "舀"},
	{"bhxc", "䑂"},
	{"bhxe", "膄"},
	{"bhxf", "冩"},
	{"bhxo", "腴"},
	{"bhxu", "腉"},
	{"bhypu", "䝞"},
	{"biav", "朖"},
	{"bibi", "膊"},
	{"bice", "朘 脧"},
	{"big", "脏"},
	{"bihq", "䏬"},
	{"bihqu", "㲕"},
	{"bii", "䏼"},
	{"bijb", "脯"},
	{"bije", "脙"},
	{"bik", "肰"},
	{"bikf", "𤔡"},
	{"bikk", "胈"},
	{"bikp", "胧"},
	{"biku", "肬"},
	{"bilr", "膅"},
	{"bimbc", "頱"},
	{"bine", "脉"},
	{"bioi", "腑"},
	{"bip", "悬"},
	{"bipc", "膩"},
	{"bipf", "臕"},
	{"bipo", "腻"},
	{"bipp", "脦"},
	{"bir", "胎"},
	{"bisb", "䐔"},
	{"bitc", "臁"},
	{"biuh", "䏵"},
	{"bixp", "膔"},
	{"biypu", "虢"},
	{"bjb", "肺"},
	{"bjbc", "䐜"},
	{"bjbd", "脖"},
	{"bjbj", "腩"},
	{"bjbm", "䐈"},
	{"bjcg", "膣"},
	{"bjcm", "腔"},
	{"bjcr", "𦞳"},
	{"bjcu", "𦡆"},
	{"bjd", "䏞"},
	{"bjdhe", "皸"},
	{"bje", "肢"},
	{"bjhaf", "鶤"},
	{"bjii", "膞"},
	{"bjka", "䐗"},
	{"bjkp", "𦚱"},
	{"bjlmi", "蠈"},
	{"bjlo", "脻"},
	{"bjmbc", "顐"},
	{"bjmc", "臏"},
	{"bjmf", "腙"},
	{"bjmg", "腟"},
	{"bjmo", "腚"},
	{"bjmu", "脘"},
	{"bjnl", "鄆"},
	{"bjnu", "腕"},
	{"bjoc", "膑"},
	{"bjrj", "䐻"},
	{"bjtc", "膹"},
	{"bjti", "臗"},
	{"bjv", "胺"},
	{"bjwj", "軍"},
	{"bk", "冈 罓"},
	{"bkcf", "膫"},
	{"bkcor", "谿"},
	{"bkcu", "𦞴"},
	{"bkd", "胨"},
	{"bkf", "然 𤉷"},
	{"bkhaf", "鶪 鷄"},
	{"bki", "肱 肽"},
	{"bkic", "脎"},
	{"bkirm", "䍞"},
	{"bkk", "网"},
	{"bkkb", "脪"},
	{"bkln", "刚"},
	{"bklu", "腌"},
	{"bkmbc", "䫣"},
	{"bkmj", "䍑"},
	{"bkmlw", "羀"},
	{"bkmr", "䐀"},
	{"bkms", "胯"},
	{"bkn", "胰"},
	{"bkni", "肒"},
	{"bknl", "郹"},
	{"bknn", "䐒"},
	{"bkno", "㰿"},
	{"bkog", "雞"},
	{"bkoo", "脥"},
	{"bkpb", "䐭"},
	{"bkpym", "䴗"},
	{"bkq", "军"},
	{"bks", "肋"},
	{"bksc", "胁"},
	{"bksj", "䐛"},
	{"bkso", "䏮"},
	{"bkss", "脇"},
	{"bl", "肿"},
	{"blbk", "胦"},
	{"blbu", "䏙"},
	{"blgm", "䐸"},
	{"bll", "𦉫"},
	{"blll", "䏒"},
	{"blln", "胇"},
	{"blmc", "膭"},
	{"blmo", "朓 脁"},
	{"blmy", "腓"},
	{"bln", "刖"},
	{"bloo", "㒳"},
	{"blqjs", "䵻"},
	{"blu", "见"},
	{"blwl", "胂"},
	{"blwv", "膢"},
	{"blx", "䐹"},
	{"blxh", "胏"},
	{"bm", "且 囗 肛"},
	{"bmbb", "臑"},
	{"bmbc", "䐓"},
	{"bmbg", "臛"},
	{"bmbk", "腝"},
	{"bmbl", "胹"},
	{"bmbs", "膤"},
	{"bmbu", "脜"},
	{"bmcw", "𦚵"},
	{"bmd", "䏏"},
	{"bmf", "肧"},
	{"bmfb", "𦢈"},
	{"bmfj", "胓"},
	{"bmfm", "胚"},
	{"bmfr", "脴"},
	{"bmg", "䏕"},
	{"bmhaf", "鴡"},
	{"bmi", "县"},
	{"bmig", "胵"},
	{"bmj", "肝"},
	{"bmke", "爰"},
	{"bmks", "助"},
	{"bmlb", "脼"},
	{"bmlm", "𦜖"},
	{"bmln", "刞"},
	{"bmm", "冄 ⺜"},
	{"bmmbc", "䪶"},
	{"bmmc", "具"},
	{"bmmf", "䏡"},
	{"bmmo", "冡 冢"},
	{"bmmr", "䏸"},
	{"bmms", "肟"},
	{"bmmu", "朊 䏓"},
	{"bmmv", "脤"},
	{"bmnl", "䢸"},
	{"bmnr", "胢"},
	{"bmog", "雎"},
	{"bmr", "同"},
	{"bmrb", "膈"},
	{"bmrt", "脰"},
	{"bmrw", "冨 腷"},
	{"bmso", "豚 䐁"},
	{"bmsp", "㥯"},
	{"bmua", "䐶"},
	{"bmue", "冦"},
	{"bmui", "冠"},
	{"bmuv", "㓂"},
	{"bmvm", "脛"},
	{"bmwf", "膘"},
	{"bmwj", "䐺"},
	{"bmwl", "腼"},
	{"bmwv", "腰"},
	{"bn", "肊 㐍"},
	{"bnau", "脃 脕"},
	{"bnb", "冎"},
	{"bncr", "膽"},
	{"bnd", "孚"},
	{"bng", "䏔"},
	{"bnhd", "腬"},
	{"bnhe", "䏜"},
	{"bnhx", "䐄"},
	{"bnii", "膙"},
	{"bnin", "䏧"},
	{"bnkg", "脡"},
	{"bnkq", "腱"},
	{"bnkv", "脠"},
	{"bnl", "䏖"},
	{"bnlii", "蠫"},
	{"bnmm", "䐞"},
	{"bnmu", "脆"},
	{"bnmvi", "䢆"},
	{"bno", "肷"},
	{"bnom", "胫"},
	{"bnot", "膯"},
	{"bnsh", "肠"},
	{"bnui", "冤"},
	{"bnwf", "䐳"},
	{"bo", "贝"},
	{"boaa", "䞎"},
	{"boabu", "赗"},
	{"boae", "腹"},
	{"boah", "膓"},
	{"boaph", "赐"},
	{"bob", "肭"},
	{"bobgr", "赒"},
	{"bobo", "朒 䏑"},
	{"boboo", "赑"},
	{"bobr", "𦛚"},
	{"bocwa", "赠"},
	{"bod", "䏫"},
	{"bodh", "财"},
	{"bodi", "胕"},
	{"boff", "赕"},
	{"bog", "脽"},
	{"bogf", "膲"},
	{"bogs", "臇 䐪"},
	{"bohaf", "鶏"},
	{"bohe", "贩"},
	{"boher", "赂"},
	{"bohh", "胗"},
	{"bohio", "贬"},
	{"bohjr", "䞌"},
	{"boibi", "赙"},
	{"boig", "赃"},
	{"boii", "朎"},
	{"boij", "贼"},
	{"boije", "赇"},
	{"boim", "䑎"},
	{"boin", "肣"},
	{"boip", "腍"},
	{"boir", "贻"},
	{"boj", "㬳"},
	{"bojka", "赌"},
	{"bojm", "贮"},
	{"bojnk", "赎"},
	{"boju", "䍃"},
	{"bokb", "贿"},
	{"bolb", "䐰"},
	{"boln", "则"},
	{"boma", "膾"},
	{"bomb", "腀"},
	{"bomc", "㒷 𦛼"},
	{"bomi", "脍"},
	{"bomm", "脸"},
	{"bommf", "祭"},
	{"bommv", "赈"},
	{"bomn", "腧 䏗"},
	{"bomo", "臉"},
	{"bompm", "赋"},
	{"bomr", "䏩"},
	{"bomrt", "豋"},
	{"bon", "肐"},
	{"boncr", "赡"},
	{"boog", "脞"},
	{"booju", "罂"},
	{"book", "败"},
	{"boomf", "赊"},
	{"bopd", "胣"},
	{"bopi", "购"},
	{"bopo", "账"},
	{"boq", "脌"},
	{"boqka", "䞐"},
	{"boqmb", "䞍"},
	{"borhu", "贶"},
	{"bosoy", "赆"},
	{"botf", "膴"},
	{"botxc", "赚"},
	{"bov", "婴"},
	{"bowp", "䞏"},
	{"bowy", "脢"},
	{"boymr", "詧"},
	{"boyr", "贴"},
	{"boytr", "赔"},
	{"boyvo", "赅"},
	{"bpa", "脂"},
	{"bpd", "肔"},
	{"bph", "䏟"},
	{"bpha", "䐇"},
	{"bphh", "肳"},
	{"bphr", "脗"},
	{"bpi", "肑"},
	{"bpmm", "䏛"},
	{"bpo", "胀"},
	{"bpp", "肶"},
	{"bppg", "䏶"},
	{"bpr", "朐 胊"},
	{"bpru", "胞"},
	{"bpt", "朑"},
	{"bptd", "䐑"},
	{"bpu", "肫"},
	{"bpuk", "胸"},
	{"bpuu", "䐢"},
	{"bq", "用"},
	{"bqdhe", "皲"},
	{"bqhaf", "䴄"},
	{"bqhag", "䑟"},
	{"bqhf", "䐼"},
	{"bqhl", "䏳"},
	{"bqj", "肨"},
	{"bqka", "䐏"},
	{"bqkk", "腠"},
	{"bqkq", "䏾"},
	{"bqmb", "腈"},
	{"bqmf", "膆"},
	{"bqmv", "脿"},
	{"bqni", "䏝"},
	{"bqnl", "郓"},
	{"bqo", "肤"},
	{"bqu", "甩"},
	{"br", "冋"},
	{"brbc", "䐣"},
	{"brc", "胑"},
	{"brhaf", "鵰"},
	{"brhg", "脭"},
	{"brhhh", "彫"},
	{"brhvf", "䌛 𦅚"},
	{"bri", "戙"},
	{"brip", "㢥"},
	{"brln", "㓮"},
	{"brmk", "脵"},
	{"brnl", "郮"},
	{"brob", "脶"},
	{"brog", "雕"},
	{"brrd", "臊"},
	{"brrj", "䐷"},
	{"brrp", "㖯"},
	{"brrs", "腭 㬽"},
	{"brse", "腵"},
	{"brsj", "䐕"},
	{"brsmm", "翢"},
	{"bru", "囘"},
	{"bsc", "䏘"},
	{"bsd", "爭"},
	{"bse", "脲"},
	{"bsec", "臔"},
	{"bsef", "鵩"},
	{"bsf", "㷡"},
	{"bsfd", "䐖"},
	{"bshh", "豸"},
	{"bshi", "肕"},
	{"bsip", "䏰"},
	{"bsj", "䏪"},
	{"bsje", "冣"},
	{"bsjr", "腒"},
	{"bsle", "服"},
	{"bsma", "䐲"},
	{"bsmg", "腛"},
	{"bsmh", "膠"},
	{"bsmj", "臎"},
	{"bsmr", "䏤"},
	{"bsmv", "脹"},
	{"bsok", "䐅"},
	{"bsp", "胒"},
	{"bsrj", "䑀"},
	{"bsrr", "膒"},
	{"bss", "凸"},
	{"bssr", "䏱"},
	{"bstv", "𦟌"},
	{"bt", "冊 皿 䍏"},
	{"bta", "腊"},
	{"btab", "冪"},
	{"btak", "膜"},
	{"btav", "臈"},
	{"btbc", "腆"},
	{"btbo", "朦 䑃"},
	{"btbs", "𦛨"},
	{"btc", "㬴"},
	{"btca", "𦡮"},
	{"btct", "膉"},
	{"btgr", "膳"},
	{"btis", "臓 臟"},
	{"btk", "朕"},
	{"btlb", "䐽"},
	{"btlf", "臙"},
	{"btlj", "䐙"},
	{"btlk", "朠"},
	{"btln", "删 刪"},
	{"btmbc", "頯 𩓚"},
	{"btmc", "䐵 𦝁"},
	{"btmd", "腜"},
	{"btmj", "𦠜"},
	{"btoe", "臒"},
	{"btop", "㬸"},
	{"btov", "㒺 䑆"},
	{"btq", "羘"},
	{"btqm", "䐤"},
	{"btrg", "䑏"},
	{"btt", "肼 胼"},
	{"bttb", "䐟"},
	{"btu", "岡"},
	{"btwa", "䐬"},
	{"btwn", "䑅"},
	{"btwv", "膿"},
	{"btxc", "膁"},
	{"btyj", "膵"},
	{"btyu", "㬻 䐠"},
	{"btyv", "罔"},
	{"bu", "冚 目"},
	{"buafu", "䁜"},
	{"buahm", "睲"},
	{"buahu", "睸"},
	{"buajv", "䁙"},
	{"buamh", "䁑"},
	{"buamj", "睅"},
	{"buamo", "睼"},
	{"buana", "瞷"},
	{"buanb", "瞯"},
	{"buang", "瞤"},
	{"buank", "矙"},
	{"buano", "䁡"},
	{"buaph", "睗"},
	{"buav", "眼"},
	{"bub", "眀"},
	{"bubac", "瞑"},
	{"bubbe", "瞹"},
	{"bubbq", "瞬"},
	{"bubd", "睬"},
	{"bubgr", "睭"},
	{"bubhf", "鷪"},
	{"bubjj", "睴"},
	{"bubme", "䁔"},
	{"bubmr", "眮"},
	{"bubou", "䁘"},
	{"bubsd", "睜"},
	{"bubu", "䀠"},
	{"bubue", "䂄"},
	{"bubug", "䂂"},
	{"bubuk", "瞁"},
	{"bubuu", "睍 覞"},
	{"bubvk", "𥉐"},
	{"bubwi", "䂃"},
	{"buc", "貝"},
	{"buce", "朡"},
	{"bucim", "瞈"},
	{"bucms", "盻"},
	{"bucnh", "睇"},
	{"bucor", "䀰"},
	{"bucsh", "盼"},
	{"bucwa", "䁬"},
	{"budhl", "𥇦"},
	{"budi", "䙷 䙸"},
	{"budj", "眜"},
	{"budk", "䀗"},
	{"budl", "䀳"},
	{"budmf", "𥈡"},
	{"budoo", "睞"},
	{"budt", "睐"},
	{"buei", "䀑"},
	{"bueiu", "䁊"},
	{"buf", "煛"},
	{"bufb", "睄"},
	{"bufbf", "矘"},
	{"bufbg", "瞠"},
	{"bufbq", "𥋇"},
	{"bufd", "眯"},
	{"bufdq", "瞵"},
	{"bufdv", "䁖"},
	{"buff", "睒"},
	{"bufh", "眇"},
	{"bufq", "眫"},
	{"bufqu", "睠"},
	{"bugce", "睖"},
	{"bugcg", "睦"},
	{"bugg", "眭"},
	{"buggu", "䁱"},
	{"bugis", "䀷"},
	{"bugit", "瞌"},
	{"bugrr", "瞦"},
	{"bugtj", "䁄"},
	{"buhaf", "瞗 鷂"},
	{"buhas", "矈"},
	{"buhce", "𥊙"},
	{"buhdf", "瞅"},
	{"buhe", "眅"},
	{"buhej", "䀱"},
	{"buher", "䀩"},
	{"buhfb", "𥋘"},
	{"buhfp", "矁"},
	{"buhgf", "矄"},
	{"buhhh", "䀐"},
	{"buhhj", "睥"},
	{"buhhv", "眽"},
	{"buhio", "眨"},
	{"buhj", "䀒"},
	{"buhjm", "睡"},
	{"buhjr", "䀨"},
	{"buhju", "瞃"},
	{"buhml", "盺"},
	{"buhni", "颻"},
	{"buhnk", "飖"},
	{"buhok", "矀 覹"},
	{"buhon", "䀪"},
	{"buhoo", "瞛"},
	{"buhpa", "睧"},
	{"buhqi", "睋"},
	{"buhqo", "眣"},
	{"buhqu", "眊"},
	{"buhsk", "睙 䁶"},
	{"buhu", "見"},
	{"buhui", "䁛"},
	{"buhus", "矏"},
	{"buhvd", "䀥"},
	{"buhvf", "繇"},
	{"buhvi", "眡"},
	{"buhvl", "䀚"},
	{"buhvp", "眂"},
	{"buhxe", "瞍"},
	{"buhxu", "睨"},
	{"buiav", "䀶"},
	{"buice", "睃"},
	{"buig", "𥅾"},
	{"buihq", "眸"},
	{"buihr", "䁍"},
	{"buijb", "䀯"},
	{"buik", "狊"},
	{"buikk", "䁭"},
	{"buikp", "眬"},
	{"builr", "瞊"},
	{"buine", "眿"},
	{"buiok", "䀵"},
	{"buir", "眙"},
	{"buitc", "矌"},
	{"buiv", "眓"},
	{"bujbc", "瞋"},
	{"bujcm", "瞾"},
	{"bujd", "眛"},
	{"bujii", "䁣"},
	{"bujir", "睵"},
	{"bujjl", "䁪"},
	{"bujka", "睹"},
	{"bujlo", "睫"},
	{"bujmc", "瞚 矉"},
	{"bujmm", "睻"},
	{"bujmn", "眝"},
	{"bujmu", "睆"},
	{"bujnu", "睕"},
	{"bujpn", "矃"},
	{"bujqr", "瞎"},
	{"bujr", "䀦"},
	{"bukcf", "瞭"},
	{"bukd", "㮂"},
	{"bukgg", "睳"},
	{"bukjj", "䡞"},
	{"bukk", "覐"},
	{"bukkb", "睎"},
	{"buklu", "䁆"},
	{"bukmf", "𥇧"},
	{"bukn", "眱"},
	{"bukni", "䀓"},
	{"bukoo", "鿃 䀹"},
	{"bukvf", "䋰"},
	{"bulbk", "眏"},
	{"bulbu", "眈"},
	{"bulln", "䀟"},
	{"bullp", "瞣"},
	{"bulmc", "瞶"},
	{"bulmi", "蜰"},
	{"bulmo", "眺"},
	{"buln", "剛"},
	{"bulwl", "眒"},
	{"bulws", "䀻"},
	{"bulwv", "瞜"},
	{"bumb", "腨"},
	{"bumbb", "𥌎"},
	{"bumbg", "矐"},
	{"bumd", "盱"},
	{"bumgg", "睚"},
	{"bumig", "眰"},
	{"bumj", "盰"},
	{"bumjk", "瞰"},
	{"bumk", "䀖"},
	{"bumls", "眄"},
	{"bummc", "䁰"},
	{"bummf", "眎"},
	{"bummi", "眃"},
	{"bummp", "矖"},
	{"bummu", "盶"},
	{"bummv", "䀼"},
	{"bumn", "盯"},
	{"bumob", "眪"},
	{"bumt", "䀘 䐩"},
	{"bumtb", "矋"},
	{"bumua", "䁮"},
	{"bumvm", "䀴"},
	{"bumvs", "䀎"},
	{"bumwf", "瞟"},
	{"bumwj", "瞫"},
	{"bumwv", "䁏"},
	{"bumym", "眐"},
	{"bun", "㐠"},
	{"bunau", "睌"},
	{"bunbe", "矎"},
	{"buncr", "瞻"},
	{"bund", "覎"},
	{"bundt", "䁅"},
	{"bunhb", "瞲"},
	{"bunhe", "𥄫"},
	{"bunin", "眵"},
	{"bunir", "眳"},
	{"bunkm", "䀽"},
	{"bunkq", "睷"},
	{"bunl", "䀕"},
	{"bunok", "睽"},
	{"bunot", "瞪"},
	{"bunri", "䂁"},
	{"bunsd", "睁"},
	{"bunwf", "䁩"},
	{"buog", "睢 瞿 膗"},
	{"buoge", "矍"},
	{"buogf", "瞧"},
	{"buohh", "眕"},
	{"buok", "䀢"},
	{"buoma", "瞺"},
	{"buomb", "睔"},
	{"buomg", "䀬"},
	{"buomm", "睑 䁯"},
	{"buomn", "睮"},
	{"buomo", "瞼"},
	{"buomr", "䀫"},
	{"buon", "盵"},
	{"buonk", "睺"},
	{"buoog", "睉"},
	{"buoq", "𢆡"},
	{"buotf", "瞴"},
	{"buowy", "䀲"},
	{"bup", "愳 㦝"},
	{"bupa", "眴"},
	{"buph", "䀣"},
	{"buphh", "䀛"},
	{"bupim", "盷"},
	{"bupp", "䀝"},
	{"bupr", "眗"},
	{"bupsh", "䀙"},
	{"buptd", "䁋"},
	{"bupu", "盹"},
	{"bupym", "鹞"},
	{"buqhl", "䀿 䁀"},
	{"buqj", "盽"},
	{"buqka", "睶"},
	{"buqmb", "睛"},
	{"buqmc", "瞔"},
	{"buqmv", "䁃"},
	{"buqou", "瞡"},
	{"burb", "睊"},
	{"burbc", "䁚"},
	{"burhu", "眖"},
	{"burmg", "睈"},
	{"burpa", "䁕"},
	{"burrd", "矂"},
	{"burse", "睱"},
	{"bursj", "䁒"},
	{"burvp", "眠"},
	{"bushb", "瞩"},
	{"bushi", "䀔"},
	{"bushr", "眧"},
	{"busj", "眲"},
	{"busk", "眍"},
	{"busmg", "眶 矅"},
	{"busp", "眤"},
	{"busrj", "䁹"},
	{"busrr", "瞘"},
	{"bustr", "䁥"},
	{"busuu", "𥇣"},
	{"busyi", "矚"},
	{"butak", "瞙"},
	{"butbc", "睓"},
	{"butbo", "矇"},
	{"butc", "䀧"},
	{"butco", "瞨"},
	{"butgs", "䂀"},
	{"butit", "䁳"},
	{"butk", "眹"},
	{"butkr", "睰"},
	{"butlb", "瞞"},
	{"butlk", "䁐"},
	{"butlo", "䁧"},
	{"butmb", "瞒"},
	{"butmj", "瞱"},
	{"butoe", "矆"},
	{"butpd", "瞸"},
	{"butq", "眻"},
	{"butqm", "䁟"},
	{"butrg", "矔"},
	{"butw", "瞄"},
	{"butwi", "䁾"},
	{"butwu", "矒"},
	{"butwv", "䁸"},
	{"butxc", "䁠"},
	{"buu", "朏 胐"},
	{"buuce", "䁓"},
	{"buumt", "䁗"},
	{"buvf", "県"},
	{"buvfb", "矊"},
	{"buvfi", "䂅"},
	{"buvid", "䁻"},
	{"buvis", "眑"},
	{"buvml", "鼎"},
	{"buvne", "睩"},
	{"buvvv", "䁽"},
	{"buwb", "䁌"},
	{"buwd", "睏"},
	{"buwfg", "䁼"},
	{"buwgf", "䁫"},
	{"buwla", "𥌓"},
	{"buwlc", "䁲"},
	{"buwlj", "䁺"},
	{"buwlv", "䁵"},
	{"buwml", "睤"},
	{"buyaj", "𥇍"},
	{"buybk", "瞮"},
	{"buybp", "矓"},
	{"buybu", "𥌑"},
	{"buycb", "䁤"},
	{"buydl", "䁨"},
	{"buyfd", "瞇"},
	{"buyhs", "眆"},
	{"buyhv", "褜"},
	{"buyj", "䀞"},
	{"buyk", "盿"},
	{"buymp", "眦"},
	{"buyoj", "睟"},
	{"buypm", "䁦"},
	{"buypt", "矑"},
	{"buyr", "䀡"},
	{"buyrf", "䁁"},
	{"buyrl", "瞓"},
	{"buyrn", "䁎"},
	{"buyso", "䁢"},
	{"buyt", "𥅈"},
	{"buytg", "瞳"},
	{"buytj", "瞕"},
	{"buyub", "瞝"},
	{"buyv", "盳"},
	{"buyvi", "眩"},
	{"buyvo", "䀭"},
	{"buyvu", "䀮"},
	{"buywm", "䁴"},
	{"bv", "妥"},
	{"bvg", "墾"},
	{"bvhaf", "鵎 鸚"},
	{"bvhl", "膷"},
	{"bvhvo", "㼏"},
	{"bvid", "䑈"},
	{"bvik", "奚"},
	{"bvne", "䐂"},
	{"bvnl", "郻"},
	{"bvno", "腞"},
	{"bvog", "䨉"},
	{"bvp", "懇"},
	{"bvpym", "鹦"},
	{"bvvv", "臘"},
	{"bvvw", "腦"},
	{"bwd", "腂 㬷"},
	{"bwg", "䤚"},
	{"bwgg", "𦢓"},
	{"bwhd", "䐃"},
	{"bwim", "膕"},
	{"bwk", "胭"},
	{"bwl", "胛"},
	{"bwlb", "腢"},
	{"bwlg", "𦣇"},
	{"bwli", "爵 臅"},
	{"bwlj", "䐾"},
	{"bwmi", "腘"},
	{"bwmv", "腲"},
	{"bwot", "膃"},
	{"bwp", "腮"},
	{"bwvf", "䐯"},
	{"bwyi", "胟"},
	{"bxff", "𦦨"},
	{"by", "丹 円 㓀"},
	{"byav", "腿"},
	{"bybb", "膼"},
	{"bybp", "朧 𠖥"},
	{"bybr", "膪"},
	{"bybs", "膀"},
	{"bycb", "䐱"},
	{"bycip", "㥖"},
	{"byck", "胶 㬵"},
	{"bydk", "㬿"},
	{"byhaf", "鴅"},
	{"byhhh", "彤"},
	{"byhj", "膖"},
	{"byhn", "肮"},
	{"byhr", "膇"},
	{"byhs", "肪"},
	{"byia", "膱"},
	{"byij", "膟"},
	{"byjj", "腁"},
	{"bykb", "膸"},
	{"bykl", "脐"},
	{"bykm", "䐮"},
	{"bylc", "䑊"},
	{"byln", "刐"},
	{"bymr", "䚻"},
	{"bymy", "胩"},
	{"bynl", "䢷"},
	{"bynv", "䑉"},
	{"byoj", "脺"},
	{"byok", "腋"},
	{"bypo", "臄"},
	{"bypt", "臚"},
	{"byr", "胋"},
	{"byrb", "䐧"},
	{"byrd", "朜"},
	{"byrn", "脝"},
	{"byrp", "㓃"},
	{"byrv", "䑋"},
	{"bys", "胪"},
	{"bysm", "写"},
	{"byt", "䏠"},
	{"byta", "腤"},
	{"bytg", "朣 膧"},
	{"bytmc", "䵊"},
	{"bytoe", "雘"},
	{"bytp", "臆"},
	{"bytr", "䏽"},
	{"byuk", "脑"},
	{"byvg", "臃"},
	{"byvi", "胘"},
	{"byvo", "胲"},
	{"bywm", "膻"},
	{"byx", "臍"},
	{"c", "金"},
	{"ca", "鈤"},
	{"caa", "錩"},
	{"cab", "𨧹"},
	{"cabt", "鎾"},
	{"cafu", "鎤"},
	{"cagu", "䥵"},
	{"cahhh", "㣒"},
	{"cahm", "鍟"},
	{"cahu", "鎇"},
	{"cam", "鉭"},
	{"camh", "鍚"},
	{"cami", "鍀"},
	{"camj", "銲"},
	{"camo", "鍉"},
	{"camvn", "甑"},
	{"can", "鍆"},
	{"cana", "鐧"},
	{"canau", "䒏"},
	{"canb", "鐗"},
	{"cand", "䥜"},
	{"canl", "鄫"},
	{"canr", "䥨"},
	{"cant", "鐦"},
	{"canw", "鑭"},
	{"caop", "𨫞"},
	{"caph", "錫"},
	{"caphh", "朆"},
	{"capp", "鋼"},
	{"capv", "鍻"},
	{"casm", "鎉"},
	{"casmm", "䎖"},
	{"cate", "鑤"},
	{"cau", "鈀"},
	{"cav", "銀"},
	{"cavf", "䥪"},
	{"cawe", "鏝"},
	{"cayf", "鐛"},
	{"cayt", "𨩄"},
	{"cb", "鈅 䏌"},
	{"cbb", "錋"},
	{"cbbe", "鑀"},
	{"cbbr", "鍋"},
	{"cbcd", "𨨥"},
	{"cbcn", "鍘"},
	{"cbcv", "𨰃"},
	{"cbdi", "鋝"},
	{"cbgr", "錭"},
	{"cbhn", "䤟"},
	{"cbhx", "䤾"},
	{"cbjj", "鍕"},
	{"cbm", "鉏"},
	{"cbme", "鍰"},
	{"cbmo", "䥂"},
	{"cbmr", "銅 𥖹"},
	{"cbms", "鋤"},
	{"cbnd", "鋢"},
	{"cbo", "钡"},
	{"cbon", "铡"},
	{"cbou", "鎐"},
	{"cbsd", "錚"},
	{"cbt", "銏"},
	{"cbtv", "龬"},
	{"cbu", "鉬"},
	{"cbuc", "鋇"},
	{"cbue", "钁"},
	{"cbug", "鑺"},
	{"cbul", "鐤"},
	{"cbuu", "鋧"},
	{"cbv", "鋖"},
	{"cbwi", "𨰜"},
	{"cc", "釟 鍂"},
	{"ccc", "鑫"},
	{"cccc", "𨰻"},
	{"cchaf", "𪄇"},
	{"cci", "鈆"},
	{"ccim", "鎓"},
	{"ccnh", "銻"},
	{"ccor", "鋊"},
	{"ccr", "鉛"},
	{"ccru", "銳"},
	{"ccsh", "鈖"},
	{"ccwa", "鏳"},
	{"cd", "鈢"},
	{"cdb", "𨦉"},
	{"cddo", "𨭣"},
	{"cddq", "鑻"},
	{"cdf", "錰"},
	{"cdg", "𨧀"},
	{"cdh", "釮"},
	{"cdhe", "鈹"},
	{"cdk", "鈌"},
	{"cdl", "鋉"},
	{"cdlo", "鏉"},
	{"cdm", "鉢"},
	{"cdmq", "鍏"},
	{"cdoo", "錸"},
	{"cdt", "铼"},
	{"cdw", "錬"},
	{"cdwf", "鍊"},
	{"ce", "淾"},
	{"cea", "錔"},
	{"ceah", "鐋"},
	{"cede", "𨨏"},
	{"cee", "𨥖"},
	{"ceed", "鎟"},
	{"ceee", "錣"},
	{"cefh", "䤬"},
	{"cegi", "鍅"},
	{"cehv", "鎃"},
	{"cei", "釵"},
	{"ceid", "𨫟"},
	{"cenh", "铴"},
	{"ceq", "铎"},
	{"cesd", "𨬡"},
	{"cetc", "𨩅"},
	{"cf", "釥 鈥"},
	{"cfb", "銷"},
	{"cfbb", "鏛"},
	{"cfbc", "鎖"},
	{"cfbd", "鏿"},
	{"cfbf", "钂"},
	{"cfbg", "鏜"},
	{"cfbk", "䥕"},
	{"cfbo", "锁"},
	{"cfbq", "鐣"},
	{"cfbr", "鋿"},
	{"cfbu", "鎲"},
	{"cfbw", "鐺"},
	{"cfd", "銤"},
	{"cfdq", "鏻"},
	{"cfdv", "镂"},
	{"cff", "錟"},
	{"cffd", "鑅"},
	{"cffg", "𨯗"},
	{"cffs", "鐒"},
	{"cfh", "鈔"},
	{"cfmu", "銧"},
	{"cfog", "𨫠"},
	{"cfq", "鉡"},
	{"cfqu", "錈"},
	{"cfsm", "铛"},
	{"cg", "釷"},
	{"cgb", "䤡"},
	{"cgbn", "𨧣"},
	{"cgce", "錂"},
	{"cgcg", "錴"},
	{"cgfo", "䥗"},
	{"cgg", "銈"},
	{"cggu", "鐃"},
	{"cgi", "鉣"},
	{"cgit", "鎑"},
	{"cglc", "䤲"},
	{"cgni", "鑄"},
	{"cgov", "𨬓"},
	{"cgp", "鋕"},
	{"cgr", "銡"},
	{"cgrf", "𨯨"},
	{"cgrr", "𨭎"},
	{"cgrv", "鎱"},
	{"cgsk", "𨫼"},
	{"cgth", "𨭌"},
	{"cgtj", "﨨"},
	{"cgwc", "鑟"},
	{"cha", "鉑 㒶"},
	{"chaa", "𨰝"},
	{"chab", "錦"},
	{"chae", "䤼"},
	{"chaf", "鵭"},
	{"chag", "鍠"},
	{"chbe", "鎫"},
	{"chbk", "鐭"},
	{"chbr", "銄"},
	{"chd", "鉌"},
	{"chdb", "鏼"},
	{"chdf", "鍬"},
	{"chdh", "銹"},
	{"chdl", "𨧺"},
	{"chdn", "鋓"},
	{"chdp", "鏭"},
	{"chdu", "鋵"},
	{"chdv", "錗"},
	{"chdw", "鐇"},
	{"che", "鈑"},
	{"chej", "鋒"},
	{"cher", "鉻"},
	{"chey", "鉖"},
	{"chfd", "䤣"},
	{"chg", "鈓"},
	{"chgf", "鑂"},
	{"chgi", "銩"},
	{"chgr", "鋯"},
	{"chgu", "銑"},
	{"chhaf", "鳻 鵜"},
	{"chhe", "鑗"},
	{"chhh", "釤"},
	{"chhj", "錍"},
	{"chhl", "鉚"},
	{"chhul", "䶏"},
	{"chhv", "䤨"},
	{"chhw", "鎦"},
	{"chixp", "麄"},
	{"chj", "釺"},
	{"chjd", "銖"},
	{"chje", "鍛"},
	{"chjg", "鍾"},
	{"chjm", "錘"},
	{"chjo", "锧"},
	{"chjr", "銛"},
	{"chju", "鍎"},
	{"chjx", "鍤"},
	{"chkb", "鐈"},
	{"chlc", "鑕"},
	{"chlmi", "蚠"},
	{"chln", "剃"},
	{"chlo", "釽 鍁"},
	{"chmbc", "頒"},
	{"chmbo", "颁"},
	{"chml", "釿"},
	{"chmr", "銗"},
	{"chn", "釠 𡯂"},
	{"chnb", "𨦨"},
	{"chnd", "鏫 䤪"},
	{"chne", "鈠"},
	{"chni", "釩 𩗩"},
	{"chnl", "邠"},
	{"chok", "攽 䥩"},
	{"chol", "䥏"},
	{"choo", "鏦"},
	{"chp", "𢚖"},
	{"chpa", "錉"},
	{"chpr", "銽"},
	{"chpym", "鹈"},
	{"chq", "鈝"},
	{"chqi", "鋨"},
	{"chqm", "鉎"},
	{"chqo", "鉄"},
	{"chrf", "鎢"},
	{"chs", "鈼"},
	{"chsk", "䥞"},
	{"chtl", "𨰉"},
	{"chtn", "䥷"},
	{"chu", "尣"},
	{"chua", "鑙 𨯩"},
	{"chuc", "鑽"},
	{"chud", "鎳"},
	{"chup", "鎴"},
	{"chvd", "铄"},
	{"chvl", "䤝"},
	{"chvo", "鈲"},
	{"chwp", "鎞 鏓"},
	{"chxc", "𨯵"},
	{"chxe", "鎪"},
	{"chxh", "銵"},
	{"ci", "公"},
	{"ciav", "鋃"},
	{"cibi", "鎛"},
	{"cice", "鋑"},
	{"cid", "枀"},
	{"cifm", "鎺"},
	{"cih", "龯"},
	{"cihaf", "䲲"},
	{"cihf", "鏚"},
	{"cihm", "銊"},
	{"cihq", "鉾"},
	{"cihr", "鍼"},
	{"cihs", "鋮"},
	{"cihu", "鈗"},
	{"cihv", "𨩆"},
	{"cii", "錢"},
	{"ciih", "鏒"},
	{"ciil", "鎯"},
	{"cij", "钱"},
	{"cijb", "鋪"},
	{"cijc", "鉥"},
	{"cije", "銶"},
	{"cijj", "龲"},
	{"cikk", "鈸"},
	{"ciku", "䤞"},
	{"cilb", "鏞"},
	{"cile", "鏮"},
	{"cill", "銂"},
	{"cilr", "鎕"},
	{"cimbc", "頌"},
	{"cimbo", "颂"},
	{"cimn", "瓮"},
	{"cimr", "𥗛"},
	{"cine", "銢 𨥭"},
	{"cing", "𨫆"},
	{"cip", "忩 釴"},
	{"cipf", "鑣"},
	{"cipm", "鉽"},
	{"cipp", "鋱 䥝"},
	{"ciq", "銭"},
	{"cir", "鈶"},
	{"cis", "鈩"},
	{"cisb", "鍽"},
	{"cisk", "錑"},
	{"cism", "翁 䥇"},
	{"citc", "鐮 鑛"},
	{"cite", "鍍"},
	{"citf", "鏣"},
	{"civ", "鉞"},
	{"cixe", "𨯙"},
	{"cixp", "鏕"},
	{"cixq", "𨭤"},
	{"cj", "針"},
	{"cjbc", "鎮"},
	{"cjbd", "鋍"},
	{"cjbf", "鎍 鑔"},
	{"cjbj", "𨩇"},
	{"cjcl", "镩"},
	{"cjcr", "鎔"},
	{"cjcv", "鑹"},
	{"cje", "鈘"},
	{"cjfe", "䤹"},
	{"cjhf", "䥱"},
	{"cjhp", "䤩"},
	{"cjig", "鐵 䥫"},
	{"cjii", "鏄"},
	{"cjip", "鏸"},
	{"cjit", "鐡"},
	{"cjjj", "𨪚"},
	{"cjjl", "鏩"},
	{"cjjm", "𨯪"},
	{"cjju", "錷"},
	{"cjka", "鍺"},
	{"cjkd", "﨧"},
	{"cjki", "鋐"},
	{"cjkp", "銠"},
	{"cjks", "銬"},
	{"cjmc", "鏔 鑌 𨰦 𨰰"},
	{"cjmf", "錝"},
	{"cjmm", "鍹"},
	{"cjmo", "錠 鎵"},
	{"cjmu", "鋎"},
	{"cjmw", "𨬬"},
	{"cjni", "䥉"},
	{"cjnl", "郸"},
	{"cjnu", "鋺"},
	{"cjoa", "鏥"},
	{"cjoc", "镔"},
	{"cjon", "䥑"},
	{"cjp", "鉈"},
	{"cjpn", "鑏"},
	{"cjpu", "铙"},
	{"cjqr", "鎋"},
	{"cjr", "鈷"},
	{"cjrb", "鍸"},
	{"cjrr", "錧"},
	{"cjru", "鋴"},
	{"cjstv", "冁"},
	{"cjtc", "鐼"},
	{"cjti", "鑧"},
	{"cjto", "鑳"},
	{"cjv", "銨"},
	{"ck", "父 釱"},
	{"ckau", "爸"},
	{"ckb", "銪"},
	{"ckbm", "㸖"},
	{"ckbmr", "㸗"},
	{"ckce", "鎩"},
	{"ckcf", "鐐"},
	{"ckd", "铩"},
	{"ckgg", "鍷"},
	{"ckhml", "斧"},
	{"cki", "鈜 鈦"},
	{"ckjka", "㸙"},
	{"ckjt", "錛"},
	{"ckkb", "䤭"},
	{"ckkk", "鏯"},
	{"cklb", "鈽"},
	{"ckld", "銌"},
	{"cklu", "䤶"},
	{"ckmb", "䤻"},
	{"ckmf", "錼"},
	{"ckmgc", "釜"},
	{"ckmr", "錡"},
	{"ckms", "銙"},
	{"ckn", "釚 銕"},
	{"ckni", "釻"},
	{"cknin", "爹"},
	{"ckoo", "鋏"},
	{"cks", "釛"},
	{"cksjl", "爺"},
	{"cksl", "爷"},
	{"cksr", "鉫"},
	{"ckt", "铗"},
	{"ckwln", "㸘"},
	{"cl", "丫 鈡"},
	{"clbk", "鉠"},
	{"clbu", "鈂"},
	{"cleg", "铿"},
	{"clk", "鉂"},
	{"cll", "鋛"},
	{"clld", "䥡"},
	{"clll", "釧"},
	{"clln", "鉘"},
	{"clmc", "鐀"},
	{"clmi", "鉵"},
	{"clmo", "銚"},
	{"clmp", "鉳"},
	{"clmy", "䤵"},
	{"cln", "釗"},
	{"clnc", "鐨"},
	{"clno", "镄"},
	{"clp", "𨨩"},
	{"clpb", "𨩈"},
	{"clq", "銉"},
	{"cls", "钔"},
	{"clsa", "锏"},
	{"clst", "锎"},
	{"clsw", "镧"},
	{"clw", "鈾"},
	{"clwl", "鉮"},
	{"clwv", "鏤"},
	{"clx", "鏽"},
	{"cm", "釭 䒑"},
	{"cma", "銆"},
	{"cmbb", "鑐"},
	{"cmbc", "顉 𨫋"},
	{"cmbe", "䥳"},
	{"cmbu", "䥤"},
	{"cmbv", "𨯂"},
	{"cmbw", "鐳"},
	{"cmd", "釪"},
	{"cme", "銾"},
	{"cmf", "鈈"},
	{"cmfb", "鑈"},
	{"cmfe", "鋄"},
	{"cmfj", "銔 𨥾"},
	{"cmfm", "鉟"},
	{"cmgg", "錱"},
	{"cmgi", "鈺"},
	{"cmgr", "鑩"},
	{"cmhaf", "鶲"},
	{"cmhf", "𨪛"},
	{"cmhl", "鋣"},
	{"cmhm", "䥶"},
	{"cmia", "𨫌"},
	{"cmig", "銍"},
	{"cmii", "𨫎"},
	{"cmj", "釬"},
	{"cmjj", "銒"},
	{"cmks", "勜"},
	{"cmlm", "錏"},
	{"cmlw", "鐂"},
	{"cmmp", "鐚 𨰣"},
	{"cmmr", "鋙"},
	{"cmms", "釫"},
	{"cmmu", "鈨"},
	{"cmmv", "鋠"},
	{"cmn", "釘"},
	{"cmnr", "鈳"},
	{"cmob", "鈵"},
	{"cmp", "憌"},
	{"cmpm", "錻"},
	{"cmpym", "鹟"},
	{"cmr", "鉐"},
	{"cmrb", "鎘"},
	{"cmrl", "䤺"},
	{"cmrr", "鎶"},
	{"cmrt", "鋀"},
	{"cmrw", "鍢"},
	{"cmso", "𨧧"},
	{"cmst", "㿽"},
	{"cmsu", "鈪"},
	{"cmt", "鈃"},
	{"cmta", "䥄"},
	{"cmtb", "𨯅"},
	{"cmtc", "铔"},
	{"cmth", "䤯"},
	{"cmtn", "鉶"},
	{"cmto", "鐝"},
	{"cmua", "鐕"},
	{"cmvb", "䥎"},
	{"cmvh", "釾"},
	{"cmvi", "鎒"},
	{"cmvm", "鋞"},
	{"cmvs", "兮"},
	{"cmwd", "䥔"},
	{"cmwf", "鏢"},
	{"cmwj", "鐔"},
	{"cmwl", "䥮"},
	{"cmwv", "𨪁"},
	{"cmym", "鉦"},
	{"cmys", "鈣"},
	{"cn", "釔"},
	{"cnao", "鐌"},
	{"cnau", "銫 鋔"},
	{"cnbk", "𨩉"},
	{"cnd", "釨"},
	{"cndt", "錳"},
	{"cnf", "鉨"},
	{"cng", "鈕"},
	{"cnhb", "鐍"},
	{"cnhd", "鍒"},
	{"cnhe", "鈒"},
	{"cnhs", "釢"},
	{"cnhx", "錎"},
	{"cni", "釸"},
	{"cnib", "銿"},
	{"cnih", "𨥨"},
	{"cnii", "鏹"},
	{"cnin", "鉹 𨥤"},
	{"cnir", "銘"},
	{"cniw", "䥁"},
	{"cnkg", "鋌"},
	{"cnkl", "𨧞"},
	{"cnkm", "鋋"},
	{"cnkq", "鍵"},
	{"cnl", "弚 鈏"},
	{"cnlh", "弟 鐊"},
	{"cnlo", "䥙"},
	{"cnlr", "錒"},
	{"cnme", "録"},
	{"cnmu", "䤥"},
	{"cnn", "釕"},
	{"cno", "欽"},
	{"cnoe", "鏺"},
	{"cnok", "鍨"},
	{"cnot", "鐙"},
	{"cnri", "鑱"},
	{"cnsh", "钖"},
	{"cnst", "𨩙"},
	{"cnwa", "鑥"},
	{"cnyi", "𨧻"},
	{"co", "釞"},
	{"coae", "鍑"},
	{"cob", "鈉"},
	{"cobg", "䥃"},
	{"cod", "銝"},
	{"codi", "鉜"},
	{"cof", "鉩"},
	{"cog", "錐"},
	{"cogd", "鏶"},
	{"cogf", "鐎"},
	{"cogj", "鎨"},
	{"cogs", "鎸 鐫"},
	{"cohg", "銋"},
	{"cohh", "鉁"},
	{"cohl", "𨦪"},
	{"coi", "䤦"},
	{"coii", "鈴"},
	{"coim", "鑯"},
	{"coin", "鈐"},
	{"coip", "錜"},
	{"coir", "鋡 鎗"},
	{"cok", "鉃"},
	{"colb", "鉓 鏅"},
	{"colh", "鎀"},
	{"colmi", "螸"},
	{"comb", "錀 鑰"},
	{"comc", "鋲"},
	{"comg", "銓"},
	{"coml", "𨨶"},
	{"comn", "鍮"},
	{"como", "鐱"},
	{"comq", "鎿"},
	{"comr", "鉿"},
	{"con", "釳"},
	{"cond", "鎎"},
	{"conk", "鍭"},
	{"conq", "𨫡"},
	{"cooa", "䥘"},
	{"coog", "銼"},
	{"cop", "慾"},
	{"copd", "鉇"},
	{"copj", "铧"},
	{"cor", "谷"},
	{"cord", "𨩚"},
	{"cowy", "鋂"},
	{"cp", "鈊"},
	{"cpa", "銁"},
	{"cpbc", "鎭"},
	{"cpd", "釶"},
	{"cph", "鉍"},
	{"cphp", "鍃"},
	{"cpi", "釣 鈎"},
	{"cpim", "鈞"},
	{"cpkp", "鍯"},
	{"cpou", "鋾"},
	{"cpp", "鈚"},
	{"cppa", "鍇"},
	{"cpr", "鉤"},
	{"cpru", "鉋"},
	{"cpt", "鉪"},
	{"cptd", "鍱"},
	{"cpu", "鈍"},
	{"cpvm", "钨"},
	{"cpyr", "鍧"},
	{"cqav", "䥟"},
	{"cqd", "銇"},
	{"cqgi", "𨨲"},
	{"cqhf", "䥛"},
	{"cqhk", "鍥"},
	{"cqhq", "䤿"},
	{"cqhu", "䥹"},
	{"cqjl", "𨧜"},
	{"cqjm", "鏏"},
	{"cqjp", "𨯚"},
	{"cqki", "鋳"},
	{"cqmb", "錆"},
	{"cqmc", "䥊"},
	{"cqmv", "錶"},
	{"cqo", "鈇"},
	{"cqoa", "鐟"},
	{"cqoc", "鑚"},
	{"cqu", "䤜"},
	{"cr", "釦 㕣"},
	{"crawe", "䜱"},
	{"crb", "鋗"},
	{"crbvk", "豀"},
	{"crc", "鉙"},
	{"crgwc", "豄"},
	{"crhaf", "鵒"},
	{"crhaj", "䜰"},
	{"crhg", "鋥"},
	{"crhr", "鋁"},
	{"crhu", "兌"},
	{"criku", "㞃"},
	{"crjcm", "谾"},
	{"crjhq", "䜮"},
	{"crki", "谹"},
	{"crkn", "䜪"},
	{"crks", "䤢"},
	{"crlb", "銱"},
	{"crlr", "鈻"},
	{"crlw", "䜬"},
	{"crm", "䜫"},
	{"crmjk", "豃"},
	{"crmr", "鏴"},
	{"crmvh", "谺"},
	{"crnl", "郤"},
	{"crno", "欲"},
	{"crnq", "谻"},
	{"crob", "锅"},
	{"croir", "谽"},
	{"crp", "总 懖 𢤹"},
	{"crpa", "鍲"},
	{"crpfd", "䜯"},
	{"crpym", "鹆"},
	{"crrd", "鐰"},
	{"crrj", "𨭐"},
	{"crrk", "𨰫"},
	{"crrs", "鍔"},
	{"crsj", "鍓"},
	{"crsl", "卻"},
	{"crsmh", "豂"},
	{"crtc", "谼"},
	{"cru", "釲"},
	{"cruc", "鐉"},
	{"crvk", "鋘"},
	{"crvp", "鈱"},
	{"crvvv", "䜲"},
	{"crybp", "豅"},
	{"crye", "鍜"},
	{"cryo", "鋜"},
	{"csav", "䤷"},
	{"csec", "鑦"},
	{"cseg", "鏗"},
	{"csh", "分 釖"},
	{"cshc", "貧"},
	{"cshf", "炃"},
	{"cshg", "坌"},
	{"cshi", "釰"},
	{"cshn", "瓫"},
	{"csho", "贫"},
	{"cshp", "忿"},
	{"cshr", "鉊"},
	{"csht", "弅 盆"},
	{"cshu", "岔"},
	{"csic", "𨯿"},
	{"csit", "鑑"},
	{"csiu", "鑬"},
	{"csj", "鉺"},
	{"csje", "鋷"},
	{"csjj", "鑷"},
	{"csjl", "鎁"},
	{"csjr", "鋸"},
	{"csju", "銸"},
	{"csk", "釼"},
	{"cskr", "𨧡"},
	{"csl", "兯"},
	{"cslb", "鉔"},
	{"cslc", "鑎"},
	{"csme", "鋟"},
	{"csmg", "鑃"},
	{"csmh", "鏐"},
	{"csmi", "鐞"},
	{"csmm", "𨦫"},
	{"csmr", "鉰"},
	{"csmv", "鋹"},
	{"csn", "㐥"},
	{"csnau", "䒊"},
	{"cso", "鈬"},
	{"csp", "鈮"},
	{"csqf", "鎷"},
	{"csr", "鉕"},
	{"csrj", "鐴"},
	{"csro", "䥲"},
	{"csrr", "鏂"},
	{"css", "鉅"},
	{"cssr", "鋦"},
	{"cstv", "𨫀"},
	{"csu", "𨥈"},
	{"cswc", "𨰹"},
	{"csyi", "钃"},
	{"csyq", "𨬯"},
	{"cta", "錯"},
	{"ctak", "鏌"},
	{"ctaw", "钄"},
	{"ctbc", "錪"},
	{"ctbk", "鏾"},
	{"ctbn", "鎆"},
	{"ctbs", "铹"},
	{"ctc", "鉷"},
	{"ctca", "鐠"},
	{"ctcd", "𨭥"},
	{"ctcg", "䥓"},
	{"ctch", "𨧼"},
	{"ctcl", "鐁"},
	{"ctco", "鏷"},
	{"ctct", "鎰"},
	{"ctcu", "𨬭"},
	{"ctcw", "𨩊"},
	{"ctei", "鑮"},
	{"ctgi", "鑆"},
	{"ctgk", "鎂"},
	{"ctgo", "𨬢"},
	{"ctgr", "鐥"},
	{"ctgt", "鑉"},
	{"ctgu", "錓"},
	{"ctii", "䥬"},
	{"ctir", "䥠"},
	{"ctis", "鑶"},
	{"ctit", "䥈"},
	{"ctja", "鐯"},
	{"ctk", "銰"},
	{"ctkr", "鍩"},
	{"ctlb", "鏋"},
	{"ctlf", "𨯧"},
	{"ctlk", "鍈"},
	{"ctlo", "𨫪"},
	{"ctm", "鉗"},
	{"ctmc", "錤 鐄"},
	{"ctmj", "鏵"},
	{"ctmv", "鍖"},
	{"ctob", "𨧨"},
	{"ctoe", "鑊"},
	{"ctop", "錵"},
	{"ctor", "鎝"},
	{"ctpd", "鐷"},
	{"ctpo", "𨪂"},
	{"ctqm", "鎈"},
	{"ctrg", "鑵"},
	{"ctrs", "𨯫"},
	{"ctsr", "鍣"},
	{"ctt", "鉼"},
	{"ctub", "鎙"},
	{"ctvi", "鎡"},
	{"ctw", "錨"},
	{"ctwa", "鏪"},
	{"ctwb", "𨭬"},
	{"ctwi", "鐏"},
	{"ctwk", "䥖"},
	{"ctxc", "鎌"},
	{"ctyj", "鑝"},
	{"ctys", "錺"},
	{"ctyv", "鋩"},
	{"cu", "釓 𨥉"},
	{"cuap", "𨬌"},
	{"cubb", "鏰"},
	{"cuce", "鍐"},
	{"cuhj", "鎽"},
	{"cuhl", "䤱"},
	{"cuhni", "䬇"},
	{"cuhqu", "毤"},
	{"culb", "銟"},
	{"cumb", "鍴"},
	{"cumbc", "䫄"},
	{"cumg", "尩"},
	{"cumj", "錌"},
	{"cumso", "䝇"},
	{"cumt", "鎧"},
	{"cune", "䤴"},
	{"cuob", "鑴"},
	{"cuog", "鏙"},
	{"cuok", "敓"},
	{"cuon", "䤫"},
	{"cuos", "䥴"},
	{"cupi", "尦"},
	{"cusu", "铠"},
	{"cutn", "𨬫"},
	{"cuu", "鈯"},
	{"cv", "釹"},
	{"cvfr", "鐑"},
	{"cvid", "鑠"},
	{"cvif", "銯"},
	{"cvii", "鐖"},
	{"cvio", "鉯"},
	{"cvl", "䤛"},
	{"cvmi", "鏘"},
	{"cvmw", "鍿"},
	{"cvne", "錄"},
	{"cvno", "䤸"},
	{"cvr", "銣"},
	{"cvvc", "鎻"},
	{"cvvd", "鏁"},
	{"cvvv", "鑞"},
	{"cvvw", "錙"},
	{"cw", "鈿"},
	{"cwa", "曾"},
	{"cwb", "𨩋"},
	{"cwd", "錁"},
	{"cwg", "鋰"},
	{"cwgf", "𨭆"},
	{"cwj", "单"},
	{"cwjc", "鏆"},
	{"cwjr", "錮"},
	{"cwk", "銦"},
	{"cwkp", "𨪜"},
	{"cwl", "鉀"},
	{"cwlb", "鍝"},
	{"cwlf", "䤽"},
	{"cwlg", "鑼"},
	{"cwli", "鐲"},
	{"cwlj", "鐸"},
	{"cwlm", "鎠"},
	{"cwln", "锣"},
	{"cwlp", "䥯"},
	{"cwlv", "鐶"},
	{"cwmr", "兽"},
	{"cwmv", "鍡"},
	{"cwol", "鎅"},
	{"cwp", "鍶"},
	{"cwr", "䤧"},
	{"cwrc", "𨭦"},
	{"cwtc", "兾"},
	{"cwtj", "鏎"},
	{"cwvf", "鏍"},
	{"cwwg", "鑸"},
	{"cwwv", "𨯬"},
	{"cwww", "鑘"},
	{"cwyi", "鉧"},
	{"cy", "釙"},
	{"cyaj", "鋽"},
	{"cybb", "鍗 鐹"},
	{"cybc", "鍞"},
	{"cybk", "钀"},
	{"cybp", "鑨"},
	{"cybs", "鎊"},
	{"cycb", "鏑 𨫢"},
	{"cyck", "鉸"},
	{"cydk", "鐓"},
	{"cye", "鈙"},
	{"cyed", "𨮏"},
	{"cyg", "鉒"},
	{"cygq", "鐽"},
	{"cyhc", "䥥"},
	{"cyhj", "鏠"},
	{"cyhm", "鏟"},
	{"cyhn", "鈧"},
	{"cyhr", "鎚"},
	{"cyhs", "鈁"},
	{"cyhu", "䥧"},
	{"cyhv", "銥"},
	{"cyib", "錥"},
	{"cyiu", "銃 鋶"},
	{"cyj", "鈄"},
	{"cyjj", "鏈"},
	{"cyk", "鈫"},
	{"cykb", "䥦"},
	{"cykq", "链"},
	{"cylb", "鈰"},
	{"cylh", "䤮"},
	{"cylm", "䤠"},
	{"cylr", "鑓"},
	{"cymb", "錹"},
	{"cymh", "鐬"},
	{"cymr", "𨦼"},
	{"cymu", "鑡"},
	{"cymy", "鉲"},
	{"cyoj", "錊"},
	{"cyok", "䤳"},
	{"cypd", "鏬"},
	{"cypo", "鐻"},
	{"cypp", "鑢"},
	{"cypq", "鎼"},
	{"cyps", "鐪"},
	{"cypt", "鑪"},
	{"cypu", "錿"},
	{"cyr", "鉆"},
	{"cyrb", "鎬"},
	{"cyrd", "錞"},
	{"cyrf", "鍄 䥋"},
	{"cyrn", "𨧤 𨪃"},
	{"cyro", "𨮙"},
	{"cyru", "𨦸"},
	{"cyrv", "鎄 鑲"},
	{"cysd", "鍦"},
	{"cysk", "鏃"},
	{"cyso", "鏇"},
	{"cyt", "鉝"},
	{"cytg", "鐘"},
	{"cyth", "铲"},
	{"cytj", "鋅 鏱"},
	{"cytk", "鎹"},
	{"cyto", "鐩"},
	{"cytp", "鐿"},
	{"cytr", "錇"},
	{"cytu", "鏡"},
	{"cyv", "釯"},
	{"cyvi", "鉉 䥰"},
	{"cyvo", "䤤"},
	{"cyvq", "鏲"},
	{"cywi", "鏀"},
	{"cyx", "鑇"},
	{"cyyb", "𨮹"},
	{"d", "木"},
	{"da", "杳"},
	{"daa", "椙"},
	{"daaa", "橸"},
	{"dabt", "榅"},
	{"dafu", "榥"},
	{"dagi", "榯"},
	{"dahl", "㭿"},
	{"dahu", "楣"},
	{"dail", "楖"},
	{"daiu", "概"},
	{"dam", "查 柦"},
	{"damh", "楊"},
	{"dami", "棏"},
	{"damj", "桿"},
	{"damo", "㮛"},
	{"dan", "椚"},
	{"dana", "橺"},
	{"danb", "橌"},
	{"dand", "㯗"},
	{"dang", "橍"},
	{"danr", "櫊 櫚"},
	{"danw", "欄"},
	{"danx", "櫩"},
	{"dapp", "棍"},
	{"dapv", "楬"},
	{"dase", "樶"},
	{"dasm", "榻"},
	{"dau", "杷"},
	{"daum", "櫭"},
	{"dav", "根"},
	{"dawe", "槾"},
	{"db", "朿"},
	{"dbac", "榠"},
	{"dbb", "棚"},
	{"dbbb", "榾"},
	{"dbbm", "栅"},
	{"dbbq", "橓"},
	{"dbbr", "楇"},
	{"dbbu", "㯒"},
	{"dbcd", "棎"},
	{"dbci", "㰄"},
	{"dbcv", "櫻"},
	{"dbd", "棌"},
	{"dbdb", "棗 棘"},
	{"dbdi", "㭩"},
	{"dbfs", "橳"},
	{"dbgr", "椆"},
	{"dbhu", "枧"},
	{"dbhx", "槄"},
	{"dbjj", "楎"},
	{"dbk", "㭎"},
	{"dbkf", "橪"},
	{"dbln", "刺"},
	{"dbm", "柤 査"},
	{"dbmc", "椇"},
	{"dbme", "楥"},
	{"dbmm", "枏 𣏵"},
	{"dbmp", "檼"},
	{"dbmr", "桐"},
	{"dbnd", "桴"},
	{"dbo", "僰"},
	{"dbok", "敇"},
	{"dbou", "榣"},
	{"dbov", "樱"},
	{"dbsd", "棦"},
	{"dbse", "棴"},
	{"dbt", "柵 㭗"},
	{"dbtk", "㮳"},
	{"dbtu", "棡"},
	{"dbtv", "棢"},
	{"dbu", "相"},
	{"dbuc", "梖"},
	{"dbue", "欔"},
	{"dbuf", "櫾"},
	{"dbug", "欋"},
	{"dbul", "檙"},
	{"dbuu", "梘"},
	{"dbv", "桵"},
	{"dbvk", "榽"},
	{"dby", "枣 枬"},
	{"dc", "朳"},
	{"dcav", "檭"},
	{"dchd", "椕"},
	{"dci", "松"},
	{"dcim", "㮬"},
	{"dcip", "棇"},
	{"dcms", "枍"},
	{"dcnh", "梯"},
	{"dcor", "㭲"},
	{"dcr", "柗"},
	{"dcrl", "㮝"},
	{"dcru", "梲"},
	{"dcsh", "枌"},
	{"dcwa", "橧"},
	{"dcwj", "椫"},
	{"dd", "林"},
	{"ddam", "楂"},
	{"ddb", "栜"},
	{"ddbai", "欎"},
	{"ddbhn", "棾"},
	{"ddbuh", "鬱"},
	{"ddc", "鐢"},
	{"ddcsh", "棼"},
	{"ddd", "森"},
	{"dddf", "㯲"},
	{"dddo", "檚"},
	{"ddec", "櫇"},
	{"ddf", "焚 㷊"},
	{"ddg", "埜"},
	{"ddh", "材"},
	{"ddhe", "柀"},
	{"ddhh", "彬"},
	{"ddhmu", "㯄"},
	{"ddhni", "梵 檒"},
	{"ddi", "村"},
	{"ddino", "椘"},
	{"ddixp", "麓"},
	{"ddj", "枺"},
	{"ddk", "樊 㭈"},
	{"ddkli", "蠜"},
	{"ddkmr", "礬"},
	{"ddkn", "㭝"},
	{"ddkq", "攀"},
	{"ddkyv", "䙪"},
	{"ddl", "梀"},
	{"ddlc", "櫴"},
	{"ddlk", "𣙙"},
	{"ddln", "楋"},
	{"ddlo", "樕"},
	{"ddmc", "䫐"},
	{"ddmf", "㮏"},
	{"ddmmf", "禁"},
	{"ddmmv", "辳"},
	{"ddmq", "椲"},
	{"ddmrt", "𧯴"},
	{"ddmwg", "𨤳"},
	{"ddmy", "梺"},
	{"ddni", "梦"},
	{"ddnkq", "㯬"},
	{"ddnl", "郴"},
	{"ddnyo", "楚"},
	{"ddoe", "㯃"},
	{"ddoin", "棽"},
	{"ddoo", "棶"},
	{"ddp", "懋 𢡟"},
	{"ddryo", "䠂"},
	{"ddsje", "樷"},
	{"ddt", "梾"},
	{"ddv", "婪"},
	{"ddvne", "㯟"},
	{"ddw", "棟 瑍"},
	{"ddwf", "楝"},
	{"ddwli", "欝"},
	{"ddye", "㪔"},
	{"ddyjj", "㰈"},
	{"de", "权"},
	{"dea", "㭼"},
	{"deau", "㿬"},
	{"deawe", "㿸"},
	{"debjj", "皹"},
	{"dedi", "树"},
	{"deed", "槡"},
	{"deee", "棳"},
	{"deem", "𣜖"},
	{"defh", "桫"},
	{"deg", "柽"},
	{"dei", "杈"},
	{"deid", "樑"},
	{"deii", "㮻"},
	{"dekni", "㿪"},
	{"deln", "㓟 㓼"},
	{"dembc", "頗"},
	{"dembk", "㿵"},
	{"dembo", "颇"},
	{"demj", "皯"},
	{"denl", "䣛"},
	{"depru", "皰 㯡"},
	{"desl", "厀"},
	{"deu", "㟚"},
	{"devvw", "㿳"},
	{"deygq", "㿹"},
	{"df", "杰 㭂 𣏹"},
	{"dfb", "梢"},
	{"dfbb", "𣙟"},
	{"dfbd", "橖"},
	{"dfbf", "欓"},
	{"dfbg", "樘"},
	{"dfbh", "橕"},
	{"dfbq", "𣛟"},
	{"dfbr", "㭻"},
	{"dfbw", "檔"},
	{"dfcq", "榉 﨔"},
	{"dfdq", "橉"},
	{"dfdv", "楼"},
	{"dff", "棪"},
	{"dffd", "𣞁 𣟕"},
	{"dffe", "㰔"},
	{"dffn", "橩"},
	{"dffr", "櫿"},
	{"dffs", "橯"},
	{"dfh", "杪"},
	{"dfhqu", "㲡"},
	{"dfhs", "㭞"},
	{"dfhu", "㮐"},
	{"dfle", "隸"},
	{"dfmbc", "䫴"},
	{"dfmu", "桄"},
	{"dfno", "歀 㱈"},
	{"dfq", "柈"},
	{"dfqs", "椦"},
	{"dfqu", "棬"},
	{"dfsm", "档"},
	{"dfv", "桜"},
	{"dg", "杜"},
	{"dgb", "柟"},
	{"dgbm", "㯛"},
	{"dgce", "棱"},
	{"dgcw", "樯"},
	{"dgdi", "㭙"},
	{"dgfo", "㯘"},
	{"dgg", "桂"},
	{"dggf", "㰊"},
	{"dggi", "槸"},
	{"dggu", "橈"},
	{"dgi", "㭕"},
	{"dgit", "榼"},
	{"dgji", "𣙀"},
	{"dgni", "檮"},
	{"dgor", "㯧"},
	{"dgov", "樾"},
	{"dgow", "檣"},
	{"dgp", "梽"},
	{"dgr", "桔"},
	{"dgrg", "檯"},
	{"dgrr", "橲"},
	{"dgrv", "榬"},
	{"dgti", "樹"},
	{"dgwc", "櫝"},
	{"dgwg", "榸"},
	{"dh", "才"},
	{"dha", "柏"},
	{"dhab", "棉"},
	{"dhae", "楾"},
	{"dhaf", "樢"},
	{"dhag", "楻"},
	{"dhaj", "槔 槹"},
	{"dhal", "櫛"},
	{"dhap", "梎"},
	{"dhau", "槝"},
	{"dhbd", "㰒"},
	{"dhbf", "㰃"},
	{"dhbt", "桖"},
	{"dhbul", "鼒"},
	{"dhcq", "櫸 欅"},
	{"dhd", "柇"},
	{"dhda", "楿"},
	{"dhdf", "楸"},
	{"dhdl", "棅"},
	{"dhdn", "梸"},
	{"dhdv", "㮃"},
	{"dhdw", "橎"},
	{"dhe", "板 皮"},
	{"dhec", "㯯"},
	{"dhej", "桻"},
	{"dheq", "栙"},
	{"dher", "格"},
	{"dhey", "柊"},
	{"dhfd", "㭔"},
	{"dhge", "檓"},
	{"dhgf", "櫄"},
	{"dhgr", "梏"},
	{"dhgu", "㭠"},
	{"dhhaf", "鸉"},
	{"dhhc", "橮"},
	{"dhhe", "㰀"},
	{"dhhh", "杉"},
	{"dhhi", "榭"},
	{"dhhj", "椑"},
	{"dhhl", "柳"},
	{"dhhv", "㭛"},
	{"dhhw", "榴"},
	{"dhi", "槐"},
	{"dhij", "櫆"},
	{"dhio", "柉"},
	{"dhj", "杄"},
	{"dhja", "櫡"},
	{"dhjd", "株"},
	{"dhje", "椴"},
	{"dhjg", "㮔"},
	{"dhjm", "棰"},
	{"dhjr", "栝"},
	{"dhju", "楯"},
	{"dhjx", "㮑"},
	{"dhk", "枖"},
	{"dhkb", "橋"},
	{"dhkl", "桥"},
	{"dhlb", "楀"},
	{"dhlc", "櫍"},
	{"dhlo", "枛 𣔙"},
	{"dhml", "析"},
	{"dhms", "栃"},
	{"dhmu", "栀 梔"},
	{"dhmy", "柝"},
	{"dhn", "机"},
	{"dhnb", "𣑲"},
	{"dhne", "杸"},
	{"dhni", "杋 楓"},
	{"dhnk", "枫"},
	{"dhon", "桁 椼"},
	{"dhoo", "樅 𣠺"},
	{"dhor", "㯚"},
	{"dhp", "杔"},
	{"dhpa", "棔 橁"},
	{"dhpm", "柢"},
	{"dhpr", "桰"},
	{"dhpu", "槪"},
	{"dhq", "㭌"},
	{"dhqm", "栍"},
	{"dhqo", "柣"},
	{"dhqu", "枆"},
	{"dhrf", "㮧"},
	{"dhrr", "桘"},
	{"dhs", "柞"},
	{"dhsb", "楄"},
	{"dhsk", "檄"},
	{"dhsu", "槴"},
	{"dht", "枡"},
	{"dhtc", "檱"},
	{"dhtn", "櫤"},
	{"dhuc", "欑"},
	{"dhuj", "橰"},
	{"dhup", "㮩"},
	{"dhus", "櫋"},
	{"dhuu", "橇"},
	{"dhvd", "栎"},
	{"dhvl", "枊"},
	{"dhvo", "柧"},
	{"dhwk", "㭡"},
	{"dhwp", "樬 㮰"},
	{"dhx", "桕"},
	{"dhxe", "㮴"},
	{"dhxo", "楰"},
	{"dhxu", "棿"},
	{"dhyb", "㰏"},
	{"dhye", "㮽"},
	{"dhyg", "樦"},
	{"dhyu", "榹"},
	{"di", "寸 㝳 𣏾"},
	{"diav", "桹"},
	{"dibi", "榑"},
	{"dice", "梭"},
	{"didr", "𣟖"},
	{"difl", "榊"},
	{"dig", "桩"},
	{"digi", "櫥"},
	{"dihf", "槭"},
	{"dihi", "㭽"},
	{"dihj", "㯅"},
	{"diho", "㰗"},
	{"dihq", "桙"},
	{"dihr", "椷"},
	{"dihu", "㭇"},
	{"dihv", "楲"},
	{"dii", "棧"},
	{"diib", "樃"},
	{"diih", "槮"},
	{"diil", "榔"},
	{"dij", "栈 㭜"},
	{"dijb", "㭪"},
	{"dije", "梂"},
	{"dik", "枤"},
	{"dikh", "椮"},
	{"dikj", "桳"},
	{"dikk", "柭"},
	{"dikp", "栊"},
	{"diku", "𣏞"},
	{"dikw", "㮥"},
	{"dilb", "槦"},
	{"dile", "槺"},
	{"dill", "栦"},
	{"diln", "刌"},
	{"dilo", "椩"},
	{"dilr", "榶"},
	{"dime", "栤"},
	{"dimo", "栨"},
	{"dine", "栐 櫠"},
	{"ding", "榳"},
	{"diod", "檪"},
	{"dioi", "椨"},
	{"dior", "㮞"},
	{"dip", "杙"},
	{"dipc", "樲"},
	{"dipm", "栻"},
	{"diq", "桟"},
	{"dir", "枱"},
	{"dirm", "棫"},
	{"dis", "枦"},
	{"dism", "㮼"},
	{"diss", "椖"},
	{"dist", "𣛮"},
	{"dit", "械 㭓"},
	{"ditc", "櫎"},
	{"ditf", "樜"},
	{"diua", "㮷"},
	{"diva", "槠"},
	{"dixe", "櫦"},
	{"dixp", "樚"},
	{"dj", "末"},
	{"djac", "㯽"},
	{"djb", "杮"},
	{"djbc", "槙"},
	{"djbd", "桲"},
	{"djbf", "檫 㮦"},
	{"djbj", "楠"},
	{"djbm", "植 椬"},
	{"djbv", "欜"},
	{"djc", "柼"},
	{"djcm", "椌"},
	{"djcr", "榕"},
	{"djcs", "榨"},
	{"djd", "㭑"},
	{"dje", "枝"},
	{"djhp", "㭦"},
	{"djhr", "楁"},
	{"djhw", "㰂"},
	{"djii", "槫"},
	{"djim", "㰇"},
	{"djip", "橞"},
	{"djji", "橶"},
	{"djjj", "檊"},
	{"djk", "杖"},
	{"djka", "楮"},
	{"djkd", "㭳"},
	{"djkp", "栳"},
	{"djkr", "槣"},
	{"djks", "栲"},
	{"djlv", "棲"},
	{"djmc", "檳"},
	{"djmf", "棕"},
	{"djmg", "榁"},
	{"djmm", "楦"},
	{"djmn", "柠"},
	{"djmo", "椗 榢"},
	{"djmu", "梡"},
	{"djnk", "椟"},
	{"djnu", "椀"},
	{"djoa", "樎"},
	{"djoc", "槟"},
	{"djp", "柁"},
	{"djpa", "榰"},
	{"djpb", "橣"},
	{"djpi", "櫁"},
	{"djpn", "檸"},
	{"djpu", "樒"},
	{"djqp", "櫶"},
	{"djqr", "㮫"},
	{"djr", "枯"},
	{"djrb", "楜"},
	{"djrj", "橭"},
	{"djrp", "唜"},
	{"djrr", "棺"},
	{"djt", "枿"},
	{"djtc", "橨"},
	{"djti", "𣟂"},
	{"djv", "桉"},
	{"djwp", "㯖"},
	{"djyj", "榟"},
	{"dk", "夬 杕"},
	{"dkb", "栯"},
	{"dkbl", "㮋"},
	{"dkce", "樧"},
	{"dkcf", "橑"},
	{"dkd", "栋"},
	{"dkde", "榝"},
	{"dkg", "㙬"},
	{"dkgg", "楏"},
	{"dkhaf", "鴂 鷘"},
	{"dkhf", "梑"},
	{"dkkb", "桸 㮁"},
	{"dkkd", "棥"},
	{"dkkk", "樉"},
	{"dklb", "柨"},
	{"dkld", "栫"},
	{"dkln", "刔"},
	{"dklu", "㭺"},
	{"dkmb", "楕"},
	{"dkmbc", "䫶"},
	{"dkmf", "㮈"},
	{"dkmr", "椅"},
	{"dkms", "桍"},
	{"dkmym", "整"},
	{"dkn", "朹 桋"},
	{"dknj", "枠"},
	{"dkok", "槉"},
	{"dkoo", "梜"},
	{"dkp", "憖 憗"},
	{"dkpb", "㯂"},
	{"dkrb", "槗"},
	{"dkrd", "𣕧"},
	{"dks", "朸"},
	{"dkso", "槬"},
	{"dksr", "枷 檶"},
	{"dkss", "栛"},
	{"dl", "束"},
	{"dla", "晳"},
	{"dlbk", "柍"},
	{"dlbu", "枕"},
	{"dld", "梊 椞"},
	{"dle", "棣"},
	{"dleg", "㭴"},
	{"dlhaf", "鵣"},
	{"dlii", "螙"},
	{"dlit", "槛"},
	{"dliu", "榄"},
	{"dlje", "㩽"},
	{"dlks", "勅"},
	{"dlksf", "鶒"},
	{"dll", "梙"},
	{"dlll", "杊 㭊"},
	{"dllmi", "蜤"},
	{"dlln", "剌 柫"},
	{"dllp", "槵"},
	{"dlmbc", "頼"},
	{"dlmc", "樻"},
	{"dlmo", "桃 𣑯"},
	{"dlmt", "㯸"},
	{"dlmy", "棑"},
	{"dlnbo", "赖"},
	{"dlno", "欶"},
	{"dlok", "敕"},
	{"dlp", "惁"},
	{"dlpn", "橷"},
	{"dlr", "𠵍"},
	{"dlshc", "賴"},
	{"dlsr", "榈 㭣"},
	{"dlvk", "櫢"},
	{"dlw", "柚"},
	{"dlwl", "柛"},
	{"dlwp", "栧"},
	{"dlws", "梬"},
	{"dlwv", "樓"},
	{"dlx", "橚"},
	{"dlxh", "柹"},
	{"dlxl", "棩"},
	{"dlyg", "㯇"},
	{"dlytj", "辢"},
	{"dm", "本 杠 杢"},
	{"dma", "栢"},
	{"dmam", "桓"},
	{"dmbb", "檽"},
	{"dmbc", "槓"},
	{"dmbe", "櫌"},
	{"dmbg", "㰌"},
	{"dmbi", "橒 㯪"},
	{"dmbk", "㮕"},
	{"dmbl", "栭"},
	{"dmbm", "欞"},
	{"dmbr", "櫺"},
	{"dmbs", "樗"},
	{"dmbw", "檑"},
	{"dmcw", "栖 梄"},
	{"dmd", "杅"},
	{"dmdhe", "皶"},
	{"dmdm", "櫪"},
	{"dmem", "極"},
	{"dmf", "杯"},
	{"dmfb", "檷"},
	{"dmfi", "㯹"},
	{"dmfj", "枰"},
	{"dmfm", "柸"},
	{"dmfn", "檦"},
	{"dmfr", "桮"},
	{"dmft", "㮎"},
	{"dmg", "枉"},
	{"dmgd", "㰉"},
	{"dmgi", "櫉"},
	{"dmgk", "㮹"},
	{"dmgn", "椡"},
	{"dmgr", "櫮"},
	{"dmgt", "梇"},
	{"dmhf", "榞"},
	{"dmhl", "㭨"},
	{"dmia", "榗"},
	{"dmig", "桎"},
	{"dmj", "杆"},
	{"dmjk", "橄"},
	{"dmkp", "㮇"},
	{"dmks", "枥"},
	{"dmlk", "梗"},
	{"dmlm", "椏"},
	{"dmls", "桺"},
	{"dmlw", "橊"},
	{"dmme", "柡"},
	{"dmmf", "柰 标"},
	{"dmmi", "枟 橱"},
	{"dmmm", "㭅"},
	{"dmmp", "欐"},
	{"dmmr", "梧"},
	{"dmms", "杇 㮄"},
	{"dmmu", "杬"},
	{"dmmv", "桭"},
	{"dmn", "朾"},
	{"dmnd", "㮪"},
	{"dmnl", "桏"},
	{"dmnn", "栵"},
	{"dmnr", "柯"},
	{"dmob", "柄"},
	{"dmr", "柘"},
	{"dmrb", "槅"},
	{"dmrd", "㮟"},
	{"dmrq", "韋"},
	{"dmrr", "㰁"},
	{"dmrrr", "㮺"},
	{"dmrt", "梪"},
	{"dmrw", "楅"},
	{"dms", "杤"},
	{"dmsmm", "翉"},
	{"dmso", "椓 㭬"},
	{"dmsu", "枙"},
	{"dmt", "枅"},
	{"dmtb", "櫔"},
	{"dmtc", "桠"},
	{"dmti", "𣗳"},
	{"dmtn", "㭢"},
	{"dmto", "橛"},
	{"dmu", "杌"},
	{"dmua", "橬"},
	{"dmue", "榎"},
	{"dmvh", "枒"},
	{"dmvi", "槈"},
	{"dmvm", "枑 桱"},
	{"dmvs", "朽"},
	{"dmvvq", "舝"},
	{"dmwc", "檟"},
	{"dmwd", "㯨"},
	{"dmwf", "槱 標"},
	{"dmwg", "㮒"},
	{"dmwj", "橝"},
	{"dmwl", "㮌"},
	{"dmwm", "橿"},
	{"dmwo", "槚"},
	{"dmwv", "楆"},
	{"dmyf", "㯊"},
	{"dmym", "柾"},
	{"dn", "杛"},
	{"dnai", "㭸"},
	{"dnao", "橡"},
	{"dnau", "栬"},
	{"dnbg", "桷"},
	{"dnbj", "槲"},
	{"dnbo", "㭥"},
	{"dnbq", "檞"},
	{"dncr", "檐"},
	{"dnd", "杍 李"},
	{"dndf", "槂"},
	{"dndu", "𣏺"},
	{"dnfd", "櫯"},
	{"dng", "杻"},
	{"dngd", "𣕑"},
	{"dngg", "橻"},
	{"dnhb", "橘"},
	{"dnhd", "楙 楺"},
	{"dnhe", "极"},
	{"dnhk", "㮘"},
	{"dnhs", "㭁"},
	{"dnib", "桶"},
	{"dnih", "柕"},
	{"dnii", "𣚦"},
	{"dnil", "栁 桞"},
	{"dnin", "杼 栘"},
	{"dniq", "桝"},
	{"dniw", "㮭"},
	{"dnj", "㭄"},
	{"dnkg", "梃"},
	{"dnkm", "梴"},
	{"dnkq", "楗"},
	{"dnl", "䢶"},
	{"dnlb", "橢 㰐"},
	{"dnlr", "㯁"},
	{"dnlw", "樄"},
	{"dnmm", "榒"},
	{"dnmu", "桅"},
	{"dnnd", "㮊"},
	{"dnno", "櫲"},
	{"dnnwf", "䱫"},
	{"dno", "杴"},
	{"dnob", "楈"},
	{"dnoe", "橃"},
	{"dnok", "楑"},
	{"dnon", "櫈"},
	{"dnoo", "榌"},
	{"dnot", "橙"},
	{"dnq", "揧"},
	{"dnqd", "榤"},
	{"dnri", "欃"},
	{"dnsd", "桗"},
	{"dnsh", "杨"},
	{"dnst", "楹"},
	{"dnsv", "㯑"},
	{"dnue", "㮀"},
	{"dnvm", "杩"},
	{"dnwa", "櫓"},
	{"dnxu", "櫷"},
	{"dnyi", "㭹"},
	{"do", "朲"},
	{"doae", "椱"},
	{"doau", "𠌊"},
	{"dob", "枘"},
	{"dobg", "榷"},
	{"dobuc", "賚"},
	{"dobuu", "䚅"},
	{"doby", "栴"},
	{"dodi", "柎"},
	{"dodoo", "㯤"},
	{"doe", "桼"},
	{"dog", "椎 㮅"},
	{"doge", "欆"},
	{"dogf", "樵"},
	{"dogj", "榫"},
	{"dogs", "檇"},
	{"dohaf", "鶆"},
	{"dohg", "栣"},
	{"dohv", "㭚"},
	{"doi", "栰"},
	{"doii", "柃"},
	{"doik", "栿 猌"},
	{"doim", "櫼"},
	{"doin", "枔"},
	{"doip", "棯 㭖"},
	{"doir", "梒 槍"},
	{"doj", "杵"},
	{"dok", "枚"},
	{"dokg", "権"},
	{"dokr", "椥"},
	{"doks", "勑"},
	{"doksf", "䳵"},
	{"dokt", "㮉"},
	{"dolb", "樇"},
	{"dold", "樤"},
	{"dolh", "𣘀"},
	{"doln", "梻"},
	{"doma", "檜"},
	{"domb", "棆"},
	{"dombc", "顂"},
	{"domc", "梹"},
	{"domd", "梌"},
	{"domg", "栓"},
	{"domi", "桧"},
	{"domk", "楩"},
	{"doml", "椧"},
	{"domm", "检 𣏴"},
	{"domn", "榆"},
	{"domo", "檢"},
	{"domr", "㭘"},
	{"domv", "楡"},
	{"don", "杚"},
	{"donk", "㮢"},
	{"donl", "郲"},
	{"doo", "來"},
	{"doog", "桽 㭫"},
	{"dop", "杹"},
	{"dopd", "柂"},
	{"dopj", "桦"},
	{"dord", "椺"},
	{"dorm", "㯓"},
	{"dosu", "枪"},
	{"dotc", "𣗍"},
	{"dotf", "橅"},
	{"doto", "㯷"},
	{"dotq", "㮆"},
	{"dowy", "梅"},
	{"doyb", "檎"},
	{"dp", "朼 杺"},
	{"dpa", "栒 栺"},
	{"dpbc", "槇"},
	{"dpcc", "㰜"},
	{"dpd", "杝"},
	{"dpfd", "椈"},
	{"dph", "柲"},
	{"dpht", "榓"},
	{"dpi", "杓 构"},
	{"dpim", "枃"},
	{"dpkp", "楤"},
	{"dpmm", "㮓"},
	{"dpo", "枨"},
	{"dpp", "枇"},
	{"dppa", "楷"},
	{"dppd", "㰑"},
	{"dppg", "梐"},
	{"dpr", "枸"},
	{"dpru", "枹"},
	{"dpt", "枻"},
	{"dptd", "楪"},
	{"dpu", "杶"},
	{"dpuu", "㮲"},
	{"dpw", "㭵"},
	{"dpym", "㭤"},
	{"dq", "杽"},
	{"dqamo", "䪘"},
	{"dqasm", "䪚"},
	{"dqbhx", "韜"},
	{"dqbjj", "韗"},
	{"dqdj", "韎"},
	{"dqfb", "韒"},
	{"dqgwc", "韥"},
	{"dqhaj", "韟"},
	{"dqhdw", "䪛"},
	{"dqhk", "楔"},
	{"dqhq", "㮮"},
	{"dqibi", "䪙"},
	{"dqijb", "䪔"},
	{"dqikk", "韍"},
	{"dqj", "㭋"},
	{"dqjip", "韢"},
	{"dqjl", "梆"},
	{"dqjm", "槥"},
	{"dqjp", "櫘 䪑"},
	{"dqka", "椿"},
	{"dqkd", "榛"},
	{"dqki", "梼"},
	{"dqkk", "楱"},
	{"dqkq", "棒"},
	{"dqkx", "樁"},
	{"dqll", "枾"},
	{"dqmb", "棈"},
	{"dqmc", "樍"},
	{"dqmf", "榡"},
	{"dqncr", "䪜"},
	{"dqnhd", "韖"},
	{"dqnl", "郼"},
	{"dqo", "枎"},
	{"dqoae", "䪖"},
	{"dqob", "䪏"},
	{"dqoc", "櫕"},
	{"dqomr", "韐"},
	{"dqou", "槻"},
	{"dqpfd", "䪕"},
	{"dqph", "䪐"},
	{"dqptd", "韘"},
	{"dqrse", "䪗"},
	{"dqs", "㭏"},
	{"dqshi", "韌"},
	{"dqsmv", "韔"},
	{"dqthb", "韛"},
	{"dqtlj", "韚"},
	{"dqtmj", "韡"},
	{"dqtoe", "䪝"},
	{"dqttb", "韝"},
	{"dqtwi", "韤"},
	{"dqwli", "韣"},
	{"dqwot", "韞"},
	{"dqwtj", "韠"},
	{"dqyg", "䪒"},
	{"dqyr", "䪓"},
	{"dqyrd", "韕"},
	{"dr", "杏"},
	{"drb", "梋"},
	{"drc", "枳"},
	{"drhg", "桯"},
	{"drhr", "梠"},
	{"drhs", "柺"},
	{"drhu", "柷"},
	{"drji", "檝"},
	{"drlb", "𣑐"},
	{"drlr", "㭒"},
	{"drmr", "㯝"},
	{"drms", "枵"},
	{"drrd", "橾"},
	{"drrj", "樿"},
	{"drrk", "欕"},
	{"drrr", "榀"},
	{"drrs", "㮙"},
	{"drsh", "枴"},
	{"drsj", "楫"},
	{"drsn", "㭭"},
	{"dru", "𣏌"},
	{"druc", "㯢"},
	{"drye", "椵"},
	{"dsav", "椻"},
	{"dseg", "樫"},
	{"dsfb", "榍"},
	{"dsg", "堏"},
	{"dsh", "朷"},
	{"dshi", "杒"},
	{"dshr", "柖"},
	{"dshu", "梶"},
	{"dsic", "㰓"},
	{"dsip", "梕"},
	{"dsit", "檻"},
	{"dsiu", "㰖"},
	{"dsj", "栮"},
	{"dsje", "棷"},
	{"dsjj", "欇"},
	{"dsjl", "椰"},
	{"dsjr", "椐"},
	{"dsju", "㭯"},
	{"dsk", "枢"},
	{"dskr", "桾"},
	{"dslc", "櫃"},
	{"dsll", "栕"},
	{"dsly", "榧"},
	{"dsma", "槢"},
	{"dsme", "梫"},
	{"dsmf", "棂"},
	{"dsmg", "框 楃 櫂"},
	{"dsmh", "樛"},
	{"dsmi", "樳"},
	{"dsmj", "𣝦"},
	{"dsmm", "栩"},
	{"dsmr", "柌"},
	{"dsms", "榋"},
	{"dsmv", "棖"},
	{"dsnd", "樼"},
	{"dsno", "柩"},
	{"dsp", "柅"},
	{"dsqf", "榪"},
	{"dsql", "梛"},
	{"dsrg", "檉"},
	{"dsrj", "檘"},
	{"dsrr", "樞"},
	{"dss", "柜"},
	{"dssr", "梮"},
	{"dstr", "𣘗"},
	{"dstt", "𣖕"},
	{"dstv", "榐"},
	{"dsu", "杞"},
	{"dsuf", "𣜠"},
	{"dsup", "梞"},
	{"dsuu", "㭾"},
	{"dsvg", "㮜"},
	{"dswl", "㭱"},
	{"dswu", "欖"},
	{"dsyi", "欘"},
	{"dsyq", "樨"},
	{"dt", "来"},
	{"dta", "棤"},
	{"dtab", "橗"},
	{"dtak", "模"},
	{"dtaw", "欗"},
	{"dtbc", "椣"},
	{"dtbd", "㮠"},
	{"dtbf", "櫒 𣜭"},
	{"dtbk", "橵"},
	{"dtbn", "椾"},
	{"dtbo", "檬"},
	{"dtc", "栱"},
	{"dtcd", "檏 㯣 㯦"},
	{"dtce", "欉"},
	{"dtcf", "櫀"},
	{"dtcg", "樭"},
	{"dtcj", "檋"},
	{"dtcl", "㯕"},
	{"dtco", "樸"},
	{"dtct", "榏"},
	{"dtcw", "楢"},
	{"dtei", "欂"},
	{"dtge", "樣"},
	{"dtgf", "榚"},
	{"dtgi", "檥"},
	{"dtgk", "𣖙"},
	{"dtgo", "檨"},
	{"dtgr", "橏"},
	{"dtgs", "㰕"},
	{"dtgt", "㯼"},
	{"dtgu", "欟"},
	{"dthg", "㯵"},
	{"dthj", "樥"},
	{"dthu", "㮱"},
	{"dtif", "𣞢"},
	{"dtih", "𣕚"},
	{"dtio", "𣔰"},
	{"dtis", "欌"},
	{"dtit", "𣙷"},
	{"dtjm", "𣜯"},
	{"dtjr", "楛 㯴"},
	{"dtk", "栚"},
	{"dtkr", "楉"},
	{"dtlb", "樠"},
	{"dtlc", "横"},
	{"dtlj", "㮖"},
	{"dtlk", "楧"},
	{"dtlm", "槿"},
	{"dtlx", "櫹"},
	{"dtm", "柑"},
	{"dtmc", "棋 橫"},
	{"dtmd", "楳"},
	{"dtmj", "樺"},
	{"dtmm", "栏"},
	{"dtmv", "椹"},
	{"dtoe", "檴"},
	{"dtof", "櫵"},
	{"dtog", "㰙 𣗎"},
	{"dtoi", "﨓"},
	{"dtop", "椛"},
	{"dtor", "榙"},
	{"dtov", "𣞼"},
	{"dtox", "欍"},
	{"dtpa", "槆"},
	{"dtpd", "𣚭 𣜿"},
	{"dtpp", "檧"},
	{"dtq", "样"},
	{"dtqm", "槎"},
	{"dtrg", "權"},
	{"dtrk", "㯳"},
	{"dtsj", "榵"},
	{"dtsl", "栉"},
	{"dtsr", "櫙"},
	{"dtt", "栟"},
	{"dttb", "構"},
	{"dttc", "椪"},
	{"dtub", "㮶"},
	{"dtvd", "欁 㰛"},
	{"dtwa", "槽"},
	{"dtwf", "𣜃"},
	{"dtwi", "樽"},
	{"dtwk", "橂"},
	{"dtwv", "檂"},
	{"dtxc", "槏"},
	{"dtyj", "㯜"},
	{"dtys", "㭶"},
	{"du", "札"},
	{"duce", "椶 㯶"},
	{"duch", "梤"},
	{"duhj", "𣗏"},
	{"dulmi", "蚻"},
	{"dumb", "椯"},
	{"dumt", "榿"},
	{"duob", "欈"},
	{"duog", "槯"},
	{"duon", "梣"},
	{"duos", "㰎"},
	{"dup", "想"},
	{"dusu", "桤"},
	{"duu", "柮"},
	{"duvif", "紮"},
	{"dvfb", "檰 㯞"},
	{"dvfo", "櫞"},
	{"dvi", "㭃"},
	{"dvid", "櫟"},
	{"dvii", "機"},
	{"dvis", "柪"},
	{"dvl", "朻"},
	{"dvmg", "梉"},
	{"dvmi", "㯍"},
	{"dvmo", "橼"},
	{"dvmt", "㰘 𣟗"},
	{"dvne", "椂"},
	{"dvno", "椽"},
	{"dvoi", "欚"},
	{"dvvd", "樔"},
	{"dvvi", "檵"},
	{"dvvn", "桚 㭮"},
	{"dvvv", "㯿"},
	{"dvvw", "椔"},
	{"dw", "東"},
	{"dwb", "𣖜"},
	{"dwc", "柶"},
	{"dwce", "㮨"},
	{"dwd", "梱 棵"},
	{"dwdw", "㯥"},
	{"dwf", "柬"},
	{"dwg", "梩"},
	{"dwhaf", "鶇 鶫"},
	{"dwhd", "棞"},
	{"dwhui", "䰤"},
	{"dwhvo", "㼑"},
	{"dwim", "槶"},
	{"dwjc", "樌"},
	{"dwji", "檲"},
	{"dwjr", "棝"},
	{"dwk", "栶"},
	{"dwks", "㭷"},
	{"dwl", "柙"},
	{"dwlg", "欏"},
	{"dwli", "㯮"},
	{"dwlj", "檡"},
	{"dwln", "椤"},
	{"dwls", "楞"},
	{"dwlv", "檈 㯰"},
	{"dwly", "檌"},
	{"dwmi", "椢"},
	{"dwmo", "㮯"},
	{"dwmv", "椳"},
	{"dwmvn", "㼯"},
	{"dwol", "楐"},
	{"dwot", "榲"},
	{"dwp", "楒"},
	{"dwtj", "㮿"},
	{"dwvf", "樏"},
	{"dww", "榃"},
	{"dwwf", "欙"},
	{"dwww", "櫑"},
	{"dwye", "㪝"},
	{"dwyi", "栂"},
	{"dy", "朴"},
	{"dyad", "槕"},
	{"dyaj", "棹"},
	{"dybb", "楴 檛"},
	{"dybc", "楨"},
	{"dybg", "㰚"},
	{"dybk", "㯙"},
	{"dybo", "桢"},
	{"dybp", "櫳"},
	{"dybs", "榜"},
	{"dycb", "樀"},
	{"dyck", "校"},
	{"dydk", "橔"},
	{"dydl", "槨 㯈"},
	{"dydu", "櫬"},
	{"dyfe", "椒"},
	{"dyg", "柱"},
	{"dygq", "橽"},
	{"dyhc", "㰋"},
	{"dyhh", "楌"},
	{"dyhj", "槰"},
	{"dyhn", "杭"},
	{"dyhr", "槌"},
	{"dyhs", "枋"},
	{"dyhv", "𣐿"},
	{"dyia", "樴"},
	{"dyib", "棛"},
	{"dyij", "𣘚"},
	{"dyiu", "梳"},
	{"dyj", "枓"},
	{"dyjj", "槤"},
	{"dyk", "𣐀"},
	{"dykm", "㯆"},
	{"dykq", "梿"},
	{"dylb", "柿"},
	{"dylm", "杫"},
	{"dymh", "檅"},
	{"dymo", "㯌"},
	{"dymu", "櫏"},
	{"dymy", "桛"},
	{"dynb", "樋"},
	{"dynv", "橠"},
	{"dyoj", "椊"},
	{"dyok", "棭"},
	{"dypd", "㯉"},
	{"dypf", "橴"},
	{"dypk", "榩"},
	{"dypm", "樝"},
	{"dypo", "㯫"},
	{"dypp", "櫖"},
	{"dyps", "㯭"},
	{"dypt", "櫨"},
	{"dypu", "椃"},
	{"dyr", "枮"},
	{"dyra", "櫧"},
	{"dyrb", "槁"},
	{"dyrd", "椁 㯎"},
	{"dyrf", "椋"},
	{"dyrn", "梈 楟"},
	{"dyro", "檺"},
	{"dyrv", "欀"},
	{"dys", "栌"},
	{"dysd", "椸"},
	{"dyso", "㯀"},
	{"dysr", "檹"},
	{"dysy", "棜 㮵"},
	{"dyt", "柆"},
	{"dyta", "㯾"},
	{"dytd", "榇"},
	{"dytg", "橦"},
	{"dytj", "梓 樟"},
	{"dytk", "㮸"},
	{"dyto", "檖"},
	{"dytp", "檍"},
	{"dytr", "棓"},
	{"dytu", "樈 檤"},
	{"dytv", "椄"},
	{"dyub", "樆"},
	{"dyut", "橀"},
	{"dyv", "杧"},
	{"dyvo", "核"},
	{"dyvq", "㯠"},
	{"dyvw", "槒"},
	{"dywd", "檁"},
	{"dywf", "檩"},
	{"dywi", "樐"},
	{"dywm", "檀"},
	{"dywv", "榱 櫰"},
	{"dyx", "櫅"},
	{"dyyb", "㰅"},
	{"e", "水"},
	{"ea", "汨 汩 沓"},
	{"eaa", "淐"},
	{"eabt", "温"},
	{"eabu", "㴘"},
	{"eafc", "灝 灦"},
	{"eafo", "灏"},
	{"eafu", "滉"},
	{"eag", "涅"},
	{"eagi", "溾"},
	{"eahm", "湦"},
	{"eahr", "㵆"},
	{"eahu", "湄"},
	{"eaiu", "溉"},
	{"eaja", "濐"},
	{"eam", "泹 𣵀"},
	{"eamh", "湯"},
	{"eami", "淂"},
	{"eamj", "涆"},
	{"eamk", "淏"},
	{"eamo", "湜"},
	{"eana", "澗"},
	{"eanb", "㵎"},
	{"eand", "澖"},
	{"eane", "灁"},
	{"eanf", "㶒"},
	{"eang", "潤"},
	{"eanj", "灛"},
	{"eank", "潣"},
	{"eano", "灍 㴸"},
	{"eanp", "㵍"},
	{"eanr", "濶"},
	{"eanw", "瀾"},
	{"eanx", "㶄"},
	{"eapp", "混"},
	{"eapv", "渴"},
	{"ease", "㵊"},
	{"easm", "溻"},
	{"easr", "𣸬"},
	{"eatc", "湿"},
	{"eate", "瀑"},
	{"eav", "泿 艰"},
	{"eavf", "濕"},
	{"eavo", "㵣"},
	{"eawe", "漫"},
	{"eaws", "澷"},
	{"eayf", "澋"},
	{"eayk", "渂"},
	{"eayt", "𣸭"},
	{"eayv", "㶞"},
	{"eb", "㳉"},
	{"ebac", "溟"},
	{"ebau", "淝"},
	{"ebb", "淜"},
	{"ebbb", "滑"},
	{"ebbe", "涭"},
	{"ebbr", "渦"},
	{"ebbu", "漞"},
	{"ebcd", "深"},
	{"ebch", "瀃"},
	{"ebci", "濺"},
	{"ebcj", "浫"},
	{"ebcn", "測"},
	{"ebcr", "浻"},
	{"ebcv", "瀴"},
	{"ebd", "𣶶"},
	{"ebdd", "𣺉"},
	{"ebdi", "浖"},
	{"ebdu", "㳶"},
	{"ebg", "𡒗"},
	{"ebgr", "淍"},
	{"ebhe", "㵻"},
	{"ebhf", "潙 㵼"},
	{"ebhg", "淫"},
	{"ebhu", "沉 观"},
	{"ebhx", "滔"},
	{"ebiu", "㶁"},
	{"ebjj", "渾"},
	{"ebkf", "鸂"},
	{"ebkm", "㶉"},
	{"ebkq", "浑"},
	{"ebla", "㴞"},
	{"ebm", "沮"},
	{"ebme", "湲"},
	{"ebmo", "溕"},
	{"ebmp", "濦"},
	{"ebmr", "洞"},
	{"ebnd", "浮"},
	{"ebnt", "㵬"},
	{"eboe", "𣿀"},
	{"ebof", "漈"},
	{"eboj", "溅"},
	{"ebon", "测"},
	{"ebou", "滛"},
	{"ebp", "慂 懘 懣"},
	{"ebpa", "㴯"},
	{"ebqo", "渓"},
	{"ebr", "泂"},
	{"ebsd", "淨"},
	{"ebsh", "㶀"},
	{"ebt", "泴 㳑"},
	{"ebtk", "㴨"},
	{"ebtu", "𣷣"},
	{"ebu", "泪"},
	{"ebuc", "浿"},
	{"ebug", "濉 灈"},
	{"ebuh", "渺"},
	{"ebuk", "湨"},
	{"ebul", "濎"},
	{"ebus", "㴐"},
	{"ebuu", "涀"},
	{"ebv", "浽 㜑"},
	{"ebvk", "溪"},
	{"ebwi", "灂"},
	{"ebyh", "浵"},
	{"ebyj", "𣂎"},
	{"ebym", "泻"},
	{"ec", "汃 淦"},
	{"ecb", "洕"},
	{"ecc", "鍙"},
	{"eccc", "𤅺"},
	{"eci", "㳂"},
	{"eck", "㳇"},
	{"eckc", "㵚"},
	{"ecnh", "涕"},
	{"ecor", "浴"},
	{"ecr", "沿"},
	{"ecru", "涗"},
	{"ecsh", "汾"},
	{"ecst", "湓"},
	{"ecwa", "潧"},
	{"ed", "沐"},
	{"edam", "渣"},
	{"edb", "洓"},
	{"edbt", "盓"},
	{"edbu", "湘"},
	{"edci", "淞"},
	{"edd", "淋"},
	{"edda", "澘"},
	{"eddd", "潹"},
	{"eddf", "澿"},
	{"eddg", "漜"},
	{"eddh", "灪"},
	{"eddn", "滼"},
	{"eddo", "濋"},
	{"eddv", "漤 𤂑"},
	{"edg", "塗"},
	{"edgg", "溦"},
	{"edha", "湐"},
	{"edhe", "波"},
	{"edhh", "涁"},
	{"edhl", "淅"},
	{"edi", "对"},
	{"edj", "沫"},
	{"edk", "決"},
	{"edkn", "㯩"},
	{"edl", "涑"},
	{"edlc", "瀨 瀬"},
	{"edlk", "潄"},
	{"edln", "溂"},
	{"edlo", "漱 濑"},
	{"edm", "泍"},
	{"edmbc", "顙"},
	{"edmbo", "颡"},
	{"edmd", "𣸑"},
	{"edmf", "渿"},
	{"edmg", "㳹"},
	{"edmq", "湋"},
	{"edn", "㐢"},
	{"ednf", "𤄄"},
	{"edod", "𣸯"},
	{"edoe", "漆"},
	{"edof", "𪆵"},
	{"edoo", "淶"},
	{"edow", "瀒"},
	{"edt", "涞"},
	{"edtc", "㶇"},
	{"edu", "㳐"},
	{"edvd", "𤄿"},
	{"edw", "涷"},
	{"edwf", "湅"},
	{"edyg", "㴤"},
	{"ee", "双 汉 沝 㕛 𣲙"},
	{"eea", "涾"},
	{"eec", "錃"},
	{"eedd", "㵉"},
	{"eedi", "㳔"},
	{"eee", "叒 淼 㴇"},
	{"eeed", "桑"},
	{"eeee", "叕 㵘"},
	{"eeeec", "䫎"},
	{"eeeee", "敠 敪"},
	{"eeeef", "鵽"},
	{"eeeen", "剟"},
	{"eeeeo", "欼"},
	{"eeeeu", "毲"},
	{"eeem", "叠 𣿫"},
	{"eei", "汊"},
	{"eeii", "溞"},
	{"eeip", "㶝"},
	{"eejb", "㵜"},
	{"eeki", "㳲"},
	{"eekn", "㴣"},
	{"eeko", "㴺"},
	{"eemr", "碆"},
	{"eeof", "㶃"},
	{"eeog", "滩"},
	{"eeol", "㴢"},
	{"eeq", "泽 㨇"},
	{"eetb", "濷"},
	{"eetc", "㶂"},
	{"eetm", "㶙"},
	{"eev", "婆"},
	{"eevr", "㵈"},
	{"efb", "消"},
	{"efbb", "𣻸"},
	{"efbc", "溑"},
	{"efbf", "灙"},
	{"efbg", "漟"},
	{"efbk", "潎"},
	{"efbr", "淌"},
	{"efbw", "澢"},
	{"efd", "洣"},
	{"efdc", "瀵"},
	{"efdq", "潾"},
	{"efdv", "溇"},
	{"eff", "淡 𣶷"},
	{"effc", "灐"},
	{"effd", "濚"},
	{"effe", "濴"},
	{"efff", "濙 瀠"},
	{"effg", "瀅"},
	{"effi", "㶈"},
	{"effr", "瀯"},
	{"effs", "澇"},
	{"efh", "沙"},
	{"efhu", "渻"},
	{"efmu", "洸"},
	{"efq", "泮"},
	{"efqe", "漛"},
	{"efqf", "潫"},
	{"efqu", "淃"},
	{"eg", "圣 坔"},
	{"egbt", "潱"},
	{"egbu", "涜"},
	{"egce", "淩"},
	{"egcg", "淕"},
	{"egde", "濲 瀔"},
	{"egdi", "洔"},
	{"egfe", "瀫"},
	{"egg", "塣 洼"},
	{"eggi", "湗"},
	{"eggu", "澆"},
	{"egi", "法"},
	{"egit", "溘"},
	{"egj", "準"},
	{"eglc", "浾"},
	{"egmbc", "頚"},
	{"egn", "乼"},
	{"egni", "濤"},
	{"egow", "濇"},
	{"egr", "洁"},
	{"egrc", "𤂌"},
	{"egrp", "㗟"},
	{"egrr", "㵙 𤀺"},
	{"egrv", "滍"},
	{"egsk", "滶"},
	{"egth", "澎"},
	{"egti", "澍"},
	{"egtj", "涬"},
	{"egwc", "瀆"},
	{"eha", "泊"},
	{"ehaa", "㵿 㶕"},
	{"ehab", "淿"},
	{"ehae", "湶"},
	{"ehaf", "鳮"},
	{"ehag", "湟"},
	{"ehal", "瀄"},
	{"ehar", "澔"},
	{"ehbd", "㶅"},
	{"ehbk", "澳"},
	{"ehbn", "淛"},
	{"ehbs", "澚"},
	{"ehbt", "洫 盪 䀊"},
	{"ehbu", "洎 灚"},
	{"ehbv", "浓"},
	{"ehby", "洀"},
	{"ehcn", "瀏"},
	{"ehd", "桬 𣓥"},
	{"ehda", "㴡"},
	{"ehdb", "潲"},
	{"ehdd", "㳵"},
	{"ehde", "潻"},
	{"ehdf", "湫"},
	{"ehdg", "𣽿"},
	{"ehdl", "𣶸"},
	{"ehdn", "浰 𣻗"},
	{"ehdp", "溒 㴽"},
	{"ehds", "𣵛"},
	{"ehdv", "涹"},
	{"ehdw", "潘"},
	{"ehe", "汳"},
	{"ehed", "涤"},
	{"ehej", "浲"},
	{"ehem", "湰"},
	{"eheq", "洚"},
	{"eher", "洛"},
	{"ehet", "瀊"},
	{"ehey", "泈"},
	{"ehf", "燙"},
	{"ehfd", "泘"},
	{"ehfp", "㵞"},
	{"ehg", "㙙 𡌂"},
	{"ehgi", "𤅕"},
	{"ehgr", "浩"},
	{"ehgu", "洗"},
	{"ehhi", "㴬"},
	{"ehhj", "㵺"},
	{"ehhl", "泖"},
	{"ehhq", "㸺"},
	{"ehhqu", "㲚"},
	{"ehhu", "滗"},
	{"ehhv", "派"},
	{"ehhw", "溜"},
	{"ehic", "𤅄"},
	{"ehio", "泛"},
	{"ehj", "汘"},
	{"ehjd", "洙"},
	{"ehjg", "湩"},
	{"ehjm", "涶"},
	{"ehjr", "活"},
	{"ehjx", "㴙"},
	{"ehk", "沃"},
	{"ehkb", "𣾷"},
	{"ehkl", "㳢"},
	{"ehkp", "添"},
	{"ehkt", "㴁"},
	{"ehlb", "渪"},
	{"ehlo", "沠"},
	{"ehlq", "潷"},
	{"ehlx", "𤄙"},
	{"ehmgi", "璗"},
	{"ehmj", "㶘"},
	{"ehml", "沂"},
	{"ehmo", "澨"},
	{"ehmr", "洉 硰"},
	{"ehmy", "泝"},
	{"ehn", "乷 㲹"},
	{"ehnb", "𣳽"},
	{"ehnd", "𣳼"},
	{"ehne", "没"},
	{"ehnf", "㵯"},
	{"ehni", "汎 渢"},
	{"ehnk", "沨"},
	{"ehnn", "洬"},
	{"ehnwf", "鯊"},
	{"ehnwm", "鲨"},
	{"ehoe", "澓"},
	{"ehok", "瀓 㵟"},
	{"ehon", "洐 𣶹"},
	{"ehoo", "漇 漎"},
	{"ehou", "㵌"},
	{"ehp", "汑"},
	{"ehpa", "涽"},
	{"ehpm", "泜"},
	{"ehpu", "漑"},
	{"ehq", "挲"},
	{"ehqi", "涐"},
	{"ehqj", "湃"},
	{"ehqm", "泩"},
	{"ehqo", "泆"},
	{"ehrau", "䣉"},
	{"ehrb", "溎"},
	{"ehrf", "溩 𪄣"},
	{"ehrt", "㵇"},
	{"ehs", "泎"},
	{"ehsd", "淭"},
	{"ehse", "溵"},
	{"ehsk", "淚 激"},
	{"ehsu", "滬"},
	{"ehua", "濳"},
	{"ehuc", "瀩 灒"},
	{"ehud", "㴪"},
	{"ehuk", "溴"},
	{"ehul", "濞"},
	{"ehup", "㴧"},
	{"ehv", "娑"},
	{"ehvd", "泺"},
	{"ehvo", "泒"},
	{"ehvp", "汦"},
	{"ehwj", "渒"},
	{"ehwo", "潨"},
	{"ehwp", "漗"},
	{"ehx", "㳫"},
	{"ehxc", "㵰"},
	{"ehxf", "潟"},
	{"ehxm", "湼"},
	{"ehxo", "㳛"},
	{"ehxu", "淣"},
	{"ehyhv", "裟"},
	{"ehyu", "㴲"},
	{"ei", "叉 戏 㲿 㳀"},
	{"eiav", "浪"},
	{"eib", "㳙"},
	{"eibi", "溥"},
	{"eibp", "㴰"},
	{"eice", "浚"},
	{"eid", "梁"},
	{"eidy", "灖"},
	{"eifd", "粱"},
	{"eihf", "滅"},
	{"eihi", "㳚"},
	{"eihq", "洠"},
	{"eihr", "減"},
	{"eihu", "沇"},
	{"eii", "淺 㕚"},
	{"eiih", "滲"},
	{"eiim", "㴉"},
	{"eiip", "㵕"},
	{"eij", "浅"},
	{"eijb", "浦"},
	{"eijc", "沭"},
	{"eije", "浗"},
	{"eik", "汱"},
	{"eikf", "溈"},
	{"eikh", "渗"},
	{"eikk", "沷"},
	{"eikp", "泷"},
	{"eiks", "沩"},
	{"eiku", "沋"},
	{"eilb", "滽"},
	{"eile", "漮"},
	{"eill", "洲"},
	{"eilmi", "蚤"},
	{"eilr", "溏"},
	{"eims", "㵴"},
	{"eine", "泳"},
	{"eioc", "澬"},
	{"eiok", "涘"},
	{"eiop", "㶐"},
	{"eip", "怼"},
	{"eipb", "浳"},
	{"eipf", "瀌"},
	{"eir", "治"},
	{"eirk", "㵄"},
	{"eirm", "淢"},
	{"eirp", "澸"},
	{"eis", "沪"},
	{"eisb", "㴜"},
	{"eise", "㴃"},
	{"eit", "㳎 㳦"},
	{"eitc", "濂 瀇"},
	{"eite", "渡"},
	{"eitf", "㵂"},
	{"eiti", "㳤"},
	{"eitu", "㴑"},
	{"eiv", "泧"},
	{"eive", "泼"},
	{"eivj", "浒"},
	{"eiwg", "瀍"},
	{"eixi", "灋"},
	{"eixp", "漉"},
	{"ej", "汁"},
	{"ejac", "濵"},
	{"ejaf", "㵭"},
	{"ejao", "㵓"},
	{"ejb", "沛"},
	{"ejbc", "滇"},
	{"ejbd", "浡"},
	{"ejbj", "湳"},
	{"ejbm", "淔 𣶺"},
	{"ejbv", "灢"},
	{"ejc", "泬 㳈"},
	{"ejcb", "潸"},
	{"ejcc", "㴱"},
	{"ejcg", "潌 㴏"},
	{"ejck", "湥"},
	{"ejcm", "涳"},
	{"ejco", "溛"},
	{"ejcr", "溶"},
	{"ejcu", "㴭 㵠"},
	{"ejd", "沬 浨"},
	{"ejdk", "漖 㴾"},
	{"ejds", "渤"},
	{"eje", "汥"},
	{"ejhf", "瀉"},
	{"ejhq", "浶"},
	{"ejhw", "瀋"},
	{"ejic", "瀻"},
	{"ejid", "溨"},
	{"ejig", "㵶"},
	{"ejii", "漙 𣽡"},
	{"ejik", "涋"},
	{"ejim", "瀐"},
	{"ejip", "潓"},
	{"ejir", "渽"},
	{"ejjb", "潮"},
	{"ejjc", "𤃬"},
	{"ejjj", "澣 濣"},
	{"ejjl", "漸"},
	{"ejjm", "瀚"},
	{"ejjn", "漧"},
	{"ejka", "渚"},
	{"ejkd", "涍"},
	{"ejki", "浤"},
	{"ejkp", "㳣"},
	{"ejks", "洘"},
	{"ejll", "渖"},
	{"ejlo", "𣶏"},
	{"ejlv", "淒"},
	{"ejmc", "演 濱"},
	{"ejmd", "𣳿"},
	{"ejme", "滱"},
	{"ejmf", "淙"},
	{"ejmm", "渲"},
	{"ejmn", "泞"},
	{"ejmo", "淀 𣺊"},
	{"ejmu", "浣"},
	{"ejnk", "渎"},
	{"ejnu", "涴"},
	{"ejoa", "㴼"},
	{"ejoc", "滨"},
	{"ejp", "沱"},
	{"ejpb", "澝 𤀑"},
	{"ejph", "淧"},
	{"ejpn", "濘"},
	{"ejpt", "㵥"},
	{"ejpu", "浇 滵"},
	{"ejqp", "瀗"},
	{"ejr", "沽"},
	{"ejrb", "湖"},
	{"ejrr", "涫 㴦"},
	{"ejru", "㳳"},
	{"ejse", "濅"},
	{"ejsh", "㵳"},
	{"ejt", "泋"},
	{"ejtc", "濆"},
	{"ejto", "瀽"},
	{"ejv", "洝"},
	{"ejye", "漃"},
	{"ejyj", "滓"},
	{"ek", "汏 㲼"},
	{"ekb", "洧"},
	{"ekc", "鋈"},
	{"ekcf", "潦"},
	{"ekf", "洃"},
	{"ekha", "潴"},
	{"ekhr", "漪"},
	{"eki", "汯 汰 㳒"},
	{"ekig", "㳗"},
	{"ekja", "㵔"},
	{"ekjt", "渀"},
	{"ekkb", "浠 淆"},
	{"ekkk", "漺"},
	{"eklb", "㳍"},
	{"ekld", "洊"},
	{"eklu", "淹"},
	{"ekm", "𣳇"},
	{"ekmf", "㴎"},
	{"ekmr", "渏"},
	{"ekms", "洿"},
	{"ekn", "氿 洟"},
	{"ekni", "汍"},
	{"eknj", "㳃"},
	{"ekoo", "浹"},
	{"ekpb", "滯"},
	{"ekql", "渐"},
	{"ekr", "㳓"},
	{"ekrc", "㵑"},
	{"eks", "劝 氻"},
	{"eksr", "泇"},
	{"ekt", "浃"},
	{"ektq", "㵮"},
	{"el", "沖"},
	{"elbk", "泱"},
	{"elbu", "沈"},
	{"elc", "𨮜"},
	{"elfl", "渊"},
	{"elg", "垽"},
	{"elgm", "澅"},
	{"elgte", "鼝"},
	{"elhi", "魙"},
	{"elim", "渱 灗"},
	{"elip", "㵃"},
	{"elit", "滥"},
	{"elk", "㳏"},
	{"ellb", "浉"},
	{"elll", "汌 沜"},
	{"elln", "沸"},
	{"ellp", "漶"},
	{"elmc", "潰"},
	{"elmcw", "䤔"},
	{"elmi", "浊"},
	{"elmo", "洮"},
	{"elmt", "濜"},
	{"elmy", "渄"},
	{"elnc", "㵒"},
	{"elq", "津"},
	{"elsa", "涧"},
	{"elsg", "润"},
	{"elsj", "聻"},
	{"elsw", "澜"},
	{"elu", "峾"},
	{"elv", "嬱"},
	{"elvu", "湚"},
	{"elw", "油"},
	{"elwp", "洩"},
	{"elws", "涄"},
	{"elwv", "漊"},
	{"elx", "潚 㴋"},
	{"elxh", "泲"},
	{"elxl", "淵"},
	{"em", "江"},
	{"ema", "洦"},
	{"emad", "㴟"},
	{"emam", "洹"},
	{"embb", "濡 灞"},
	{"embc", "湏"},
	{"embd", "瀮"},
	{"embe", "瀀"},
	{"embg", "瀖"},
	{"embi", "澐 澪 瀜"},
	{"embk", "渜"},
	{"embl", "洏"},
	{"embm", "𤅷"},
	{"embr", "𤅟"},
	{"embu", "灀 㵡"},
	{"embw", "㵢"},
	{"emby", "㳩"},
	{"emcw", "洒 酒"},
	{"emd", "汙"},
	{"emdm", "瀝"},
	{"emdp", "𤃉"},
	{"emf", "㳅"},
	{"emfb", "濔"},
	{"emfi", "㵱 𤅜"},
	{"emfj", "泙"},
	{"emfr", "㳪"},
	{"emg", "汪"},
	{"emgb", "洅 㴂"},
	{"emgg", "涯"},
	{"emgh", "濏"},
	{"emgk", "㴛"},
	{"emgr", "𣾏"},
	{"emgt", "㳥"},
	{"emgu", "潖"},
	{"emhf", "源 鴻"},
	{"emia", "滏"},
	{"emig", "洷"},
	{"emih", "㴳"},
	{"emj", "汗"},
	{"emjk", "澉"},
	{"emjs", "汚"},
	{"emks", "沥"},
	{"emlb", "沞"},
	{"emlk", "浭"},
	{"emlm", "𣵾"},
	{"emls", "沔"},
	{"emlw", "澑"},
	{"emmc", "澒"},
	{"emmf", "沶"},
	{"emmi", "沄"},
	{"emmp", "灑"},
	{"emmr", "浯"},
	{"emms", "污"},
	{"emmu", "沅"},
	{"emmv", "浱"},
	{"emn", "汀"},
	{"emnc", "㴿"},
	{"emnn", "洌"},
	{"emnr", "河"},
	{"emo", "㳁"},
	{"emoa", "瀦"},
	{"empm", "鸿"},
	{"emr", "沯 沰"},
	{"emrb", "滆"},
	{"emrr", "滒"},
	{"emrt", "浢"},
	{"emru", "𣸰"},
	{"emrw", "湢"},
	{"emsk", "涙"},
	{"emso", "涿"},
	{"emt", "汧"},
	{"emtb", "濿"},
	{"emti", "㴻"},
	{"emto", "㵐"},
	{"emua", "潛"},
	{"emub", "灊"},
	{"emvb", "漘"},
	{"emvg", "溼"},
	{"emvi", "溽"},
	{"emvm", "沍 涇"},
	{"emvr", "滣"},
	{"emvs", "汅"},
	{"emwb", "㶚"},
	{"emwd", "溧"},
	{"emwf", "漂"},
	{"emwg", "湮 湹"},
	{"emwj", "潭"},
	{"emwl", "湎"},
	{"emwv", "㴗"},
	{"emyf", "漹"},
	{"emym", "泟"},
	{"en", "㲸"},
	{"enao", "潒"},
	{"enau", "浼"},
	{"enbk", "渙"},
	{"enbq", "澥"},
	{"enbs", "湧"},
	{"enbt", "盕"},
	{"encr", "澹"},
	{"end", "染"},
	{"enda", "㵫"},
	{"ene", "沒"},
	{"enem", "洆"},
	{"enf", "沵"},
	{"enff", "𤄏"},
	{"enfq", "㶍"},
	{"eng", "沑"},
	{"enhb", "潏"},
	{"enhd", "渘"},
	{"enhe", "汲"},
	{"enhx", "淊"},
	{"eni", "汐 泓"},
	{"enib", "涌"},
	{"enic", "濥"},
	{"enii", "漒"},
	{"enin", "汿 沀"},
	{"enir", "洺"},
	{"enj", "汛"},
	{"enkg", "涏"},
	{"enkm", "涎"},
	{"enkq", "湕"},
	{"enkw", "𣶻"},
	{"enl", "邓"},
	{"enla", "㳱 𣾂"},
	{"enlb", "瀡"},
	{"enlc", "濻"},
	{"enld", "滁"},
	{"enlm", "漋"},
	{"enlp", "㶏"},
	{"enls", "泐"},
	{"enmb", "瀰"},
	{"enme", "渌"},
	{"enmm", "溺"},
	{"enmu", "洈"},
	{"ennc", "澦"},
	{"ennf", "㳽"},
	{"enno", "滪 㴍"},
	{"eno", "欢 㳄"},
	{"enob", "湑"},
	{"enoe", "潑"},
	{"enok", "湀"},
	{"enom", "泾"},
	{"enop", "溌"},
	{"enot", "澄"},
	{"enpo", "涨"},
	{"enqd", "滘"},
	{"enri", "瀺"},
	{"ensd", "浄"},
	{"ensh", "汤"},
	{"ensj", "渳"},
	{"ensp", "㴔"},
	{"enst", "溋"},
	{"ensv", "漲"},
	{"enue", "涵"},
	{"enwa", "瀂"},
	{"enwf", "漁"},
	{"enwm", "渔"},
	{"eo", "汄"},
	{"eoah", "漡"},
	{"eob", "汭"},
	{"eobg", "㴶"},
	{"eobt", "盜"},
	{"eod", "㳜"},
	{"eode", "溆 潊"},
	{"eodi", "泭"},
	{"eodk", "漵"},
	{"eog", "淮 难"},
	{"eogd", "潗"},
	{"eogf", "潐"},
	{"eohg", "㳝"},
	{"eohh", "沴"},
	{"eoi", "浌"},
	{"eoic", "㵅"},
	{"eoii", "泠 𣸮"},
	{"eoik", "洑"},
	{"eoim", "瀸"},
	{"eoin", "汵"},
	{"eoip", "淰"},
	{"eoir", "浛 滄"},
	{"eoiv", "湌"},
	{"eoj", "汻"},
	{"eok", "㳊"},
	{"eokf", "瀿"},
	{"eokg", "潅"},
	{"eokp", "滺"},
	{"eokr", "𣺈"},
	{"eol", "㳞"},
	{"eolb", "滫 潃"},
	{"eold", "滌"},
	{"eolf", "㶖"},
	{"eolk", "浟"},
	{"eom", "㳋"},
	{"eoma", "澮"},
	{"eomb", "淪 瀹 㵸"},
	{"eomc", "浜"},
	{"eomd", "涂"},
	{"eomg", "洤"},
	{"eomi", "浍"},
	{"eomk", "潋"},
	{"eomm", "潝 𣲚"},
	{"eomn", "汽 渝"},
	{"eomo", "澰"},
	{"eomr", "洽 涻"},
	{"eomt", "渰"},
	{"eomu", "㴈"},
	{"eon", "汔"},
	{"eond", "溙"},
	{"eono", "㳬"},
	{"eoob", "溍"},
	{"eook", "瀲"},
	{"eooo", "㶑"},
	{"eop", "沎 沦"},
	{"eopd", "沲"},
	{"eora", "潪"},
	{"eord", "湺"},
	{"eosk", "洢"},
	{"eosu", "沧"},
	{"eotf", "潕"},
	{"eoto", "濮"},
	{"eotq", "㵲"},
	{"eou", "𣳈"},
	{"eowy", "海"},
	{"eoyt", "涖"},
	{"ep", "沁 㲺"},
	{"epa", "洵 𣇹"},
	{"epd", "柒 池"},
	{"epdc", "𤃡"},
	{"epfd", "淗"},
	{"epg", "埿"},
	{"eph", "泌"},
	{"epha", "㳷"},
	{"ephg", "㳴"},
	{"ephh", "沕"},
	{"ephp", "淴"},
	{"ephr", "湉"},
	{"epht", "㴵"},
	{"epi", "汋 沟"},
	{"epim", "汮"},
	{"epl", "浺"},
	{"epou", "淘"},
	{"epp", "沘"},
	{"eppa", "湝"},
	{"epr", "泃"},
	{"epru", "泡"},
	{"epsh", "沏"},
	{"ept", "泄"},
	{"eptd", "渫"},
	{"epu", "沌"},
	{"epuk", "洶"},
	{"epym", "鸡"},
	{"epyr", "渹"},
	{"eqbd", "瀞"},
	{"eqbi", "𤂅"},
	{"eqbu", "濪 㵾"},
	{"eqd", "洡"},
	{"eqg", "堻"},
	{"eqhf", "潔"},
	{"eqhl", "浙"},
	{"eqj", "沣"},
	{"eqjr", "湱"},
	{"eqju", "滟"},
	{"eqka", "湷"},
	{"eqkd", "溱"},
	{"eqke", "溰"},
	{"eqki", "涛"},
	{"eqkk", "湊"},
	{"eqkq", "淎"},
	{"eqmb", "清"},
	{"eqmc", "漬"},
	{"eqmf", "溸 溹"},
	{"eqmo", "渍"},
	{"eqoa", "潜"},
	{"eqoc", "濽"},
	{"eqod", "㳺"},
	{"eqor", "湁"},
	{"er", "呇"},
	{"erau", "浥"},
	{"erb", "涓"},
	{"erbc", "滜"},
	{"erbo", "涢"},
	{"erc", "𣲵"},
	{"erd", "㳭"},
	{"erhg", "浧"},
	{"erhu", "況"},
	{"erji", "濈"},
	{"erlu", "渑"},
	{"ermr", "潞"},
	{"erob", "涡"},
	{"erp", "惉"},
	{"erpa", "湣"},
	{"errd", "澡"},
	{"errj", "潬"},
	{"errs", "湂"},
	{"erru", "澏"},
	{"erse", "溊"},
	{"ersj", "湒"},
	{"ertm", "㽏"},
	{"eru", "汜"},
	{"eruc", "潠"},
	{"ervk", "洖"},
	{"ervp", "泯"},
	{"erxu", "澠"},
	{"eryo", "浞"},
	{"es", "汇"},
	{"esbn", "涮"},
	{"esce", "澱"},
	{"esd", "渠"},
	{"ese", "㳮"},
	{"eseg", "𣻹 𣿬"},
	{"eseo", "㵵"},
	{"esfb", "㴮"},
	{"esfi", "𣻷"},
	{"esfj", "㶠"},
	{"eshi", "㲽"},
	{"eshr", "沼"},
	{"eshu", "浘"},
	{"esim", "澀"},
	{"esip", "涊"},
	{"esit", "濫"},
	{"esj", "洱"},
	{"esja", "潳"},
	{"esje", "滠"},
	{"esjj", "灄"},
	{"esjr", "涺"},
	{"esjt", "㶌"},
	{"esju", "㳧 㴷"},
	{"esk", "沤"},
	{"eskn", "泦"},
	{"eskr", "涒"},
	{"eslc", "㶊"},
	{"esll", "洍"},
	{"eslr", "瀶"},
	{"esm", "汈"},
	{"esma", "漝"},
	{"esmb", "漏 㴆"},
	{"esmc", "瀷"},
	{"esme", "浸"},
	{"esmg", "洭 渥 濯"},
	{"esmh", "漻"},
	{"esmi", "潯"},
	{"esmj", "濢"},
	{"esmo", "㵤"},
	{"esmr", "泀"},
	{"esmv", "涱"},
	{"esnd", "潺"},
	{"eso", "沢"},
	{"esog", "滙 𣾀"},
	{"esoy", "浕"},
	{"esp", "泥"},
	{"esqf", "溲"},
	{"esrj", "澼"},
	{"esrl", "㴫"},
	{"esrr", "漚"},
	{"ess", "洰"},
	{"estn", "㶜"},
	{"estt", "𣸹"},
	{"estv", "𣺹"},
	{"esu", "氾"},
	{"esuf", "𤏁"},
	{"esuu", "淈"},
	{"eswu", "灠"},
	{"esyi", "灟"},
	{"esyq", "漽"},
	{"eta", "㳻"},
	{"etab", "濗"},
	{"etak", "漠"},
	{"etav", "㵧"},
	{"etaw", "灡"},
	{"etbc", "淟 𤅎"},
	{"etbd", "溁"},
	{"etbf", "潆"},
	{"etbg", "滢"},
	{"etbk", "潵"},
	{"etbn", "湔"},
	{"etbo", "濛"},
	{"etbs", "涝"},
	{"etc", "洪"},
	{"etca", "潽"},
	{"etcd", "澲"},
	{"etce", "灇"},
	{"etcf", "濝 𪃡"},
	{"etcg", "𣻺"},
	{"etch", "𣶼"},
	{"etcl", "澌"},
	{"etco", "𣾴"},
	{"etct", "溢"},
	{"etcu", "港"},
	{"etcw", "湭"},
	{"etge", "漾"},
	{"etgf", "溔"},
	{"etgi", "濧 𣿭"},
	{"etgk", "渼"},
	{"etgo", "湵 㵪"},
	{"etgt", "濭"},
	{"etgu", "㳾"},
	{"ethd", "㴕"},
	{"ethg", "𣿅"},
	{"ethn", "𣼵"},
	{"etho", "㴀"},
	{"ethu", "渞"},
	{"etif", "瀳"},
	{"etio", "𣷸"},
	{"etis", "㶓"},
	{"etit", "漭"},
	{"etjb", "滞"},
	{"etju", "𣻻"},
	{"etk", "浂"},
	{"etkn", "渕"},
	{"etkr", "渃"},
	{"etlb", "滿"},
	{"etlj", "㴖"},
	{"etlk", "渶"},
	{"etlm", "漌"},
	{"etlo", "漢"},
	{"etlx", "瀟"},
	{"etm", "泔"},
	{"etmb", "满"},
	{"etmbc", "頮"},
	{"etmbo", "颒"},
	{"etmc", "淇 潢"},
	{"etmd", "湈"},
	{"etmi", "𣶽"},
	{"etmj", "澕"},
	{"etmm", "㳕"},
	{"etmr", "渮"},
	{"etmv", "湛"},
	{"etmw", "𣺋"},
	{"etnk", "𣿮"},
	{"etnu", "𣸱"},
	{"etoe", "濩"},
	{"etog", "灘"},
	{"etom", "㶋"},
	{"etop", "㳸"},
	{"etor", "溚 濸"},
	{"etov", "瀁"},
	{"etpd", "㵩"},
	{"etpo", "㴚"},
	{"etpp", "濍"},
	{"etq", "洋"},
	{"etqm", "溠"},
	{"etrg", "灌"},
	{"etse", "𣿯"},
	{"etst", "灆"},
	{"ett", "汫 洴"},
	{"ettb", "溝"},
	{"ettc", "湴 𣾁"},
	{"ettn", "渆"},
	{"ettr", "㵛"},
	{"ettt", "灎"},
	{"ettu", "灔"},
	{"etub", "溯"},
	{"etui", "溬"},
	{"etun", "㴊"},
	{"etvd", "𤂋"},
	{"etvi", "滋"},
	{"etvp", "濨"},
	{"etw", "浀 渵"},
	{"etwa", "漕"},
	{"etwb", "澫"},
	{"etwi", "澊 瀎"},
	{"etwt", "澧"},
	{"etwv", "濃"},
	{"etxc", "溓"},
	{"etyc", "𤅖"},
	{"etyj", "㵏 𤂍"},
	{"etym", "淽"},
	{"etyp", "𣸆"},
	{"etys", "淓"},
	{"etyu", "㵁"},
	{"eu", "汕"},
	{"euap", "潉"},
	{"eubb", "漰"},
	{"eubt", "䀀"},
	{"euc", "鍌 鎏"},
	{"eufb", "㴥"},
	{"eugk", "澂"},
	{"euhj", "𣺿"},
	{"euhq", "溄"},
	{"eujf", "漴"},
	{"eujt", "灃"},
	{"euk", "汹"},
	{"eumb", "湍"},
	{"eumf", "湠"},
	{"eumg", "漄"},
	{"eumgi", "瑬"},
	{"eune", "㴠"},
	{"euog", "漼"},
	{"euon", "涔"},
	{"eutc", "潂"},
	{"eutk", "㵹"},
	{"eutt", "灩"},
	{"eutu", "灧"},
	{"euu", "泏"},
	{"euud", "𤀻"},
	{"ev", "汝"},
	{"evfb", "𤁗"},
	{"evfd", "灤"},
	{"evfe", "𤀼"},
	{"evff", "㴴"},
	{"evfg", "濰"},
	{"evfn", "灣"},
	{"evfr", "𤀽"},
	{"evid", "濼"},
	{"evio", "泤"},
	{"evis", "泑"},
	{"evjr", "㴌"},
	{"evmg", "潍"},
	{"evmw", "湽"},
	{"evne", "淥"},
	{"evno", "湪"},
	{"evr", "洳"},
	{"evrf", "㵖"},
	{"evrp", "㖳"},
	{"evug", "灉"},
	{"evvd", "漅"},
	{"evvn", "㳨"},
	{"evvu", "㴩"},
	{"evvw", "淄"},
	{"ew", "沺 畓"},
	{"ewb", "渭"},
	{"ewc", "泗 𣳉"},
	{"ewce", "溭"},
	{"ewcr", "㴄 㴅"},
	{"ewd", "涃 淉"},
	{"ewdq", "潿"},
	{"ewe", "𣲷"},
	{"ewfq", "滃"},
	{"ewg", "浬"},
	{"ewgf", "潶"},
	{"ewgg", "濹"},
	{"ewim", "漍"},
	{"ewjr", "涸"},
	{"ewk", "洇"},
	{"ewl", "㳌"},
	{"ewla", "濖"},
	{"ewlb", "湡"},
	{"ewlc", "㵋"},
	{"ewli", "濁"},
	{"ewlj", "澤"},
	{"ewlk", "㶔"},
	{"ewln", "瀱"},
	{"ewlo", "潀 𣽁"},
	{"ewlv", "澴"},
	{"ewml", "淠"},
	{"ewmo", "溷"},
	{"ewmv", "渨"},
	{"ewno", "歠"},
	{"ewo", "泅"},
	{"ewot", "溫"},
	{"ewp", "㴓"},
	{"ewqs", "涠"},
	{"ewr", "洄"},
	{"ewtc", "潩"},
	{"ewtj", "滭"},
	{"ewvf", "漯"},
	{"ewwf", "㶟"},
	{"ewwg", "灅"},
	{"ewww", "㵽"},
	{"eyaj", "淖"},
	{"eybb", "渧 濄"},
	{"eybc", "湞"},
	{"eybg", "灕"},
	{"eybk", "澈"},
	{"eybo", "浈"},
	{"eybp", "瀧"},
	{"eybr", "𣽊"},
	{"eybs", "滂"},
	{"eybu", "濬 𣿰"},
	{"eycb", "滴"},
	{"eycd", "滦"},
	{"eyck", "洨 湙"},
	{"eycn", "湾"},
	{"eyct", "㴒"},
	{"eycu", "渷"},
	{"eycv", "滚 滾"},
	{"eydi", "㳡"},
	{"eydk", "潡"},
	{"eydl", "漷 澵"},
	{"eydu", "瀙"},
	{"eyed", "澯"},
	{"eyem", "瀣"},
	{"eyfd", "㴹"},
	{"eyfe", "淑"},
	{"eyg", "注"},
	{"eygq", "澾"},
	{"eyhc", "濓 瀕"},
	{"eyhj", "漨"},
	{"eyhm", "滻"},
	{"eyhn", "沆"},
	{"eyho", "濒"},
	{"eyhs", "汸"},
	{"eyhv", "㳖"},
	{"eyib", "淯"},
	{"eyid", "㳿"},
	{"eyit", "㳰"},
	{"eyiu", "流 㳘"},
	{"eyj", "㳆"},
	{"eyjc", "灨"},
	{"eyjj", "漣"},
	{"eyk", "汶 㳠"},
	{"eykb", "㵦"},
	{"eykk", "滧"},
	{"eykl", "济"},
	{"eykn", "浏"},
	{"eykq", "涟"},
	{"eylc", "洂 瀢"},
	{"eylh", "涉"},
	{"eylm", "沚"},
	{"eymh", "濊"},
	{"eymm", "澁"},
	{"eymo", "渋"},
	{"eymp", "泚"},
	{"eymu", "𤀹"},
	{"eyoj", "淬"},
	{"eyok", "液"},
	{"eypd", "滹"},
	{"eypk", "澞"},
	{"eypo", "澽"},
	{"eypp", "濾"},
	{"eypt", "瀘"},
	{"eypu", "淲"},
	{"eyr", "沾"},
	{"eyra", "湻 㶆"},
	{"eyrb", "滈"},
	{"eyrd", "淳"},
	{"eyrf", "涼"},
	{"eyrj", "滸"},
	{"eyrn", "涥 渟 瀛 灜 𤅀 𤅗"},
	{"eyro", "濠"},
	{"eyru", "湸 𣻼"},
	{"eyrv", "瀼"},
	{"eys", "泸"},
	{"eysc", "㶛"},
	{"eysd", "游 湤"},
	{"eysk", "㵀"},
	{"eyso", "漩"},
	{"eysy", "淤"},
	{"eyt", "泣"},
	{"eyta", "湆"},
	{"eytb", "湇"},
	{"eytg", "潼"},
	{"eyth", "浐"},
	{"eytj", "漳 㳯"},
	{"eyto", "澻"},
	{"eytp", "澺"},
	{"eytr", "涪"},
	{"eytu", "滝"},
	{"eytv", "淁"},
	{"eyub", "漓"},
	{"eyuh", "滮"},
	{"eyv", "汒"},
	{"eyvb", "㵝"},
	{"eyvg", "澭"},
	{"eyvi", "泫"},
	{"eyvw", "滀"},
	{"eywd", "澟"},
	{"eywi", "滷"},
	{"eywm", "澶"},
	{"eywv", "滖 瀤 㶎"},
	{"eyx", "濟"},
	{"eyy", "汴"},
	{"f", "火"},
	{"faa", "焻"},
	{"fab", "焨"},
	{"fabt", "煴"},
	{"fafu", "熀"},
	{"faht", "焺"},
	{"fahu", "溗"},
	{"fam", "炟"},
	{"famh", "煬"},
	{"famj", "焊 㷸"},
	{"famo", "煶"},
	{"fanb", "燗"},
	{"fank", "燘"},
	{"fano", "熌"},
	{"fanp", "燜"},
	{"fanw", "爛"},
	{"fanx", "爓"},
	{"faph", "焬"},
	{"fapp", "焜"},
	{"fapv", "㷎"},
	{"farf", "燳"},
	{"fase", "熶"},
	{"fate", "爆"},
	{"fatj", "爗"},
	{"fau", "𤆵"},
	{"fawe", "熳"},
	{"fayf", "燝"},
	{"fayi", "𤋉"},
	{"fayt", "煜"},
	{"fb", "肖"},
	{"fbac", "熐"},
	{"fbb", "焩"},
	{"fbbe", "燰"},
	{"fbbhu", "觉"},
	{"fbbr", "煱"},
	{"fbbuu", "覚"},
	{"fbcr", "烱"},
	{"fbd", "栄 𤊕"},
	{"fbe", "泶"},
	{"fbf", "㡀"},
	{"fbg", "坣"},
	{"fbhaf", "鶺 䳤"},
	{"fbhgr", "喾"},
	{"fbhn", "𤆤"},
	{"fbhne", "㲂"},
	{"fbhqu", "㲖"},
	{"fbhui", "䰪"},
	{"fbhx", "熖"},
	{"fbjj", "溤"},
	{"fbkf", "燃"},
	{"fbks", "労"},
	{"fbla", "㷔"},
	{"fblmi", "蛍"},
	{"fbln", "削"},
	{"fbme", "煖"},
	{"fbmmi", "尝"},
	{"fbmr", "烔"},
	{"fbnd", "学 烰"},
	{"fbnl", "䣊"},
	{"fbnwm", "鲎"},
	{"fbok", "敝 敞"},
	{"fbou", "熎"},
	{"fbpym", "鹡"},
	{"fbq", "㶲"},
	{"fbr", "尚 炯"},
	{"fbrbc", "賞"},
	{"fbrbo", "赏"},
	{"fbrbp", "㦂"},
	{"fbrd", "棠"},
	{"fbrg", "堂"},
	{"fbrhu", "党"},
	{"fbrlb", "常"},
	{"fbrmh", "牚"},
	{"fbrmn", "瑐 瓽"},
	{"fbrnn", "㗬"},
	{"fbrpa", "嘗"},
	{"fbrq", "掌"},
	{"fbrr", "営"},
	{"fbrtm", "甞"},
	{"fbrw", "當"},
	{"fbrwf", "黨"},
	{"fbryo", "䟫"},
	{"fbryv", "裳"},
	{"fbtlc", "黉"},
	{"fbtu", "焵"},
	{"fbtv", "焹"},
	{"fbu", "峃"},
	{"fbug", "爠"},
	{"fbuu", "覍 䙺"},
	{"fbwi", "爝"},
	{"fbyh", "烿"},
	{"fcb", "脊"},
	{"fci", "炂"},
	{"fcip", "焧"},
	{"fcnh", "焍"},
	{"fcnl", "䣔"},
	{"fcor", "焀"},
	{"fcq", "举"},
	{"fcwa", "熷"},
	{"fcymr", "誉"},
	{"fd", "炑 米 𣏦"},
	{"fdamg", "糧"},
	{"fdamh", "糃"},
	{"fdamo", "䊓"},
	{"fdapp", "䊐"},
	{"fdau", "粑"},
	{"fdawe", "䊡"},
	{"fdbcr", "𥺂"},
	{"fdbm", "粗"},
	{"fdbmr", "粡"},
	{"fdbnd", "粰"},
	{"fdbt", "粣"},
	{"fdbuu", "粯"},
	{"fdcsh", "粉"},
	{"fddam", "𥻗"},
	{"fddb", "䊂"},
	{"fddh", "爩"},
	{"fddi", "籿"},
	{"fddj", "粖"},
	{"fdeii", "糔"},
	{"fdfbg", "糛"},
	{"fdfbr", "䊑"},
	{"fdff", "䊏"},
	{"fdfh", "粆"},
	{"fdfq", "䉽"},
	{"fdfqu", "䊎"},
	{"fdgbt", "䊦"},
	{"fdgni", "䊭"},
	{"fdgp", "𥺃"},
	{"fdgrr", "糦"},
	{"fdha", "粕"},
	{"fdhag", "䊗"},
	{"fdhdp", "䊝"},
	{"fdhdw", "䊩"},
	{"fdhe", "粄"},
	{"fdhfd", "䉿"},
	{"fdhgu", "䊁"},
	{"fdhhj", "粺"},
	{"fdhj", "粁"},
	{"fdhml", "䉼"},
	{"fdhn", "籶"},
	{"fdhnb", "䊃"},
	{"fdhoa", "糌"},
	{"fdhoo", "䊴"},
	{"fdhp", "籷"},
	{"fdhqu", "粍"},
	{"fdhuk", "糗"},
	{"fdhvp", "䉻"},
	{"fdiav", "粮"},
	{"fdibi", "糐"},
	{"fdidy", "䊳"},
	{"fdig", "粧"},
	{"fdigi", "𥺁"},
	{"fdiih", "糝"},
	{"fdijb", "䊇"},
	{"fdikh", "糁"},
	{"fdile", "糠"},
	{"fdilr", "糖"},
	{"fdipp", "䊌"},
	{"fdisb", "糄"},
	{"fditc", "䊯"},
	{"fdixp", "麊"},
	{"fdiyr", "𥺦"},
	{"fdj", "籵 㶬"},
	{"fdjbj", "䊖"},
	{"fdjd", "䊉"},
	{"fdjii", "䊜"},
	{"fdjk", "粀"},
	{"fdjkp", "粩"},
	{"fdjmf", "粽"},
	{"fdjmo", "糘"},
	{"fdjr", "䊀"},
	{"fdjrb", "糊"},
	{"fdk", "炔 类"},
	{"fdkde", "䊛"},
	{"fdki", "粏"},
	{"fdknj", "粋"},
	{"fdlc", "㸊"},
	{"fdlnc", "䊧"},
	{"fdlw", "粙"},
	{"fdlwb", "䊘"},
	{"fdlx", "䊥"},
	{"fdm", "㶱 䉺"},
	{"fdma", "粨"},
	{"fdmbb", "糯"},
	{"fdmbc", "頪"},
	{"fdmbl", "粫"},
	{"fdmcw", "粞"},
	{"fdmlk", "粳"},
	{"fdmlm", "𥺼"},
	{"fdmms", "粝"},
	{"fdmq", "溿"},
	{"fdms", "粐"},
	{"fdmtb", "糲"},
	{"fdmua", "糣"},
	{"fdmwg", "糎"},
	{"fdmwj", "䊤"},
	{"fdmwl", "糆"},
	{"fdn", "㐘"},
	{"fdnd", "籽"},
	{"fdng", "粈"},
	{"fdnhd", "糅"},
	{"fdnii", "糨"},
	{"fdniq", "粦"},
	{"fdnir", "䊅"},
	{"fdnj", "籸"},
	{"fdnkq", "䊕"},
	{"fdnl", "粌"},
	{"fdnmm", "糑"},
	{"fdnob", "糈"},
	{"fdog", "䊒"},
	{"fdogf", "𥼚"},
	{"fdoim", "䊱"},
	{"fdok", "敉"},
	{"fdoma", "糩"},
	{"fdomo", "𥽋"},
	{"fdomr", "粭"},
	{"fdon", "籺"},
	{"fdonk", "糇"},
	{"fdopd", "粚"},
	{"fdowy", "䊈"},
	{"fdpfd", "粷"},
	{"fdphh", "粅"},
	{"fdpp", "粃"},
	{"fdqmb", "精"},
	{"fdsfb", "糏"},
	{"fdshi", "籾"},
	{"fdshu", "䊊"},
	{"fdsit", "糮"},
	{"fdsmg", "䊮"},
	{"fdsmv", "粻"},
	{"fdso", "粎"},
	{"fdss", "粔"},
	{"fdtak", "糢"},
	{"fdtaw", "糷"},
	{"fdtbk", "糤"},
	{"fdtbn", "糋"},
	{"fdtc", "粪"},
	{"fdtgf", "糕"},
	{"fdthb", "糒"},
	{"fdtlb", "䊟"},
	{"fdtlk", "䊔"},
	{"fdtm", "粓"},
	{"fdtmc", "粸 䊣"},
	{"fdtmv", "糂"},
	{"fdtop", "糀"},
	{"fdtvg", "糚"},
	{"fdtvi", "糍"},
	{"fdtw", "粬"},
	{"fdtwa", "糟"},
	{"fdtwb", "䊪"},
	{"fdu", "籼"},
	{"fduce", "糉 糭"},
	{"fdv", "籹"},
	{"fdvmg", "䊋"},
	{"fdvne", "粶"},
	{"fdw", "畨"},
	{"fdwd", "粿"},
	{"fdwe", "𥹉"},
	{"fdwf", "煉"},
	{"fdwg", "粴"},
	{"fdwji", "糰"},
	{"fdwla", "糬"},
	{"fdwlv", "糫"},
	{"fdwly", "䊫"},
	{"fdwtc", "糞"},
	{"fdy", "烞"},
	{"fdycb", "䊞"},
	{"fdyhn", "粇"},
	{"fdyhr", "糙 䊚"},
	{"fdyj", "料"},
	{"fdyoj", "粹"},
	{"fdyr", "粘"},
	{"fdyra", "䊰"},
	{"fdyt", "粒"},
	{"fdytu", "糡"},
	{"femvn", "㽊"},
	{"ff", "炎 炏"},
	{"ffb", "焇"},
	{"ffbb", "膋 龦"},
	{"ffbbu", "覮 䁝"},
	{"ffbc", "鎣"},
	{"ffbd", "榮"},
	{"ffbdd", "檾"},
	{"ffbe", "滎"},
	{"ffbf", "熒 爣"},
	{"ffbg", "塋 𤎌"},
	{"ffbhf", "鶯"},
	{"ffbhm", "𤯵"},
	{"ffbhn", "焭"},
	{"ffbhq", "犖"},
	{"ffbkp", "憥"},
	{"ffbks", "勞"},
	{"ffbli", "螢"},
	{"ffbmf", "禜"},
	{"ffbmg", "瑩"},
	{"ffbmn", "甇"},
	{"ffbmr", "䃕"},
	{"ffbmt", "䝁"},
	{"ffbmw", "醟"},
	{"ffbnd", "𡦃"},
	{"ffbnj", "溮"},
	{"ffbou", "罃"},
	{"ffbrr", "營"},
	{"ffbsm", "䎕"},
	{"ffbu", "嵤"},
	{"ffbuu", "覢"},
	{"ffbv", "嫈"},
	{"ffbvf", "縈"},
	{"ffbw", "㽦"},
	{"ffbya", "䪯"},
	{"ffbyr", "謍"},
	{"ffbyv", "褮"},
	{"ffdq", "燐"},
	{"ffe", "燮"},
	{"fff", "焱 爕 㷋 㸉"},
	{"fffd", "燊 爃 𤒇"},
	{"ffff", "燚"},
	{"fffg", "𤍢"},
	{"fffi", "𤑚"},
	{"fffs", "𤏪"},
	{"ffg", "烾"},
	{"ffh", "炒"},
	{"ffhaf", "鶑"},
	{"ffhe", "夑"},
	{"ffhni", "飊"},
	{"ffhqu", "㲜 㲭"},
	{"ffjv", "𡠺"},
	{"ffks", "勬"},
	{"ffln", "剡"},
	{"ffmbc", "纇 顃"},
	{"ffmbo", "颣"},
	{"ffmu", "𤈛"},
	{"ffnem", "㷥"},
	{"ffniq", "㷠"},
	{"ffnj", "㷀"},
	{"ffnl", "郯 䣣"},
	{"ffno", "欻"},
	{"ffog", "熦"},
	{"ffp", "㥕"},
	{"ffye", "敥"},
	{"ffypu", "虩"},
	{"ffyr", "溡"},
	{"fg", "灶"},
	{"fgcc", "爀"},
	{"fgce", "𤊥"},
	{"fgg", "烓"},
	{"fggu", "燒"},
	{"fgit", "熆"},
	{"fglc", "焃"},
	{"fgni", "燽"},
	{"fgnl", "䣘"},
	{"fgqkq", "㷯"},
	{"fgrr", "熺 𤐵"},
	{"fh", "少"},
	{"fha", "𤇢"},
	{"fhaf", "䲴"},
	{"fhag", "煌"},
	{"fhal", "㸅"},
	{"fhau", "㝸"},
	{"fhbi", "烐"},
	{"fhbk", "燠"},
	{"fhbt", "烅"},
	{"fhbu", "省"},
	{"fhbv", "㶶"},
	{"fhd", "秌"},
	{"fhdf", "煂"},
	{"fhdn", "熪"},
	{"fhdw", "燔"},
	{"fhe", "炍"},
	{"fhej", "烽"},
	{"fher", "烙"},
	{"fhey", "炵"},
	{"fhfd", "烀"},
	{"fhge", "燬"},
	{"fhgf", "燻"},
	{"fhgr", "焅"},
	{"fhgs", "㷲"},
	{"fhgu", "烍"},
	{"fhgy", "㸆"},
	{"fhhaf", "䲵"},
	{"fhhl", "㶯"},
	{"fhhqu", "毟"},
	{"fhhw", "熘"},
	{"fhje", "煅"},
	{"fhjg", "煡"},
	{"fhjx", "𤊿"},
	{"fhkb", "燆"},
	{"fhks", "劣"},
	{"fhln", "㓬"},
	{"fhlo", "焮"},
	{"fhml", "炘"},
	{"fhnau", "㝹"},
	{"fhne", "炈"},
	{"fhni", "煈"},
	{"fhnq", "鼡"},
	{"fhon", "烆"},
	{"fhp", "灹 㥹"},
	{"fhpa", "焝"},
	{"fhrf", "熓"},
	{"fhrj", "㷆"},
	{"fhs", "炸"},
	{"fhsb", "煇"},
	{"fhsf", "爋 𤑛"},
	{"fhsk", "燩"},
	{"fhsm", "煽"},
	{"fhsu", "熩"},
	{"fhu", "灮"},
	{"fhuc", "𤓎"},
	{"fhup", "熄"},
	{"fhvd", "烁"},
	{"fhwj", "焷"},
	{"fhwp", "熜"},
	{"fhxg", "㷐"},
	{"fhxu", "𤊓"},
	{"fiav", "烺"},
	{"fibi", "煿"},
	{"fice", "焌"},
	{"fid", "炢"},
	{"fihr", "煠"},
	{"fiib", "𤎜"},
	{"fijb", "烳"},
	{"fikk", "炦"},
	{"file", "𤎖"},
	{"filii", "蠽"},
	{"filo", "焿"},
	{"filr", "煻"},
	{"fiok", "㶼"},
	{"fipf", "爊"},
	{"fipm", "烒"},
	{"fir", "炲"},
	{"fird", "㷘"},
	{"fis", "炉"},
	{"fitc", "燫 爌"},
	{"fitf", "熫"},
	{"fixp", "熝"},
	{"fjbd", "㶿"},
	{"fjbj", "煵"},
	{"fjck", "㷝"},
	{"fjcm", "焢"},
	{"fjcn", "焪"},
	{"fjcr", "熔"},
	{"fjhp", "烢"},
	{"fji", "戦"},
	{"fjkf", "爎"},
	{"fjks", "烤"},
	{"fjmm", "煊"},
	{"fjmu", "烷"},
	{"fjnu", "焥"},
	{"fjp", "炨"},
	{"fjpu", "烧"},
	{"fjrb", "煳"},
	{"fjrr", "熍"},
	{"fjtc", "燌"},
	{"fjtu", "焼"},
	{"fjv", "𤇼"},
	{"fjvd", "炼"},
	{"fjwj", "𤉖"},
	{"fk", "尖"},
	{"fka", "暼"},
	{"fkb", "烠"},
	{"fkbu", "瞥"},
	{"fkc", "鐅"},
	{"fkcf", "燎"},
	{"fkf", "尜"},
	{"fkgg", "煁"},
	{"fkhaf", "鷩"},
	{"fkhqu", "氅"},
	{"fkik", "獘"},
	{"fkkb", "烯 𤉶"},
	{"fklb", "幣"},
	{"fklmi", "蟞"},
	{"fklu", "㷈"},
	{"fkmbc", "類"},
	{"fkmnp", "斃"},
	{"fkn", "彆 㶢"},
	{"fknwf", "鱉"},
	{"fknwm", "鳖"},
	{"fknxu", "龞"},
	{"fkog", "䨆"},
	{"fkp", "憋"},
	{"fkq", "撆"},
	{"fkrau", "鄨"},
	{"fkrxu", "鼈"},
	{"fkryo", "蹩"},
	{"fksb", "熁"},
	{"fksc", "燲"},
	{"fkss", "㶸"},
	{"fkt", "弊 㢢"},
	{"fkv", "嫳"},
	{"fkvif", "䌘"},
	{"flbk", "炴"},
	{"flbu", "㶩"},
	{"flii", "爞"},
	{"flln", "炥"},
	{"flmi", "烛"},
	{"flmo", "烑"},
	{"flmt", "燼"},
	{"fln", "灲"},
	{"flsp", "焖"},
	{"flwv", "熡"},
	{"flx", "熽"},
	{"fm", "灴"},
	{"fmad", "㷞"},
	{"fmam", "烜"},
	{"fmbb", "燸"},
	{"fmbc", "煩"},
	{"fmbg", "㸌"},
	{"fmbi", "燯"},
	{"fmbk", "煗"},
	{"fmbm", "爧"},
	{"fmbo", "烦"},
	{"fmc", "兴"},
	{"fmdm", "爏"},
	{"fme", "㶹"},
	{"fmf", "炋 烣"},
	{"fmhf", "㷧"},
	{"fmj", "㶥"},
	{"fmkr", "㶺"},
	{"fmmr", "焐"},
	{"fmn", "灯"},
	{"fmnjk", "厳"},
	{"fmnr", "炣"},
	{"fmob", "炳"},
	{"fmr", "炻"},
	{"fmrw", "煏"},
	{"fmso", "烼"},
	{"fmtb", "爄"},
	{"fmu", "光"},
	{"fmua", "熸"},
	{"fmvm", "烴"},
	{"fmwf", "熛"},
	{"fmwg", "煙 㷑"},
	{"fmwj", "燂"},
	{"fmym", "炡"},
	{"fnbk", "煥"},
	{"fng", "炄"},
	{"fnhaf", "鵥"},
	{"fnhb", "燏"},
	{"fnhd", "溳"},
	{"fnhe", "𤆣"},
	{"fnhx", "焰"},
	{"fni", "㶤"},
	{"fnib", "㷁"},
	{"fnin", "㶦 㶴"},
	{"fnkg", "烶"},
	{"fnkm", "烻"},
	{"fnkq", "煒"},
	{"fnl", "邩"},
	{"fnla", "焔"},
	{"fno", "炊"},
	{"fnom", "烃"},
	{"fnot", "燈"},
	{"fnq", "揱"},
	{"fnqd", "𤌴"},
	{"fnsh", "炀"},
	{"fnvif", "𦂗"},
	{"fo", "尐"},
	{"fob", "㶧"},
	{"fobg", "𤌍"},
	{"fod", "烌"},
	{"fog", "焳 雀"},
	{"fogf", "燋"},
	{"fogs", "㷪"},
	{"foii", "炩"},
	{"foip", "焾"},
	{"foir", "焓 熗"},
	{"fok", "炇"},
	{"foll", "炌"},
	{"foma", "燴"},
	{"fomb", "爚 㷍"},
	{"fomg", "烇"},
	{"fomi", "烩"},
	{"fomo", "㷿"},
	{"fomr", "烚"},
	{"fond", "熂"},
	{"foomb", "䶴"},
	{"fop", "炛"},
	{"fopd", "炧"},
	{"fopj", "烨"},
	{"form", "熻"},
	{"fosu", "炝"},
	{"fotf", "㷻"},
	{"fowy", "烸"},
	{"fpa", "㶷"},
	{"fpd", "灺"},
	{"fpi", "灼"},
	{"fpim", "𤆥"},
	{"fpkp", "㷓"},
	{"fppa", "煯"},
	{"fpru", "炮"},
	{"fptd", "滐"},
	{"fpu", "炖"},
	{"fpuu", "煼"},
	{"fq", "半"},
	{"fqbu", "眷"},
	{"fqbuu", "䚏"},
	{"fqd", "桊"},
	{"fqdmq", "韏"},
	{"fqe", "𣳾"},
	{"fqhd", "䅈"},
	{"fqhe", "叛"},
	{"fqhml", "斴"},
	{"fqhq", "牶"},
	{"fqiav", "飬"},
	{"fqj", "炐"},
	{"fqks", "劵"},
	{"fqlb", "帣"},
	{"fqll", "奍"},
	{"fqlmi", "䖭"},
	{"fqln", "判 㔂"},
	{"fqmbc", "頖"},
	{"fqmmf", "䄅"},
	{"fqmso", "豢"},
	{"fqmvn", "甐"},
	{"fqn", "弮"},
	{"fqnbg", "觠"},
	{"fqnl", "鄰"},
	{"fqnwf", "鮝"},
	{"fqnwm", "鲞"},
	{"fqoc", "㸇"},
	{"fqoiv", "餋"},
	{"fqq", "拳"},
	{"fqs", "炜"},
	{"fqsh", "券"},
	{"fqsmm", "翷"},
	{"fqsqf", "駦"},
	{"fqsu", "卷"},
	{"fqu", "亃"},
	{"fqvif", "絭"},
	{"fqvv", "粼"},
	{"fqvvv", "𥻘"},
	{"fqyj", "㪵"},
	{"fqymr", "誊"},
	{"fqymu", "齤"},
	{"frb", "焆"},
	{"frbc", "熉"},
	{"frc", "炽"},
	{"frhu", "炾"},
	{"frik", "獣"},
	{"frob", "㶽"},
	{"frp", "㕾"},
	{"frr", "焒"},
	{"frrd", "燥"},
	{"frrj", "燀"},
	{"frrr", "煢"},
	{"fruc", "㷷"},
	{"frye", "煆"},
	{"fsd", "㮡"},
	{"fseg", "熞"},
	{"fsei", "爥"},
	{"fsh", "灱"},
	{"fshr", "炤"},
	{"fsit", "爁"},
	{"fsjj", "㸎"},
	{"fsjr", "𤉸"},
	{"fskr", "𤉙"},
	{"fsll", "烥"},
	{"fsln", "㓥"},
	{"fsm", "当"},
	{"fsma", "熠"},
	{"fsmb", "㷌"},
	{"fsmg", "燿"},
	{"fsmh", "熮"},
	{"fsmi", "燖"},
	{"fsmt", "熤"},
	{"fsmv", "㷃"},
	{"fsoy", "烬"},
	{"fsrr", "熰"},
	{"fss", "炬"},
	{"fssr", "焗"},
	{"fstt", "𤋊"},
	{"fsuu", "煀"},
	{"fswu", "爦"},
	{"fsyi", "爥"},
	{"ft", "灷"},
	{"fta", "焟"},
	{"ftak", "㷬"},
	{"ftaw", "爤"},
	{"ftbf", "𤐄"},
	{"ftbn", "㷙"},
	{"ftc", "烘 烡"},
	{"ftcd", "㸁"},
	{"ftce", "爜"},
	{"ftcl", "燍"},
	{"ftcw", "煔"},
	{"ftgi", "燨"},
	{"ftgq", "㷣"},
	{"ftgr", "㷽"},
	{"ftgs", "爔"},
	{"ftja", "𤏸"},
	{"ftk", "烪"},
	{"ftlf", "𤒈"},
	{"ftlj", "煣"},
	{"ftlk", "煸"},
	{"ftlo", "熯"},
	{"ftlx", "𤑳"},
	{"ftm", "㶰"},
	{"ftmc", "熿 𤊄"},
	{"ftmd", "煤"},
	{"ftmj", "燁"},
	{"ftmm", "烂"},
	{"ftmv", "滊"},
	{"ftob", "焫"},
	{"ftof", "爑"},
	{"ftpi", "烵"},
	{"ftpo", "煫"},
	{"ftpp", "燪"},
	{"ftq", "烊"},
	{"ftqu", "𤏲"},
	{"ftrg", "爟"},
	{"fttb", "煹"},
	{"ftwa", "㷮"},
	{"ftwb", "燤"},
	{"ftwi", "燇"},
	{"ftwr", "𤌚"},
	{"ftwv", "燶"},
	{"ftxc", "熑"},
	{"ftyj", "㷹"},
	{"fu", "灿"},
	{"fua", "𣆤 𣆥"},
	{"fuap", "熴"},
	{"fuapp", "尡"},
	{"fubjj", "輝"},
	{"fubkq", "辉"},
	{"fubuu", "䚇"},
	{"fudmq", "韑"},
	{"fuhag", "𤾗"},
	{"fuhj", "㷨"},
	{"fuhuc", "𧹍"},
	{"fuitc", "兤"},
	{"fujcm", "䆪"},
	{"fuks", "勌"},
	{"fumb", "煪"},
	{"fumt", "𤍈"},
	{"fumvn", "㼳"},
	{"fuog", "熣"},
	{"fusma", "𦒉"},
	{"fusmg", "耀"},
	{"futlc", "黋"},
	{"futmj", "㒯"},
	{"fuu", "炪"},
	{"fvid", "爍"},
	{"fvis", "㶭"},
	{"fvok", "数"},
	{"fvvv", "爉"},
	{"fw", "畑"},
	{"fwb", "煲"},
	{"fwd", "巣 㷄"},
	{"fwgf", "㷵"},
	{"fwgg", "爅"},
	{"fwhvo", "㼕"},
	{"fwj", "単"},
	{"fwjc", "𤎽"},
	{"fwk", "烟"},
	{"fwkp", "煾"},
	{"fwl", "炠"},
	{"fwlb", "㷒"},
	{"fwlg", "𤓓"},
	{"fwli", "燭"},
	{"fwlj", "燡"},
	{"fwln", "劏"},
	{"fwmbc", "顲"},
	{"fwmv", "煨"},
	{"fwmvn", "㽆"},
	{"fwot", "熅"},
	{"fwtc", "熼"},
	{"fwtj", "熚 𤒹"},
	{"fyaj", "焯"},
	{"fyav", "煺"},
	{"fybc", "𤋺"},
	{"fybp", "爖"},
	{"fycb", "熵"},
	{"fyck", "烄 㷜"},
	{"fydk", "燉"},
	{"fyed", "燦"},
	{"fyev", "爘"},
	{"fyg", "炷"},
	{"fygq", "燵"},
	{"fyhj", "熢"},
	{"fyhn", "炕"},
	{"fyhr", "㷟"},
	{"fyia", "熾"},
	{"fyib", "焴"},
	{"fyj", "炓"},
	{"fyk", "炆"},
	{"fynb", "熥"},
	{"fyoj", "焠"},
	{"fyok", "焲"},
	{"fypo", "㷾"},
	{"fypp", "爈"},
	{"fypt", "爐"},
	{"fyr", "炶"},
	{"fyrb", "熇"},
	{"fyrd", "焞"},
	{"fyrg", "㸀"},
	{"fyrn", "㷚"},
	{"fyro", "𤐶"},
	{"fyru", "煷"},
	{"fyrv", "爙"},
	{"fysg", "𤍣"},
	{"fytg", "燑"},
	{"fyti", "㸍"},
	{"fytj", "𤍤"},
	{"fyto", "燧"},
	{"fytp", "燱"},
	{"fytr", "焙"},
	{"fyub", "㷰"},
	{"fyvi", "炫"},
	{"fyvo", "烗"},
	{"fywd", "燣"},
	{"fywf", "燷"},
	{"fyx", "㸄"},
	{"fyy", "炞"},
	{"g", "土"},
	{"gadi", "埘"},
	{"gag", "㘿"},
	{"gagi", "塒"},
	{"gah", "声"},
	{"gahu", "堳"},
	{"gam", "坦"},
	{"gamh", "場"},
	{"gami", "壜"},
	{"gamj", "垾"},
	{"gamo", "堤"},
	{"gana", "墹"},
	{"ganx", "壛"},
	{"gaph", "埸"},
	{"gapp", "堒"},
	{"gapv", "堨"},
	{"gasm", "塌"},
	{"gav", "垠"},
	{"gavf", "㙷"},
	{"gawe", "墁"},
	{"gb", "冉"},
	{"gbac", "塓"},
	{"gbb", "堋"},
	{"gbbr", "堝"},
	{"gbcd", "堔 𡑕"},
	{"gbcr", "埛"},
	{"gbd", "埰"},
	{"gbdi", "埒"},
	{"gbhn", "壳"},
	{"gbhne", "觳 㱿 䐨"},
	{"gbhp", "悫"},
	{"gbhu", "坈 売"},
	{"gbhx", "塪"},
	{"gbjj", "堚"},
	{"gblm", "壺"},
	{"gbm", "坥"},
	{"gbmc", "埧"},
	{"gbmd", "槖"},
	{"gbmm", "壼"},
	{"gbmo", "塚 塜"},
	{"gbmr", "垌"},
	{"gbmri", "蠧"},
	{"gbmt", "壹"},
	{"gbnd", "垺"},
	{"gbnxu", "䶲"},
	{"gbo", "坝"},
	{"gbp", "壱"},
	{"gbr", "坰"},
	{"gbsd", "埩"},
	{"gbsmm", "䎃"},
	{"gbtc", "壶"},
	{"gbtu", "堈"},
	{"gbuc", "垻"},
	{"gbul", "䵺"},
	{"gbut", "㚃"},
	{"gbuu", "垷"},
	{"gbwo", "㚄"},
	{"gby", "坍"},
	{"gcbmr", "䞒"},
	{"gcbuu", "覿 䚂"},
	{"gccr", "﨏"},
	{"gcdhe", "皾"},
	{"gcg", "坴"},
	{"gcglc", "赫"},
	{"gche", "夌"},
	{"gcilr", "赯"},
	{"gcim", "塕"},
	{"gcjka", "赭"},
	{"gclmi", "赨"},
	{"gcm", "䞑"},
	{"gcmbb", "䞕"},
	{"gcmbc", "頳"},
	{"gcmvm", "䞓"},
	{"gcnau", "赩"},
	{"gcnl", "郝"},
	{"gcno", "赥"},
	{"gco", "赱"},
	{"gcok", "赦"},
	{"gcru", "㙂"},
	{"gcrxu", "鼀"},
	{"gcrye", "赮"},
	{"gcsh", "坋"},
	{"gcshu", "䞔"},
	{"gcsle", "赧"},
	{"gcv", "丧"},
	{"gcwa", "增"},
	{"gcwr", "啬"},
	{"gcybc", "赬"},
	{"gcybo", "赪"},
	{"gdhe", "坡"},
	{"gdhne", "榖 穀 糓 㝅"},
	{"gdi", "寺"},
	{"gdk", "块"},
	{"gdmq", "㙔"},
	{"gdw", "埬"},
	{"gdwf", "堜"},
	{"gebu", "瞽"},
	{"gec", "鏧 䥢"},
	{"ged", "㯏"},
	{"gee", "漀"},
	{"geea", "䶁"},
	{"geee", "㙍"},
	{"geeii", "鼜"},
	{"gef", "㷫"},
	{"gefbg", "鼞"},
	{"gegi", "䵽"},
	{"geha", "㿦"},
	{"gehd", "䅽"},
	{"gehda", "馨"},
	{"gehey", "鼕 㲇"},
	{"gehhj", "鼙"},
	{"gehkb", "毊"},
	{"gehor", "鼛"},
	{"geid", "墚"},
	{"gejwj", "䡰"},
	{"gelmi", "螜"},
	{"gelxl", "鼘"},
	{"gemr", "磬"},
	{"genot", "鼟"},
	{"geoii", "㲆"},
	{"geoju", "罄"},
	{"geomr", "䶀"},
	{"gep", "愨 慤 𢡱"},
	{"geq", "撀"},
	{"geshr", "㲈"},
	{"gesj", "聲"},
	{"gesmv", "鼚"},
	{"geymr", "謦"},
	{"geyr", "䵿"},
	{"geyta", "韾"},
	{"gf", "灻"},
	{"gfbr", "埫"},
	{"gfbuu", "𧡘"},
	{"gfbw", "壋"},
	{"gfcb", "塉"},
	{"gff", "埮"},
	{"gfhne", "縠 鷇 㷤"},
	{"gfle", "隷"},
	{"gfmu", "垙"},
	{"gfno", "款"},
	{"gfq", "坢"},
	{"gfqg", "堘"},
	{"gfqu", "埢"},
	{"gfsm", "垱"},
	{"gg", "圭"},
	{"ggb", "㘱"},
	{"ggbt", "㙪"},
	{"ggce", "堎"},
	{"ggcw", "墙"},
	{"ggdi", "封"},
	{"ggff", "燅"},
	{"ggg", "垚 𡋣"},
	{"gggcg", "龳"},
	{"gggg", "㙓"},
	{"gggog", "𡓨"},
	{"gggu", "堯 墝"},
	{"gghaf", "鵱 䳏"},
	{"gghne", "瑴 㲄"},
	{"ggkni", "埶"},
	{"ggks", "勎"},
	{"gglmi", "䖯"},
	{"ggln", "刲"},
	{"ggni", "壔"},
	{"ggnl", "邽"},
	{"ggno", "㰪"},
	{"ggow", "墻"},
	{"ggp", "恚"},
	{"ggrau", "郌"},
	{"ggrxu", "鼃 䵷"},
	{"ggy", "卦"},
	{"ggye", "㪈"},
	{"ghad", "𡏭"},
	{"ghaf", "䲧"},
	{"ghag", "堭"},
	{"ghbd", "㙾"},
	{"ghbk", "墺"},
	{"ghbr", "垧"},
	{"ghbu", "垍"},
	{"ghdp", "塖"},
	{"ghdw", "墦"},
	{"ghe", "坂"},
	{"ghej", "埄"},
	{"gher", "垎"},
	{"ghfd", "垀"},
	{"ghgf", "壎"},
	{"ghgr", "𡌃"},
	{"ghhi", "塮"},
	{"ghhj", "埤"},
	{"ghhne", "殸"},
	{"ghhw", "塯"},
	{"ghi", "塊"},
	{"ghj", "圲"},
	{"ghje", "塅"},
	{"ghjg", "堹"},
	{"ghjm", "埵"},
	{"ghkb", "墧"},
	{"ghlb", "㙖"},
	{"ghlmi", "蟚"},
	{"ghml", "圻"},
	{"ghmr", "垢"},
	{"ghmvn", "甏"},
	{"ghmy", "坼"},
	{"ghnd", "垛"},
	{"ghne", "坄"},
	{"ghni", "堸"},
	{"ghon", "垳"},
	{"ghoo", "㙡"},
	{"ghor", "㙮"},
	{"ghp", "圫"},
	{"ghpm", "坻"},
	{"ghqu", "㘪"},
	{"ghrf", "塢"},
	{"ghrj", "埠"},
	{"ghrr", "垖"},
	{"ghsk", "墽"},
	{"ghu", "圥"},
	{"ghud", "㙞"},
	{"ghvo", "坬"},
	{"ghvp", "坁"},
	{"ghxu", "堄"},
	{"gi", "去"},
	{"gia", "暬"},
	{"giapv", "朅"},
	{"giav", "埌"},
	{"gibi", "㙛"},
	{"gibt", "盍"},
	{"gibuc", "贄 䞇"},
	{"gic", "䥍"},
	{"gice", "埈"},
	{"gid", "槷"},
	{"gie", "漐"},
	{"gif", "熱"},
	{"gig", "墊"},
	{"gihab", "幫"},
	{"gihaf", "鷙"},
	{"gihf", "墄"},
	{"gihp", "㙳"},
	{"gihq", "煓"},
	{"gihr", "堿"},
	{"gihs", "城"},
	{"gihui", "魗"},
	{"gihv", "㙎"},
	{"giib", "㙟"},
	{"giih", "墋"},
	{"gijb", "埔"},
	{"gikk", "坺"},
	{"gikp", "垅"},
	{"giks", "劫 勢"},
	{"gilb", "墉"},
	{"gile", "𡐓"},
	{"gili", "𡌺"},
	{"gilmi", "蟄"},
	{"giln", "刦"},
	{"gilr", "塘"},
	{"gimbc", "䪺"},
	{"gimmi", "㙯"},
	{"ginl", "邿 𨚫"},
	{"ginn", "垿"},
	{"gino", "㰦"},
	{"ginwf", "䲀"},
	{"giok", "埃"},
	{"gip", "慹"},
	{"giq", "摯 摰 㨍"},
	{"gir", "坮"},
	{"girm", "域"},
	{"girp", "唟"},
	{"girxu", "鼁"},
	{"giryo", "䠟"},
	{"gish", "刧"},
	{"gishi", "刼"},
	{"gisl", "却"},
	{"gisle", "叝"},
	{"gismm", "翿"},
	{"gisqf", "騺"},
	{"gist", "墭"},
	{"git", "弆"},
	{"gitc", "壙"},
	{"gitf", "墌"},
	{"gitlj", "鞤"},
	{"giv", "㜂"},
	{"givif", "縶"},
	{"giwg", "㙻"},
	{"gixp", "塶"},
	{"giyhv", "褺"},
	{"giymr", "謺"},
	{"giypu", "䖔"},
	{"gjbc", "填"},
	{"gjbj", "𡎜"},
	{"gjbm", "埴"},
	{"gjbv", "㚂"},
	{"gjc", "坹"},
	{"gjck", "堗"},
	{"gjcm", "埪"},
	{"gjcn", "㙀"},
	{"gjcr", "塎"},
	{"gjdi", "垨"},
	{"gjhne", "轂"},
	{"gjhp", "垞"},
	{"gjhvo", "瑗"},
	{"gjii", "塼"},
	{"gjjn", "墘"},
	{"gjka", "堵"},
	{"gjki", "㙆"},
	{"gjkni", "執"},
	{"gjkr", "𡏾"},
	{"gjks", "㘼"},
	{"gjmd", "㘾"},
	{"gjmm", "塇"},
	{"gjmn", "坾"},
	{"gjmo", "埞"},
	{"gjmu", "垸"},
	{"gjmvn", "㼬"},
	{"gjnu", "埦"},
	{"gjp", "坨"},
	{"gjsle", "報"},
	{"gjtc", "墳"},
	{"gjv", "垵"},
	{"gjwj", "𡌄"},
	{"gjwv", "壊"},
	{"gka", "𣊁"},
	{"gkbt", "盩"},
	{"gkbuc", "贅"},
	{"gkc", "鏊"},
	{"gkcf", "㙩"},
	{"gkf", "熬"},
	{"gkhaf", "鷔"},
	{"gkhne", "㺉"},
	{"gkik", "獒"},
	{"gkkk", "塽"},
	{"gklb", "㘵"},
	{"gklmi", "螫 螯"},
	{"gklu", "埯"},
	{"gkma", "㙽"},
	{"gkmb", "堶"},
	{"gkmr", "埼"},
	{"gkms", "垮"},
	{"gknwf", "鰲"},
	{"gkoo", "埉"},
	{"gkpb", "墆"},
	{"gkq", "摮"},
	{"gkrxu", "鼇"},
	{"gks", "㘦"},
	{"gksb", "㙝"},
	{"gksj", "聱"},
	{"gksqf", "驁"},
	{"gku", "嶅"},
	{"gkymr", "謷"},
	{"glbk", "坱"},
	{"gle", "埭"},
	{"glhne", "㲉"},
	{"glll", "圳"},
	{"glln", "坲"},
	{"glmc", "墤"},
	{"glmo", "垗"},
	{"glmt", "壗"},
	{"glnc", "赤"},
	{"glq", "垏"},
	{"glwl", "坤"},
	{"glwv", "塿"},
	{"glx", "㙌"},
	{"gmam", "垣"},
	{"gmbb", "壖 壩"},
	{"gmbi", "墵"},
	{"gmbk", "堧"},
	{"gmc", "鋆"},
	{"gmd", "圩"},
	{"gmdm", "壢"},
	{"gmf", "坏"},
	{"gmfj", "坪"},
	{"gmfm", "坯"},
	{"gmgg", "堐"},
	{"gmgi", "𡊩"},
	{"gmhf", "塬"},
	{"gmig", "垤"},
	{"gmjk", "𡑒"},
	{"gmks", "坜"},
	{"gmlk", "埂"},
	{"gmlm", "埡"},
	{"gmlw", "㙧"},
	{"gmmi", "坛"},
	{"gmms", "圬"},
	{"gmmu", "坃"},
	{"gmn", "圢"},
	{"gmnr", "坷"},
	{"gmr", "坧"},
	{"gmrb", "塥"},
	{"gmrw", "堛"},
	{"gmso", "㙇"},
	{"gmtc", "垭"},
	{"gmto", "㙭"},
	{"gmvm", "坘"},
	{"gmwd", "塛"},
	{"gmwf", "墂"},
	{"gmwg", "堙"},
	{"gmwj", "墰"},
	{"gmwm", "壃"},
	{"gmwv", "㙘"},
	{"gmy", "圷"},
	{"gmyf", "墕"},
	{"gn", "㐊 㐋"},
	{"gnbg", "埆"},
	{"gncr", "㙴"},
	{"gnhe", "圾"},
	{"gnhne", "彀 殼"},
	{"gnhx", "埳"},
	{"gnib", "埇"},
	{"gnin", "垑 㘧"},
	{"gnkm", "埏"},
	{"gnmf", "燾"},
	{"gnmi", "壽"},
	{"gnmp", "㦞"},
	{"gnmu", "垝"},
	{"gno", "坎"},
	{"gnob", "壻"},
	{"gnoe", "墢"},
	{"gnot", "墱"},
	{"gnsd", "垜"},
	{"gnsh", "场"},
	{"gnsv", "㙣"},
	{"gnui", "堍"},
	{"go", "圦"},
	{"goae", "㙏"},
	{"goah", "塲"},
	{"goam", "䞡"},
	{"goamh", "䞶 𧼮"},
	{"goamj", "趕"},
	{"goamo", "趧"},
	{"goawe", "䟂"},
	{"gob", "㘨"},
	{"gobm", "趄"},
	{"gobnd", "䞯"},
	{"gobqr", "䞴"},
	{"goc", "趛 䤰"},
	{"gocor", "䞱"},
	{"godh", "䞗"},
	{"godi", "坿"},
	{"godk", "赽"},
	{"godl", "趚"},
	{"goeee", "䞵"},
	{"gofb", "趙"},
	{"gofbr", "趟"},
	{"gofh", "赻"},
	{"gog", "堆"},
	{"gogd", "㙫"},
	{"gogg", "䞨"},
	{"goggu", "趬"},
	{"goglc", "䞰"},
	{"gogr", "趌"},
	{"goha", "䞟"},
	{"gohag", "䞹"},
	{"gohds", "䞬"},
	{"goher", "䞦"},
	{"gohjd", "趎"},
	{"gohjr", "趏"},
	{"gohju", "䞺"},
	{"gohkb", "趫"},
	{"gohml", "赾"},
	{"gohmr", "䞧"},
	{"gohmy", "䞣"},
	{"gohnd", "趓"},
	{"gohne", "豰"},
	{"gohqi", "䞲"},
	{"gohqo", "趃"},
	{"gohuc", "趲"},
	{"gohuo", "趱"},
	{"gohus", "䟍"},
	{"gohvi", "趆"},
	{"gohvp", "赿"},
	{"gohyu", "䞾"},
	{"goi", "㘺"},
	{"goice", "䞭"},
	{"goii", "坽"},
	{"goiih", "䟃"},
	{"goik", "垘"},
	{"goimo", "趑"},
	{"goin", "坅"},
	{"goior", "趦"},
	{"goip", "埝 䞖"},
	{"goiv", "越"},
	{"gojbf", "䞽"},
	{"goje", "䞚"},
	{"gojig", "䟈 䟌"},
	{"gojmr", "趤"},
	{"gok", "坆 赵"},
	{"gokb", "䞥"},
	{"goks", "赲 㘯"},
	{"goll", "圿"},
	{"golln", "䞞"},
	{"golmo", "趒"},
	{"golxh", "趀"},
	{"gom", "坵"},
	{"gomb", "埨"},
	{"gomc", "㙃"},
	{"gomf", "䞜"},
	{"gomfb", "趰"},
	{"gomgi", "䞝"},
	{"gomhm", "䟐"},
	{"gomj", "赶"},
	{"gomlb", "䞙"},
	{"gomls", "䞛"},
	{"gommr", "䞸"},
	{"gomn", "堬"},
	{"gomnn", "趔"},
	{"gomr", "垥 䞠"},
	{"gon", "圪"},
	{"gonbs", "䞻"},
	{"goncr", "䟋"},
	{"gonf", "趂"},
	{"gonin", "趍"},
	{"gonk", "堠"},
	{"gono", "赼"},
	{"gonsm", "趋"},
	{"goo", "龪"},
	{"goog", "趡"},
	{"googf", "趭"},
	{"goohh", "趁"},
	{"gooin", "赺"},
	{"gooip", "趝"},
	{"goomb", "䟑"},
	{"goomd", "䞮"},
	{"goomr", "䞩"},
	{"goon", "䞘"},
	{"gooog", "趖"},
	{"goos", "䞢"},
	{"goov", "䘮"},
	{"gopfd", "趜"},
	{"gopim", "赹"},
	{"gopr", "䞤"},
	{"gopuu", "趨"},
	{"goqmc", "䟄"},
	{"goqoc", "䟎"},
	{"gord", "堢"},
	{"gorrd", "趮"},
	{"gort", "塩"},
	{"goru", "起"},
	{"gorw", "墖"},
	{"goryo", "趗"},
	{"goshl", "䞪"},
	{"goshr", "超"},
	{"goshu", "趘"},
	{"gosje", "趣"},
	{"goskr", "䞫"},
	{"gosmg", "趯"},
	{"gosmm", "趐"},
	{"gosuu", "䞷"},
	{"gota", "趞"},
	{"gotcw", "趥"},
	{"gotf", "墲"},
	{"gotmc", "趪"},
	{"goto", "㙸"},
	{"gotqm", "䟀"},
	{"gotrg", "䟒"},
	{"gou", "赸"},
	{"gouu", "趉"},
	{"govid", "䟏"},
	{"govii", "䟇"},
	{"govl", "赳"},
	{"govne", "趢"},
	{"govno", "䞼"},
	{"govvd", "䟁"},
	{"gowli", "䟉"},
	{"gowr", "嗇"},
	{"gowtc", "趩"},
	{"gowtj", "䟆"},
	{"gowy", "㙁"},
	{"goy", "赴"},
	{"goyaj", "趠"},
	{"goyj", "﨣"},
	{"goypo", "䟊"},
	{"goyr", "趈"},
	{"goyt", "趇"},
	{"goytr", "䞳"},
	{"gp", "志"},
	{"gpbc", "塡"},
	{"gpbuu", "覟"},
	{"gpd", "地"},
	{"gphh", "圽"},
	{"gpi", "圴 㘬"},
	{"gpim", "均"},
	{"gpmm", "堩"},
	{"gpp", "㘩"},
	{"gppa", "堦"},
	{"gppg", "㙄"},
	{"gpr", "坸"},
	{"gpru", "垉"},
	{"gptd", "堞"},
	{"gpu", "坉"},
	{"gpvm", "坞"},
	{"gqhf", "𡐤"},
	{"gqhne", "毂 㨌"},
	{"gqjl", "垹"},
	{"gqka", "堾"},
	{"gqkq", "埲"},
	{"gqmb", "埥"},
	{"gqmf", "塐"},
	{"gr", "吉"},
	{"grb", "埍"},
	{"grbc", "塤"},
	{"grbg", "臺"},
	{"grbo", "埙"},
	{"grd", "㙅"},
	{"grgr", "喆"},
	{"grgrr", "嚞 囍"},
	{"grhaf", "鴶 𪇟"},
	{"grhg", "埕"},
	{"grhne", "嗀 嗀"},
	{"grhv", "袁"},
	{"grks", "劼 㔛"},
	{"grln", "㓤"},
	{"grmbc", "頡"},
	{"grmbo", "颉"},
	{"grmfm", "噽"},
	{"grmfr", "嚭"},
	{"grmvn", "㼭"},
	{"grnl", "郆"},
	{"grno", "欯 歖"},
	{"grob", "埚"},
	{"grp", "憙"},
	{"grrj", "墠"},
	{"grrk", "壧"},
	{"grrs", "堮"},
	{"grrv", "喪"},
	{"grsj", "𡎎"},
	{"grsmm", "翓"},
	{"grt", "壴"},
	{"grtf", "熹"},
	{"grtr", "喜 嘉"},
	{"gru", "圯 㐖"},
	{"grvp", "垊"},
	{"grye", "敼"},
	{"gsav", "堰"},
	{"gseg", "𡐖"},
	{"gsfi", "墛"},
	{"gsit", "壏"},
	{"gsjt", "壣"},
	{"gskn", "㘲"},
	{"gsl", "壭"},
	{"gslc", "㙺"},
	{"gsmb", "埽"},
	{"gsme", "埐"},
	{"gsmr", "䂲"},
	{"gsmv", "㙊"},
	{"gso", "㘮"},
	{"gsok", "敖"},
	{"gsp", "坭"},
	{"gsrj", "壀"},
	{"gsrr", "塸"},
	{"gssu", "垇"},
	{"gstt", "塀"},
	{"gsu", "圮 𡉏"},
	{"gsuu", "堀"},
	{"gsyq", "墀"},
	{"gtak", "塻"},
	{"gtbc", "㙉"},
	{"gtc", "垬"},
	{"gtco", "墣"},
	{"gtcp", "塨"},
	{"gtct", "塧"},
	{"gtcu", "塂"},
	{"gtdhe", "皷"},
	{"gtdi", "尌"},
	{"gtgq", "㙚"},
	{"gtgr", "墡"},
	{"gtgs", "㙿"},
	{"gtgt", "壒"},
	{"gthaf", "鷧"},
	{"gthf", "𡓽"},
	{"gthhh", "彭"},
	{"gtiop", "懿"},
	{"gtior", "𡄻"},
	{"gtiov", "𡤜"},
	{"gtj", "幸"},
	{"gtja", "墸"},
	{"gtje", "鼓"},
	{"gtk", "㘷"},
	{"gtlb", "㙢"},
	{"gtlk", "𡎘"},
	{"gtlm", "墐"},
	{"gtm", "坩"},
	{"gtmbc", "䫦"},
	{"gtmc", "墴 㙋"},
	{"gtmj", "墷"},
	{"gtmv", "堪"},
	{"gtno", "㰻 㱅"},
	{"gtnop", "㦤"},
	{"gtol", "𡏆"},
	{"gtop", "埖"},
	{"gtor", "塔"},
	{"gtov", "𡒶"},
	{"gtq", "垟"},
	{"gtrg", "壦"},
	{"gtss", "壾"},
	{"gtt", "垪 㘫"},
	{"gttc", "𡌶"},
	{"gtu", "亄"},
	{"gtvs", "墈"},
	{"gtwi", "墫 壿"},
	{"gtwim", "𧰒"},
	{"gtwn", "㙹"},
	{"gtye", "鼔"},
	{"gtyu", "塃"},
	{"gu", "圠"},
	{"gubb", "塴"},
	{"guce", "堫"},
	{"gudi", "𡭄"},
	{"guggu", "㚁"},
	{"guhaf", "䴃"},
	{"guhne", "瞉 䍍"},
	{"gumb", "㙐"},
	{"gumbc", "顤"},
	{"gumj", "堓"},
	{"gumt", "塏"},
	{"guog", "墔"},
	{"guon", "埁"},
	{"gusmm", "翹"},
	{"gusu", "垲"},
	{"guye", "𢿣"},
	{"gvfn", "壪"},
	{"gvhne", "㜌"},
	{"gvii", "㙨"},
	{"gvis", "坳 㘭"},
	{"gvno", "堟"},
	{"gvvw", "堖"},
	{"gw", "𡊰"},
	{"gwb", "㙕"},
	{"gwbt", "䀋"},
	{"gwd", "堁"},
	{"gwg", "埋"},
	{"gwj", "毐"},
	{"gwjr", "堌"},
	{"gwk", "㘻"},
	{"gwlb", "堣"},
	{"gwlc", "賣"},
	{"gwlj", "墿"},
	{"gwlm", "堽"},
	{"gwls", "塄"},
	{"gwlw", "夁"},
	{"gwmv", "㙗"},
	{"gwno", "㱇"},
	{"gwol", "堺"},
	{"gwot", "塭"},
	{"gwww", "㙼"},
	{"gwyi", "坶"},
	{"gy", "圤"},
	{"gybp", "壠"},
	{"gybs", "塝"},
	{"gybt", "盐"},
	{"gycb", "墑 墒"},
	{"gycn", "塆"},
	{"gycv", "壌 㙥"},
	{"gydk", "墩"},
	{"gydl", "墎"},
	{"gyfe", "埱"},
	{"gygj", "𡐿"},
	{"gygq", "墶"},
	{"gyhj", "塳"},
	{"gyhn", "坑"},
	{"gyhr", "塠"},
	{"gyhs", "坊"},
	{"gyib", "堉"},
	{"gyj", "㘰"},
	{"gyk", "坟"},
	{"gylc", "壝"},
	{"gylh", "埗"},
	{"gylm", "址"},
	{"gym", "圵"},
	{"gymy", "垰"},
	{"gyo", "走"},
	{"gyoj", "埣"},
	{"gypd", "㙤"},
	{"gypm", "墟"},
	{"gypo", "壉"},
	{"gypt", "壚"},
	{"gypu", "㙈"},
	{"gyr", "坫"},
	{"gyrb", "塙"},
	{"gyrd", "埻"},
	{"gyrg", "㙵"},
	{"gyro", "壕"},
	{"gyrv", "壤"},
	{"gys", "垆"},
	{"gyt", "垃"},
	{"gyta", "堷"},
	{"gytg", "墥"},
	{"gyti", "㚀"},
	{"gytj", "垶 墇"},
	{"gytr", "培"},
	{"gytu", "境"},
	{"gyuk", "垴"},
	{"gyvg", "㙲"},
	{"gyvi", "𡊨"},
	{"gyvo", "垓"},
	{"gywd", "壈"},
	{"gywi", "塷"},
	{"gywm", "壇"},
	{"gywv", "壞"},
	{"h", "竹"},
	{"ha", "白"},
	{"haamj", "皔"},
	{"haapv", "馤 㿣"},
	{"haau", "皅"},
	{"habbe", "皧"},
	{"habgr", "皗"},
	{"habnd", "馟"},
	{"habwi", "皭"},
	{"hac", "㒵"},
	{"hacsh", "馚"},
	{"hadj", "皌"},
	{"hae", "泉"},
	{"hafbf", "㿩 䭱"},
	{"hafhh", "㣎"},
	{"hafmu", "㿠"},
	{"haggu", "皢"},
	{"hagni", "㿧"},
	{"haha", "㿟"},
	{"hahaa", "皛 馫"},
	{"hahaf", "䳆"},
	{"hahag", "皨"},
	{"hahaj", "皞 皡"},
	{"hahdw", "皤"},
	{"hahe", "皈"},
	{"hahgr", "皓"},
	{"hahi", "魄"},
	{"hahm", "篂"},
	{"hahqi", "皒"},
	{"hahqu", "㿞"},
	{"hahsk", "皦"},
	{"hahu", "皃"},
	{"hahud", "𤾚"},
	{"hahuj", "皥"},
	{"hahuk", "𩡗"},
	{"hahxu", "𤾆"},
	{"hai", "㿝"},
	{"haii", "馢"},
	{"haikk", "馛"},
	{"hail", "節"},
	{"haioj", "皐"},
	{"haipf", "皫"},
	{"haj", "皁"},
	{"hajbd", "馞"},
	{"hajd", "𤽜"},
	{"hajmc", "馪"},
	{"hajmu", "皖"},
	{"hajnu", "𤾂"},
	{"hajtc", "馩"},
	{"hak", "㚖"},
	{"hakj", "皋"},
	{"haklb", "㡍"},
	{"haklu", "馣"},
	{"hakmr", "䭲"},
	{"haks", "劰"},
	{"halb", "帛"},
	{"hali", "蠞"},
	{"halmo", "㿡"},
	{"halmy", "馡"},
	{"ham", "笪"},
	{"hambc", "䫒 䫝"},
	{"hambg", "皬"},
	{"hambi", "𤿂"},
	{"hamg", "皇"},
	{"hamhm", "㿨"},
	{"hamj", "筸"},
	{"hamo", "䈕"},
	{"hamvn", "㼟"},
	{"hana", "簡"},
	{"hang", "䉮"},
	{"hank", "簢"},
	{"hanp", "䉍"},
	{"hanw", "籣"},
	{"haoae", "馥"},
	{"haobg", "㿥"},
	{"haoii", "皊"},
	{"haoir", "馠"},
	{"haok", "敀"},
	{"hap", "皂"},
	{"haph", "馝"},
	{"hapi", "的"},
	{"happ", "箟"},
	{"hapsl", "皍"},
	{"hapv", "䈓"},
	{"haqka", "㿤"},
	{"haqkq", "䭰"},
	{"haqmb", "皘"},
	{"haqmc", "皟"},
	{"hasm", "䈳"},
	{"hasmm", "䎅"},
	{"hasp", "馜"},
	{"hatif", "𤾸"},
	{"hatmj", "皣"},
	{"hatt", "皏"},
	{"hatxc", "馦"},
	{"hau", "癿 笆"},
	{"haumt", "皚"},
	{"hauog", "皠"},
	{"hausu", "皑"},
	{"hauu", "䭯"},
	{"havid", "皪"},
	{"havt", "簋"},
	{"haw", "畠"},
	{"hawe", "𥲑"},
	{"hawot", "馧"},
	{"hayck", "皎"},
	{"hayd", "梟"},
	{"hayf", "鳥"},
	{"haymp", "皉"},
	{"hayn", "鳬"},
	{"hayrb", "皜"},
	{"hayu", "島"},
	{"hayv", "裊"},
	{"hbau", "䈈"},
	{"hbb", "䑁"},
	{"hbbk", "䉰"},
	{"hbbm", "舋"},
	{"hbbr", "䈑"},
	{"hbbt", "䀉"},
	{"hbbu", "䁷"},
	{"hbbuu", "覺 䚁"},
	{"hbcn", "䈟"},
	{"hbdci", "𦦵"},
	{"hbddf", "爨 㸑"},
	{"hbe", "澩"},
	{"hbf", "燢 爂"},
	{"hbfe", "籐"},
	{"hbff", "籘 𥸎"},
	{"hbg", "壆 㙑"},
	{"hbhaf", "鵳 鶣 鷮 鷽"},
	{"hbhgr", "嚳"},
	{"hbhj", "簲"},
	{"hbhu", "笕"},
	{"hbhvf", "緜"},
	{"hbhx", "䈱"},
	{"hbib", "䈻"},
	{"hbk", "奥 奧"},
	{"hbks", "筋"},
	{"hblmp", "𠤣"},
	{"hbln", "制"},
	{"hbm", "笡"},
	{"hbmbc", "顅"},
	{"hbmch", "釁"},
	{"hbme", "䈠"},
	{"hbmgi", "璺 㼂"},
	{"hbmr", "礐 筒"},
	{"hbms", "筯"},
	{"hbmvn", "甂 㽇"},
	{"hbnbg", "觷"},
	{"hbnd", "學"},
	{"hbnl", "鄅"},
	{"hbnwf", "鱟"},
	{"hbog", "雤"},
	{"hbok", "敿"},
	{"hbop", "箆"},
	{"hbq", "甪"},
	{"hbr", "向 𠿟"},
	{"hbrh", "簓"},
	{"hbsd", "箏"},
	{"hbse", "箙"},
	{"hbsmm", "翩 䎗"},
	{"hbsqf", "䮸"},
	{"hbt", "笧 血"},
	{"hbtmc", "黌"},
	{"hbtn", "䈀"},
	{"hbu", "嶨 自"},
	{"hbuc", "筫"},
	{"hbue", "籰 𥴠"},
	{"hbuf", "纂 䵵"},
	{"hbuh", "篎"},
	{"hbui", "篡 簒"},
	{"hbut", "算"},
	{"hbuu", "筧 篹"},
	{"hbuv", "籑 䉵"},
	{"hbye", "敽"},
	{"hbyi", "舟"},
	{"hc", "乊"},
	{"hcb", "臖"},
	{"hcbt", "盨"},
	{"hce", "澃"},
	{"hcg", "𡒊"},
	{"hchaf", "鸒"},
	{"hche", "夓"},
	{"hchg", "籦"},
	{"hci", "䇗"},
	{"hcii", "籛"},
	{"hcij", "篯"},
	{"hcim", "䈵"},
	{"hcjwj", "轝"},
	{"hcln", "劉 劗"},
	{"hcmr", "礜"},
	{"hcn", "乥"},
	{"hcnl", "鄮 酇"},
	{"hcno", "歟"},
	{"hcp", "㦛"},
	{"hcpm", "𥳾"},
	{"hcq", "擧 舉"},
	{"hcv", "嬃"},
	{"hcve", "籙"},
	{"hcwa", "䉕"},
	{"hcwj", "箪"},
	{"hcymp", "頾"},
	{"hcymr", "譽"},
	{"hcyt", "䇓"},
	{"hd", "禾"},
	{"hda", "香"},
	{"hdaa", "䅛"},
	{"hdaiu", "穊"},
	{"hdami", "䅞"},
	{"hdamj", "稈"},
	{"hdamo", "䅠"},
	{"hdapp", "䅙"},
	{"hdapv", "䅥"},
	{"hdase", "穝"},
	{"hdawe", "䅼"},
	{"hdb", "策 䄴"},
	{"hdbb", "稝"},
	{"hdbgb", "稱"},
	{"hdbgr", "稠"},
	{"hdbhx", "稻"},
	{"hdbk", "𥰡"},
	{"hdbla", "稲"},
	{"hdbm", "租"},
	{"hdbmp", "穩"},
	{"hdbmr", "秱"},
	{"hdbn", "箣"},
	{"hdbnd", "稃"},
	{"hdbof", "穄"},
	{"hdbsp", "穏"},
	{"hdbt", "盉"},
	{"hdbu", "箱"},
	{"hdbuu", "䅐"},
	{"hdbv", "䅑"},
	{"hdbwi", "穱"},
	{"hdci", "𥯆"},
	{"hdcnh", "稊"},
	{"hdcru", "稅"},
	{"hdcsh", "秎"},
	{"hdd", "箖"},
	{"hddhe", "秛"},
	{"hddj", "秣"},
	{"hddmq", "稦"},
	{"hddoo", "䅘"},
	{"hdeq", "释"},
	{"hdf", "秋"},
	{"hdfa", "稥"},
	{"hdfb", "稍 䈾"},
	{"hdfd", "䊬"},
	{"hdfdc", "䆏"},
	{"hdfh", "秒"},
	{"hdfq", "秚"},
	{"hdfqu", "䅚"},
	{"hdgce", "稜"},
	{"hdgcg", "稑"},
	{"hdgcw", "穑"},
	{"hdgdi", "秲"},
	{"hdgg", "䅅"},
	{"hdggu", "穘"},
	{"hdgow", "穡"},
	{"hdgr", "秸"},
	{"hdgrw", "穯"},
	{"hdha", "䄸"},
	{"hdhaf", "鴸 鷍"},
	{"hdhag", "䅣"},
	{"hdhah", "穆"},
	{"hdhbv", "秾"},
	{"hdhd", "秝"},
	{"hdhda", "䅨"},
	{"hdhds", "䅎"},
	{"hdhdv", "䅗"},
	{"hdher", "䅂"},
	{"hdhhj", "稗"},
	{"hdhj", "秊 䄭"},
	{"hdhjd", "秼"},
	{"hdhjg", "種"},
	{"hdhjm", "䅜"},
	{"hdhjr", "秳"},
	{"hdhjx", "䅤"},
	{"hdhk", "秗"},
	{"hdhkb", "穚"},
	{"hdhn", "秃"},
	{"hdhne", "毇"},
	{"hdhnf", "䆇"},
	{"hdhp", "秅"},
	{"hdhpm", "秪"},
	{"hdhqo", "秩"},
	{"hdhqu", "秏"},
	{"hdhr", "䈷"},
	{"hdhsb", "稨"},
	{"hdhu", "禿"},
	{"hdhuc", "穳"},
	{"hdhur", "䆌"},
	{"hdhvp", "秖"},
	{"hdhw", "籕"},
	{"hdhxc", "穥"},
	{"hdi", "私 㦵"},
	{"hdiav", "稂"},
	{"hdice", "稄"},
	{"hdihp", "䅊"},
	{"hdihu", "𥝲"},
	{"hdiih", "穇"},
	{"hdij", "䄾"},
	{"hdijb", "秿"},
	{"hdijc", "秫"},
	{"hdije", "𥟇"},
	{"hdikh", "䅟"},
	{"hdikk", "秡"},
	{"hdikm", "稶"},
	{"hdilb", "𥡲"},
	{"hdile", "穅"},
	{"hdilr", "䅯"},
	{"hdimo", "䅆"},
	{"hdioc", "䆅"},
	{"hdip", "䄩"},
	{"hdipf", "穮"},
	{"hdir", "秮"},
	{"hdirm", "稢"},
	{"hditc", "穬 䆂"},
	{"hdiua", "稽"},
	{"hdiuu", "嵇"},
	{"hdjbc", "稹"},
	{"hdjbf", "䅴"},
	{"hdjbm", "稙"},
	{"hdjcm", "䅝"},
	{"hdjcr", "穃"},
	{"hdje", "秓"},
	{"hdjec", "䅩"},
	{"hdjf", "䉘"},
	{"hdjhp", "秺"},
	{"hdjip", "穗"},
	{"hdjmc", "穦"},
	{"hdjmf", "𥟡"},
	{"hdjmo", "稼"},
	{"hdjpa", "䅲"},
	{"hdjr", "秙"},
	{"hdjwp", "穂"},
	{"hdkkb", "稀"},
	{"hdklu", "䅖"},
	{"hdkn", "䄺"},
	{"hdkni", "秇"},
	{"hdkss", "䅄"},
	{"hdl", "秉 种 䇿"},
	{"hdlbk", "秧"},
	{"hdlc", "籟"},
	{"hdlln", "䄶"},
	{"hdllv", "䅹"},
	{"hdlmo", "䄻 䅪"},
	{"hdln", "利 剁 㓷"},
	{"hdlo", "簌 籁"},
	{"hdlp", "乘"},
	{"hdlpc", "䆊"},
	{"hdlw", "秞 釉"},
	{"hdlwb", "䅢"},
	{"hdlwp", "䄿"},
	{"hdlxh", "秭"},
	{"hdm", "笨"},
	{"hdmbb", "穤"},
	{"hdmbc", "䅡"},
	{"hdmbk", "稬"},
	{"hdmcw", "䄽"},
	{"hdmd", "䄨"},
	{"hdmfb", "穪"},
	{"hdmfj", "秤"},
	{"hdmfm", "秠"},
	{"hdmig", "秷"},
	{"hdmj", "秆"},
	{"hdmlk", "稉"},
	{"hdmlm", "稏"},
	{"hdmmi", "秐"},
	{"hdmmp", "穲"},
	{"hdmnn", "䅀"},
	{"hdmow", "䄼"},
	{"hdmq", "𥯤"},
	{"hdmr", "䄷"},
	{"hdmrw", "稫"},
	{"hdmt", "䄯"},
	{"hdmtc", "䅉"},
	{"hdmua", "䅾"},
	{"hdmvh", "䄰"},
	{"hdmvi", "䅶"},
	{"hdmvn", "甈 㼡"},
	{"hdmwf", "䅺"},
	{"hdnau", "䅋"},
	{"hdnd", "季 秄"},
	{"hdnf", "称"},
	{"hdnhs", "秀 䄧"},
	{"hdnin", "移"},
	{"hdnkg", "䅍"},
	{"hdnl", "邾 鄡 䣋"},
	{"hdnmu", "臲"},
	{"hdnn", "䄦"},
	{"hdnob", "稰"},
	{"hdnsp", "稳"},
	{"hdnwa", "穭"},
	{"hdnwu", "穐"},
	{"hdnxu", "龝 䆋"},
	{"hdo", "秂"},
	{"hdoae", "稪"},
	{"hdob", "䄲"},
	{"hdoe", "黍"},
	{"hdog", "稚 䧽"},
	{"hdogd", "穕"},
	{"hdogf", "穛"},
	{"hdohg", "秹"},
	{"hdohj", "䄹"},
	{"hdoii", "秢"},
	{"hdoim", "䆎"},
	{"hdoip", "稔"},
	{"hdoir", "䅮"},
	{"hdok", "斆"},
	{"hdomb", "稐"},
	{"hdomd", "稌"},
	{"hdomr", "秴"},
	{"hdoo", "箂"},
	{"hdos", "秨"},
	{"hdp", "悉"},
	{"hdpd", "䄬"},
	{"hdph", "秘"},
	{"hdpi", "䄪"},
	{"hdpp", "秕"},
	{"hdppa", "稭 𥟠"},
	{"hdpre", "䅓"},
	{"hdpuu", "䅳"},
	{"hdq", "䄵"},
	{"hdqhk", "稧"},
	{"hdqmc", "積"},
	{"hdqo", "䄮"},
	{"hdr", "和 㕿"},
	{"hdrb", "䅌"},
	{"hdrc", "积"},
	{"hdrhg", "程"},
	{"hdrhr", "稆"},
	{"hdrrd", "䆆"},
	{"hdrxu", "鼄"},
	{"hdsb", "篐"},
	{"hdshu", "䅏"},
	{"hdsj", "䎹"},
	{"hdsjr", "䅕"},
	{"hdsmh", "穋"},
	{"hdso", "釈"},
	{"hdsp", "秜"},
	{"hdsqf", "𥡗"},
	{"hdsr", "䉩"},
	{"hdss", "秬"},
	{"hdsu", "䄫"},
	{"hdsyj", "稺"},
	{"hdsyq", "穉 𥣡"},
	{"hdt", "乗"},
	{"hdta", "稓"},
	{"hdtc", "簯"},
	{"hdtcd", "𥣈"},
	{"hdtco", "穙"},
	{"hdtct", "䅬"},
	{"hdtgf", "䅵"},
	{"hdtm", "䈤"},
	{"hdtmc", "稘 穔"},
	{"hdtmj", "䅿"},
	{"hdtod", "䅷"},
	{"hdtoe", "穫"},
	{"hdtsj", "穁"},
	{"hdtvi", "稵"},
	{"hdtw", "䅦"},
	{"hdtwv", "穠"},
	{"hdtxc", "稴"},
	{"hdtyj", "䅸"},
	{"hdtyv", "䅒"},
	{"hdu", "秈 㟀"},
	{"hduce", "稯"},
	{"hdumt", "䅱"},
	{"hduni", "秽"},
	{"hdv", "委"},
	{"hdvii", "穖"},
	{"hdvvw", "䅔"},
	{"hdw", "番"},
	{"hdwb", "稩"},
	{"hdwce", "稷"},
	{"hdwd", "稞 䉓"},
	{"hdwgf", "䆀"},
	{"hdwhd", "稛"},
	{"hdwjr", "稒"},
	{"hdwk", "秵"},
	{"hdwkp", "䅰"},
	{"hdwlj", "釋 䆁"},
	{"hdwlp", "䆉"},
	{"hdwtc", "穓"},
	{"hdyaf", "䅫"},
	{"hdybp", "䆍"},
	{"hdybs", "䅭"},
	{"hdycv", "穣"},
	{"hdye", "斅"},
	{"hdyhn", "秔"},
	{"hdyhs", "䄱"},
	{"hdyj", "科"},
	{"hdylm", "䄳"},
	{"hdymh", "穢"},
	{"hdyoj", "稡"},
	{"hdyr", "秥"},
	{"hdyrb", "稿"},
	{"hdyrd", "稕"},
	{"hdyrf", "稤"},
	{"hdyrv", "穰"},
	{"hdysq", "䆈"},
	{"hdyta", "䅧"},
	{"hdytg", "穜"},
	{"hdyto", "穟"},
	{"hdytr", "稖"},
	{"hdyub", "䅻"},
	{"hdyvw", "稸"},
	{"hdywm", "䆄"},
	{"hdyx", "穧"},
	{"he", "反 夂"},
	{"hea", "䈋 䵒"},
	{"heag", "篞"},
	{"heah", "簜"},
	{"heamh", "䵘"},
	{"hebhx", "䵚"},
	{"hebm", "䈌"},
	{"hebt", "盤"},
	{"hec", "鎜 䥣"},
	{"hecd", "簗"},
	{"hed", "条 槃"},
	{"hede", "箥"},
	{"hedw", "䵔"},
	{"hefd", "夈"},
	{"heg", "垼"},
	{"heha", "箔"},
	{"hehee", "灥"},
	{"hehhh", "㣊 㣐"},
	{"hehl", "䇵"},
	{"hehn", "処"},
	{"hehq", "䵓"},
	{"hehqu", "㲣"},
	{"hehu", "箲"},
	{"hehw", "籓"},
	{"heib", "䈬"},
	{"heidd", "䵈"},
	{"heii", "簿"},
	{"heir", "箈"},
	{"heknn", "䵙"},
	{"heks", "务"},
	{"helb", "幋"},
	{"helmi", "螌"},
	{"heln", "㓿"},
	{"hemhm", "㚅"},
	{"hemr", "磐"},
	{"hemrw", "䵗"},
	{"henl", "鄋"},
	{"hep", "慇"},
	{"hepd", "筂"},
	{"heq", "夅 搫 㩓"},
	{"heqj", "夆"},
	{"heqjf", "㶻"},
	{"her", "各"},
	{"herp", "㤩"},
	{"heseg", "䵛"},
	{"heshi", "䵑"},
	{"hesjr", "䵕"},
	{"hesr", "䈃"},
	{"hesu", "笵"},
	{"hetc", "篊"},
	{"hetlj", "鞶"},
	{"hetwv", "䵜"},
	{"hev", "媻"},
	{"hevif", "縏 䋜"},
	{"hew", "备"},
	{"hewp", "惫"},
	{"hey", "冬 处"},
	{"heye", "㪢"},
	{"heyhv", "褩"},
	{"heyli", "螽"},
	{"heyn", "㐑"},
	{"heyr", "黏"},
	{"heyub", "黐"},
	{"hfaht", "鵿"},
	{"hfate", "鸔"},
	{"hfb", "筲"},
	{"hfbd", "䉎"},
	{"hfbn", "箾"},
	{"hfbvk", "䳶"},
	{"hfbw", "簹"},
	{"hfc", "鍫"},
	{"hfd", "乎 釆 䲷"},
	{"hfdk", "鴃"},
	{"hfdn", "乯"},
	{"hfdv", "篓"},
	{"hfe", "湬"},
	{"hfesd", "𪆫"},
	{"hffs", "簩"},
	{"hfgdi", "𪀔"},
	{"hfhaf", "鶖"},
	{"hfher", "鴼"},
	{"hfhey", "鴤"},
	{"hfhn", "鳧"},
	{"hfhqi", "䳗 䳘"},
	{"hfhqo", "䳀"},
	{"hfhrb", "鶳"},
	{"hfhu", "箵"},
	{"hfhvp", "䲬"},
	{"hfhxu", "鶃"},
	{"hfhyu", "鷈"},
	{"hfice", "鵔"},
	{"hfikk", "䳁"},
	{"hfjc", "鴥"},
	{"hfjme", "䳹"},
	{"hfjp", "鴕"},
	{"hfk", "䲦"},
	{"hfks", "勳"},
	{"hfku", "㸔"},
	{"hflb", "㡑"},
	{"hflmi", "蝵"},
	{"hfmcw", "醔"},
	{"hfmmp", "𪈳"},
	{"hfmnr", "鴚"},
	{"hfmvn", "甃"},
	{"hfn", "鳦"},
	{"hfniu", "䳃"},
	{"hfnl", "鄔"},
	{"hfno", "歍"},
	{"hfog", "鵻 䨂"},
	{"hfoip", "鴏"},
	{"hfomd", "鵌"},
	{"hfonk", "䳧"},
	{"hfp", "愁"},
	{"hfpru", "䳈"},
	{"hfpym", "鹙"},
	{"hfq", "揫"},
	{"hfqu", "箞"},
	{"hfrc", "䳅"},
	{"hfrxu", "䵸"},
	{"hfsju", "䳖"},
	{"hfsm", "筜"},
	{"hfsqf", "鷌"},
	{"hfsrr", "䳼"},
	{"hftbo", "䴌"},
	{"hftgi", "鸃"},
	{"hftmc", "鶀"},
	{"hftoe", "鸌"},
	{"hfu", "㠀"},
	{"hfv", "媝"},
	{"hfvk", "䉤"},
	{"hfvne", "鵦"},
	{"hfwlv", "䴋"},
	{"hfydk", "鷻"},
	{"hfyhs", "䲱"},
	{"hfyhv", "䙚"},
	{"hg", "壬 𡈼 ⺧"},
	{"hgafu", "皩"},
	{"hgce", "䈊"},
	{"hgcr", "簭"},
	{"hgdi", "等"},
	{"hgea", "濌"},
	{"hgf", "熏"},
	{"hgfmu", "皝"},
	{"hgg", "筀"},
	{"hggi", "篈"},
	{"hghaf", "䳨 䳯"},
	{"hghne", "毀"},
	{"hghu", "先"},
	{"hgi", "丟 丢"},
	{"hgit", "篕"},
	{"hgji", "䉅"},
	{"hgks", "動"},
	{"hgmbc", "顧"},
	{"hgmvn", "𤭮"},
	{"hgni", "籌"},
	{"hgnl", "𨛘"},
	{"hgow", "䉢"},
	{"hgpm", "筠"},
	{"hgr", "告"},
	{"hgrg", "籉"},
	{"hgrly", "靠"},
	{"hgrp", "㘒"},
	{"hhaf", "䉆"},
	{"hhag", "篁"},
	{"hhail", "卿"},
	{"hhano", "䠾"},
	{"hhbk", "䉛"},
	{"hhbo", "贸"},
	{"hhbu", "睝"},
	{"hhbuc", "貿"},
	{"hhc", "錅"},
	{"hhcn", "䉧"},
	{"hhcsh", "躮"},
	{"hhd", "棃"},
	{"hhdf", "篍"},
	{"hhdi", "射"},
	{"hhdj", "䈖"},
	{"hhdm", "躰"},
	{"hhdn", "筣 簃"},
	{"hhdw", "䉒"},
	{"hhed", "筿"},
	{"hheq", "䇨"},
	{"hher", "笿"},
	{"hhey", "笗"},
	{"hhfbr", "躺"},
	{"hhfd", "䊍"},
	{"hhffs", "軂"},
	{"hhfh", "𨈘"},
	{"hhgni", "軇"},
	{"hhgr", "筶"},
	{"hhgu", "筅"},
	{"hhh", "彡"},
	{"hhhaf", "鵹"},
	{"hhhdv", "躷"},
	{"hhhe", "䉫"},
	{"hhhj", "箄"},
	{"hhhl", "笷"},
	{"hhhnd", "躲"},
	{"hhho", "辵"},
	{"hhhq", "犂"},
	{"hhiav", "躴"},
	{"hhile", "躿"},
	{"hhiop", "軈"},
	{"hhj", "卑"},
	{"hhjcm", "躻"},
	{"hhjcn", "䠻"},
	{"hhjd", "䇬"},
	{"hhjg", "箽"},
	{"hhjm", "箠"},
	{"hhjmc", "軉"},
	{"hhjon", "䴻"},
	{"hhjr", "筈"},
	{"hhk", "笑"},
	{"hhkb", "簥"},
	{"hhkmr", "躸"},
	{"hhkms", "䠸"},
	{"hhlbu", "躭"},
	{"hhlf", "籞"},
	{"hhllv", "軁"},
	{"hhlmc", "䠿"},
	{"hhlmi", "䖿"},
	{"hhlmo", "䠷"},
	{"hhlo", "笊"},
	{"hhlsr", "䠺"},
	{"hhmbc", "須"},
	{"hhmbo", "须"},
	{"hhmdm", "𨊛"},
	{"hhmmp", "𨉼"},
	{"hhmog", "軅"},
	{"hhn", "躬"},
	{"hhni", "竼"},
	{"hhnsd", "躱"},
	{"hhnwf", "鯬"},
	{"hhodi", "䠵"},
	{"hhoe", "黎"},
	{"hhoii", "䠲"},
	{"hhok", "䉠 䠶"},
	{"hhol", "篽"},
	{"hhomn", "䠼"},
	{"hhon", "筕"},
	{"hhoo", "簁"},
	{"hhoq", "箻"},
	{"hhp", "惣 㥎"},
	{"hhpfd", "躹"},
	{"hhpp", "𨈚"},
	{"hhqm", "笙"},
	{"hhqu", "笔"},
	{"hhrb", "篩"},
	{"hhrr", "躳"},
	{"hhrrj", "軃"},
	{"hhs", "笮"},
	{"hhsav", "躽"},
	{"hhsb", "篇"},
	{"hhsh", "剓"},
	{"hhsip", "躵"},
	{"hhsk", "躯"},
	{"hhsl", "卯"},
	{"hhslc", "贕"},
	{"hhsld", "孵"},
	{"hhsle", "毈"},
	{"hhsli", "卵"},
	{"hhsmv", "躼"},
	{"hhsrr", "軀"},
	{"hhtgk", "躾"},
	{"hhtwt", "軆"},
	{"hhuc", "籫"},
	{"hhui", "䈭"},
	{"hhumt", "䠽"},
	{"hhuu", "䠳"},
	{"hhvo", "笟"},
	{"hhvu", "篼"},
	{"hhw", "留"},
	{"hhwd", "躶"},
	{"hhwgf", "黧"},
	{"hhwp", "篦"},
	{"hhxc", "籅"},
	{"hhxf", "䉣"},
	{"hhybp", "䡁"},
	{"hhye", "䈲"},
	{"hhyia", "軄"},
	{"hhyt", "䠴"},
	{"hhyu", "篪"},
	{"hhyvo", "䠹"},
	{"hhywm", "䡀"},
	{"hi", "么 鬼 䇝"},
	{"hiahu", "䰨"},
	{"hiav", "筤"},
	{"hibkk", "䰣"},
	{"hibt", "簠"},
	{"hibtv", "魍"},
	{"hifb", "魈"},
	{"hife", "簶"},
	{"higgu", "䰫"},
	{"hihaf", "鵝 鵞"},
	{"hihda", "䭳"},
	{"hihhh", "鬽"},
	{"hihml", "鬿"},
	{"hihon", "䰢"},
	{"hihp", "䉞"},
	{"hihq", "犩"},
	{"hihqo", "䰡"},
	{"hihqu", "㲳"},
	{"hihr", "箴"},
	{"hihs", "筬"},
	{"hihwj", "䰦"},
	{"hii", "箋"},
	{"hiih", "篸"},
	{"hiikk", "魃"},
	{"hiipj", "𩲭"},
	{"hiirm", "魊"},
	{"hiit", "𥵃"},
	{"hiiv", "魆"},
	{"hij", "笺"},
	{"hijb", "𥮉"},
	{"hijd", "魅"},
	{"hije", "鬾"},
	{"hikf", "䈧"},
	{"hikj", "䉊"},
	{"hikp", "笼"},
	{"hiks", "㔟"},
	{"hilmi", "䖸"},
	{"hilr", "篖"},
	{"hilwl", "䰠"},
	{"himbc", "䫥"},
	{"himlb", "魎"},
	{"himob", "魉"},
	{"himwf", "魒"},
	{"hine", "䉬"},
	{"hinhb", "䰬"},
	{"hino", "乏"},
	{"hiog", "魋"},
	{"hioll", "魀"},
	{"hipko", "䰯"},
	{"hipm", "𥳁"},
	{"hipym", "鹅"},
	{"hiq", "䇳"},
	{"hir", "笞"},
	{"hird", "䈢"},
	{"hirm", "䈅"},
	{"hirp", "䈚"},
	{"hisk", "䈆"},
	{"hisu", "簄"},
	{"hit", "笲"},
	{"hitb", "𥱊"},
	{"hitc", "簾"},
	{"hitf", "䉀"},
	{"hitgi", "䰮"},
	{"hitmc", "魌"},
	{"hitwi", "𩴾"},
	{"hitxc", "魐"},
	{"hivii", "魕"},
	{"hiwtj", "魓"},
	{"hixp", "簏"},
	{"hiye", "㪆"},
	{"hiyj", "魁"},
	{"hiypm", "魖"},
	{"hiypu", "䰧"},
	{"hiyub", "魑"},
	{"hj", "千"},
	{"hjac", "䈿"},
	{"hjbc", "貭 䈯"},
	{"hjbj", "䈒"},
	{"hjbo", "质"},
	{"hjbu", "盾"},
	{"hjbuu", "䚌"},
	{"hjcm", "箜"},
	{"hjcor", "谸"},
	{"hjcr", "䈶"},
	{"hjd", "朱 栞"},
	{"hjf", "㷏"},
	{"hjg", "圱"},
	{"hjhaf", "鵯"},
	{"hjhne", "段"},
	{"hjhx", "臿"},
	{"hjii", "篿 簙"},
	{"hjim", "籖"},
	{"hjji", "䉖"},
	{"hjjj", "簳"},
	{"hjjo", "簐"},
	{"hjjr", "簵 䉐"},
	{"hjju", "範"},
	{"hjka", "箸"},
	{"hjkp", "䇭"},
	{"hjks", "㔓"},
	{"hjlg", "埀"},
	{"hjlii", "䘀"},
	{"hjln", "𠜱"},
	{"hjlo", "箑"},
	{"hjlp", "乖"},
	{"hjmbc", "顊 䫌 䫧"},
	{"hjmk", "簆"},
	{"hjmm", "箮"},
	{"hjmn", "䇡"},
	{"hjmu", "筦"},
	{"hjmvn", "㼰"},
	{"hjnl", "郫 䢴 䣗"},
	{"hjnu", "箢"},
	{"hjoa", "䈹"},
	{"hjp", "忎"},
	{"hjpu", "䈼"},
	{"hjpym", "鹎"},
	{"hjr", "舌 䇢"},
	{"hjrb", "箶"},
	{"hjrr", "管"},
	{"hjsmm", "翱 翺"},
	{"hjtg", "簺"},
	{"hjtm", "垂"},
	{"hjwg", "重"},
	{"hjye", "㪏"},
	{"hk", "夭"},
	{"hka", "昋"},
	{"hkapv", "𦤦"},
	{"hkcf", "簝"},
	{"hkd", "棨"},
	{"hke", "叐"},
	{"hkhaf", "鴁 鴌 鸄 䴈"},
	{"hkk", "笅"},
	{"hkks", "勶"},
	{"hkll", "乔"},
	{"hklmi", "蚕"},
	{"hkln", "刋"},
	{"hklq", "肇"},
	{"hknbq", "䚫"},
	{"hkni", "笂"},
	{"hknl", "鄓"},
	{"hkoo", "筴"},
	{"hkp", "忝 懲 㦘"},
	{"hkr", "吞 呑"},
	{"hkrbr", "喬"},
	{"hks", "竻"},
	{"hksr", "笳"},
	{"hkt", "䇲"},
	{"hku", "岙 嶴 㠞"},
	{"hkvif", "綮"},
	{"hkymr", "譥"},
	{"hlai", "兎"},
	{"hlapv", "齃"},
	{"hlb", "币"},
	{"hlbi", "禹"},
	{"hlbk", "䇦"},
	{"hlbuc", "質"},
	{"hldam", "齄"},
	{"hlgbo", "䶑"},
	{"hlha", "皙"},
	{"hlhdl", "𥡝"},
	{"hlhml", "斦"},
	{"hlhuk", "齅"},
	{"hlit", "篮"},
	{"hljbv", "齉"},
	{"hlkn", "鼽"},
	{"hlks", "劤"},
	{"hllb", "筛"},
	{"hlle", "齂"},
	{"hllj", "簰"},
	{"hlll", "簘"},
	{"hlln", "劓 笰"},
	{"hlmbc", "頎"},
	{"hlmbo", "颀"},
	{"hlmc", "簣"},
	{"hlmi", "䖝"},
	{"hlmj", "鼾"},
	{"hlmmf", "禦"},
	{"hlmo", "筄"},
	{"hlmu", "鼿"},
	{"hlmvn", "齀"},
	{"hln", "乮"},
	{"hlng", "䶊"},
	{"hlnhe", "䶋"},
	{"hlnl", "邤"},
	{"hlno", "欣"},
	{"hlo", "爪"},
	{"hloma", "䶐"},
	{"hlomr", "䶎"},
	{"hlp", "㤻"},
	{"hlpr", "齁"},
	{"hlpru", "䶌"},
	{"hlq", "筆"},
	{"hlr", "啠"},
	{"hlsa", "简"},
	{"hlsr", "䉱"},
	{"hltwv", "齈"},
	{"hlvk", "籔"},
	{"hlvl", "鼼"},
	{"hlvvu", "齆"},
	{"hlw", "笛"},
	{"hlwli", "斶"},
	{"hlwp", "䇩"},
	{"hlwv", "簍"},
	{"hlx", "簫"},
	{"hlxh", "笫"},
	{"hlypm", "齇"},
	{"hlypu", "䖐"},
	{"hm", "笁"},
	{"hmau", "巵"},
	{"hmb", "甧"},
	{"hmbc", "篢"},
	{"hmbg", "籗"},
	{"hmbi", "䉙"},
	{"hmbo", "䉹"},
	{"hmbu", "眚"},
	{"hmcw", "䇴"},
	{"hmd", "竽"},
	{"hmfb", "籋"},
	{"hmgn", "箌 籈"},
	{"hmgt", "筭"},
	{"hmhaf", "鴟 鷎 䲼 䳠"},
	{"hmhml", "斵"},
	{"hmhmm", "㽓"},
	{"hmhne", "毁"},
	{"hmhqm", "甡"},
	{"hmig", "䇪"},
	{"hmj", "竿"},
	{"hmje", "㩾"},
	{"hmjj", "筓"},
	{"hml", "斤"},
	{"hmlk", "筻"},
	{"hmlm", "𥮳"},
	{"hmln", "㔐"},
	{"hmm", "竺"},
	{"hmmbc", "䫇"},
	{"hmmk", "䈣"},
	{"hmmp", "籭"},
	{"hmmu", "笎"},
	{"hmmvn", "甀"},
	{"hmnd", "築"},
	{"hmni", "䉔"},
	{"hmnj", "筑"},
	{"hmnl", "筇 邸 郵"},
	{"hmnq", "篫"},
	{"hmnr", "笴"},
	{"hmob", "䇤"},
	{"hmoo", "筮"},
	{"hmow", "䇧"},
	{"hmp", "惩 憇"},
	{"hmr", "后"},
	{"hmrb", "䈪"},
	{"hmrg", "垕"},
	{"hmrt", "䇺"},
	{"hmrw", "䈏"},
	{"hmsl", "笻"},
	{"hmsmb", "歸"},
	{"hmsu", "卮"},
	{"hmt", "笄"},
	{"hmua", "簪"},
	{"hmvh", "笌"},
	{"hmvm", "䇘"},
	{"hmwd", "篥"},
	{"hmwf", "篻"},
	{"hmwj", "簟"},
	{"hmwks", "甥"},
	{"hmy", "斥"},
	{"hmyf", "篶"},
	{"hmym", "䇥"},
	{"hn", "几 凢 𠂊 ⺇ ⺈"},
	{"hna", "䫻"},
	{"hnamh", "颺"},
	{"hnbj", "䈸"},
	{"hnbmc", "颶"},
	{"hnbo", "䉉"},
	{"hnbou", "䬙"},
	{"hnbq", "䇶 䉏"},
	{"hnbs", "䈥"},
	{"hnbuc", "䥚 𩗗"},
	{"hnc", "鋫"},
	{"hncr", "簷"},
	{"hncru", "䬈"},
	{"hnd", "朵 梨"},
	{"hndk", "䫼"},
	{"hndmq", "颹"},
	{"hndo", "箛"},
	{"hne", "凤 殳"},
	{"hnef", "篜"},
	{"hneii", "颾"},
	{"hnem", "䇰"},
	{"hnf", "㶡"},
	{"hnfb", "颵"},
	{"hnff", "颷"},
	{"hnfff", "飈"},
	{"hnfq", "䉳"},
	{"hngce", "䬋"},
	{"hnglc", "䬉"},
	{"hngni", "䬞"},
	{"hnhaf", "鳯"},
	{"hnhag", "凰 䬖"},
	{"hnhcn", "䬟"},
	{"hnhdn", "䬆"},
	{"hnhdv", "䬐"},
	{"hnhe", "笈"},
	{"hnhhh", "颩"},
	{"hnhhw", "飀"},
	{"hnhjr", "颳"},
	{"hnhli", "風"},
	{"hnhni", "䬕"},
	{"hnhnn", "飍"},
	{"hnhq", "犁"},
	{"hnhqu", "䫽"},
	{"hnhxe", "颼"},
	{"hni", "凡"},
	{"hnib", "筩"},
	{"hnihi", "䬄"},
	{"hnikk", "飇"},
	{"hnir", "颱"},
	{"hnirm", "䬎"},
	{"hnis", "䇟"},
	{"hniv", "䬂"},
	{"hnjfe", "䬒"},
	{"hnjp", "䬁"},
	{"hnk", "风 𠘰"},
	{"hnkcf", "飉"},
	{"hnkg", "筳"},
	{"hnkm", "筵"},
	{"hnkoo", "䬊"},
	{"hnkss", "䬅"},
	{"hnl", "䇙"},
	{"hnlb", "凧"},
	{"hnld", "篨 𥱥"},
	{"hnle", "䉄"},
	{"hnlh", "第"},
	{"hnlmi", "䖽"},
	{"hnlo", "䉌"},
	{"hnlv", "䈨"},
	{"hnm", "䫹"},
	{"hnma", "凮"},
	{"hnmaf", "鳳"},
	{"hnmb", "䉲"},
	{"hnmbc", "頽"},
	{"hnmbo", "颓"},
	{"hnme", "箓"},
	{"hnmgh", "飋"},
	{"hnmlw", "飅"},
	{"hnmm", "篛"},
	{"hnmmi", "凨"},
	{"hnmni", "夙 㓘"},
	{"hnmnn", "颲"},
	{"hnmvh", "颬"},
	{"hnmwf", "飃"},
	{"hnnl", "䢳"},
	{"hnnsh", "飏"},
	{"hnnwf", "䱘 䱥"},
	{"hno", "䇜"},
	{"hnob", "䈝"},
	{"hnoe", "㴝"},
	{"hnomn", "䬔"},
	{"hnono", "颴"},
	{"hnot", "簦"},
	{"hnp", "愆 㦣"},
	{"hnph", "䫾"},
	{"hnphp", "䬍"},
	{"hnpru", "颮"},
	{"hnpym", "䴘"},
	{"hnq", "掣"},
	{"hnqkq", "𩗴"},
	{"hnqo", "颫"},
	{"hnrms", "𩖸"},
	{"hnryo", "躗"},
	{"hnsd", "筝"},
	{"hnsh", "䫸"},
	{"hnshr", "䫿"},
	{"hnsmh", "飂"},
	{"hnsqf", "䬚"},
	{"hntmc", "䬝"},
	{"hntxc", "凲"},
	{"hnu", "𩖞"},
	{"hnvis", "䬀"},
	{"hnvm", "笃"},
	{"hnwb", "䬑"},
	{"hnwgf", "䵩"},
	{"hnwp", "颸"},
	{"hnwtj", "䬛"},
	{"hnyhv", "製"},
	{"hnyk", "𩖰"},
	{"hnylm", "凪"},
	{"hnymr", "讆"},
	{"hnyr", "颭"},
	{"hnyrb", "䬘"},
	{"hnyt", "䬃"},
	{"hnyta", "䬓"},
	{"hnytr", "䬏"},
	{"hnyub", "䬜"},
	{"ho", "八 彳"},
	{"hoa", "昝"},
	{"hoahu", "𢔰"},
	{"hoamh", "㼒"},
	{"hoami", "得"},
	{"hoamo", "徥"},
	{"hoau", "爬"},
	{"hoaue", "忁"},
	{"hoav", "很"},
	{"hob", "笍"},
	{"hobc", "籲"},
	{"hobg", "篧"},
	{"hobgn", "衢"},
	{"hobgr", "徟"},
	{"hobm", "徂"},
	{"hobme", "㣪"},
	{"hobmr", "㣚"},
	{"hobou", "徭"},
	{"hobrn", "衕"},
	{"hobuc", "䝿"},
	{"hobug", "忂"},
	{"hobvk", "徯"},
	{"hoci", "彸"},
	{"hociu", "㣞"},
	{"hocmn", "銜"},
	{"hocnh", "㣢"},
	{"hodbn", "衞 䘙"},
	{"hodd", "㣩"},
	{"hodhe", "彼"},
	{"hodi", "符"},
	{"hodmq", "徫"},
	{"hodoo", "徠"},
	{"hodqn", "衛"},
	{"hodt", "徕"},
	{"hodwf", "徚"},
	{"hoemn", "衍"},
	{"hof", "熧 䇣"},
	{"hofbk", "徶"},
	{"hofbr", "徜"},
	{"hog", "坕"},
	{"hogdi", "待"},
	{"hoge", "篗 䉶"},
	{"hogg", "徍"},
	{"hoggn", "街"},
	{"hoggu", "徺"},
	{"hogr", "㣟"},
	{"hogtj", "𢔛"},
	{"hogyo", "徒"},
	{"hohaf", "鴔 鴩 䳷"},
	{"hohag", "徨"},
	{"hohdp", "㣰"},
	{"hohdv", "㣦"},
	{"hohfn", "鵆"},
	{"hohg", "䇮"},
	{"hohgn", "衝"},
	{"hohjg", "㣫"},
	{"hohju", "循"},
	{"hohkn", "𧗤"},
	{"hohne", "役"},
	{"hohpm", "彽"},
	{"hohq", "㹐"},
	{"hohqm", "徃"},
	{"hohqo", "瓞 𤔅"},
	{"hohs", "筰 㣗"},
	{"hohsk", "徼"},
	{"hohvo", "㼌"},
	{"hoi", "筏"},
	{"hoib", "籂"},
	{"hoice", "𢓭"},
	{"hoicn", "術"},
	{"hoie", "䈗"},
	{"hoii", "笭 㣤"},
	{"hoij", "㣝"},
	{"hoim", "籤"},
	{"hoimn", "𧗠"},
	{"hoin", "笒"},
	{"hoiop", "㣹"},
	{"hoip", "笩"},
	{"hoir", "篬"},
	{"hoisb", "徧"},
	{"hoiv", "篒"},
	{"hojbj", "㣮"},
	{"hojbm", "徝"},
	{"hojcn", "衠"},
	{"hojjn", "䡓"},
	{"hojlo", "徢"},
	{"hojmf", "徖"},
	{"hojpn", "㣷"},
	{"hojrn", "衚"},
	{"hojwp", "德"},
	{"hok", "笶 㣕"},
	{"hokg", "䉜"},
	{"hoki", "㣖"},
	{"hokmr", "徛"},
	{"hokoo", "㣣"},
	{"hoks", "劮"},
	{"hol", "筗"},
	{"holbu", "㼉"},
	{"hold", "篠"},
	{"holhy", "㣠"},
	{"holii", "瓥"},
	{"holk", "筱"},
	{"holln", "彿"},
	{"holmy", "徘"},
	{"holn", "𠠬"},
	{"holq", "律"},
	{"holw", "㣙"},
	{"holy", "𥮴"},
	{"homb", "籥 䈁"},
	{"homcw", "徆"},
	{"homd", "筡"},
	{"homg", "筌"},
	{"homjn", "衎"},
	{"homk", "箯"},
	{"homm", "签"},
	{"hommm", "徰"},
	{"hommn", "行"},
	{"homn", "㣔 䈩"},
	{"homnf", "鴴"},
	{"homnm", "鸻"},
	{"homo", "簽"},
	{"homr", "答"},
	{"homrn", "衙"},
	{"homtn", "㣜"},
	{"homun", "衏"},
	{"homvm", "徑"},
	{"homvn", "㼻"},
	{"homwf", "徱"},
	{"homym", "征"},
	{"honbn", "䚘"},
	{"honfn", "𢖍"},
	{"honhe", "彶"},
	{"honk", "篌"},
	{"honkn", "衡 𧗽 𧗾"},
	{"honkq", "徤"},
	{"honl", "酂"},
	{"honom", "径"},
	{"hooae", "復"},
	{"hooge", "㸕"},
	{"hoogi", "㣥"},
	{"hooii", "彾"},
	{"hooin", "衑"},
	{"hook", "籢"},
	{"hool", "㣡"},
	{"hooma", "徻"},
	{"hoomd", "徐"},
	{"hooml", "御"},
	{"hoomn", "衘"},
	{"hoomr", "㣛"},
	{"hooo", "籨"},
	{"hoooo", "從"},
	{"hootf", "㣳"},
	{"hooun", "䘖"},
	{"hop", "怣 慫 𢜛"},
	{"hopa", "徇"},
	{"hopd", "彵"},
	{"hopi", "彴 瓝"},
	{"hopr", "㣘"},
	{"hopru", "爮 瓟"},
	{"hopsh", "彻"},
	{"hoqb", "篟"},
	{"hoqfn", "䘘"},
	{"hoqkq", "𢔓"},
	{"hoqmc", "㣱"},
	{"hor", "咎"},
	{"hormg", "徎"},
	{"horn", "箚"},
	{"horsj", "㣬"},
	{"horye", "徦"},
	{"hose", "䈜"},
	{"hosfb", "㣯"},
	{"hosj", "聳"},
	{"hossn", "衐"},
	{"hosyq", "徲"},
	{"hota", "徣"},
	{"hotcn", "衖"},
	{"hotf", "䉑"},
	{"hotio", "徔"},
	{"hotmc", "㣴"},
	{"hotom", "㣸"},
	{"hotq", "徉"},
	{"hotun", "衜"},
	{"hotxc", "㼓"},
	{"hotyo", "従"},
	{"houbk", "幑"},
	{"houce", "㣭"},
	{"houfk", "徽 鰴 黴"},
	{"houfn", "䘗"},
	{"hougk", "徵"},
	{"hourk", "徾 㣲"},
	{"houuk", "微"},
	{"hov", "媭"},
	{"hovbu", "㣧"},
	{"hovie", "後"},
	{"hovjr", "㣨"},
	{"hovni", "㼖"},
	{"hovun", "衟"},
	{"howr", "徊"},
	{"hoy", "䇚"},
	{"hoybk", "徹"},
	{"hoybp", "徿"},
	{"hoybs", "徬"},
	{"hoyck", "㼎"},
	{"hoyg", "往"},
	{"hoygq", "㣵"},
	{"hoyhs", "彷"},
	{"hoyin", "衒"},
	{"hoyj", "斞"},
	{"hoylh", "徏"},
	{"hoylo", "徙"},
	{"hoynn", "䘕"},
	{"hoyrv", "忀"},
	{"hoytg", "徸"},
	{"hoytj", "𢕔"},
	{"hoywm", "㣶"},
	{"hp", "乇"},
	{"hpa", "昏 筍"},
	{"hpad", "箰"},
	{"hpd", "竾"},
	{"hpdk", "筷"},
	{"hph", "䇖"},
	{"hphaf", "鵖 䲭"},
	{"hphh", "笏"},
	{"hpi", "𥫩"},
	{"hpim", "笉"},
	{"hpj", "氒"},
	{"hpkf", "䈐"},
	{"hpko", "籎"},
	{"hpkp", "䈡"},
	{"hpks", "㔞 㔡"},
	{"hplb", "帋"},
	{"hpln", "剩"},
	{"hpm", "氐"},
	{"hpmbc", "頿 顖"},
	{"hpmvu", "旣"},
	{"hpnl", "鄎"},
	{"hpp", "笓"},
	{"hppj", "筚"},
	{"hpr", "笱"},
	{"hpru", "笣"},
	{"hpsl", "印 卽"},
	{"hpt", "笹"},
	{"hptd", "䈎"},
	{"hpuu", "篘"},
	{"hpye", "㪓"},
	{"hq", "牛 牜"},
	{"hqapv", "㹇"},
	{"hqate", "犦"},
	{"hqau", "筢 㸭"},
	{"hqawe", "𤛔"},
	{"hqb", "乕"},
	{"hqbdi", "㸹"},
	{"hqbjj", "㹆"},
	{"hqbmc", "犋"},
	{"hqbtu", "犅"},
	{"hqbu", "看"},
	{"hqbuc", "㸽"},
	{"hqbuk", "煟"},
	{"hqby", "𤘪"},
	{"hqcsh", "㸮"},
	{"hqd", "筙"},
	{"hqda", "籍"},
	{"hqeq", "箨"},
	{"hqfb", "䈰"},
	{"hqffr", "㹚"},
	{"hqffu", "㹙"},
	{"hqfqo", "㹖"},
	{"hqfqu", "犈"},
	{"hqg", "牡"},
	{"hqgbn", "㸿"},
	{"hqgdi", "特"},
	{"hqggu", "㹓"},
	{"hqgni", "㹗"},
	{"hqgr", "㸵"},
	{"hqgwc", "犢"},
	{"hqhdj", "煐"},
	{"hqhej", "㸼"},
	{"hqhgr", "牿"},
	{"hqhj", "篺"},
	{"hqhkb", "犞"},
	{"hqhl", "䇽"},
	{"hqhml", "㸫"},
	{"hqhmr", "㸸"},
	{"hqhp", "䉥"},
	{"hqhpm", "牴"},
	{"hqhq", "牪"},
	{"hqhqm", "牲"},
	{"hqhqq", "犇"},
	{"hqhqu", "牦"},
	{"hqhw", "籀"},
	{"hqi", "我"},
	{"hqiih", "犙"},
	{"hqiok", "㸻"},
	{"hqipc", "㹑"},
	{"hqipf", "犥"},
	{"hqisb", "犏"},
	{"hqiuh", "牻"},
	{"hqjb", "㸬"},
	{"hqjbd", "㹀"},
	{"hqjbm", "犆"},
	{"hqjm", "篲"},
	{"hqjmm", "𤚗"},
	{"hqjnd", "牸"},
	{"hqjnk", "犊"},
	{"hqjp", "㸰"},
	{"hqjqr", "犗"},
	{"hqjr", "牯"},
	{"hqjru", "𤙥"},
	{"hqka", "箺"},
	{"hqki", "筹"},
	{"hqkmr", "犄"},
	{"hqks", "牞"},
	{"hqlll", "㸪"},
	{"hqlw", "牰"},
	{"hqlxh", "牬"},
	{"hqm", "生"},
	{"hqmb", "箐"},
	{"hqmbb", "㹘"},
	{"hqmc", "簀"},
	{"hqmce", "㹛"},
	{"hqmcw", "牺"},
	{"hqmhf", "㹉"},
	{"hqmj", "㸩"},
	{"hqmmr", "牾"},
	{"hqmnr", "牱"},
	{"hqmo", "箦"},
	{"hqmqj", "拜"},
	{"hqmtb", "犡"},
	{"hqmvm", "牼"},
	{"hqmw", "籒"},
	{"hqmwm", "㹔"},
	{"hqn", "㐦"},
	{"hqnbg", "觕"},
	{"hqnkq", "煋"},
	{"hqo", "失"},
	{"hqoa", "簮"},
	{"hqobg", "㹊"},
	{"hqoe", "䉟"},
	{"hqoii", "㸳"},
	{"hqok", "牧"},
	{"hqolh", "㹋"},
	{"hqomg", "牷"},
	{"hqond", "犔"},
	{"hqoo", "籡"},
	{"hqopd", "㸱"},
	{"hqos", "㸲"},
	{"hqp", "牝"},
	{"hqpd", "牠"},
	{"hqphh", "物"},
	{"hqpkp", "㹅"},
	{"hqpuu", "犓"},
	{"hqr", "筘 𤘘"},
	{"hqrj", "䉗"},
	{"hqrs", "箉"},
	{"hqrye", "煰"},
	{"hqsb", "箍"},
	{"hqshi", "牣"},
	{"hqsip", "㸾"},
	{"hqta", "簎"},
	{"hqtb", "簼"},
	{"hqtce", "犪"},
	{"hqtco", "㹒"},
	{"hqtgi", "犠"},
	{"hqtgs", "犧"},
	{"hqthb", "犕"},
	{"hqtlm", "㹏"},
	{"hqtm", "箝"},
	{"hqtq", "䍧"},
	{"hqu", "毛"},
	{"hqvl", "㸨"},
	{"hqvvv", "犣"},
	{"hqwc", "牭"},
	{"hqwce", "㹄"},
	{"hqwj", "籜"},
	{"hqwk", "㸶"},
	{"hqwlp", "犤"},
	{"hqwvf", "㹎"},
	{"hqwyi", "牳"},
	{"hqyaj", "𤙴"},
	{"hqybp", "𤜆"},
	{"hqycb", "㹍"},
	{"hqydk", "犜"},
	{"hqyhm", "㹌"},
	{"hqyhn", "牨"},
	{"hqyhs", "牥"},
	{"hqyj", "㸯"},
	{"hqyrb", "犒"},
	{"hqyrd", "犉"},
	{"hqyrf", "㹁"},
	{"hqytg", "犝"},
	{"hqytr", "犃"},
	{"hqyv", "牤"},
	{"hraph", "舓"},
	{"hrau", "䇼"},
	{"hrb", "䑚"},
	{"hrbc", "篔"},
	{"hrbmm", "䑙"},
	{"hrbo", "筼"},
	{"hrdlc", "𦧺"},
	{"hre", "洜"},
	{"hrff", "舕"},
	{"hrgb", "舑"},
	{"hrhaf", "鴭 鴰 鵅 鵠"},
	{"hrhkp", "舔"},
	{"hrhml", "㪾"},
	{"hrhpm", "煘 迣 錕 鬳"},
	{"hrhr", "筥"},
	{"hrhrr", "舙"},
	{"hrhvi", "䑛"},
	{"hrhvp", "舐"},
	{"hrihu", "䦾"},
	{"hrj", "阜"},
	{"hrks", "勂 㔚"},
	{"hrlb", "帥"},
	{"hrlmi", "蛗"},
	{"hrln", "刮 劄 㓢"},
	{"hrlr", "𨸏"},
	{"hrmbc", "頟 頧 䫠"},
	{"hrmg", "䇸"},
	{"hrmlb", "師"},
	{"hrmr", "簬"},
	{"hrncr", "舚"},
	{"hrnl", "郈 郜"},
	{"hrno", "㰶"},
	{"hrog", "雒 䧼"},
	{"hrok", "啟"},
	{"hrp", "惒"},
	{"hrptd", "䑜"},
	{"hrpym", "鹄"},
	{"hrrj", "簞"},
	{"hrrk", "䉷"},
	{"hrse", "䈔"},
	{"hrsj", "箿"},
	{"hrsmm", "䎊 䎋"},
	{"hrsn", "䇷"},
	{"hrtm", "甜"},
	{"hru", "乱 峊"},
	{"hruc", "簨"},
	{"hrvk", "筽"},
	{"hrvl", "舏"},
	{"hrvp", "笢"},
	{"hrwvf", "𦧲"},
	{"hryf", "烏"},
	{"hrytj", "辞"},
	{"hs", "乍 戶"},
	{"hsb", "肩"},
	{"hsbr", "扃"},
	{"hsbt", "扁"},
	{"hsec", "䉯"},
	{"hsf", "勲"},
	{"hsff", "扊"},
	{"hsfi", "𥳀"},
	{"hshaf", "𩿞"},
	{"hshml", "所"},
	{"hshne", "殷 𣪧"},
	{"hshr", "笤"},
	{"hshu", "䇻 𠒎"},
	{"hsik", "戾"},
	{"hsit", "籃"},
	{"hsj", "䇯"},
	{"hsje", "箃"},
	{"hsji", "䉁"},
	{"hsk", "笋"},
	{"hsko", "篋"},
	{"hskr", "䇹"},
	{"hskt", "箧"},
	{"hslc", "籄"},
	{"hsll", "䇫"},
	{"hslmy", "扉"},
	{"hsly", "篚"},
	{"hsmb", "箒"},
	{"hsmbc", "頺 䫵"},
	{"hsmbl", "𥤃"},
	{"hsmg", "筐 籊"},
	{"hsmi", "筺"},
	{"hsmr", "笥"},
	{"hsms", "㐆"},
	{"hsno", "㰾"},
	{"hsog", "雇"},
	{"hsok", "敫"},
	{"hsp", "怎 憅"},
	{"hspd", "㦾"},
	{"hsqf", "篤"},
	{"hsr", "笸"},
	{"hsrau", "扈"},
	{"hsru", "戺"},
	{"hssmm", "扇"},
	{"hsw", "㧂"},
	{"hswl", "筪"},
	{"hsyhs", "房"},
	{"hsyhv", "扆"},
	{"hsyj", "戽"},
	{"hsyjj", "箳"},
	{"hsyr", "扂"},
	{"hsyu", "𡷊"},
	{"ht", "升"},
	{"htbk", "䉈"},
	{"htbn", "箭"},
	{"htce", "簸"},
	{"htcg", "簊"},
	{"htcl", "簛"},
	{"hte", "𣲛"},
	{"htfq", "衅"},
	{"htg", "𡉼"},
	{"htgi", "䉝"},
	{"hthaf", "鷑"},
	{"hther", "衉"},
	{"hthhv", "衇"},
	{"htice", "䘒"},
	{"htine", "䘑"},
	{"htjhr", "䘔"},
	{"htjs", "簕"},
	{"htkr", "箬"},
	{"htlm", "䈽"},
	{"htln", "剰 㔍"},
	{"htm", "䇞"},
	{"htmc", "箕 簧"},
	{"htmf", "衃"},
	{"htmo", "篏"},
	{"htng", "衄"},
	{"htnhx", "䘓"},
	{"htnl", "䘏"},
	{"htno", "欰"},
	{"htoe", "籆"},
	{"htoho", "衆"},
	{"htshc", "䘐"},
	{"htshi", "衂"},
	{"htsj", "衈"},
	{"htsl", "卹"},
	{"htt", "䈂"},
	{"httb", "篝"},
	{"httwi", "衊"},
	{"htvi", "䈘"},
	{"htvn", "䉇"},
	{"htw", "筁"},
	{"htxc", "䈴"},
	{"hu", "屲"},
	{"hua", "㬱"},
	{"huam", "曁"},
	{"huasm", "㲩"},
	{"hubo", "赞"},
	{"hubuc", "贊"},
	{"hubuu", "覒"},
	{"huce", "䈦"},
	{"hud", "臬"},
	{"hudm", "𦤎"},
	{"hue", "㲑"},
	{"hueii", "㲧"},
	{"huf", "毜 熈 𤆬"},
	{"hufd", "毩"},
	{"huff", "毯"},
	{"hug", "墍"},
	{"huhaf", "鵚 鶂 鶞 鷉"},
	{"huhgu", "兟 毨"},
	{"huhhh", "毝"},
	{"huhon", "𠒣"},
	{"huhor", "㲮"},
	{"huhqu", "㲎"},
	{"huhud", "㯔"},
	{"huhuf", "䄟"},
	{"huhup", "㦌"},
	{"huhuu", "毳"},
	{"huihi", "㲓"},
	{"huihq", "毪"},
	{"huij", "毧"},
	{"huije", "毬"},
	{"huik", "臭"},
	{"huikh", "毶"},
	{"huikk", "瞂"},
	{"huioj", "臯"},
	{"hujcs", "臱"},
	{"hukq", "𦤑"},
	{"hulmc", "穨"},
	{"hulmy", "毴"},
	{"huln", "𠜎"},
	{"humb", "篅"},
	{"humbc", "頹 䫁 䫢"},
	{"humcw", "毢"},
	{"hummu", "𠒑"},
	{"humnp", "臰"},
	{"hune", "䈄"},
	{"hunhs", "㲌"},
	{"hunkq", "毽"},
	{"hunl", "郋 郳 䢾 𠒒"},
	{"huno", "歋 㰫"},
	{"hunwa", "氌"},
	{"huog", "㲝"},
	{"huoin", "㲐"},
	{"huok", "㪇"},
	{"huomn", "毺"},
	{"huooo", "臮"},
	{"hup", "息 憩"},
	{"hupa", "毥"},
	{"hupfd", "毱"},
	{"hupru", "𣭚"},
	{"hutak", "氁"},
	{"hutca", "氆"},
	{"huu", "嵆"},
	{"huv", "㛷"},
	{"huvvv", "㲱"},
	{"huwml", "鼻"},
	{"huwp", "毸"},
	{"huye", "㪒"},
	{"huyiu", "㲙"},
	{"huyj", "𣁽"},
	{"huymr", "諬"},
	{"huyr", "毡"},
	{"huytj", "辠"},
	{"huytr", "毰"},
	{"huywm", "氊"},
	{"hv", "𧘇"},
	{"hvajv", "鼹"},
	{"hvau", "䉋"},
	{"hvbjj", "鼲"},
	{"hvbu", "覣"},
	{"hvbuc", "鼰"},
	{"hvbuk", "鼳"},
	{"hvbuu", "覛"},
	{"hvbvk", "鼷"},
	{"hvcsh", "鼢"},
	{"hvd", "乐"},
	{"hvdl", "簖"},
	{"hve", "笯"},
	{"hvfb", "䈫"},
	{"hvfi", "箹 䈙"},
	{"hvfy", "䈺"},
	{"hvgdi", "鼭"},
	{"hvher", "䶅"},
	{"hvhey", "鼨"},
	{"hvhhw", "䶉"},
	{"hvhi", "魏"},
	{"hvhqm", "鼪"},
	{"hvhu", "兜"},
	{"hvhyu", "鼶"},
	{"hvibi", "䶈"},
	{"hvif", "系"},
	{"hvik", "鼣"},
	{"hvikk", "鼥"},
	{"hvil", "籪"},
	{"hvio", "瓜"},
	{"hvjck", "鼵"},
	{"hvjp", "鼧"},
	{"hvlw", "鼬"},
	{"hvlwb", "䶇"},
	{"hvmbc", "䫋"},
	{"hvmfj", "䶄"},
	{"hvmi", "䉃"},
	{"hvmmr", "鼯"},
	{"hvmr", "鼫"},
	{"hvmvn", "瑏"},
	{"hvnkg", "鼮"},
	{"hvno", "篆"},
	{"hvog", "䶆"},
	{"hvoin", "䶃"},
	{"hvp", "氏"},
	{"hvpi", "䶂"},
	{"hvpr", "鼩"},
	{"hvqmb", "鼱"},
	{"hvr", "筎"},
	{"hvsav", "鼴"},
	{"hvshr", "鼦"},
	{"hvsl", "卬"},
	{"hvsm", "鸟"},
	{"hvtxc", "鼸"},
	{"hvvv", "䉭"},
	{"hvwww", "鼺"},
	{"hvyk", "鼤"},
	{"hw", "甶"},
	{"hwe", "笝"},
	{"hwgti", "睾"},
	{"hwhaf", "鶹 鷭"},
	{"hwhd", "箘"},
	{"hwhu", "𠒇"},
	{"hwim", "簂"},
	{"hwjr", "箇"},
	{"hwk", "囟 筃"},
	{"hwkk", "囪"},
	{"hwks", "勫"},
	{"hwl", "笚"},
	{"hwlb", "簚"},
	{"hwlc", "簤"},
	{"hwlg", "籮"},
	{"hwli", "篾"},
	{"hwln", "箩 䉚"},
	{"hwmbc", "䪿"},
	{"hwml", "箅"},
	{"hwmvn", "㽃"},
	{"hwmvs", "粵"},
	{"hwni", "䇱"},
	{"hwnk", "囱"},
	{"hwnl", "鄱"},
	{"hwno", "㰱"},
	{"hwnoo", "飜"},
	{"hwp", "悤 𥯨"},
	{"hwpym", "鹠"},
	{"hwsmm", "翻"},
	{"hwtj", "篳"},
	{"hwvf", "䉂"},
	{"hwww", "䉪"},
	{"hx", "臼 𦥑"},
	{"hxamh", "䑗"},
	{"hxbc", "興"},
	{"hxbt", "盥"},
	{"hxfd", "䊆"},
	{"hxh", "身"},
	{"hxhaf", "䳎 䳔"},
	{"hxhnq", "䑕"},
	{"hxhu", "兒"},
	{"hxjb", "䑔"},
	{"hxjc", "輿"},
	{"hxjlo", "䑖"},
	{"hxkc", "舆"},
	{"hxlb", "帠"},
	{"hxle", "叟"},
	{"hxmmv", "䢅 䢉"},
	{"hxno", "歃"},
	{"hxo", "臾"},
	{"hxt", "舁"},
	{"hxtqm", "䑘"},
	{"hxu", "龜"},
	{"hxvyv", "鼠"},
	{"hxwks", "舅"},
	{"hxyc", "與"},
	{"hxyf", "舃 舄"},
	{"hyab", "䑵"},
	{"hyabu", "艒"},
	{"hyaj", "䈇"},
	{"hyasm", "䑽"},
	{"hyau", "舥"},
	{"hybb", "簻 𥰆"},
	{"hybg", "籬"},
	{"hybhu", "舰"},
	{"hybmr", "𦨴"},
	{"hybmw", "䒄"},
	{"hybnd", "艀"},
	{"hybp", "籠"},
	{"hybs", "篣"},
	{"hybt", "盘"},
	{"hybuu", "䚀"},
	{"hyci", "舩"},
	{"hyck", "筊"},
	{"hycnh", "䑯"},
	{"hycr", "船"},
	{"hyd", "㭧"},
	{"hydhe", "㿭 𦨭"},
	{"hydoo", "𦩑"},
	{"hyei", "䑡"},
	{"hyem", "䑭"},
	{"hyfb", "艄"},
	{"hyfbw", "艡"},
	{"hyfqf", "䲍"},
	{"hyfqu", "䒅"},
	{"hyg", "䇠"},
	{"hygow", "艢"},
	{"hyha", "舶"},
	{"hyhab", "艊"},
	{"hyhaf", "鵃 䳉"},
	{"hyhag", "艎"},
	{"hyhe", "舨"},
	{"hyhej", "艂"},
	{"hyheq", "舽"},
	{"hyhgr", "艁"},
	{"hyhhh", "䑣"},
	{"hyhj", "篷"},
	{"hyhlo", "艞"},
	{"hyhm", "簅"},
	{"hyhn", "笐"},
	{"hyhne", "般"},
	{"hyhni", "舤 䑺"},
	{"hyhoi", "䒀"},
	{"hyhr", "簉"},
	{"hyhs", "籩 舴"},
	{"hyhsb", "艑"},
	{"hyhxe", "艘"},
	{"hyiav", "艆"},
	{"hyik", "舣"},
	{"hyisb", "䑷"},
	{"hyite", "艔"},
	{"hyjfe", "䑹"},
	{"hyjj", "䉸"},
	{"hyjmf", "䑸"},
	{"hyjmw", "䒇"},
	{"hyjnu", "䑱"},
	{"hyjoa", "䑿"},
	{"hyjp", "舵"},
	{"hyjr", "䑩"},
	{"hyjtc", "䒈"},
	{"hyki", "舦"},
	{"hykms", "舿"},
	{"hykpb", "艜"},
	{"hyks", "笾"},
	{"hyl", "舯"},
	{"hylm", "䇛"},
	{"hylmo", "䑬"},
	{"hylw", "舳"},
	{"hylwv", "艛"},
	{"hym", "舡"},
	{"hymbs", "艝"},
	{"hymcw", "舾"},
	{"hymlm", "𦩒"},
	{"hymnr", "舸"},
	{"hymo", "篴"},
	{"hymr", "䇾"},
	{"hymu", "䉦 䑢"},
	{"hyndt", "艋"},
	{"hynhe", "䑥"},
	{"hynkg", "艇"},
	{"hynl", "郍"},
	{"hynn", "䑠"},
	{"hynot", "艠"},
	{"hynri", "艬"},
	{"hynsd", "䑮"},
	{"hynwa", "艪"},
	{"hynxu", "䶱"},
	{"hyodi", "䑧"},
	{"hyoe", "䉨"},
	{"hyog", "䧷"},
	{"hyoge", "艭 䑾"},
	{"hyoii", "舲"},
	{"hyoin", "䑤"},
	{"hyoip", "艌 𦨮"},
	{"hyoir", "艙"},
	{"hyoj", "箤"},
	{"hyomb", "䑳"},
	{"hyomd", "艅"},
	{"hyomr", "䑪"},
	{"hyono", "𦩂"},
	{"hyopd", "䑨"},
	{"hyosu", "舱"},
	{"hyotq", "䒉"},
	{"hypc", "簴"},
	{"hypm", "𥲤"},
	{"hypp", "舭"},
	{"hypr", "䑦"},
	{"hypt", "籚"},
	{"hyptd", "艓"},
	{"hypu", "箎 虒"},
	{"hypuu", "䑼"},
	{"hypym", "鸼"},
	{"hyqmb", "䑶"},
	{"hyr", "笘"},
	{"hyra", "䈞"},
	{"hyrb", "篙"},
	{"hyrji", "艥"},
	{"hyrl", "篰"},
	{"hyrn", "籝 籯"},
	{"hyro", "籇"},
	{"hyrv", "䉴"},
	{"hyryo", "䟟"},
	{"hysc", "籏"},
	{"hysd", "箷"},
	{"hysh", "舠"},
	{"hyshu", "艉"},
	{"hysit", "艦"},
	{"hysjr", "艍"},
	{"hysk", "簇"},
	{"hysm", "𥰁"},
	{"hysma", "䒁"},
	{"hysmm", "䎇"},
	{"hysy", "箊"},
	{"hyt", "笠"},
	{"hytb", "𥴰"},
	{"hytbo", "艨"},
	{"hytc", "舼"},
	{"hytct", "艗"},
	{"hyte", "䈛"},
	{"hytgi", "艤"},
	{"hythu", "艏"},
	{"hytj", "𥭴"},
	{"hytmc", "䑴"},
	{"hytoe", "艧"},
	{"hytqm", "艖"},
	{"hytr", "箁 䈮"},
	{"hytt", "䑫"},
	{"hytu", "篭"},
	{"hytv", "䈉"},
	{"hytwa", "艚"},
	{"hyu", "舢"},
	{"hyub", "篱"},
	{"hyuce", "艐"},
	{"hyv", "笀"},
	{"hyvmi", "䒂"},
	{"hyvu", "䈍"},
	{"hywg", "艃"},
	{"hywl", "舺"},
	{"hywm", "䉡"},
	{"hywv", "簑"},
	{"hyy", "笇"},
	{"hyyaj", "䑲"},
	{"hyybk", "䒆"},
	{"hyybs", "艕"},
	{"hyyhn", "航"},
	{"hyyhr", "䒃"},
	{"hyyhs", "舫"},
	{"hyyiu", "艈"},
	{"hyylh", "䑰"},
	{"hyyo", "籧"},
	{"hyyps", "艣"},
	{"hyypt", "艫"},
	{"hyys", "舻"},
	{"hyysd", "䑻"},
	{"hyytg", "艟"},
	{"hyyvi", "舷"},
	{"hyyx", "艩"},
	{"i", "戈"},
	{"iaie", "廄"},
	{"iaiu", "廐"},
	{"iam", "㡺"},
	{"iav", "良 㡾"},
	{"ib", "禸 䏍"},
	{"ibbr", "㢐"},
	{"ibbt", "盙"},
	{"ibcn", "廁"},
	{"ibcv", "廮"},
	{"ibd", "㮾"},
	{"ibdi", "尃"},
	{"ibg", "塱"},
	{"ibgi", "䏻"},
	{"ibhaf", "鵏 鷛 䳌"},
	{"ibhhh", "㣑"},
	{"ibhqu", "㲢"},
	{"ibhvo", "㼐"},
	{"ibln", "㓲"},
	{"ibm", "㡹"},
	{"ibn", "乶"},
	{"ibnl", "郙 鄘"},
	{"ibo", "贠"},
	{"ibpp", "能"},
	{"ibrp", "喸"},
	{"ibsh", "廫"},
	{"ibsqf", "騗"},
	{"ibuc", "貟"},
	{"ibyhs", "旉"},
	{"icff", "𤒼"},
	{"ichaf", "𪇵"},
	{"iche", "夋"},
	{"icid", "庺"},
	{"icln", "劆"},
	{"icnl", "鄺"},
	{"icno", "廞"},
	{"icp", "怷"},
	{"id", "床 术"},
	{"idb", "㢀"},
	{"idbbb", "䯢"},
	{"idbbr", "𪎩"},
	{"idbu", "廂"},
	{"idf", "𤇍"},
	{"idfd", "糜"},
	{"idg", "塺"},
	{"idhaf", "䳸"},
	{"idhd", "穈"},
	{"idhda", "黁"},
	{"idhi", "魔 麽"},
	{"idhq", "犘"},
	{"idhqu", "麾"},
	{"idjtc", "黂"},
	{"idlmy", "靡"},
	{"idlyf", "爢 㸏"},
	{"idm", "㡷"},
	{"idmr", "磨"},
	{"idok", "䵇"},
	{"idomn", "䵉"},
	{"idoo", "庲"},
	{"idp", "怸 㥻 㦄"},
	{"idq", "摩"},
	{"idrhr", "麿"},
	{"ids", "书"},
	{"idsje", "黀"},
	{"idvi", "麼"},
	{"idvif", "縻"},
	{"idymr", "䜆"},
	{"ie", "氷"},
	{"iea", "昶"},
	{"iebt", "盚"},
	{"iec", "䥭"},
	{"iedhe", "皴"},
	{"iehaf", "鵕"},
	{"iehhh", "𢒋"},
	{"iekn", "㐜"},
	{"ieln", "剫"},
	{"ienau", "𠬍"},
	{"ienl", "䣇"},
	{"ieno", "㱂"},
	{"ienui", "㕙"},
	{"ieok", "救"},
	{"ieyhv", "裘"},
	{"if", "厼 礻 ⺬"},
	{"ifaa", "𥚕"},
	{"ifam", "𥘵"},
	{"ifamh", "禓"},
	{"ifamo", "禔"},
	{"ifaoc", "禵"},
	{"ifasm", "禢"},
	{"ifbac", "䄙"},
	{"ifbbr", "禍"},
	{"ifbgr", "禂"},
	{"ifbhu", "视"},
	{"ifbjj", "禈"},
	{"ifbk", "廠"},
	{"ifbm", "祖"},
	{"ifbme", "禐"},
	{"ifbof", "䄞"},
	{"ifbuu", "視"},
	{"ifcnh", "祶"},
	{"ifcru", "祱"},
	{"ifcwj", "禅"},
	{"ifdlc", "䄤"},
	{"ifdmq", "禕"},
	{"ife", "㵗"},
	{"ifeee", "䄌"},
	{"ifew", "䄕"},
	{"iffkc", "禷"},
	{"iffmu", "𥙑"},
	{"ifg", "社"},
	{"ifgce", "祾"},
	{"ifgi", "祛"},
	{"ifgni", "禱"},
	{"ifgp", "䄊"},
	{"ifgr", "祮"},
	{"ifgrc", "𥜝"},
	{"ifgrr", "禧"},
	{"ifgwc", "䄣"},
	{"ifhaf", "鷓"},
	{"ifhag", "䄓"},
	{"ifhg", "祍"},
	{"ifhgr", "祰"},
	{"ifhhj", "禆"},
	{"ifhjd", "祩"},
	{"ifhjr", "䄆"},
	{"ifhk", "祅"},
	{"ifhlb", "䄔"},
	{"ifhml", "祈 㫂"},
	{"ifhn", "凴"},
	{"ifhne", "祋"},
	{"ifhpa", "䄑"},
	{"ifhpm", "祗"},
	{"ifhqi", "䄉"},
	{"ifhqo", "祑"},
	{"ifhs", "祚"},
	{"ifhuc", "禶"},
	{"ifhvp", "祇"},
	{"ifhyu", "禠"},
	{"ifi", "䄀"},
	{"ifibi", "禣"},
	{"ifikk", "祓"},
	{"ifilr", "禟"},
	{"ifit", "祴"},
	{"ifjbc", "禛"},
	{"ifjbm", "禃"},
	{"ifjd", "祙"},
	{"ifje", "䃽"},
	{"ifjka", "禇"},
	{"ifjr", "祜"},
	{"ifklu", "䄋"},
	{"ifkmr", "䄎"},
	{"ifkpb", "𥛣"},
	{"ifkr", "祐"},
	{"ifl", "祌"},
	{"iflbk", "䄃"},
	{"ifllv", "䄛"},
	{"iflmo", "祧"},
	{"iflpb", "禙"},
	{"iflpc", "𥜥"},
	{"iflw", "䄂"},
	{"iflwl", "神"},
	{"iflxl", "䄗"},
	{"ifm", "应"},
	{"ifmbc", "顣"},
	{"ifmbo", "䄥"},
	{"ifmfb", "禰"},
	{"ifmig", "祬"},
	{"ifmk", "祆"},
	{"ifmmv", "祳"},
	{"ifmr", "祏"},
	{"ifmrt", "䄈"},
	{"ifmrw", "福"},
	{"ifmtb", "禲"},
	{"ifmwg", "禋"},
	{"ifmwj", "禫"},
	{"ifncr", "䄡"},
	{"ifnf", "祢"},
	{"ifnhs", "礽"},
	{"ifnl", "祁 鄬"},
	{"ifnme", "禄"},
	{"ifnmu", "祪"},
	{"ifnvm", "祃"},
	{"ifodi", "祔"},
	{"ifohv", "祣"},
	{"ifoip", "䄒"},
	{"ifoll", "祄"},
	{"ifoma", "禬"},
	{"ifomb", "禴"},
	{"ifomr", "祫"},
	{"ifomv", "䄖"},
	{"ifp", "慼 憑"},
	{"ifpd", "祂"},
	{"ifph", "祕"},
	{"ifpi", "礿"},
	{"ifpou", "祹"},
	{"ifpp", "䃾"},
	{"ifpt", "䄁"},
	{"ifpym", "鹧"},
	{"ifqhk", "禊"},
	{"ifqki", "祷"},
	{"ifqkx", "䄝"},
	{"ifqo", "䃿"},
	{"ifqs", "祎"},
	{"ifr", "㗤"},
	{"ifrhg", "䄇"},
	{"ifrhu", "祝"},
	{"ifrmk", "祦"},
	{"ifrob", "祸"},
	{"ifrrj", "禪"},
	{"ifru", "祀"},
	{"ifryo", "蹙"},
	{"ifs", "㞝"},
	{"ifshr", "祒"},
	{"ifsme", "祲"},
	{"ifsmm", "祤"},
	{"ifsmr", "祠"},
	{"ifsqf", "禡"},
	{"ifta", "䄍"},
	{"iftcg", "禥"},
	{"iftcw", "禉"},
	{"iftgf", "禚"},
	{"iftgr", "𥛶"},
	{"ifthk", "䄏"},
	{"iftmc", "祺"},
	{"iftmd", "禖"},
	{"iftq", "祥"},
	{"iftvi", "禌"},
	{"iftwa", "䄚"},
	{"iftwt", "禮"},
	{"iftwv", "禯"},
	{"ifu", "礼"},
	{"ifvii", "禨"},
	{"ifvne", "祿"},
	{"ifvno", "禒"},
	{"ifwce", "禝"},
	{"ifwd", "祼"},
	{"ifwg", "𥚃"},
	{"ifwjr", "祻"},
	{"ifwk", "䄄"},
	{"ifwlb", "禑"},
	{"ifwlm", "禤"},
	{"ifwp", "禗"},
	{"ifwtc", "禩"},
	{"ify", "䃼"},
	{"ifybb", "禘"},
	{"ifybc", "禎"},
	{"ifybo", "祯"},
	{"ifybs", "䄘"},
	{"ifyhs", "祊"},
	{"ifylm", "祉"},
	{"ifyoj", "祽"},
	{"ifyrb", "禞"},
	{"ifyrv", "禳"},
	{"ifyto", "禭"},
	{"ifyub", "䄜"},
	{"ifywm", "䄠"},
	{"ifyx", "䄢"},
	{"ig", "庄"},
	{"igb", "膺"},
	{"igbt", "䀅"},
	{"igce", "庱"},
	{"igdi", "庤"},
	{"ige", "㕠"},
	{"ighaf", "鷹"},
	{"igi", "庒"},
	{"igit", "廅"},
	{"igj", "凖"},
	{"ignl", "鄽"},
	{"igow", "廧"},
	{"igp", "應"},
	{"igsk", "廒"},
	{"igti", "廚"},
	{"igyhv", "装"},
	{"ih", "戊"},
	{"ihaf", "𩾷"},
	{"ihdc", "廭"},
	{"ihdp", "㢉"},
	{"ihdw", "㢖"},
	{"iher", "㦴"},
	{"ihey", "庝"},
	{"ihhi", "螷 蠯"},
	{"ihhj", "庳"},
	{"ihhl", "㡻"},
	{"ihhqu", "毿"},
	{"ihhw", "廇"},
	{"ihi", "廆 戍"},
	{"ihjx", "㢎"},
	{"ihkb", "㢗"},
	{"ihlbu", "㓄"},
	{"ihln", "剼"},
	{"ihm", "戌"},
	{"ihmbc", "䫩"},
	{"ihmf", "烕"},
	{"ihml", "庍"},
	{"ihmr", "咸"},
	{"ihmv", "威"},
	{"ihoo", "㢔"},
	{"ihp", "㡯"},
	{"ihpe", "廏"},
	{"ihpm", "底"},
	{"ihq", "牟"},
	{"ihrr", "㢂"},
	{"ihs", "成"},
	{"ihsh", "𢦓"},
	{"ihu", "允"},
	{"ihvp", "㡳"},
	{"ihxe", "廋"},
	{"ihxo", "庾"},
	{"ihymf", "戚"},
	{"ii", "広 戔 㕕 㡲"},
	{"iiav", "㢃"},
	{"iib", "朗"},
	{"iibt", "盞"},
	{"iibu", "䁉"},
	{"iibyj", "斚"},
	{"iif", "㷱"},
	{"iii", "厽"},
	{"iiid", "㕖"},
	{"iiif", "絫 㕘"},
	{"iiig", "垒"},
	{"iiih", "參"},
	{"iiil", "廊"},
	{"iiim", "叄"},
	{"iiip", "叅"},
	{"iijb", "庯"},
	{"iikp", "庞"},
	{"iiln", "剆 剗"},
	{"iilq", "肈"},
	{"iim", "㦯"},
	{"iinl", "郎 䣌"},
	{"iino", "欴"},
	{"iiobo", "腐"},
	{"iirau", "郒"},
	{"iis", "庐"},
	{"iiuh", "庬"},
	{"iive", "废"},
	{"iivif", "䋯"},
	{"iixp", "廘"},
	{"iiypu", "虦"},
	{"ij", "戎"},
	{"ijb", "甫"},
	{"ijbt", "盏"},
	{"ijc", "朮"},
	{"ijcc", "麻"},
	{"ijdd", "䢄"},
	{"ije", "庋 求"},
	{"ijfe", "廀"},
	{"ijjb", "廟"},
	{"ijjn", "㐣"},
	{"ijjp", "廤"},
	{"ijkd", "庨"},
	{"ijln", "刬"},
	{"ijwj", "庫"},
	{"ik", "义 庆 犬"},
	{"ikb", "䏿"},
	{"ikbu", "䁈"},
	{"ikbuc", "貵"},
	{"ikd", "𣘼"},
	{"ikhaf", "䳊"},
	{"ikhhh", "参"},
	{"ikhni", "飆"},
	{"ikhnk", "飙"},
	{"ikik", "㹜"},
	{"ikikk", "猋"},
	{"ikjwj", "軬"},
	{"ikk", "犮"},
	{"iklq", "𦘦"},
	{"iklu", "庵"},
	{"ikmg", "𤨣"},
	{"ikmmm", "叁"},
	{"ikmr", "㢊"},
	{"iknf", "為"},
	{"ikno", "欸"},
	{"ikop", "㥷"},
	{"ikp", "慦 龙"},
	{"ikpb", "廗"},
	{"ikq", "库"},
	{"ikr", "啓"},
	{"ikrm", "彧"},
	{"iksi", "为"},
	{"iku", "尤"},
	{"ikw", "畚"},
	{"ikye", "㪐"},
	{"ilb", "庸"},
	{"ile", "康"},
	{"ilg", "𡏅"},
	{"ilil", "州"},
	{"illmi", "䗝"},
	{"ilmo", "庣"},
	{"ilmy", "䨾"},
	{"iln", "划"},
	{"ilo", "庚"},
	{"ilob", "𢉼"},
	{"iloc", "賡"},
	{"iloo", "赓"},
	{"ilq", "㡽"},
	{"ilr", "唐"},
	{"ils", "门"},
	{"ilw", "庙"},
	{"ilwp", "曵 㡼"},
	{"ilwv", "廔"},
	{"im", "冫"},
	{"imbac", "凕"},
	{"imbcr", "㓏"},
	{"imbgr", "凋"},
	{"imbmr", "㓊"},
	{"imbsd", "凈"},
	{"imc", "凎 剢"},
	{"imcw", "庮"},
	{"imd", "㡰"},
	{"imdci", "凇"},
	{"imddf", "凚"},
	{"imdk", "决"},
	{"imdl", "凁"},
	{"imdw", "凍"},
	{"ime", "冰 㳼"},
	{"imfq", "冸"},
	{"imgce", "凌"},
	{"imgcg", "㓐"},
	{"imgt", "㢅"},
	{"imgtj", "㓑"},
	{"imgwc", "凟"},
	{"imhgu", "冼"},
	{"imhhi", "㓔"},
	{"imhjr", "㓉"},
	{"imhk", "㓇"},
	{"imhui", "䰥"},
	{"imice", "𠗕"},
	{"imidq", "𠘚"},
	{"imig", "庢 㦶"},
	{"imihf", "㓕"},
	{"imihr", "减"},
	{"imikk", "冹"},
	{"imir", "冶"},
	{"imjbj", "㓓"},
	{"imjlv", "凄"},
	{"imkd", "冻"},
	{"imku", "庑"},
	{"iml", "丬 冲"},
	{"imlq", "冿"},
	{"imm", "冮"},
	{"immgi", "𤦂"},
	{"immmr", "𠗐"},
	{"immn", "㓅"},
	{"immnn", "冽"},
	{"immp", "廲"},
	{"immr", "㓈"},
	{"immvh", "冴"},
	{"immvm", "冱 𠗊"},
	{"immwd", "凓"},
	{"immwg", "凐"},
	{"imn", "庁"},
	{"imnau", "凂"},
	{"imnbk", "𠗫"},
	{"imndt", "𠗠"},
	{"imno", "次 㰲"},
	{"imnsd", "净"},
	{"imnui", "𠗟"},
	{"imnvm", "冯"},
	{"imog", "准"},
	{"imoii", "冷"},
	{"imoir", "凔"},
	{"imoiv", "飡"},
	{"imomd", "凃"},
	{"imomg", "㓌"},
	{"imomr", "冾"},
	{"imop", "㓆"},
	{"imp", "惑"},
	{"imphh", "𠖳"},
	{"impko", "凝"},
	{"imqhf", "㓗"},
	{"imqkk", "凑"},
	{"imqmb", "凊"},
	{"imrhu", "况"},
	{"imrt", "㢄"},
	{"imrvp", "冺"},
	{"imsll", "臧"},
	{"imsme", "㓎"},
	{"imsqf", "馮"},
	{"imsuf", "凞 𠘑 𠘕"},
	{"imtc", "㓋"},
	{"imtcl", "凘"},
	{"imue", "廈"},
	{"imumt", "凒"},
	{"imuog", "凗"},
	{"imvh", "庌"},
	{"imvid", "𠘙"},
	{"imwjr", "凅"},
	{"imwk", "𠗃"},
	{"imwlj", "凙"},
	{"imwtj", "㓖"},
	{"imyiu", "㓍"},
	{"imyrf", "凉"},
	{"imywd", "凜"},
	{"imywf", "凛"},
	{"inbq", "廨"},
	{"ine", "永"},
	{"infd", "㢝"},
	{"infq", "廯"},
	{"inin", "序 㢁"},
	{"inkg", "庭"},
	{"inl", "邝"},
	{"inli", "廕"},
	{"inlr", "㢌"},
	{"innh", "㐧"},
	{"ino", "之 㡱"},
	{"inoe", "廢"},
	{"inop", "廃"},
	{"inv", "讠"},
	{"io", "庂"},
	{"iobo", "资"},
	{"iobt", "盗"},
	{"iobuc", "資"},
	{"iod", "庥 栥"},
	{"iodi", "府"},
	{"iofd", "粢"},
	{"iog", "垐 㢈"},
	{"iogj", "㢑"},
	{"iogm", "鹰"},
	{"iogr", "譍"},
	{"iohaf", "鶊 䳐"},
	{"iohd", "秶"},
	{"ioif", "焤"},
	{"ioii", "㡵"},
	{"ioin", "庈"},
	{"iok", "矣"},
	{"ioll", "庎"},
	{"ioma", "廥"},
	{"iomd", "庩"},
	{"iomn", "㢏"},
	{"iomo", "㢛"},
	{"iomr", "𢈈"},
	{"iomvn", "瓷"},
	{"ion", "乲"},
	{"ionn", "㢋"},
	{"ioog", "座 䧹"},
	{"iooiv", "餈"},
	{"iop", "恣"},
	{"iopym", "鹒"},
	{"ior", "咨"},
	{"iord", "楶"},
	{"ios", "㡸"},
	{"iotf", "廡"},
	{"iov", "姿"},
	{"iovif", "䌠"},
	{"ip", "庀 弋"},
	{"ipbm", "麆"},
	{"ipbuc", "貣"},
	{"ipc", "鏖"},
	{"ipd", "㭍 䴢"},
	{"ipf", "熊 麃"},
	{"ipfd", "麋"},
	{"ipfdq", "麟"},
	{"ipg", "塵"},
	{"iphaf", "鳶 𪈠"},
	{"iphd", "麇"},
	{"iphda", "麘"},
	{"iphdv", "䴧"},
	{"ipher", "𪊲"},
	{"iphfd", "䴣"},
	{"iphhi", "麝"},
	{"iphk", "䴠"},
	{"iphn", "麂"},
	{"iphni", "䴟"},
	{"iphor", "麔"},
	{"iphqm", "䴤 𪊟"},
	{"iphxu", "麑"},
	{"ipice", "𪊴"},
	{"ipihr", "麙"},
	{"ipine", "䴪"},
	{"ipipp", "麤"},
	{"ipksr", "䴥"},
	{"iplii", "䘅"},
	{"iplmi", "螚"},
	{"ipm", "弌 式"},
	{"ipmbc", "䫲"},
	{"ipmbi", "䴫"},
	{"ipmbr", "麢"},
	{"ipmc", "廎"},
	{"ipmg", "䶭"},
	{"ipmhf", "䴨"},
	{"ipmk", "䶮"},
	{"ipmm", "弍"},
	{"ipmmc", "貳"},
	{"ipmmm", "弎"},
	{"ipmmo", "贰"},
	{"ipmmv", "麎"},
	{"ipmo", "庼"},
	{"ipmr", "砻"},
	{"ipmvn", "㼾"},
	{"ipmwd", "麜"},
	{"ipmwf", "䴩"},
	{"ipmwm", "麠"},
	{"ipnkg", "𪊶"},
	{"ipnl", "鄜"},
	{"ipnsj", "麛"},
	{"ipog", "隿"},
	{"ipoiv", "䬥"},
	{"ipop", "㓒"},
	{"ipp", "庇 忒 態 麀"},
	{"ippru", "麅"},
	{"ippym", "鸢"},
	{"iprrk", "麣"},
	{"ipru", "庖"},
	{"iprvk", "麌"},
	{"iprye", "麚"},
	{"ipsj", "聋"},
	{"ipskr", "麏"},
	{"iptc", "龚"},
	{"iptm", "甙"},
	{"iptmc", "麒"},
	{"ipu", "庉"},
	{"ipwd", "𪊽"},
	{"ipwhd", "麕"},
	{"ipyg", "麈"},
	{"ipyhv", "袭"},
	{"ipyiu", "麍"},
	{"ipyk", "𪊓"},
	{"ipykr", "麐 𪊺"},
	{"ipymr", "詟 䴦"},
	{"ipyrf", "麖"},
	{"ipytj", "麞 𪋟"},
	{"ipyx", "麡"},
	{"iq", "㦮"},
	{"iqhaf", "鴾"},
	{"iqhf", "緳"},
	{"iqje", "庪"},
	{"iqks", "劺"},
	{"ir", "台"},
	{"irc", "㡶"},
	{"ird", "枲"},
	{"irf", "炱"},
	{"irhaf", "鶶"},
	{"irhhh", "㣍"},
	{"irhqu", "㲥"},
	{"irln", "刣"},
	{"irm", "或"},
	{"irmbc", "顑"},
	{"irmg", "戜"},
	{"irmvn", "瓵 㼺"},
	{"irnbg", "觱"},
	{"irnl", "邰"},
	{"irno", "㰧 㰹"},
	{"irp", "怠 感"},
	{"iru", "乨"},
	{"irymu", "䶠"},
	{"irytj", "辝"},
	{"is", "户"},
	{"isa", "间"},
	{"isbt", "盛"},
	{"isd", "㦿"},
	{"isgi", "㧁"},
	{"isgp", "廳"},
	{"ishaf", "鳸"},
	{"ishbr", "扄"},
	{"ishn", "𠙖"},
	{"isja", "廜"},
	{"isjp", "廰"},
	{"islb", "帍"},
	{"islq", "肁"},
	{"ismbc", "䫆"},
	{"ismc", "㢞"},
	{"ismh", "廖"},
	{"ismvn", "㼩"},
	{"isn", "戹"},
	{"isnhe", "㧀"},
	{"isnin", "扅"},
	{"isnl", "郕"},
	{"isok", "敷"},
	{"isr", "启"},
	{"isrj", "廦"},
	{"isvif", "䋀"},
	{"it", "弁 戒"},
	{"ita", "庴"},
	{"itcl", "廝"},
	{"ite", "度"},
	{"itf", "庶"},
	{"itfi", "䗪"},
	{"ithaf", "鴘"},
	{"itlb", "席"},
	{"itlk", "㢍"},
	{"itlm", "廑"},
	{"itmbc", "䪻"},
	{"itmc", "廣"},
	{"itmp", "懬"},
	{"itms", "㢙"},
	{"itoo", "庻"},
	{"itp", "慿"},
	{"itq", "庠"},
	{"itso", "庹"},
	{"itt", "庰"},
	{"itu", "㡿"},
	{"itw", "庿"},
	{"itwp", "㢜"},
	{"itxc", "廉"},
	{"itxf", "㢘"},
	{"iuhhh", "尨"},
	{"iv", "戉"},
	{"ivapv", "谒"},
	{"ivawe", "谩"},
	{"ivbgr", "调"},
	{"ivbkq", "诨"},
	{"ivbm", "诅"},
	{"ivbme", "谖"},
	{"ivbou", "谣"},
	{"ivbr", "诇"},
	{"ivci", "讼"},
	{"ivcru", "说"},
	{"ivdhe", "诐"},
	{"ivdi", "讨"},
	{"ivdk", "诀"},
	{"ivdwf", "谏"},
	{"iveq", "译"},
	{"ivfb", "诮"},
	{"ivfbu", "谠"},
	{"ivff", "谈"},
	{"ivgdi", "诗"},
	{"ivgg", "诖"},
	{"ivgr", "诘"},
	{"ivhds", "诱"},
	{"ivhdv", "诿"},
	{"ivhg", "㢕"},
	{"ivhgr", "诰"},
	{"ivhgu", "诜"},
	{"ivhhi", "谢"},
	{"ivhjd", "诛"},
	{"ivhjr", "话"},
	{"ivhml", "䜣"},
	{"ivhmr", "诟"},
	{"ivhmy", "诉"},
	{"ivhn", "讥"},
	{"ivhne", "设"},
	{"ivhnk", "讽"},
	{"ivhp", "讬"},
	{"ivhvi", "诋"},
	{"ivhxo", "谀"},
	{"ivihs", "诚"},
	{"ivik", "议"},
	{"iviok", "诶"},
	{"ivior", "谘"},
	{"ivipm", "试"},
	{"ivir", "诒"},
	{"ivisb", "谝"},
	{"ivit", "诫"},
	{"ivj", "计"},
	{"ivjbk", "谳"},
	{"ivjbm", "谊"},
	{"ivjhp", "诧"},
	{"ivjka", "诸"},
	{"ivjll", "谉"},
	{"ivjnk", "读"},
	{"ivjr", "诂"},
	{"ivkf", "诙"},
	{"ivkhg", "诳"},
	{"ivks", "勆"},
	{"ivlll", "训"},
	{"ivllp", "䜨"},
	{"ivlmy", "诽"},
	{"ivlsw", "谰"},
	{"ivm", "讧"},
	{"ivmfj", "评"},
	{"ivmj", "讦"},
	{"ivmmr", "语"},
	{"ivmn", "订"},
	{"ivmnr", "诃"},
	{"ivmoo", "诬"},
	{"ivmso", "诼"},
	{"ivmua", "谮"},
	{"ivmvh", "讶"},
	{"ivmwj", "谭"},
	{"ivmym", "证"},
	{"ivncr", "谵"},
	{"ivnhb", "谲"},
	{"ivnhx", "谄"},
	{"ivnib", "诵"},
	{"ivnj", "讯"},
	{"ivnkm", "䜥"},
	{"ivnkv", "诞"},
	{"ivnl", "郞 郎"},
	{"ivnmu", "诡"},
	{"ivnob", "谞"},
	{"ivnsd", "诤"},
	{"ivnsm", "诌"},
	{"ivnuy", "谗"},
	{"ivo", "认"},
	{"ivob", "讷"},
	{"ivog", "谁"},
	{"ivogf", "谯"},
	{"ivohh", "诊"},
	{"ivoim", "谶"},
	{"ivoip", "谂"},
	{"ivoj", "许"},
	{"ivomg", "诠"},
	{"ivomn", "谕"},
	{"ivon", "讫"},
	{"ivop", "论"},
	{"ivos", "诈"},
	{"ivowy", "诲"},
	{"ivpa", "询"},
	{"ivpht", "谧"},
	{"ivppa", "谐"},
	{"ivptd", "谍"},
	{"ivqd", "诔"},
	{"ivqki", "诪"},
	{"ivqmb", "请"},
	{"ivqs", "讳"},
	{"ivrc", "识"},
	{"ivrmk", "误"},
	{"ivrrs", "谔"},
	{"ivsh", "㓪"},
	{"ivshi", "讱"},
	{"ivshr", "诏"},
	{"ivsim", "䜧"},
	{"ivsje", "诹"},
	{"ivsk", "讴"},
	{"ivsmg", "诓"},
	{"ivsmh", "谬"},
	{"ivsmm", "诩"},
	{"ivsmr", "词"},
	{"ivss", "讵"},
	{"ivsu", "记"},
	{"ivtak", "谟"},
	{"ivtbh", "谫"},
	{"ivtc", "䜤"},
	{"ivtca", "谱"},
	{"ivtct", "谥"},
	{"ivtkr", "诺"},
	{"ivtlf", "䜩"},
	{"ivtlm", "谨"},
	{"ivtmd", "谋"},
	{"ivtmv", "谌"},
	{"ivtpa", "䜦"},
	{"ivtq", "详"},
	{"ivtt", "讲"},
	{"ivtxc", "谦"},
	{"ivtyu", "谎"},
	{"ivu", "讪"},
	{"ivug", "廱"},
	{"ivuk", "讻"},
	{"ivuu", "诎"},
	{"ivwb", "谓"},
	{"ivwce", "谡"},
	{"ivwd", "课"},
	{"ivy", "讣"},
	{"ivybb", "谛"},
	{"ivybs", "谤"},
	{"ivycb", "谪"},
	{"ivyfd", "谜"},
	{"ivyhh", "谚"},
	{"ivyhs", "访"},
	{"ivylr", "谴"},
	{"ivym", "让"},
	{"ivyoj", "谇"},
	{"ivypm", "谑"},
	{"ivyrd", "谆"},
	{"ivyrf", "谅"},
	{"ivyta", "谙"},
	{"ivyvo", "该"},
	{"iwcg", "廛"},
	{"iwg", "㢆"},
	{"iwl", "庘"},
	{"iwlb", "庽"},
	{"iwtc", "廙"},
	{"ixe", "慶"},
	{"ixf", "廌"},
	{"ixp", "鹿"},
	{"iybp", "龐"},
	{"iydl", "廓"},
	{"iyhv", "庡"},
	{"iyln", "劘"},
	{"iymp", "庛"},
	{"iymr", "㢇"},
	{"iypm", "㢒"},
	{"iyps", "㢚"},
	{"iypt", "廬"},
	{"iyr", "店"},
	{"iyrl", "廍"},
	{"iyt", "㡴"},
	{"iytj", "㢓"},
	{"iywd", "廩"},
	{"iywf", "廪"},
	{"iyx", "𪗆"},
	{"j", "十"},
	{"jaac", "䥌"},
	{"jabuu", "覩"},
	{"jaf", "煑 煮"},
	{"jahc", "賔"},
	{"jahml", "斱"},
	{"jahne", "殾"},
	{"jahui", "䰩"},
	{"jajwj", "䡤"},
	{"jalii", "䘄"},
	{"jamo", "寔"},
	{"jan", "乽"},
	{"janl", "都"},
	{"janoo", "䬡"},
	{"jarp", "㗯"},
	{"jas", "䎞"},
	{"jasmm", "翥"},
	{"jav", "宴"},
	{"jayc", "㝠"},
	{"jb", "巿"},
	{"jbbo", "赍"},
	{"jbbuc", "賫 賷 䝴"},
	{"jbd", "寀"},
	{"jbhaf", "鶦 䴁"},
	{"jbhod", "櫜"},
	{"jbik", "献"},
	{"jblli", "蟗"},
	{"jblyd", "㰆"},
	{"jbm", "宜"},
	{"jbmc", "真"},
	{"jbmm", "直"},
	{"jbmod", "㯻"},
	{"jbmrd", "橐"},
	{"jbmri", "蠹"},
	{"jbnd", "孛"},
	{"jbof", "察"},
	{"jboiv", "䭌"},
	{"jboud", "㯱"},
	{"jbrrv", "囊"},
	{"jbtj", "南"},
	{"jbvif", "索"},
	{"jbwno", "疐"},
	{"jc", "穴"},
	{"jcahk", "䆨"},
	{"jcap", "䆞"},
	{"jcapp", "窤"},
	{"jcbbr", "窩"},
	{"jcbmr", "䆚"},
	{"jcbou", "窰"},
	{"jcbu", "窅"},
	{"jcbuk", "䆩"},
	{"jcbuu", "䚔"},
	{"jccwa", "䆵"},
	{"jccwn", "𥦬"},
	{"jcd", "穼"},
	{"jcdk", "䆕"},
	{"jceee", "窡"},
	{"jceev", "䆯"},
	{"jceff", "䆱"},
	{"jcegg", "漥 窪"},
	{"jcemd", "窏"},
	{"jcese", "䆮"},
	{"jcfdj", "窲"},
	{"jcfdv", "窭"},
	{"jcff", "䆦"},
	{"jcgfo", "窾"},
	{"jcgg", "窐"},
	{"jcgru", "竈"},
	{"jcgwc", "竇"},
	{"jcgwu", "竃"},
	{"jchaf", "窵 鷏 䴅 䴐"},
	{"jchbt", "䆝"},
	{"jchdb", "竊"},
	{"jchdp", "窸"},
	{"jchdv", "䆧"},
	{"jchdw", "䆺"},
	{"jche", "㪦"},
	{"jchgr", "窖"},
	{"jchhl", "窌"},
	{"jchhn", "窮"},
	{"jchhr", "竆"},
	{"jchio", "窆"},
	{"jchk", "穾"},
	{"jchoo", "窳"},
	{"jchq", "窂"},
	{"jchs", "窄"},
	{"jchsk", "竅"},
	{"jchuu", "竁"},
	{"jchvo", "窊"},
	{"jchwk", "窗"},
	{"jchwp", "窻"},
	{"jchxh", "䆤"},
	{"jchxv", "竄"},
	{"jci", "戭 㝐"},
	{"jciav", "䆡"},
	{"jcid", "梥"},
	{"jcihs", "窚"},
	{"jcihu", "䆓"},
	{"jcik", "突"},
	{"jcile", "䆲"},
	{"jcip", "窓"},
	{"jcirm", "窢"},
	{"jcjbc", "窴 㒹"},
	{"jcjjj", "䆭"},
	{"jcjkd", "窙"},
	{"jcjnk", "窦"},
	{"jcjr", "𥥖"},
	{"jckb", "䆜"},
	{"jckcf", "竂"},
	{"jcki", "䆖"},
	{"jckn", "究"},
	{"jckni", "䆒"},
	{"jcks", "穷"},
	{"jcl", "䆔"},
	{"jclb", "帘"},
	{"jcll", "窜"},
	{"jclmo", "窕"},
	{"jclwv", "窶"},
	{"jcm", "空"},
	{"jcmbc", "顛"},
	{"jcmbm", "𥩔"},
	{"jcmbo", "颠"},
	{"jcmd", "穻"},
	{"jcmig", "窒"},
	{"jcmms", "窍"},
	{"jcmmu", "竀"},
	{"jcmmv", "䆣"},
	{"jcmn", "䆑"},
	{"jcmob", "窉"},
	{"jcmso", "䆥"},
	{"jcmuv", "窛"},
	{"jcmvh", "穿"},
	{"jcmym", "䆙"},
	{"jcn", "穵 穹"},
	{"jcnfq", "䇁"},
	{"jcnhb", "䆷"},
	{"jcnhx", "窞"},
	{"jcni", "穸"},
	{"jcnjk", "䆻"},
	{"jcnlm", "窿"},
	{"jcno", "歕"},
	{"jcnot", "䆸"},
	{"jcnwu", "䆴"},
	{"jcog", "䨈"},
	{"jcogf", "䆶"},
	{"jcoju", "窑"},
	{"jcold", "窱"},
	{"jcomn", "窬"},
	{"jcomr", "䆟"},
	{"jcor", "容"},
	{"jcord", "㮤"},
	{"jcp", "㥲"},
	{"jcpko", "窽"},
	{"jcpkp", "䆫"},
	{"jcpru", "窇"},
	{"jcpsh", "窃"},
	{"jcpu", "窀"},
	{"jcpym", "窎"},
	{"jcqdk", "䆢"},
	{"jcqhk", "窫"},
	{"jcqou", "窺"},
	{"jcrbc", "䆬"},
	{"jcrhp", "䆛"},
	{"jcrob", "窝"},
	{"jcrvl", "䆗"},
	{"jcsit", "䆾"},
	{"jcsjl", "窷"},
	{"jcskr", "窘"},
	{"jcsll", "䆠"},
	{"jcsmm", "翸 䎙"},
	{"jcsrr", "䆰"},
	{"jcsuu", "窟"},
	{"jctgf", "窯"},
	{"jctjj", "䇀"},
	{"jctt", "穽"},
	{"jcttv", "嚢"},
	{"jcuu", "窋"},
	{"jcvis", "窈 𥥆"},
	{"jcvmd", "䆿 𥧌"},
	{"jcvmr", "窹"},
	{"jcvvd", "窼"},
	{"jcwd", "窠"},
	{"jcwl", "䆘"},
	{"jcyaj", "窧"},
	{"jcybb", "䆼"},
	{"jcybp", "竉"},
	{"jcyck", "窔"},
	{"jcymo", "䆳"},
	{"jcyoj", "窣"},
	{"jcypo", "䆽"},
	{"jcyta", "窨"},
	{"jcytg", "䆹"},
	{"jd", "宋 未"},
	{"jdbuu", "䙿"},
	{"jdci", "𡨭"},
	{"jdd", "㝝"},
	{"jdhaf", "鵓"},
	{"jdi", "守"},
	{"jdisy", "𣚺"},
	{"jdks", "勃"},
	{"jdmbc", "䫅 䫙 𩓐"},
	{"jdnl", "郣"},
	{"jdok", "教 㪍"},
	{"jdpym", "鹁"},
	{"jdrp", "㖝"},
	{"je", "支 㝊 㲾"},
	{"jebmo", "䴿"},
	{"jebnd", "䴸"},
	{"jebuu", "麲"},
	{"jecu", "宻"},
	{"jed", "檕"},
	{"jedh", "䴭"},
	{"jedj", "䴲"},
	{"jedoo", "麳"},
	{"jefbc", "䵀"},
	{"jeg", "墼"},
	{"jehaf", "鳷"},
	{"jehej", "䴶"},
	{"jehqu", "㲍"},
	{"jehwj", "䴽"},
	{"jei", "䴰"},
	{"jeii", "䴼"},
	{"jeip", "䴬"},
	{"jejc", "䴳"},
	{"jejmu", "䴷"},
	{"jejp", "䴱"},
	{"jejwj", "轚"},
	{"jeks", "攰"},
	{"jelmi", "蟿"},
	{"jembc", "頍"},
	{"jemr", "礊"},
	{"jeog", "䧴"},
	{"jeoju", "罊"},
	{"jephh", "䴯"},
	{"jeq", "擊"},
	{"jese", "寖"},
	{"jesmi", "攳"},
	{"jesmm", "翅"},
	{"jetbo", "䵆"},
	{"jetmc", "䵃"},
	{"jetqm", "䴾"},
	{"jett", "䴵"},
	{"jetwt", "䵄"},
	{"jeu", "䴮"},
	{"jevif", "繫"},
	{"jevmi", "䵁"},
	{"jewd", "䴹"},
	{"jeycb", "䵂"},
	{"jeytr", "䴺"},
	{"jf", "灾"},
	{"jfb", "宵"},
	{"jfd", "宩"},
	{"jfe", "叜"},
	{"jfhaf", "鶎"},
	{"jfln", "亊"},
	{"jgc", "䥅"},
	{"jgji", "㝪"},
	{"jglmi", "䘁"},
	{"jgrv", "㝨"},
	{"jhdw", "審"},
	{"jher", "客"},
	{"jhfd", "宷"},
	{"jhgu", "宪"},
	{"jhiom", "䪣"},
	{"jhk", "宎"},
	{"jhkb", "㝯"},
	{"jhlb", "㝢"},
	{"jhn", "宂"},
	{"jhoo", "寙"},
	{"jhp", "宅"},
	{"jhq", "牢"},
	{"jhqu", "宒"},
	{"jhus", "㝰"},
	{"jhxf", "寫"},
	{"jiav", "㝗"},
	{"jibi", "博"},
	{"jid", "栽"},
	{"jidi", "專"},
	{"jif", "烖"},
	{"jig", "㘽 㦳"},
	{"jihaf", "鷒 䳒"},
	{"jihs", "宬 㦲"},
	{"jijwj", "載"},
	{"jik", "宊"},
	{"jikf", "寪"},
	{"jikp", "宠"},
	{"jikq", "载"},
	{"jile", "㝩"},
	{"jilmi", "蛓"},
	{"jiln", "剸"},
	{"jilsm", "韯"},
	{"jimcw", "酨"},
	{"jimig", "臷"},
	{"jimvn", "甎"},
	{"jinl", "鄟"},
	{"jino", "㝎"},
	{"jiobo", "胾"},
	{"jiog", "截"},
	{"jip", "惠"},
	{"jips", "㢤"},
	{"jir", "哉"},
	{"jismm", "翝"},
	{"jiwgf", "䵧"},
	{"jiwtc", "戴"},
	{"jiyhv", "裁"},
	{"jj", "卄 廾"},
	{"jjabt", "輼"},
	{"jjamh", "輰"},
	{"jjapp", "輥"},
	{"jjapv", "輵"},
	{"jjawe", "䡬"},
	{"jjb", "朝"},
	{"jjbb", "輣"},
	{"jjbc", "寘"},
	{"jjbgr", "輖"},
	{"jjbhx", "轁"},
	{"jjbjj", "䡣"},
	{"jjbtv", "輞"},
	{"jjci", "䡆"},
	{"jjcor", "輍"},
	{"jjdmq", "韓"},
	{"jjeed", "䡦"},
	{"jjeee", "輟"},
	{"jjeg", "軽"},
	{"jjfb", "輎"},
	{"jjfdq", "轔"},
	{"jjfmu", "輄"},
	{"jjgce", "輘"},
	{"jjgcg", "䡜"},
	{"jjgow", "轖"},
	{"jjgrv", "轅"},
	{"jjhau", "䡚"},
	{"jjhby", "輈"},
	{"jjhdw", "轓"},
	{"jjhe", "䡊"},
	{"jjher", "輅"},
	{"jjhfd", "軤"},
	{"jjhg", "軠"},
	{"jjhju", "輴"},
	{"jjhkb", "轎"},
	{"jjhml", "斬"},
	{"jjhn", "䡄"},
	{"jjhne", "軗"},
	{"jjhni", "軓"},
	{"jjhoo", "䡮"},
	{"jjhpm", "軧"},
	{"jjhqo", "軼"},
	{"jjhqu", "軞"},
	{"jjhrf", "䡧"},
	{"jjhs", "䡎"},
	{"jjhsn", "軶"},
	{"jjhuc", "䡽"},
	{"jjhus", "䡻"},
	{"jjhvo", "軱"},
	{"jjhvp", "軝"},
	{"jjhwj", "䡟"},
	{"jjhwp", "䡯"},
	{"jjhxu", "輗"},
	{"jji", "戟"},
	{"jjiav", "䡙"},
	{"jjibi", "𨍭"},
	{"jjice", "𨌘"},
	{"jjihr", "輱"},
	{"jjihu", "𨋍"},
	{"jjii", "輚"},
	{"jjijb", "輔"},
	{"jjikk", "軷"},
	{"jjikw", "輽"},
	{"jjimo", "軣"},
	{"jjip", "寭"},
	{"jjipm", "軾"},
	{"jjir", "軩"},
	{"jjirp", "轗"},
	{"jjisb", "䡢"},
	{"jjism", "䡪"},
	{"jjixp", "轆"},
	{"jjjbc", "䡩"},
	{"jjjbo", "䡹"},
	{"jjjcr", "䡥"},
	{"jjje", "䡋"},
	{"jjjii", "轉"},
	{"jjjjj", "轟"},
	{"jjjki", "𨌆"},
	{"jjjmu", "輐"},
	{"jjjnu", "䡝"},
	{"jjjp", "䡐"},
	{"jjjqr", "轄"},
	{"jjjr", "軲"},
	{"jjjrr", "輨"},
	{"jjjtc", "轒"},
	{"jjjwj", "䡛"},
	{"jjk", "軑"},
	{"jjkcf", "轑"},
	{"jjkd", "宯"},
	{"jjki", "軚 䡌"},
	{"jjkk", "䡈"},
	{"jjkmr", "輢"},
	{"jjkn", "軌"},
	{"jjks", "䡃"},
	{"jjlbk", "軮"},
	{"jjlll", "䡅"},
	{"jjlmy", "輫"},
	{"jjlo", "寁"},
	{"jjlw", "軸"},
	{"jjmbb", "轜"},
	{"jjmbk", "輭"},
	{"jjmbl", "輀"},
	{"jjmbo", "䡿"},
	{"jjmbr", "䡼"},
	{"jjmbs", "轌"},
	{"jjmbv", "𨍥"},
	{"jjmcg", "䡖"},
	{"jjmcw", "輏"},
	{"jjmdm", "轣"},
	{"jjmfj", "軯"},
	{"jjmg", "軖"},
	{"jjmig", "輊"},
	{"jjmj", "軒"},
	{"jjmlb", "輛"},
	{"jjmmi", "転"},
	{"jjmmu", "䡇"},
	{"jjmnr", "軻"},
	{"jjmrw", "輻"},
	{"jjmsu", "軛"},
	{"jjmu", "軏"},
	{"jjmub", "輌"},
	{"jjmvm", "輕"},
	{"jjnau", "輓"},
	{"jjnem", "䡕"},
	{"jjnhd", "輮"},
	{"jjnhx", "輡"},
	{"jjni", "䡏"},
	{"jjnin", "䡔"},
	{"jjnj", "軐"},
	{"jjno", "軟"},
	{"jjo", "倝"},
	{"jjoae", "輹"},
	{"jjob", "軜"},
	{"jjod", "榦"},
	{"jjodi", "軵"},
	{"jjohf", "鶾"},
	{"jjohh", "軫"},
	{"jjohu", "㲦"},
	{"jjoii", "軨"},
	{"jjoin", "軡"},
	{"jjoli", "螒"},
	{"jjomb", "輪"},
	{"jjomd", "𠏉"},
	{"jjomg", "輇"},
	{"jjomj", "幹 龫"},
	{"jjomn", "輸"},
	{"jjon", "乾 亁"},
	{"jjoog", "雗"},
	{"jjosf", "䮧"},
	{"jjosm", "翰 𨌺"},
	{"jjoyj", "斡"},
	{"jjppa", "䡡"},
	{"jjpr", "軥"},
	{"jjpru", "軳"},
	{"jjpu", "軘"},
	{"jjpw", "䡘"},
	{"jjpyr", "輷"},
	{"jjqjm", "轊"},
	{"jjqjp", "䡺"},
	{"jjqkd", "轃"},
	{"jjqkk", "輳"},
	{"jjqmb", "輤"},
	{"jjqo", "䡍"},
	{"jjqs", "韩"},
	{"jjr", "軎 㝒"},
	{"jjrc", "軹"},
	{"jjrhu", "軦"},
	{"jjrrj", "䡲"},
	{"jjrsj", "輯"},
	{"jjrvp", "䡑"},
	{"jjshi", "軔"},
	{"jjshr", "軺"},
	{"jjsit", "轞"},
	{"jjsje", "輙"},
	{"jjsju", "輒"},
	{"jjskr", "輑"},
	{"jjsmg", "軭"},
	{"jjsmh", "轇"},
	{"jjsmm", "䎐"},
	{"jjsnd", "轏"},
	{"jjsrj", "䡶"},
	{"jjsrr", "䡱"},
	{"jjstv", "輾"},
	{"jjtag", "轥"},
	{"jjtav", "轕"},
	{"jjtc", "輁"},
	{"jjtcl", "䡳"},
	{"jjtco", "轐"},
	{"jjtcw", "輶"},
	{"jjtgi", "轙 轛"},
	{"jjtgt", "䡷"},
	{"jjtqg", "䡭"},
	{"jjtt", "軿"},
	{"jjtwv", "䡸"},
	{"jju", "軋"},
	{"jjumb", "輲"},
	{"jjvid", "轢"},
	{"jjvis", "軪"},
	{"jjvl", "䡂"},
	{"jjvmw", "輺"},
	{"jjvvd", "轈"},
	{"jjvvw", "輜"},
	{"jjw", "䡒"},
	{"jjwd", "輠"},
	{"jjwlv", "轘"},
	{"jjwot", "轀"},
	{"jjwww", "轠"},
	{"jjybc", "䡠"},
	{"jjybk", "轍 䡾"},
	{"jjyck", "較"},
	{"jjycv", "𨍽 𨎊"},
	{"jjye", "軙"},
	{"jjyg", "軴"},
	{"jjyhj", "䡫"},
	{"jjyhn", "䡉"},
	{"jjyib", "𨌯"},
	{"jjyjj", "轋"},
	{"jjypt", "轤"},
	{"jjyrf", "輬"},
	{"jjyt", "𨋢"},
	{"jjytg", "䡴"},
	{"jjyto", "䡵"},
	{"jjyvo", "輆"},
	{"jk", "丈 耂"},
	{"jka", "者"},
	{"jkb", "宥"},
	{"jkbhu", "觌"},
	{"jkcf", "寮"},
	{"jkhaf", "鶟"},
	{"jkhq", "㹈"},
	{"jkhqu", "㲠"},
	{"jki", "宏"},
	{"jklb", "㠻"},
	{"jkmdo", "斄"},
	{"jkme", "漦"},
	{"jkmhq", "犛"},
	{"jkmhu", "氂"},
	{"jkmig", "耊"},
	{"jkmnd", "孷"},
	{"jkmr", "寄"},
	{"jkmsh", "剺"},
	{"jkmv", "嫠"},
	{"jkmwg", "釐"},
	{"jkn", "宄"},
	{"jknd", "孝"},
	{"jkp", "老"},
	{"jkpr", "耇"},
	{"jks", "㔹"},
	{"jksc", "协"},
	{"jkss", "協"},
	{"jkyr", "耉"},
	{"jkys", "考"},
	{"jla", "暫"},
	{"jlbuu", "覱"},
	{"jlc", "鏨"},
	{"jld", "槧"},
	{"jle", "叓"},
	{"jlg", "塹"},
	{"jlgyo", "䟅"},
	{"jlhaf", "䳻"},
	{"jlk", "吏"},
	{"jlln", "事"},
	{"jlme", "寝"},
	{"jlmo", "宨"},
	{"jlmr", "磛"},
	{"jloiv", "䭕"},
	{"jlp", "慙"},
	{"jlq", "㨻"},
	{"jlryo", "蹔"},
	{"jlu", "㟻"},
	{"jlv", "妻 㜞"},
	{"jlw", "宙"},
	{"jlwl", "审"},
	{"jlwv", "寠"},
	{"jlyo", "疌"},
	{"jm", "士 㝉"},
	{"jmam", "宣"},
	{"jmbn", "寕 𡨴"},
	{"jmbu", "㝟"},
	{"jmc", "鑋"},
	{"jmch", "寡"},
	{"jmcw", "𡧳"},
	{"jmd", "宇"},
	{"jmfc", "寳"},
	{"jmgc", "㝙"},
	{"jmgi", "宝"},
	{"jmgu", "寚"},
	{"jmhaf", "鵼 䳦"},
	{"jmhc", "賓"},
	{"jmhne", "㲁"},
	{"jmig", "室"},
	{"jmjmm", "矗"},
	{"jmlc", "寅"},
	{"jmlm", "㝞"},
	{"jmmbc", "𩓧"},
	{"jmmc", "賨"},
	{"jmmf", "宗"},
	{"jmmu", "完"},
	{"jmmv", "宸"},
	{"jmn", "宁"},
	{"jmnt", "㿾"},
	{"jmp", "惪"},
	{"jmr", "宕"},
	{"jmrp", "嗭"},
	{"jmrw", "富"},
	{"jmsmm", "翧"},
	{"jmso", "家"},
	{"jmtb", "𡩅"},
	{"jmuc", "寶"},
	{"jmue", "寇"},
	{"jmuv", "宼"},
	{"jmyo", "定"},
	{"jn", "宆"},
	{"jnbk", "寏"},
	{"jnd", "字"},
	{"jndhe", "麬"},
	{"jnfh", "麨"},
	{"jngi", "麮"},
	{"jnhaf", "鸋 𪄳"},
	{"jnhqu", "㲰"},
	{"jni", "宖"},
	{"jnihq", "麰"},
	{"jnijb", "麱"},
	{"jnim", "宐"},
	{"jnin", "㝖"},
	{"jniu", "宛"},
	{"jnkm", "㝚"},
	{"jnlm", "㝫"},
	{"jnln", "剚"},
	{"jnmls", "麪"},
	{"jnmwl", "麵"},
	{"jnmys", "麫"},
	{"jnn", "㝋"},
	{"jno", "㝌"},
	{"jnon", "麧"},
	{"jnpfd", "麴"},
	{"jnpru", "麭"},
	{"jnqd", "𡩣"},
	{"jnqo", "麩"},
	{"jntcw", "𪍑"},
	{"jntw", "麯"},
	{"jnuf", "䵫"},
	{"jnui", "寃 䗕"},
	{"jnujt", "麷"},
	{"jnup", "惌"},
	{"jny", "𪋿"},
	{"jnyk", "卖"},
	{"jnyr", "䴴"},
	{"jnyub", "麶"},
	{"jodi", "𡧛"},
	{"jog", "寉"},
	{"jogs", "寯 㝦"},
	{"joll", "㝏"},
	{"joma", "宿"},
	{"jombc", "顁"},
	{"jomc", "宾"},
	{"jomr", "㝓"},
	{"jomw", "㝛"},
	{"joni", "麥"},
	{"joos", "宱"},
	{"jose", "寑"},
	{"jp", "它"},
	{"jpa", "耆"},
	{"jpam", "㝭"},
	{"jpbn", "寧"},
	{"jpbq", "甯"},
	{"jpbt", "寍"},
	{"jpbuu", "䙾"},
	{"jpe", "㝕"},
	{"jpgb", "𡩋"},
	{"jph", "宓"},
	{"jphaf", "䳓"},
	{"jphb", "寗"},
	{"jphi", "蜜"},
	{"jphqu", "耄"},
	{"jpht", "䀄"},
	{"jphu", "密 䁇"},
	{"jpj", "㔺"},
	{"jpjkp", "䎜"},
	{"jpko", "寲"},
	{"jpmig", "耋"},
	{"jpmu", "尧"},
	{"jpmvn", "㼠"},
	{"jpn", "㐗"},
	{"jppr", "耈"},
	{"jpr", "㖈 䎛"},
	{"jpsmm", "䎝"},
	{"jq", "车"},
	{"jqhk", "㝣"},
	{"jqk", "実"},
	{"jqmb", "寈"},
	{"jqmp", "憲"},
	{"jqmr", "害"},
	{"jqnhd", "䂋"},
	{"jqomn", "输"},
	{"jqop", "轮"},
	{"jqu", "轧"},
	{"jr", "古"},
	{"jrb", "胡"},
	{"jrbhf", "鶘"},
	{"jrbpm", "鹕"},
	{"jrcor", "豁"},
	{"jrd", "宲"},
	{"jre", "㕝"},
	{"jrhaf", "鴣 鶷 𪃭 𪃾"},
	{"jrhhh", "彮"},
	{"jrhne", "毄 㲅"},
	{"jrhr", "宮"},
	{"jrhu", "克"},
	{"jrhvo", "㼋"},
	{"jrln", "割"},
	{"jrlr", "官"},
	{"jrmbc", "額"},
	{"jrmbo", "额"},
	{"jrmu", "宺"},
	{"jrmvn", "瓳 㼸"},
	{"jrog", "䧸"},
	{"jrok", "故"},
	{"jrp", "怘 愙"},
	{"jrpym", "鸪"},
	{"jrqo", "㝬"},
	{"jrr", "宫"},
	{"jrrp", "悹 㖛"},
	{"jrrye", "嘏"},
	{"jrsmm", "䎁"},
	{"jrye", "㪡"},
	{"jrytj", "辜 𨐒"},
	{"jshaf", "䳣"},
	{"jsje", "㝡"},
	{"jskr", "宭"},
	{"jsll", "宦 宧"},
	{"jsmh", "寥"},
	{"jsmvn", "㼥"},
	{"jsobo", "膥"},
	{"jsp", "愂"},
	{"jt", "卉"},
	{"jta", "㝜 㫩"},
	{"jtak", "寞"},
	{"jtbc", "賁"},
	{"jtbi", "寬"},
	{"jtbo", "贲"},
	{"jtbu", "寛"},
	{"jtcc", "賽"},
	{"jtcd", "寨"},
	{"jtcf", "騫 鶱"},
	{"jtcg", "塞"},
	{"jtci", "䗙"},
	{"jtcm", "骞"},
	{"jtcn", "弿"},
	{"jtco", "赛 蹇 䞿"},
	{"jtcp", "㥶"},
	{"jtcq", "搴"},
	{"jtcr", "謇"},
	{"jtcu", "寋"},
	{"jtcv", "褰"},
	{"jtcy", "寒"},
	{"jtd", "桒"},
	{"jtge", "鼖"},
	{"jthu", "尭"},
	{"jtoa", "𣇸"},
	{"jtt", "宑"},
	{"jttb", "㝤"},
	{"jtv", "𡜦"},
	{"ju", "七"},
	{"jubt", "䀇"},
	{"jucsh", "兝"},
	{"judi", "尅"},
	{"jufe", "㝮"},
	{"juhaf", "鵷"},
	{"juhj", "兛"},
	{"juhqu", "兞"},
	{"juj", "兙"},
	{"jujru", "兢"},
	{"jujt", "寷"},
	{"juks", "勀"},
	{"juln", "剋 剜"},
	{"juma", "兡"},
	{"jumvi", "䢇"},
	{"jumwg", "兣"},
	{"jupym", "鹓"},
	{"jusmm", "翘"},
	{"jv", "安 㐄"},
	{"jvbt", "䀂"},
	{"jvd", "案"},
	{"jvhaf", "鴳 鶈"},
	{"jvhd", "䅁"},
	{"jvmb", "寎 㝲"},
	{"jvmbc", "頞"},
	{"jvmd", "寐 寱 㝥"},
	{"jvme", "寢"},
	{"jvmn", "㝱"},
	{"jvmr", "寣 寤"},
	{"jvmvn", "㼮"},
	{"jvnl", "郪 䢿"},
	{"jvoog", "㝧"},
	{"jvp", "悳"},
	{"jvtj", "鞌"},
	{"jwa", "曺"},
	{"jwbuu", "覾"},
	{"jwdi", "専"},
	{"jwi", "叀"},
	{"jwj", "車"},
	{"jwjc", "實"},
	{"jwks", "㔤"},
	{"jwlb", "寓"},
	{"jwlp", "㥁"},
	{"jwlv", "寰"},
	{"jwno", "畞"},
	{"jwp", "恵"},
	{"jybc", "寊"},
	{"jybp", "寵"},
	{"jyc", "宍"},
	{"jyck", "㝔"},
	{"jydu", "寴"},
	{"jyfe", "寂"},
	{"jyg", "宔"},
	{"jyhs", "㝑"},
	{"jyk", "实"},
	{"jymr", "㝘"},
	{"jysm", "㝍"},
	{"jytj", "宰"},
	{"k", "乂 大 㐅"},
	{"kab", "奛"},
	{"kad", "橥"},
	{"kam", "疸"},
	{"kamh", "瘍"},
	{"kana", "癎"},
	{"kanb", "癇"},
	{"kanx", "㿕"},
	{"kaph", "痬"},
	{"karrj", "奲"},
	{"kau", "疤"},
	{"kav", "痕"},
	{"kb", "冇 有"},
	{"kbb", "痭"},
	{"kbbb", "㾶"},
	{"kbbr", "瘑"},
	{"kbbt", "䀁"},
	{"kbcv", "癭"},
	{"kbgr", "奝"},
	{"kbhaf", "鵗 䳑"},
	{"kbhne", "殽"},
	{"kbhq", "牵"},
	{"kbhqu", "毻"},
	{"kbi", "𠕇"},
	{"kbihm", "𢒰"},
	{"kbik", "㹷"},
	{"kbirm", "戫"},
	{"kbirv", "㦽"},
	{"kbjj", "瘒"},
	{"kbm", "疽 㚗"},
	{"kbmr", "痌"},
	{"kbmvn", "瓻"},
	{"kbnl", "郁 郗 郩"},
	{"kbno", "欷"},
	{"kboae", "㬼"},
	{"kbof", "瘵"},
	{"kbov", "瘿"},
	{"kbp", "㤫"},
	{"kbq", "痈"},
	{"kbu", "㾇"},
	{"kbub", "㿜"},
	{"kbug", "癯"},
	{"kbybp", "龓"},
	{"kc", "㾣"},
	{"kca", "昚"},
	{"kcaf", "尞"},
	{"kcano", "閷"},
	{"kcbu", "眘"},
	{"kcbuu", "䙽"},
	{"kcf", "㶫"},
	{"kchne", "殺"},
	{"kcipm", "弒"},
	{"kcln", "剎"},
	{"kcpi", "瘹"},
	{"kcru", "痥"},
	{"kcwa", "𤺧"},
	{"kcwj", "瘅"},
	{"kd", "东 㚓"},
	{"kdb", "㾊"},
	{"kdbm", "㾴"},
	{"kdbn", "𤷫"},
	{"kdd", "痳 㚞"},
	{"kdhe", "疲"},
	{"kdi", "夺"},
	{"kdipm", "弑"},
	{"kdj", "㭐"},
	{"kdk", "疦"},
	{"kdlc", "癩"},
	{"kdlk", "瘷"},
	{"kdln", "瘌"},
	{"kdlo", "瘶"},
	{"kdnl", "𨚲"},
	{"kdog", "雑"},
	{"kdok", "敎"},
	{"kdoo", "㾢"},
	{"kdpym", "鸫"},
	{"ke", "友 㽷"},
	{"kefh", "痧"},
	{"keii", "瘙"},
	{"kell", "奫"},
	{"keog", "瘫"},
	{"kf", "灰 疢"},
	{"kfb", "痟"},
	{"kfbt", "盔"},
	{"kfcb", "瘠"},
	{"kfdv", "瘘"},
	{"kff", "痰"},
	{"kffr", "㿘"},
	{"kffs", "癆"},
	{"kfhaf", "鷯"},
	{"kfhu", "㾪"},
	{"kfog", "䨅"},
	{"kfp", "悐 𢠃"},
	{"kfpym", "鹩"},
	{"kg", "圶 㽵"},
	{"kgb", "㾆"},
	{"kgdi", "痔"},
	{"kgg", "奎 㾏"},
	{"kggp", "㥣"},
	{"kghaf", "鵟"},
	{"kgi", "㾀"},
	{"kgil", "㾡"},
	{"kgni", "㿒"},
	{"kgon", "㿐"},
	{"kgp", "痣 㤮"},
	{"kh", "犭"},
	{"khaa", "猖"},
	{"khaf", "䲪"},
	{"khag", "㾮"},
	{"khahm", "猩"},
	{"khahu", "猸"},
	{"khaj", "㿁"},
	{"khal", "癤"},
	{"kham", "狚"},
	{"khamj", "猂"},
	{"khapp", "猑"},
	{"khapv", "猲"},
	{"khav", "狠"},
	{"khawe", "獌"},
	{"khbac", "猽"},
	{"khbbb", "猾"},
	{"khbbm", "㹪"},
	{"khbbr", "猧"},
	{"khbm", "狙"},
	{"khbme", "猨"},
	{"khbmr", "狪"},
	{"khbn", "痸"},
	{"khbo", "狈"},
	{"khbou", "牏"},
	{"khbsd", "猙"},
	{"khbtt", "狦"},
	{"khbuc", "狽"},
	{"khbue", "玃"},
	{"khcim", "㺋"},
	{"khd", "狇"},
	{"khdam", "猹"},
	{"khdc", "癪"},
	{"khdd", "痵"},
	{"khdf", "㾭"},
	{"khdh", "犲"},
	{"khdhe", "狓"},
	{"khdk", "㹟"},
	{"khdlc", "獺"},
	{"khdlo", "獭"},
	{"khdn", "痢"},
	{"khdoo", "猍"},
	{"khdu", "痜"},
	{"khdv", "痿 㿆"},
	{"khe", "㽹"},
	{"khea", "㹺"},
	{"khefh", "猀"},
	{"kheg", "㹩"},
	{"khey", "疼"},
	{"khf", "狄"},
	{"khfbk", "獙"},
	{"khfdq", "獜"},
	{"khfhn", "猟"},
	{"khfmu", "㹰"},
	{"khggu", "獟"},
	{"khgi", "㹤"},
	{"khgr", "狤"},
	{"khgrv", "猿"},
	{"khgu", "㾌"},
	{"khha", "狛"},
	{"khhaj", "獔"},
	{"khhau", "㹸"},
	{"khhbn", "猘"},
	{"khhdn", "猁"},
	{"khhdv", "㹻"},
	{"khhdw", "㺕"},
	{"khher", "狢"},
	{"khhey", "㹣"},
	{"khhg", "狅"},
	{"khhgf", "獯"},
	{"khhhj", "猈"},
	{"khhj", "痺"},
	{"khhjr", "狧"},
	{"khhkb", "獢"},
	{"khhl", "奅"},
	{"khhml", "㹞"},
	{"khhni", "猦"},
	{"khhqm", "狌"},
	{"khhrb", "獅"},
	{"khhrk", "𤠒"},
	{"khhsb", "猏 猵"},
	{"khhsk", "獥"},
	{"khhuj", "獋"},
	{"khhvo", "狐"},
	{"khhvp", "㹝"},
	{"khhw", "瘤"},
	{"khhxc", "㺞"},
	{"khhxe", "犍"},
	{"khhxf", "獡"},
	{"khhxu", "猊"},
	{"khhyr", "㹾"},
	{"khi", "犷 瘣"},
	{"khiav", "狼"},
	{"khibi", "煄"},
	{"khice", "狻"},
	{"khihr", "㺂"},
	{"khihu", "狁"},
	{"khii", "㹽"},
	{"khiih", "㺑"},
	{"khij", "狨"},
	{"khik", "犾 𤜥"},
	{"khikf", "㺔"},
	{"khiko", "㺆"},
	{"khiku", "犹"},
	{"khilb", "㺎"},
	{"khilo", "㹹"},
	{"khio", "疺"},
	{"khitc", "獷"},
	{"khiuh", "狵"},
	{"khiv", "狘"},
	{"khivk", "狱"},
	{"khjb", "犻"},
	{"khjc", "狖"},
	{"khjco", "㺠"},
	{"khjdi", "狩"},
	{"khjg", "瘇"},
	{"khjjl", "獑"},
	{"khjka", "猪"},
	{"khjkd", "㹲"},
	{"khjkp", "狫"},
	{"khjlk", "㹬"},
	{"khjmc", "獱"},
	{"khjmf", "猔"},
	{"khjmn", "狞"},
	{"khjoc", "㺍"},
	{"khjp", "㾩"},
	{"khjpn", "獰"},
	{"khjr", "狜"},
	{"khjrb", "猢"},
	{"khjtc", "獖"},
	{"khjwo", "㺙"},
	{"khkcf", "獠"},
	{"khkkb", "狶"},
	{"khkmr", "猗"},
	{"khkn", "犰 㹫"},
	{"khkni", "犱"},
	{"khkoo", "狹"},
	{"khksr", "㹢"},
	{"khkt", "狭"},
	{"khl", "狆"},
	{"khlbk", "㹧"},
	{"khllb", "狮"},
	{"khlln", "狒"},
	{"khllv", "㺏"},
	{"khlmi", "独"},
	{"khlmo", "狣"},
	{"khlmy", "猅"},
	{"khlw", "㹨"},
	{"khlwp", "㹭"},
	{"khma", "㹮"},
	{"khmam", "狟"},
	{"khmbb", "獳"},
	{"khmbe", "獶"},
	{"khmbg", "㺢"},
	{"khmce", "獿"},
	{"khmcw", "𤞏"},
	{"khmfb", "獮"},
	{"khmfm", "狉"},
	{"khmg", "狂"},
	{"khmhf", "煍"},
	{"khmhm", "㺡"},
	{"khmj", "犴"},
	{"khmlk", "㹴"},
	{"khmmf", "狋"},
	{"khmmr", "㹳"},
	{"khmto", "獗"},
	{"khmvh", "犽"},
	{"khmvm", "㹵"},
	{"khmwd", "𤢂"},
	{"khnbq", "獬"},
	{"khndf", "煚"},
	{"khndt", "猛"},
	{"khndu", "犼"},
	{"khne", "疫"},
	{"khnf", "狝"},
	{"khng", "狃"},
	{"khngu", "峱"},
	{"khnhb", "獝"},
	{"khnhd", "猱"},
	{"khnhe", "𤜯"},
	{"khni", "瘋"},
	{"khnjk", "㺖"},
	{"khnk", "疯"},
	{"khnkg", "㹶"},
	{"khnkm", "狿"},
	{"khnmb", "獼"},
	{"khnmk", "㺅"},
	{"khnnf", "猕"},
	{"khnob", "𤟠"},
	{"khnok", "猤"},
	{"khnri", "㺥"},
	{"khnsd", "狰"},
	{"khnvm", "犸"},
	{"khod", "㹯"},
	{"khoe", "癁"},
	{"khog", "猚"},
	{"khogf", "㺘"},
	{"khoii", "狑"},
	{"khoim", "㺤"},
	{"khoir", "犌"},
	{"khok", "癓 癥"},
	{"kholk", "𤠣"},
	{"khoma", "獪"},
	{"khomd", "狳"},
	{"khomi", "狯"},
	{"khomm", "猃"},
	{"khomn", "㺄"},
	{"khomo", "獫"},
	{"khomr", "猞"},
	{"khon", "犵"},
	{"khonk", "猴"},
	{"khoo", "瘲 㿅"},
	{"khopd", "狏"},
	{"khor", "𤺥"},
	{"khpa", "狥 痻"},
	{"khpfd", "㹼"},
	{"khphp", "㺀"},
	{"khpi", "犳"},
	{"khppg", "狴"},
	{"khpr", "狗"},
	{"khpru", "狍"},
	{"khpu", "㹠"},
	{"khqhk", "猰"},
	{"khqhl", "狾"},
	{"khqkd", "犑"},
	{"khqmb", "猜"},
	{"khqmc", "㺓"},
	{"khqsk", "獓"},
	{"khrb", "狷"},
	{"khrrj", "㺗"},
	{"khrrk", "玁"},
	{"khrrr", "㺧"},
	{"khrye", "猳"},
	{"khryo", "㹱"},
	{"khs", "痄"},
	{"khsft", "㺛"},
	{"khshr", "㹦"},
	{"khsit", "㺝"},
	{"khsjt", "㺦"},
	{"khslk", "㺇"},
	{"khsmg", "㺟"},
	{"khsmh", "㺒"},
	{"khsp", "狔"},
	{"khsqf", "獁"},
	{"khsu", "犯"},
	{"khta", "猎"},
	{"khtak", "獏"},
	{"khtav", "獦"},
	{"khtbc", "猠"},
	{"khtbo", "獴"},
	{"khtco", "獛"},
	{"khtct", "獈"},
	{"khtcw", "猶"},
	{"khtgp", "㺊"},
	{"khtgu", "猐"},
	{"khtjl", "玂"},
	{"khtmc", "猉 獚"},
	{"khtoe", "獲"},
	{"khtpr", "㺃"},
	{"khtrg", "獾"},
	{"khtui", "獇"},
	{"khtw", "猫"},
	{"khtwv", "㺜"},
	{"khtxc", "㺌"},
	{"khub", "癟"},
	{"khuc", "㿗"},
	{"khuce", "猣"},
	{"khumb", "猯"},
	{"khumi", "㺈"},
	{"khuog", "獕"},
	{"khup", "瘜"},
	{"khvi", "疷"},
	{"khvis", "狕"},
	{"khvno", "猭"},
	{"khvo", "㽿"},
	{"khvp", "疧"},
	{"khvvd", "㺐"},
	{"khvvv", "獵"},
	{"khvvw", "㺁"},
	{"khwb", "猬"},
	{"khwd", "猓"},
	{"khwg", "狸"},
	{"khwl", "狎"},
	{"khwlg", "玀"},
	{"khwli", "獨"},
	{"khwln", "猡"},
	{"khwlv", "獧"},
	{"khwmv", "猥"},
	{"khxe", "瘦"},
	{"khxo", "瘐"},
	{"khxv", "癙"},
	{"khyaj", "㹿"},
	{"khyck", "狡"},
	{"khydk", "獤"},
	{"khye", "瘢"},
	{"khyg", "㹥"},
	{"khygq", "㺚"},
	{"khyhn", "犺"},
	{"khymh", "獩"},
	{"khymr", "狺"},
	{"khyoj", "猝"},
	{"khypt", "獹"},
	{"khypu", "猇"},
	{"khyrf", "猄"},
	{"khyrk", "獄"},
	{"khyrv", "獽"},
	{"khytg", "獞"},
	{"khyti", "㺣"},
	{"khytj", "獐"},
	{"khytu", "獍"},
	{"khyu", "㾷"},
	{"khyvi", "㹡"},
	{"khyy", "犿"},
	{"ki", "太"},
	{"kiav", "㾗"},
	{"kibt", "盇"},
	{"kice", "痠"},
	{"kihni", "䫺"},
	{"kiih", "瘮"},
	{"kiil", "㾿"},
	{"kijb", "痡"},
	{"kijc", "㾁"},
	{"kikh", "瘆"},
	{"kiku", "疣"},
	{"kimbl", "䎠"},
	{"kinl", "郄"},
	{"kiog", "雄"},
	{"kiov", "㾳"},
	{"kip", "态"},
	{"kir", "㾂"},
	{"kirm", "㚜"},
	{"kisb", "㾫"},
	{"kisl", "㕁"},
	{"kismm", "翃"},
	{"kiuh", "痝"},
	{"kiv", "奿"},
	{"kj", "夲"},
	{"kjbc", "瘨"},
	{"kjcc", "痲 癲"},
	{"kjcm", "㾤"},
	{"kjco", "癫"},
	{"kjdhe", "㿴"},
	{"kje", "㽻"},
	{"kjhhh", "㣏"},
	{"kjk", "㽴"},
	{"kjka", "奢 瓡 瘏"},
	{"kjkd", "痚"},
	{"kjp", "㾃"},
	{"kjr", "㽽"},
	{"kjrb", "㾰"},
	{"kjrr", "瑔 痯"},
	{"kjt", "奔"},
	{"kjtc", "㿎"},
	{"kjwj", "㾝"},
	{"kk", "爻 㚐"},
	{"kkb", "痏 肴"},
	{"kkbm", "爼"},
	{"kkcf", "療"},
	{"kkhaf", "鷞 鸑"},
	{"kkhg", "㾠"},
	{"kkk", "𡘙"},
	{"kkkb", "㾙"},
	{"kkkk", "爽 㸚"},
	{"kklb", "希"},
	{"kklu", "瓾 痷"},
	{"kkmbc", "䫪"},
	{"kkmr", "㾨"},
	{"kkmvn", "㼽"},
	{"kkn", "痍"},
	{"kknj", "疩"},
	{"kkog", "瘞"},
	{"kkoo", "㾜 㿓"},
	{"kkop", "瘱"},
	{"kkpb", "㿃"},
	{"kkrb", "瘸"},
	{"kks", "夯"},
	{"kksr", "痂"},
	{"kktg", "瘗"},
	{"kla", "暂"},
	{"klb", "布"},
	{"klbu", "㽸"},
	{"klc", "錾"},
	{"kld", "椠"},
	{"klg", "在"},
	{"kll", "夰"},
	{"klll", "夼"},
	{"klln", "疿 㚕"},
	{"klmc", "㿉"},
	{"klmi", "痋"},
	{"klmy", "痱"},
	{"kln", "刈"},
	{"klnd", "存"},
	{"klsd", "痫"},
	{"klw", "㾄 𡘊"},
	{"klwe", "痩"},
	{"klwu", "奄"},
	{"klwv", "瘻"},
	{"klxh", "㾅"},
	{"kly", "栆"},
	{"km", "左 疘"},
	{"kmaa", "奭"},
	{"kmbg", "癨"},
	{"kmbl", "㾍"},
	{"kmbw", "癗"},
	{"kmcw", "㾞"},
	{"kmd", "㽳"},
	{"kmdm", "癧"},
	{"kmfr", "痞"},
	{"kmgg", "癍 㻎 㿀"},
	{"kmig", "痓"},
	{"kmks", "疬"},
	{"kmlk", "㾘"},
	{"kmlm", "瘂"},
	{"kmlw", "癅"},
	{"kmm", "夳"},
	{"kmmf", "奈"},
	{"kmmi", "夽"},
	{"kmmp", "癋 㿛"},
	{"kmmr", "痦"},
	{"kmms", "夸 疞"},
	{"kmn", "疔"},
	{"kmnf", "𤹐"},
	{"kmnn", "㾐"},
	{"kmnr", "奇 疴"},
	{"kmob", "病"},
	{"kmrt", "痘"},
	{"kms", "疠"},
	{"kmso", "瓿 瘃"},
	{"kmtc", "痖"},
	{"kmua", "㿊"},
	{"kmvh", "疨"},
	{"kmvm", "痙"},
	{"kmvs", "㽲"},
	{"kmwf", "瘭"},
	{"kmwl", "奤"},
	{"kmy", "疜"},
	{"kmym", "症"},
	{"kn", "九 夷 𡯁"},
	{"kna", "旭 旮"},
	{"knbk", "瘓"},
	{"knbq", "㿍"},
	{"kncr", "癚"},
	{"knd", "杂"},
	{"kndt", "𤷪"},
	{"knfq", "癬"},
	{"knhaf", "鳩 䲥"},
	{"knhe", "㽺"},
	{"knhs", "疓"},
	{"kni", "丸 厹"},
	{"knib", "痛"},
	{"knin", "奓 痑"},
	{"knir", "㚚"},
	{"knj", "卆"},
	{"knjbc", "㐤"},
	{"knl", "㽼"},
	{"knld", "㾻"},
	{"knli", "癊"},
	{"knlm", "癃"},
	{"knlp", "癮"},
	{"knlr", "痾"},
	{"knmbc", "頄"},
	{"knmbk", "㐡"},
	{"knmq", "癣"},
	{"knn", "疗 㐇"},
	{"kno", "疚"},
	{"knoe", "癈"},
	{"knog", "䧱"},
	{"knom", "痉"},
	{"knop", "㾱"},
	{"knpym", "鸠"},
	{"knr", "叴"},
	{"knsh", "疡"},
	{"knsv", "瘬"},
	{"knthu", "馗"},
	{"knymr", "訄"},
	{"knypu", "虓"},
	{"kobuc", "𧶘"},
	{"kod", "㾋"},
	{"kodi", "㾈"},
	{"kog", "痽"},
	{"kogf", "癄"},
	{"kogg", "㚝"},
	{"kogi", "奪"},
	{"kogw", "奮"},
	{"kogx", "𡚒"},
	{"kohaf", "鵊"},
	{"kohh", "疹"},
	{"koii", "㾉"},
	{"koir", "瘡"},
	{"kok", "疾"},
	{"kokr", "痴"},
	{"koll", "疥"},
	{"koln", "㓨"},
	{"koma", "癐"},
	{"kombc", "頰"},
	{"komg", "痊"},
	{"komn", "瘉"},
	{"komo", "㿌"},
	{"komp", "癒"},
	{"komr", "㾑"},
	{"komvn", "㼪"},
	{"kon", "疙"},
	{"konk", "瘊"},
	{"konl", "郟"},
	{"kono", "㰰"},
	{"koo", "夾 㚒"},
	{"koog", "痤"},
	{"kop", "㤲"},
	{"kosu", "疮"},
	{"kowy", "痗"},
	{"koye", "㪎"},
	{"kp", "疕 㔫 㣻"},
	{"kpa", "㚛"},
	{"kpblb", "帶"},
	{"kpblo", "䠠"},
	{"kpblp", "慸"},
	{"kpko", "癡"},
	{"kpp", "疪"},
	{"kppa", "㾬"},
	{"kpr", "痀"},
	{"kpru", "疱"},
	{"kpt", "疶"},
	{"kqabt", "辒"},
	{"kqapp", "辊"},
	{"kqb", "䢁"},
	{"kqbtv", "辋"},
	{"kqee", "轰"},
	{"kqeee", "辍"},
	{"kqfdq", "辚"},
	{"kqgrv", "辕"},
	{"kqhby", "辀"},
	{"kqher", "辂"},
	{"kqhfd", "轷"},
	{"kqhk", "瘈"},
	{"kqhkl", "轿"},
	{"kqhml", "斩"},
	{"kqhp", "瘛"},
	{"kqhqo", "轶"},
	{"kqhvd", "轹"},
	{"kqijb", "辅"},
	{"kqipm", "轼"},
	{"kqixp", "辘"},
	{"kqjqr", "辖"},
	{"kqjr", "轱"},
	{"kqk", "轪"},
	{"kqkn", "轨"},
	{"kqlw", "轴"},
	{"kqmig", "轾"},
	{"kqmj", "轩"},
	{"kqmnr", "轲"},
	{"kqmob", "辆"},
	{"kqmrw", "辐"},
	{"kqmsu", "轭"},
	{"kqno", "软"},
	{"kqnom", "轻"},
	{"kqohh", "轸"},
	{"kqomg", "辁"},
	{"kqon", "䢀"},
	{"kqqkk", "辏"},
	{"kqqni", "转"},
	{"kqrc", "轵"},
	{"kqrsj", "辑"},
	{"kqshi", "轫"},
	{"kqshr", "轺"},
	{"kqsju", "辄"},
	{"kqsk", "㾲"},
	{"kqstv", "辗"},
	{"kqvvw", "辎"},
	{"kqybk", "辙"},
	{"kqyck", "较"},
	{"kqyrf", "辌"},
	{"kqys", "轳"},
	{"kqyt", "䢂"},
	{"kr", "右"},
	{"krb", "㾓"},
	{"krbo", "贺"},
	{"krbuc", "賀"},
	{"krc", "疻"},
	{"krd", "架"},
	{"krdhe", "㿲"},
	{"krhaf", "鴐 鵸"},
	{"krhqu", "毠"},
	{"krje", "攲"},
	{"krk", "㚙"},
	{"krkmr", "㚡"},
	{"krln", "剞"},
	{"krmbc", "䫑"},
	{"krmnr", "哿"},
	{"krmr", "䂟"},
	{"krn", "乫"},
	{"krno", "欹"},
	{"krnvm", "驾"},
	{"krog", "䧺"},
	{"kromb", "嗧"},
	{"krp", "㤎"},
	{"krq", "㧝"},
	{"krr", "㔔 㾔"},
	{"krrd", "㿋"},
	{"krrj", "癉"},
	{"krrp", "㖙"},
	{"krru", "癌"},
	{"krs", "㔖"},
	{"krsqf", "駕"},
	{"krsu", "㠰"},
	{"krv", "妿"},
	{"krye", "敧 瘕"},
	{"kryhv", "袈"},
	{"kryta", "䪪"},
	{"ks", "力"},
	{"ksc", "办"},
	{"ksce", "癜"},
	{"kshaf", "鴮"},
	{"kshvf", "綔"},
	{"kshvo", "瓠"},
	{"ksj", "耷"},
	{"ksk", "奁"},
	{"kske", "㿄"},
	{"ksksb", "脅"},
	{"ksksc", "䝱"},
	{"kskss", "劦"},
	{"ksksv", "姭"},
	{"ksl", "疖"},
	{"ksln", "刳"},
	{"ksm", "疟"},
	{"ksma", "㿇"},
	{"ksmb", "瘺"},
	{"ksme", "㾛"},
	{"ksmg", "㿑"},
	{"ksmh", "瘳"},
	{"ksmi", "套"},
	{"ksmv", "痮"},
	{"ksnl", "郀"},
	{"ksno", "㰭"},
	{"ksp", "痆"},
	{"kspru", "匏"},
	{"ksqf", "㾺"},
	{"ksql", "𤶸"},
	{"ksr", "加"},
	{"ksrj", "癖"},
	{"ksrq", "㿏"},
	{"ksrr", "奩"},
	{"kss", "奆"},
	{"kssu", "㾎"},
	{"ksu", "劜 㽶"},
	{"kswp", "勰"},
	{"kt", "夹 㚏"},
	{"kta", "瘄"},
	{"ktak", "瘼"},
	{"ktbc", "痶"},
	{"ktbs", "痨"},
	{"ktgf", "㚠"},
	{"ktj", "㚔"},
	{"ktjr", "瘔"},
	{"ktlm", "瘽"},
	{"ktln", "刾 㓫"},
	{"ktm", "疳"},
	{"ktmbc", "頬"},
	{"ktmbo", "颊"},
	{"ktmc", "癀"},
	{"ktmv", "瘎"},
	{"ktnl", "郏"},
	{"ktog", "癱"},
	{"ktor", "瘩"},
	{"ktov", "癢"},
	{"ktq", "痒 羍"},
	{"ktqm", "瘥"},
	{"ktuo", "瘚"},
	{"ktwb", "癘"},
	{"ktwv", "癑"},
	{"ktxc", "㾾"},
	{"ku", "尢 疝 㚎 㞭"},
	{"kuap", "㞁"},
	{"kubbb", "尳"},
	{"kubv", "㞂"},
	{"kudhe", "㝿"},
	{"kue", "㝽"},
	{"kugk", "㿂"},
	{"kuhaf", "鵪"},
	{"kuhjg", "尰"},
	{"kuisb", "㞈"},
	{"kukf", "㞀"},
	{"kuklu", "㞄"},
	{"kukm", "㝾"},
	{"kukmr", "㞆"},
	{"kulit", "尴"},
	{"kulmc", "尵"},
	{"kuln", "剦"},
	{"kumd", "㝼"},
	{"kumg", "尪"},
	{"kunl", "䣍"},
	{"kunmu", "尯"},
	{"kunsd", "尮"},
	{"kuoll", "尬"},
	{"kupi", "尥"},
	{"kupym", "鹌"},
	{"kusit", "尷"},
	{"kutqm", "㞉"},
	{"kutxc", "尲"},
	{"kuu", "㽾"},
	{"kuwd", "㞅"},
	{"kuwmv", "㞇"},
	{"kuye", "㪑"},
	{"kuyj", "㪺"},
	{"kveq", "𤸻"},
	{"kvfb", "癵"},
	{"kvfq", "癴"},
	{"kvhg", "㿈"},
	{"kvl", "㽱"},
	{"kvr", "㾒"},
	{"kvug", "癰"},
	{"kw", "奋"},
	{"kwd", "㾧"},
	{"kwg", "㾖"},
	{"kwgg", "癦"},
	{"kwgt", "𤼎"},
	{"kwjr", "痼"},
	{"kwle", "瘝"},
	{"kwlg", "㿚"},
	{"kwlk", "㿙"},
	{"kwlv", "癏"},
	{"kwml", "痹"},
	{"kwmv", "㾯"},
	{"kwot", "瘟"},
	{"kwr", "痐"},
	{"kwvf", "瘰"},
	{"kwwf", "癳"},
	{"kwww", "㿔"},
	{"ky", "冭"},
	{"kyav", "㾼"},
	{"kyfe", "㾥"},
	{"kyg", "疰"},
	{"kyhr", "㾽"},
	{"kylh", "㾟"},
	{"kymh", "奯"},
	{"kymp", "疵"},
	{"kyoj", "瘁"},
	{"kypd", "㾹"},
	{"kypm", "瘧 㾚"},
	{"kypt", "㿖"},
	{"kypu", "䖊"},
	{"kyr", "痁"},
	{"kyrb", "㾸"},
	{"kyrj", "㾵"},
	{"kysk", "瘯"},
	{"kysy", "瘀"},
	{"kyta", "瘖"},
	{"kytj", "瘴 㾕"},
	{"kytp", "癔"},
	{"kytr", "㾦"},
	{"kyvg", "癕"},
	{"kyvi", "痃"},
	{"kyvo", "痎"},
	{"kywd", "癛"},
	{"kywf", "癝"},
	{"kyx", "癠"},
	{"l", "中"},
	{"la", "旧 甴 衵"},
	{"laa", "裮"},
	{"lahu", "児"},
	{"laitb", "𢅺"},
	{"lam", "袒"},
	{"lamo", "褆"},
	{"lana", "襇"},
	{"lanb", "襉"},
	{"lanw", "襴"},
	{"laph", "裼"},
	{"lapp", "裩"},
	{"lapv", "褐"},
	{"lase", "襊"},
	{"lasm", "褟"},
	{"late", "襮"},
	{"lav", "裉"},
	{"lb", "巾"},
	{"lbab", "㡌"},
	{"lbabu", "帽"},
	{"lbafu", "幌"},
	{"lbahu", "𢃼"},
	{"lbanw", "幱"},
	{"lbapv", "幆"},
	{"lbau", "帊"},
	{"lbawe", "幔"},
	{"lbaws", "㡢"},
	{"lbayf", "幜"},
	{"lbb", "䙀"},
	{"lbbac", "幎"},
	{"lbbhx", "幍"},
	{"lbbjj", "㡓"},
	{"lbbmp", "㡥"},
	{"lbbof", "㡜"},
	{"lbbse", "㡪"},
	{"lbcru", "帨"},
	{"lbcsh", "帉"},
	{"lbcv", "䙬"},
	{"lbdhe", "帔"},
	{"lbdj", "帓"},
	{"lbdmq", "幃"},
	{"lbfb", "帩"},
	{"lbfbq", "幥"},
	{"lbfh", "㠺"},
	{"lbgni", "幬"},
	{"lbgr", "裯"},
	{"lbha", "帕"},
	{"lbhal", "幯"},
	{"lbhdw", "幡"},
	{"lbhey", "㠽"},
	{"lbhjg", "㡖"},
	{"lbhju", "㡒"},
	{"lbhml", "㠼"},
	{"lbhn", "㠶"},
	{"lbhni", "帆"},
	{"lbhqo", "帙"},
	{"lbhwp", "幒 㡙"},
	{"lbhyu", "㡗"},
	{"lbigi", "幮"},
	{"lbii", "帴"},
	{"lbiih", "幓"},
	{"lbikh", "㡎"},
	{"lbikk", "帗"},
	{"lbjct", "㡧"},
	{"lbjj", "褌"},
	{"lbjka", "帾"},
	{"lbjmc", "㡦"},
	{"lbjmo", "幏"},
	{"lbjnu", "帵"},
	{"lbjqp", "幰"},
	{"lbjtc", "幩"},
	{"lbk", "央"},
	{"lbklu", "㡋"},
	{"lbkms", "㡁"},
	{"lbkq", "裈"},
	{"lblbu", "帎"},
	{"lbllv", "㡞"},
	{"lbm", "袓"},
	{"lbma", "帞"},
	{"lbmbc", "幁 幊"},
	{"lbme", "褑"},
	{"lbmm", "衻"},
	{"lbmmi", "㡡"},
	{"lbmmv", "帪"},
	{"lbmn", "帄"},
	{"lbmrw", "幅"},
	{"lbmso", "䝉"},
	{"lbmvn", "㼙"},
	{"lbmwf", "幖"},
	{"lbnau", "㡈"},
	{"lbncr", "幨"},
	{"lbnhe", "㠷"},
	{"lbnhx", "㡊"},
	{"lbnin", "㡅"},
	{"lbnl", "鄁"},
	{"lbnot", "㡠"},
	{"lbnyi", "㡉"},
	{"lbog", "帷"},
	{"lboim", "㡨"},
	{"lboll", "㠹"},
	{"lbomn", "㡏"},
	{"lbomr", "帢"},
	{"lbonk", "帿"},
	{"lbotf", "幠"},
	{"lbovu", "㡃"},
	{"lbp", "㠲"},
	{"lbpa", "㡄"},
	{"lbpo", "帐"},
	{"lbptd", "幉"},
	{"lbqki", "帱"},
	{"lbqmc", "幘"},
	{"lbqmo", "帻"},
	{"lbqo", "㠸"},
	{"lbqs", "帏"},
	{"lbrc", "帜"},
	{"lbrrd", "幧"},
	{"lbrrj", "幝"},
	{"lbshi", "㠴"},
	{"lbshr", "𢁾"},
	{"lbsju", "㡇"},
	{"lbsmg", "幄"},
	{"lbsmh", "𢄪"},
	{"lbsmv", "帳"},
	{"lbstt", "幈"},
	{"lbt", "盅"},
	{"lbtak", "幙"},
	{"lbtbn", "㡐"},
	{"lbtbo", "幪"},
	{"lbtcd", "㡤"},
	{"lbtco", "幞"},
	{"lbtlk", "㡕"},
	{"lbtmc", "帺"},
	{"lbtt", "帡"},
	{"lbttb", "㡚"},
	{"lbtwa", "㡟"},
	{"lbtwi", "幭"},
	{"lbtxc", "㡘"},
	{"lbtyu", "㡛"},
	{"lbu", "冘"},
	{"lbv", "农"},
	{"lbvk", "䙎"},
	{"lbwg", "𢃇"},
	{"lbwim", "幗"},
	{"lbwmi", "帼"},
	{"lby", "袇"},
	{"lbybc", "幀"},
	{"lbybo", "帧"},
	{"lbyhc", "𢅳"},
	{"lbyhj", "㡝"},
	{"lbyia", "幟"},
	{"lbyjj", "帲"},
	{"lbyr", "帖"},
	{"lbytg", "幢"},
	{"lbytj", "幛"},
	{"lbytv", "帹"},
	{"lbyvu", "㡆"},
	{"lbyx", "䶓"},
	{"lc", "䘳"},
	{"lci", "衳"},
	{"lcip", "䙂"},
	{"lcmbc", "䫭"},
	{"lcnl", "鄪"},
	{"lcor", "裕"},
	{"lcru", "裞"},
	{"lcsh", "衯"},
	{"lcwa", "䙢"},
	{"ldbb", "襋"},
	{"ldci", "䘴"},
	{"lddf", "襟"},
	{"lddq", "襻"},
	{"ldhe", "被"},
	{"ldi", "衬"},
	{"ldj", "袜"},
	{"ldk", "袂"},
	{"ldlc", "襰"},
	{"ldmq", "褘"},
	{"ldpym", "鹇"},
	{"le", "隶 㕜"},
	{"leb", "肾"},
	{"lebo", "贤"},
	{"lebuc", "䝨"},
	{"leed", "褬"},
	{"leee", "裰"},
	{"leg", "坚"},
	{"lei", "衩"},
	{"levif", "紧"},
	{"leyt", "竖"},
	{"lfb", "䘯"},
	{"lfbf", "䘷"},
	{"lfbk", "襒"},
	{"lfbw", "襠"},
	{"lfdv", "褛"},
	{"lff", "裧"},
	{"lfpu", "䏋"},
	{"lfq", "袢"},
	{"lfqu", "裷"},
	{"lfsm", "裆"},
	{"lfwj", "褝"},
	{"lga", "書"},
	{"lgam", "晝"},
	{"lgb", "袡"},
	{"lgce", "裬"},
	{"lgg", "袿"},
	{"lggi", "褹"},
	{"lggu", "襓"},
	{"lggy", "褂"},
	{"lgi", "袪"},
	{"lgr", "袺"},
	{"lgrc", "襭"},
	{"lgrv", "褤"},
	{"lguw", "畵"},
	{"lgwc", "襩"},
	{"lgwm", "畫"},
	{"lha", "袙"},
	{"lhbk", "襖"},
	{"lhbt", "裇"},
	{"lhbuu", "䙻"},
	{"lhcj", "襷"},
	{"lhdw", "襎"},
	{"lheq", "袶"},
	{"lher", "袼"},
	{"lhg", "衽"},
	{"lhhh", "衫"},
	{"lhhj", "裨"},
	{"lhiom", "䪢"},
	{"lhjd", "袾"},
	{"lhjf", "䙧"},
	{"lhjg", "褈"},
	{"lhju", "䙉"},
	{"lhjx", "䙄"},
	{"lhk", "袄"},
	{"lhmo", "长"},
	{"lhn", "凣 䘛"},
	{"lhon", "裄"},
	{"lhoo", "褷 䙕"},
	{"lhpm", "袛"},
	{"lhqo", "袟"},
	{"lhsb", "褊"},
	{"lhuc", "襸"},
	{"lhul", "襣"},
	{"lhvp", "衹"},
	{"lhws", "𧞄"},
	{"lhxh", "裑"},
	{"lhxu", "䘽"},
	{"lhyu", "褫"},
	{"lia", "蚎"},
	{"liaa", "䗉"},
	{"liabu", "蝐"},
	{"liahm", "䗌"},
	{"liahu", "蝞"},
	{"liail", "蝍"},
	{"liam", "䖧"},
	{"liamh", "蝪"},
	{"liamo", "蝭"},
	{"liana", "𧒄"},
	{"liaph", "蜴"},
	{"liapp", "蜫"},
	{"liapv", "蝎"},
	{"liau", "蚆"},
	{"liav", "蛝"},
	{"liavf", "䗾"},
	{"liavo", "蠍"},
	{"liawe", "蟃"},
	{"liayt", "䗑"},
	{"lib", "蚏"},
	{"libac", "螟"},
	{"libbb", "螖"},
	{"libbr", "蝸"},
	{"libcv", "蠳"},
	{"libdi", "蛶"},
	{"libgr", "蜩"},
	{"libhu", "览"},
	{"libi", "䙏"},
	{"libkk", "蛧"},
	{"libm", "蛆"},
	{"libme", "蝯"},
	{"libmm", "蚦"},
	{"libnd", "蜉"},
	{"libp", "褦"},
	{"libt", "监"},
	{"libtv", "蝄"},
	{"libuc", "蛽"},
	{"libue", "蠼"},
	{"libug", "蠷"},
	{"libuu", "蜆"},
	{"libvk", "螇"},
	{"liby", "蚒"},
	{"lic", "鉴"},
	{"lici", "蚣"},
	{"licim", "螉"},
	{"lick", "蚥"},
	{"lickl", "䗄"},
	{"licmj", "䖫"},
	{"licru", "蛻"},
	{"licsh", "蚡"},
	{"licwj", "蝉"},
	{"lid", "蚞"},
	{"lidci", "蜙"},
	{"lidhe", "蚾"},
	{"lidhl", "蜥"},
	{"lidi", "䖞"},
	{"lidk", "蚗"},
	{"lidln", "蝲"},
	{"lidw", "蝀"},
	{"lieee", "蝃"},
	{"lieg", "蛏"},
	{"liesd", "蟝"},
	{"lifb", "蛸"},
	{"lifbb", "蟐"},
	{"lifbg", "螳"},
	{"lifbw", "蟷"},
	{"lifdq", "䗲"},
	{"lifdv", "蝼"},
	{"liff", "䗊"},
	{"liffd", "蠑"},
	{"liffs", "蟧"},
	{"lifh", "䖢"},
	{"lifhn", "蝋"},
	{"lifqu", "蜷"},
	{"ligb", "蚺"},
	{"ligce", "䗀"},
	{"ligg", "蛙"},
	{"liggu", "蟯"},
	{"ligi", "𧉧"},
	{"ligil", "䖼"},
	{"ligis", "蜐"},
	{"ligit", "䗘"},
	{"ligr", "蛣"},
	{"ligrr", "蟢"},
	{"ligth", "蟛"},
	{"lihad", "蟂"},
	{"lihaf", "䳋"},
	{"lihag", "蝗"},
	{"lihal", "䗻"},
	{"lihbr", "䖮"},
	{"lihdj", "蝌"},
	{"lihdn", "蜊"},
	{"lihdp", "蟋"},
	{"lihds", "蜏"},
	{"lihdv", "蜲"},
	{"lihdw", "蟠"},
	{"lihej", "蜂"},
	{"liher", "蛒"},
	{"lihf", "䙘"},
	{"lihhj", "蜱"},
	{"lihhv", "䖰"},
	{"lihhw", "䗜"},
	{"lihi", "螝"},
	{"lihjd", "蛛"},
	{"lihje", "𧎚"},
	{"lihjf", "䗼"},
	{"lihjg", "蝩"},
	{"lihjr", "蛞"},
	{"lihkb", "蟜"},
	{"lihlb", "蝺"},
	{"lihlo", "䖣"},
	{"lihml", "蚚"},
	{"lihmt", "䗗"},
	{"lihmy", "蚸"},
	{"lihn", "虮"},
	{"lihnd", "蟍 𧊶"},
	{"lihng", "䗴"},
	{"lihni", "䖠"},
	{"liho", "䙯"},
	{"lihoo", "䗥"},
	{"lihp", "虴"},
	{"lihpm", "蚳"},
	{"lihqi", "蛾"},
	{"lihqm", "﨡"},
	{"lihqo", "蛈"},
	{"lihqu", "蚝"},
	{"lihrb", "螄"},
	{"lihrf", "螐"},
	{"lihs", "蚱"},
	{"lihsb", "蝙"},
	{"lihsk", "蜧"},
	{"lihsu", "蚅"},
	{"lihuk", "螑"},
	{"lihup", "螅"},
	{"lihvo", "蛌"},
	{"lihvp", "蚔"},
	{"lihwi", "䘊"},
	{"lihwp", "蟌"},
	{"lihxe", "螋"},
	{"lihxu", "蜺"},
	{"lihyu", "螔"},
	{"lii", "䙁"},
	{"liiav", "蜋"},
	{"liibi", "䗚"},
	{"liidd", "䗫"},
	{"liih", "襂"},
	{"liihf", "䗩"},
	{"liihq", "蛑"},
	{"liihv", "蝛"},
	{"liii", "䗃"},
	{"liiil", "螂"},
	{"liijb", "蜅"},
	{"liije", "蛷"},
	{"liik", "蚁"},
	{"liikf", "蟡"},
	{"liikk", "蛂"},
	{"liiku", "蚘"},
	{"liilb", "䗤"},
	{"liile", "䗧"},
	{"liilr", "螗"},
	{"liioc", "蠀"},
	{"liirm", "蜮"},
	{"liitc", "蠊"},
	{"liitf", "蟅"},
	{"liitu", "蝷"},
	{"liiuh", "蛖"},
	{"liixp", "螰"},
	{"lij", "䘬"},
	{"lijb", "補"},
	{"lijbj", "蝻"},
	{"lijc", "䘤"},
	{"lijcg", "螲"},
	{"lije", "蚑"},
	{"lijfe", "䗏"},
	{"lijhp", "䖳"},
	{"lijig", "蠘"},
	{"lijim", "䘂"},
	{"lijip", "蟪"},
	{"lijj", "褲"},
	{"lijjl", "螹"},
	{"lijka", "蝫"},
	{"lijkp", "蛯"},
	{"lijlo", "蜨"},
	{"lijmc", "螾 蠙"},
	{"lijmm", "蝖"},
	{"lijmo", "蝊"},
	{"lijmu", "䖾"},
	{"lijnu", "蜿"},
	{"lijp", "蛇"},
	{"lijpa", "螧"},
	{"lijpn", "䗿"},
	{"lijpu", "蛲"},
	{"lijqp", "䘆"},
	{"lijqr", "螛"},
	{"lijr", "蛄"},
	{"lijrb", "蝴"},
	{"lijrr", "䗆"},
	{"lijtc", "蟦"},
	{"lijwj", "蛼"},
	{"lik", "奨"},
	{"likb", "蛕"},
	{"likcf", "蟟"},
	{"likgg", "蝰"},
	{"likk", "袚"},
	{"likkb", "䖷"},
	{"likkk", "䗮"},
	{"likmr", "䗁"},
	{"likn", "蛦"},
	{"likok", "螏"},
	{"likoo", "蛺"},
	{"likpb", "螮"},
	{"likq", "裤"},
	{"liksr", "𧊀"},
	{"likss", "蛠"},
	{"likt", "蛱"},
	{"lil", "蚛"},
	{"lilii", "蟲"},
	{"lilit", "蠱"},
	{"lillb", "蛳"},
	{"lille", "蝂"},
	{"lillp", "䗭"},
	{"lilmi", "螀 䖵"},
	{"lilmo", "䖴"},
	{"lilmq", "蝆"},
	{"lilw", "蚰"},
	{"lilwl", "𧊋"},
	{"lilwv", "螻"},
	{"lilx", "蟰"},
	{"lilxl", "蜵"},
	{"lim", "虹"},
	{"lima", "蛨"},
	{"limbb", "蠕"},
	{"limbc", "蝢"},
	{"limbk", "蝡"},
	{"limbs", "䘈"},
	{"limcw", "醤"},
	{"limd", "虶"},
	{"limfj", "蚲"},
	{"limfm", "蚽"},
	{"limg", "蚟"},
	{"limhf", "螈"},
	{"limig", "蛭"},
	{"limj", "虷"},
	{"limlb", "蜽"},
	{"limmi", "蟵"},
	{"limms", "蛎"},
	{"limmu", "蚖"},
	{"limmv", "蜄"},
	{"limn", "虰"},
	{"limnn", "蛚"},
	{"limnr", "蚵"},
	{"limob", "蛃"},
	{"limr", "䖨"},
	{"limrb", "螎"},
	{"limrw", "蝠"},
	{"limso", "䖶"},
	{"limt", "蚈"},
	{"limtb", "蠣"},
	{"limto", "蟩"},
	{"limvh", "蚜"},
	{"limvm", "蛵"},
	{"limwf", "螵"},
	{"limwg", "䗎"},
	{"limwj", "蟫"},
	{"limwl", "蝒"},
	{"limwm", "䗵"},
	{"limy", "虾"},
	{"limyf", "䗡"},
	{"linao", "蟓"},
	{"linbc", "蝜"},
	{"linbq", "蠏"},
	{"lincr", "蟾"},
	{"lind", "虸"},
	{"lindt", "蜢"},
	{"ling", "䖡"},
	{"linhb", "𧑐"},
	{"linhd", "蝚"},
	{"linhx", "蜭"},
	{"linib", "蛹"},
	{"linin", "蛥"},
	{"linkg", "蜓"},
	{"linkm", "蜒"},
	{"linl", "蚓"},
	{"linmu", "蛫"},
	{"lino", "㰩"},
	{"linob", "蝑"},
	{"linot", "䗳"},
	{"linue", "蜬"},
	{"linvm", "蚂"},
	{"linwf", "䗨"},
	{"lioae", "蝮"},
	{"liob", "蚋"},
	{"liodi", "蚹"},
	{"liog", "蜼"},
	{"liogf", "蟭"},
	{"lioii", "蛉"},
	{"lioim", "䘋"},
	{"lioin", "蚙"},
	{"lioip", "蚮"},
	{"lioir", "螥"},
	{"liokr", "蜘"},
	{"liolb", "䗛"},
	{"liold", "螩"},
	{"lioll", "蚧"},
	{"liom", "蚯"},
	{"liomb", "蜦"},
	{"liomd", "蜍"},
	{"liomg", "𧊲"},
	{"liomn", "蝓"},
	{"liomr", "蛤"},
	{"lion", "虼"},
	{"lionk", "䗔"},
	{"liono", "蜁"},
	{"liopc", "蟘"},
	{"liosk", "蛜"},
	{"liotf", "蟱"},
	{"lioyb", "蠄"},
	{"lip", "䘝"},
	{"lipa", "䖲"},
	{"lipd", "虵"},
	{"lipfd", "䗇"},
	{"liph", "䖩"},
	{"lipi", "虳"},
	{"lipim", "蚐"},
	{"lipkp", "䗓"},
	{"lipou", "蜪"},
	{"lipp", "蚍"},
	{"lippa", "蝔"},
	{"lippg", "蜌"},
	{"lipr", "蚼"},
	{"lipru", "蚫"},
	{"liptd", "蝶"},
	{"lipw", "蜔"},
	{"liq", "㧛"},
	{"liqj", "蚌"},
	{"liqka", "蝽"},
	{"liqkd", "螓"},
	{"liqkq", "蜯"},
	{"liqmb", "蜻"},
	{"liqmf", "螦"},
	{"liqmy", "蝳"},
	{"liqo", "蚨"},
	{"lirb", "蜎"},
	{"lirks", "𧊅"},
	{"lirlu", "蝇"},
	{"lirob", "蜗"},
	{"lirrj", "蟬"},
	{"liruc", "蟤"},
	{"lirvk", "蜈"},
	{"lirxu", "蠅"},
	{"lirye", "蝦"},
	{"lisav", "蝘"},
	{"lisem", "蠮"},
	{"lish", "虭"},
	{"lishr", "蛁"},
	{"lishu", "𧋦"},
	{"lisjr", "蜛"},
	{"lismg", "蠗 䖱"},
	{"lismh", "蟉"},
	{"lismi", "蟳"},
	{"lismm", "蛡"},
	{"lismv", "䗅"},
	{"liso", "蚇"},
	{"lisp", "蚭"},
	{"lisqf", "螞"},
	{"lisrg", "蟶"},
	{"liss", "蚷"},
	{"lisyi", "蠾"},
	{"lit", "裓"},
	{"lita", "蜡"},
	{"litak", "蟆"},
	{"litav", "䗶"},
	{"litb", "褯"},
	{"litbd", "蝾"},
	{"litbo", "蠓"},
	{"litcl", "蟖"},
	{"litco", "䗱"},
	{"litct", "螠"},
	{"litcw", "蝤"},
	{"litgi", "蟻"},
	{"litgr", "蟮"},
	{"litgu", "蜣"},
	{"litit", "蟒"},
	{"litjb", "䗖"},
	{"litkt", "蠎"},
	{"litlb", "蟎"},
	{"litlk", "蝧"},
	{"litlm", "螼"},
	{"litlx", "蠨"},
	{"litm", "蚶"},
	{"litmb", "螨"},
	{"litmc", "蜞 蟥"},
	{"litmd", "䗋"},
	{"litob", "蜹"},
	{"litoe", "蠖"},
	{"litpd", "蠂"},
	{"litq", "蛘 䖹"},
	{"litrg", "蠸"},
	{"litt", "蛢"},
	{"littc", "䗒"},
	{"litvi", "螆"},
	{"litvp", "䗹"},
	{"litw", "蛐"},
	{"litwa", "螬"},
	{"litwb", "蠇"},
	{"litwi", "蠛 𧒆"},
	{"litxc", "螊"},
	{"liu", "虬"},
	{"liuce", "蝬"},
	{"liumb", "𧍒"},
	{"liumt", "螘"},
	{"liuob", "蠵"},
	{"liuu", "䖦"},
	{"live", "袯"},
	{"livfi", "𧖣"},
	{"livfn", "䘎"},
	{"livii", "蟣"},
	{"livis", "蚴"},
	{"livl", "虯"},
	{"livno", "蝝"},
	{"livvv", "蠟"},
	{"liwb", "蝟"},
	{"liwd", "蜾"},
	{"liwfg", "䘃"},
	{"liwgf", "蟔"},
	{"liwgg", "䘃"},
	{"liwhd", "蜠"},
	{"liwim", "蟈"},
	{"liwjc", "䗰"},
	{"liwl", "䖬"},
	{"liwli", "蠋"},
	{"liwlj", "蠌"},
	{"liwlu", "蝿"},
	{"liwlv", "蠉"},
	{"liwmi", "蝈"},
	{"liwot", "蝹"},
	{"liwr", "蛔"},
	{"liwsl", "蜖"},
	{"liwvf", "螺"},
	{"liwww", "蠝"},
	{"liy", "虲"},
	{"liyav", "螁"},
	{"liybp", "蠬"},
	{"liybs", "螃"},
	{"liycb", "螪"},
	{"liyck", "蛟"},
	{"liyg", "蛀"},
	{"liygq", "蟽"},
	{"liyhj", "䗦"},
	{"liyhn", "蚢"},
	{"liyhr", "䗢"},
	{"liyhs", "蚄"},
	{"liyia", "蟙"},
	{"liyib", "蜟"},
	{"liyij", "蟀"},
	{"liyiu", "䖻"},
	{"liyj", "蚪"},
	{"liyk", "蚊"},
	{"liykl", "蛴"},
	{"liymo", "𧏿"},
	{"liymr", "䛓"},
	{"liyog", "䗯"},
	{"liyoj", "蜶"},
	{"liypb", "蟕"},
	{"liypt", "蠦"},
	{"liypu", "䗂"},
	{"liyr", "蛅"},
	{"liyra", "蠩"},
	{"liyrd", "蜳"},
	{"liyrn", "蝏"},
	{"liyro", "蠔"},
	{"liyru", "𧐢"},
	{"liyrv", "蠰"},
	{"liysd", "蝣"},
	{"liyso", "蜨"},
	{"liytj", "蟑"},
	{"liytp", "䗷"},
	{"liyub", "螭"},
	{"liyv", "虻"},
	{"liyvi", "蚿"},
	{"liyvu", "䗈"},
	{"liywm", "蟺"},
	{"liyx", "蠐"},
	{"lj", "𦘒"},
	{"ljc", "袕"},
	{"ljcr", "褣"},
	{"ljd", "𧙕"},
	{"lje", "衼"},
	{"ljic", "襶"},
	{"ljka", "褚"},
	{"ljlv", "褄"},
	{"ljmm", "䙋"},
	{"ljmn", "䘢"},
	{"ljmo", "䘺"},
	{"ljnu", "䘼"},
	{"ljp", "袉"},
	{"ljr", "𧙖"},
	{"ljrr", "䘾"},
	{"ljto", "䙭"},
	{"lk", "史"},
	{"lkbt", "盎"},
	{"lkdhe", "㿮"},
	{"lkhaf", "鴦"},
	{"lki", "𧘹"},
	{"lkk", "䘠"},
	{"lkld", "袸"},
	{"lklu", "裺"},
	{"lkm", "袏"},
	{"lkma", "襫"},
	{"lkmb", "䙃"},
	{"lkmr", "裿"},
	{"lkms", "袴"},
	{"lkmvn", "㼜"},
	{"lknau", "䒋"},
	{"lkoo", "裌"},
	{"lkpb", "𧜵"},
	{"lkpym", "鸯"},
	{"lkr", "𧙗"},
	{"ll", "串 衶"},
	{"llamh", "暢"},
	{"llaph", "𣈱"},
	{"llb", "䘜"},
	{"llbk", "䘧"},
	{"llbu", "衴"},
	{"llbuu", "覑"},
	{"lldwf", "朄"},
	{"llfl", "粛"},
	{"llfq", "牉"},
	{"llgwc", "牘"},
	{"llhe", "版"},
	{"llhhj", "牌"},
	{"llhjd", "㸡"},
	{"llhjx", "牐"},
	{"llhqu", "㲏"},
	{"llhsb", "牖"},
	{"llhwp", "牕"},
	{"llii", "牋"},
	{"llilb", "牗"},
	{"llit", "褴"},
	{"lll", "川"},
	{"lllb", "帅"},
	{"lllc", "順"},
	{"lllll", "㸞"},
	{"lllmo", "㸠"},
	{"lllo", "顺"},
	{"llmb", "师"},
	{"llmc", "䙡"},
	{"llml", "片"},
	{"llmo", "䙌"},
	{"llmy", "裶"},
	{"lln", "弗"},
	{"llno", "㸝"},
	{"llnri", "㸥"},
	{"llnsh", "畅"},
	{"lloa", "临"},
	{"llomn", "煃"},
	{"llp", "患"},
	{"llpa", "㸟"},
	{"llpb", "褙"},
	{"llpc", "䙫"},
	{"llpi", "畃"},
	{"llptd", "牒"},
	{"llsa", "裥"},
	{"llshr", "牊"},
	{"llsm", "归"},
	{"llsmb", "帰"},
	{"llsw", "襕"},
	{"lltcd", "㸣"},
	{"llthb", "㸢"},
	{"llw", "袖"},
	{"llwv", "褸"},
	{"llww", "丳"},
	{"llxl", "裫"},
	{"llybs", "牓"},
	{"llytv", "𤗈"},
	{"lm", "丄"},
	{"lma", "袹"},
	{"lmbb", "襦"},
	{"lmbi", "䙥"},
	{"lmbk", "䙇"},
	{"lmbl", "袻"},
	{"lmbo", "贵"},
	{"lmbuc", "貴"},
	{"lmfb", "襧"},
	{"lmfbc", "賮"},
	{"lmfbt", "盡"},
	{"lmft", "䀆"},
	{"lmg", "壮"},
	{"lmhdw", "䪤"},
	{"lmi", "虫"},
	{"lmig", "䘭"},
	{"lmik", "状"},
	{"lmj", "衦"},
	{"lmky", "䙣"},
	{"lmlb", "裲"},
	{"lmln", "劃"},
	{"lmmm", "韭"},
	{"lmmp", "襹"},
	{"lmmv", "裖"},
	{"lmnii", "将"},
	{"lmnr", "袔"},
	{"lmp", "北"},
	{"lmpnl", "邶"},
	{"lmr", "袥"},
	{"lmrb", "䙐"},
	{"lmrt", "裋"},
	{"lmrw", "褔"},
	{"lmto", "䙠"},
	{"lmuo", "兆"},
	{"lmuoc", "頫"},
	{"lmuof", "鴵"},
	{"lmuou", "覜"},
	{"lmv", "妆"},
	{"lmvi", "褥"},
	{"lmwf", "褾"},
	{"lmwu", "褼"},
	{"lmwv", "䙅"},
	{"lmyq", "羋"},
	{"lmyyn", "剕"},
	{"lmyyy", "非"},
	{"ln", "刂 鬥"},
	{"lnao", "襐"},
	{"lnbml", "鬬"},
	{"lnbo", "费"},
	{"lnbuc", "費"},
	{"lncr", "襜"},
	{"lnd", "桨"},
	{"lne", "浆"},
	{"lnhe", "衱"},
	{"lnhs", "𧘌"},
	{"lnhxu", "鬩"},
	{"lnib", "𧚔"},
	{"lnibi", "牔"},
	{"lnii", "襁"},
	{"lnin", "袳"},
	{"lnjnk", "牍"},
	{"lnk", "奖"},
	{"lnkm", "䘰"},
	{"lnks", "㔗"},
	{"lnl", "䘟"},
	{"lnln", "刜"},
	{"lnmcw", "酱"},
	{"lnmjk", "鬫"},
	{"lnmti", "鬪"},
	{"lnnau", "艴"},
	{"lnnru", "䰗"},
	{"lnnxu", "鬮"},
	{"lnoe", "襏"},
	{"lnok", "㪄 䙆"},
	{"lnoo", "䙍"},
	{"lnot", "䙞"},
	{"lnpkp", "牎"},
	{"lnrml", "鬭"},
	{"lnsmh", "䰘"},
	{"lntc", "鬨"},
	{"lnvm", "䘞"},
	{"lnyj", "鬦"},
	{"lnylb", "鬧"},
	{"loae", "複"},
	{"lob", "衲"},
	{"lodi", "袝"},
	{"lof", "袮"},
	{"logd", "襍"},
	{"logte", "鼗"},
	{"lohg", "袵"},
	{"lohh", "袗"},
	{"loii", "袊"},
	{"loik", "袱"},
	{"loim", "襳"},
	{"loin", "衿"},
	{"loll", "衸"},
	{"lolsm", "䪠 䪡"},
	{"loma", "襘"},
	{"lomm", "裣"},
	{"lomn", "褕"},
	{"lomo", "襝"},
	{"lomr", "袷"},
	{"lonk", "䙈"},
	{"lonl", "䣒"},
	{"lopd", "袘"},
	{"lord", "褓"},
	{"loto", "襥"},
	{"lp", "忠"},
	{"lpa", "䘩"},
	{"lpb", "背"},
	{"lpbcn", "㼱"},
	{"lpd", "衪"},
	{"lpfd", "䉾"},
	{"lpg", "㘳"},
	{"lph", "袐"},
	{"lphu", "兠"},
	{"lpim", "袀"},
	{"lpjwj", "軰"},
	{"lpm", "丠"},
	{"lpou", "裪"},
	{"lpq", "𠤖"},
	{"lpr", "袧"},
	{"lpru", "袍"},
	{"lpt", "袣"},
	{"lptd", "褋"},
	{"lpwtc", "冀"},
	{"lq", "聿"},
	{"lqf", "㶳"},
	{"lqhk", "褉"},
	{"lqmat", "衋 䀌"},
	{"lqmc", "襀"},
	{"lqmv", "裱"},
	{"lqo", "衭"},
	{"lqs", "袆"},
	{"lrb", "裐"},
	{"lrhg", "裎"},
	{"lrp", "㥈"},
	{"lrrd", "襙"},
	{"lrrj", "襌"},
	{"lruc", "襈"},
	{"lsaa", "阊"},
	{"lsasm", "阘"},
	{"lsav", "褗"},
	{"lsbbe", "阌"},
	{"lsbuk", "阒"},
	{"lscru", "阅"},
	{"lscwj", "阐"},
	{"lsd", "闲"},
	{"lsdh", "闭"},
	{"lsdwf", "阑"},
	{"lseg", "𧜶"},
	{"lsehr", "阔"},
	{"lsei", "䙱"},
	{"lseq", "䙙"},
	{"lsgg", "闺"},
	{"lsgit", "阖"},
	{"lsh", "初"},
	{"lshaf", "䳙"},
	{"lsher", "阁"},
	{"lshpa", "阍"},
	{"lshr", "袑"},
	{"lshxu", "阋"},
	{"lsiav", "阆"},
	{"lsirm", "阈"},
	{"lsit", "襤"},
	{"lsjbc", "阗"},
	{"lsjj", "襵"},
	{"lsjka", "阇"},
	{"lsjr", "裾"},
	{"lski", "闳"},
	{"lsklu", "阉"},
	{"lskr", "裙"},
	{"lslc", "頥"},
	{"lslmi", "闽"},
	{"lslmo", "阓"},
	{"lsm", "闩"},
	{"lsma", "褶"},
	{"lsme", "䘲"},
	{"lsmg", "闰"},
	{"lsmi", "襑"},
	{"lsmj", "闬"},
	{"lsmmm", "闫"},
	{"lsnhx", "阎"},
	{"lsnjk", "阚"},
	{"lsnok", "阕"},
	{"lsnsd", "䦶"},
	{"lsnvm", "闯"},
	{"lsnwu", "阄"},
	{"lso", "闪"},
	{"lsoi", "阀"},
	{"lsoog", "䦷"},
	{"lsp", "闷 䘦"},
	{"lsqs", "闱"},
	{"lsr", "问"},
	{"lsrr", "闾 䙔"},
	{"lssj", "闻"},
	{"lstuo", "阙"},
	{"lsusu", "闿"},
	{"lsuu", "䘿"},
	{"lswd", "阃"},
	{"lswl", "闸"},
	{"lswlb", "䦸"},
	{"lswlv", "阛"},
	{"lsyhn", "闶"},
	{"lsyk", "闵"},
	{"lsylb", "闹"},
	{"lsymr", "訚"},
	{"lsysy", "阏"},
	{"lsyvo", "阂"},
	{"ltaw", "襽"},
	{"ltbi", "襺"},
	{"ltbo", "䙩"},
	{"ltco", "襆"},
	{"ltgi", "襼"},
	{"ltjb", "䙊"},
	{"ltlb", "襔"},
	{"ltmc", "褀"},
	{"ltor", "褡"},
	{"ltqm", "褨"},
	{"ltrg", "䙮"},
	{"lttb", "褠"},
	{"ltwa", "褿"},
	{"ltwi", "襪"},
	{"ltwn", "䙦"},
	{"ltwv", "襛"},
	{"lu", "儿"},
	{"lubb", "䙖"},
	{"lue", "沊"},
	{"luf", "㷗 㷩"},
	{"luhaf", "鴆"},
	{"luhne", "㱽"},
	{"lumb", "褍"},
	{"lumbc", "䪴"},
	{"lumvn", "瓭"},
	{"lune", "䘶"},
	{"lunl", "邥"},
	{"luog", "䧵"},
	{"lupym", "鸩"},
	{"luu", "袦"},
	{"lvbu", "胤"},
	{"lvhaf", "鷜"},
	{"lvhqu", "氀"},
	{"lvhvo", "𤬏"},
	{"lvii", "𧝞"},
	{"lvis", "袎"},
	{"lvmbc", "䫫"},
	{"lvmvn", "甊"},
	{"lvne", "䘵"},
	{"lvnl", "䣚"},
	{"lvno", "褖"},
	{"lvok", "數"},
	{"lvr", "袽"},
	{"lvyj", "㪹"},
	{"lw", "由"},
	{"lwb", "冑 胄"},
	{"lwd", "裍 裸"},
	{"lwdq", "䙟"},
	{"lwdv", "䙨"},
	{"lwg", "裡"},
	{"lwk", "裀"},
	{"lwl", "申 䘥"},
	{"lwlg", "𧟌"},
	{"lwli", "襡 䙓"},
	{"lwlj", "襗"},
	{"lwlm", "𧝁"},
	{"lwlp", "襬"},
	{"lwlv", "婁"},
	{"lwmbc", "頔"},
	{"lwml", "畁"},
	{"lwmvs", "甹"},
	{"lwn", "㐕"},
	{"lwnl", "邮"},
	{"lwnvs", "㽕"},
	{"lwo", "㬰"},
	{"lwot", "褞"},
	{"lwp", "曳"},
	{"lwsu", "㕀"},
	{"lwtj", "襅"},
	{"lwu", "电"},
	{"lx", "肅"},
	{"lxh", "𠂔"},
	{"lxhaf", "鷫"},
	{"lxln", "㔅"},
	{"lxno", "歗"},
	{"lxpym", "鹔"},
	{"lxsmm", "䎘"},
	{"lxye", "㪩"},
	{"ly", "补"},
	{"lyav", "褪"},
	{"lybb", "褅 䙤"},
	{"lybg", "䙰"},
	{"lybp", "襱"},
	{"lybu", "𦚯"},
	{"lybuc", "䩀"},
	{"lycb", "䙗"},
	{"lyck", "䘨"},
	{"lycv", "䙛"},
	{"lyd", "棐"},
	{"lydu", "襯"},
	{"lygq", "𧞅"},
	{"lyhj", "䙜"},
	{"lyhq", "㹃"},
	{"lyhqu", "靟"},
	{"lyhuu", "䩁"},
	{"lyib", "䘻"},
	{"lyik", "猆"},
	{"lyiu", "裗 䘪"},
	{"lyjj", "褳"},
	{"lyjwj", "輩"},
	{"lyk", "奜"},
	{"lykq", "辈"},
	{"lylm", "𧘲"},
	{"lylmi", "蜚"},
	{"lymb", "褃"},
	{"lymbc", "䫍"},
	{"lymgi", "㻗"},
	{"lymp", "䘣"},
	{"lymy", "裃"},
	{"lyn", "㐟"},
	{"lynd", "𩇫"},
	{"lyoiv", "餥"},
	{"lyoj", "䘹"},
	{"lyok", "䘸"},
	{"lyp", "悲"},
	{"lypu", "裭"},
	{"lyr", "袩"},
	{"lysmm", "翡"},
	{"lysu", "䨽"},
	{"lyto", "襚"},
	{"lyub", "褵"},
	{"lyv", "婓"},
	{"lyvi", "袨"},
	{"lyvw", "䙒"},
	{"lywm", "襢"},
	{"lywv", "䙑"},
	{"lyyhv", "裴"},
	{"lyyk", "斐"},
	{"m", "一"},
	{"ma", "百"},
	{"mabk", "厭"},
	{"mad", "櫫"},
	{"mahl", "㪽"},
	{"mahr", "厬"},
	{"mai", "戩 戬"},
	{"maiu", "厩"},
	{"maln", "㓦 㔆"},
	{"mam", "亘"},
	{"mama", "皕"},
	{"mamaa", "𤾩"},
	{"mambc", "䫬"},
	{"mamgi", "𤧥"},
	{"mami", "㕌"},
	{"mamr", "碧"},
	{"mamvn", "㼣"},
	{"mand", "厚"},
	{"manl", "鄑 䣟"},
	{"mayj", "㪶"},
	{"mbaah", "霷"},
	{"mbapv", "䨠"},
	{"mbawe", "𩅍"},
	{"mbbb", "䨜"},
	{"mbbgr", "霌"},
	{"mbbhg", "霾"},
	{"mbbhv", "霢"},
	{"mbbie", "霡"},
	{"mbbmo", "霥"},
	{"mbbnd", "䨗"},
	{"mbbuu", "覼 䨘 䨳 𧢝"},
	{"mbcc", "𠫍"},
	{"mbchf", "靎"},
	{"mbchj", "𩆨"},
	{"mbcn", "厠"},
	{"mbcsh", "雰"},
	{"mbcwa", "䰝"},
	{"mbd", "雬"},
	{"mbdbe", "䨷"},
	{"mbdbu", "霜"},
	{"mbdci", "𩃭"},
	{"mbdd", "霖"},
	{"mbddh", "霦"},
	{"mbdhl", "䨛"},
	{"mbdi", "耐"},
	{"mbebg", "霪"},
	{"mbebr", "霘"},
	{"mbed", "霂"},
	{"mbedd", "䨬"},
	{"mbegg", "䨟"},
	{"mbehg", "䨙"},
	{"mbejb", "霈"},
	{"mbelu", "霃"},
	{"mbely", "𩄼"},
	{"mbemd", "䨕"},
	{"mbemj", "䨵"},
	{"mbemm", "靋"},
	{"mbeni", "霐"},
	{"mbeoi", "霗"},
	{"mbetc", "霟"},
	{"mbetj", "䨰"},
	{"mbetv", "霮"},
	{"mbeyg", "霔"},
	{"mbeyr", "霑"},
	{"mbeys", "霶"},
	{"mbf", "㶮 䎡"},
	{"mbfb", "霄"},
	{"mbfmu", "䨔"},
	{"mbg", "壐"},
	{"mbgwg", "䨪"},
	{"mbhaf", "鴯 鷊 鸍"},
	{"mbhdf", "𩄍"},
	{"mbhes", "雾"},
	{"mbhey", "𩂓"},
	{"mbhfd", "雽"},
	{"mbhhh", "耏"},
	{"mbhhw", "霤"},
	{"mbhlb", "䨞"},
	{"mbhml", "𩂋"},
	{"mbhoe", "䨱"},
	{"mbhok", "霺"},
	{"mbhp", "䨋"},
	{"mbhqu", "雮"},
	{"mbhui", "䰭 䰰"},
	{"mbhxu", "霓"},
	{"mbi", "戞"},
	{"mbibl", "䨶"},
	{"mbifl", "䨩"},
	{"mbijb", "鬴"},
	{"mbimo", "䨏"},
	{"mbivv", "霭"},
	{"mbje", "䰙"},
	{"mbjlv", "霋"},
	{"mbjmc", "靌"},
	{"mbjon", "䨫"},
	{"mbk", "耎"},
	{"mbkb", "䨖"},
	{"mbkmr", "𩃤"},
	{"mbkn", "䨑"},
	{"mbks", "勵 㔝"},
	{"mblbk", "雵"},
	{"mbll", "而"},
	{"mblmi", "融"},
	{"mblmo", "雿"},
	{"mblmy", "霏"},
	{"mbm", "亙"},
	{"mbmbc", "顬 䫱"},
	{"mbmbl", "需"},
	{"mbmbo", "颥"},
	{"mbmd", "𩁹"},
	{"mbmdm", "靂"},
	{"mbmgi", "璽"},
	{"mbmin", "𩃬"},
	{"mbmks", "雳"},
	{"mbmmc", "霊"},
	{"mbmmi", "雲"},
	{"mbmms", "雩"},
	{"mbmmu", "䨌"},
	{"mbmmv", "震"},
	{"mbmr", "雼"},
	{"mbmvn", "䰛"},
	{"mbmy", "雫"},
	{"mbnai", "䨲"},
	{"mbnhe", "雭"},
	{"mbnhk", "霚"},
	{"mbnhs", "霧"},
	{"mbnhu", "霿"},
	{"mbni", "䨎"},
	{"mbnib", "霱"},
	{"mbnih", "雺"},
	{"mbnkg", "霆"},
	{"mbnkm", "𩃀"},
	{"mbnl", "邴 䣓"},
	{"mbnlm", "霳"},
	{"mbnlp", "䨸"},
	{"mbnlq", "𩄐"},
	{"mbnlw", "䨯"},
	{"mbnnn", "霛"},
	{"mbnoo", "䬠"},
	{"mbnot", "霯"},
	{"mbo", "页"},
	{"mboah", "鬺"},
	{"mbod", "𩂯"},
	{"mbog", "霍"},
	{"mboge", "䨥"},
	{"mbogf", "靍"},
	{"mbogg", "靃"},
	{"mbohb", "𩃥"},
	{"mboii", "零"},
	{"mbolf", "䨹"},
	{"mbomr", "䨐"},
	{"mbon", "厕"},
	{"mbowy", "霉"},
	{"mbp", "恧 㥑 𩂈"},
	{"mbphe", "憂"},
	{"mbphp", "䨚"},
	{"mbpru", "雹"},
	{"mbpym", "鹂 䴓"},
	{"mbqjs", "䨮"},
	{"mbqmb", "䨝"},
	{"mbrbc", "霣"},
	{"mbrji", "霵"},
	{"mbrmr", "露"},
	{"mbrrg", "𤫊"},
	{"mbrri", "𩆜"},
	{"mbrrm", "靈"},
	{"mbrrp", "龗"},
	{"mbrrr", "霝"},
	{"mbrrv", "孁"},
	{"mbrye", "霞"},
	{"mbsfi", "霨"},
	{"mbsm", "雪"},
	{"mbsma", "霫"},
	{"mbsmm", "翮 䨒"},
	{"mbsmr", "𠻸"},
	{"mbsrj", "霹"},
	{"mbtbk", "霰"},
	{"mbtbo", "靀"},
	{"mbtcl", "𩅰"},
	{"mbtgi", "䨴"},
	{"mbtjb", "霸"},
	{"mbtlj", "䨣"},
	{"mbtlk", "霙"},
	{"mbtm", "雸"},
	{"mbtmv", "䨢"},
	{"mbtt", "䨍"},
	{"mbtwt", "霻"},
	{"mbuc", "貢 頁"},
	{"mbuce", "鬷"},
	{"mbujt", "靊"},
	{"mbune", "䨡"},
	{"mbv", "耍"},
	{"mbvr", "𩂰"},
	{"mbw", "雷"},
	{"mbwr", "䨓"},
	{"mbwtc", "霬"},
	{"mbwu", "電"},
	{"mbwww", "靁"},
	{"mbybp", "靇"},
	{"mbybs", "䨦"},
	{"mbydl", "霩"},
	{"mbye", "㪅"},
	{"mbyhj", "𩅛"},
	{"mbyhr", "䨨"},
	{"mbyhs", "雱"},
	{"mbyhv", "𩂱"},
	{"mbyk", "雯 䰚"},
	{"mbykl", "霁"},
	{"mbylw", "䨤"},
	{"mbymr", "霅"},
	{"mbyrv", "靄"},
	{"mbyt", "雴"},
	{"mbyti", "䨧"},
	{"mbytn", "霠"},
	{"mbytv", "霎"},
	{"mbyx", "霽"},
	{"mc", "㕋"},
	{"mca", "晋"},
	{"mcfdq", "䫰"},
	{"mcg", "垩"},
	{"mche", "夒"},
	{"mchq", "㹕"},
	{"mcml", "顨"},
	{"mcohh", "䪾"},
	{"mcp", "恶 慐 𢥧 𢦀"},
	{"mcw", "西"},
	{"mcwm", "酉"},
	{"md", "于"},
	{"mda", "曆"},
	{"mdbt", "盂"},
	{"mdbu", "厢"},
	{"mdda", "暦"},
	{"mddi", "厯"},
	{"mddo", "𠪴"},
	{"mdf", "㷴"},
	{"mdhaf", "鷅"},
	{"mdln", "㔄"},
	{"mdm", "五"},
	{"mdmgi", "㻺"},
	{"mdmr", "磿"},
	{"mdnl", "邘"},
	{"mdok", "㪀"},
	{"mdp", "𢟍"},
	{"mdykm", "䊲"},
	{"mdylm", "歴 歷"},
	{"me", "汞"},
	{"mebu", "䀾"},
	{"mec", "𨫣"},
	{"mem", "亟"},
	{"menl", "鄾"},
	{"meno", "㱊"},
	{"meoiv", "䬸"},
	{"mer", "唘"},
	{"mf", "不 𣎴"},
	{"mfa", "㫘"},
	{"mfbk", "厰 爾"},
	{"mfbq", "甭"},
	{"mfbt", "盃"},
	{"mfbuc", "贗"},
	{"mfbuu", "覔 覝"},
	{"mff", "㶨 㶪"},
	{"mfhaf", "鴀"},
	{"mfhhh", "彯"},
	{"mfhni", "飄"},
	{"mfhnk", "飘"},
	{"mfhvo", "瓢"},
	{"mfj", "平 㔻"},
	{"mfjbm", "𠁆"},
	{"mfk", "奀"},
	{"mfks", "勡"},
	{"mfln", "剽 㓹"},
	{"mfm", "丕"},
	{"mfmbc", "願 顠"},
	{"mfmff", "厵"},
	{"mfmmf", "祘"},
	{"mfmvn", "㼼"},
	{"mfmwv", "嫑"},
	{"mfmym", "歪"},
	{"mfnl", "鄢"},
	{"mfoiv", "䬩"},
	{"mfomi", "𠀾"},
	{"mfp", "愿"},
	{"mfr", "否"},
	{"mfrbc", "𧶏"},
	{"mfsmm", "翲"},
	{"mfu", "礼"},
	{"mfvnd", "孬"},
	{"mfyiu", "𥜆"},
	{"mg", "王 𤣩"},
	{"mga", "㬜"},
	{"mgaa", "琩"},
	{"mgabt", "瑥"},
	{"mgabu", "瑁"},
	{"mgahm", "瑋"},
	{"mgahu", "瑊"},
	{"mgamh", "獂"},
	{"mgamo", "瑅"},
	{"mgana", "𤩎"},
	{"mganw", "瓓"},
	{"mgaph", "㻛"},
	{"mgapp", "琨"},
	{"mgau", "琶"},
	{"mgav", "珢"},
	{"mgawe", "㻴"},
	{"mgayf", "璟"},
	{"mgayk", "琝"},
	{"mgb", "再 玥"},
	{"mgbb", "㻚"},
	{"mgbbe", "璦"},
	{"mgbbq", "𤩥"},
	{"mgbcd", "琛"},
	{"mgbcv", "瓔"},
	{"mgbgr", "琱"},
	{"mgbhn", "𤤌"},
	{"mgbhu", "现"},
	{"mgbhx", "瑫"},
	{"mgbjj", "琿"},
	{"mgbkq", "珲"},
	{"mgbm", "珇"},
	{"mgbme", "猺"},
	{"mgbnd", "琈"},
	{"mgbof", "㻮"},
	{"mgbou", "瑤 瑶"},
	{"mgbov", "璎"},
	{"mgbr", "㺾"},
	{"mgbsd", "琤"},
	{"mgbt", "珊"},
	{"mgbu", "㺺"},
	{"mgbuc", "珼"},
	{"mgbuu", "現 䚈"},
	{"mgby", "玬"},
	{"mgc", "琻 𨨖"},
	{"mgci", "玜"},
	{"mgcnh", "珶"},
	{"mgcsh", "玢"},
	{"mgcwa", "璔"},
	{"mgd", "琹"},
	{"mgdbb", "㻷"},
	{"mgdd", "琳"},
	{"mgddo", "璴"},
	{"mgdhe", "玻"},
	{"mgdk", "玦"},
	{"mgdl", "㻋"},
	{"mgdlc", "瓎"},
	{"mgdln", "㻝"},
	{"mgdmq", "猼"},
	{"mgdoo", "琜"},
	{"mgdwf", "瑓"},
	{"mgea", "𤦊"},
	{"mgegi", "琺"},
	{"mgeii", "瑵"},
	{"mgemn", "𤤾"},
	{"mgesd", "璖"},
	{"mgfb", "琑"},
	{"mgfbb", "瑺"},
	{"mgfbc", "瑣"},
	{"mgfbo", "琐"},
	{"mgfbw", "璫"},
	{"mgfdq", "璘"},
	{"mgff", "琰"},
	{"mgffd", "𤪤"},
	{"mgffg", "㼆"},
	{"mgffs", "𤩂"},
	{"mgfmu", "珖"},
	{"mgfqu", "𤦔"},
	{"mgfsm", "珰"},
	{"mgfv", "珱"},
	{"mgg", "厓 𤣰"},
	{"mggb", "珃"},
	{"mggce", "𤦫"},
	{"mggg", "珪"},
	{"mgggu", "𤩊"},
	{"mggi", "珐"},
	{"mggnf", "瓙"},
	{"mggni", "璹"},
	{"mggp", "𤥴"},
	{"mggsk", "璈"},
	{"mggwc", "瓄"},
	{"mgha", "珀"},
	{"mghae", "瑑"},
	{"mghaf", "鳿 鵄 𪆒"},
	{"mghag", "瑝"},
	{"mghbr", "珦"},
	{"mghby", "珘"},
	{"mghdc", "璳"},
	{"mghdd", "㻑"},
	{"mghdf", "𤧐"},
	{"mghdg", "𤩏"},
	{"mghdl", "𤦋"},
	{"mghdn", "琍"},
	{"mghds", "琇"},
	{"mghdw", "璠"},
	{"mghej", "琒"},
	{"mgher", "珞"},
	{"mghgr", "𤥢"},
	{"mghgu", "珗"},
	{"mghhe", "瓈"},
	{"mghhj", "琕"},
	{"mghhl", "珋"},
	{"mghhw", "瑠"},
	{"mghi", "瑰"},
	{"mghj", "𤣳"},
	{"mghjd", "珠"},
	{"mghje", "瑖"},
	{"mghjm", "㻔"},
	{"mghjr", "𤪔"},
	{"mghkb", "𤩝"},
	{"mghlb", "獀"},
	{"mghlc", "瓆"},
	{"mghlq", "㻶"},
	{"mghmo", "㻄"},
	{"mghmr", "㻈"},
	{"mghn", "玑"},
	{"mghnb", "珮"},
	{"mghnf", "𤪧"},
	{"mghni", "㺬"},
	{"mghnn", "珟"},
	{"mghoh", "𤨤 𤪱"},
	{"mghon", "珩 𤦷"},
	{"mghoo", "瑽"},
	{"mghpa", "琘"},
	{"mghqi", "珴"},
	{"mghqm", "珄"},
	{"mghrb", "瑡"},
	{"mghrf", "瑦"},
	{"mghsk", "璬"},
	{"mghuc", "瓚"},
	{"mghul", "䶍"},
	{"mghuo", "瓒"},
	{"mghwp", "璁"},
	{"mghxc", "璵"},
	{"mghxu", "𤦤"},
	{"mgi", "玉 玊 㺨"},
	{"mgiav", "琅"},
	{"mgib", "㻆"},
	{"mgice", "㻐"},
	{"mgihm", "珬"},
	{"mgihr", "犎"},
	{"mgihs", "珹 臹"},
	{"mgihu", "玧"},
	{"mgii", "琖"},
	{"mgiib", "𤨡"},
	{"mgiil", "瑯"},
	{"mgijc", "㺷"},
	{"mgije", "球"},
	{"mgik", "㺴"},
	{"mgikp", "珑"},
	{"mgilg", "班"},
	{"mgilr", "瑭"},
	{"mgine", "𤤯"},
	{"mging", "𤧻"},
	{"mgir", "珆"},
	{"mgirm", "琙"},
	{"mgisb", "㻞"},
	{"mgisk", "璷"},
	{"mgit", "㕎 㺹"},
	{"mgitc", "㼅"},
	{"mgjbc", "瑱"},
	{"mgjbm", "𤦌"},
	{"mgjch", "獊"},
	{"mgjck", "㻠"},
	{"mgjcr", "瑢"},
	{"mgjhw", "𤪺"},
	{"mgjii", "瑼"},
	{"mgjip", "璤"},
	{"mgjka", "琽"},
	{"mgjkp", "珯"},
	{"mgjkr", "𤨥"},
	{"mgjll", "㻘"},
	{"mgjmc", "璌 璸"},
	{"mgjmf", "琮"},
	{"mgjmm", "犐"},
	{"mgjmo", "琔 𤨎"},
	{"mgjmu", "琓 𤩷"},
	{"mgjnu", "琬"},
	{"mgjoc", "瑸"},
	{"mgjpn", "𤪥"},
	{"mgjrb", "瑚"},
	{"mgjrr", "琯"},
	{"mgjru", "𤥣"},
	{"mgjv", "𤥃"},
	{"mgjyu", "𤪓"},
	{"mgk", "㺯"},
	{"mgkb", "珛"},
	{"mgkcf", "璙"},
	{"mgkhr", "𤨦"},
	{"mgkkb", "琋"},
	{"mgkld", "珔 臶"},
	{"mgkmb", "㻟"},
	{"mgkmr", "琦"},
	{"mgkoo", "𤥵"},
	{"mgks", "玏"},
	{"mgksr", "珈"},
	{"mgkss", "珕"},
	{"mgle", "㻖"},
	{"mglll", "玔"},
	{"mglln", "𤤖"},
	{"mgllv", "㻲"},
	{"mglmc", "璝"},
	{"mglmo", "珧"},
	{"mglmt", "璶"},
	{"mglmy", "琲"},
	{"mgln", "到 㺫"},
	{"mglq", "珒"},
	{"mglwk", "㻀"},
	{"mglwl", "珅"},
	{"mglx", "璛"},
	{"mgm", "玒"},
	{"mgma", "𤤿"},
	{"mgmbb", "瓀"},
	{"mgmbc", "頊"},
	{"mgmbe", "瓇 𤫑"},
	{"mgmbk", "瑌"},
	{"mgmbm", "𤫩"},
	{"mgmbo", "顼"},
	{"mgmbr", "𤫢"},
	{"mgmbs", "㻬"},
	{"mgmd", "玗"},
	{"mgmf", "环 𦤹"},
	{"mgmfj", "玶"},
	{"mgmfm", "㺽"},
	{"mgmg", "玨"},
	{"mgmgh", "璱"},
	{"mgmgi", "珏"},
	{"mgmhl", "琊"},
	{"mgmhm", "瓑"},
	{"mgmia", "瑨"},
	{"mgmig", "臸"},
	{"mgmj", "玕"},
	{"mgmlb", "㺰"},
	{"mgmlm", "𤦩"},
	{"mgmlw", "璢"},
	{"mgmmp", "𤫟"},
	{"mgmmr", "珸"},
	{"mgmms", "㺮"},
	{"mgmmu", "玩"},
	{"mgmn", "玎"},
	{"mgmnr", "珂"},
	{"mgmpm", "珷"},
	{"mgmso", "琢"},
	{"mgmt", "𤣿"},
	{"mgmtb", "𤪲"},
	{"mgmua", "㻸"},
	{"mgmue", "𤧶"},
	{"mgmvh", "玡"},
	{"mgmvn", "珁 甄"},
	{"mgmwd", "瑮"},
	{"mgmwf", "𤨧"},
	{"mgmwj", "㻼"},
	{"mgnau", "㻊"},
	{"mgnbe", "瓊"},
	{"mgnbk", "瑒"},
	{"mgnd", "㺭"},
	{"mgne", "𤣻"},
	{"mgnf", "珎"},
	{"mgng", "㺲"},
	{"mgnhb", "璚"},
	{"mgnhd", "瑈"},
	{"mgnin", "𤥀"},
	{"mgnir", "𤥁"},
	{"mgnj", "𤣲"},
	{"mgnkg", "珽"},
	{"mgnkm", "𤥻"},
	{"mgnkq", "𤧣"},
	{"mgnl", "郅 鄄 䣑"},
	{"mgnlb", "瓍"},
	{"mgno", "歅 玖 㱋 㺵"},
	{"mgnot", "璒"},
	{"mgnqd", "㻧"},
	{"mgnsh", "玚"},
	{"mgnvm", "玛"},
	{"mgnyo", "㺼"},
	{"mgo", "珡"},
	{"mgog", "琟"},
	{"mgogs", "㻪 㻽"},
	{"mgohb", "𤦍"},
	{"mgohh", "珍"},
	{"mgoii", "玲"},
	{"mgoin", "玪 琴"},
	{"mgoip", "玳 𤦬"},
	{"mgoir", "琀 瑲"},
	{"mgoj", "玝"},
	{"mgoju", "珤"},
	{"mgok", "玫 致"},
	{"mgoll", "玠"},
	{"mgoma", "璯"},
	{"mgomb", "𤦎"},
	{"mgomd", "㻌"},
	{"mgomg", "㻇"},
	{"mgomi", "㻅"},
	{"mgomn", "瑜"},
	{"mgomr", "珨"},
	{"mgono", "琁"},
	{"mgooo", "㻜"},
	{"mgord", "𤦸"},
	{"mgosu", "玱"},
	{"mgotf", "璑"},
	{"mgotq", "𤪕"},
	{"mgowy", "珻"},
	{"mgoyk", "𤨨"},
	{"mgpa", "珣"},
	{"mgph", "珌 瑟"},
	{"mgphp", "𤦏"},
	{"mgpi", "玓"},
	{"mgpko", "𤪦"},
	{"mgpkp", "𤧚"},
	{"mgpp", "玭 琵"},
	{"mgppa", "瑄"},
	{"mgpr", "玽"},
	{"mgpru", "玸"},
	{"mgpt", "玴"},
	{"mgptd", "㻡"},
	{"mgpu", "𤤀"},
	{"mgqhf", "𤩦"},
	{"mgqj", "玤"},
	{"mgqjm", "㻰"},
	{"mgqjp", "𤪳"},
	{"mgqka", "瑃"},
	{"mgqkd", "瑧 臻"},
	{"mgqkq", "琫"},
	{"mgqmb", "𤦭"},
	{"mgqmw", "瑇"},
	{"mgqo", "玞"},
	{"mgqoc", "瓉"},
	{"mgqs", "玮"},
	{"mgrb", "琄"},
	{"mgrhg", "珵"},
	{"mgrmr", "璐"},
	{"mgrpa", "瑉"},
	{"mgrr", "噩"},
	{"mgrrd", "璪"},
	{"mgrrj", "𤩧"},
	{"mgrvk", "㻍"},
	{"mgrvp", "珉"},
	{"mgrye", "瑕"},
	{"mgryo", "珿"},
	{"mgshr", "玿"},
	{"mgsj", "珥"},
	{"mgsje", "㻓"},
	{"mgsjl", "瑘"},
	{"mgsjr", "琚"},
	{"mgsk", "厫 䑒"},
	{"mgskr", "珺"},
	{"mgsll", "㺿"},
	{"mgsmf", "㻏"},
	{"mgsmh", "璆"},
	{"mgsmi", "璕"},
	{"mgsmj", "璻"},
	{"mgsmm", "珝"},
	{"mgsmt", "璼"},
	{"mgsnd", "㻵"},
	{"mgsp", "𤤗"},
	{"mgsqf", "瑪"},
	{"mgsql", "𤥶"},
	{"mgstt", "𤧅"},
	{"mgstv", "𤧷"},
	{"mgsu", "玘 𤣱"},
	{"mgsuu", "㻕"},
	{"mgt", "弄"},
	{"mgtbc", "琠"},
	{"mgtbn", "獉"},
	{"mgtc", "珙"},
	{"mgtcf", "𤪌"},
	{"mgtcg", "璂"},
	{"mgtch", "𤦈"},
	{"mgtcl", "𤩐"},
	{"mgtco", "璞"},
	{"mgtcw", "㻥"},
	{"mgtgi", "㼁"},
	{"mgtgk", "𤧞"},
	{"mgtgt", "瓂"},
	{"mgtgu", "琷"},
	{"mgthn", "㻳"},
	{"mgths", "璓"},
	{"mgti", "㕑"},
	{"mgtio", "𤦧"},
	{"mgtjs", "𤨕"},
	{"mgtlb", "璊"},
	{"mgtlf", "𤫇"},
	{"mgtlk", "瑛"},
	{"mgtlm", "瑾"},
	{"mgtlo", "𤨢"},
	{"mgtm", "玵"},
	{"mgtmc", "琪 璜"},
	{"mgtmj", "璍"},
	{"mgtmv", "㻣"},
	{"mgtnk", "𤩸"},
	{"mgtod", "瑹 𤨓"},
	{"mgtoe", "瓁"},
	{"mgtpr", "㻤"},
	{"mgtq", "珜"},
	{"mgtqg", "𤨩"},
	{"mgtqm", "瑳"},
	{"mgtrg", "瓘"},
	{"mgtrk", "璥"},
	{"mgtt", "㻂"},
	{"mgtvi", "𤧹"},
	{"mgtxc", "㻩"},
	{"mgtyj", "𤪼"},
	{"mgu", "玌"},
	{"mguap", "𤨾"},
	{"mgufk", "𤪖"},
	{"mgumb", "瑞"},
	{"mgumt", "𤧸"},
	{"mguob", "瓗"},
	{"mguog", "璀"},
	{"mguon", "琌"},
	{"mguos", "㼇"},
	{"mgutn", "𤩑"},
	{"mgvid", "瓅"},
	{"mgvii", "璣"},
	{"mgvio", "𤤳"},
	{"mgviw", "㼄"},
	{"mgvl", "㺩"},
	{"mgvmp", "璏"},
	{"mgvne", "琭"},
	{"mgvno", "猻"},
	{"mgvvd", "璅"},
	{"mgvvv", "㼃"},
	{"mgvvw", "瑙"},
	{"mgwg", "理"},
	{"mgwhd", "㻒"},
	{"mgwjc", "瑻"},
	{"mgwk", "珚"},
	{"mgwkp", "𤨒"},
	{"mgwl", "玾"},
	{"mgwlb", "㻦"},
	{"mgwlg", "㼈"},
	{"mgwli", "㻿"},
	{"mgwlv", "環"},
	{"mgwol", "琾"},
	{"mgwr", "㻁"},
	{"mgwtj", "㻫"},
	{"mgwww", "瓃"},
	{"mgy", "㺪"},
	{"mgyaj", "琸"},
	{"mgybc", "𤦹"},
	{"mgybj", "璭"},
	{"mgybk", "瓛"},
	{"mgybp", "瓏"},
	{"mgybr", "𤩅"},
	{"mgybs", "𤧭"},
	{"mgybu", "璿 𤪻"},
	{"mgyck", "珓"},
	{"mgydk", "㻻"},
	{"mgye", "㺳"},
	{"mgyed", "璨 𤨪"},
	{"mgyfe", "琡"},
	{"mgygq", "㼀"},
	{"mgyhj", "㻱"},
	{"mgyhs", "𤤁"},
	{"mgyib", "㻙"},
	{"mgyij", "㻭"},
	{"mgyiu", "珫 琉"},
	{"mgyj", "㺶"},
	{"mgyjj", "璉"},
	{"mgyk", "玟"},
	{"mgykg", "斑"},
	{"mgykh", "珳"},
	{"mgykq", "琏"},
	{"mgylb", "㺻"},
	{"mgylc", "𤥂"},
	{"mgylh", "㻉"},
	{"mgymp", "玼"},
	{"mgymr", "琂"},
	{"mgyog", "璡"},
	{"mgyoj", "琗"},
	{"mgyok", "𤥿"},
	{"mgypd", "㻯"},
	{"mgypo", "璩"},
	{"mgypt", "瓐"},
	{"mgypu", "琥"},
	{"mgyr", "玷"},
	{"mgyrf", "琼"},
	{"mgyrn", "𤧟"},
	{"mgyru", "𤦻"},
	{"mgyrv", "瓖"},
	{"mgysd", "㻢"},
	{"mgysm", "玙"},
	{"mgyso", "璇"},
	{"mgytj", "璋"},
	{"mgyto", "璲"},
	{"mgytr", "琣 𤦺"},
	{"mgytt", "琎"},
	{"mgytu", "璄"},
	{"mgyub", "璃"},
	{"mgyvi", "玹"},
	{"mgywm", "璮"},
	{"mgywv", "瓌"},
	{"mgyx", "璾"},
	{"mgyy", "玣"},
	{"mgyyb", "瓋"},
	{"mh", "厂"},
	{"mhae", "厡"},
	{"mhaf", "原 䲨"},
	{"mhav", "㸧"},
	{"mhdd", "厤"},
	{"mhdf", "㷴"},
	{"mhdn", "㽁"},
	{"mhgu", "𠀡"},
	{"mhhaf", "鴉"},
	{"mhhh", "㣉"},
	{"mhjm", "厜"},
	{"mhlv", "𥘅"},
	{"mhmbc", "䪵"},
	{"mhni", "巩"},
	{"mhnl", "邪"},
	{"mhog", "雅"},
	{"mhoiv", "餮"},
	{"mhp", "厇"},
	{"mhpm", "厎"},
	{"mhpym", "鸦"},
	{"mhs", "厏"},
	{"mhxf", "㕐"},
	{"mibbe", "靉"},
	{"mifb", "䨭"},
	{"mig", "至 㦱"},
	{"mihaf", "䲰 䴇"},
	{"mihi", "魂"},
	{"mihl", "𠩯"},
	{"mii", "㦺"},
	{"miia", "晉"},
	{"mijb", "㕊"},
	{"mik", "厌"},
	{"mikf", "黡"},
	{"miki", "魇"},
	{"mikl", "厣"},
	{"mikp", "厐"},
	{"miks", "动"},
	{"mikv", "餍"},
	{"mikw", "靥"},
	{"mile", "霴"},
	{"milnc", "靅"},
	{"mimgi", "𤤴"},
	{"mimii", "䨺"},
	{"mimm", "㱐"},
	{"minl", "鄏 䢵"},
	{"mioin", "霒"},
	{"miond", "霼"},
	{"mipt", "𤤙"},
	{"mipu", "霕"},
	{"mir", "䂖"},
	{"mitgi", "𤩺"},
	{"miuh", "厖"},
	{"miyle", "靆"},
	{"mj", "干"},
	{"mjbc", "厧"},
	{"mjbt", "㿻"},
	{"mjbuu", "䚓"},
	{"mjf", "烎 㶣"},
	{"mjhaf", "鳱 鷣"},
	{"mjixp", "麉"},
	{"mjln", "刊"},
	{"mjmbc", "頇"},
	{"mjmbo", "顸"},
	{"mjmjl", "郉"},
	{"mjmvn", "㼞"},
	{"mjn", "𢏗"},
	{"mjnl", "邗"},
	{"mjog", "䧲"},
	{"mjok", "敢"},
	{"mjr", "㕆"},
	{"mjwj", "厙"},
	{"mjybp", "䶬"},
	{"mk", "天"},
	{"mkab", "奣"},
	{"mkali", "蠺"},
	{"mkd", "檿"},
	{"mkdhe", "𥀬"},
	{"mke", "沗"},
	{"mkg", "壓 𡍶"},
	{"mkhi", "魘"},
	{"mkhqm", "甦"},
	{"mklii", "䗞 䘉"},
	{"mklmy", "䨿"},
	{"mkln", "㓴"},
	{"mklsm", "䪞"},
	{"mkmvn", "㼲"},
	{"mkmwl", "靨"},
	{"mknl", "郠"},
	{"mkoiv", "饜"},
	{"mkp", "憨 㤁"},
	{"mkq", "擪"},
	{"mks", "功"},
	{"mktct", "㬲"},
	{"mku", "无"},
	{"mkv", "嬮"},
	{"mkwgf", "黶 䵡"},
	{"mkwl", "厴"},
	{"mkylm", "㱘"},
	{"ml", "丌"},
	{"mlb", "帀"},
	{"mlbo", "兩"},
	{"mlbu", "両"},
	{"mlby", "雨 ⻗"},
	{"mllm", "亞"},
	{"mlls", "丣"},
	{"mllw", "覀"},
	{"mlm", "工"},
	{"mlmy", "厞"},
	{"mln", "㓚"},
	{"mlq", "㧭"},
	{"mlvs", "丏"},
	{"mlwk", "更"},
	{"mm", "二"},
	{"mmbb", "丽"},
	{"mmbbp", "麗"},
	{"mmbbv", "婯"},
	{"mmbc", "項"},
	{"mmbo", "项"},
	{"mmbuc", "䝾"},
	{"mmf", "示"},
	{"mmg", "堊"},
	{"mmhaf", "鵛 鵡 䲹"},
	{"mmi", "云"},
	{"mmig", "厔"},
	{"mmii", "䰟"},
	{"mmj", "厈"},
	{"mmks", "勁"},
	{"mml", "亓"},
	{"mmlmi", "蝁"},
	{"mmln", "剄"},
	{"mmm", "三"},
	{"mmmbc", "頸 䪹"},
	{"mmmgi", "琧"},
	{"mmmm", "亖 㠭"},
	{"mmmv", "辰"},
	{"mmn", "亍 厅 㐏"},
	{"mmnl", "邳 䣆"},
	{"mmno", "㰳"},
	{"mmok", "政"},
	{"mmp", "惡 𢘫"},
	{"mmps", "㫄"},
	{"mmpym", "鹉"},
	{"mmqmb", "靕"},
	{"mmr", "吾"},
	{"mmrn", "㐚"},
	{"mms", "厉"},
	{"mmt", "㕃"},
	{"mmti", "厨"},
	{"mmtj", "㕏"},
	{"mmu", "元"},
	{"mmue", "厦"},
	{"mmug", "坖"},
	{"mmuu", "黿"},
	{"mmvh", "厊"},
	{"mmvi", "㕄"},
	{"mmvn", "瓨"},
	{"mmvs", "巧"},
	{"mmyiu", "巰"},
	{"mmym", "㱏"},
	{"mmypu", "虣"},
	{"mn", "丁"},
	{"mnb", "㱚"},
	{"mnbm", "殂"},
	{"mnbnd", "殍"},
	{"mnbv", "㱣"},
	{"mnc", "銎"},
	{"mncsh", "瓰"},
	{"mncwj", "殚"},
	{"mndhe", "㱟"},
	{"mndhl", "㱤"},
	{"mndl", "殐"},
	{"mndwf", "㱫"},
	{"mnf", "烈"},
	{"mnfd", "䊄"},
	{"mng", "型"},
	{"mngbt", "殪"},
	{"mngce", "㱥"},
	{"mngth", "㱶"},
	{"mngwc", "殰"},
	{"mnhaf", "殦 鴷"},
	{"mnhbt", "殈"},
	{"mnhd", "䅃"},
	{"mnhe", "瓪"},
	{"mnhgu", "㱡"},
	{"mnhj", "瓩"},
	{"mnhjd", "殊"},
	{"mnhje", "㱭"},
	{"mnhk", "殀"},
	{"mnhml", "歽"},
	{"mnhne", "殁"},
	{"mnhpa", "殙"},
	{"mnhqm", "殅"},
	{"mnhqu", "瓱"},
	{"mnhui", "㱱"},
	{"mnhuk", "殠"},
	{"mni", "歹"},
	{"mniav", "㱢"},
	{"mnii", "殘"},
	{"mnij", "残"},
	{"mnije", "殏"},
	{"mnir", "殆"},
	{"mnj", "瓧"},
	{"mnjbm", "殖"},
	{"mnjim", "殱"},
	{"mnjmc", "殥 殯"},
	{"mnjmo", "㱨"},
	{"mnjnk", "㱩"},
	{"mnjnu", "㱧"},
	{"mnjoc", "殡"},
	{"mnjr", "㱠"},
	{"mnjru", "殑"},
	{"mnjtc", "㱵"},
	{"mnjwj", "䡗"},
	{"mnjyj", "㱰"},
	{"mnk", "𣧂"},
	{"mnklu", "殗"},
	{"mnkmr", "㱦"},
	{"mnkoo", "殎"},
	{"mnkpb", "殢"},
	{"mnks", "劽"},
	{"mnl", "邛"},
	{"mnlb", "㡂"},
	{"mnlbk", "殃"},
	{"mnle", "殔"},
	{"mnlmc", "殨"},
	{"mnlmi", "蛩"},
	{"mnlmo", "㱮"},
	{"mnln", "列"},
	{"mnlq", "肂"},
	{"mnma", "瓸"},
	{"mnmbc", "頂"},
	{"mnmbo", "顶"},
	{"mnmem", "殛"},
	{"mnmhm", "㱹"},
	{"mnmni", "㱛"},
	{"mnmr", "䂬"},
	{"mnmvm", "殌"},
	{"mnmvn", "㼗 㼦"},
	{"mnmvs", "㱙"},
	{"mnmwg", "甅"},
	{"mnmwm", "殭"},
	{"mnn", "㐉"},
	{"mnne", "歿"},
	{"mnnl", "邒"},
	{"mnnwf", "鮤"},
	{"mnoah", "殤"},
	{"mnogd", "㱷"},
	{"mnohh", "殄"},
	{"mnoim", "殲"},
	{"mnoiv", "飱"},
	{"mnomm", "殓"},
	{"mnomo", "殮"},
	{"mnonh", "殇"},
	{"mnp", "恐 死 㤠 𢢭"},
	{"mnpa", "殉"},
	{"mnpg", "㘸"},
	{"mnphh", "歾"},
	{"mnptd", "殜"},
	{"mnpu", "瓲"},
	{"mnpym", "䴕"},
	{"mnq", "㧬"},
	{"mnqkd", "殝"},
	{"mnqmc", "㱴"},
	{"mnqo", "巬 㠫"},
	{"mnr", "可"},
	{"mnrbc", "殞"},
	{"mnrbo", "殒"},
	{"mnrn", "㐓"},
	{"mnrpa", "㱪"},
	{"mnrrj", "殫"},
	{"mnryo", "跫"},
	{"mnsj", "聓"},
	{"mnsrj", "㱸"},
	{"mntct", "㱲"},
	{"mntlj", "鞏"},
	{"mntlm", "殣"},
	{"mnumt", "㱯"},
	{"mnup", "㤪"},
	{"mnv", "姴"},
	{"mnw", "㽝"},
	{"mnwg", "瓼"},
	{"mnwlj", "殬"},
	{"mnwmv", "㱬"},
	{"mnwot", "殟"},
	{"mnyed", "殩"},
	{"mnyfu", "殧"},
	{"mnyhv", "裂"},
	{"mnymu", "䶛"},
	{"mnynq", "㱻"},
	{"mnyo", "㱜"},
	{"mnypt", "㱺"},
	{"mnyt", "㱞"},
	{"mnytr", "殕"},
	{"mo", "仄"},
	{"moau", "豝"},
	{"moav", "豤"},
	{"mob", "丙"},
	{"mobhu", "觋"},
	{"mobjj", "䝍"},
	{"mobm", "豠"},
	{"mobt", "䀃"},
	{"mobuu", "覡 䚖"},
	{"mobvk", "豯"},
	{"moeee", "䝌"},
	{"mof", "燹"},
	{"mog", "㕍 䝅"},
	{"mogbt", "豷"},
	{"mogc", "贋"},
	{"mogf", "㷳"},
	{"mogo", "赝"},
	{"mohaf", "鵐 鷢 䴒"},
	{"mohf", "鴈"},
	{"mohmu", "䝈"},
	{"mohne", "豛"},
	{"mohoo", "豵"},
	{"mohqm", "甤"},
	{"mohsn", "豟"},
	{"mohui", "䰱"},
	{"moijb", "豧"},
	{"moin", "㕂"},
	{"mojka", "豬"},
	{"mojlo", "䝊"},
	{"mojmf", "䝋"},
	{"mojtc", "豶"},
	{"mojto", "豮"},
	{"moju", "厒"},
	{"mok", "攻"},
	{"mokkb", "豨"},
	{"molii", "蟸"},
	{"mollv", "䝏"},
	{"molmi", "蟨"},
	{"moln", "劂"},
	{"molwv", "䝏"},
	{"momgi", "㻹"},
	{"momhf", "豲"},
	{"momo", "厱"},
	{"momr", "㕉"},
	{"momso", "豩"},
	{"momt", "豜"},
	{"monlb", "䝐"},
	{"moo", "巫"},
	{"moob", "两"},
	{"moog", "雁"},
	{"mook", "𢽴"},
	{"moomn", "𧱬"},
	{"mopr", "豞"},
	{"mopu", "豘"},
	{"mopym", "鹀"},
	{"morye", "豭"},
	{"moryo", "蹷"},
	{"moseo", "䝒"},
	{"mosjj", "䝕"},
	{"motrg", "䝔"},
	{"moumb", "䝎"},
	{"movvv", "䝓"},
	{"mow", "㐁"},
	{"mowot", "豱"},
	{"moycb", "豴"},
	{"moyjj", "豣"},
	{"moytg", "䝑"},
	{"moyvo", "豥"},
	{"mpbuc", "貮"},
	{"mpbuu", "䚕"},
	{"mphaf", "鸝"},
	{"mphhh", "彲"},
	{"mpks", "㱝"},
	{"mpmm", "弐"},
	{"mpnl", "酈"},
	{"mpno", "㰷"},
	{"mpylm", "武"},
	{"mr", "石"},
	{"mrahm", "䃏"},
	{"mramh", "碭"},
	{"mrami", "碍"},
	{"mramo", "碮"},
	{"mrana", "磵"},
	{"mranb", "礀"},
	{"mranw", "䃹"},
	{"mrapp", "䃂"},
	{"mrapv", "碣"},
	{"mrav", "硍"},
	{"mravf", "礘"},
	{"mrbb", "硼"},
	{"mrbbb", "磆"},
	{"mrbbm", "𥑬"},
	{"mrbbr", "碢"},
	{"mrbf", "䂹"},
	{"mrbgr", "碉"},
	{"mrbhu", "砚"},
	{"mrbhx", "𥔿"},
	{"mrbj", "鞷"},
	{"mrbl", "鬲"},
	{"mrbm", "砠"},
	{"mrbmr", "硐"},
	{"mrbof", "磜"},
	{"mrbou", "磘"},
	{"mrbq", "砽"},
	{"mrbsd", "碀"},
	{"mrbtu", "碙"},
	{"mrbtv", "䃃"},
	{"mrbuc", "𧵔"},
	{"mrbuu", "硯"},
	{"mrbvk", "磎"},
	{"mrby", "砃"},
	{"mrc", "碒 𥐙"},
	{"mrcno", "䃢"},
	{"mrcor", "硲"},
	{"mrcru", "䂱"},
	{"mrcsh", "砏"},
	{"mrcwa", "磳"},
	{"mrcwj", "䃅"},
	{"mrd", "䂞"},
	{"mrdam", "碴"},
	{"mrdci", "硹"},
	{"mrdd", "碄"},
	{"mrddo", "礎"},
	{"mrdhe", "破"},
	{"mrdj", "砞"},
	{"mrdk", "砄"},
	{"mrdm", "砵"},
	{"mrdoo", "䂾"},
	{"mre", "泵 砅"},
	{"mrea", "䂿"},
	{"mreed", "磉"},
	{"mrei", "䂘"},
	{"mresd", "磲"},
	{"mrfb", "硝"},
	{"mrfbq", "礃"},
	{"mrfbw", "礑"},
	{"mrfdq", "磷"},
	{"mrfdr", "𥕝"},
	{"mrfff", "礯"},
	{"mrffs", "磱"},
	{"mrfh", "砂"},
	{"mrfmu", "硄"},
	{"mrgce", "碐"},
	{"mrgg", "硅"},
	{"mrggu", "磽"},
	{"mrgi", "砝"},
	{"mrgis", "䂶"},
	{"mrgit", "磕"},
	{"mrglc", "硳"},
	{"mrgr", "硈"},
	{"mrgrr", "礂"},
	{"mrgsk", "磝"},
	{"mrha", "砶"},
	{"mrhab", "䃇"},
	{"mrhaf", "䲽"},
	{"mrhbk", "礇"},
	{"mrhdn", "䂰"},
	{"mrhdw", "磻"},
	{"mrheq", "䂫"},
	{"mrher", "硌"},
	{"mrhet", "䃲"},
	{"mrhey", "䂢"},
	{"mrhgr", "硞"},
	{"mrhhj", "碑"},
	{"mrhhw", "磂"},
	{"mrhi", "磈"},
	{"mrhio", "砭"},
	{"mrhjd", "硃"},
	{"mrhje", "碫"},
	{"mrhjm", "硾"},
	{"mrhjp", "䂷"},
	{"mrhju", "碷"},
	{"mrhkb", "礄"},
	{"mrhkl", "硚"},
	{"mrhl", "厛"},
	{"mrhlc", "礩"},
	{"mrhml", "斫 㪼"},
	{"mrhmy", "䂨"},
	{"mrhn", "矶 𥐥"},
	{"mrhne", "砓"},
	{"mrhni", "矾 碸"},
	{"mrhnk", "砜"},
	{"mrhoo", "磫"},
	{"mrhp", "矺"},
	{"mrhpa", "碈"},
	{"mrhpm", "砥"},
	{"mrhq", "㸴"},
	{"mrhqi", "硪"},
	{"mrhrf", "䃖"},
	{"mrhs", "砟"},
	{"mrhsb", "碥"},
	{"mrhse", "磤"},
	{"mrhsk", "礉"},
	{"mrhsn", "砨"},
	{"mrhuc", "礸"},
	{"mrhvd", "砾"},
	{"mrhwk", "硇"},
	{"mrhwp", "磇"},
	{"mrhxc", "礖"},
	{"mrhxf", "磶"},
	{"mrhye", "䃑"},
	{"mrhyu", "磃"},
	{"mri", "矿 䂝"},
	{"mriav", "硠"},
	{"mribi", "磗"},
	{"mridr", "礳"},
	{"mridy", "䃺"},
	{"mrie", "砯"},
	{"mrig", "䂯"},
	{"mrihf", "磩"},
	{"mrihr", "碱"},
	{"mrii", "碊"},
	{"mriih", "磣"},
	{"mrikf", "䃣"},
	{"mrikh", "碜"},
	{"mrilr", "磄"},
	{"mriod", "䃯"},
	{"mrip", "㢦"},
	{"mrirm", "䂸"},
	{"mrirp", "䃭"},
	{"mrism", "𥔱"},
	{"mritc", "礦"},
	{"mriuh", "硥"},
	{"mrixp", "䃙"},
	{"mrjbc", "磌"},
	{"mrjbf", "䃰"},
	{"mrjck", "䃐"},
	{"mrjcm", "硿"},
	{"mrjdk", "䃝"},
	{"mrjhr", "碦"},
	{"mrjii", "磚"},
	{"mrjim", "䃱"},
	{"mrjkd", "硣"},
	{"mrjki", "硡"},
	{"mrjkp", "硓"},
	{"mrjlv", "䃀"},
	{"mrjmc", "礗"},
	{"mrjmf", "碂"},
	{"mrjmm", "碹"},
	{"mrjmo", "碇"},
	{"mrjnu", "碗"},
	{"mrjp", "砣"},
	{"mrjpu", "硗"},
	{"mrjqr", "磍"},
	{"mrjr", "𥑮"},
	{"mrjrr", "䃔"},
	{"mrjwj", "硨"},
	{"mrkk", "䂚"},
	{"mrkkk", "磢"},
	{"mrklu", "硽"},
	{"mrkmr", "碕"},
	{"mrknj", "砕"},
	{"mrknn", "䃎"},
	{"mrkoo", "硤"},
	{"mrkq", "砗"},
	{"mrks", "劯"},
	{"mrksr", "𥑆"},
	{"mrkt", "硖"},
	{"mrlln", "砩"},
	{"mrlmo", "䂪"},
	{"mrln", "矵 㔏"},
	{"mrlq", "硉"},
	{"mrlwl", "砷"},
	{"mrlx", "䃤"},
	{"mrm", "矼"},
	{"mrmbb", "礝 䃻"},
	{"mrmbc", "碩 䫊 䫷"},
	{"mrmbg", "礭"},
	{"mrmbk", "碝"},
	{"mrmbo", "硕 䂵"},
	{"mrmbs", "𥗠"},
	{"mrmbu", "礵"},
	{"mrmbw", "礌"},
	{"mrmcw", "硒"},
	{"mrmfj", "砰"},
	{"mrmgi", "砡"},
	{"mrmgt", "硦"},
	{"mrmhm", "礰"},
	{"mrmj", "矸"},
	{"mrmjj", "硏"},
	{"mrmlk", "硬"},
	{"mrmlm", "䃁"},
	{"mrmmi", "𥐯"},
	{"mrmms", "砺"},
	{"mrmn", "矴"},
	{"mrmnr", "砢"},
	{"mrmpm", "碔"},
	{"mrmr", "砳"},
	{"mrmrb", "䃒"},
	{"mrmrr", "磊"},
	{"mrmso", "硺"},
	{"mrmsu", "砈"},
	{"mrmt", "研"},
	{"mrmtb", "礪"},
	{"mrmtn", "硎"},
	{"mrmu", "矹"},
	{"mrmua", "䃡"},
	{"mrmvb", "磭"},
	{"mrmvh", "砑"},
	{"mrmvm", "硜"},
	{"mrmvn", "砙"},
	{"mrmwf", "磦"},
	{"mrmwg", "䃌"},
	{"mrmwj", "磹"},
	{"mrmwm", "礓"},
	{"mrn", "乭"},
	{"mrnbg", "确"},
	{"mrncr", "䃫"},
	{"mrnd", "矷"},
	{"mrnf", "䂧"},
	{"mrnhe", "砐"},
	{"mrni", "矽"},
	{"mrnib", "硧"},
	{"mrnin", "䂛"},
	{"mrnkv", "硟"},
	{"mrnl", "郚 酃 䂙"},
	{"mrnmu", "硊"},
	{"mrno", "歌 砍 㰤"},
	{"mrnom", "硁"},
	{"mrnot", "磴"},
	{"mrnqd", "磔"},
	{"mrnr", "哥"},
	{"mrnri", "䃨"},
	{"mrnsh", "砀"},
	{"mrnvm", "码"},
	{"mrobg", "確"},
	{"mrodi", "䂤"},
	{"mrog", "碓"},
	{"mrogd", "磼"},
	{"mrogf", "礁"},
	{"mrohh", "䂦"},
	{"mroii", "砱"},
	{"mroim", "䃸"},
	{"mroin", "砛"},
	{"mroip", "䂼"},
	{"mrok", "敔 䂠"},
	{"mroll", "砎"},
	{"mrom", "砼 䂡"},
	{"mromb", "碖"},
	{"mromd", "硢"},
	{"mromg", "硂"},
	{"mromm", "硷"},
	{"mromn", "䃋"},
	{"mromo", "礆"},
	{"mromr", "硆"},
	{"mron", "矻"},
	{"mroog", "䂳"},
	{"mropd", "砤"},
	{"mrp", "厑 䂗"},
	{"mrpko", "礙"},
	{"mrpp", "砒"},
	{"mrppa", "䃈"},
	{"mrpru", "砲"},
	{"mrpsh", "砌"},
	{"mrptd", "碟"},
	{"mrpu", "砘"},
	{"mrpuk", "𥒚"},
	{"mrqhk", "碶"},
	{"mrqj", "䂜"},
	{"mrqmb", "碃"},
	{"mrqmc", "磧"},
	{"mrqmo", "碛"},
	{"mrqmy", "碡"},
	{"mrqni", "砖"},
	{"mrqo", "砆 㠬"},
	{"mrrbc", "磒"},
	{"mrrpa", "䃉"},
	{"mrrrj", "磾"},
	{"mrrrk", "礹"},
	{"mrrvp", "䂥"},
	{"mrrye", "碬"},
	{"mrryo", "𨀂"},
	{"mrsec", "礥"},
	{"mrseg", "䃘"},
	{"mrsfb", "碿"},
	{"mrsfk", "礮"},
	{"mrsit", "礛"},
	{"mrsk", "𥐰"},
	{"mrslb", "砸"},
	{"mrsma", "磖"},
	{"mrsmh", "磟"},
	{"mrsmv", "䂻"},
	{"mrsqf", "碼"},
	{"mrsrj", "礔"},
	{"mrsrr", "𥕥"},
	{"mrstv", "碾"},
	{"mrt", "豆"},
	{"mrta", "碏"},
	{"mrtav", "礍"},
	{"mrtbc", "碘"},
	{"mrtbf", "礤"},
	{"mrtbk", "䃟"},
	{"mrtbm", "䃊"},
	{"mrtbo", "礞"},
	{"mrtc", "硔"},
	{"mrtcd", "礏"},
	{"mrtcg", "𥕛"},
	{"mrtei", "礴"},
	{"mrtgi", "礒"},
	{"mrtgo", "𥖄"},
	{"mrtgr", "磰"},
	{"mrtgt", "礚"},
	{"mrtii", "礡"},
	{"mrtju", "𥕜"},
	{"mrtk", "砹"},
	{"mrtlf", "𥗕"},
	{"mrtlk", "碤"},
	{"mrtmc", "磺 䃆"},
	{"mrtmv", "碪"},
	{"mrtn", "㐙"},
	{"mrtop", "硴"},
	{"mrtov", "礢"},
	{"mrtpo", "䃍"},
	{"mrtqm", "磋"},
	{"mrtrg", "礶"},
	{"mrtst", "礷"},
	{"mrtt", "硑"},
	{"mrttb", "䃓"},
	{"mrttc", "碰"},
	{"mrtv", "䜳"},
	{"mrtvi", "磁 𥔵"},
	{"mrtvp", "礠"},
	{"mrtvs", "磡"},
	{"mrtwa", "𥕢"},
	{"mrtwi", "礣 𥖁"},
	{"mrtwk", "磸"},
	{"mrtwv", "䃩"},
	{"mrtxc", "磏"},
	{"mrtyv", "硭"},
	{"mrubb", "磞"},
	{"mruhi", "䃬"},
	{"mrumf", "碳"},
	{"mrumj", "硸"},
	{"mrumr", "碋"},
	{"mrumt", "磑"},
	{"mruob", "磮"},
	{"mruog", "磪"},
	{"mruon", "硶"},
	{"mrusu", "硙"},
	{"mruu", "础"},
	{"mrven", "䃗"},
	{"mrvid", "礫"},
	{"mrvii", "磯"},
	{"mrvne", "碌"},
	{"mrvvv", "䃳"},
	{"mrvvw", "碯"},
	{"mrw", "畐"},
	{"mrwd", "硱 䂺"},
	{"mrwhd", "碅"},
	{"mrwk", "䂩"},
	{"mrwlj", "礋"},
	{"mrwmv", "碨"},
	{"mrwr", "硘"},
	{"mrwvf", "磥"},
	{"mrwww", "礧"},
	{"mrwyc", "𥖏"},
	{"mrwyi", "砪"},
	{"mryaj", "䂽"},
	{"mrybb", "碲"},
	{"mrybc", "碵"},
	{"mrybp", "礲"},
	{"mrybs", "磅"},
	{"mryck", "䂭"},
	{"mrycv", "磙 𥕦"},
	{"mrydk", "礅"},
	{"mrye", "㪃 㪮"},
	{"mryg", "砫"},
	{"mrygq", "䃮"},
	{"mryhn", "砊"},
	{"mryhr", "磓"},
	{"mryiu", "硫"},
	{"mryjj", "䃛"},
	{"mryk", "砇"},
	{"mrylc", "硛"},
	{"mrylm", "砋"},
	{"mrymp", "䂣"},
	{"mrymr", "䂴"},
	{"mrynv", "䃷"},
	{"mryoj", "碎"},
	{"mryr", "砧"},
	{"mryra", "䃴"},
	{"mryrb", "碻"},
	{"mryrf", "䃄"},
	{"mryrn", "碠"},
	{"mrysk", "䃚"},
	{"mryso", "䃠"},
	{"mrysv", "䃵"},
	{"mryt", "砬"},
	{"mrytg", "䃥"},
	{"mrytj", "𥕞"},
	{"mryto", "礈"},
	{"mrytr", "碚"},
	{"mrytu", "磀"},
	{"mryvo", "硋"},
	{"mrywi", "磠"},
	{"mrywk", "硵"},
	{"mrywm", "䃪"},
	{"mrywv", "䃶"},
	{"ms", "万"},
	{"msgp", "㕔"},
	{"msh", "㓛"},
	{"mshaf", "䲾"},
	{"mshjg", "𩅞"},
	{"msho", "豕"},
	{"msko", "豖"},
	{"msks", "励"},
	{"msl", "卭"},
	{"mslmi", "虿"},
	{"msnl", "鄠"},
	{"msok", "攷"},
	{"msp", "㤍"},
	{"msqo", "巭"},
	{"msryo", "趸"},
	{"msu", "厄"},
	{"msv", "㚽 𠩐"},
	{"msymr", "䛒"},
	{"mt", "幵 开"},
	{"mta", "厝 晉"},
	{"mtamo", "䜻"},
	{"mtavf", "䝃"},
	{"mtbt", "㿼"},
	{"mtbuu", "䙹"},
	{"mtc", "亚"},
	{"mtch", "严"},
	{"mtcl", "厮"},
	{"mtcp", "䴡"},
	{"mtdhe", "䜵"},
	{"mtdl", "䜹"},
	{"mtfd", "䊙"},
	{"mtgi", "㕒"},
	{"mthaf", "鳽"},
	{"mtheq", "䜶"},
	{"mthhh", "形"},
	{"mthhj", "豍"},
	{"mthhw", "䝀"},
	{"mthqu", "毭"},
	{"mtje", "豉"},
	{"mtjnu", "豌"},
	{"mtlm", "厪"},
	{"mtln", "刑"},
	{"mtm", "豇"},
	{"mtmbc", "頭"},
	{"mtmvn", "㼛"},
	{"mtnl", "邢 郖"},
	{"mtno", "㰢 㰯"},
	{"mtog", "雃"},
	{"mtoge", "䝄"},
	{"mtomn", "䜽"},
	{"mtq", "揅"},
	{"mtshu", "䜸"},
	{"mtsme", "䜷"},
	{"mtsmm", "䍾"},
	{"mtta", "䜺"},
	{"mttmc", "𧯯"},
	{"mttxc", "豏"},
	{"mtuo", "厥"},
	{"mtwb", "厲"},
	{"mtwgf", "䵤"},
	{"mtye", "䜴"},
	{"mtyj", "㪷"},
	{"mtyta", "䜾"},
	{"mu", "兀 兀"},
	{"mua", "朁"},
	{"muali", "蠶"},
	{"mub", "襾"},
	{"mudi", "㝴"},
	{"muf", "炁"},
	{"muhaf", "鸘 䲫 䲮 䲶"},
	{"muhe", "夏"},
	{"mui", "戛"},
	{"muir", "兘"},
	{"mukll", "奡"},
	{"mulmi", "虺"},
	{"muln", "刓 㓰"},
	{"mumbc", "頑 䪲"},
	{"mumbo", "顾"},
	{"mumg", "尫 㒬"},
	{"mumrb", "鬵"},
	{"mumso", "豗 㒮"},
	{"mumvu", "兓"},
	{"munl", "邧"},
	{"munmu", "卼"},
	{"mup", "㤅"},
	{"mupym", "鹴"},
	{"musmm", "𦒘"},
	{"musmt", "尶"},
	{"muw", "画"},
	{"muyj", "㪴"},
	{"mv", "匚 匸"},
	{"mva", "㫳"},
	{"mvb", "脣"},
	{"mvdh", "牙"},
	{"mvdi", "辱"},
	{"mvdo", "㸦"},
	{"mvhaf", "䳩"},
	{"mvhne", "㲀"},
	{"mvku", "旡"},
	{"mvl", "㔿"},
	{"mvlmi", "蜃"},
	{"mvmbc", "䫃"},
	{"mvni", "瓦"},
	{"mvnl", "䣅"},
	{"mvnm", "互"},
	{"mvno", "㰮"},
	{"mvok", "敐"},
	{"mvoma", "䢈"},
	{"mvphh", "覅"},
	{"mvr", "唇"},
	{"mvs", "丂"},
	{"mvvg", "坙"},
	{"mvvm", "巠"},
	{"mwabt", "醖"},
	{"mwahm", "醒"},
	{"mwaj", "覃"},
	{"mwamo", "醍"},
	{"mwapp", "醌"},
	{"mwate", "䤖"},
	{"mwbdi", "酹"},
	{"mwbhu", "䩄"},
	{"mwbm", "䣯"},
	{"mwbmr", "酮"},
	{"mwbnd", "酻"},
	{"mwbo", "贾"},
	{"mwbuc", "賈"},
	{"mwbuu", "靦"},
	{"mwbwi", "釂"},
	{"mwcmt", "䤈"},
	{"mwcsh", "酚"},
	{"mwd", "栗"},
	{"mwdd", "醂"},
	{"mwdhe", "䩅"},
	{"mwdi", "酎"},
	{"mweee", "醊"},
	{"mwf", "䙳"},
	{"mwfd", "粟"},
	{"mwff", "醈"},
	{"mwg", "厘 垔"},
	{"mwgg", "㕓 䙵"},
	{"mwgit", "醘"},
	{"mwgni", "醻"},
	{"mwhaf", "鶝"},
	{"mwhbv", "䙶"},
	{"mwhd", "酥 䅇"},
	{"mwher", "酪"},
	{"mwhgf", "醺"},
	{"mwhgr", "酷"},
	{"mwhgu", "酰"},
	{"mwhi", "醜"},
	{"mwhio", "覂"},
	{"mwhjd", "䣷"},
	{"mwhjr", "䣶"},
	{"mwhne", "酘"},
	{"mwhoe", "覆"},
	{"mwhqu", "酕"},
	{"mwhs", "酢"},
	{"mwhsk", "覈"},
	{"mwhxe", "醙"},
	{"mwi", "䣬"},
	{"mwiav", "酿"},
	{"mwice", "酸"},
	{"mwidd", "醾 䩋"},
	{"mwidf", "醿"},
	{"mwidy", "釄"},
	{"mwihr", "醎"},
	{"mwii", "醆"},
	{"mwiih", "醦"},
	{"mwijb", "酺 䩉"},
	{"mwik", "䣭"},
	{"mwikk", "䣮"},
	{"mwiku", "𨠄"},
	{"mwill", "酬"},
	{"mwilr", "醣"},
	{"mwilw", "疈"},
	{"mwip", "䣧"},
	{"mwit", "䣲"},
	{"mwive", "酦"},
	{"mwjb", "䣪"},
	{"mwjbm", "䣾"},
	{"mwjcs", "醡"},
	{"mwjdi", "酧"},
	{"mwje", "䣫"},
	{"mwjfe", "䤇"},
	{"mwjka", "醏"},
	{"mwjkd", "酵"},
	{"mwjnu", "䩊"},
	{"mwjp", "酡"},
	{"mwjr", "酤"},
	{"mwjrb", "醐"},
	{"mwk", "䙲"},
	{"mwkb", "酭"},
	{"mwkcf", "䩍"},
	{"mwki", "酞"},
	{"mwklu", "醃"},
	{"mwknj", "酔"},
	{"mwkrt", "醢"},
	{"mwks", "勔 䣦 𠡳"},
	{"mwksu", "䙴"},
	{"mwl", "㕅"},
	{"mwlbu", "酖"},
	{"mwlii", "蠠"},
	{"mwlkt", "醠"},
	{"mwlmc", "靧"},
	{"mwln", "副"},
	{"mwlut", "醓"},
	{"mwlyq", "䤏"},
	{"mwmbb", "醹"},
	{"mwmbr", "醽"},
	{"mwmd", "酑"},
	{"mwmdt", "䣿"},
	{"mwmf", "㶾"},
	{"mwmj", "酐"},
	{"mwmm", "畺"},
	{"mwmmf", "票"},
	{"mwmmi", "酝"},
	{"mwmmp", "釃"},
	{"mwmmu", "酛"},
	{"mwmn", "酊"},
	{"mwmnr", "酠"},
	{"mwmrw", "㽬"},
	{"mwmth", "酽"},
	{"mwmua", "䤐"},
	{"mwmvn", "㽌"},
	{"mwmwf", "醥"},
	{"mwmwj", "醰"},
	{"mwmwl", "䤄"},
	{"mwmww", "靐 䨻"},
	{"mwnhb", "䤎"},
	{"mwnir", "酩"},
	{"mwnob", "醑"},
	{"mwnoe", "醱"},
	{"mwnok", "䤆"},
	{"mwnop", "醗"},
	{"mwog", "醀"},
	{"mwogf", "醮 䩌"},
	{"mwoi", "䣹"},
	{"mwoik", "覄"},
	{"mwoim", "䤘"},
	{"mwoin", "䩂"},
	{"mwoir", "䣻 䤌"},
	{"mwomd", "酴"},
	{"mwomg", "酫"},
	{"mwomn", "䤅"},
	{"mwomo", "醶 䩎"},
	{"mwos", "䩆"},
	{"mwowy", "酶 䩈"},
	{"mwp", "䣥"},
	{"mwpa", "酯"},
	{"mwpd", "酏"},
	{"mwpht", "䤉"},
	{"mwpi", "酌"},
	{"mwpou", "醄"},
	{"mwpp", "䩃"},
	{"mwpr", "䣱"},
	{"mwpru", "靤"},
	{"mwpu", "䣩"},
	{"mwqo", "酜"},
	{"mwqu", "䣨"},
	{"mwr", "靣"},
	{"mwrb", "䣺"},
	{"mwrhg", "酲"},
	{"mwrrk", "釅"},
	{"mwsj", "䣵"},
	{"mwsmh", "醪"},
	{"mwsmr", "䣳"},
	{"mwsrr", "醧"},
	{"mwss", "䣰"},
	{"mwsu", "配"},
	{"mwta", "醋"},
	{"mwtbo", "䤓"},
	{"mwtco", "醭"},
	{"mwtjb", "覇"},
	{"mwtjf", "覊"},
	{"mwtjr", "覉"},
	{"mwtkr", "䤀"},
	{"mwtlb", "䤍"},
	{"mwtlf", "醼"},
	{"mwtm", "酣"},
	{"mwtmc", "䤑"},
	{"mwtmd", "䤂"},
	{"mwtmv", "䤁"},
	{"mwtog", "醛"},
	{"mwtqm", "醝"},
	{"mwtsj", "䤊"},
	{"mwtwa", "醩"},
	{"mwtwi", "䩏"},
	{"mwtwt", "醴"},
	{"mwtwv", "醲"},
	{"mwuk", "酗"},
	{"mwuku", "䣴"},
	{"mwv", "要"},
	{"mwvib", "酳"},
	{"mwvid", "䤕"},
	{"mwvii", "䤒"},
	{"mwvne", "醁"},
	{"mwvoi", "䤙"},
	{"mwwlj", "醳"},
	{"mwwot", "醞"},
	{"mwycv", "醸"},
	{"mwyfd", "醚"},
	{"mwyiu", "酼"},
	{"mwyj", "酙"},
	{"mwyl", "面"},
	{"mwyoj", "醉"},
	{"mwypo", "醵"},
	{"mwyr", "酟 䩇"},
	{"mwyra", "醕"},
	{"mwyrd", "醇"},
	{"mwyrf", "䣼"},
	{"mwyrv", "釀"},
	{"mwyta", "䤃"},
	{"mwytp", "醷"},
	{"mwytr", "醅"},
	{"mwyub", "醨"},
	{"mwyut", "醯"},
	{"mxye", "敮"},
	{"my", "下"},
	{"mybp", "龎"},
	{"myhn", "颪"},
	{"myhv", "㕈"},
	{"mylf", "焉"},
	{"mylm", "正"},
	{"mym", "㠪"},
	{"mymu", "兏 㒫"},
	{"myn", "乤"},
	{"myo", "𤴓"},
	{"myp", "忑"},
	{"mypt", "𠫂"},
	{"myt", "㕇"},
	{"mytj", "厗"},
	{"myvs", "丐"},
	{"myye", "㪪"},
	{"n", "弓"},
	{"na", "𣄽"},
	{"nahu", "免"},
	{"napo", "象"},
	{"nau", "弝 色"},
	{"nbam", "觛"},
	{"nbami", "䚟"},
	{"nbamo", "䚣"},
	{"nbapp", "䚠"},
	{"nbb", "弸"},
	{"nbbue", "夐 敻 𢿌"},
	{"nbc", "䥸"},
	{"nbci", "䚗"},
	{"nbcwj", "觯"},
	{"nbd", "㯐"},
	{"nbdk", "觖"},
	{"nbdl", "觫"},
	{"nbdoo", "䚞"},
	{"nbf", "烉"},
	{"nbfdq", "䚬"},
	{"nbfh", "觘"},
	{"nbfmu", "觥"},
	{"nbg", "墮 角"},
	{"nbgg", "觟"},
	{"nbhaf", "鷸"},
	{"nbher", "觡"},
	{"nbhgu", "䚚"},
	{"nbhkb", "䚩"},
	{"nbhpm", "觝"},
	{"nbhq", "𧣈"},
	{"nbhqr", "䚛"},
	{"nbhqu", "氄"},
	{"nbhvo", "觚"},
	{"nbhvp", "觗"},
	{"nbhwj", "䚜"},
	{"nbhxu", "觬"},
	{"nbhyu", "䚦"},
	{"nbi", "㦷"},
	{"nbije", "觩"},
	{"nbjka", "觰"},
	{"nbk", "奐"},
	{"nbkmr", "觭"},
	{"nbks", "勇 觔"},
	{"nblmi", "触"},
	{"nbln", "劀 㓩"},
	{"nbmam", "䚙"},
	{"nbme", "觨"},
	{"nbmgi", "瓕"},
	{"nbmvn", "㼧"},
	{"nbnbe", "觼"},
	{"nbnhe", "觙"},
	{"nbnme", "觮"},
	{"nbnmm", "䚥"},
	{"nbnmu", "觤"},
	{"nbnoe", "䚨"},
	{"nbo", "负"},
	{"nboah", "觴"},
	{"nbogs", "觹 𧤤"},
	{"nbonh", "觞"},
	{"nboo", "𧢲"},
	{"nbop", "隳"},
	{"nbp", "恿"},
	{"nbptd", "䚢"},
	{"nbpym", "鹬"},
	{"nbq", "⻆"},
	{"nbrrj", "觶"},
	{"nbshq", "解"},
	{"nbsmh", "䚧"},
	{"nbtgq", "觲"},
	{"nbtlc", "觵"},
	{"nbtlf", "觾"},
	{"nbtq", "觧"},
	{"nbtrg", "䚭"},
	{"nbu", "嶞"},
	{"nbuc", "負"},
	{"nbue", "彏"},
	{"nbuob", "觿"},
	{"nbuos", "觽"},
	{"nbv", "㜷"},
	{"nbvid", "觻"},
	{"nbvl", "觓"},
	{"nbwlb", "䚤"},
	{"nbwli", "觸"},
	{"nbwlv", "䚪"},
	{"nbwp", "䚡"},
	{"nbye", "㪌"},
	{"nbyj", "斛"},
	{"nbymr", "䜐"},
	{"nbyoj", "䚝"},
	{"nbytj", "觪"},
	{"nc", "小"},
	{"ncwj", "弹"},
	{"ncymr", "詹"},
	{"nd", "子"},
	{"ndbcv", "孾"},
	{"ndbt", "孟"},
	{"ndbuc", "孭"},
	{"ndf", "孙"},
	{"ndgrr", "㝆"},
	{"ndhaf", "鶔"},
	{"ndhe", "㢰"},
	{"ndhvf", "孫"},
	{"ndhvo", "孤"},
	{"ndir", "孡"},
	{"ndjmf", "孮"},
	{"ndlmt", "孻"},
	{"ndln", "刴"},
	{"ndmbb", "孺"},
	{"ndmlm", "孲"},
	{"ndnau", "㝃"},
	{"ndnbc", "𡥼"},
	{"ndnd", "孖"},
	{"ndnda", "孴"},
	{"ndndd", "孨"},
	{"ndnin", "㜿"},
	{"ndok", "孜"},
	{"ndoll", "㜾"},
	{"ndp", "孞"},
	{"ndpru", "孢"},
	{"ndqhl", "㝂"},
	{"ndr", "𡥄"},
	{"ndtlb", "𡦖"},
	{"ndu", "孔"},
	{"ndwyi", "𣫮"},
	{"ndymr", "𡥪"},
	{"ndyvo", "孩"},
	{"ne", "氶 氹"},
	{"nef", "焏"},
	{"neg", "𡍵"},
	{"nehaf", "䲯"},
	{"neln", "剥 㔇"},
	{"nem", "丞"},
	{"nemb", "脀"},
	{"nemf", "烝"},
	{"nemsu", "卺 巹"},
	{"nesd", "㣄"},
	{"neu", "㞼"},
	{"nf", "尔"},
	{"nfaa", "鯧"},
	{"nfabt", "鰛"},
	{"nfagi", "鰣"},
	{"nfahm", "鯹"},
	{"nfail", "鯽"},
	{"nfaja", "鱪"},
	{"nfam", "䱇"},
	{"nfamh", "鰑"},
	{"nfamo", "鯷"},
	{"nfaph", "鯣"},
	{"nfapp", "鯤"},
	{"nfasm", "鰨"},
	{"nfau", "䰾"},
	{"nfawe", "鰻"},
	{"nfb", "弰"},
	{"nfbbb", "䱻"},
	{"nfbbe", "鱫"},
	{"nfbcj", "鱡"},
	{"nfbcn", "鰂"},
	{"nfbf", "㢼"},
	{"nfbgr", "鯛"},
	{"nfbjj", "鯶"},
	{"nfbm", "䱉"},
	{"nfbme", "鰀"},
	{"nfbmr", "鮦"},
	{"nfbnd", "䱐"},
	{"nfbof", "鰶"},
	{"nfbou", "鰩"},
	{"nfbtv", "䱩"},
	{"nfbuu", "覙"},
	{"nfbv", "鮾"},
	{"nfci", "䰸"},
	{"nfcim", "䱵"},
	{"nfcnh", "鮷"},
	{"nfcru", "鮵"},
	{"nfcsh", "魵"},
	{"nfcwa", "鱛"},
	{"nfdbn", "䱨"},
	{"nfdhe", "鮍"},
	{"nfdj", "䱅"},
	{"nfdlc", "䲚"},
	{"nfdln", "鯻"},
	{"nfdm", "䱁"},
	{"nfdn", "粥"},
	{"nfdoo", "鯠"},
	{"nfdw", "鯟"},
	{"nfdwf", "鰊"},
	{"nfefh", "鯋"},
	{"nfeii", "鰠"},
	{"nfemw", "䲤"},
	{"nffb", "鮹"},
	{"nffba", "鱨"},
	{"nffd", "䱊"},
	{"nffdq", "鱗"},
	{"nfffs", "䲏"},
	{"nffh", "魦"},
	{"nffqu", "䱧"},
	{"nfg", "𩵚"},
	{"nfgce", "鯪"},
	{"nfgcg", "鯥"},
	{"nfgfo", "䲌"},
	{"nfgg", "鮭"},
	{"nfggu", "鱙"},
	{"nfgi", "魼"},
	{"nfgit", "鰪"},
	{"nfgni", "䲖"},
	{"nfgr", "鮚"},
	{"nfgrr", "鱚"},
	{"nfgyo", "鯐"},
	{"nfha", "鮊"},
	{"nfhae", "鰁"},
	{"nfhaf", "鷠"},
	{"nfhag", "鰉"},
	{"nfhal", "䲙"},
	{"nfhbn", "鯯"},
	{"nfhd", "穌"},
	{"nfhdd", "鯚"},
	{"nfhdf", "鰍"},
	{"nfhdn", "鯏"},
	{"nfhdv", "鯘"},
	{"nfhdw", "鱕"},
	{"nfhe", "魬"},
	{"nfher", "鮥"},
	{"nfhey", "鮗"},
	{"nfhgr", "鯌"},
	{"nfhhw", "鰡"},
	{"nfhir", "鱵"},
	{"nfhjd", "鮢"},
	{"nfhje", "𩹨"},
	{"nfhjg", "䱰"},
	{"nfhjr", "䲘"},
	{"nfhkb", "鱎"},
	{"nfhml", "䰺"},
	{"nfhmr", "鮜"},
	{"nfhon", "䲗"},
	{"nfhor", "鯦"},
	{"nfhp", "魠"},
	{"nfhpl", "鮣"},
	{"nfhqm", "鮏"},
	{"nfhqo", "䱃"},
	{"nfhqu", "魹"},
	{"nfhrb", "鰤"},
	{"nfhrf", "鰞"},
	{"nfhs", "鮓"},
	{"nfhvf", "鯀"},
	{"nfhvo", "䱄"},
	{"nfhwj", "䱝"},
	{"nfhxc", "鱮"},
	{"nfhxe", "䱸"},
	{"nfhxh", "鯓"},
	{"nfhxu", "鯢"},
	{"nfi", "䰹"},
	{"nfice", "鮻"},
	{"nfidd", "䲈"},
	{"nfihm", "鯳"},
	{"nfihr", "鰔"},
	{"nfihs", "鯎"},
	{"nfihv", "鰄"},
	{"nfii", "䱠"},
	{"nfiih", "鰺"},
	{"nfijb", "鯆"},
	{"nfije", "鯄"},
	{"nfikh", "鯵"},
	{"nfikk", "鮁"},
	{"nfiku", "魷"},
	{"nfilb", "鱅"},
	{"nfile", "鱇"},
	{"nfir", "鮐"},
	{"nfirm", "䱛"},
	{"nfirp", "鱤"},
	{"nfis", "魲"},
	{"nfisb", "鯿"},
	{"nfisk", "𩸭"},
	{"nfivl", "䱶"},
	{"nfjb", "䰽"},
	{"nfjcr", "鰫"},
	{"nfjd", "鮇"},
	{"nfjii", "鱄"},
	{"nfjjl", "䱿"},
	{"nfjka", "鯺"},
	{"nfjkp", "鮱"},
	{"nfjks", "鮳"},
	{"nfjmf", "鯮"},
	{"nfjmg", "鰘"},
	{"nfjmm", "鰚"},
	{"nfjmu", "鯇"},
	{"nfjp", "鮀"},
	{"nfjpa", "鰭"},
	{"nfjr", "鮕"},
	{"nfjrb", "鰗"},
	{"nfjtc", "鱝"},
	{"nfjv", "鮟"},
	{"nfkb", "鮪"},
	{"nfke", "𩵼"},
	{"nfkkb", "鯑"},
	{"nfklu", "𩸆"},
	{"nfkmb", "鰖"},
	{"nfkmf", "䱞"},
	{"nfkms", "鮬"},
	{"nfkn", "鮧"},
	{"nfksr", "𩶛"},
	{"nflbk", "䱀"},
	{"nflbu", "魫"},
	{"nflln", "鮄"},
	{"nfllv", "䱾"},
	{"nflmo", "鮡"},
	{"nflmy", "鯡"},
	{"nfln", "魝"},
	{"nflw", "鮋"},
	{"nflx", "鱐"},
	{"nfm", "魟"},
	{"nfmam", "䱎"},
	{"nfmbb", "鱬"},
	{"nfmbl", "鮞"},
	{"nfmbm", "鱈 䱍"},
	{"nfmbw", "鱩"},
	{"nfmcw", "鯂"},
	{"nfmfj", "鮃"},
	{"nfmfl", "鰰"},
	{"nfmfm", "魾"},
	{"nfmgi", "玺"},
	{"nfmgr", "鱷"},
	{"nfmlb", "魳"},
	{"nfmlk", "鯁"},
	{"nfmls", "䱖"},
	{"nfmmf", "䱈"},
	{"nfmmp", "鱺"},
	{"nfmmr", "鯃"},
	{"nfmmu", "魭"},
	{"nfmn", "䰳"},
	{"nfmnr", "魺"},
	{"nfmr", "鮖"},
	{"nfmrt", "䱏"},
	{"nfmrw", "鰏"},
	{"nfmtb", "鱱"},
	{"nfmto", "鱖"},
	{"nfmvm", "魱"},
	{"nfmwf", "鰾"},
	{"nfmwg", "䱳"},
	{"nfmwj", "鱏"},
	{"nfmwm", "䲔"},
	{"nfnao", "鱌"},
	{"nfnau", "鮸"},
	{"nfnbq", "䲒"},
	{"nfnd", "䰵"},
	{"nfndt", "鯭"},
	{"nfnff", "鱻 䲜"},
	{"nfnhb", "鱊"},
	{"nfnhd", "鰇"},
	{"nfnhe", "魥"},
	{"nfnhx", "䱤"},
	{"nfnib", "鯒"},
	{"nfnin", "魣"},
	{"nfnjk", "䲎"},
	{"nfnkg", "䱓"},
	{"nfnkq", "鰎"},
	{"nfnkv", "鯅"},
	{"nfnlb", "䲊"},
	{"nfnmi", "鯴"},
	{"nfnmm", "鰯"},
	{"nfnmu", "鮠"},
	{"nfnob", "䱬"},
	{"nfnoe", "鱍"},
	{"nfnsd", "䱆 䱢"},
	{"nfnwf", "䲆 𩺰"},
	{"nfo", "魜"},
	{"nfoae", "鰒"},
	{"nfob", "魶"},
	{"nfod", "鮴"},
	{"nfodi", "鮒"},
	{"nfog", "䱦"},
	{"nfoii", "魿"},
	{"nfoik", "鮲"},
	{"nfoin", "䰼"},
	{"nfoip", "鯰"},
	{"nfoir", "䱽"},
	{"nfok", "䰻"},
	{"nfold", "鰷"},
	{"nfolk", "䱔"},
	{"nfoll", "魪"},
	{"nfoma", "鱠"},
	{"nfomb", "鯩"},
	{"nfomd", "鮽"},
	{"nfomk", "鯾"},
	{"nfomo", "䲓"},
	{"nfomr", "鮯"},
	{"nfon", "䰴"},
	{"nfonk", "鯸"},
	{"nfop", "魤"},
	{"nfopd", "䰿"},
	{"nfowy", "䱕"},
	{"nfoyk", "䲄"},
	{"nfp", "愻"},
	{"nfpa", "鮨"},
	{"nfpfd", "䱡"},
	{"nfph", "鮅"},
	{"nfphh", "魩"},
	{"nfpi", "魡"},
	{"nfpmm", "䱭 䱴"},
	{"nfpp", "魮"},
	{"nfpr", "鮈"},
	{"nfpru", "鮑"},
	{"nfptd", "鰈"},
	{"nfpu", "魨"},
	{"nfqhk", "䱮"},
	{"nfqhl", "䱑"},
	{"nfqj", "䰷"},
	{"nfqka", "鰆"},
	{"nfqmb", "鯖"},
	{"nfqmc", "鰿"},
	{"nfqmv", "䱪"},
	{"nfqoa", "䲋"},
	{"nfqou", "䲅"},
	{"nfrau", "䱒"},
	{"nfrrd", "鱢"},
	{"nfrrj", "鱓"},
	{"nfrrs", "鰐"},
	{"nfrxu", "鱦"},
	{"nfrye", "鰕"},
	{"nfsav", "鰋"},
	{"nfseg", "鰹"},
	{"nfsfi", "䲁"},
	{"nfsh", "魛"},
	{"nfshr", "鮉"},
	{"nfsje", "鯫"},
	{"nfsjr", "䱟"},
	{"nfsju", "鮿"},
	{"nfskr", "鮶"},
	{"nfsll", "䱌"},
	{"nfsma", "鰼"},
	{"nfsmb", "鯞"},
	{"nfsme", "鮼"},
	{"nfsmi", "鱘"},
	{"nfsmm", "鮙"},
	{"nfsqf", "鰢"},
	{"nfsrr", "鰸"},
	{"nfss", "鮔"},
	{"nfstv", "䱼"},
	{"nfsu", "魢"},
	{"nfta", "䱜"},
	{"nftc", "䱋"},
	{"nftca", "䲕"},
	{"nftcl", "䲉"},
	{"nftcw", "鰌"},
	{"nftgi", "䲑"},
	{"nftgr", "鱔"},
	{"nftjs", "鰳"},
	{"nftkr", "鰙"},
	{"nftlc", "鱑"},
	{"nftm", "魽"},
	{"nftmc", "鯕"},
	{"nftoe", "鱯"},
	{"nftov", "鱶"},
	{"nftq", "鮮"},
	{"nftqg", "鱃"},
	{"nftqm", "䱹"},
	{"nftrg", "鱹"},
	{"nftt", "鮩"},
	{"nftvi", "鰦"},
	{"nftvp", "𩼰"},
	{"nftwa", "鰽"},
	{"nftwi", "鱒 鱴"},
	{"nftwt", "鱧"},
	{"nftwu", "䲛"},
	{"nftxc", "鰜"},
	{"nftyv", "𩷶"},
	{"nfu", "䰲"},
	{"nfuce", "鯼"},
	{"nfujf", "𩻃"},
	{"nfumt", "䱺"},
	{"nfvhl", "鱜"},
	{"nfvid", "鱳"},
	{"nfvis", "䱂"},
	{"nfvmi", "鱂"},
	{"nfvne", "䱚"},
	{"nfvno", "䱲"},
	{"nfvvd", "䲃"},
	{"nfvvv", "鱲"},
	{"nfvvw", "鯔"},
	{"nfwg", "鯉"},
	{"nfwj", "弾"},
	{"nfwjr", "鯝"},
	{"nfwl", "魻"},
	{"nfwla", "鱰"},
	{"nfwlb", "鰅"},
	{"nfwle", "鰥"},
	{"nfwlv", "鱞"},
	{"nfwmv", "鰃"},
	{"nfwo", "鮂"},
	{"nfwot", "鰮"},
	{"nfwp", "鰓"},
	{"nfwr", "鮰"},
	{"nfybb", "䱱 𩼣"},
	{"nfybs", "鰟"},
	{"nfyck", "鮫"},
	{"nfydl", "䲇"},
	{"nfyfe", "䱙"},
	{"nfyhn", "魧"},
	{"nfyhr", "𩺬"},
	{"nfyhs", "魴"},
	{"nfyiu", "鯍"},
	{"nfyjj", "鰱"},
	{"nfyk", "魰"},
	{"nfyle", "𩻸"},
	{"nfymf", "鮛"},
	{"nfymh", "鱥"},
	{"nfymo", "鱁"},
	{"nfyoj", "䱣"},
	{"nfypk", "鰬"},
	{"nfypm", "鱋"},
	{"nfyps", "䲐"},
	{"nfypt", "鱸"},
	{"nfypu", "鯱"},
	{"nfyr", "鮎"},
	{"nfyrb", "鰝"},
	{"nfyrd", "鯙"},
	{"nfyrf", "鯨"},
	{"nfyso", "䲂"},
	{"nfysy", "鯲"},
	{"nfyt", "𩶘"},
	{"nfytj", "鱆"},
	{"nfytv", "鯜"},
	{"nfyv", "䰶"},
	{"nfyvi", "鮌"},
	{"nfywm", "鱣"},
	{"nfyx", "鱭"},
	{"ng", "丑"},
	{"ngi", "厾"},
	{"ngmbc", "頲"},
	{"ngmbo", "颋"},
	{"ngmwm", "疆"},
	{"nhate", "䂍"},
	{"nhbcr", "矞"},
	{"nhbue", "矡"},
	{"nhd", "柔"},
	{"nhdv", "㢻"},
	{"nhe", "及"},
	{"nhep", "㤂"},
	{"nhfb", "矟"},
	{"nhhuc", "䂎"},
	{"nhli", "虱"},
	{"nhlii", "蟊"},
	{"nhlmi", "䂈 䖥"},
	{"nhnao", "䂊"},
	{"nhng", "䂇"},
	{"nhnvm", "骘"},
	{"nhoii", "矝"},
	{"nhoin", "矜"},
	{"nhok", "敄"},
	{"nhoks", "務"},
	{"nhonk", "䂉"},
	{"nhpi", "䂆"},
	{"nhpm", "弤"},
	{"nhs", "乃"},
	{"nhsqf", "騭"},
	{"nhta", "矠"},
	{"nhv", "𡛺"},
	{"nhvo", "弧"},
	{"nhx", "臽"},
	{"nhytg", "䂌"},
	{"ni", "夕 弘"},
	{"niail", "𡖖"},
	{"nibq", "甬"},
	{"nic", "䥒"},
	{"nif", "㢱"},
	{"nihaf", "鵵"},
	{"nihq", "犟"},
	{"nihqm", "夝"},
	{"nij", "㚈"},
	{"nijmc", "夤"},
	{"niks", "勥"},
	{"nili", "強"},
	{"niln", "劖"},
	{"ninh", "矛"},
	{"nini", "多"},
	{"ninii", "𠓗"},
	{"ninl", "邜 酁"},
	{"ninn", "予"},
	{"nioiv", "飧"},
	{"niq", "舛"},
	{"nir", "名"},
	{"nisl", "夘"},
	{"nisu", "夗"},
	{"nitc", "彍"},
	{"niv", "婱"},
	{"niwj", "圅"},
	{"nixp", "麁"},
	{"niy", "外"},
	{"niyj", "斘"},
	{"niymr", "謽 𧥧"},
	{"niyo", "癶"},
	{"nj", "卂"},
	{"njbc", "㣀"},
	{"njg", "塦"},
	{"njhaf", "鳵"},
	{"njjwp", "聼"},
	{"njlii", "蝨"},
	{"nk", "又 夊 廴"},
	{"nka", "暓"},
	{"nkbcr", "𢌡"},
	{"nkbr", "㢠"},
	{"nkbu", "瞀"},
	{"nkc", "鍪"},
	{"nkd", "楘"},
	{"nkf", "煞 㷺"},
	{"nkg", "堥"},
	{"nkha", "廹"},
	{"nkhaf", "鶩 䳫"},
	{"nkhg", "廷"},
	{"nkhml", "郔"},
	{"nkhym", "延"},
	{"nki", "戣 㢬"},
	{"nklb", "㡔"},
	{"nklmi", "蝥"},
	{"nklq", "建"},
	{"nklw", "廸"},
	{"nkmcw", "廼"},
	{"nkmrt", "䜼"},
	{"nknl", "鄈"},
	{"nknvm", "骛"},
	{"nknwf", "䱯"},
	{"nkog", "䨁"},
	{"nkoiv", "饏"},
	{"nkp", "愗 㤵"},
	{"nkpym", "鹜"},
	{"nkrhg", "𢌥"},
	{"nksqf", "騖"},
	{"nktlj", "鞪"},
	{"nku", "嵍"},
	{"nkv", "婺"},
	{"nkvif", "䋷"},
	{"nkvvv", "廵"},
	{"nkwr", "廻"},
	{"nkwsl", "廽"},
	{"nkyv", "㢟"},
	{"nl", "弔 引 阝 ⻏ ⻖"},
	{"nla", "阳"},
	{"nlafu", "𨻙"},
	{"nlag", "陧"},
	{"nlamh", "陽"},
	{"nlamo", "隄"},
	{"nlav", "限"},
	{"nlavf", "隰"},
	{"nlb", "阴"},
	{"nlbhf", "䧦"},
	{"nlbhx", "䧟"},
	{"nlbi", "𢏐"},
	{"nlbm", "阻"},
	{"nlbmp", "隱"},
	{"nlbof", "際"},
	{"nlbqr", "䧓"},
	{"nlbsp", "隠"},
	{"nlbt", "盄"},
	{"nlbuu", "䧋"},
	{"nlbv", "䧌"},
	{"nlcnh", "𨹥"},
	{"nlcor", "䧍"},
	{"nldhe", "陂"},
	{"nldk", "䦼"},
	{"nldoo", "䧒"},
	{"nldw", "陳"},
	{"nldwk", "敶"},
	{"nle", "阥"},
	{"nlf", "阦"},
	{"nlfb", "陗"},
	{"nlfbg", "隚"},
	{"nlfdq", "隣"},
	{"nlfhf", "隙"},
	{"nlgce", "陵"},
	{"nlgcg", "陸"},
	{"nlggu", "隢"},
	{"nlgi", "阹"},
	{"nlgni", "隯"},
	{"nlgsk", "隞"},
	{"nlgyo", "陡"},
	{"nlhaf", "隝"},
	{"nlhag", "隍"},
	{"nlhau", "﨩"},
	{"nlhbk", "隩"},
	{"nlhe", "阪"},
	{"nlhej", "䧏"},
	{"nlhem", "隆"},
	{"nlheq", "降"},
	{"nlher", "䧄"},
	{"nlhhj", "陴"},
	{"nlhhw", "𨻧"},
	{"nlhi", "隗"},
	{"nlhj", "阡"},
	{"nlhjd", "陎"},
	{"nlhjg", "隀"},
	{"nlhjm", "陲"},
	{"nlhlb", "𨺲"},
	{"nlhpm", "阺"},
	{"nlhqr", "䧊"},
	{"nlhrf", "隖"},
	{"nlhs", "阼"},
	{"nlht", "阩"},
	{"nlhta", "陹"},
	{"nlhtg", "陞"},
	{"nlhwp", "䧭"},
	{"nlhxg", "隉"},
	{"nlice", "陖"},
	{"nlihu", "阭"},
	{"nlihv", "隇"},
	{"nlii", "䧖"},
	{"nlijb", "陠"},
	{"nlikp", "陇"},
	{"nlikv", "䧪"},
	{"nlilb", "䧡"},
	{"nlilr", "䧜"},
	{"nlirm", "䧕"},
	{"nlisn", "阸"},
	{"nlj", "䦹"},
	{"nljii", "䧠"},
	{"nljip", "䧥"},
	{"nljka", "陼"},
	{"nljmc", "䧬"},
	{"nljmo", "䧑"},
	{"nljmu", "院"},
	{"nljp", "陀"},
	{"nljqp", "䧮"},
	{"nljtc", "隫"},
	{"nljwj", "陣"},
	{"nlkb", "陏"},
	{"nlkd", "陈"},
	{"nlki", "䧀"},
	{"nlkmb", "隋"},
	{"nlkmm", "隓"},
	{"nlkmr", "陭"},
	{"nlkms", "陓"},
	{"nlkn", "䧅"},
	{"nlkoo", "陜 陝"},
	{"nlkq", "阵"},
	{"nlks", "阞"},
	{"nlkt", "陕"},
	{"nll", "䦿"},
	{"nllmc", "隤"},
	{"nllmy", "陫"},
	{"nlma", "陌"},
	{"nlmbb", "隭"},
	{"nlmbk", "陾"},
	{"nlmbl", "陑"},
	{"nlmbv", "陋"},
	{"nlmf", "阫"},
	{"nlmfb", "隬"},
	{"nlmfj", "𨸶"},
	{"nlmfm", "𨸹"},
	{"nlmlw", "䧈"},
	{"nlmmf", "际"},
	{"nlmmu", "阮"},
	{"nlmmv", "陙"},
	{"nlmn", "䦺"},
	{"nlmnr", "阿"},
	{"nlmob", "陃"},
	{"nlmpm", "陚"},
	{"nlmrb", "隔"},
	{"nlmsu", "阨"},
	{"nlmu", "阢"},
	{"nlmvm", "陘"},
	{"nlmwf", "䧣"},
	{"nlmwg", "陻"},
	{"nlmym", "阷"},
	{"nlnbs", "𨺳"},
	{"nlnd", "䦻"},
	{"nlnff", "䧰"},
	{"nlnhx", "陷"},
	{"nlnin", "陊 䦽"},
	{"nlnj", "阠"},
	{"nlnjk", "䧩"},
	{"nlnla", "陥"},
	{"nlnmu", "陒"},
	{"nlnom", "陉"},
	{"nlnot", "隥"},
	{"nlnri", "䧯"},
	{"nlnsp", "隐"},
	{"nlo", "队"},
	{"nloae", "䧗"},
	{"nlodi", "附"},
	{"nlog", "陮"},
	{"nloii", "陰"},
	{"nloip", "䧔"},
	{"nloll", "阶"},
	{"nlomb", "陯"},
	{"nlomd", "除"},
	{"nlomm", "险"},
	{"nlomn", "隃"},
	{"nlomo", "險"},
	{"nlon", "阣"},
	{"nlopd", "陁"},
	{"nlosi", "隂"},
	{"nlpd", "阤"},
	{"nlpfd", "陱"},
	{"nlpou", "陶"},
	{"nlpp", "阰"},
	{"nlppa", "階"},
	{"nlppg", "陛"},
	{"nlpr", "䧁"},
	{"nlqki", "陦"},
	{"nlqu", "陆"},
	{"nlrb", "䧎"},
	{"nlrbc", "隕"},
	{"nlrbo", "陨"},
	{"nlrd", "𨹦"},
	{"nlsav", "隁"},
	{"nlshr", "䧂"},
	{"nlsje", "陬"},
	{"nlsko", "陿"},
	{"nlsqf", "䧞"},
	{"nlsrj", "隦"},
	{"nlsrr", "䧢"},
	{"nltc", "䧆"},
	{"nltcd", "䧨"},
	{"nltco", "䧤"},
	{"nltct", "隘"},
	{"nltgi", "䥀 䧧"},
	{"nltpo", "隊"},
	{"nltt", "阱"},
	{"nltxc", "隒"},
	{"nlumi", "䧝"},
	{"nlumt", "隑"},
	{"nluop", "䧙"},
	{"nlvno", "䧘"},
	{"nlvvd", "隟"},
	{"nlw", "䧃"},
	{"nlwg", "䧉"},
	{"nlwlb", "隅"},
	{"nlwmv", "隈"},
	{"nlwol", "𨺬"},
	{"nlx", "彇"},
	{"nlybp", "隴"},
	{"nlybs", "䧛"},
	{"nlyhm", "隡"},
	{"nlyhn", "阬"},
	{"nlyhs", "防"},
	{"nlyhv", "䧇"},
	{"nlyj", "阧"},
	{"nlykb", "随 隨"},
	{"nlylh", "陟"},
	{"nlylm", "阯"},
	{"nlylo", "𨺗"},
	{"nlypu", "䖎"},
	{"nlyr", "阽"},
	{"nlyrb", "䧚"},
	{"nlyrd", "䧐"},
	{"nlyro", "䧫"},
	{"nlyta", "隌"},
	{"nlyti", "隵"},
	{"nlytj", "障"},
	{"nlyto", "隧"},
	{"nlytr", "陪"},
	{"nlyvo", "陔"},
	{"nlyx", "隮"},
	{"nm", "厃 㢧"},
	{"nma", "驲 㢶"},
	{"nmaa", "鲳"},
	{"nmabt", "鳁"},
	{"nmadi", "鲥"},
	{"nmail", "鲫"},
	{"nmamo", "鳀"},
	{"nman", "弼"},
	{"nmapp", "鲲"},
	{"nmasm", "鳎"},
	{"nmau", "鲃"},
	{"nmawe", "鳗"},
	{"nmbg", "㣆"},
	{"nmbgr", "鲷"},
	{"nmbm", "驵"},
	{"nmbmr", "鲖"},
	{"nmbn", "䰜 𢏺"},
	{"nmbon", "鲗"},
	{"nmbou", "鳐"},
	{"nmbwd", "彚"},
	{"nmd", "弙"},
	{"nmdhe", "鲏"},
	{"nmdl", "疎"},
	{"nme", "驭"},
	{"nmeii", "骚"},
	{"nmeq", "驿"},
	{"nmfb", "彌"},
	{"nmfbi", "鲿"},
	{"nmfdq", "鳞"},
	{"nmfft", "彞"},
	{"nmgce", "鲮"},
	{"nmgg", "鲑"},
	{"nmgr", "鲒"},
	{"nmha", "鲌"},
	{"nmhae", "鳈"},
	{"nmhag", "鳇"},
	{"nmhd", "稣"},
	{"nmhdf", "鳅"},
	{"nmhed", "鲦"},
	{"nmher", "骆"},
	{"nmhhw", "骝"},
	{"nmhjr", "鳤"},
	{"nmhkl", "骄"},
	{"nmhmr", "鲘"},
	{"nmhpl", "䲟"},
	{"nmhqo", "𡘓"},
	{"nmhvf", "鲧"},
	{"nmhwp", "骢"},
	{"nmhxu", "鲵"},
	{"nmice", "骏"},
	{"nmike", "鲅"},
	{"nmikh", "骖"},
	{"nmiku", "鱿"},
	{"nmilb", "鳙"},
	{"nmir", "骀"},
	{"nmirp", "鳡"},
	{"nmis", "驴"},
	{"nmisb", "骗"},
	{"nmism", "骟"},
	{"nmj", "㢨"},
	{"nmjks", "鲓"},
	{"nmjmf", "骔"},
	{"nmjmu", "鲩"},
	{"nmjp", "驼"},
	{"nmjpa", "鳍"},
	{"nmjpu", "骁"},
	{"nmjto", "鲼"},
	{"nmjv", "䯃"},
	{"nmk", "驮"},
	{"nmkb", "鲔"},
	{"nmkk", "驳"},
	{"nmkmr", "骑"},
	{"nmks", "劲"},
	{"nmleg", "鲣"},
	{"nmlk", "驶"},
	{"nmlll", "驯"},
	{"nmlmi", "蜑"},
	{"nmlmy", "鲱"},
	{"nmln", "刭"},
	{"nmlpc", "骥"},
	{"nmlw", "鲉"},
	{"nmlws", "骋"},
	{"nmlx", "骕"},
	{"nmm", "彐"},
	{"nmmbb", "骊"},
	{"nmmbl", "鲕"},
	{"nmmbo", "颈"},
	{"nmmbs", "鳕"},
	{"nmmbu", "骦"},
	{"nmme", "录"},
	{"nmmfj", "鲆"},
	{"nmmlk", "鲠"},
	{"nmmn", "夛"},
	{"nmmnr", "鲄"},
	{"nmmr", "䃧"},
	{"nmmrw", "鲾"},
	{"nmms", "㢪"},
	{"nmmto", "鳜"},
	{"nmmu", "㞪"},
	{"nmmwf", "骠"},
	{"nmnhi", "鲺"},
	{"nmnib", "鲬"},
	{"nmnim", "弱"},
	{"nmnmf", "鶸"},
	{"nmnmm", "骉"},
	{"nmnok", "骙"},
	{"nmnsm", "驺"},
	{"nmoae", "鳆"},
	{"nmodi", "驸"},
	{"nmog", "骓"},
	{"nmoip", "鲶"},
	{"nmok", "矦"},
	{"nmomi", "鲙"},
	{"nmomm", "验"},
	{"nmopj", "骅"},
	{"nmos", "鲊"},
	{"nmosu", "䲝"},
	{"nmpd", "驰"},
	{"nmpr", "驹"},
	{"nmpru", "鲍"},
	{"nmptd", "鲽"},
	{"nmpu", "鲀"},
	{"nmqka", "䲠"},
	{"nmqmb", "鲭"},
	{"nmrb", "㣂"},
	{"nmrob", "䯄"},
	{"nmrr", "彁"},
	{"nmrrs", "鳄"},
	{"nmseo", "骤"},
	{"nmsfi", "鳚"},
	{"nmsh", "鱽"},
	{"nmsje", "鲰 䯅"},
	{"nmsk", "驱"},
	{"nmskr", "鲪"},
	{"nmsma", "鳛"},
	{"nmsme", "骎"},
	{"nmsmi", "鲟"},
	{"nmsnd", "骣"},
	{"nmsu", "危"},
	{"nmtcw", "䲡"},
	{"nmtjs", "鳓"},
	{"nmtmc", "骐"},
	{"nmtoe", "鳠"},
	{"nmtq", "鲜"},
	{"nmtt", "骈"},
	{"nmttr", "鳝"},
	{"nmtwi", "鳟"},
	{"nmtwt", "鳢"},
	{"nmtxc", "鳒"},
	{"nmua", "㣅"},
	{"nmvm", "弳"},
	{"nmvvw", "鲻"},
	{"nmwc", "驷"},
	{"nmwd", "骒"},
	{"nmwg", "鲤 㢾"},
	{"nmwjr", "鲴"},
	{"nmwk", "骃"},
	{"nmwlf", "鳏"},
	{"nmwm", "彊"},
	{"nmwmv", "鳂"},
	{"nmwn", "弻"},
	{"nmwp", "鳃"},
	{"nmwvf", "骡"},
	{"nmybs", "鳑"},
	{"nmyck", "鲛"},
	{"nmyg", "驻"},
	{"nmyhs", "鲂"},
	{"nmyiu", "疏"},
	{"nmykl", "鲚"},
	{"nmykq", "鲢"},
	{"nmyr", "鲇"},
	{"nmyrf", "鲸"},
	{"nmyrv", "骧"},
	{"nmys", "鲈"},
	{"nmyt", "䲞"},
	{"nmytj", "骍"},
	{"nmyvo", "骇"},
	{"nmywm", "鳣"},
	{"nn", "了 亇"},
	{"nnbqr", "㚋"},
	{"nnd", "㮗"},
	{"nngr", "夡"},
	{"nnhe", "𢎽"},
	{"nnje", "㩼"},
	{"nnkf", "㷇"},
	{"nnlmc", "㚍"},
	{"nnm", "孑"},
	{"nnmbc", "預 䫂"},
	{"nnmbo", "预"},
	{"nnmc", "㢲"},
	{"nnmrb", "鬻 䰞 𩱳"},
	{"nnnao", "豫"},
	{"nnnin", "㐨"},
	{"nno", "孓"},
	{"nnok", "㢸"},
	{"nnom", "弪"},
	{"nnp", "㥤"},
	{"nnpr", "夠"},
	{"nnqo", "承 𠄘"},
	{"nnr", "叾"},
	{"nnsl", "卶"},
	{"nnsmm", "翗"},
	{"nnu", "𠙶"},
	{"nnvvu", "郺"},
	{"nnwd", "㚌"},
	{"nnyvo", "㚊"},
	{"no", "久 欠 飞"},
	{"noam", "疍"},
	{"nob", "胥"},
	{"nobt", "㿿"},
	{"noc", "鐆"},
	{"nodi", "弣"},
	{"nof", "弥 灸 𤉋"},
	{"nofd", "粂"},
	{"nog", "墜 墬"},
	{"nohaf", "䴂"},
	{"nohne", "癹"},
	{"nohto", "飛"},
	{"nohv", "㢳"},
	{"nok", "矤"},
	{"noks", "勨"},
	{"nolmi", "蛋"},
	{"nomj", "癷"},
	{"nomk", "癸"},
	{"nomku", "発"},
	{"nomr", "㢵"},
	{"nomrn", "凳"},
	{"nomrt", "登"},
	{"nonhe", "發"},
	{"nonk", "㢿"},
	{"nonoo", "飝"},
	{"nop", "𢝵"},
	{"nopd", "㢮"},
	{"noph", "𢞵"},
	{"npd", "弛"},
	{"npi", "㢩"},
	{"npnii", "𣬚"},
	{"npo", "张"},
	{"nptd", "弽"},
	{"nq", "丮 𢩦"},
	{"nqd", "桀"},
	{"nqg", "㘶 㙰"},
	{"nqlmi", "蟹"},
	{"nrb", "弲"},
	{"nrilo", "㗮"},
	{"nrli", "强"},
	{"nrmvn", "甔"},
	{"nrog", "𨿅"},
	{"nrpp", "㲋"},
	{"nrppi", "毚"},
	{"nrppk", "㚟"},
	{"nrrj", "彈"},
	{"nrv", "娿"},
	{"nrvp", "㢯"},
	{"nsbt", "盈"},
	{"nsbul", "鼐"},
	{"nsc", "䥐"},
	{"nsd", "争 朶 檃"},
	{"nsdhe", "皱"},
	{"nsdj", "㭆"},
	{"nse", "夃 𠃮"},
	{"nsf", "尕"},
	{"nsg", "埅"},
	{"nshaf", "䳱"},
	{"nshr", "弨"},
	{"nsj", "弭"},
	{"nsjn", "㢽"},
	{"nsjr", "呄"},
	{"nsk", "奦"},
	{"nsll", "弬"},
	{"nsm", "刍"},
	{"nsmls", "戼"},
	{"nsmv", "張"},
	{"nsnd", "孕"},
	{"nsnin", "㚉"},
	{"nsnl", "邹"},
	{"nsog", "雏"},
	{"nsp", "急"},
	{"nsrr", "彄"},
	{"nss", "弡"},
	{"nsv", "㜈"},
	{"ntbh", "彅"},
	{"ntbuu", "覴"},
	{"nthaf", "䳾"},
	{"nthb", "㣁"},
	{"nthqu", "㲪"},
	{"nti", "戤"},
	{"ntks", "勐"},
	{"ntln", "㔁"},
	{"ntmc", "彉"},
	{"ntmvn", "㽅"},
	{"ntnl", "鄧 𨜏"},
	{"nu", "乙 㢫"},
	{"nuab", "𡦀"},
	{"nubt", "盌"},
	{"nubu", "眢"},
	{"nue", "函 弢 弢"},
	{"nuhaf", "鴛"},
	{"nuhqu", "䶰"},
	{"nui", "兔"},
	{"nuje", "㩻"},
	{"nuks", "勉"},
	{"nulb", "㠾"},
	{"nulmi", "䖤"},
	{"numbc", "頠 顄"},
	{"numvn", "㼝"},
	{"nuni", "㢷"},
	{"nunl", "䣀"},
	{"nup", "怨"},
	{"nupym", "鸳"},
	{"nusqf", "駌"},
	{"nuv", "妴"},
	{"nuw", "㽜"},
	{"nv", "饣"},
	{"nvamg", "䭪"},
	{"nvapp", "馄"},
	{"nvawe", "馒"},
	{"nvbbb", "馉"},
	{"nvbv", "馁"},
	{"nvdam", "馇"},
	{"nvgit", "馌"},
	{"nvhbr", "饷"},
	{"nvhe", "饭"},
	{"nvher", "饹"},
	{"nvhg", "饪"},
	{"nvhhw", "馏"},
	{"nvhk", "饫"},
	{"nvhn", "饥"},
	{"nvhp", "饦"},
	{"nvhqi", "饿"},
	{"nvhxe", "馊"},
	{"nvibi", "馎"},
	{"nvice", "馂"},
	{"nvij", "饯"},
	{"nvir", "饴"},
	{"nvjbd", "饽"},
	{"nvjbv", "馕"},
	{"nvjpu", "饶"},
	{"nvjrr", "馆"},
	{"nvlii", "䗺"},
	{"nvlmi", "蚀"},
	{"nvlmo", "馈"},
	{"nvmn", "饤"},
	{"nvmrt", "饾"},
	{"nvnhx", "馅"},
	{"nvno", "饮"},
	{"nvnsh", "饧"},
	{"nvnuy", "馋"},
	{"nvoks", "饬"},
	{"nvolb", "饰"},
	{"nvomd", "馀"},
	{"nvomn", "饩"},
	{"nvomr", "饸"},
	{"nvpru", "饱"},
	{"nvpu", "饨"},
	{"nvruc", "馔"},
	{"nvsj", "饵"},
	{"nvsm", "马"},
	{"nvsmr", "饲"},
	{"nvtak", "馍"},
	{"nvtbk", "馓"},
	{"nvtlm", "馑"},
	{"nvtqg", "馐"},
	{"nvtt", "饼"},
	{"nvuu", "饳"},
	{"nvwd", "馃"},
	{"nvyck", "饺"},
	{"nvyhv", "饻"},
	{"nw", "乪"},
	{"nwbue", "𡕷"},
	{"nwf", "魚"},
	{"nwfa", "魯"},
	{"nwks", "勇"},
	{"nwlmi", "螴"},
	{"nwlu", "亀"},
	{"nwlv", "彋"},
	{"nwm", "鱼"},
	{"nwma", "鲁"},
	{"nwni", "㢴"},
	{"nwtj", "彃"},
	{"nwu", "龟"},
	{"nx", "卍"},
	{"nxff", "燄"},
	{"nxhaf", "鵮"},
	{"nxno", "欿"},
	{"nxpym", "鹐"},
	{"nxu", "龜"},
	{"nybn", "㣃"},
	{"nybu", "䀤"},
	{"nye", "㢭"},
	{"nyk", "买"},
	{"nylm", "⺪"},
	{"nyo", "疋"},
	{"nyrd", "弴"},
	{"nyrf", "弶"},
	{"nyrp", "夞"},
	{"nytj", "㢹"},
	{"nytv", "㢺"},
	{"nyvi", "弦"},
	{"o", "人"},
	{"oa", "㒲"},
	{"oaa", "倡"},
	{"oabuu", "䚐"},
	{"oahe", "复"},
	{"oahu", "𠋥"},
	{"oahwj", "朇"},
	{"oail", "㑡"},
	{"oaln", "劊"},
	{"oam", "但"},
	{"oamh", "偒"},
	{"oamo", "偍"},
	{"oan", "們"},
	{"oana", "僴"},
	{"oanb", "僩"},
	{"oanl", "鄶"},
	{"oaph", "㑥"},
	{"oapp", "倱"},
	{"oapv", "偈"},
	{"oasm", "傝"},
	{"oate", "儤"},
	{"oav", "佷"},
	{"oavf", "儑"},
	{"oawe", "僈"},
	{"oayf", "𠎠"},
	{"ob", "仴 內"},
	{"obau", "俷"},
	{"obb", "倗"},
	{"obbb", "傦"},
	{"obbe", "僾"},
	{"obbq", "僢"},
	{"obch", "儩"},
	{"obcn", "側"},
	{"obd", "倸"},
	{"obf", "㷶"},
	{"obg", "隺"},
	{"obgb", "偁"},
	{"obgr", "倜"},
	{"obhaf", "鸙"},
	{"obhd", "龢"},
	{"obhf", "僞"},
	{"obhu", "伔"},
	{"obhyu", "䶵 𧈛"},
	{"objj", "㑮"},
	{"obkf", "㒄"},
	{"obm", "伹"},
	{"obmbc", "龥"},
	{"obmc", "俱"},
	{"obmp", "㒚"},
	{"obmr", "侗"},
	{"obnd", "俘"},
	{"obno", "龡"},
	{"obo", "肉"},
	{"obof", "傺"},
	{"obon", "侧"},
	{"obou", "傜"},
	{"obp", "憊"},
	{"obppa", "龤"},
	{"obq", "佣"},
	{"obr", "㕯"},
	{"obsmm", "𦒈"},
	{"obuc", "倶"},
	{"obuf", "㒡"},
	{"obuu", "俔"},
	{"obv", "俀"},
	{"obvk", "傒"},
	{"obvne", "龣"},
	{"obyhn", "䶳"},
	{"obyr", "㑾"},
	{"oc", "仈"},
	{"ocb", "佾"},
	{"oci", "伀"},
	{"ocim", "傟"},
	{"ocip", "倊"},
	{"ocnh", "俤"},
	{"ocor", "俗"},
	{"ocru", "侻"},
	{"ocsh", "份"},
	{"ocwa", "僧"},
	{"od", "休"},
	{"odbuc", "賲"},
	{"odc", "鎥"},
	{"odci", "倯"},
	{"odd", "㑣"},
	{"oddf", "僸"},
	{"oddo", "儊"},
	{"ode", "叙"},
	{"odf", "溣 烋 㷛"},
	{"odg", "堡"},
	{"odh", "𠆫"},
	{"odhaf", "䳜"},
	{"odhe", "佊"},
	{"odhf", "鵂"},
	{"odi", "付"},
	{"odl", "㑛"},
	{"odm", "体"},
	{"odmq", "偉"},
	{"odnl", "䣄"},
	{"odog", "雓 䨀"},
	{"odoj", "𠓼"},
	{"odok", "敘"},
	{"odoo", "倈"},
	{"odp", "怹 恷"},
	{"odpm", "鸺"},
	{"odrxu", "䵹"},
	{"odsmg", "糴"},
	{"odt", "俫"},
	{"odw", "倲 𤲞"},
	{"odye", "敍"},
	{"odyj", "斜"},
	{"oe", "仅 氽 汆 㲻"},
	{"oeog", "傩"},
	{"oeok", "𠈹"},
	{"oevif", "䌓"},
	{"of", "伙 尒 尓"},
	{"ofb", "俏"},
	{"ofbc", "償"},
	{"ofbd", "㒉"},
	{"ofbf", "儻"},
	{"ofbg", "㑽"},
	{"ofbi", "偿"},
	{"ofbk", "僘"},
	{"ofbr", "倘"},
	{"ofbu", "傥"},
	{"ofbw", "儅"},
	{"ofd", "籴"},
	{"ofdq", "僯"},
	{"ofdv", "偻"},
	{"off", "倓"},
	{"offd", "儝"},
	{"offg", "𠐓"},
	{"offn", "㒌"},
	{"offs", "僗"},
	{"ofh", "仯"},
	{"ofhae", "㶗"},
	{"ofhaf", "鷡 鷦"},
	{"ofhqu", "㲬"},
	{"ofhu", "偗"},
	{"ofj", "伞"},
	{"ofln", "劁"},
	{"ofmbc", "顦"},
	{"ofmu", "侊"},
	{"ofmvn", "甒"},
	{"ofnl", "鄦"},
	{"ofp", "您"},
	{"ofpym", "鹪"},
	{"ofq", "伴"},
	{"ofqf", "儯"},
	{"ofqu", "倦"},
	{"oft", "㑞"},
	{"ofw", "畲"},
	{"og", "仕 隹"},
	{"ogbo", "赁"},
	{"ogbuc", "賃"},
	{"ogbuu", "観"},
	{"ogce", "倰"},
	{"ogd", "栠 集"},
	{"ogdi", "侍"},
	{"oge", "隻 雙"},
	{"ogee", "䨇"},
	{"ogf", "焦 㶵 㸈"},
	{"ogg", "佳"},
	{"oggu", "僥"},
	{"oghaf", "鵀 鶴 䳡"},
	{"oghn", "凭"},
	{"oghq", "犨"},
	{"ogi", "佉"},
	{"ogil", "㑢"},
	{"ogivg", "雠"},
	{"ogj", "隼"},
	{"ogks", "勧"},
	{"oglms", "雋"},
	{"ogln", "剉"},
	{"ogmbc", "顀"},
	{"ogmcw", "䣸"},
	{"ognhs", "隽"},
	{"ogni", "儔"},
	{"ogno", "歓"},
	{"ogog", "雔"},
	{"ogogd", "雧"},
	{"ogogg", "雥 𠓾"},
	{"ogogl", "䨊"},
	{"ogp", "恁"},
	{"ogpym", "鹤"},
	{"ogr", "佶 售 㘜"},
	{"ogrg", "儓"},
	{"ogrr", "僖 𠏼"},
	{"ogsk", "傲"},
	{"ogtj", "倖"},
	{"ogvif", "䋕"},
	{"ogwc", "儥"},
	{"ogyc", "䧶"},
	{"ogymr", "讐"},
	{"ogyrg", "讎"},
	{"oh", "入"},
	{"oha", "伯"},
	{"ohaf", "鳰"},
	{"ohag", "偟"},
	{"ohbt", "侐"},
	{"ohbu", "㑑"},
	{"ohbv", "侬"},
	{"ohby", "侜"},
	{"ohce", "傻"},
	{"ohdd", "㑧"},
	{"ohdf", "偢"},
	{"ohdi", "俬"},
	{"ohdn", "俐"},
	{"ohdp", "僁"},
	{"ohdr", "俰"},
	{"ohdv", "倭"},
	{"ohdw", "僠"},
	{"ohe", "仮"},
	{"oheh", "俢"},
	{"oheq", "佭"},
	{"oher", "佫"},
	{"ohew", "俻"},
	{"ohey", "佟"},
	{"ohfp", "僽"},
	{"ohg", "任"},
	{"ohgi", "𠑥"},
	{"ohgr", "俈"},
	{"ohgs", "働"},
	{"ohgu", "侁"},
	{"ohhh", "㐱"},
	{"ohhj", "俾"},
	{"ohho", "乑"},
	{"ohi", "仫 傀"},
	{"ohj", "仟"},
	{"ohjd", "侏"},
	{"ohjg", "偅"},
	{"ohjm", "倕"},
	{"ohjr", "佸"},
	{"ohju", "偱"},
	{"ohjx", "偛"},
	{"ohk", "仸"},
	{"ohkb", "僑"},
	{"ohkl", "侨"},
	{"ohlb", "偊"},
	{"ohlc", "儨"},
	{"ohlo", "俽"},
	{"ohml", "伒"},
	{"ohn", "仉"},
	{"ohnb", "佩"},
	{"ohne", "伇"},
	{"ohnf", "𠏵"},
	{"ohni", "偑 𠆩"},
	{"ohnk", "㐽"},
	{"ohnn", "㑉"},
	{"ohoa", "偺"},
	{"ohoi", "偫"},
	{"ohoo", "傱"},
	{"ohor", "倃"},
	{"ohp", "仛"},
	{"ohpa", "㒐"},
	{"ohpm", "低"},
	{"ohq", "件"},
	{"ohqi", "俄"},
	{"ohqo", "佚"},
	{"ohqu", "𠇔"},
	{"ohrf", "𠌥"},
	{"ohs", "作"},
	{"ohsb", "偏"},
	{"ohsg", "僱"},
	{"ohsk", "儌"},
	{"oht", "㐼"},
	{"ohuc", "儹"},
	{"ohvf", "係"},
	{"ohvl", "仰"},
	{"ohwp", "傯"},
	{"ohxc", "㒜"},
	{"ohxe", "傁"},
	{"ohxh", "㑗"},
	{"ohxu", "倪 㒨"},
	{"ohyu", "傂"},
	{"oi", "伐"},
	{"oiabt", "饂"},
	{"oiai", "飠"},
	{"oiamh", "餳"},
	{"oiapp", "餛"},
	{"oiapv", "餲"},
	{"oiar", "倉"},
	{"oiav", "俍 食 䬶"},
	{"oiawe", "饅"},
	{"oiay", "⻞"},
	{"oiayf", "䭘"},
	{"oibbb", "餶"},
	{"oibhx", "饀"},
	{"oibi", "傅"},
	{"oibjj", "餫"},
	{"oibm", "飷"},
	{"oibmp", "䭡"},
	{"oibmr", "餇"},
	{"oibp", "㑷"},
	{"oibv", "餒"},
	{"oice", "俊"},
	{"oicnh", "䬾"},
	{"oicru", "䬽"},
	{"oicyo", "餩"},
	{"oid", "𠇲"},
	{"oidam", "餷"},
	{"oidj", "䬴"},
	{"oidl", "餗"},
	{"oidm", "䬱"},
	{"oieee", "餟"},
	{"oifbd", "饓"},
	{"oifbg", "饄"},
	{"oiff", "餤"},
	{"oifq", "䬳"},
	{"oig", "垡"},
	{"oigbt", "饐"},
	{"oiggu", "饒"},
	{"oigit", "饁"},
	{"oigrr", "饎"},
	{"oigte", "䵾"},
	{"oihaf", "鴒"},
	{"oihag", "餭"},
	{"oihbr", "餉"},
	{"oihdv", "餧"},
	{"oihe", "飯"},
	{"oiher", "餎"},
	{"oihf", "傶"},
	{"oihg", "飪"},
	{"oihhl", "飹"},
	{"oihhw", "餾"},
	{"oihi", "餽"},
	{"oihjr", "餂"},
	{"oihk", "飫"},
	{"oihn", "飢"},
	{"oihne", "䬦"},
	{"oihon", "餰"},
	{"oihp", "侂 飥"},
	{"oihpi", "䬫"},
	{"oihq", "侔"},
	{"oihqi", "餓"},
	{"oihs", "飵 𠉛"},
	{"oihsb", "䭏"},
	{"oihuc", "饡"},
	{"oihup", "䭒"},
	{"oihxe", "餿"},
	{"oii", "俴"},
	{"oiibi", "餺"},
	{"oiice", "餕"},
	{"oiidf", "䭧"},
	{"oiidr", "饝"},
	{"oiidy", "䭩"},
	{"oiif", "㒍"},
	{"oiih", "傪"},
	{"oiii", "餞"},
	{"oiijb", "餔"},
	{"oiilr", "餹"},
	{"oiiq", "䬻"},
	{"oiir", "飴"},
	{"oiitc", "䭠"},
	{"oiitf", "䭖"},
	{"oijb", "俌"},
	{"oijbd", "餑"},
	{"oijbf", "𩟔"},
	{"oijbv", "饢"},
	{"oije", "俅"},
	{"oijln", "䭄"},
	{"oijpn", "䭢"},
	{"oijrb", "餬"},
	{"oijrr", "館"},
	{"oijtc", "饙"},
	{"oik", "仪 伏"},
	{"oikcf", "䭜"},
	{"oike", "㑓"},
	{"oikf", "偽"},
	{"oikjt", "餴"},
	{"oikkb", "餙 餚"},
	{"oiklu", "餣"},
	{"oikmb", "䭉"},
	{"oiks", "伪"},
	{"oiku", "优"},
	{"oilb", "傭"},
	{"oilbk", "䬬"},
	{"oilmc", "饋"},
	{"oilmi", "蝕"},
	{"oilmm", "韱"},
	{"oilmo", "餆"},
	{"oiln", "刽"},
	{"oilr", "傏"},
	{"oimbc", "領"},
	{"oimbk", "餪"},
	{"oimbo", "领"},
	{"oimf", "䬪"},
	{"oimgi", "㺸"},
	{"oimig", "䬹"},
	{"oimj", "飦"},
	{"oimmu", "䬧"},
	{"oimn", "飣"},
	{"oimo", "佽"},
	{"oimrt", "餖"},
	{"oimua", "䭙"},
	{"oimvn", "瓴"},
	{"oin", "今"},
	{"oinc", "貪"},
	{"oindo", "𡦈"},
	{"oinhx", "餡"},
	{"oini", "令"},
	{"oinin", "䬷"},
	{"oinjk", "䭛"},
	{"oinkq", "䭈"},
	{"oinl", "邻"},
	{"oino", "飲"},
	{"oinp", "念"},
	{"oinr", "含"},
	{"oinri", "饞"},
	{"oint", "盦"},
	{"oinv", "衾"},
	{"oinw", "酓"},
	{"oio", "飤"},
	{"oioae", "𩜲"},
	{"oiohg", "餁"},
	{"oiohh", "飻"},
	{"oioi", "俯"},
	{"oioip", "䭃"},
	{"oiok", "俟"},
	{"oioks", "飭"},
	{"oiolb", "飾"},
	{"oioma", "䭝"},
	{"oiomd", "餘"},
	{"oiomr", "餄"},
	{"oion", "䬣"},
	{"oiond", "餼"},
	{"oionk", "餱"},
	{"oiop", "㒣"},
	{"oiord", "䭋"},
	{"oip", "代 怤"},
	{"oipc", "㒃"},
	{"oipf", "儦"},
	{"oipgr", "䭇"},
	{"oiph", "飶"},
	{"oipkn", "䬨"},
	{"oipm", "侙"},
	{"oipr", "䬲"},
	{"oipru", "飽"},
	{"oiptd", "䭎"},
	{"oipu", "飩"},
	{"oipym", "鸰"},
	{"oiqmt", "䭍"},
	{"oir", "佁"},
	{"oirau", "䭂"},
	{"oirb", "䬼"},
	{"oirp", "㖚"},
	{"oiruc", "饌"},
	{"oish", "䬢"},
	{"oishr", "䬰"},
	{"oishu", "䬿"},
	{"oisj", "餌"},
	{"oisk", "㑦"},
	{"oism", "傓"},
	{"oismm", "翎"},
	{"oismr", "飼"},
	{"oismv", "餦"},
	{"oisrr", "饇"},
	{"oit", "㑘"},
	{"oitak", "饃"},
	{"oitbk", "饊"},
	{"oitbo", "饛"},
	{"oitc", "儣"},
	{"oitei", "䭦"},
	{"oitgf", "餻"},
	{"oitgp", "䭐"},
	{"oitgr", "饍"},
	{"oitgt", "饚"},
	{"oitk", "餀"},
	{"oitlk", "䭊"},
	{"oitlm", "饉"},
	{"oitov", "䭥"},
	{"oitpd", "䭟"},
	{"oitq", "䬺"},
	{"oitqg", "饈"},
	{"oitt", "餅"},
	{"oitxc", "䭑"},
	{"oitys", "餝"},
	{"oiumr", "𩜠"},
	{"oiumt", "䭓"},
	{"oiuob", "䭨"},
	{"oiuu", "飿"},
	{"oiv", "姇"},
	{"oiva", "储"},
	{"oivii", "饑"},
	{"oivio", "䬮"},
	{"oivno", "餯"},
	{"oiwd", "餜"},
	{"oiwjr", "䭅"},
	{"oiwlg", "饠"},
	{"oiwlj", "䭞"},
	{"oiwmv", "餵"},
	{"oiwtj", "饆"},
	{"oiyck", "餃"},
	{"oiyg", "飳"},
	{"oiyhr", "䭔"},
	{"oiyhv", "餏"},
	{"oiyjj", "餠"},
	{"oiylr", "䭤"},
	{"oiymh", "饖"},
	{"oiynj", "䭀"},
	{"oiyr", "䬯"},
	{"oiyrv", "饟"},
	{"oiytg", "䭚"},
	{"oiytk", "餸"},
	{"oiytr", "餢"},
	{"oiytu", "䭗"},
	{"oiyvo", "䬵"},
	{"oiywm", "饘"},
	{"oiyx", "䭣"},
	{"oiyy", "飰"},
	{"oj", "什 午"},
	{"ojb", "伂"},
	{"ojbc", "傎"},
	{"ojbd", "侼"},
	{"ojbj", "㑲"},
	{"ojbm", "值 𠊙"},
	{"ojbv", "儾"},
	{"ojcm", "倥"},
	{"ojcr", "傛"},
	{"ojd", "佅"},
	{"ojdi", "㑏"},
	{"oje", "伎"},
	{"ojg", "㙦"},
	{"ojhaf", "鶽"},
	{"ojhhh", "𢒑"},
	{"ojhp", "侘"},
	{"ojii", "傳"},
	{"ojij", "儎"},
	{"ojip", "僡"},
	{"ojiq", "傤"},
	{"ojjk", "僌"},
	{"ojk", "仗"},
	{"ojka", "偖"},
	{"ojkd", "侾"},
	{"ojkf", "𠐟"},
	{"ojkp", "佬"},
	{"ojks", "侤"},
	{"ojlk", "使"},
	{"ojln", "倳"},
	{"ojlo", "倢"},
	{"ojm", "伫"},
	{"ojmc", "儐"},
	{"ojmf", "倧"},
	{"ojmm", "𠊿"},
	{"ojmmr", "啎"},
	{"ojmn", "佇"},
	{"ojmo", "傢 𠉵"},
	{"ojmu", "俒"},
	{"ojnu", "倇"},
	{"ojoc", "傧"},
	{"ojon", "𠍅"},
	{"ojp", "佗"},
	{"ojpn", "儜"},
	{"ojpu", "侥 㑻"},
	{"ojr", "估"},
	{"ojrk", "做"},
	{"ojrr", "倌 㑸"},
	{"ojsl", "厁"},
	{"ojtc", "僨"},
	{"ojtg", "僿"},
	{"ojto", "偾"},
	{"ojty", "㒏"},
	{"oju", "缶"},
	{"ojv", "侒"},
	{"ojwj", "俥"},
	{"ok", "攵 矢 㐲"},
	{"okb", "侑"},
	{"okbu", "䀺"},
	{"okbuu", "䂓"},
	{"okc", "鋚"},
	{"okcf", "僚"},
	{"okcu", "傄"},
	{"okcwa", "矰"},
	{"okd", "㑈"},
	{"oke", "伖"},
	{"okf", "焂"},
	{"okgr", "䂒"},
	{"okgtj", "䂔"},
	{"okhae", "瀪"},
	{"okhaf", "鴙 𪄴"},
	{"okhby", "矪"},
	{"okhdv", "矮"},
	{"okhg", "俇"},
	{"okhk", "矨"},
	{"okhkb", "矯"},
	{"okhkl", "矫"},
	{"oki", "㑀"},
	{"okjt", "倴"},
	{"okkb", "俙"},
	{"okkk", "傸"},
	{"oklb", "佈"},
	{"okld", "侟"},
	{"oklu", "俺"},
	{"okm", "佐"},
	{"okmf", "倷"},
	{"okmr", "倚"},
	{"okmrt", "短"},
	{"okms", "侉"},
	{"okn", "仇 侇"},
	{"oknd", "𢻯"},
	{"oknj", "伜"},
	{"oknl", "矧"},
	{"oknn", "偧"},
	{"oknwf", "鰵"},
	{"oknwm", "鳘"},
	{"okog", "雉"},
	{"okok", "㑵"},
	{"okoo", "俠"},
	{"okoog", "矬"},
	{"okp", "悠 慜"},
	{"okpb", "僀"},
	{"okq", "伡"},
	{"okr", "佑 知"},
	{"okryo", "跾"},
	{"oks", "仂"},
	{"okshr", "䂏"},
	{"oksr", "伽"},
	{"okss", "矩"},
	{"okt", "侠"},
	{"oktlj", "䩦"},
	{"oktoe", "矱"},
	{"okuu", "䂐"},
	{"okv", "㛜"},
	{"okvif", "繁"},
	{"okvno", "䂕"},
	{"okwlp", "矲"},
	{"okymp", "䂑"},
	{"ol", "个 仲"},
	{"olb", "㠳"},
	{"olbk", "佒"},
	{"oleg", "㑠"},
	{"olha", "㫦"},
	{"olhaf", "䲸"},
	{"olhf", "倐"},
	{"olhi", "䖺"},
	{"olhw", "偹"},
	{"oll", "介"},
	{"ollk", "敒"},
	{"olln", "佛"},
	{"ollp", "㖋"},
	{"olmbu", "睂"},
	{"olmc", "僓"},
	{"olmo", "佻"},
	{"olmt", "儘"},
	{"olmy", "俳"},
	{"olnk", "候"},
	{"olno", "㰡"},
	{"olob", "脩"},
	{"olod", "條"},
	{"olof", "儵 絛 鯈"},
	{"oloh", "修"},
	{"oloj", "鞗"},
	{"olok", "倏 攸"},
	{"olom", "翛"},
	{"olp", "𠊞"},
	{"olpb", "偝"},
	{"olq", "侓"},
	{"ols", "们"},
	{"olw", "伷"},
	{"olwl", "伸"},
	{"olws", "俜"},
	{"olwv", "僂"},
	{"om", "丘 亼 仜 仝 㒰"},
	{"oma", "佰"},
	{"omami", "𦉡"},
	{"ombb", "儒"},
	{"ombc", "㑯"},
	{"ombe", "優"},
	{"ombk", "偄"},
	{"ombl", "侕"},
	{"ombn", "俞"},
	{"ombo", "㑔"},
	{"ombp", "愈 𢜒"},
	{"ombt", "侖"},
	{"ombv", "兪"},
	{"omc", "兵"},
	{"omd", "余 㐵"},
	{"omdm", "伍 儮"},
	{"omdp", "悆"},
	{"omdu", "峹 嵞"},
	{"omdw", "畬"},
	{"omf", "伓"},
	{"omfb", "儞"},
	{"omfj", "伻"},
	{"omfm", "伾 佥"},
	{"omfr", "俖"},
	{"omg", "全"},
	{"omgb", "侢"},
	{"omgc", "釒"},
	{"omgk", "𠊷"},
	{"omgn", "倒"},
	{"omgt", "㑝"},
	{"omh", "乒"},
	{"omhf", "傆"},
	{"omi", "乓"},
	{"omig", "侄"},
	{"omj", "仠"},
	{"omjr", "舍"},
	{"omjv", "钅"},
	{"omky", "㒎"},
	{"oml", "㐃"},
	{"omlb", "倆 𠉴"},
	{"omlk", "便"},
	{"omlm", "俹"},
	{"omln", "剑"},
	{"omlo", "㑒"},
	{"omlw", "価"},
	{"omm", "仁"},
	{"ommf", "佘"},
	{"ommi", "会 伝"},
	{"ommm", "仨"},
	{"ommp", "儷"},
	{"ommr", "俉"},
	{"ommu", "㐾"},
	{"ommv", "佞 侲"},
	{"ommvn", "㽂"},
	{"omn", "仃 气"},
	{"omnl", "邱 䣃"},
	{"omnn", "例 侴"},
	{"omno", "歙"},
	{"omnr", "何"},
	{"omob", "俩 㑂"},
	{"omok", "敛"},
	{"ompm", "倵"},
	{"omr", "合"},
	{"omrb", "龠"},
	{"omrl", "命"},
	{"omrm", "翕"},
	{"omro", "僉"},
	{"omrp", "龕 㥐"},
	{"omrq", "拿 搻"},
	{"omrr", "樖"},
	{"omrt", "侸 弇 盒"},
	{"omru", "𥅽"},
	{"omrw", "偪 畣"},
	{"omsl", "卸"},
	{"omsp", "屔"},
	{"omsu", "伌"},
	{"omth", "俨"},
	{"omtn", "侀"},
	{"omu", "岳 㐳"},
	{"omua", "僭"},
	{"omvh", "伢"},
	{"omvi", "傉"},
	{"omvm", "俓"},
	{"omvn", "佤"},
	{"omwa", "會 㑹"},
	{"omwc", "價"},
	{"omwd", "傈 僳"},
	{"omwf", "僄"},
	{"omwl", "偭"},
	{"omwm", "僵"},
	{"omwq", "僲"},
	{"omwu", "僊"},
	{"omwv", "偠"},
	{"omye", "㪧"},
	{"omyf", "傿"},
	{"omym", "佂"},
	{"on", "乞 亿 㐈 𠆤"},
	{"ona", "氜"},
	{"onabt", "氲"},
	{"onamh", "氱"},
	{"onao", "像"},
	{"onau", "俛"},
	{"onbc", "偩"},
	{"onbhu", "觎"},
	{"onbs", "𠋀"},
	{"onbuu", "覦"},
	{"oncr", "儋"},
	{"oncsh", "氛"},
	{"ond", "仔"},
	{"ondw", "氭"},
	{"onf", "你"},
	{"onfb", "㲵"},
	{"onfd", "氣"},
	{"onff", "氮"},
	{"ong", "𡌅"},
	{"onhaf", "鳹"},
	{"onhb", "僪"},
	{"onhd", "㑱"},
	{"onhe", "伋"},
	{"onhey", "氡"},
	{"onhqu", "毹"},
	{"onhs", "仍"},
	{"oni", "㐴 㒱"},
	{"onib", "俑"},
	{"onin", "伃 侈"},
	{"onir", "佲"},
	{"onjk", "㒈"},
	{"onjru", "氪"},
	{"onjv", "氨"},
	{"onk", "気"},
	{"onkc", "䫛"},
	{"onkg", "侹"},
	{"onkl", "鄇"},
	{"onkq", "健"},
	{"onks", "㔕"},
	{"onl", "伄 氕 㲴 𠇁"},
	{"onll", "氘"},
	{"onlll", "氚"},
	{"onlln", "氟"},
	{"onln", "刉 㓱"},
	{"onlwl", "氠"},
	{"onmcw", "氥"},
	{"onmk", "侯"},
	{"onmlm", "氬"},
	{"onmob", "氞"},
	{"onmtc", "氩"},
	{"onmu", "佹"},
	{"onmvm", "氫"},
	{"onmvn", "㼶"},
	{"onnhs", "氖"},
	{"onnl", "鄃"},
	{"onno", "歈 㰟"},
	{"onnom", "氢"},
	{"ono", "㐸"},
	{"onob", "偦 氝"},
	{"onog", "雂"},
	{"onok", "㩿"},
	{"onot", "僜"},
	{"onp", "忥"},
	{"onqd", "傑"},
	{"onqmb", "氰"},
	{"onri", "儳"},
	{"onrp", "㖌"},
	{"onrrj", "㲷"},
	{"onsm", "㑇"},
	{"ontq", "氧"},
	{"onu", "氙"},
	{"onvm", "㐷"},
	{"onvne", "氯"},
	{"onwa", "𠐔"},
	{"onwd", "𣱣"},
	{"onwk", "氤"},
	{"onwot", "氳"},
	{"onye", "㪁 㪂"},
	{"onyvo", "氦"},
	{"onywi", "㲶"},
	{"oo", "从"},
	{"ooa", "㫺"},
	{"ooah", "傷"},
	{"oob", "㐻"},
	{"oobg", "傕"},
	{"oobm", "俎"},
	{"oobo", "肏"},
	{"oof", "伱"},
	{"oog", "倠 坐"},
	{"ooge", "夎"},
	{"oogf", "僬"},
	{"oogs", "儁 㑺"},
	{"ooi", "㦰"},
	{"ooic", "僋"},
	{"ooii", "伶"},
	{"ooin", "仱"},
	{"ooip", "㑫"},
	{"ooir", "傖"},
	{"ooj", "仵"},
	{"ookr", "倁"},
	{"ooks", "伤"},
	{"ool", "㑖"},
	{"ooll", "价"},
	{"ooln", "劍"},
	{"oom", "丛"},
	{"ooma", "儈"},
	{"oomb", "倫 㒢"},
	{"oombc", "顩"},
	{"oombu", "䁞"},
	{"oomc", "㑟"},
	{"oomd", "俆"},
	{"oomg", "佺"},
	{"oomi", "侩"},
	{"oomm", "俭"},
	{"oomn", "偷 㐹"},
	{"oomo", "儉"},
	{"oomr", "佮"},
	{"oomv", "偸"},
	{"oon", "仡"},
	{"oond", "㑶"},
	{"oono", "歛 㰸"},
	{"ooo", "众 㐺"},
	{"ooog", "侳"},
	{"oooj", "傘"},
	{"oook", "斂"},
	{"oooo", "𠈌"},
	{"oop", "伦"},
	{"oorm", "㒆"},
	{"oosh", "劎"},
	{"ooshi", "劒"},
	{"oosj", "耸"},
	{"oosk", "劔"},
	{"oosu", "伧"},
	{"ootf", "㒇"},
	{"ootq", "儛"},
	{"oou", "佡"},
	{"oowy", "侮"},
	{"ooye", "㪘"},
	{"ooyk", "𠍁"},
	{"ooym", "㑅"},
	{"op", "伈 化"},
	{"opa", "侚"},
	{"opbo", "货"},
	{"opbuc", "貨 貸"},
	{"opbue", "䦆"},
	{"opbym", "䥾"},
	{"opd", "他 柋 㐌"},
	{"opg", "垈"},
	{"oph", "佖"},
	{"ophh", "伆"},
	{"ophms", "䥿"},
	{"ophq", "牮"},
	{"opi", "仢"},
	{"opim", "伨"},
	{"opism", "䦂"},
	{"opive", "䥽"},
	{"opj", "华"},
	{"opjiv", "䦄"},
	{"opko", "儗"},
	{"opkp", "偬"},
	{"oplb", "帒"},
	{"opmc", "傾"},
	{"opmku", "䥻"},
	{"opmo", "倾"},
	{"opmvh", "䥺"},
	{"opo", "伥"},
	{"opok", "敜"},
	{"opp", "仳"},
	{"oppa", "偕"},
	{"opphh", "䥼"},
	{"opqjl", "䦁"},
	{"opr", "佝"},
	{"opru", "佨"},
	{"opsmm", "䦀"},
	{"opt", "伳"},
	{"optd", "偞"},
	{"optja", "䦃"},
	{"opttr", "䦅"},
	{"opu", "伅 岱"},
	{"opuu", "㑳"},
	{"opwgf", "黛"},
	{"opyhv", "袋"},
	{"oq", "年 㐿"},
	{"oqbu", "儬"},
	{"oqd", "㑍"},
	{"oqhaf", "鵇"},
	{"oqhf", "𠎧"},
	{"oqhk", "偰"},
	{"oqhl", "㑜"},
	{"oqj", "仹"},
	{"oqka", "偆"},
	{"oqke", "傣"},
	{"oqki", "俦"},
	{"oqkq", "俸"},
	{"oqmb", "倩"},
	{"oqmc", "債"},
	{"oqmf", "傃"},
	{"oqmo", "债"},
	{"oqmv", "俵"},
	{"oqni", "传"},
	{"oqo", "伕"},
	{"oqoa", "僣"},
	{"oqoc", "儧"},
	{"oqs", "伟"},
	{"or", "㐰"},
	{"ora", "智"},
	{"orau", "俋"},
	{"orbc", "傊"},
	{"orbuc", "䝷"},
	{"orc", "伿"},
	{"ord", "保"},
	{"ordf", "䳰"},
	{"ordhe", "㿯"},
	{"orhaf", "鴿 鵨 鶬"},
	{"orhqu", "㲛"},
	{"orhr", "侶"},
	{"orhu", "侃 㑆"},
	{"ori", "戧"},
	{"orijb", "舖"},
	{"orikp", "龛"},
	{"orjrr", "舘"},
	{"orln", "創 㓣 㓧"},
	{"orlr", "佀"},
	{"ormbc", "頜 頷"},
	{"ormbo", "颔"},
	{"ormcw", "䣽"},
	{"ormg", "侱"},
	{"ormk", "俣"},
	{"ormvn", "㼨"},
	{"ormwt", "盫"},
	{"orn", "㐛"},
	{"ornin", "舒"},
	{"ornl", "郃"},
	{"orno", "欱"},
	{"orog", "䧻 䧾"},
	{"orok", "㑨 㪉"},
	{"orp", "𢜔"},
	{"orpym", "鸽"},
	{"orq", "㧱"},
	{"orr", "侣"},
	{"orrd", "僺"},
	{"orrj", "僤"},
	{"orrk", "儼"},
	{"orrr", "偘"},
	{"orrs", "偔"},
	{"orrxu", "鼅"},
	{"orsj", "偮"},
	{"orsmm", "䎏"},
	{"oru", "㐶"},
	{"oruc", "僎"},
	{"orvk", "俁"},
	{"orxu", "僶"},
	{"orye", "假 敆"},
	{"oryo", "促"},
	{"osav", "偃 𠍾"},
	{"osd", "榘"},
	{"oseg", "㒑"},
	{"oset", "㒘"},
	{"oshi", "仞"},
	{"oshr", "佋"},
	{"osim", "㒊"},
	{"osj", "佴"},
	{"osjj", "㒤"},
	{"osjl", "倻"},
	{"osjr", "倨"},
	{"osju", "㑙"},
	{"osk", "伊"},
	{"oskr", "侰"},
	{"osll", "𠈄"},
	{"osm", "仺"},
	{"osme", "侵 㑴"},
	{"osmg", "偓 㑌 㒛"},
	{"osmgi", "㺱"},
	{"osmh", "僇"},
	{"osmr", "伺"},
	{"osmt", "儖"},
	{"osmv", "倀"},
	{"osnd", "僝"},
	{"osno", "飮"},
	{"oso", "伬"},
	{"osoy", "侭"},
	{"osp", "伲 㤰"},
	{"osqf", "傌"},
	{"osql", "㑚"},
	{"osrj", "僻"},
	{"osrr", "傴"},
	{"oss", "佢"},
	{"osso", "㒪"},
	{"ossr", "侷"},
	{"ostt", "偋"},
	{"osu", "仓"},
	{"osuu", "倔"},
	{"ota", "借"},
	{"otaj", "䓥"},
	{"otbc", "倎"},
	{"otbg", "㒗"},
	{"otbn", "偂"},
	{"otc", "供"},
	{"otcd", "㒒"},
	{"otch", "𠊠"},
	{"otcl", "㒋 䣏"},
	{"otco", "僕 僛"},
	{"otcw", "偤"},
	{"otdd", "橆"},
	{"otf", "無"},
	{"otgi", "儀"},
	{"otgr", "僐"},
	{"othb", "備"},
	{"othn", "𠍆"},
	{"otif", "儰"},
	{"otja", "㒂"},
	{"otkr", "偌"},
	{"otlk", "偀"},
	{"otlm", "僅"},
	{"otlo", "傼"},
	{"otm", "佄"},
	{"otmc", "倛 僙"},
	{"otmv", "偡"},
	{"otniq", "舞"},
	{"otog", "儺"},
	{"otpb", "僃"},
	{"otpd", "僷"},
	{"otq", "佯"},
	{"otqm", "傞"},
	{"otrk", "儆"},
	{"otsj", "傇"},
	{"ott", "併"},
	{"ottb", "傋"},
	{"otw", "㑋 㑤"},
	{"otwa", "傮"},
	{"otwb", "㒖"},
	{"otwi", "僔 㒝"},
	{"otwn", "儚"},
	{"otwt", "僼 𥂝"},
	{"otwv", "儂"},
	{"otxc", "傔"},
	{"ou", "仙 仚 屳"},
	{"ouami", "罎"},
	{"oubb", "傰"},
	{"oubtu", "罁"},
	{"ouce", "儍"},
	{"oudk", "缺"},
	{"oudm", "缽"},
	{"ouf", "缹"},
	{"oufbh", "𦉘"},
	{"oufbq", "罉"},
	{"ouhio", "䍇"},
	{"ouhjm", "䍋"},
	{"ouhmr", "缿"},
	{"oui", "戗"},
	{"oujmn", "䍆"},
	{"oujt", "㒥"},
	{"oulmo", "罀"},
	{"ouln", "创 㓡"},
	{"oum", "缸"},
	{"oumb", "偳"},
	{"oumbc", "𩓥"},
	{"oumd", "䍂"},
	{"oumfj", "䍈"},
	{"oumvn", "缻"},
	{"oumwj", "罈"},
	{"ouni", "㑕"},
	{"ouno", "缼"},
	{"ouob", "儶"},
	{"ouog", "催"},
	{"ouoii", "䍅"},
	{"ouon", "侺"},
	{"ouos", "㒞"},
	{"oupym", "鸧"},
	{"ourc", "䍉"},
	{"ousl", "缷"},
	{"outif", "䍎"},
	{"outrg", "罐"},
	{"outt", "缾"},
	{"outwi", "罇"},
	{"ouu", "㑁 㒴"},
	{"ouwjc", "罆"},
	{"ouyck", "䍊"},
	{"ouymr", "諐"},
	{"ouypd", "罅"},
	{"ouypt", "罏"},
	{"ouypu", "𧇍"},
	{"ouyr", "䍄"},
	{"ouytr", "䍌"},
	{"ov", "亾 㚢"},
	{"ovav", "银"},
	{"ovbk", "钢"},
	{"ovbmr", "铜"},
	{"ove", "伮"},
	{"ovfb", "㒙"},
	{"ovhqo", "铁"},
	{"ovhu", "㠩"},
	{"ovii", "僟"},
	{"ovio", "似"},
	{"ovis", "㑃"},
	{"ovjbc", "镇"},
	{"ovjmo", "锭"},
	{"ovjr", "㑬"},
	{"ovl", "钟"},
	{"ovno", "㑰"},
	{"ovoi", "㒩"},
	{"ovoii", "铃"},
	{"ovp", "㤀 㥋"},
	{"ovr", "侞"},
	{"ovvd", "㑿"},
	{"ovvu", "㑎"},
	{"ovvv", "儠"},
	{"ow", "佃"},
	{"owbp", "𠏋"},
	{"owc", "伵"},
	{"owd", "倮"},
	{"owg", "俚"},
	{"owgj", "㒁"},
	{"owhaf", "䳺"},
	{"owhr", "㑼"},
	{"owj", "毎"},
	{"owjc", "𠍿"},
	{"owjr", "個"},
	{"owks", "侽"},
	{"owlb", "偶"},
	{"owlg", "儸"},
	{"owli", "㒔"},
	{"owln", "㑩"},
	{"owlv", "儇"},
	{"owml", "㑭"},
	{"owmv", "偎"},
	{"owno", "㱃"},
	{"owog", "䨄"},
	{"owp", "偲"},
	{"owr", "佪"},
	{"owvf", "傫"},
	{"owwf", "儽"},
	{"owwg", "㒦"},
	{"owww", "儡"},
	{"owyi", "每 㑄"},
	{"owyta", "韽"},
	{"oy", "仆"},
	{"oyaj", "倬"},
	{"oybb", "偙"},
	{"oybc", "偵"},
	{"oybg", "㒧"},
	{"oybo", "侦"},
	{"oybp", "儱"},
	{"oybs", "傍"},
	{"oycb", "㒀"},
	{"oyck", "佼"},
	{"oydu", "儭"},
	{"oyed", "儏 𠍇"},
	{"oyem", "㒠"},
	{"oyfe", "俶"},
	{"oyfu", "僦"},
	{"oyg", "住"},
	{"oygq", "㒓"},
	{"oyhh", "偐"},
	{"oyhn", "伉"},
	{"oyhs", "仿"},
	{"oyhv", "依"},
	{"oyhvf", "緐"},
	{"oyib", "俼"},
	{"oyjj", "僆"},
	{"oyk", "伩"},
	{"oykk", "傚"},
	{"oykl", "侪 㑪"},
	{"oyks", "俲"},
	{"oylc", "㑊"},
	{"oylm", "企"},
	{"oylr", "儙"},
	{"oym", "仩"},
	{"oymf", "㑐"},
	{"oymp", "佌"},
	{"oymr", "信"},
	{"oymt", "𠈔"},
	{"oymy", "佧"},
	{"oynv", "㒅"},
	{"oyoj", "倅"},
	{"oyok", "敏"},
	{"oypd", "偨"},
	{"oypp", "儢"},
	{"oypu", "俿"},
	{"oyqd", "𠎀"},
	{"oyr", "佔"},
	{"oyra", "儲"},
	{"oyrb", "傐"},
	{"oyrf", "倞"},
	{"oyri", "傠"},
	{"oyrn", "停"},
	{"oyro", "儫"},
	{"oyrv", "偯 儴"},
	{"oysk", "倣"},
	{"oyso", "偼"},
	{"oysv", "㒟"},
	{"oyt", "位"},
	{"oyta", "偣"},
	{"oytg", "僮"},
	{"oytj", "傽"},
	{"oyto", "𠎵"},
	{"oytp", "億"},
	{"oytr", "倍"},
	{"oytt", "傡"},
	{"oytu", "傹"},
	{"oytv", "倿"},
	{"oyub", "禽"},
	{"oyvg", "㒕"},
	{"oyvi", "伭"},
	{"oyvif", "䋣"},
	{"oyvo", "侅"},
	{"oyvv", "侫"},
	{"oyvw", "傗"},
	{"oywm", "儃"},
	{"oyx", "儕"},
	{"oyyib", "𣫺"},
	{"oyyiu", "毓"},
	{"p", "心"},
	{"pa", "旨 旬"},
	{"pabt", "愠"},
	{"pac", "銞"},
	{"pafu", "愰"},
	{"pahaf", "鶛"},
	{"pahm", "惺"},
	{"paiu", "慨"},
	{"paj", "㔬"},
	{"paks", "勓"},
	{"pam", "怛"},
	{"pamh", "愓"},
	{"pami", "㥂"},
	{"pamj", "悍"},
	{"pamo", "惿 㔭"},
	{"pan", "㥃"},
	{"panb", "憪"},
	{"pand", "㝁"},
	{"pank", "憫"},
	{"panl", "郇"},
	{"pano", "㰬"},
	{"panp", "㦖"},
	{"panu", "㦦"},
	{"panw", "㦨"},
	{"paph", "惕"},
	{"papp", "惃"},
	{"papv", "愒"},
	{"pate", "懪"},
	{"pathu", "䭫"},
	{"pav", "恨"},
	{"pavvu", "䭬"},
	{"pawe", "慢"},
	{"payf", "憬"},
	{"payk", "㥗"},
	{"pbac", "慏"},
	{"pbb", "㥊"},
	{"pbbb", "愲"},
	{"pbbe", "懓 㥅"},
	{"pbcd", "㤾"},
	{"pbcn", "惻"},
	{"pbcr", "㤯"},
	{"pbd", "㥒"},
	{"pbg", "墯"},
	{"pbgr", "惆"},
	{"pbhx", "慆"},
	{"pbjj", "惲"},
	{"pbkf", "㦓"},
	{"pbkq", "恽"},
	{"pbm", "怚"},
	{"pbmc", "惧"},
	{"pbme", "愋"},
	{"pbmp", "懚"},
	{"pbmr", "恫"},
	{"pbof", "憏"},
	{"pbon", "恻"},
	{"pbou", "愮"},
	{"pbsd", "𢛵"},
	{"pbtu", "𢜟"},
	{"pbtv", "惘"},
	{"pbu", "䀏"},
	{"pbue", "戄"},
	{"pbug", "懼"},
	{"pbuu", "悓"},
	{"pbvc", "眞"},
	{"pbvk", "慀"},
	{"pc", "惍"},
	{"pchaf", "鷆"},
	{"pci", "忪"},
	{"pcim", "慃"},
	{"pciu", "恱"},
	{"pcks", "勩"},
	{"pcmbc", "顚"},
	{"pcnh", "悌"},
	{"pcp", "𢣁"},
	{"pcru", "悅"},
	{"pcsh", "㤋"},
	{"pcwa", "憎"},
	{"pcwj", "惮"},
	{"pd", "也"},
	{"pdd", "惏"},
	{"pddf", "㦗"},
	{"pddo", "憷"},
	{"pdhaf", "鵴 𪃸"},
	{"pdhe", "怶"},
	{"pdi", "忖"},
	{"pdk", "快"},
	{"pdl", "悚"},
	{"pdlc", "懶"},
	{"pdlo", "懒"},
	{"pdm", "㤓"},
	{"pdmbc", "穎 㯋"},
	{"pdmbo", "颖"},
	{"pdmq", "愇"},
	{"pdwyi", "乸"},
	{"peee", "惙"},
	{"peg", "怪"},
	{"pei", "㣾"},
	{"peii", "慅"},
	{"pembc", "潁"},
	{"pembo", "颍"},
	{"peq", "怿"},
	{"pf", "灳"},
	{"pfb", "悄"},
	{"pfbf", "戃"},
	{"pfbg", "憆"},
	{"pfbr", "惝"},
	{"pfd", "匊"},
	{"pfdq", "憐"},
	{"pfdv", "㥪"},
	{"pff", "惔"},
	{"pffe", "㦪"},
	{"pffr", "𢥏"},
	{"pffs", "憦"},
	{"pfmbc", "熲 頴 顈"},
	{"pfmbo", "颕"},
	{"pfmu", "恍"},
	{"pfq", "怑"},
	{"pfqu", "惓"},
	{"pfuk", "悩"},
	{"pgbt", "㦉"},
	{"pgcc", "懗"},
	{"pgce", "㥄"},
	{"pgdi", "恃"},
	{"pgg", "㤬"},
	{"pggu", "憢"},
	{"pgi", "怯"},
	{"pgii", "㥘"},
	{"pgis", "㤼"},
	{"pgit", "㔩 㥺"},
	{"pglc", "㤸"},
	{"pgni", "懤"},
	{"pgow", "懎"},
	{"pgp", "𢙺"},
	{"pgr", "恄"},
	{"pgrg", "懛"},
	{"pgrr", "憘"},
	{"pgsk", "慠"},
	{"pgth", "憉"},
	{"pgtj", "悻"},
	{"ph", "必"},
	{"pha", "怕 曶 㫚"},
	{"phag", "惶"},
	{"phal", "㦢"},
	{"phbk", "懊"},
	{"phbq", "甮"},
	{"phbr", "恦"},
	{"phbt", "恤"},
	{"phbu", "䀜"},
	{"phbuu", "覕"},
	{"phcn", "懰"},
	{"phcwa", "㬟"},
	{"phdb", "憡"},
	{"phdd", "悸"},
	{"phdf", "愀"},
	{"phdn", "悧"},
	{"phdw", "憣"},
	{"phe", "㤆"},
	{"pher", "恪"},
	{"phey", "㤏"},
	{"phgr", "悎"},
	{"phgs", "慟"},
	{"phh", "勿"},
	{"phhaf", "鴓"},
	{"phhk", "𢞖"},
	{"phhn", "匑"},
	{"phhr", "匔"},
	{"phi", "愧"},
	{"phj", "忏"},
	{"phjr", "恬"},
	{"phk", "㤇"},
	{"phkb", "憍"},
	{"phkl", "㤭"},
	{"phkp", "悿"},
	{"phlc", "懫"},
	{"phln", "刎"},
	{"phlo", "惞"},
	{"phml", "忻"},
	{"phmr", "㤧"},
	{"phmso", "䝆"},
	{"phmy", "𢘛"},
	{"phn", "𢖯 𢖾"},
	{"phni", "忛 𢞁"},
	{"phnl", "邲"},
	{"phon", "㤚"},
	{"php", "忽"},
	{"phpa", "惛"},
	{"phpe", "匓"},
	{"phqm", "性"},
	{"phqo", "怢"},
	{"phs", "怍"},
	{"phsb", "惼"},
	{"phsk", "悷 憿"},
	{"phua", "㦧"},
	{"phuc", "㦫"},
	{"phvi", "怟"},
	{"phvp", "忯"},
	{"phwp", "憁"},
	{"phxc", "懙"},
	{"phxe", "㥰"},
	{"phxo", "㥚"},
	{"phyhv", "袃"},
	{"phyu", "㥴"},
	{"pi", "勺 勾"},
	{"piav", "悢"},
	{"pibi", "愽"},
	{"pice", "悛"},
	{"pidi", "懡"},
	{"pidy", "戂"},
	{"pihf", "慽"},
	{"pihi", "㤜"},
	{"pihq", "恈"},
	{"pii", "㥇"},
	{"piih", "慘"},
	{"pijb", "匍"},
	{"pijc", "怵"},
	{"pije", "㤹"},
	{"pikh", "惨"},
	{"piku", "忧"},
	{"pilb", "慵"},
	{"pile", "慷"},
	{"pim", "勻 匀"},
	{"pine", "怺"},
	{"pipc", "㦐"},
	{"pipm", "恜"},
	{"pir", "怡"},
	{"pirm", "惐"},
	{"pirp", "憾"},
	{"pit", "悈"},
	{"pitc", "懭"},
	{"piuh", "㤶"},
	{"piv", "怴"},
	{"pixp", "㦇"},
	{"piyr", "惦"},
	{"pjb", "㤄"},
	{"pjbc", "慎"},
	{"pjbd", "悖"},
	{"pjbm", "㥀"},
	{"pjbo", "懥"},
	{"pjcm", "悾"},
	{"pjcr", "愹"},
	{"pjd", "怽"},
	{"pje", "忮"},
	{"pjhaf", "鴇"},
	{"pjhp", "㤞"},
	{"pjhr", "愘"},
	{"pjii", "慱"},
	{"pjim", "懴"},
	{"pjip", "憓"},
	{"pjjl", "慚"},
	{"pjka", "㥩"},
	{"pjkp", "恅"},
	{"pjlk", "㤦"},
	{"pjlv", "悽"},
	{"pjmf", "悰"},
	{"pjmm", "愃"},
	{"pjmn", "㤖"},
	{"pjnu", "惋"},
	{"pjpa", "愭"},
	{"pjpn", "懧"},
	{"pjpym", "鸨"},
	{"pjqp", "㦥"},
	{"pjr", "怙"},
	{"pjrr", "悺"},
	{"pjsqf", "駂"},
	{"pjtc", "憤"},
	{"pjto", "愤"},
	{"pk", "匁 忕"},
	{"pkb", "㤢"},
	{"pkcf", "憭"},
	{"pkf", "恢"},
	{"pki", "忲"},
	{"pkj", "㤒"},
	{"pkja", "㦋"},
	{"pkk", "匆 㤊"},
	{"pkkb", "悕"},
	{"pkki", "恡"},
	{"pkkk", "慡"},
	{"pklb", "怖"},
	{"pkld", "𢙨"},
	{"pklg", "恠"},
	{"pklq", "肄"},
	{"pklu", "匎 㤿"},
	{"pkmb", "惰"},
	{"pkmbc", "𩓙"},
	{"pkmr", "㥓"},
	{"pkms", "恗"},
	{"pkn", "勼 恞"},
	{"pknio", "疑"},
	{"pknj", "忰"},
	{"pkno", "欵"},
	{"pkok", "愱"},
	{"pkoo", "悏"},
	{"pkp", "怱"},
	{"pkpb", "㦅"},
	{"pkql", "惭"},
	{"pkr", "㤑"},
	{"pks", "忇"},
	{"pksb", "愶"},
	{"pkss", "恊"},
	{"pl", "忡"},
	{"plbk", "怏"},
	{"plbu", "忱"},
	{"ple", "㥆"},
	{"pleg", "悭"},
	{"plgm", "㦎"},
	{"plln", "怫"},
	{"plmc", "憒"},
	{"plmo", "恌 愦"},
	{"plmy", "悱"},
	{"plp", "㥙"},
	{"plpb", "㔨"},
	{"plpc", "懻"},
	{"plsk", "悯"},
	{"plw", "怞"},
	{"plwk", "㤤"},
	{"plwv", "慺"},
	{"pmak", "懨"},
	{"pmam", "恒"},
	{"pmbb", "懦"},
	{"pmbc", "愩 頃 㥧"},
	{"pmbe", "懮"},
	{"pmbk", "愞"},
	{"pmbm", "恆"},
	{"pmbo", "顷 㦭"},
	{"pmcw", "恓"},
	{"pmf", "怀"},
	{"pmfj", "匉 怦"},
	{"pmfm", "怌"},
	{"pmfr", "㤳"},
	{"pmg", "忹"},
	{"pmhf", "㥳"},
	{"pmig", "恎"},
	{"pmik", "恹"},
	{"pmis", "恸"},
	{"pmj", "忓"},
	{"pmjp", "鸵"},
	{"pmku", "怃"},
	{"pmmi", "忶"},
	{"pmmr", "悟"},
	{"pmmu", "忨"},
	{"pmn", "忊"},
	{"pmnl", "邬"},
	{"pmnn", "㤡"},
	{"pmob", "怲"},
	{"pmrt", "㤱"},
	{"pmrw", "匐 愊"},
	{"pmtoe", "鹱"},
	{"pmua", "憯"},
	{"pmvh", "㤉"},
	{"pmwd", "慄 憟"},
	{"pmwf", "慓"},
	{"pmwj", "憛"},
	{"pmwl", "愐"},
	{"pmyf", "㥼"},
	{"pmym", "怔"},
	{"pn", "乜 忆"},
	{"pnau", "悗"},
	{"pnbk", "愌"},
	{"pnbq", "懈"},
	{"pnbs", "愑"},
	{"pncr", "憺"},
	{"pndt", "𢛴"},
	{"pnem", "㥛"},
	{"png", "忸"},
	{"pnhb", "憰"},
	{"pnhe", "忣"},
	{"pnhx", "惂"},
	{"pni", "匇"},
	{"pnib", "悀"},
	{"pnin", "恀"},
	{"pnjk", "㦑"},
	{"pnlb", "憜"},
	{"pnlm", "㦕"},
	{"pnlp", "㦩"},
	{"pnmm", "愵"},
	{"pnmu", "恑"},
	{"pno", "忺"},
	{"pnob", "㥠"},
	{"pnot", "憕"},
	{"pnsj", "㥝"},
	{"pnyi", "惤"},
	{"poae", "愎"},
	{"poah", "慯"},
	{"pod", "恘"},
	{"podi", "㤔"},
	{"pog", "惟"},
	{"poge", "愯"},
	{"pogf", "憔"},
	{"pogs", "懏"},
	{"pohg", "㤛"},
	{"poii", "怜"},
	{"poim", "懺"},
	{"poin", "忴"},
	{"poip", "惗"},
	{"poir", "愴 㤷"},
	{"poj", "忤"},
	{"poju", "匋"},
	{"poks", "勚"},
	{"poll", "忦"},
	{"poma", "懀"},
	{"pomb", "惀"},
	{"pomd", "悇"},
	{"pomg", "恮"},
	{"pomn", "愉"},
	{"pomo", "憸"},
	{"pomr", "恰"},
	{"pomvn", "㽈"},
	{"pon", "忔"},
	{"ponbg", "觺"},
	{"pond", "愾"},
	{"posu", "怆"},
	{"potf", "憮"},
	{"powy", "悔"},
	{"pp", "比 㤈"},
	{"ppa", "恂 恉"},
	{"ppad", "惸"},
	{"ppbc", "愼"},
	{"ppd", "枈"},
	{"ppdhe", "㿫"},
	{"ppfd", "粊 㥌"},
	{"ppg", "坒"},
	{"pph", "怭"},
	{"ppha", "皆"},
	{"pphp", "惚"},
	{"pphqu", "毞"},
	{"ppi", "㣿"},
	{"ppj", "毕"},
	{"ppje", "㩺"},
	{"ppko", "懝"},
	{"ppkp", "愡"},
	{"ppmnp", "毙"},
	{"ppo", "怅"},
	{"ppp", "惢 㐂"},
	{"pppd", "橤"},
	{"pppf", "繠"},
	{"pppg", "悂"},
	{"ppph", "毖"},
	{"ppr", "怐"},
	{"ppru", "怉"},
	{"ppt", "怈"},
	{"pptd", "惵"},
	{"ppu", "忳"},
	{"ppuk", "恟"},
	{"ppuu", "㥮"},
	{"ppyhv", "䘡"},
	{"pqjp", "懳"},
	{"pqke", "㥭"},
	{"pqki", "㤽"},
	{"pqmb", "情"},
	{"pqmc", "㥽"},
	{"pqmf", "愫"},
	{"pr", "句"},
	{"prau", "悒"},
	{"prb", "悁"},
	{"prbc", "愪"},
	{"prc", "怾"},
	{"prhaf", "鴝"},
	{"prhg", "悜"},
	{"prhml", "斪"},
	{"prhqu", "㲒"},
	{"prhu", "怳"},
	{"prks", "劬"},
	{"prmbc", "䪷"},
	{"prmk", "悮"},
	{"prnin", "够"},
	{"prnl", "邭"},
	{"prno", "欨"},
	{"prog", "雊"},
	{"prok", "敂"},
	{"prpa", "惽"},
	{"prpym", "鸲"},
	{"prrd", "懆"},
	{"prrj", "憚"},
	{"prrs", "愕"},
	{"prru", "㦍"},
	{"prrxu", "䵶"},
	{"pru", "包"},
	{"pruc", "㦏"},
	{"prvk", "悞"},
	{"prvp", "怋"},
	{"prxu", "憴"},
	{"psav", "愝"},
	{"pseg", "慳"},
	{"psh", "切 忉"},
	{"pshi", "㣼"},
	{"pshr", "怊"},
	{"psit", "懢"},
	{"psje", "慑"},
	{"psjj", "懾"},
	{"psju", "㤴"},
	{"psk", "怄"},
	{"psko", "愜"},
	{"pskt", "惬"},
	{"psly", "㥱"},
	{"psma", "慴"},
	{"psmg", "恇 𢣷"},
	{"psmh", "憀"},
	{"psmi", "憳"},
	{"psmr", "𢘜"},
	{"psmv", "悵"},
	{"psp", "怩"},
	{"pspd", "㥡"},
	{"psrr", "慪"},
	{"pss", "怇"},
	{"pstr", "㥾"},
	{"psu", "忋"},
	{"pt", "世"},
	{"pta", "惜"},
	{"ptaj", "愺"},
	{"ptak", "慔"},
	{"ptbc", "㥏"},
	{"ptbo", "懞"},
	{"ptbuc", "貰"},
	{"ptc", "㤨"},
	{"ptcw", "㥢"},
	{"ptd", "枼"},
	{"ptgi", "㦠"},
	{"ptgt", "㦈"},
	{"pthg", "懂"},
	{"ptkr", "𢜪"},
	{"ptlb", "慲"},
	{"ptlj", "愅"},
	{"ptlk", "愥"},
	{"ptlm", "慬"},
	{"ptm", "㤌"},
	{"ptmc", "㥍"},
	{"ptmj", "㦊"},
	{"ptms", "懄"},
	{"ptmv", "愖"},
	{"ptno", "㰥"},
	{"ptoe", "㦜"},
	{"ptor", "匒"},
	{"ptov", "懩"},
	{"ptpo", "㥞"},
	{"ptpp", "憽"},
	{"ptrg", "懽"},
	{"ptt", "恲"},
	{"ptwa", "慒"},
	{"ptwi", "懱"},
	{"ptwn", "懜"},
	{"ptwu", "懵"},
	{"ptwv", "憹"},
	{"ptxc", "慊"},
	{"ptyg", "𢤦"},
	{"ptyu", "慌"},
	{"ptyv", "恾"},
	{"pu", "屯"},
	{"pua", "旾"},
	{"pub", "胷"},
	{"puce", "惾"},
	{"pudhe", "皺"},
	{"puf", "炰"},
	{"puhaf", "鶵"},
	{"puhvo", "㼊"},
	{"puk", "匈 忷"},
	{"puln", "刨"},
	{"pumb", "惴"},
	{"pumbc", "頓"},
	{"pumbo", "顿"},
	{"pumt", "愷"},
	{"punl", "邨 鄒"},
	{"puno", "㱀"},
	{"puog", "慛 雛"},
	{"pupu", "芻"},
	{"pusu", "恺"},
	{"puu", "㤕"},
	{"pve", "怓"},
	{"pvid", "㦡"},
	{"pvis", "怮"},
	{"pvno", "㥟"},
	{"pvo", "匃"},
	{"pvsm", "乌"},
	{"pvvw", "惱"},
	{"pw", "甸"},
	{"pwb", "㥜"},
	{"pwbp", "㦙"},
	{"pwc", "怬"},
	{"pwd", "悃 惈"},
	{"pwg", "悝"},
	{"pwim", "慖"},
	{"pwjc", "慣"},
	{"pwjo", "惯"},
	{"pwkp", "𢞴"},
	{"pwlb", "㥥"},
	{"pwlg", "㦬"},
	{"pwlj", "懌"},
	{"pwlr", "㦒"},
	{"pwls", "愣"},
	{"pwlv", "懁"},
	{"pwmo", "㥵"},
	{"pwmv", "愄"},
	{"pwot", "慍"},
	{"pwp", "愢"},
	{"pwr", "恛"},
	{"pyaj", "悼"},
	{"pybs", "㥬"},
	{"pyck", "恔"},
	{"pydk", "憞"},
	{"pyfu", "憱"},
	{"pyg", "𠣕"},
	{"pyhj", "㦀"},
	{"pyhm", "㦃"},
	{"pyhn", "忼"},
	{"pyhr", "慥"},
	{"pyhs", "㤃"},
	{"pyia", "𢡠"},
	{"pyib", "㥔"},
	{"pyiu", "㤝"},
	{"pyjj", "慩"},
	{"pyk", "忟"},
	{"pykr", "悋"},
	{"pymr", "訇 𢚘"},
	{"pyoj", "悴"},
	{"pypd", "㦆"},
	{"pypm", "憈"},
	{"pypo", "懅"},
	{"pyr", "怗"},
	{"pyra", "㥫"},
	{"pyrd", "惇"},
	{"pyrf", "惊"},
	{"pyrn", "悙"},
	{"pyrv", "懹"},
	{"pysd", "枭"},
	{"pysn", "凫"},
	{"pysu", "岛"},
	{"pysv", "袅"},
	{"pyta", "愔"},
	{"pytg", "憧"},
	{"pytj", "慞"},
	{"pytp", "憶"},
	{"pytr", "㥉"},
	{"pyuk", "恼"},
	{"pyv", "忙"},
	{"pyvi", "怰"},
	{"pyvo", "㤥"},
	{"pyvu", "㤺"},
	{"pyvw", "慉"},
	{"pywd", "懍"},
	{"pywf", "懔"},
	{"pywi", "㔪"},
	{"pywm", "憻"},
	{"pywv", "懐 懷"},
	{"pyx", "懠"},
	{"pyy", "忭"},
	{"q", "手"},
	{"qa", "抇"},
	{"qabk", "㩎"},
	{"qabt", "揾 擝"},
	{"qafu", "㨪"},
	{"qahaf", "𪂹"},
	{"qail", "揤"},
	{"qaiu", "摡"},
	{"qam", "担"},
	{"qame", "𢸶"},
	{"qamh", "揚"},
	{"qami", "㧹"},
	{"qamj", "捍"},
	{"qamo", "提"},
	{"qan", "捫"},
	{"qana", "𢵧"},
	{"qanb", "撊"},
	{"qang", "撋"},
	{"qank", "捑"},
	{"qanl", "䣠"},
	{"qano", "㨛"},
	{"qanr", "擱"},
	{"qanw", "攔"},
	{"qaph", "掦"},
	{"qapp", "掍"},
	{"qapv", "揭"},
	{"qase", "撮"},
	{"qasm", "搨"},
	{"qate", "㩧"},
	{"qau", "把"},
	{"qav", "拫"},
	{"qawe", "摱"},
	{"qayf", "撔"},
	{"qb", "抈"},
	{"qbac", "㨠"},
	{"qbb", "掤"},
	{"qbbb", "搰"},
	{"qbbe", "授"},
	{"qbbhu", "靓"},
	{"qbbr", "𢰸"},
	{"qbbsd", "靜"},
	{"qbbuu", "靚"},
	{"qbcd", "探"},
	{"qbcv", "攖"},
	{"qbd", "採"},
	{"qbdi", "捋"},
	{"qbfmu", "靗"},
	{"qbhaf", "鶄"},
	{"qbhhh", "𩇕"},
	{"qbhx", "搯"},
	{"qbjj", "揮"},
	{"qbjmo", "靛"},
	{"qbk", "㧏"},
	{"qbkf", "撚"},
	{"qbkq", "挥"},
	{"qbm", "抯 㧇"},
	{"qbme", "援"},
	{"qbmr", "挏"},
	{"qbmu", "揺"},
	{"qbnau", "靘"},
	{"qbnd", "捊"},
	{"qbnl", "郬"},
	{"qbnsd", "静"},
	{"qbof", "摖"},
	{"qbomn", "靔"},
	{"qbond", "靝"},
	{"qbou", "搖"},
	{"qbov", "撄"},
	{"qbpym", "䴖"},
	{"qbq", "拥"},
	{"qbqr", "㨄"},
	{"qbsd", "掙"},
	{"qbtoe", "䨼"},
	{"qbtu", "掆"},
	{"qbu", "𢫏"},
	{"qbue", "攫"},
	{"qbug", "㩴"},
	{"qbuu", "挸"},
	{"qbv", "挼"},
	{"qbvk", "㨙"},
	{"qbwi", "㩊 㩱"},
	{"qbyr", "㨱"},
	{"qc", "扒"},
	{"qcbuu", "䚍"},
	{"qchq", "掰"},
	{"qcim", "㨣"},
	{"qcip", "捴"},
	{"qcks", "勣"},
	{"qcnh", "挮"},
	{"qcnl", "鄼"},
	{"qcno", "撳"},
	{"qcrp", "搃"},
	{"qcru", "挩"},
	{"qcsh", "扮"},
	{"qcwj", "掸"},
	{"qd", "耒"},
	{"qdam", "揸"},
	{"qdami", "䎪"},
	{"qdau", "耙"},
	{"qdb", "拺"},
	{"qdbm", "耝"},
	{"qdbms", "耡"},
	{"qdcor", "䎥"},
	{"qdd", "㨆"},
	{"qddf", "㩒"},
	{"qddhe", "耚"},
	{"qdfbr", "耥"},
	{"qdfdv", "耧"},
	{"qdff", "䎦"},
	{"qdffs", "耮"},
	{"qdfh", "耖"},
	{"qdhe", "披"},
	{"qdhqu", "耗"},
	{"qdhvo", "㼍"},
	{"qdidr", "耱"},
	{"qdir", "耛"},
	{"qdj", "抹"},
	{"qdk", "抉"},
	{"qdklu", "䎨"},
	{"qdksr", "耞"},
	{"qdl", "捒"},
	{"qdlc", "攋"},
	{"qdln", "揦"},
	{"qdlo", "摗"},
	{"qdlwv", "耬"},
	{"qdmbc", "頛"},
	{"qdmbe", "耰"},
	{"qdmmi", "耘"},
	{"qdmn", "耓"},
	{"qdmvi", "耨"},
	{"qdnd", "耔"},
	{"qdnl", "䣂"},
	{"qdomb", "耣"},
	{"qdomr", "耠"},
	{"qdon", "䎢"},
	{"qdqdd", "䆐"},
	{"qdqmc", "耫"},
	{"qdrlr", "耜"},
	{"qdss", "耟"},
	{"qdssr", "䎤"},
	{"qdta", "耤"},
	{"qdtal", "䎰 䣢"},
	{"qdtbs", "耢"},
	{"qdtlo", "䎯"},
	{"qdtoe", "耯"},
	{"qdtt", "耕"},
	{"qdttb", "耩"},
	{"qdtvi", "𦔒"},
	{"qduce", "䎫"},
	{"qdvii", "耭"},
	{"qdvio", "䎣"},
	{"qdvvw", "䎩"},
	{"qdw", "㨂"},
	{"qdwf", "揀"},
	{"qdwlb", "耦"},
	{"qdwli", "䎬"},
	{"qdwlp", "䎱"},
	{"qdybs", "耪"},
	{"qdycb", "䎮"},
	{"qdyhr", "䎭"},
	{"qdytr", "䎧"},
	{"qdywv", "耲"},
	{"qea", "㧺"},
	{"qec", "鋬"},
	{"qee", "㧐"},
	{"qeed", "搡"},
	{"qeee", "掇"},
	{"qeem", "𢶣"},
	{"qefh", "挱"},
	{"qei", "扠"},
	{"qeii", "搔"},
	{"qeli", "掻"},
	{"qemwl", "麺"},
	{"qeog", "摊"},
	{"qepfd", "麹"},
	{"qeq", "择"},
	{"qeqo", "麸"},
	{"qes", "㧟"},
	{"qfb", "捎"},
	{"qfbf", "攩"},
	{"qfbg", "摚"},
	{"qfbk", "撇"},
	{"qfbq", "撐 撑"},
	{"qfbu", "搅"},
	{"qfbw", "擋"},
	{"qfdq", "撛"},
	{"qfdv", "搂"},
	{"qff", "掞"},
	{"qffd", "㩞"},
	{"qffr", "攚"},
	{"qffs", "撈"},
	{"qfh", "抄"},
	{"qfhs", "挘"},
	{"qfhu", "毮 㨘"},
	{"qfmu", "挄"},
	{"qfpi", "䋤"},
	{"qfq", "拌"},
	{"qfqq", "搼"},
	{"qfqu", "捲"},
	{"qfsm", "挡"},
	{"qfvk", "擞"},
	{"qfyaj", "繛"},
	{"qg", "扗"},
	{"qgb", "抩"},
	{"qgbt", "撎"},
	{"qgce", "掕"},
	{"qgdi", "持"},
	{"qgg", "挂"},
	{"qggu", "撓"},
	{"qggy", "掛"},
	{"qgi", "抾"},
	{"qgit", "搕"},
	{"qgj", "㔼"},
	{"qgji", "𢴇"},
	{"qglc", "捇"},
	{"qgni", "擣"},
	{"qgr", "拮"},
	{"qgrc", "擷"},
	{"qgrg", "擡"},
	{"qgro", "撷"},
	{"qgrv", "㨬"},
	{"qgsk", "𢳆"},
	{"qha", "拍"},
	{"qhaf", "㨶"},
	{"qhag", "揘"},
	{"qhai", "𢯊"},
	{"qhal", "擳"},
	{"qham", "𢴈"},
	{"qhau", "搗"},
	{"qhbd", "㩭"},
	{"qhbf", "攥"},
	{"qhbk", "擙"},
	{"qhbu", "攪"},
	{"qhcq", "攑 㩮"},
	{"qhd", "栔"},
	{"qhdb", "㩍"},
	{"qhdf", "揪"},
	{"qhdl", "㨀"},
	{"qhdv", "捼"},
	{"qhdw", "播"},
	{"qhe", "扳 洯"},
	{"qhej", "捀"},
	{"qhen", "拠"},
	{"qher", "挌"},
	{"qhfb", "𢶠"},
	{"qhgi", "㩐"},
	{"qhgr", "捁"},
	{"qhgu", "㧥"},
	{"qhher", "㗉"},
	{"qhhj", "捭"},
	{"qhhl", "㧕"},
	{"qhhq", "㸷"},
	{"qhhv", "挀"},
	{"qhhw", "㨨"},
	{"qhio", "抸"},
	{"qhj", "扦"},
	{"qhjd", "㧣"},
	{"qhjg", "揰"},
	{"qhjl", "挿"},
	{"qhjm", "捶"},
	{"qhjr", "括"},
	{"qhju", "揗"},
	{"qhjx", "插"},
	{"qhk", "契 扷"},
	{"qhkb", "撟"},
	{"qhkk", "㧞"},
	{"qhkl", "挢"},
	{"qhkm", "𢶍"},
	{"qhko", "擌"},
	{"qhkp", "掭"},
	{"qhlc", "㩫"},
	{"qhlmi", "蛪"},
	{"qhlo", "抓 掀"},
	{"qhmb", "㩶"},
	{"qhml", "折"},
	{"qhmr", "㧨 䂮"},
	{"qhmvn", "㼤"},
	{"qhmy", "拆"},
	{"qhnb", "㧩"},
	{"qhnbg", "觢"},
	{"qhnd", "挆"},
	{"qhne", "投"},
	{"qhoa", "揝"},
	{"qhoo", "摐 𢲛"},
	{"qhor", "撘"},
	{"qhp", "恝 托"},
	{"qhpa", "捪"},
	{"qhpm", "抵"},
	{"qhq", "挈 㧳"},
	{"qhqi", "㧴"},
	{"qhqo", "抶"},
	{"qhqu", "㧌"},
	{"qhrf", "摀"},
	{"qhs", "拃"},
	{"qhsb", "掮 揙"},
	{"qhsk", "捩 撽"},
	{"qhsm", "搧"},
	{"qht", "抍"},
	{"qhtn", "擶"},
	{"qhu", "兂"},
	{"qhuc", "攢"},
	{"qhuk", "搝"},
	{"qhul", "擤"},
	{"qhuo", "擨"},
	{"qhuu", "撬"},
	{"qhv", "㛃"},
	{"qhvd", "㧰"},
	{"qhvif", "絜"},
	{"qhvl", "抑"},
	{"qhvo", "㧓"},
	{"qhvp", "扺"},
	{"qhvu", "㨮"},
	{"qhwp", "摠"},
	{"qhx", "㧮"},
	{"qhxe", "搜"},
	{"qhxh", "㧶"},
	{"qhxm", "捏 揑"},
	{"qhxu", "掜"},
	{"qhye", "搬"},
	{"qhymr", "䛚"},
	{"qhymu", "齧"},
	{"qhyu", "搋"},
	{"qi", "找"},
	{"qibi", "搏"},
	{"qibo", "贽"},
	{"qibp", "㨢"},
	{"qice", "捘"},
	{"qidq", "擵"},
	{"qidy", "攠"},
	{"qif", "热 㧠"},
	{"qig", "垫"},
	{"qih", "㧔"},
	{"qihf", "搣 摵"},
	{"qihm", "掋"},
	{"qihr", "㨔"},
	{"qihu", "抁"},
	{"qihv", "揻"},
	{"qii", "拡"},
	{"qiih", "摻"},
	{"qiil", "𢲲"},
	{"qiip", "撡"},
	{"qij", "𢫨"},
	{"qijb", "捕"},
	{"qije", "捄"},
	{"qik", "㧋"},
	{"qikf", "撝"},
	{"qikh", "掺"},
	{"qiki", "㧑"},
	{"qikj", "撪"},
	{"qikk", "拔"},
	{"qikp", "拢"},
	{"qiks", "势"},
	{"qiku", "扰"},
	{"qikw", "㨧"},
	{"qilmi", "蛰"},
	{"qilo", "掶"},
	{"qilr", "搪"},
	{"qine", "𢫕"},
	{"qing", "㨩"},
	{"qioi", "捬"},
	{"qiok", "挨"},
	{"qipd", "攈 攗"},
	{"qipf", "㩠"},
	{"qipm", "拭"},
	{"qipw", "攟"},
	{"qipym", "鸷"},
	{"qiq", "挚"},
	{"qir", "抬"},
	{"qirm", "掝"},
	{"qirp", "撼"},
	{"qis", "护"},
	{"qisk", "㩤"},
	{"qisn", "㧖"},
	{"qisu", "㨭"},
	{"qit", "拚 𢬿"},
	{"qitc", "擴"},
	{"qitf", "摭"},
	{"qive", "拨"},
	{"qivif", "絷"},
	{"qixp", "摝"},
	{"qiyr", "掂"},
	{"qj", "丯 丰"},
	{"qjb", "㧊"},
	{"qjbc", "搷"},
	{"qjbd", "挬"},
	{"qjbf", "擦 𢱢"},
	{"qjbj", "揇"},
	{"qjbk", "擜"},
	{"qjbm", "㨁"},
	{"qjbv", "攮"},
	{"qjc", "㧒"},
	{"qjcc", "攧"},
	{"qjck", "揬 𢲷"},
	{"qjcl", "撺"},
	{"qjcm", "控"},
	{"qjcn", "挖"},
	{"qjco", "搲 𢱑"},
	{"qjcq", "㨓"},
	{"qjcr", "搈 㩈"},
	{"qjcs", "搾"},
	{"qjcv", "攛"},
	{"qjd", "抺 㧲"},
	{"qje", "技"},
	{"qjhp", "挓"},
	{"qjhr", "揢"},
	{"qjhu", "抭"},
	{"qjig", "擮"},
	{"qjii", "摶"},
	{"qjim", "㩥"},
	{"qjji", "撠"},
	{"qjjj", "搟 擀"},
	{"qjjl", "摲"},
	{"qjjn", "㨴"},
	{"qjk", "扙"},
	{"qjka", "㨋"},
	{"qjkp", "㧯"},
	{"qjkr", "㨳"},
	{"qjks", "拷"},
	{"qjlo", "捷"},
	{"qjlv", "捿"},
	{"qjmc", "擯"},
	{"qjmm", "揎"},
	{"qjmn", "拧"},
	{"qjmo", "掟"},
	{"qjmr", "砉"},
	{"qjmu", "捖"},
	{"qjnau", "艳"},
	{"qjnl", "邦 鄻"},
	{"qjnu", "捥"},
	{"qjoa", "摍"},
	{"qjoc", "摈"},
	{"qjog", "㩁"},
	{"qjp", "拕"},
	{"qjpa", "搘"},
	{"qjpn", "擰"},
	{"qjpu", "挠 㨸"},
	{"qjqp", "攇"},
	{"qjqr", "搳"},
	{"qjrau", "邫"},
	{"qjrr", "捾"},
	{"qjru", "𢭪"},
	{"qjsh", "㓞"},
	{"qjsm", "彗"},
	{"qjsmf", "熭"},
	{"qjsmp", "慧"},
	{"qjtd", "㩟"},
	{"qjtf", "㩷"},
	{"qjtg", "㩙"},
	{"qjto", "攓"},
	{"qjtv", "攐"},
	{"qjty", "㩃"},
	{"qjv", "按"},
	{"qjwj", "捙"},
	{"qka", "春"},
	{"qkali", "蠢"},
	{"qkap", "惷"},
	{"qkbo", "赘"},
	{"qkbuu", "䚉"},
	{"qkce", "摋"},
	{"qkcf", "撩"},
	{"qkdi", "寿"},
	{"qke", "泰"},
	{"qkf", "拻"},
	{"qkgg", "㨒"},
	{"qkhd", "秦"},
	{"qkhk", "奏"},
	{"qkhx", "舂"},
	{"qkhxp", "憃"},
	{"qkja", "撦"},
	{"qkjon", "䵅"},
	{"qkjt", "捹"},
	{"qkkb", "𢯎"},
	{"qkkk", "摤"},
	{"qkla", "㫪"},
	{"qklb", "抪"},
	{"qkld", "拵"},
	{"qkln", "㓶"},
	{"qklu", "掩"},
	{"qkmb", "㨊"},
	{"qkmbc", "䫔"},
	{"qkmf", "捺"},
	{"qkmr", "掎"},
	{"qkms", "挎"},
	{"qkn", "挗"},
	{"qkni", "执"},
	{"qkns", "抛"},
	{"qknvm", "骜"},
	{"qknwm", "鳌"},
	{"qkoo", "挾"},
	{"qkp", "㤗 㥿"},
	{"qkpb", "摕"},
	{"qkq", "奉"},
	{"qkr", "嗸"},
	{"qkrd", "𢱌"},
	{"qks", "扐"},
	{"qksb", "搚"},
	{"qksj", "𢱕"},
	{"qkso", "摦"},
	{"qksr", "拁"},
	{"qkss", "拹"},
	{"qkt", "挟"},
	{"qkus", "拋"},
	{"qkv", "嫯"},
	{"qkvc", "拣"},
	{"qla", "晢"},
	{"qlb", "㧆"},
	{"qlbk", "抰"},
	{"qlbu", "抌 䀸"},
	{"qlc", "銴"},
	{"qldhe", "㿱"},
	{"qle", "捸"},
	{"qlf", "焎"},
	{"qlg", "埑"},
	{"qlgm", "㩇"},
	{"qlhab", "幚"},
	{"qlit", "㨫"},
	{"qliu", "揽"},
	{"qllb", "帮"},
	{"qllmi", "蜇"},
	{"qlln", "拂"},
	{"qlmc", "撌"},
	{"qlmo", "挑"},
	{"qlmr", "硩"},
	{"qlmy", "排"},
	{"qln", "乴"},
	{"qlnc", "㩌"},
	{"qloiv", "䭁"},
	{"qlp", "悊"},
	{"qlpb", "揹"},
	{"qlr", "哲"},
	{"qlryo", "踅"},
	{"qls", "扪"},
	{"qlsr", "搁"},
	{"qlv", "娎"},
	{"qlvif", "䋢"},
	{"qlvk", "擻"},
	{"qlw", "抽"},
	{"qlwe", "捜"},
	{"qlwl", "抻"},
	{"qlwp", "拽"},
	{"qlwv", "摟"},
	{"qlx", "㩋"},
	{"qlyhv", "裚"},
	{"qlymr", "誓"},
	{"qm", "扛"},
	{"qma", "𢫦"},
	{"qmak", "擫"},
	{"qmam", "𢬎"},
	{"qmb", "青"},
	{"qmbb", "擩"},
	{"qmbc", "摃"},
	{"qmbe", "擾"},
	{"qmbg", "攉"},
	{"qmbi", "㩕"},
	{"qmbk", "㨎"},
	{"qmbl", "㧫"},
	{"qmblm", "靑"},
	{"qmbo", "责"},
	{"qmbs", "摴"},
	{"qmbuc", "責"},
	{"qmbv", "𢸍"},
	{"qmbw", "擂"},
	{"qmcw", "拪"},
	{"qmd", "扜"},
	{"qmdm", "攊"},
	{"qmf", "抔"},
	{"qmfb", "擟"},
	{"qmfj", "抨"},
	{"qmfm", "抷"},
	{"qmfr", "㧵"},
	{"qmg", "抂"},
	{"qmgg", "捱"},
	{"qmgk", "㨖"},
	{"qmgn", "捯"},
	{"qmgt", "挵"},
	{"qmhe", "麦"},
	{"qmhl", "捓"},
	{"qmia", "搢"},
	{"qmig", "挃"},
	{"qmj", "扞"},
	{"qmjk", "撖"},
	{"qmkr", "㧷"},
	{"qmku", "抚"},
	{"qmky", "㩑"},
	{"qmlb", "掚"},
	{"qmlk", "挭"},
	{"qmlm", "掗"},
	{"qmlw", "㩅"},
	{"qmmi", "抎"},
	{"qmmp", "攦"},
	{"qmmr", "捂"},
	{"qmms", "扝"},
	{"qmmu", "抏"},
	{"qmmv", "振"},
	{"qmn", "打"},
	{"qmnn", "挒"},
	{"qmnr", "抲"},
	{"qmob", "抦"},
	{"qmqj", "拝"},
	{"qmr", "拓"},
	{"qmrb", "搹"},
	{"qmrdi", "夀"},
	{"qmre", "揼"},
	{"qmrr", "㩡"},
	{"qmrt", "𢭃"},
	{"qmrw", "揊"},
	{"qmso", "㧻"},
	{"qmsu", "扼"},
	{"qmtc", "挜"},
	{"qmto", "撅"},
	{"qmu", "扤"},
	{"qmua", "撍"},
	{"qmv", "表"},
	{"qmvh", "㧎"},
	{"qmvi", "搙"},
	{"qmvif", "素"},
	{"qmvm", "挳"},
	{"qmvn", "㧚"},
	{"qmwd", "搮"},
	{"qmwf", "摽"},
	{"qmwj", "撢"},
	{"qmwm", "㩖"},
	{"qmwn", "㨽"},
	{"qmwyf", "纛"},
	{"qmwyi", "毒"},
	{"qn", "㧈"},
	{"qnau", "挽"},
	{"qnbg", "捔"},
	{"qnbj", "㩂"},
	{"qnbk", "換"},
	{"qnbq", "𢶷"},
	{"qncr", "擔"},
	{"qndf", "搎"},
	{"qndt", "掹"},
	{"qnem", "拯"},
	{"qng", "扭"},
	{"qnhd", "揉"},
	{"qnhe", "扱"},
	{"qnhs", "扔"},
	{"qnhx", "掐"},
	{"qni", "专"},
	{"qnib", "捅"},
	{"qnin", "抒 拸"},
	{"qnj", "扟"},
	{"qnkg", "挺"},
	{"qnkm", "挻"},
	{"qnkq", "揵"},
	{"qnlb", "撱"},
	{"qnlo", "𢵌"},
	{"qnmm", "搦"},
	{"qnmu", "㧪"},
	{"qno", "扻"},
	{"qnob", "揟"},
	{"qnoe", "撥"},
	{"qnok", "揆"},
	{"qnot", "撜"},
	{"qnqd", "搩"},
	{"qnri", "攙"},
	{"qnsd", "挣"},
	{"qnsh", "扬"},
	{"qnsm", "㤘"},
	{"qnst", "㨕"},
	{"qnuy", "搀"},
	{"qnwa", "擼"},
	{"qo", "夫"},
	{"qoa", "替"},
	{"qoah", "摥"},
	{"qob", "抐"},
	{"qobg", "搉"},
	{"qobhu", "规"},
	{"qobuc", "賛"},
	{"qobuu", "規"},
	{"qodi", "拊"},
	{"qog", "推"},
	{"qogb", "㩦"},
	{"qoge", "㨦 㩳"},
	{"qogf", "撨"},
	{"qogs", "携"},
	{"qohaf", "鳺"},
	{"qohg", "拰"},
	{"qohh", "抮"},
	{"qoii", "拎"},
	{"qoim", "攕"},
	{"qoin", "扲"},
	{"qoip", "捻"},
	{"qoir", "搶"},
	{"qoiv", "搇"},
	{"qojwj", "輦"},
	{"qokf", "㩯"},
	{"qokq", "辇"},
	{"qoll", "扴"},
	{"qom", "拞"},
	{"qomb", "掄"},
	{"qomc", "捠"},
	{"qomd", "捈"},
	{"qomg", "拴"},
	{"qoml", "掵"},
	{"qomm", "捡"},
	{"qomn", "揄 㧉"},
	{"qomo", "撿"},
	{"qomq", "𢲡"},
	{"qomr", "拾 捨"},
	{"qomt", "揜"},
	{"qomu", "捳"},
	{"qon", "扢"},
	{"qonl", "邞"},
	{"qooa", "𢵄"},
	{"qoog", "挫"},
	{"qooo", "㧿"},
	{"qop", "抡"},
	{"qopd", "拖"},
	{"qoqo", "㚘"},
	{"qord", "㨐"},
	{"qorm", "㩉"},
	{"qorq", "搿"},
	{"qosu", "抢"},
	{"qotf", "撫"},
	{"qowy", "挴"},
	{"qoy", "扵"},
	{"qoya", "摿"},
	{"qoyb", "擒"},
	{"qp", "抋"},
	{"qpa", "指 㧦"},
	{"qpd", "扡"},
	{"qpec", "㩩"},
	{"qpfd", "掬"},
	{"qph", "㧙"},
	{"qphp", "㧾"},
	{"qpi", "扚 抅"},
	{"qpko", "擬"},
	{"qpkp", "揔"},
	{"qpmm", "揯"},
	{"qpou", "掏"},
	{"qpp", "批"},
	{"qppa", "揩"},
	{"qpr", "拘"},
	{"qpru", "抱"},
	{"qpt", "抴"},
	{"qptd", "揲"},
	{"qpu", "扽"},
	{"qpuu", "搊"},
	{"qpyr", "揈"},
	{"qpyu", "捣"},
	{"qq", "抙"},
	{"qqhaf", "䳞"},
	{"qqhk", "揳"},
	{"qqjl", "挷"},
	{"qqjp", "㩨"},
	{"qqjs", "㨹"},
	{"qqka", "𢰦"},
	{"qqkd", "搸"},
	{"qqkk", "揍"},
	{"qqkq", "捧"},
	{"qqkx", "摏"},
	{"qqmb", "掅"},
	{"qqmf", "㨞"},
	{"qqmv", "㧼"},
	{"qqni", "抟"},
	{"qqo", "扶"},
	{"qqoc", "攅"},
	{"qqoj", "攆"},
	{"qqoq", "撵"},
	{"qqou", "摫"},
	{"qqq", "掱"},
	{"qqu", "扥"},
	{"qr", "扣"},
	{"qrau", "挹"},
	{"qrb", "捐"},
	{"qrbc", "損"},
	{"qrbo", "损"},
	{"qrc", "抧"},
	{"qrhu", "拀"},
	{"qrji", "擑"},
	{"qrlb", "𢬢"},
	{"qrln", "剨"},
	{"qrmg", "挰"},
	{"qrn", "㐝"},
	{"qrpa", "㨉"},
	{"qrr", "捛"},
	{"qrrd", "操"},
	{"qrrj", "撣"},
	{"qrsh", "拐"},
	{"qrsj", "揖"},
	{"qrsn", "捌"},
	{"qruc", "撰"},
	{"qrvp", "抿"},
	{"qryo", "捉"},
	{"qs", "韦"},
	{"qsabt", "韫"},
	{"qsav", "揠"},
	{"qsbhx", "韬"},
	{"qsce", "㩔"},
	{"qseg", "摼 擓"},
	{"qsfb", "㨝"},
	{"qsh", "㧅"},
	{"qshe", "𢲈"},
	{"qshi", "扨"},
	{"qshr", "招"},
	{"qshu", "捤"},
	{"qsike", "韨"},
	{"qsit", "㩜"},
	{"qsj", "挕"},
	{"qsje", "掫"},
	{"qsjj", "攝"},
	{"qsjl", "揶"},
	{"qsjo", "摂"},
	{"qsjr", "据"},
	{"qsk", "抠"},
	{"qskr", "捃"},
	{"qslb", "㧜"},
	{"qsle", "报"},
	{"qsll", "挋"},
	{"qsm", "扫"},
	{"qsma", "摺"},
	{"qsmb", "掃"},
	{"qsmg", "握 擢"},
	{"qsmh", "摎"},
	{"qsmi", "撏"},
	{"qsmj", "㩣"},
	{"qsmm", "挧"},
	{"qsmv", "掁"},
	{"qso", "択"},
	{"qsog", "㨤"},
	{"qsokc", "䫨"},
	{"qsp", "抳"},
	{"qsql", "挪"},
	{"qsrj", "擗"},
	{"qsrr", "摳"},
	{"qss", "拒"},
	{"qsshi", "韧"},
	{"qssr", "挶"},
	{"qstt", "摒"},
	{"qstv", "搌"},
	{"qsuu", "掘"},
	{"qswu", "攬"},
	{"qsyj", "搱"},
	{"qsyq", "摨"},
	{"qta", "措"},
	{"qtak", "摸"},
	{"qtav", "擖"},
	{"qtbc", "捵"},
	{"qtbf", "攃 𢶕"},
	{"qtbh", "㨵"},
	{"qtbk", "撒"},
	{"qtbn", "揃"},
	{"qtbo", "㩚"},
	{"qtbs", "捞"},
	{"qtc", "拱"},
	{"qtcd", "擈"},
	{"qtce", "𢹸"},
	{"qtcl", "撕"},
	{"qtco", "撲"},
	{"qtct", "搤"},
	{"qtcw", "揂"},
	{"qtge", "㨾"},
	{"qtgi", "㩘 𢷮"},
	{"qtja", "擆"},
	{"qtjd", "㨲"},
	{"qtjp", "𢶤"},
	{"qtkl", "擲"},
	{"qtkr", "掿"},
	{"qtlb", "㨺"},
	{"qtlm", "㨷"},
	{"qtm", "拑"},
	{"qtmc", "掑 撗"},
	{"qtmj", "撶"},
	{"qtmm", "拦"},
	{"qtmv", "揕"},
	{"qtob", "㨅"},
	{"qtod", "搽"},
	{"qtoe", "擭"},
	{"qtog", "攤"},
	{"qtoo", "擹"},
	{"qtor", "搭"},
	{"qtov", "攁"},
	{"qtpa", "㨚"},
	{"qtpd", "擛"},
	{"qtqm", "搓"},
	{"qtqu", "撯"},
	{"qtrd", "㩰"},
	{"qtrg", "㩲"},
	{"qtrk", "擏"},
	{"qtsj", "搑"},
	{"qtt", "拼"},
	{"qttb", "搆"},
	{"qttc", "掽"},
	{"qtub", "搠"},
	{"qtw", "描"},
	{"qtwi", "撙 㩢"},
	{"qtwv", "擃"},
	{"qtxc", "搛"},
	{"qu", "击 扎 㧄"},
	{"quce", "㨑"},
	{"qud", "槼"},
	{"qumb", "揣"},
	{"qumf", "㨏"},
	{"qumrb", "鬹"},
	{"qumt", "㨟"},
	{"quob", "攜"},
	{"quog", "摧"},
	{"quos", "㩗 𢹂"},
	{"quu", "拙"},
	{"quv", "嫢"},
	{"quvif", "紥"},
	{"quwp", "㩄"},
	{"qvfb", "㨥"},
	{"qvfc", "㩪"},
	{"qvfe", "𢲩"},
	{"qvfi", "𢺳"},
	{"qvfu", "撧"},
	{"qvhaf", "䳲"},
	{"qvid", "擽"},
	{"qvio", "拟"},
	{"qvis", "抝 拗"},
	{"qvl", "㧃"},
	{"qvmi", "摪"},
	{"qvno", "掾"},
	{"qvoi", "攭"},
	{"qvvd", "摷"},
	{"qvvn", "拶"},
	{"qvvv", "擸"},
	{"qwd", "捆 捰"},
	{"qwg", "捚"},
	{"qwgf", "㩏"},
	{"qwhr", "撂"},
	{"qwim", "摑"},
	{"qwjc", "摜"},
	{"qwji", "㩛"},
	{"qwjo", "掼"},
	{"qwjr", "㧽"},
	{"qwk", "㧢"},
	{"qwkp", "摁"},
	{"qwl", "押"},
	{"qwlg", "攞"},
	{"qwli", "摆 擉"},
	{"qwlj", "擇"},
	{"qwlp", "擺"},
	{"qwlv", "擐"},
	{"qwmi", "掴"},
	{"qwmo", "㨡"},
	{"qwmv", "揋"},
	{"qwot", "搵"},
	{"qwp", "揌"},
	{"qwtj", "𢳂"},
	{"qwvf", "摞"},
	{"qwwm", "㩸 㩹"},
	{"qwwv", "攌"},
	{"qwww", "攂"},
	{"qwyi", "拇"},
	{"qxbuu", "䚎"},
	{"qxi", "㦼"},
	{"qy", "扑"},
	{"qyaj", "掉"},
	{"qybb", "揥 撾"},
	{"qybc", "揁"},
	{"qybg", "攡"},
	{"qybk", "撤 㩵"},
	{"qybp", "攏"},
	{"qybs", "搒"},
	{"qycb", "摘"},
	{"qyck", "挍"},
	{"qycv", "㨰"},
	{"qydi", "挝"},
	{"qydk", "撴"},
	{"qydl", "㨯"},
	{"qyfe", "掓"},
	{"qyfu", "㩆"},
	{"qyg", "拄"},
	{"qygq", "撻"},
	{"qyhj", "摓"},
	{"qyhn", "抗"},
	{"qyhr", "搥"},
	{"qyhs", "㧍"},
	{"qyhv", "挔"},
	{"qyij", "摔"},
	{"qyiu", "㧤 㧧"},
	{"qyj", "抖"},
	{"qyjj", "摙"},
	{"qyk", "抆"},
	{"qykl", "挤 㨈"},
	{"qykm", "摌"},
	{"qylh", "捗"},
	{"qylm", "扯"},
	{"qymb", "掯"},
	{"qymi", "㩬"},
	{"qymp", "㧗"},
	{"qymy", "拤"},
	{"qyoj", "捽"},
	{"qyok", "掖"},
	{"qypd", "摢"},
	{"qypk", "㨜 㩀"},
	{"qypm", "摣"},
	{"qypo", "據"},
	{"qypp", "攄"},
	{"qyps", "擄"},
	{"qypt", "攎"},
	{"qypu", "㨿"},
	{"qyr", "拈"},
	{"qyrb", "搞"},
	{"qyrd", "㨃"},
	{"qyrf", "掠 𢴒"},
	{"qyrn", "揨 攍 㧸"},
	{"qyro", "㩝"},
	{"qyrv", "攘"},
	{"qysd", "揓 𢰧"},
	{"qyso", "㨗"},
	{"qyt", "拉"},
	{"qyta", "揞"},
	{"qytg", "撞"},
	{"qytr", "掊"},
	{"qytu", "摬"},
	{"qytv", "接"},
	{"qyub", "摛"},
	{"qyvg", "擁"},
	{"qyvo", "㧡"},
	{"qyvq", "撁"},
	{"qyvw", "搐"},
	{"qywm", "擅"},
	{"qyx", "擠"},
	{"qyy", "抃"},
	{"qyyb", "擿"},
	{"r", "口"},
	{"raa", "唱"},
	{"rag", "㖏"},
	{"rail", "唧"},
	{"raiu", "嘅"},
	{"rajv", "𠹵"},
	{"ram", "呾"},
	{"ramh", "啺"},
	{"ramj", "哻"},
	{"ramo", "㖷"},
	{"ramw", "嗮"},
	{"ranb", "㗴"},
	{"ranh", "𠻻"},
	{"rank", "㘚"},
	{"ranr", "㗿"},
	{"ranw", "㘓"},
	{"ranx", "嚪"},
	{"rapv", "喝"},
	{"rase", "嘬"},
	{"rate", "嚗"},
	{"rau", "吧 邑"},
	{"rav", "哏"},
	{"rawe", "𠼦"},
	{"raye", "敯"},
	{"rayf", "𠾶"},
	{"rayt", "喅"},
	{"rb", "肙"},
	{"rbbb", "嗗"},
	{"rbbe", "噯 㖟"},
	{"rbbr", "喎"},
	{"rbca", "囎"},
	{"rbcv", "嚶"},
	{"rbd", "啋"},
	{"rbdi", "哷"},
	{"rbdu", "啂"},
	{"rbgr", "啁"},
	{"rbhaf", "鵑"},
	{"rbhn", "㕴"},
	{"rbhx", "㗖"},
	{"rbjj", "喗"},
	{"rbkf", "嘫"},
	{"rbln", "剐"},
	{"rbm", "咀"},
	{"rbmc", "㖵"},
	{"rbme", "喛"},
	{"rbmr", "哃"},
	{"rbmvn", "瓹"},
	{"rbnd", "哹"},
	{"rbo", "员"},
	{"rbof", "㗫"},
	{"rbou", "嗂"},
	{"rbov", "嘤"},
	{"rbpym", "鹃"},
	{"rbsd", "𠲜"},
	{"rbsmm", "翤"},
	{"rbsmr", "嗣"},
	{"rbss", "𠱂"},
	{"rbtk", "𠹻"},
	{"rbuc", "員 唄"},
	{"rbug", "㘗"},
	{"rbuu", "哯"},
	{"rbv", "哸"},
	{"rbvk", "嗘"},
	{"rbwi", "嚼"},
	{"rbyp", "𡄯"},
	{"rc", "只 叭 唫"},
	{"rcah", "𡃶"},
	{"rcbuu", "䚋"},
	{"rchaf", "鶰"},
	{"rci", "㕬"},
	{"rcim", "嗡"},
	{"rck", "㕮"},
	{"rckn", "嗲"},
	{"rcks", "勛"},
	{"rcl", "吖"},
	{"rcmbc", "䫟"},
	{"rcms", "𠯋"},
	{"rcmwv", "嘦"},
	{"rcnh", "㖒"},
	{"rcnl", "鄖"},
	{"rcno", "㰨"},
	{"rcor", "唂"},
	{"rcru", "哾"},
	{"rcsh", "吩"},
	{"rcst", "㖹"},
	{"rcte", "𡆇"},
	{"rcwa", "噌"},
	{"rcwj", "啴"},
	{"rcyq", "𡅈"},
	{"rd", "呆 㕲"},
	{"rdam", "喳"},
	{"rdd", "啉"},
	{"rddf", "噤"},
	{"rdhl", "唽"},
	{"rdhqu", "氉"},
	{"rdhr", "𠺝"},
	{"rdi", "吋"},
	{"rdjr", "喖"},
	{"rdk", "吷"},
	{"rdlc", "𡃤"},
	{"rdln", "劋 喇"},
	{"rdlo", "嗽"},
	{"rdm", "呠"},
	{"rdmg", "𠶖"},
	{"rdmk", "𠼰"},
	{"rdmq", "喡"},
	{"rdnl", "鄵"},
	{"rdoo", "唻"},
	{"rdqq", "𠾴"},
	{"rdrd", "槑"},
	{"rdrj", "𡀞"},
	{"rdw", "㖦"},
	{"rdws", "㘄"},
	{"rdyn", "𠵉"},
	{"re", "叹"},
	{"rea", "𠴲"},
	{"rebb", "𠿭"},
	{"rede", "啵"},
	{"reed", "嗓"},
	{"reee", "啜"},
	{"reev", "嘙"},
	{"refh", "唦"},
	{"rehp", "𠻹"},
	{"reiv", "𠺘"},
	{"rejf", "𡄽"},
	{"reoy", "嗨"},
	{"rf", "吙"},
	{"rfb", "哨"},
	{"rfba", "嚐"},
	{"rfbc", "嗩"},
	{"rfbg", "嘡"},
	{"rfbn", "𠸑"},
	{"rfbo", "唢"},
	{"rfbw", "噹"},
	{"rfd", "咪"},
	{"rfdj", "𠺫"},
	{"rfdq", "噒"},
	{"rfdv", "喽"},
	{"rff", "啖"},
	{"rffd", "㘇"},
	{"rffo", "㗵"},
	{"rffs", "嘮"},
	{"rfgi", "㘍"},
	{"rfh", "吵"},
	{"rfhu", "㗂"},
	{"rfkt", "𡃇"},
	{"rfmu", "咣"},
	{"rfog", "𠻘"},
	{"rfqu", "啳"},
	{"rg", "吐"},
	{"rgb", "呥"},
	{"rgbt", "噎"},
	{"rgcc", "嚇"},
	{"rgce", "㖫"},
	{"rgfe", "㘑"},
	{"rgg", "哇"},
	{"rggu", "嘵"},
	{"rggy", "啩"},
	{"rghaf", "鷕"},
	{"rgi", "呿"},
	{"rgis", "𠲵"},
	{"rgit", "嗑"},
	{"rgkc", "嚽"},
	{"rglc", "哧"},
	{"rgni", "嚋"},
	{"rgnl", "郢"},
	{"rgob", "𡁻"},
	{"rgou", "𠺬"},
	{"rgpd", "哋"},
	{"rgr", "咭"},
	{"rgrg", "㘆"},
	{"rgrr", "嘻"},
	{"rgsk", "嗷"},
	{"rgth", "嘭"},
	{"rgtj", "啈"},
	{"rgwc", "𡂝"},
	{"rgwg", "𠹺"},
	{"rgyo", "唗"},
	{"rha", "㕷"},
	{"rhad", "嘄"},
	{"rhaf", "鳴"},
	{"rhag", "喤"},
	{"rhai", "啲"},
	{"rhaj", "嗥"},
	{"rhal", "㘉"},
	{"rhap", "唣"},
	{"rhbk", "噢"},
	{"rhbn", "𠶜"},
	{"rhbr", "响"},
	{"rhbu", "咱"},
	{"rhbv", "哝"},
	{"rhcn", "嚠"},
	{"rhd", "咊"},
	{"rhda", "㗍"},
	{"rhdf", "啾"},
	{"rhdn", "唎"},
	{"rhdp", "㗭 𡀝"},
	{"rhdr", "啝"},
	{"rhds", "唀"},
	{"rhdv", "唩"},
	{"rhdw", "噃"},
	{"rhej", "㖓"},
	{"rher", "咯"},
	{"rhey", "咚"},
	{"rhfb", "𠿫"},
	{"rhfd", "呼"},
	{"rhg", "呈"},
	{"rhgf", "嚑"},
	{"rhgi", "𠲍"},
	{"rhgr", "哠"},
	{"rhgs", "㗢"},
	{"rhhe", "嚟"},
	{"rhhj", "啤"},
	{"rhhk", "㗛"},
	{"rhhv", "哌"},
	{"rhi", "𠺌 吆"},
	{"rhj", "吀"},
	{"rhjd", "咮"},
	{"rhjg", "喠"},
	{"rhjm", "唾"},
	{"rhjr", "咶"},
	{"rhjx", "喢"},
	{"rhk", "㕭"},
	{"rhkb", "嘺"},
	{"rhkp", "㖭"},
	{"rhml", "听"},
	{"rhmo", "噬"},
	{"rhmr", "㖃"},
	{"rhn", "叽"},
	{"rhnd", "哚 𠼝"},
	{"rhne", "吺"},
	{"rhni", "㕨"},
	{"rhoa", "喒"},
	{"rhoi", "嘚"},
	{"rhoiv", "䬭"},
	{"rhon", "哘 㗸 㘅"},
	{"rhoo", "嘥 㗰"},
	{"rhoq", "𠷈"},
	{"rhor", "㗳"},
	{"rhp", "吒"},
	{"rhpa", "㖧"},
	{"rhpl", "喞"},
	{"rhpm", "呧"},
	{"rhq", "吽"},
	{"rhqi", "哦"},
	{"rhqj", "㗑"},
	{"rhqo", "呹"},
	{"rhqu", "㕰"},
	{"rhr", "呂"},
	{"rhrf", "嗚"},
	{"rhrn", "𠵯"},
	{"rhs", "咋"},
	{"rhsk", "唳 噭"},
	{"rht", "呏"},
	{"rhu", "兄"},
	{"rhuc", "囋"},
	{"rhuj", "嘷"},
	{"rhuk", "嗅"},
	{"rhul", "嚊"},
	{"rhvo", "呱"},
	{"rhwg", "囖"},
	{"rhxd", "㘀"},
	{"rhxe", "嗖 㖬"},
	{"rhxu", "唲"},
	{"rhyu", "嗁"},
	{"ri", "𠯫"},
	{"riav", "哴"},
	{"ribi", "㗘"},
	{"ribp", "𠹌"},
	{"rice", "唆"},
	{"ridi", "嚒"},
	{"ridq", "嚤"},
	{"ridr", "嚰"},
	{"rifb", "𡁜"},
	{"rift", "𡅏"},
	{"rihf", "嘁"},
	{"rihm", "㖅"},
	{"rihq", "哞"},
	{"rihr", "喊"},
	{"rihu", "吮"},
	{"rihv", "喴"},
	{"riih", "嘇"},
	{"riil", "啷"},
	{"rijb", "哺"},
	{"rijc", "嘛"},
	{"rik", "吠"},
	{"rikf", "噅"},
	{"rikk", "㕹"},
	{"rikp", "咙"},
	{"riku", "㕱"},
	{"rilb", "嘃"},
	{"rill", "㖄"},
	{"rimi", "唥"},
	{"rine", "咏"},
	{"riog", "雖"},
	{"riok", "唉"},
	{"ripp", "𠳓"},
	{"rir", "咍"},
	{"rirm", "㖪"},
	{"risn", "呝"},
	{"rit", "㖑"},
	{"ritc", "嚝"},
	{"rite", "喥"},
	{"ritf", "嗻"},
	{"riuh", "哤"},
	{"riyp", "㖢"},
	{"riyr", "𠶧"},
	{"rj", "叶"},
	{"rjal", "嘟"},
	{"rjbc", "嗔"},
	{"rjbd", "哱"},
	{"rjbf", "嗦 嚓"},
	{"rjbj", "喃"},
	{"rjbm", "𠵌"},
	{"rjbo", "嚏"},
	{"rjbv", "囔"},
	{"rjca", "噾"},
	{"rjcg", "㗧"},
	{"rjcm", "啌"},
	{"rjd", "味"},
	{"rjdk", "嘋"},
	{"rje", "吱"},
	{"rjhaf", "鷤"},
	{"rjhp", "咤"},
	{"rjhq", "哰"},
	{"rjhr", "喀"},
	{"rji", "戢 戰"},
	{"rjig", "𡁶"},
	{"rjjb", "嘲"},
	{"rjji", "囀 𠽤"},
	{"rjjj", "𡆀"},
	{"rjka", "啫"},
	{"rjkd", "哮"},
	{"rjkp", "咾"},
	{"rjks", "𠱼"},
	{"rjlo", "啑"},
	{"rjlv", "啛"},
	{"rjmg", "㗌"},
	{"rjmm", "喧"},
	{"rjmmv", "辴"},
	{"rjmn", "咛"},
	{"rjmo", "啶 𠺢"},
	{"rjmu", "唍"},
	{"rjnl", "鄲"},
	{"rjnu", "啘"},
	{"rjon", "嘜"},
	{"rjp", "咜"},
	{"rjpa", "嗜"},
	{"rjpn", "嚀"},
	{"rjpu", "哓 嘧"},
	{"rjqr", "嗐"},
	{"rjr", "咕"},
	{"rjrb", "㗅"},
	{"rjrc", "𡅅"},
	{"rjrr", "𠴨"},
	{"rjru", "𠳭"},
	{"rjstv", "囅"},
	{"rjt", "𠱥"},
	{"rjtc", "噴 㘔"},
	{"rjtg", "噻"},
	{"rjto", "喷 㗷"},
	{"rjv", "咹"},
	{"rjwj", "唓"},
	{"rk", "㕦"},
	{"rka", "暋"},
	{"rkb", "哊"},
	{"rkbl", "喐"},
	{"rkbu", "睯"},
	{"rkcf", "嘹"},
	{"rkf", "咴"},
	{"rkgg", "喹"},
	{"rkhf", "唙"},
	{"rki", "吰 呔"},
	{"rkit", "㗐"},
	{"rkjt", "喯"},
	{"rkkb", "唏"},
	{"rkki", "㖁"},
	{"rklb", "咘"},
	{"rklu", "唵"},
	{"rkm", "咗"},
	{"rkmf", "㖠"},
	{"rkmr", "𠵇"},
	{"rkms", "咵"},
	{"rkn", "咦 㕤"},
	{"rkoi", "𡁯"},
	{"rkoo", "唊"},
	{"rkp", "愍"},
	{"rkpb", "㗣"},
	{"rkqi", "啭"},
	{"rkrd", "㗎"},
	{"rkrf", "𡃉"},
	{"rks", "另 叻"},
	{"rksb", "嗋"},
	{"rksj", "𠸊"},
	{"rksr", "咖"},
	{"rku", "㟩"},
	{"rlb", "吊"},
	{"rlbk", "咉"},
	{"rlbu", "㕪"},
	{"rlgm", "㗲"},
	{"rlll", "嘨"},
	{"rlln", "咈"},
	{"rlmc", "嘳"},
	{"rlmi", "虽"},
	{"rlmo", "咷"},
	{"rlmt", "嚍"},
	{"rlmy", "啡"},
	{"rlon", "𠸐"},
	{"rlq", "㖀"},
	{"rlsk", "㘎"},
	{"rlwl", "呻"},
	{"rlwp", "㖂"},
	{"rlwu", "黾"},
	{"rlwv", "嘍"},
	{"rlx", "嘯"},
	{"rm", "叿"},
	{"rma", "咟"},
	{"rmak", "嚈"},
	{"rmam", "咺"},
	{"rmamh", "踼"},
	{"rmamo", "踶"},
	{"rmang", "躙"},
	{"rmanm", "躢"},
	{"rmanw", "躝"},
	{"rmaph", "踢"},
	{"rmasm", "蹋"},
	{"rmau", "跁"},
	{"rmav", "跟"},
	{"rmb", "跀"},
	{"rmbb", "嚅 𨂃"},
	{"rmbbb", "𨃴"},
	{"rmbbr", "踻"},
	{"rmbc", "嗊 㖽"},
	{"rmbd", "踩"},
	{"rmbdi", "䟹"},
	{"rmbe", "嚘"},
	{"rmbg", "嚯"},
	{"rmbhx", "蹈"},
	{"rmbi", "嘠"},
	{"rmbkf", "蹨"},
	{"rmbl", "㖇"},
	{"rmbm", "跙 𠽌"},
	{"rmbo", "唝"},
	{"rmbou", "䠛"},
	{"rmbr", "㘊"},
	{"rmbsd", "踭"},
	{"rmbt", "跚 䟸"},
	{"rmbuc", "䟺"},
	{"rmbue", "躩"},
	{"rmbug", "躣"},
	{"rmbuk", "䠐"},
	{"rmbvk", "蹊"},
	{"rmc", "趴"},
	{"rmcw", "哂 唒"},
	{"rmcwa", "蹭"},
	{"rmd", "吁"},
	{"rmdam", "蹅"},
	{"rmdb", "䟱"},
	{"rmdhe", "跛"},
	{"rmdk", "趹"},
	{"rmdl", "踈"},
	{"rmdlc", "䠭"},
	{"rmdm", "嚦 㕶"},
	{"rmdoo", "𨂐"},
	{"rmea", "踏"},
	{"rmeb", "䠌"},
	{"rmeee", "䟾"},
	{"rmei", "䟕"},
	{"rmf", "吥"},
	{"rmfb", "踃"},
	{"rmfbg", "蹚"},
	{"rmfbh", "𨅝"},
	{"rmfbk", "䠥"},
	{"rmfbr", "䠀"},
	{"rmfbw", "𨆉"},
	{"rmfcb", "蹐"},
	{"rmfdq", "蹸"},
	{"rmffe", "躞"},
	{"rmfh", "䟞"},
	{"rmfj", "呯"},
	{"rmfm", "呸 㗏"},
	{"rmfq", "跘"},
	{"rmfqf", "䠮"},
	{"rmfqu", "踡"},
	{"rmfr", "𠳝"},
	{"rmg", "㕵"},
	{"rmgce", "踜"},
	{"rmgcg", "踛"},
	{"rmgdi", "跱"},
	{"rmgg", "啀 跬"},
	{"rmggu", "蹺"},
	{"rmgi", "䟩"},
	{"rmgil", "踋"},
	{"rmgn", "噖"},
	{"rmgni", "躊"},
	{"rmgt", "哢"},
	{"rmgyo", "跿"},
	{"rmhdf", "踿"},
	{"rmhdv", "踒"},
	{"rmhdw", "蹯"},
	{"rmheq", "跭"},
	{"rmher", "路"},
	{"rmhgu", "跣"},
	{"rmhhj", "䠋"},
	{"rmhhw", "蹓"},
	{"rmhio", "䟪"},
	{"rmhjd", "跦"},
	{"rmhjg", "踵"},
	{"rmhjo", "踬"},
	{"rmhjr", "䟯"},
	{"rmhju", "踲"},
	{"rmhk", "跃"},
	{"rmhkb", "蹻"},
	{"rmhke", "䟦"},
	{"rmhlb", "踽"},
	{"rmhlc", "躓"},
	{"rmhml", "斲"},
	{"rmhmy", "跅"},
	{"rmhnd", "跺"},
	{"rmhne", "䟝"},
	{"rmhon", "䟰"},
	{"rmhoo", "蹝 蹤"},
	{"rmhqo", "跌"},
	{"rmhs", "䟭"},
	{"rmhsb", "蹁"},
	{"rmhsk", "躈"},
	{"rmhuc", "躦"},
	{"rmhuk", "䠗"},
	{"rmhuo", "躜"},
	{"rmhvd", "跞"},
	{"rmhvi", "䟡"},
	{"rmhvp", "䟗"},
	{"rmhwp", "䠘"},
	{"rmhyu", "蹏"},
	{"rmiav", "踉"},
	{"rmice", "踆"},
	{"rmig", "咥"},
	{"rmigi", "躕"},
	{"rmihf", "䠞"},
	{"rmii", "踐"},
	{"rmiim", "䠁"},
	{"rmij", "践"},
	{"rmijc", "䟣"},
	{"rmije", "䟵"},
	{"rmikk", "跋"},
	{"rmior", "䠖"},
	{"rmir", "跆"},
	{"rmism", "𨃩"},
	{"rmite", "踱"},
	{"rmitf", "蹠"},
	{"rmiv", "䟠"},
	{"rmiwg", "躔"},
	{"rmixp", "蹗"},
	{"rmiyr", "踮"},
	{"rmjb", "䟛"},
	{"rmjbc", "蹎"},
	{"rmjbj", "𨂾"},
	{"rmjcl", "蹿"},
	{"rmjco", "䠚"},
	{"rmjcv", "躥"},
	{"rmjd", "跊"},
	{"rmje", "跂"},
	{"rmjk", "噉"},
	{"rmjka", "踷"},
	{"rmjkd", "踍"},
	{"rmjlo", "踕"},
	{"rmjmf", "踪"},
	{"rmjmn", "𨀉"},
	{"rmjnu", "踠"},
	{"rmjoa", "蹜"},
	{"rmjp", "跎"},
	{"rmjpu", "跷"},
	{"rmjr", "跍"},
	{"rmjrb", "䠒"},
	{"rmjrr", "䠉"},
	{"rmk", "吴"},
	{"rmkcf", "蹽"},
	{"rmkgg", "䠑"},
	{"rmkmr", "踦"},
	{"rmkms", "跨"},
	{"rmkn", "跠"},
	{"rmkpb", "蹛"},
	{"rmkr", "㖔"},
	{"rmks", "呖"},
	{"rmksr", "跏"},
	{"rmku", "呒"},
	{"rmky", "㗺"},
	{"rmlb", "啢"},
	{"rmle", "䠈"},
	{"rmlk", "哽"},
	{"rmlm", "啞"},
	{"rmlmc", "蹪"},
	{"rmlmo", "跳"},
	{"rmlmy", "䠊"},
	{"rmln", "㓸"},
	{"rmlq", "𨀞"},
	{"rmlwp", "跩"},
	{"rmmcw", "跴"},
	{"rmmd", "趶"},
	{"rmmf", "呩"},
	{"rmmfb", "躎"},
	{"rmmfr", "踎"},
	{"rmmgi", "𨆼"},
	{"rmmi", "呍"},
	{"rmmig", "跮"},
	{"rmmlb", "䠃"},
	{"rmmlk", "𨁈"},
	{"rmmmi", "蹰"},
	{"rmmml", "䟚"},
	{"rmmmp", "躧"},
	{"rmmmv", "䟴"},
	{"rmmn", "䟓"},
	{"rmmnr", "跒"},
	{"rmmp", "噁"},
	{"rmmpm", "䟼"},
	{"rmmr", "唔 跖"},
	{"rmmre", "𨂽"},
	{"rmmrw", "踾"},
	{"rmmt", "趼"},
	{"rmmto", "蹶"},
	{"rmmv", "㖘"},
	{"rmmvm", "踁"},
	{"rmmwu", "蹮"},
	{"rmn", "叮"},
	{"rmnbs", "踴"},
	{"rmncr", "䠨"},
	{"rmnf", "䟢"},
	{"rmnhb", "蹫"},
	{"rmnhd", "蹂"},
	{"rmnhe", "趿"},
	{"rmnib", "踊"},
	{"rmnih", "䟥"},
	{"rmnin", "跢"},
	{"rmnkq", "踺"},
	{"rmnmu", "跪"},
	{"rmnn", "咧"},
	{"rmnoe", "蹳"},
	{"rmnok", "䠏"},
	{"rmnot", "蹬"},
	{"rmnr", "呵"},
	{"rmnsd", "跥"},
	{"rmntl", "䠬"},
	{"rmob", "唡 䟜"},
	{"rmodi", "跗"},
	{"rmog", "踓"},
	{"rmohh", "跈"},
	{"rmoi", "𡁷"},
	{"rmoii", "跉"},
	{"rmoik", "䟮"},
	{"rmoin", "趻"},
	{"rmoip", "踗"},
	{"rmoir", "蹌"},
	{"rmokr", "踟"},
	{"rmom", "䟬"},
	{"rmomb", "踚 䠯"},
	{"rmomd", "䟻"},
	{"rmomg", "跧"},
	{"rmomn", "踰"},
	{"rmomr", "跲"},
	{"rmon", "趷"},
	{"rmoog", "䟶"},
	{"rmooo", "踨"},
	{"rmora", "䠦"},
	{"rmorm", "蹹"},
	{"rmosu", "跄"},
	{"rmoto", "𨆯"},
	{"rmotq", "躌"},
	{"rmou", "𠶲"},
	{"rmowy", "踇"},
	{"rmoym", "𨀣"},
	{"rmpfd", "踘"},
	{"rmph", "䟤"},
	{"rmpi", "趵"},
	{"rmpmc", "蹞"},
	{"rmppj", "跸"},
	{"rmpr", "跔"},
	{"rmpru", "跑"},
	{"rmpsh", "䟙"},
	{"rmpt", "跇"},
	{"rmptd", "蹀"},
	{"rmqd", "𨀤"},
	{"rmqhl", "䟷"},
	{"rmqka", "踳"},
	{"rmqki", "踌"},
	{"rmqkx", "蹖"},
	{"rmqmc", "蹟"},
	{"rmqo", "趺"},
	{"rmr", "𠰴"},
	{"rmrb", "嗝"},
	{"rmrbc", "䠝"},
	{"rmre", "㗞"},
	{"rmrj", "𠹶"},
	{"rmrr", "𠹭"},
	{"rmrrd", "躁"},
	{"rmrrj", "䠤"},
	{"rmrse", "䠍"},
	{"rmrt", "哣"},
	{"rmruc", "䠣"},
	{"rmrvp", "䟨"},
	{"rmryo", "踀"},
	{"rmsei", "䠱"},
	{"rmseo", "䠫"},
	{"rmsja", "䠧"},
	{"rmsje", "踙"},
	{"rmsjj", "躡"},
	{"rmsjr", "踞"},
	{"rmsju", "踂"},
	{"rmsmg", "躍 䠎"},
	{"rmsmh", "蹘"},
	{"rmsmv", "䠆"},
	{"rmso", "啄"},
	{"rmsp", "跜"},
	{"rmsrj", "躃"},
	{"rmss", "距"},
	{"rmssr", "跼"},
	{"rmstv", "蹍"},
	{"rmsu", "呃"},
	{"rmsup", "跽"},
	{"rmsuu", "䠇"},
	{"rmswu", "𨈇"},
	{"rmt", "咞"},
	{"rmta", "踖"},
	{"rmtag", "躪"},
	{"rmtb", "𡂖"},
	{"rmtbc", "䠄"},
	{"rmtc", "哑"},
	{"rmtce", "躨"},
	{"rmtco", "蹼"},
	{"rmtcw", "䠓"},
	{"rmtja", "躇"},
	{"rmtkl", "躑"},
	{"rmtkr", "蹃"},
	{"rmtlb", "蹣"},
	{"rmtlg", "躏"},
	{"rmtmb", "蹒"},
	{"rmtmc", "踑"},
	{"rmtmj", "𨅯"},
	{"rmtmv", "踸"},
	{"rmto", "噘"},
	{"rmtpo", "䠔"},
	{"rmtqa", "躤"},
	{"rmtqm", "蹉"},
	{"rmtrg", "䠰"},
	{"rmtsj", "䠜"},
	{"rmtt", "跰"},
	{"rmttc", "踫"},
	{"rmtwa", "蹧"},
	{"rmtwi", "蹲"},
	{"rmu", "䟖"},
	{"rmua", "噆"},
	{"rmubb", "蹦"},
	{"rmue", "嗄"},
	{"rmuhi", "𨅏"},
	{"rmui", "嘎"},
	{"rmumb", "踹"},
	{"rmuw", "𠵾"},
	{"rmvh", "呀"},
	{"rmvi", "嗕"},
	{"rmvid", "躒"},
	{"rmvim", "躖"},
	{"rmvmi", "蹡"},
	{"rmvn", "咓"},
	{"rmvne", "䟿"},
	{"rmvs", "号"},
	{"rmvvi", "䠪"},
	{"rmvvv", "躐"},
	{"rmw", "䟧"},
	{"rmwc", "𠿪"},
	{"rmwd", "踝 㗚"},
	{"rmwf", "嘌"},
	{"rmwg", "喱 㖶"},
	{"rmwhd", "䠅"},
	{"rmwj", "嘾"},
	{"rmwjc", "躀"},
	{"rmwl", "喕"},
	{"rmwli", "躅"},
	{"rmwtj", "蹕"},
	{"rmwv", "喓"},
	{"rmwyi", "𧿹"},
	{"rmy", "吓 䟔"},
	{"rmyaj", "踔"},
	{"rmyav", "蹆"},
	{"rmybb", "蹄"},
	{"rmybp", "躘"},
	{"rmybs", "䠙"},
	{"rmycb", "蹢"},
	{"rmyck", "跤"},
	{"rmydk", "蹾"},
	{"rmyf", "嘕"},
	{"rmyfe", "踧"},
	{"rmyfu", "蹴"},
	{"rmyg", "跓"},
	{"rmygq", "躂"},
	{"rmyhj", "跹"},
	{"rmyhn", "䟘"},
	{"rmyhs", "趽"},
	{"rmyij", "𨄮"},
	{"rmyiu", "䟲 䟽"},
	{"rmyjj", "蹥"},
	{"rmyk", "跶"},
	{"rmykl", "跻"},
	{"rmylc", "跡"},
	{"rmylh", "踄"},
	{"rmylm", "趾"},
	{"rmymh", "䠩"},
	{"rmymp", "跐"},
	{"rmymu", "躚"},
	{"rmyoj", "踤"},
	{"rmypd", "䠕"},
	{"rmypm", "䠡"},
	{"rmypo", "躆"},
	{"rmyr", "跕"},
	{"rmyrv", "躟"},
	{"rmytg", "蹱"},
	{"rmytr", "踣"},
	{"rmytv", "踥"},
	{"rmyx", "躋"},
	{"rnbg", "唃 𡃏"},
	{"rnbj", "嘝"},
	{"rnbk", "喚"},
	{"rnbs", "㗈"},
	{"rncr", "噡"},
	{"rnd", "吇"},
	{"rndt", "𠵼"},
	{"rndu", "吼"},
	{"rne", "𠱁"},
	{"rng", "吜 𡋾"},
	{"rnhb", "噊"},
	{"rnhd", "㖻"},
	{"rnhe", "吸"},
	{"rnhs", "𠮨"},
	{"rnhx", "啗"},
	{"rnin", "哆"},
	{"rnir", "𠱷"},
	{"rniy", "𠰻"},
	{"rnkm", "唌"},
	{"rnl", "吲"},
	{"rnlb", "𡃴"},
	{"rnlf", "𡁸"},
	{"rnlm", "唨 𠾐"},
	{"rnlr", "啊"},
	{"rnmk", "㗋"},
	{"rnmu", "𠱓"},
	{"rnn", "𠮩"},
	{"rno", "吹"},
	{"rnoe", "㗶"},
	{"rnot", "噔"},
	{"rnqd", "𠹳"},
	{"rnri", "嚵"},
	{"rnsp", "喼"},
	{"rnvm", "吗"},
	{"rnwa", "嚕"},
	{"rnxu", "𪚩"},
	{"ro", "叺 㕥"},
	{"rob", "吶"},
	{"robq", "𤰉"},
	{"rod", "咻"},
	{"rodi", "咐"},
	{"rof", "焁"},
	{"rog", "唯 㘴"},
	{"rogd", "㗱"},
	{"rogf", "噍"},
	{"rogp", "㗹"},
	{"rohe", "𠿬"},
	{"rohf", "喺"},
	{"roic", "嗿"},
	{"roif", "𠼮"},
	{"roii", "呤"},
	{"roin", "吟"},
	{"roip", "唸 𠰺"},
	{"roir", "唅 嗆"},
	{"roiv", "喰 𠹸"},
	{"roj", "吘"},
	{"rok", "呚"},
	{"roks", "勋"},
	{"roll", "吤"},
	{"rom", "𠰋"},
	{"roma", "噲"},
	{"romb", "㖮"},
	{"romd", "唋"},
	{"romi", "哙"},
	{"roml", "啣 𠵴"},
	{"romm", "噏"},
	{"romn", "喻"},
	{"romo", "噞"},
	{"romq", "嗱"},
	{"romr", "哈 啥"},
	{"romt", "啽"},
	{"romv", "喩"},
	{"ron", "吃"},
	{"rond", "𠺪"},
	{"ronk", "喉"},
	{"ronl", "郧"},
	{"roob", "𠹹"},
	{"roog", "唑"},
	{"rop", "吪"},
	{"ropd", "咃"},
	{"ropj", "哗"},
	{"roq", "哖"},
	{"rorp", "㘛"},
	{"rosk", "咿"},
	{"rosmm", "䟳"},
	{"ross", "𠳔"},
	{"rosu", "呛"},
	{"rotf", "嘸"},
	{"roto", "𡂈"},
	{"roud", "嚹"},
	{"roum", "𠼭"},
	{"rowr", "嗰"},
	{"royb", "噙"},
	{"roym", "㖉"},
	{"royv", "𠵱"},
	{"rp", "叱 吣 𠮟"},
	{"rpa", "咰"},
	{"rpbmr", "㖰"},
	{"rpcsh", "哛"},
	{"rpd", "吔"},
	{"rph", "咇"},
	{"rphaf", "鴖"},
	{"rphh", "吻"},
	{"rphp", "唿"},
	{"rpim", "呁"},
	{"rpko", "㘈"},
	{"rplii", "蟁"},
	{"rpln", "刡"},
	{"rpmbc", "䪸"},
	{"rpok", "敃"},
	{"rpoll", "㖎"},
	{"rpou", "啕"},
	{"rpp", "吡"},
	{"rppa", "喈"},
	{"rppj", "哔"},
	{"rpr", "呴"},
	{"rpru", "咆"},
	{"rpt", "呭"},
	{"rptd", "喋"},
	{"rpu", "吨"},
	{"rpuc", "噸"},
	{"rpuk", "哅"},
	{"rpuu", "㗙"},
	{"rpvk", "㕼"},
	{"rpvm", "呜"},
	{"rpwp", "㥸"},
	{"rpym", "鸣"},
	{"rqam", "𠵆"},
	{"rqbu", "𡃁"},
	{"rqde", "𠵿"},
	{"rqdm", "𠾵"},
	{"rqfh", "𠳕"},
	{"rqha", "啪"},
	{"rqhf", "噄"},
	{"rqhk", "喫"},
	{"rqhl", "哳"},
	{"rqhu", "囓"},
	{"rqhw", "𡃓"},
	{"rqj", "㕩"},
	{"rqjm", "嘒"},
	{"rqjp", "嚖"},
	{"rqka", "㖺"},
	{"rqkd", "嗪"},
	{"rqkq", "唪"},
	{"rqmb", "啨"},
	{"rqmc", "嘖"},
	{"rqme", "唛"},
	{"rqmf", "嗉"},
	{"rqmm", "𠻺"},
	{"rqmn", "咑"},
	{"rqmo", "啧"},
	{"rqne", "𠳖"},
	{"rqo", "呋"},
	{"rqyg", "𡃵"},
	{"rqyj", "唞"},
	{"rqym", "𠳏"},
	{"rqyt", "啦"},
	{"rr", "吕"},
	{"rrau", "唈"},
	{"rrbnq", "䑝"},
	{"rrbyj", "斝"},
	{"rrc", "呮"},
	{"rrf", "喣"},
	{"rrhaf", "鷺"},
	{"rrhn", "咒"},
	{"rrhu", "呪"},
	{"rrik", "哭 獸"},
	{"rrikr", "器"},
	{"rrill", "喌"},
	{"rrmcr", "囂"},
	{"rrmjs", "咢"},
	{"rrmmk", "嚴"},
	{"rrmms", "咢"},
	{"rrmor", "嚣"},
	{"rrmr", "噐 𡀔"},
	{"rrms", "呺"},
	{"rrmvs", "㕺"},
	{"rrnl", "郘"},
	{"rrnvm", "骂"},
	{"rrob", "㖞"},
	{"rrpa", "㗃"},
	{"rrpym", "鹭"},
	{"rrr", "品"},
	{"rrrd", "喿 噪"},
	{"rrrh", "𠻝"},
	{"rrrj", "嘽"},
	{"rrrk", "㘙"},
	{"rrrr", "碞 㗊"},
	{"rrrs", "㗁"},
	{"rrru", "喦 嵒"},
	{"rrsk", "㖐"},
	{"rrslr", "嚚"},
	{"rrsn", "哵"},
	{"rrsqf", "駡"},
	{"rrtu", "㖾"},
	{"rruc", "噀"},
	{"rrvlr", "嘂"},
	{"rrvp", "呡"},
	{"rrw", "㽞"},
	{"rrwj", "單"},
	{"rrwmr", "嘼"},
	{"rrwmu", "鼉"},
	{"rrye", "㗇"},
	{"rryo", "哫"},
	{"rs", "㕧"},
	{"rsbn", "唰"},
	{"rsbuu", "覨"},
	{"rsec", "㘋"},
	{"rsef", "𡁵"},
	{"rsf", "𤏩"},
	{"rsfk", "㘐"},
	{"rsh", "叨"},
	{"rshaf", "鴞 鶚"},
	{"rshb", "嘱"},
	{"rshu", "𠳿"},
	{"rshwj", "㗗"},
	{"rsit", "嚂"},
	{"rsj", "咠 咡"},
	{"rsje", "嗫 㖩"},
	{"rsjj", "囁"},
	{"rsjl", "㖿 㗦"},
	{"rsjr", "啹"},
	{"rsk", "吚 呕"},
	{"rsl", "叩"},
	{"rslb", "咂"},
	{"rsll", "𠱸"},
	{"rsln", "別 㓵"},
	{"rsm", "叼"},
	{"rsma", "㗩"},
	{"rsmbc", "顎 䪽"},
	{"rsmbo", "颚"},
	{"rsme", "唚"},
	{"rsmg", "哐 喔 嚁"},
	{"rsmh", "嘐"},
	{"rsmi", "噚 㖊"},
	{"rsmj", "噿"},
	{"rsmr", "呞"},
	{"rsnl", "鄂"},
	{"rso", "呎"},
	{"rsoiv", "飸"},
	{"rsp", "呢"},
	{"rspym", "鹗"},
	{"rsqf", "嗎"},
	{"rsql", "哪"},
	{"rsrj", "噼"},
	{"rsro", "𡂿"},
	{"rsrr", "嘔"},
	{"rss", "𠰠"},
	{"rssec", "䫗"},
	{"rsseo", "㰺"},
	{"rssl", "卾"},
	{"rssu", "𠱃"},
	{"rsuu", "啒"},
	{"rswu", "囕"},
	{"rsyi", "囑"},
	{"rsypu", "號"},
	{"rta", "唶"},
	{"rtak", "嗼"},
	{"rtav", "噶"},
	{"rtaw", "囒"},
	{"rtbc", "唺"},
	{"rtbo", "𡁏"},
	{"rtbs", "唠"},
	{"rtc", "哄"},
	{"rtcd", "㗼"},
	{"rtcg", "𠼻"},
	{"rtcl", "嘶"},
	{"rtco", "噗"},
	{"rtct", "嗌"},
	{"rtgf", "㗝"},
	{"rtgi", "嚉 囈"},
	{"rtgk", "𠸍"},
	{"rtgu", "唴"},
	{"rthv", "𠾭"},
	{"rtj", "𠯢"},
	{"rtjg", "嚡"},
	{"rtjp", "㗾"},
	{"rtjs", "嘞"},
	{"rtk", "咲 哎"},
	{"rtkp", "㘃"},
	{"rtkr", "喏 𠸏"},
	{"rtlf", "嚥"},
	{"rtlj", "㗆"},
	{"rtlk", "𠸄"},
	{"rtlo", "嘆"},
	{"rtm", "咁"},
	{"rtmc", "唭"},
	{"rtmd", "㖼"},
	{"rtmj", "嘩"},
	{"rtmv", "啿"},
	{"rtn", "呓"},
	{"rtnd", "囌"},
	{"rtod", "嗏"},
	{"rtoe", "嚄"},
	{"rtoi", "𠸖"},
	{"rtor", "嗒 嗬"},
	{"rtox", "嚿"},
	{"rtph", "㖴"},
	{"rtq", "咩"},
	{"rtqm", "嗟"},
	{"rtrg", "嚾"},
	{"rtst", "㘕"},
	{"rttb", "㗕"},
	{"rtub", "嗍"},
	{"rtui", "嗴"},
	{"rtvi", "嗞"},
	{"rtvp", "㘂"},
	{"rtw", "喵 㖆"},
	{"rtwa", "嘈"},
	{"rtwb", "噧"},
	{"rtwi", "噂 囆"},
	{"rtwv", "噥"},
	{"rtxc", "嗛"},
	{"rtyb", "嚆"},
	{"rtyj", "𡂴"},
	{"ru", "巳 𠮿"},
	{"rubb", "嘣"},
	{"rudi", "导"},
	{"rug", "㙱"},
	{"ruhjj", "𢁅"},
	{"ruhne", "㱼"},
	{"ruhr", "𠸉"},
	{"ruk", "㕳"},
	{"rukb", "𨚼"},
	{"rumb", "喘"},
	{"rumc", "巺"},
	{"rumg", "嘊"},
	{"rumi", "嗤"},
	{"rumr", "啱"},
	{"rune", "㖤"},
	{"runi", "哕"},
	{"runl", "鄳 䣞"},
	{"runo", "㰝"},
	{"ruog", "嗺"},
	{"ruoiv", "饕"},
	{"ruok", "攺"},
	{"ruon", "㖗"},
	{"rurau", "䣈"},
	{"rurhu", "㒭"},
	{"rutc", "巽"},
	{"ruu", "咄"},
	{"ruvi", "㗀"},
	{"rv", "𠯆"},
	{"rve", "呶"},
	{"rveq", "𠸎"},
	{"rvfb", "𠺶"},
	{"rvff", "噝"},
	{"rvfh", "𠴕"},
	{"rvfi", "喲"},
	{"rvfj", "𡃈"},
	{"rvfu", "𠾼"},
	{"rvhi", "𠹷"},
	{"rvi", "吆"},
	{"rvid", "嚛"},
	{"rvii", "嘰"},
	{"rvio", "㕽"},
	{"rvis", "呦 𠯻"},
	{"rvjd", "𠵈"},
	{"rvjr", "𠵎"},
	{"rvl", "叫"},
	{"rvmi", "哟"},
	{"rvnc", "呉"},
	{"rvne", "㖨"},
	{"rvnk", "吳"},
	{"rvno", "喙"},
	{"rvp", "民"},
	{"rvvm", "咝"},
	{"rvvu", "嗈"},
	{"rwb", "喟"},
	{"rwc", "呬"},
	{"rwfr", "嚸"},
	{"rwg", "哩"},
	{"rwgf", "嘿"},
	{"rwgg", "嚜"},
	{"rwgn", "嘢"},
	{"rwhd", "㖥"},
	{"rwim", "嘓"},
	{"rwjr", "𠴱"},
	{"rwk", "咽"},
	{"rwkp", "嗯"},
	{"rwks", "𠲸"},
	{"rwl", "呷"},
	{"rwlb", "喁"},
	{"rwlc", "嘪"},
	{"rwlg", "囉"},
	{"rwli", "噣"},
	{"rwlj", "㘁"},
	{"rwln", "啰"},
	{"rwls", "㗄"},
	{"rwlv", "噮"},
	{"rwmi", "啯"},
	{"rwmv", "喂"},
	{"rwnl", "鄙"},
	{"rwot", "嗢"},
	{"rwtj", "嗶"},
	{"rwvf", "𠼱"},
	{"rwyi", "呣"},
	{"rxu", "黽"},
	{"ry", "卟"},
	{"ryaj", "啅"},
	{"ryao", "噷"},
	{"rybb", "啼 㗻"},
	{"rybg", "囄"},
	{"rybk", "囐"},
	{"rybp", "嚨"},
	{"rybs", "嗙"},
	{"ryc", "𠯿"},
	{"rycb", "嘀"},
	{"ryck", "咬"},
	{"rydg", "囃"},
	{"rydk", "噋"},
	{"rydl", "噺 㗥"},
	{"rydu", "嚫"},
	{"ryfu", "噈"},
	{"ryg", "𠰍"},
	{"rygq", "噠"},
	{"ryhc", "嚬 㘖"},
	{"ryhh", "喭"},
	{"ryhn", "吭"},
	{"ryhr", "㗓"},
	{"ryhs", "㕫"},
	{"ryhv", "𠲖"},
	{"ryib", "唷"},
	{"ryid", "𠾍"},
	{"ryj", "呌"},
	{"ryjj", "嗹"},
	{"ryk", "呅"},
	{"rykl", "哜"},
	{"rylm", "⻊"},
	{"rymb", "啃"},
	{"rymh", "噦"},
	{"rymp", "呲"},
	{"rymr", "唁"},
	{"rymu", "嚙"},
	{"rymy", "咔"},
	{"rynb", "嗵"},
	{"ryo", "足"},
	{"ryoe", "𡃀"},
	{"ryoj", "啐"},
	{"ryok", "㖡"},
	{"ryon", "㘌"},
	{"rypb", "嘴"},
	{"rypc", "嘘"},
	{"rypd", "喍 嘑"},
	{"rypf", "㗪"},
	{"rypk", "噳 㗔"},
	{"rypm", "噓 㖸"},
	{"rypo", "噱"},
	{"rypt", "嚧"},
	{"rypu", "唬"},
	{"ryr", "呫"},
	{"ryrb", "嗃"},
	{"ryrd", "啍"},
	{"ryrn", "哼"},
	{"ryro", "嚎"},
	{"ryru", "喨"},
	{"ryrv", "嚷 㗒"},
	{"ryse", "叚"},
	{"rysk", "嗾"},
	{"ryso", "𠸝"},
	{"rysy", "唹"},
	{"ryt", "㕸"},
	{"ryta", "喑"},
	{"rytg", "噇"},
	{"ryti", "嚱"},
	{"rytj", "㖕"},
	{"rytp", "噫"},
	{"rytr", "㖣"},
	{"rytv", "唼"},
	{"ryub", "𠻗"},
	{"ryvg", "噰"},
	{"ryvi", "呟"},
	{"ryvo", "咳"},
	{"ryvw", "㗜"},
	{"rywe", "嚃"},
	{"rywo", "嚺 𠺖"},
	{"rywr", "啚"},
	{"ryx", "嚌"},
	{"s", "尸"},
	{"sahaf", "鷵"},
	{"sahni", "飁"},
	{"sai", "㦻"},
	{"sammu", "翫"},
	{"sanl", "䣝"},
	{"sau", "㞎"},
	{"sav", "匽"},
	{"sbcc", "屭"},
	{"sbe", "㕞"},
	{"sbhg", "朢"},
	{"sbln", "刷 㔉"},
	{"sbo", "屃"},
	{"sbuc", "屓"},
	{"sbug", "匷"},
	{"sc", "匹"},
	{"scb", "㞕"},
	{"schaf", "鴄"},
	{"schne", "殿"},
	{"scwa", "層"},
	{"sd", "杘"},
	{"sdb", "㞖"},
	{"se", "尿 㞋"},
	{"seb", "腎 臀 㬾"},
	{"sebu", "瞖 䁂"},
	{"sebuc", "賢 贀"},
	{"sec", "鋻"},
	{"sed", "棸"},
	{"sef", "焣 㷂 㷅"},
	{"seg", "埾 堅 壂 㙠"},
	{"sehaf", "鷖"},
	{"sehde", "䵖"},
	{"sehq", "㹂"},
	{"selmi", "蜸 䗟"},
	{"sembo", "颞"},
	{"semcw", "醫"},
	{"semgi", "瑿 𤩱"},
	{"semoo", "毉"},
	{"semr", "硻 䃜"},
	{"semrt", "豎 䝂"},
	{"send", "孯"},
	{"seobo", "臋"},
	{"seog", "匯"},
	{"seooo", "聚"},
	{"sepym", "鹥"},
	{"seq", "掔"},
	{"ser", "㗨"},
	{"sesmm", "翳"},
	{"seu", "㞑"},
	{"sev", "娶 婜 嫛"},
	{"sevif", "緊 繄"},
	{"sewgf", "黳"},
	{"seyt", "竪"},
	{"sfa", "馹"},
	{"sfaa", "䮖"},
	{"sfabt", "𩥈"},
	{"sfajv", "騴"},
	{"sfamj", "駻"},
	{"sfamo", "騠"},
	{"sfapp", "騉"},
	{"sfapv", "騔"},
	{"sfb", "屑"},
	{"sfbbb", "䮩"},
	{"sfbbr", "騧"},
	{"sfbbu", "䮭"},
	{"sfbcr", "䮐"},
	{"sfbdi", "䮑"},
	{"sfbgr", "騆"},
	{"sfbhx", "𩥅"},
	{"sfbjj", "䮝"},
	{"sfbm", "駔"},
	{"sfbmr", "駧"},
	{"sfbr", "駉"},
	{"sfbvk", "騱"},
	{"sfck", "䭸"},
	{"sfcru", "駾"},
	{"sfcsh", "䭻"},
	{"sfcwa", "驓"},
	{"sfd", "屎"},
	{"sfdhe", "駊"},
	{"sfdi", "尉 㷉"},
	{"sfdk", "駃"},
	{"sfdl", "駷"},
	{"sfdoo", "騋"},
	{"sfdv", "屡"},
	{"sfe", "馭"},
	{"sfeed", "䮣"},
	{"sfeee", "䮕"},
	{"sfeii", "騷"},
	{"sfeli", "騒"},
	{"sff", "㷦"},
	{"sffdq", "驎"},
	{"sfffq", "䮼"},
	{"sffmu", "駫"},
	{"sffqf", "驣"},
	{"sffwj", "騨"},
	{"sfgbd", "驝"},
	{"sfgce", "䮚"},
	{"sfgcg", "𩣱"},
	{"sfggu", "驍"},
	{"sfgi", "䮃"},
	{"sfgni", "䮻"},
	{"sfhae", "騡"},
	{"sfhag", "騜"},
	{"sfhdp", "騬"},
	{"sfhdw", "䮳"},
	{"sfher", "駱"},
	{"sfhgu", "駪"},
	{"sfhhl", "駠"},
	{"sfhhw", "騮"},
	{"sfhi", "騩"},
	{"sfhjd", "駯"},
	{"sfhjm", "䮔"},
	{"sfhjx", "䮢"},
	{"sfhkb", "驕"},
	{"sfhml", "馸"},
	{"sfhni", "颿 䭵"},
	{"sfhp", "馲"},
	{"sfhq", "䭽"},
	{"sfhqi", "騀"},
	{"sfhqo", "䭿"},
	{"sfhqu", "䭷"},
	{"sfhsb", "騙"},
	{"sfhsm", "騸"},
	{"sfhvl", "䭹"},
	{"sfhwp", "驄"},
	{"sfhxe", "騪"},
	{"sfhxu", "䮘"},
	{"sfiav", "駺"},
	{"sfice", "駿"},
	{"sfihu", "馻"},
	{"sfiih", "驂"},
	{"sfij", "駥"},
	{"sfijb", "䮒"},
	{"sfik", "䭾"},
	{"sfikk", "䮂"},
	{"sfiku", "駀"},
	{"sfill", "駲"},
	{"sfiok", "騃"},
	{"sfiop", "𩥝"},
	{"sfipf", "䮽"},
	{"sfir", "駘"},
	{"sfirm", "䮙"},
	{"sfis", "馿"},
	{"sfist", "𩦝"},
	{"sfit", "駴 䮁"},
	{"sfitc", "𩧉"},
	{"sfiuh", "駹"},
	{"sfiv", "䮅"},
	{"sfixp", "騼"},
	{"sfj", "䭴"},
	{"sfjb", "馷"},
	{"sfje", "馶"},
	{"sfjfe", "䮟"},
	{"sfjig", "驖"},
	{"sfjmc", "驞"},
	{"sfjmf", "騌"},
	{"sfjon", "䮮"},
	{"sfjp", "駝"},
	{"sfjto", "䮿"},
	{"sfjv", "𩣑"},
	{"sfjyj", "䮨"},
	{"sfk", "馱"},
	{"sfki", "駄"},
	{"sfkjt", "𩣺"},
	{"sfkk", "駁"},
	{"sfkkb", "䮎"},
	{"sfkkk", "騻"},
	{"sfkmr", "騎"},
	{"sfkn", "䮊"},
	{"sfl", "馽"},
	{"sflbk", "駚"},
	{"sflbu", "馾"},
	{"sflk", "駛"},
	{"sflll", "馴"},
	{"sfllv", "䮫"},
	{"sflmo", "駣"},
	{"sflmy", "騑"},
	{"sflpc", "驥"},
	{"sflq", "䮇"},
	{"sflw", "駎"},
	{"sflws", "騁"},
	{"sflx", "驌"},
	{"sfmbu", "驦"},
	{"sfmfj", "駍 䮆"},
	{"sfmfm", "駓"},
	{"sfmgi", "𩢤"},
	{"sfmhf", "騵"},
	{"sfmig", "駤"},
	{"sfmj", "馯"},
	{"sfml", "䭶"},
	{"sfmlm", "𩤃"},
	{"sfmlw", "驑"},
	{"sfmml", "䭼"},
	{"sfmmp", "驪"},
	{"sfmmr", "䮏"},
	{"sfmnn", "䮋"},
	{"sfmrb", "䮥"},
	{"sfmrw", "䮠"},
	{"sfmtb", "𩧃"},
	{"sfmvm", "𩣪"},
	{"sfmwf", "驃"},
	{"sfmwj", "驔"},
	{"sfmwv", "騕"},
	{"sfmx", "駵"},
	{"sfnhb", "驈"},
	{"sfnhd", "騥"},
	{"sfnhe", "馺"},
	{"sfnin", "䮈"},
	{"sfniq", "䑞"},
	{"sfnkq", "騝"},
	{"sfnkv", "駳"},
	{"sfnl", "䣕"},
	{"sfnli", "䮛"},
	{"sfnoe", "驋"},
	{"sfnok", "騤"},
	{"sfnoo", "騛"},
	{"sfnot", "䮴"},
	{"sfnqd", "䮪"},
	{"sfoae", "䮡"},
	{"sfobg", "䮤"},
	{"sfod", "䮌"},
	{"sfodi", "駙"},
	{"sfog", "騅"},
	{"sfogd", "䮶"},
	{"sfohh", "駗"},
	{"sfohv", "䮉"},
	{"sfoii", "駖"},
	{"sfoip", "騐"},
	{"sfok", "駇"},
	{"sfom", "駈"},
	{"sfomd", "駼"},
	{"sfomg", "駩"},
	{"sfomn", "騟"},
	{"sfomo", "驗"},
	{"sfomr", "騇"},
	{"sfopd", "駞"},
	{"sfpa", "駨"},
	{"sfpd", "馳"},
	{"sfph", "駜"},
	{"sfpi", "馰"},
	{"sfpkp", "騘"},
	{"sfpou", "騊"},
	{"sfpr", "駒"},
	{"sfpru", "䮀"},
	{"sfptd", "䮜"},
	{"sfpuu", "騶"},
	{"sfqjr", "騞"},
	{"sfqka", "䮞"},
	{"sfqsk", "䮯"},
	{"sfrau", "䣖"},
	{"sfrb", "駽"},
	{"sfrrj", "驒"},
	{"sfrye", "騢"},
	{"sfseo", "驟"},
	{"sfsfd", "䯂"},
	{"sfsff", "驫"},
	{"sfshr", "駋"},
	{"sfsj", "駬"},
	{"sfsjj", "䯀"},
	{"sfsjr", "𩤅"},
	{"sfsk", "駆"},
	{"sfsma", "騽"},
	{"sfsmc", "龮"},
	{"sfsme", "駸"},
	{"sfsnd", "驏"},
	{"sfso", "駅"},
	{"sfsqf", "騳"},
	{"sfsrr", "驅"},
	{"sfss", "駏"},
	{"sfssr", "駶"},
	{"sfstv", "𩥇"},
	{"sft", "馵"},
	{"sftaj", "騲"},
	{"sftak", "䮬"},
	{"sftbn", "騚"},
	{"sftcd", "驜"},
	{"sftjd", "驧"},
	{"sftlf", "驠"},
	{"sftlm", "騹"},
	{"sftmc", "騏 䮲"},
	{"sftmj", "驊"},
	{"sftrg", "驩"},
	{"sftt", "駢"},
	{"sfuce", "騣"},
	{"sfuhj", "𩥪"},
	{"sfumj", "䮗"},
	{"sfumt", "𩥉"},
	{"sfuob", "驨"},
	{"sfvne", "騄"},
	{"sfwc", "駟"},
	{"sfwd", "騍"},
	{"sfwk", "駰"},
	{"sfwli", "䮷"},
	{"sfwlj", "驛"},
	{"sfwp", "騦"},
	{"sfwtc", "龭"},
	{"sfwtj", "驆"},
	{"sfwvf", "騾"},
	{"sfyaj", "䮓"},
	{"sfybp", "䮾"},
	{"sfybs", "騯"},
	{"sfycb", "䮰"},
	{"sfyck", "駮"},
	{"sfydk", "驐"},
	{"sfyg", "駐"},
	{"sfyhn", "䭺"},
	{"sfyhv", "褧 䮍"},
	{"sfyjj", "騈"},
	{"sfyk", "馼"},
	{"sfymh", "䮹"},
	{"sfymo", "䮱"},
	{"sfynq", "䯁"},
	{"sfypm", "驉"},
	{"sfypt", "驢"},
	{"sfyrb", "䮦"},
	{"sfyrv", "驤"},
	{"sfytg", "䮵"},
	{"sfytj", "騂 騿"},
	{"sfyvi", "䮄"},
	{"sfyvo", "駭"},
	{"sfywm", "驙"},
	{"sfyx", "䮺"},
	{"sghaf", "鸐"},
	{"sgi", "戳"},
	{"sgjwp", "聽"},
	{"sgks", "劻"},
	{"sgln", "剭"},
	{"sgnl", "邼"},
	{"sgwc", "匵"},
	{"sgye", "㪬"},
	{"sh", "刀"},
	{"shaf", "鳲 䲩"},
	{"shajv", "䰋"},
	{"shana", "鬝"},
	{"shanb", "鬜"},
	{"shaph", "鬄"},
	{"shau", "䯲"},
	{"shawe", "鬘"},
	{"shbb", "鬅"},
	{"shbd", "䰂"},
	{"shbm", "䯶"},
	{"shbmm", "髥"},
	{"shbqr", "䯾"},
	{"shbt", "匴"},
	{"shbu", "㞒"},
	{"shby", "𩬅"},
	{"shc", "刅"},
	{"shci", "䯳"},
	{"shcnh", "鬀"},
	{"shcwa", "鬙"},
	{"shd", "髤"},
	{"shdbn", "鬎"},
	{"shdci", "鬆"},
	{"shdhe", "髲"},
	{"shdoe", "䰍"},
	{"she", "䯭"},
	{"shefh", "髿"},
	{"shfb", "髾"},
	{"shfh", "䯯"},
	{"shfqu", "鬈"},
	{"shgb", "髯"},
	{"shgr", "髻"},
	{"shhaf", "鳭 鷚"},
	{"shhdf", "鬏"},
	{"shhdn", "鬁"},
	{"shhdv", "䰀"},
	{"shhej", "髼"},
	{"shhet", "䰔"},
	{"shhg", "𩬎"},
	{"shhgr", "䯻"},
	{"shhhc", "鬚"},
	{"shhjr", "髺"},
	{"shhn", "髠"},
	{"shhne", "䯴"},
	{"shhoo", "䰌"},
	{"shhpr", "䯺"},
	{"shhqu", "髦"},
	{"shhuc", "䰖"},
	{"shhus", "䰓"},
	{"shhye", "䰉"},
	{"shi", "刃 戮"},
	{"shibi", "䰊"},
	{"shiih", "鬖"},
	{"shij", "䯷"},
	{"shikk", "髮"},
	{"shimo", "䯸"},
	{"shio", "㞏"},
	{"shjbc", "鬒"},
	{"shjig", "䰏"},
	{"shjka", "䰇"},
	{"shjmc", "鬢"},
	{"shjmf", "鬃"},
	{"shjoc", "鬓"},
	{"shjpa", "鬐"},
	{"shjpn", "鬡"},
	{"shjrb", "鬍"},
	{"shjt", "䯵"},
	{"shjx", "㞚"},
	{"shke", "髪"},
	{"shkhf", "䯼"},
	{"shkmb", "鬌"},
	{"shks", "勠"},
	{"shlb", "属"},
	{"shlbu", "髧"},
	{"shlln", "髴"},
	{"shlmc", "䰎"},
	{"shln", "剹"},
	{"shmbb", "䰑"},
	{"shmbc", "顟 䰅"},
	{"shmbl", "髵"},
	{"shmf", "䯱"},
	{"shmfm", "髬"},
	{"shml", "匠"},
	{"shmls", "髩"},
	{"shmmu", "髨"},
	{"shmu", "髡"},
	{"shn", "凥"},
	{"shnhd", "䰆"},
	{"shnhs", "䯮"},
	{"shnih", "髳"},
	{"shnl", "鄝"},
	{"shnmu", "𩯕"},
	{"shnr", "㔯"},
	{"shnsd", "鬇"},
	{"shoa", "㞛"},
	{"shob", "屩"},
	{"shod", "屧 髹"},
	{"shoe", "屐 履"},
	{"shog", "雡"},
	{"sholl", "䯰"},
	{"shoma", "鬠"},
	{"shomc", "鬂"},
	{"shoo", "屣 㞞"},
	{"shoog", "髽"},
	{"shot", "屜"},
	{"shov", "屨 㞜"},
	{"shpd", "髢"},
	{"shpru", "髱"},
	{"shpt", "髰"},
	{"shpym", "鹨"},
	{"shqka", "鬊"},
	{"shqu", "尾"},
	{"shr", "召"},
	{"shsb", "匾"},
	{"shshb", "脋"},
	{"shshh", "刕"},
	{"shshr", "髫"},
	{"shsit", "䰐"},
	{"shsj", "髶"},
	{"shsme", "䯹"},
	{"shtak", "鬕"},
	{"shtbn", "鬋"},
	{"shtbo", "䰒"},
	{"shtc", "髸"},
	{"shthu", "䭮"},
	{"shtlb", "鬗"},
	{"shtqm", "䰈"},
	{"shttc", "䰃"},
	{"shtw", "髷"},
	{"shtwv", "鬞"},
	{"shtxc", "鬑"},
	{"shuce", "鬉"},
	{"shue", "㞙"},
	{"shvne", "䰁"},
	{"shvvv", "鬣"},
	{"shwkv", "鬛"},
	{"shwlv", "鬟"},
	{"shwp", "䰄"},
	{"shxo", "㔱"},
	{"shyhj", "鬔"},
	{"shyhs", "髣"},
	{"shymp", "髭"},
	{"shyoj", "䯿"},
	{"shypt", "䰕"},
	{"shyrv", "鬤"},
	{"shytr", "䯽"},
	{"shyu", "㔸"},
	{"sibt", "監"},
	{"sibuu", "覧"},
	{"sic", "鍳"},
	{"sicvs", "䦇"},
	{"sif", "熨"},
	{"sihhh", "髟"},
	{"sihk", "镺"},
	{"sihml", "斸"},
	{"sihq", "犚"},
	{"sihqo", "镻"},
	{"sije", "㞗"},
	{"sikcf", "镽"},
	{"sikm", "䦈"},
	{"silmi", "螱"},
	{"siln", "劚"},
	{"silq", "肆"},
	{"sim", "习"},
	{"simbc", "䫮"},
	{"simfb", "镾"},
	{"simgi", "㻨 𤧬"},
	{"simrt", "䜿"},
	{"simvn", "瓺"},
	{"sinl", "鄩"},
	{"sino", "镹"},
	{"sip", "忍 慰"},
	{"siqsk", "䦋"},
	{"sisuu", "镼"},
	{"sit", "匥"},
	{"sitoe", "彠"},
	{"siwc", "䦉"},
	{"siyhv", "褽"},
	{"siymf", "䦊"},
	{"siymm", "歰"},
	{"sj", "耳"},
	{"sjavf", "䏉"},
	{"sjb", "臂 䎳"},
	{"sjbac", "䏃"},
	{"sjbmm", "耼"},
	{"sjbof", "䏅"},
	{"sjbqr", "䎻"},
	{"sjc", "屄 鐾"},
	{"sjcim", "聬"},
	{"sjcip", "聡"},
	{"sjcrp", "聪"},
	{"sjcsh", "聁"},
	{"sjd", "檗"},
	{"sjdln", "䏀"},
	{"sje", "取 㵨"},
	{"sjee", "聂"},
	{"sjenl", "郰"},
	{"sjf", "耿"},
	{"sjfd", "糪"},
	{"sjff", "𦖠"},
	{"sjg", "壁"},
	{"sjgb", "聃"},
	{"sjgr", "聐"},
	{"sjhaf", "鷿"},
	{"sjhbn", "䎺"},
	{"sjhdf", "䎿"},
	{"sjhgr", "聕"},
	{"sjhhj", "聛"},
	{"sjhhl", "聊"},
	{"sjhjd", "䎷"},
	{"sjhjr", "聒"},
	{"sjhlb", "聥"},
	{"sjhpa", "䎽"},
	{"sjhqu", "毦"},
	{"sjhui", "聭"},
	{"sjhwp", "聰"},
	{"sjhxe", "䏂"},
	{"sjhxu", "聣"},
	{"sji", "聀"},
	{"sjirm", "聝"},
	{"sjjbf", "聺"},
	{"sjjcg", "䏄"},
	{"sjjcm", "聜"},
	{"sjjmn", "聍"},
	{"sjjmo", "聢"},
	{"sjjn", "匭"},
	{"sjjpn", "聹"},
	{"sjjwp", "聴"},
	{"sjjyj", "䏁"},
	{"sjk", "䢃"},
	{"sjka", "屠"},
	{"sjkf", "屪"},
	{"sjki", "耾"},
	{"sjkoo", "聗"},
	{"sjlb", "幦"},
	{"sjlbu", "耽"},
	{"sjlmc", "聵"},
	{"sjlmo", "聩"},
	{"sjln", "刵"},
	{"sjlwl", "䎶"},
	{"sjlws", "聘"},
	{"sjmbc", "顳"},
	{"sjmbl", "聏"},
	{"sjmg", "𤩹"},
	{"sjmgi", "璧"},
	{"sjmmi", "耺"},
	{"sjmmr", "䎸"},
	{"sjmn", "耵"},
	{"sjmr", "礕"},
	{"sjmvn", "甓"},
	{"sjmwf", "䏇"},
	{"sjmym", "聇"},
	{"sjn", "䎲"},
	{"sjncr", "聸"},
	{"sjnd", "孹"},
	{"sjnl", "耶"},
	{"sjno", "㱌"},
	{"sjnok", "聧"},
	{"sjohh", "聄"},
	{"sjoii", "聆"},
	{"sjoin", "耹"},
	{"sjok", "聅 𣀳"},
	{"sjomb", "䎾"},
	{"sjomn", "𦖭"},
	{"sjomr", "𦕲"},
	{"sjp", "恥 憵"},
	{"sjph", "䎵"},
	{"sjpkp", "聦"},
	{"sjq", "擘"},
	{"sjqmb", "聙"},
	{"sjr", "居"},
	{"sjrc", "职"},
	{"sjrxu", "鼊"},
	{"sjryo", "躄"},
	{"sjsh", "劈"},
	{"sjsj", "聑"},
	{"sjsjj", "聶"},
	{"sjtk", "联"},
	{"sjtor", "𦖿"},
	{"sjtt", "䎴"},
	{"sjtwa", "䏆"},
	{"sju", "耴"},
	{"sjuu", "聉"},
	{"sjv", "嬖"},
	{"sjvff", "䏈"},
	{"sjvif", "繴"},
	{"sjvik", "聫"},
	{"sjvis", "聈"},
	{"sjvit", "聯"},
	{"sjvne", "䎼"},
	{"sjybp", "䏊"},
	{"sjyhv", "襞"},
	{"sjyia", "職"},
	{"sjyjj", "聠"},
	{"sjylm", "耻"},
	{"sjymr", "譬"},
	{"sjyrn", "聤"},
	{"sk", "区 尹"},
	{"skcf", "㞠"},
	{"skhaf", "鴎"},
	{"skhne", "殴"},
	{"skm", "丒"},
	{"skmbc", "䪳"},
	{"skmvn", "瓯"},
	{"skn", "尻"},
	{"skni", "㞍"},
	{"skno", "欧"},
	{"skoo", "匧"},
	{"skp", "悘"},
	{"skpym", "鸥"},
	{"skqn", "匦"},
	{"skr", "君"},
	{"skrr", "匲"},
	{"sl", "卩"},
	{"slb", "匝"},
	{"sle", "臤"},
	{"sli", "卪"},
	{"slm", "卫"},
	{"slmbc", "頣 頤"},
	{"slmbo", "颐"},
	{"slmc", "匱"},
	{"slmo", "匮"},
	{"slmvn", "㼢"},
	{"slmy", "匪 屝"},
	{"slnf", "䑐"},
	{"slnl", "䢻"},
	{"slo", "臥"},
	{"slorr", "臨"},
	{"slqmc", "賾"},
	{"slqmo", "赜"},
	{"slr", "㠯"},
	{"slru", "巸"},
	{"slsl", "臣"},
	{"slsll", "臦"},
	{"sltco", "䑑"},
	{"slvif", "綤"},
	{"slw", "届"},
	{"slwv", "屢"},
	{"sly", "卧"},
	{"slymr", "䛗"},
	{"sm", "刁 ⺕"},
	{"smamo", "翨"},
	{"smbjj", "翬 𦑩"},
	{"smbkq", "翚"},
	{"smblb", "帚"},
	{"smcsh", "翂"},
	{"smdhe", "翍"},
	{"smdi", "寻"},
	{"smea", "䎓"},
	{"smf", "灵"},
	{"smfht", "彛"},
	{"smg", "匡"},
	{"smgi", "匤"},
	{"smha", "習"},
	{"smhaf", "翵"},
	{"smhqo", "翐"},
	{"smhqu", "毣"},
	{"smht", "𦐒"},
	{"smi", "镸 𦐂"},
	{"smibi", "䎔"},
	{"smig", "屋"},
	{"smihi", "䎉"},
	{"smii", "䎒"},
	{"smijb", "䎍"},
	{"smikk", "翇"},
	{"smip", "𦏵"},
	{"smiv", "䎀"},
	{"smje", "翄"},
	{"smk", "㚑"},
	{"smknj", "翆"},
	{"smkoo", "翜"},
	{"sml", "翀 𠁨"},
	{"smlb", "屚"},
	{"smlwp", "䎈"},
	{"smm", "羾"},
	{"smmbc", "頨"},
	{"smmg", "䍿"},
	{"smmi", "层"},
	{"smmii", "㝷"},
	{"smmri", "尋"},
	{"smmv", "屒 㞡"},
	{"smnl", "䣁"},
	{"smnp", "屍"},
	{"smob", "㔷"},
	{"smog", "翟"},
	{"smohh", "翏"},
	{"smoii", "䎆"},
	{"smonk", "翭"},
	{"smpd", "𦏸"},
	{"smpr", "翑"},
	{"smpru", "䎂"},
	{"smqjm", "𦒄"},
	{"smqjp", "䎚"},
	{"smqmb", "𦑊"},
	{"smr", "司"},
	{"smryo", "䎌"},
	{"smsim", "羽"},
	{"smsju", "䎎"},
	{"smso", "㞘 𡱰"},
	{"smt", "羿"},
	{"smuce", "翪"},
	{"smv", "長"},
	{"smvne", "䎑"},
	{"smwtc", "翼"},
	{"smyjj", "翴"},
	{"smyk", "𦐐"},
	{"smyoj", "翠"},
	{"smyrb", "翯"},
	{"smyrf", "翞"},
	{"smyt", "翋 翌"},
	{"smytv", "翣"},
	{"snd", "㞌"},
	{"sndd", "孱"},
	{"snin", "㞔"},
	{"sniy", "㔰"},
	{"snlr", "屙"},
	{"sno", "匛"},
	{"so", "尺"},
	{"soam", "昼"},
	{"sog", "龨"},
	{"soin", "㔲 㔳"},
	{"soiv", "䬤"},
	{"sok", "医"},
	{"soln", "㔌"},
	{"somn", "匬"},
	{"somo", "匳"},
	{"somr", "匼"},
	{"sonl", "鄹"},
	{"sono", "㰼"},
	{"soog", "𠥔"},
	{"sop", "㥦"},
	{"sorc", "咫"},
	{"soy", "尽"},
	{"sp", "尼"},
	{"spa", "㞓"},
	{"spbuc", "贒"},
	{"spd", "匜"},
	{"spha", "匫"},
	{"sphaf", "鵋 䲿"},
	{"sphh", "匢"},
	{"spp", "屁"},
	{"spt", "屉"},
	{"sptd", "屟"},
	{"spym", "鸤"},
	{"sqln", "㓾"},
	{"sqnl", "那"},
	{"sqsf", "馬"},
	{"sr", "叵 𡰪"},
	{"srbt", "盬"},
	{"srbuu", "覗 䙼"},
	{"srdi", "尀"},
	{"srf", "焄 𤍥"},
	{"srhaf", "鵘 鶋 鷗 䳂"},
	{"srhg", "聖"},
	{"srhne", "毆"},
	{"srhrf", "𠥹"},
	{"srks", "劭"},
	{"srlb", "屌"},
	{"srlii", "䘌"},
	{"srln", "刟 剧"},
	{"srmbc", "頵"},
	{"srmvn", "甌"},
	{"srn", "㐒"},
	{"srnd", "孠"},
	{"srnl", "邵 郡"},
	{"srno", "歐"},
	{"srp", "慝"},
	{"srrau", "𨛦"},
	{"srrj", "匰"},
	{"srrr", "區"},
	{"srru", "巶"},
	{"srsl", "卲"},
	{"srsmm", "䎄"},
	{"srtq", "羣 群"},
	{"sruc", "㔵"},
	{"srye", "敺 㪊"},
	{"sryhv", "裠"},
	{"sryjf", "鸊"},
	{"sryjm", "䴙"},
	{"srymr", "䛐"},
	{"srytj", "辟"},
	{"ss", "巨"},
	{"ssf", "燛"},
	{"sskll", "臩"},
	{"sslii", "螶"},
	{"ssn", "乬"},
	{"ssnl", "䢹"},
	{"ssr", "局"},
	{"ssu", "凹"},
	{"sthqu", "㲯"},
	{"stkr", "匿 𡲢"},
	{"stln", "㔋"},
	{"stox", "匶"},
	{"stqq", "羼"},
	{"stt", "屏"},
	{"stv", "展"},
	{"stwk", "㞟"},
	{"su", "己 已 㔾"},
	{"sudi", "屗"},
	{"suf", "煕 熙 𤋮"},
	{"sug", "屆"},
	{"suhaf", "鶌"},
	{"suhqm", "𡲥"},
	{"suhu", "兕"},
	{"sumbc", "䪱"},
	{"sumg", "匩"},
	{"sund", "屘"},
	{"sunl", "邔"},
	{"suok", "改"},
	{"sup", "忌"},
	{"sut", "异"},
	{"sutc", "𢁉"},
	{"sutmc", "㠱"},
	{"suu", "屈 㞯"},
	{"suv", "妀 媐"},
	{"svhaf", "鶠"},
	{"svmb", "屫"},
	{"svmg", "匨"},
	{"svnl", "郾"},
	{"svno", "㰽"},
	{"svryo", "𨃨"},
	{"sw", "屇"},
	{"swbt", "鹽"},
	{"swbuu", "覽"},
	{"swc", "鑒"},
	{"swd", "㯺"},
	{"swl", "匣"},
	{"swmvn", "㽉"},
	{"swq", "擥"},
	{"swtc", "㔴"},
	{"swymr", "譼"},
	{"syhn", "匟"},
	{"syhyn", "䖙"},
	{"syjc", "㔶"},
	{"syjj", "屛"},
	{"syoiv", "䭆"},
	{"syp", "𢛶"},
	{"syt", "㞐"},
	{"sytj", "屖"},
	{"syyi", "屬"},
	{"syyq", "犀"},
	{"syyu", "𡲬"},
	{"t", "廿"},
	{"ta", "昔 䒤"},
	{"taa", "菖"},
	{"taaa", "蕌"},
	{"tab", "萌"},
	{"tabt", "蒀"},
	{"tabu", "萺"},
	{"tad", "菒"},
	{"tadhe", "皵"},
	{"tadi", "莳"},
	{"tagi", "蒔"},
	{"tahaf", "鵲"},
	{"tahml", "斮"},
	{"tahs", "葃"},
	{"tahu", "葿"},
	{"tail", "莭"},
	{"taiu", "蔇"},
	{"taj", "草"},
	{"tak", "莫"},
	{"taka", "暮"},
	{"takb", "幕"},
	{"takf", "驀"},
	{"takg", "墓"},
	{"taki", "蟇 𦻒"},
	{"takm", "蓦"},
	{"takn", "㱳"},
	{"takp", "慕"},
	{"takq", "摹"},
	{"takr", "謩"},
	{"taks", "募"},
	{"talk", "𦴤"},
	{"taln", "剒"},
	{"tam", "㠮"},
	{"tamj", "䓍"},
	{"tan", "菛"},
	{"tana", "蕳"},
	{"tanb", "蕑"},
	{"tand", "䔵"},
	{"tang", "藺"},
	{"tanp", "蕄"},
	{"tanr", "蔄 䕡"},
	{"tanv", "蔅 䕞"},
	{"tanw", "蘭"},
	{"taog", "䧿"},
	{"taok", "㪚"},
	{"taph", "䓪"},
	{"tapp", "菎"},
	{"tapv", "葛"},
	{"tapym", "鹊"},
	{"tase", "蕞"},
	{"tau", "芭"},
	{"tav", "茛"},
	{"tawe", "蔓"},
	{"tbac", "蓂"},
	{"tbau", "萉"},
	{"tbav", "﨟"},
	{"tbb", "萠 䒿"},
	{"tbbb", "蓇"},
	{"tbbe", "薆"},
	{"tbbhu", "觏"},
	{"tbbk", "䕧"},
	{"tbbq", "蕣"},
	{"tbbr", "萵"},
	{"tbbu", "薍"},
	{"tbbuu", "覯"},
	{"tbc", "典 蓥"},
	{"tbcn", "萴"},
	{"tbcsh", "黺"},
	{"tbcv", "蘡"},
	{"tbd", "槊 荣 菜"},
	{"tbdh", "𦹮"},
	{"tbe", "荥 𦬣"},
	{"tbf", "荧"},
	{"tbfe", "藤"},
	{"tbff", "虅 䕨"},
	{"tbfs", "蕂"},
	{"tbg", "塑"},
	{"tbgr", "䓟"},
	{"tbhf", "蔿"},
	{"tbhg", "薶"},
	{"tbhn", "䒮"},
	{"tbhq", "荦"},
	{"tbhs", "葄"},
	{"tbhu", "苋 藐"},
	{"tbhx", "蓞"},
	{"tbib", "䔕"},
	{"tbijb", "黼"},
	{"tbikk", "黻"},
	{"tbjj", "葷"},
	{"tbkf", "䔳"},
	{"tbki", "䒯"},
	{"tbkk", "䒽"},
	{"tbkq", "荤"},
	{"tbks", "劳 勱"},
	{"tbli", "繭 萤"},
	{"tbln", "前 蒯"},
	{"tbm", "苴"},
	{"tbmbc", "顜 顢"},
	{"tbmbo", "颟"},
	{"tbme", "萲"},
	{"tbmg", "莹"},
	{"tbmig", "䑓"},
	{"tbmm", "䒣"},
	{"tbmo", "蒙"},
	{"tbmr", "茼"},
	{"tbms", "莇"},
	{"tbmv", "䓻"},
	{"tbmw", "蒏"},
	{"tbnd", "莩 㮍"},
	{"tbnf", "煎"},
	{"tbnh", "剪"},
	{"tbni", "蒬"},
	{"tbnj", "茕"},
	{"tbnm", "翦"},
	{"tbof", "蔡"},
	{"tbok", "散"},
	{"tbon", "荝"},
	{"tbop", "萞"},
	{"tbou", "䓨 䔄"},
	{"tbp", "愬 𦽳"},
	{"tbpm", "莺"},
	{"tbpr", "葋"},
	{"tbq", "苚"},
	{"tbr", "苘"},
	{"tbrr", "营"},
	{"tbse", "菔"},
	{"tbtv", "菵"},
	{"tbu", "苜"},
	{"tbud", "蔝"},
	{"tbuf", "蘨"},
	{"tbui", "萈"},
	{"tbuk", "藈"},
	{"tbul", "薡"},
	{"tbut", "萛"},
	{"tbuu", "莧"},
	{"tbuw", "䕎"},
	{"tbv", "荽"},
	{"tbvf", "萦"},
	{"tbvk", "蒵"},
	{"tby", "䒟"},
	{"tbyj", "斠"},
	{"tbytp", "䖁"},
	{"tc", "业 共 菳 䒔"},
	{"tca", "普 㫷"},
	{"tcb", "朞 期 䐌"},
	{"tcbhu", "觍"},
	{"tcbt", "益"},
	{"tcbuu", "覥"},
	{"tcd", "棊 㭟"},
	{"tce", "㳟"},
	{"tcfb", "黹 䕥"},
	{"tcfh", "㝺"},
	{"tcg", "基"},
	{"tcgg", "黊"},
	{"tchaf", "鶼 鷬 䳍 䳢"},
	{"tche", "夔 䕫"},
	{"tchml", "斯"},
	{"tcim", "蓊"},
	{"tcip", "䓗"},
	{"tcjl", "蕲"},
	{"tcjwj", "輂"},
	{"tckb", "䵋"},
	{"tckoo", "䵌"},
	{"tclbu", "黆"},
	{"tclmi", "蛬"},
	{"tcln", "剘"},
	{"tcmbc", "䫏 䫡"},
	{"tcmr", "碁"},
	{"tcmvn", "甉"},
	{"tcn", "㐞"},
	{"tcnl", "邺 䢼"},
	{"tcno", "欺 歉"},
	{"tcnok", "彂"},
	{"tcoin", "黅"},
	{"tcok", "敟"},
	{"tcp", "恭 惎"},
	{"tcpi", "䔙"},
	{"tcpym", "鹣"},
	{"tcq", "拲"},
	{"tcrau", "䢽"},
	{"tcrrj", "䵐"},
	{"tcru", "巷 莌"},
	{"tcsd", "棻"},
	{"tcsh", "芬"},
	{"tcsmh", "䵏"},
	{"tcst", "葐"},
	{"tctd", "業"},
	{"tcte", "叢"},
	{"tctj", "丵"},
	{"tcto", "菐"},
	{"tctu", "凿"},
	{"tcumb", "䵎"},
	{"tcvif", "綦"},
	{"tcwm", "酋"},
	{"tcye", "㪠"},
	{"tcyg", "黈"},
	{"tcyj", "斢 㪸"},
	{"tcymr", "諅"},
	{"tcyr", "黇"},
	{"tcyrd", "䵍"},
	{"td", "㭉"},
	{"tdav", "𦶠"},
	{"tdb", "茦"},
	{"tdbb", "蕀"},
	{"tdbk", "蓛"},
	{"tdbn", "莿"},
	{"tdbu", "葙"},
	{"tdci", "菘"},
	{"tdd", "菻"},
	{"tddh", "䖇"},
	{"tdfb", "䔠"},
	{"tdg", "荰"},
	{"tdgg", "蓕"},
	{"tdhaf", "鷋 鸈"},
	{"tdhl", "菥"},
	{"tdj", "茉"},
	{"tdje", "䓩"},
	{"tdk", "芵"},
	{"tdkf", "䕩"},
	{"tdlc", "藾"},
	{"tdlk", "䔩"},
	{"tdln", "䓶"},
	{"tdlo", "蔌"},
	{"tdlu", "萙"},
	{"tdm", "苯"},
	{"tdmq", "葦"},
	{"tdnl", "鄴"},
	{"tdno", "㱉"},
	{"tdof", "藮"},
	{"tdon", "䕆"},
	{"tdoo", "萊"},
	{"tdoy", "䔦"},
	{"tdqt", "𧄧"},
	{"tdr", "莕"},
	{"tdrd", "𦹂"},
	{"tdsr", "藲"},
	{"tdt", "莱"},
	{"tdte", "𧁒"},
	{"tdw", "菄"},
	{"tdwf", "萰"},
	{"tea", "䓠"},
	{"teae", "䕕"},
	{"teah", "蕩"},
	{"teap", "𦹲"},
	{"teat", "蕰"},
	{"teav", "䔽"},
	{"tebd", "𦷰"},
	{"tebm", "菹"},
	{"tebv", "𦷪"},
	{"tec", "鑿"},
	{"ted", "莯"},
	{"tede", "菠"},
	{"teev", "蔢"},
	{"tefd", "糳"},
	{"tefh", "莎"},
	{"tege", "蔆"},
	{"teha", "萡"},
	{"tehl", "䓅"},
	{"tehm", "䓜"},
	{"tehn", "䓷"},
	{"tehp", "䓋 𦿞"},
	{"tehr", "落 萿 𦶡"},
	{"teht", "蘯"},
	{"tehv", "蒎 䓾"},
	{"tehw", "藩"},
	{"teib", "蒲"},
	{"teii", "薄 䔐"},
	{"teir", "菭"},
	{"teiv", "蒗"},
	{"teln", "劐"},
	{"telq", "葏"},
	{"telu", "莐"},
	{"tem", "茳"},
	{"temf", "薸"},
	{"temj", "萍 藫"},
	{"temn", "𦭑"},
	{"temr", "菏"},
	{"temt", "䓑"},
	{"tend", "蒅"},
	{"tene", "莈"},
	{"tenh", "荡"},
	{"teod", "蒤"},
	{"teom", "虃"},
	{"teon", "蕍"},
	{"teot", "蒞"},
	{"teoy", "𦷫"},
	{"tepa", "𦴥"},
	{"tepu", "萢"},
	{"teqb", "蔳"},
	{"terd", "藻"},
	{"tesd", "蕖"},
	{"tese", "蓡 薓"},
	{"tesr", "菬"},
	{"tess", "菃"},
	{"test", "蘫"},
	{"tesu", "范"},
	{"tetc", "葓"},
	{"tett", "蓱"},
	{"tevd", "薻"},
	{"tewb", "蕅"},
	{"tewj", "䕪"},
	{"tewt", "薀"},
	{"teyb", "薃"},
	{"teye", "蔋"},
	{"teyp", "𦴢"},
	{"teyr", "𦹃"},
	{"teyt", "𦲷"},
	{"teyu", "蓅"},
	{"teyv", "茫"},
	{"tf", "苂 䒕"},
	{"tfa", "㬫"},
	{"tfaj", "蔊"},
	{"tfb", "莦"},
	{"tfbe", "蕿"},
	{"tfbk", "蔽"},
	{"tfbn", "萷"},
	{"tfdv", "蒌"},
	{"tff", "菼"},
	{"tfff", "藀"},
	{"tfh", "䒚"},
	{"tfhaf", "䴏"},
	{"tfhw", "䕰"},
	{"tfk", "𡙡"},
	{"tfkc", "蘱"},
	{"tfku", "虌"},
	{"tfmbc", "䫞"},
	{"tfmc", "薠"},
	{"tfmu", "茪"},
	{"tfnl", "酀"},
	{"tfpi", "䓎"},
	{"tfqu", "菤"},
	{"tfvk", "薮"},
	{"tfyj", "𦻐"},
	{"tg", "芏 𦍌"},
	{"tgb", "苒"},
	{"tgbt", "盖"},
	{"tgbuu", "觀"},
	{"tgce", "菱"},
	{"tgcw", "蔷"},
	{"tgdi", "對 䓁"},
	{"tgea", "𧅥"},
	{"tgeno", "羨"},
	{"tgf", "羔 㸐"},
	{"tgfo", "羮 䕀"},
	{"tgftk", "羹"},
	{"tgg", "茥"},
	{"tggf", "䕭"},
	{"tggi", "葑 蓺"},
	{"tggu", "蕘"},
	{"tghaf", "鸛"},
	{"tghds", "羲"},
	{"tghi", "羗 𦍑"},
	{"tghml", "𣂷 𣂼"},
	{"tghni", "飌"},
	{"tghqi", "義"},
	{"tghu", "羌"},
	{"tgi", "䒧"},
	{"tgif", "爇"},
	{"tgii", "藝"},
	{"tgimo", "羡"},
	{"tgine", "羕"},
	{"tgir", "䕋"},
	{"tgit", "蓋"},
	{"tgjd", "䕮"},
	{"tgje", "蕔"},
	{"tgji", "蓻"},
	{"tgk", "美"},
	{"tgks", "勸"},
	{"tglc", "䓇"},
	{"tglln", "羛"},
	{"tglmi", "𧕴"},
	{"tgmbc", "顴"},
	{"tgmbo", "颧"},
	{"tgmj", "𦱾"},
	{"tgni", "薵"},
	{"tgnl", "酄"},
	{"tgno", "歡 羑 莰"},
	{"tgobo", "臡"},
	{"tgow", "薔"},
	{"tgp", "恙 戁 䓌"},
	{"tgpm", "荺"},
	{"tgpym", "鹳"},
	{"tgq", "𢺋"},
	{"tgr", "䓀"},
	{"tgrf", "䕵"},
	{"tgrg", "薹"},
	{"tgrr", "䕒"},
	{"tgsk", "蔜"},
	{"tgte", "薣"},
	{"tgtr", "善"},
	{"tgum", "𧄍"},
	{"tgv", "姜"},
	{"tgwc", "藚"},
	{"tgyr", "𦹷"},
	{"tgyv", "蘾"},
	{"tha", "苩"},
	{"thaa", "藠 䔤"},
	{"thae", "葲 𧄦"},
	{"thaf", "蔦 蘤"},
	{"thag", "葟"},
	{"thai", "菂"},
	{"thaj", "䔌"},
	{"thau", "葩"},
	{"thbh", "虋"},
	{"thbk", "薁"},
	{"thbt", "䒸"},
	{"thbu", "首"},
	{"thcn", "藰"},
	{"thd", "䒩"},
	{"thda", "萫"},
	{"thdb", "蕱 藊 䕝"},
	{"thdd", "䔉"},
	{"thde", "薐"},
	{"thdf", "萩 䕴"},
	{"thdg", "䕌 𦻓"},
	{"thdh", "菞 蕛"},
	{"thdj", "萪"},
	{"thdk", "萟"},
	{"thdm", "蒩"},
	{"thdn", "莉 䔟"},
	{"thdr", "萂"},
	{"thds", "莠"},
	{"thdu", "蘒 蘒"},
	{"thdv", "萎 藒"},
	{"thdw", "蕃"},
	{"the", "䒘"},
	{"thej", "莑"},
	{"ther", "茖"},
	{"they", "苳"},
	{"thfd", "苸"},
	{"thfs", "蘍"},
	{"thg", "𦯀"},
	{"thgf", "薰"},
	{"thhaf", "鶜"},
	{"thhc", "蕦"},
	{"thhd", "蔾"},
	{"thhe", "藜"},
	{"thhj", "萆"},
	{"thhl", "茆 𦺄"},
	{"thhq", "𦺙"},
	{"thhw", "蒥"},
	{"thi", "蒐"},
	{"thio", "䒦"},
	{"thj", "芊"},
	{"thjd", "孽 糵 茱 蘖"},
	{"thje", "葮"},
	{"thjg", "董"},
	{"thjm", "菙"},
	{"thjo", "躠"},
	{"thjp", "䓙"},
	{"thjr", "䒷"},
	{"thk", "芺"},
	{"thkb", "蕎"},
	{"thkl", "荞"},
	{"thkp", "菾"},
	{"thlb", "萭"},
	{"thlf", "蘌"},
	{"thlo", "𦲽"},
	{"thmb", "蘬"},
	{"thml", "芹"},
	{"thmr", "茩"},
	{"thmy", "𦭐"},
	{"thn", "芁"},
	{"thnd", "䔧"},
	{"thne", "芟"},
	{"thni", "芃"},
	{"thnq", "䔣"},
	{"thod", "蒣"},
	{"thoe", "蕧 䓈"},
	{"thok", "薇 藢 𦱿 𧃸"},
	{"thol", "蓹"},
	{"thom", "䓚"},
	{"thon", "荇 葕 蘅 䕔 𦸇"},
	{"thoo", "蓏 蓗 蓯 蓰"},
	{"thoq", "葎"},
	{"thov", "䓳"},
	{"thpl", "茚"},
	{"thpm", "茋"},
	{"thq", "䒜"},
	{"thqi", "莪"},
	{"thqm", "苼"},
	{"thqo", "苵"},
	{"thqu", "芼"},
	{"thrb", "蒒"},
	{"thrj", "薛"},
	{"ths", "苲"},
	{"thsb", "菺 萹"},
	{"thse", "蒑"},
	{"thsk", "薂 䓞"},
	{"thsu", "蔰"},
	{"thuc", "蘈"},
	{"thul", "䕗"},
	{"thup", "蒠"},
	{"thvi", "蘶"},
	{"thvl", "䒢"},
	{"thvo", "苽"},
	{"thvp", "芪"},
	{"thvu", "蔸"},
	{"thwp", "蓖 蔥"},
	{"thxc", "藇 䕟"},
	{"thxe", "蓃"},
	{"thxf", "蕮"},
	{"thxo", "萸"},
	{"thxu", "萖"},
	{"thye", "蒰"},
	{"thyn", "𦶢"},
	{"thyr", "䓘"},
	{"tiav", "莨"},
	{"tibi", "蒪"},
	{"tic", "𨮝"},
	{"tice", "荾"},
	{"tidd", "蔴"},
	{"tidf", "䕷"},
	{"tidq", "藦"},
	{"tidr", "蘑"},
	{"tidy", "蘼"},
	{"tifm", "䔃"},
	{"tifq", "䔗"},
	{"tifw", "䕐"},
	{"tih", "茂"},
	{"tihaf", "鷀 鷷 䴊"},
	{"tihc", "蕆"},
	{"tihi", "荗 䕇"},
	{"tihm", "菧"},
	{"tiho", "蒇"},
	{"tihr", "葴 蒧"},
	{"tihs", "荿"},
	{"tihv", "葳"},
	{"tii", "菚"},
	{"tiib", "蓢"},
	{"tiih", "蔘"},
	{"tiil", "蓈"},
	{"tiit", "𦾟"},
	{"tij", "茙"},
	{"tijb", "莆"},
	{"tije", "莍"},
	{"tik", "芆"},
	{"tikf", "蒍"},
	{"tikk", "茇 䔸"},
	{"tikp", "茏"},
	{"tikt", "莽"},
	{"tiku", "蓭 𦬓"},
	{"tilo", "菮"},
	{"tilr", "蓎"},
	{"time", "蓤"},
	{"timo", "茨"},
	{"tims", "藏"},
	{"tine", "䕠"},
	{"tinl", "䣡"},
	{"tino", "芝"},
	{"tioc", "薋"},
	{"tiod", "薬"},
	{"tiog", "蓙"},
	{"tip", "懟 芅"},
	{"tipd", "蘪"},
	{"tipf", "藨"},
	{"tipg", "薼"},
	{"tipym", "鹚"},
	{"tir", "苔"},
	{"tird", "葈"},
	{"tis", "芦"},
	{"tisk", "䓞"},
	{"tist", "𦼦"},
	{"tit", "䒪"},
	{"titb", "蓆"},
	{"titc", "薕"},
	{"titf", "蔗"},
	{"tivv", "蔼"},
	{"tixf", "薦"},
	{"tixp", "蔍"},
	{"tiyf", "䕲"},
	{"tj", "卅"},
	{"tjabt", "鞰"},
	{"tjam", "靼"},
	{"tjamo", "鞮"},
	{"tjanw", "䪍"},
	{"tjapv", "鞨"},
	{"tjau", "靶"},
	{"tjav", "鞎"},
	{"tjavf", "韅"},
	{"tjb", "芾 䩗"},
	{"tjbc", "蒖"},
	{"tjbd", "荸"},
	{"tjbf", "䕓"},
	{"tjbhx", "鞱"},
	{"tjbj", "萳"},
	{"tjbjj", "䩵"},
	{"tjblb", "带"},
	{"tjbm", "萓 靻"},
	{"tjbuu", "䩤"},
	{"tjbv", "鞖"},
	{"tjbvk", "鞵"},
	{"tjc", "茓"},
	{"tjcim", "䩺"},
	{"tjck", "葖"},
	{"tjcn", "藭"},
	{"tjcr", "蓉"},
	{"tjcs", "䓖"},
	{"tjd", "苿"},
	{"tjdbb", "䪂"},
	{"tjdhe", "鞁"},
	{"tjdj", "靺"},
	{"tjds", "葧"},
	{"tje", "芰"},
	{"tjea", "鞜"},
	{"tjef", "蘻"},
	{"tjei", "靫"},
	{"tjfb", "鞘"},
	{"tjfbg", "鞺"},
	{"tjfbn", "鞩"},
	{"tjfbr", "鞝"},
	{"tjfh", "䩖"},
	{"tjfq", "靽"},
	{"tjg", "靯"},
	{"tjgg", "鞋"},
	{"tjgr", "鞊"},
	{"tjgwc", "韇"},
	{"tjhaf", "鷨 䳬"},
	{"tjhd", "鞂"},
	{"tjhdf", "鞦"},
	{"tjhf", "藛"},
	{"tjhhj", "鞞"},
	{"tjhkb", "鞽"},
	{"tjhkl", "鞒"},
	{"tjhml", "靳"},
	{"tjhne", "䩔"},
	{"tjhqu", "㲨"},
	{"tjhr", "𦴦"},
	{"tjhvi", "䩚"},
	{"tjhvl", "䩕"},
	{"tjhvo", "䩝"},
	{"tjig", "䕙"},
	{"tjii", "蓴"},
	{"tjip", "蕙"},
	{"tjite", "䩲"},
	{"tjitf", "䩾"},
	{"tjixf", "韀"},
	{"tjjcm", "鞚"},
	{"tjjfe", "䩳"},
	{"tjjj", "蓒"},
	{"tjjl", "蔪"},
	{"tjjnu", "䩩"},
	{"tjjrb", "䩴"},
	{"tjjrp", "䪀"},
	{"tjjrr", "䩪"},
	{"tjjtc", "䩿"},
	{"tjjv", "鞍"},
	{"tjka", "著"},
	{"tjkd", "䓔"},
	{"tjkf", "藔"},
	{"tjkmr", "䩭"},
	{"tjkn", "䩟"},
	{"tjkoo", "䩡"},
	{"tjkp", "荖"},
	{"tjks", "勒"},
	{"tjlbk", "鞅"},
	{"tjlmc", "鞼"},
	{"tjlmo", "鞉"},
	{"tjlo", "萐"},
	{"tjlv", "萋"},
	{"tjlw", "䩜"},
	{"tjlwv", "鞻"},
	{"tjm", "苎"},
	{"tjmc", "蔩 𧅤"},
	{"tjmd", "荢 䩒"},
	{"tjme", "蔻"},
	{"tjmf", "萗"},
	{"tjmj", "靬"},
	{"tjmk", "蔲"},
	{"tjmlb", "䩫"},
	{"tjmlk", "鞕"},
	{"tjmm", "萱"},
	{"tjmn", "苧 靪"},
	{"tjmo", "萣"},
	{"tjmob", "鞆"},
	{"tjmr", "菪"},
	{"tjmrb", "䩹"},
	{"tjmu", "莞 靰"},
	{"tjmv", "𦸅"},
	{"tjmvi", "䩘"},
	{"tjmw", "䔰"},
	{"tjmwm", "韁"},
	{"tjn", "䩑"},
	{"tjnau", "鞔"},
	{"tjncr", "韂"},
	{"tjnem", "䩯"},
	{"tjng", "靵"},
	{"tjnhd", "鞣"},
	{"tjnhe", "靸"},
	{"tjni", "鞃"},
	{"tjnkg", "䩠"},
	{"tjnkq", "鞬"},
	{"tjnkv", "䩥"},
	{"tjnl", "鄿 靷"},
	{"tjnri", "䪌"},
	{"tjnu", "菀"},
	{"tjoa", "蓿"},
	{"tjob", "靹"},
	{"tjoin", "靲"},
	{"tjomd", "䩣"},
	{"tjomk", "鞭"},
	{"tjomn", "䩱"},
	{"tjomr", "鞈"},
	{"tjomt", "鞥"},
	{"tjon", "䩐"},
	{"tjop", "靴"},
	{"tjpa", "蓍"},
	{"tjpb", "䔭"},
	{"tjpfd", "鞠"},
	{"tjph", "䩛"},
	{"tjpi", "靮 䩓"},
	{"tjpn", "薴"},
	{"tjpru", "鞄"},
	{"tjpt", "靾"},
	{"tjptd", "鞢"},
	{"tjpu", "蔤"},
	{"tjpyr", "鞫"},
	{"tjqhl", "䩢"},
	{"tjqkq", "䩬"},
	{"tjqp", "藼"},
	{"tjqyt", "鞡"},
	{"tjr", "苦"},
	{"tjrb", "葫 鞙"},
	{"tjrmg", "鞓"},
	{"tjrr", "菅"},
	{"tjrsj", "䩰"},
	{"tjsh", "㔑"},
	{"tjshi", "靭"},
	{"tjshr", "鞀"},
	{"tjsk", "靱"},
	{"tjsmv", "䩨"},
	{"tjsqf", "䩻"},
	{"tjsrr", "䩽"},
	{"tjtaw", "韊"},
	{"tjtc", "蕡"},
	{"tjtco", "䪁"},
	{"tjtcw", "鞧"},
	{"tjthb", "鞴"},
	{"tjtif", "韉"},
	{"tjtii", "䪇"},
	{"tjtkd", "鞯"},
	{"tjtmc", "䪄"},
	{"tjtmj", "鞾"},
	{"tjtoe", "韄"},
	{"tjtor", "鞳"},
	{"tjtq", "藆"},
	{"tjtsj", "䩸"},
	{"tjttb", "鞲"},
	{"tjtwm", "韈"},
	{"tjtwt", "䪆"},
	{"tjumi", "䩶"},
	{"tjuob", "䪎"},
	{"tjv", "荌 㜸"},
	{"tjvii", "鞿"},
	{"tjvis", "靿"},
	{"tjvne", "䩮"},
	{"tjvvv", "䪉"},
	{"tjwj", "莗"},
	{"tjwk", "鞇"},
	{"tjwli", "䪅"},
	{"tjwtj", "鞸"},
	{"tjybp", "䪊"},
	{"tjybs", "䩷"},
	{"tjydk", "䪃"},
	{"tjydl", "鞹"},
	{"tjygq", "韃"},
	{"tjyhj", "䩼"},
	{"tjyj", "䔂"},
	{"tjyk", "鞑"},
	{"tjylc", "䪋"},
	{"tjylr", "䪈"},
	{"tjymr", "䩧"},
	{"tjymu", "韆"},
	{"tjymy", "鞐"},
	{"tjyr", "䩞"},
	{"tjyrd", "鞟"},
	{"tjytr", "鞛"},
	{"tjyvi", "䩙"},
	{"tk", "关 艾"},
	{"tkb", "䒴"},
	{"tkbuu", "䚆"},
	{"tkce", "蔱"},
	{"tkd", "檠"},
	{"tkdn", "䓭"},
	{"tke", "苃"},
	{"tkha", "蕏"},
	{"tkhaf", "鴱 鶧 𪅐 𪆴"},
	{"tkhf", "荻"},
	{"tkhg", "莥 䔆"},
	{"tkhi", "藱"},
	{"tkhk", "获"},
	{"tkhl", "䓄"},
	{"tkhqu", "㲟"},
	{"tkhr", "𦸒"},
	{"tkhu", "莸"},
	{"tkhw", "蕕"},
	{"tkit", "葢"},
	{"tkjt", "莾"},
	{"tkk", "䒝"},
	{"tkkb", "莃"},
	{"tkkk", "䔪"},
	{"tkld", "荐"},
	{"tklg", "茬"},
	{"tklmi", "蟼"},
	{"tkln", "苅"},
	{"tklu", "菴"},
	{"tkmf", "萘"},
	{"tkmr", "䓫"},
	{"tkms", "荂"},
	{"tkmvn", "㽀"},
	{"tkn", "艽 荑"},
	{"tkni", "芄"},
	{"tknl", "鄚 鄭 䣐"},
	{"tkok", "蒺"},
	{"tkoo", "莢"},
	{"tkp", "憼"},
	{"tkpb", "蔕"},
	{"tkpu", "䓐"},
	{"tkq", "擎"},
	{"tkr", "若"},
	{"tkri", "蠚"},
	{"tkrp", "惹"},
	{"tks", "艻"},
	{"tksc", "苏"},
	{"tksqf", "驚"},
	{"tksr", "茄"},
	{"tkss", "荔"},
	{"tkt", "荚 㢣"},
	{"tkymr", "警"},
	{"tl", "𦬕"},
	{"tlav", "䕣"},
	{"tlb", "芇 䒥"},
	{"tlbk", "英"},
	{"tlbo", "㒼 䓣"},
	{"tlbr", "萜"},
	{"tlbu", "䒞"},
	{"tlim", "虄"},
	{"tlit", "蓝"},
	{"tlj", "革"},
	{"tlkf", "𩤯 𪃳"},
	{"tlll", "䔥"},
	{"tllmi", "蟴"},
	{"tlln", "茀"},
	{"tlmc", "蕢"},
	{"tlmg", "荘"},
	{"tlmi", "茧 蒋"},
	{"tlmm", "韮"},
	{"tlmo", "蒉"},
	{"tlmp", "苝"},
	{"tlmt", "藎"},
	{"tlmvn", "㽄"},
	{"tlmy", "菲"},
	{"tlpf", "燕 鷰 㷼"},
	{"tlpv", "嬊"},
	{"tlq", "茟"},
	{"tlqm", "堇"},
	{"tlsg", "蔺"},
	{"tlvk", "藪"},
	{"tlw", "苖"},
	{"tlwc", "黄"},
	{"tlwk", "茰"},
	{"tlwp", "䒶"},
	{"tlwv", "蔞"},
	{"tlx", "蕭"},
	{"tlyd", "䕁"},
	{"tlyk", "𦻔"},
	{"tlyp", "蕜"},
	{"tm", "甘 㐀"},
	{"tmam", "荁"},
	{"tmbb", "薷"},
	{"tmbc", "䔈"},
	{"tmbf", "虉"},
	{"tmbg", "藿"},
	{"tmbhu", "觐"},
	{"tmbi", "蕓 蕶"},
	{"tmbk", "䓴"},
	{"tmbl", "荋"},
	{"tmbm", "䖅"},
	{"tmbr", "蘦 虂"},
	{"tmbu", "蘎"},
	{"tmbuu", "覲"},
	{"tmbw", "蕾"},
	{"tmce", "蘷"},
	{"tmcw", "茜 莤"},
	{"tmd", "某 芋"},
	{"tmdhe", "㿷"},
	{"tmdm", "藶"},
	{"tmf", "芣"},
	{"tmfb", "薾"},
	{"tmff", "蒜"},
	{"tmfh", "㝻"},
	{"tmfj", "苹"},
	{"tmfm", "苤"},
	{"tmfo", "䕯"},
	{"tmfr", "䓏"},
	{"tmgf", "蘸"},
	{"tmgn", "菿 薽 䔷"},
	{"tmgr", "蘁"},
	{"tmgt", "䔊"},
	{"tmhaf", "䲺"},
	{"tmhf", "蒝"},
	{"tmhg", "蕥"},
	{"tmhjr", "甛"},
	{"tmhl", "䓉"},
	{"tmhml", "斳"},
	{"tmig", "荎"},
	{"tmj", "芉"},
	{"tmjo", "𦮖"},
	{"tmjwj", "䡨"},
	{"tmks", "勤"},
	{"tmku", "芜"},
	{"tmlb", "𦲸"},
	{"tmlii", "䗣"},
	{"tmlk", "莄"},
	{"tmlm", "菫"},
	{"tmm", "兰"},
	{"tmmc", "其"},
	{"tmmf", "䒬"},
	{"tmmi", "芸"},
	{"tmmp", "䕻"},
	{"tmmr", "䓊"},
	{"tmms", "葝"},
	{"tmmu", "芫"},
	{"tmmv", "甚"},
	{"tmmvn", "㽍"},
	{"tmmwj", "㽑"},
	{"tmn", "艼"},
	{"tmnf", "𦶣"},
	{"tmnh", "薚"},
	{"tmnj", "茿"},
	{"tmnl", "邯 鄞"},
	{"tmnm", "薤"},
	{"tmnn", "茢"},
	{"tmno", "歏"},
	{"tmnr", "苛"},
	{"tmnv", "蒆 薞"},
	{"tmoa", "藸"},
	{"tmob", "苪"},
	{"tmom", "蕤"},
	{"tmoo", "莁"},
	{"tmoq", "蕐"},
	{"tmpg", "塟"},
	{"tmpt", "葬"},
	{"tmrb", "蒚"},
	{"tmrm", "䕢"},
	{"tmrr", "藞 䔅"},
	{"tmrt", "荳"},
	{"tmrw", "葍"},
	{"tmsu", "苊"},
	{"tmt", "茾"},
	{"tmtc", "䕱"},
	{"tmtj", "華"},
	{"tmtn", "荊"},
	{"tmto", "蕨"},
	{"tmtxc", "㽐"},
	{"tmue", "𦷜"},
	{"tmvb", "䔚"},
	{"tmvh", "芽"},
	{"tmvi", "蓐"},
	{"tmvm", "莖"},
	{"tmvs", "䒓"},
	{"tmwc", "黃"},
	{"tmwd", "䔁"},
	{"tmwf", "蔈"},
	{"tmwg", "䓰"},
	{"tmwj", "蕈"},
	{"tmwm", "薑"},
	{"tmwr", "䔯"},
	{"tmwt", "𧂯"},
	{"tmwu", "蓜"},
	{"tmwv", "葽 䖆"},
	{"tmy", "芐"},
	{"tmyf", "蔫"},
	{"tmym", "𦭒"},
	{"tmymu", "齹"},
	{"tn", "艺 芎"},
	{"tnau", "莬"},
	{"tnbc", "萯"},
	{"tnbe", "藑"},
	{"tnbj", "蔛"},
	{"tnbn", "葪"},
	{"tnbq", "薢"},
	{"tncr", "薝"},
	{"tnd", "芓"},
	{"tndf", "蓀"},
	{"tndo", "菰"},
	{"tndt", "䓝"},
	{"tndu", "芤"},
	{"tnef", "蒸"},
	{"tnem", "䒱 䓧"},
	{"tnet", "䕄"},
	{"tnfd", "蘇"},
	{"tnfn", "薊"},
	{"tnfq", "蘚"},
	{"tnhd", "葇"},
	{"tnhe", "芨"},
	{"tnhk", "䓮"},
	{"tnhs", "艿 蓩"},
	{"tnhx", "萏"},
	{"tni", "苰"},
	{"tnih", "茅"},
	{"tnii", "蔃"},
	{"tnil", "茒"},
	{"tnin", "芧 茤"},
	{"tniq", "荈"},
	{"tnir", "茗"},
	{"tniu", "苑"},
	{"tniv", "蕵"},
	{"tniw", "䓿"},
	{"tnj", "䒖"},
	{"tnkg", "莛"},
	{"tnkm", "莚"},
	{"tnl", "䒡"},
	{"tnlb", "荫 䔺"},
	{"tnlc", "藬"},
	{"tnld", "蒢"},
	{"tnle", "䔖"},
	{"tnlh", "苐 萨"},
	{"tnli", "蔭 䕃"},
	{"tnlm", "蕯 薩"},
	{"tnlo", "䔹"},
	{"tnlp", "蘟 𦱆 𦻕"},
	{"tnlr", "䔒"},
	{"tnlu", "𦶤"},
	{"tnlw", "蔯"},
	{"tnmb", "䔫 䕳"},
	{"tnmbc", "顭"},
	{"tnmi", "䒭"},
	{"tnmm", "蒻 䕬"},
	{"tnmn", "蓟"},
	{"tnmq", "藓"},
	{"tnmu", "蔬"},
	{"tnnc", "蕷"},
	{"tnnl", "鄸"},
	{"tnno", "蓣"},
	{"tno", "芡"},
	{"tnoe", "蕟"},
	{"tnok", "葵"},
	{"tnom", "茎"},
	{"tnoo", "𦴧"},
	{"tnot", "䔲"},
	{"tnqd", "𦵴"},
	{"tnsd", "䒳"},
	{"tnsj", "葞"},
	{"tnsp", "莻"},
	{"tnst", "萾"},
	{"tntg", "虇"},
	{"tnue", "菡"},
	{"tnui", "菟"},
	{"tnup", "葾"},
	{"tnus", "葂"},
	{"tnwf", "䔡"},
	{"tnyi", "𦱁"},
	{"tnyk", "荬"},
	{"toav", "艱"},
	{"tob", "芮"},
	{"tobg", "蒮"},
	{"tocu", "䓲"},
	{"tod", "茠 茶"},
	{"todi", "苻"},
	{"todj", "䔑"},
	{"todv", "藵"},
	{"tof", "苶"},
	{"tog", "茌 萑 雈"},
	{"toge", "蒦"},
	{"togf", "蕉"},
	{"togrr", "囏"},
	{"togx", "舊"},
	{"tohaf", "鸏 䴆"},
	{"tohg", "荏"},
	{"tohj", "𦭛"},
	{"tohqm", "㽔"},
	{"tohqu", "氋 㲫"},
	{"tohs", "莋"},
	{"tohv", "䔀"},
	{"toi", "茷 㕗"},
	{"toiav", "養"},
	{"toibp", "㔮"},
	{"toic", "䕘"},
	{"toie", "葰"},
	{"toii", "苓"},
	{"toik", "茯"},
	{"toin", "芩"},
	{"toip", "菍 䒫"},
	{"toir", "蒼"},
	{"toiv", "䓹"},
	{"tok", "䒨"},
	{"tokf", "蘩"},
	{"tokg", "薙"},
	{"tokp", "𧁋"},
	{"tokr", "䓡"},
	{"tol", "茽"},
	{"tolb", "蓨"},
	{"told", "蓧"},
	{"tolh", "蓚"},
	{"tolk", "莜"},
	{"toll", "养 芥"},
	{"tom", "茊"},
	{"toma", "薈"},
	{"tomb", "菕 蘥"},
	{"tomd", "荼"},
	{"tomg", "荃"},
	{"tomi", "荟"},
	{"tomk", "蔹"},
	{"tomm", "芢"},
	{"tomn", "芞 萮"},
	{"tomo", "薟"},
	{"tomr", "荅 荷"},
	{"tomt", "葊"},
	{"ton", "䒗"},
	{"tonk", "葔"},
	{"tono", "歎"},
	{"tons", "芿"},
	{"tonwf", "鯗"},
	{"too", "苁"},
	{"tooe", "蓌"},
	{"toog", "莝 難"},
	{"took", "蘞"},
	{"toom", "葅"},
	{"tooo", "蘝"},
	{"toos", "䔢"},
	{"top", "花"},
	{"topp", "蒊"},
	{"topym", "鹲"},
	{"toqb", "蒨"},
	{"tord", "葆"},
	{"tose", "葠"},
	{"tosp", "㗡"},
	{"tosr", "𦴨"},
	{"tosu", "苍"},
	{"totf", "蕪"},
	{"totv", "𧁓"},
	{"tou", "苮"},
	{"touk", "蒛"},
	{"toum", "䔘"},
	{"towy", "莓"},
	{"toym", "𦮳"},
	{"toyr", "蓓 𦴩"},
	{"toyt", "莅"},
	{"toyv", "𦲤"},
	{"tp", "芯"},
	{"tpa", "荀 𦮂"},
	{"tpdc", "蘔"},
	{"tpfc", "蘏"},
	{"tpfd", "菊"},
	{"tph", "苾"},
	{"tphh", "芴"},
	{"tpho", "㒸"},
	{"tphp", "䓤"},
	{"tpi", "芍 芶"},
	{"tpib", "葡"},
	{"tpir", "𦲀"},
	{"tpkk", "茐"},
	{"tpko", "薿"},
	{"tpkp", "葱"},
	{"tpmc", "䔛"},
	{"tpmw", "蔔"},
	{"tpo", "苌"},
	{"tpou", "萄"},
	{"tpp", "芘"},
	{"tppa", "蒈"},
	{"tppd", "蘂"},
	{"tppj", "荜"},
	{"tppp", "蕊"},
	{"tpr", "苟 茍"},
	{"tpru", "苞"},
	{"tpsh", "苆"},
	{"tpt", "𦭓"},
	{"tptd", "葉"},
	{"tpu", "芚"},
	{"tpua", "萅"},
	{"tpuu", "蒭"},
	{"tpw", "䓒"},
	{"tpym", "茑"},
	{"tpyv", "蘹 𦮝"},
	{"tq", "羊 𦍋 ⺶"},
	{"tqao", "䔶"},
	{"tqapv", "羯"},
	{"tqau", "羓"},
	{"tqav", "䔾"},
	{"tqbd", "𧂮"},
	{"tqbu", "着"},
	{"tqcsh", "羒"},
	{"tqd", "䒹"},
	{"tqda", "藉"},
	{"tqdb", "藕"},
	{"tqdi", "𦶮 𧂭"},
	{"tqdj", "䍪"},
	{"tqdmq", "䍷"},
	{"tqdw", "䍶"},
	{"tqeee", "䍳"},
	{"tqeq", "萚"},
	{"tqfh", "莏"},
	{"tqhaf", "鴹"},
	{"tqhdv", "䍴"},
	{"tqhdw", "羳"},
	{"tqhhh", "羏"},
	{"tqhk", "葜"},
	{"tqhl", "䓆"},
	{"tqhne", "羖"},
	{"tqhpm", "羝"},
	{"tqhr", "葀"},
	{"tqhuk", "䍹"},
	{"tqhxu", "䍲"},
	{"tqiav", "羪"},
	{"tqib", "蒱"},
	{"tqibi", "䍸"},
	{"tqice", "羧"},
	{"tqihr", "羬"},
	{"tqii", "兿"},
	{"tqij", "羢"},
	{"tqik", "菝"},
	{"tqixe", "羻"},
	{"tqj", "䒠"},
	{"tqjb", "䍨"},
	{"tqjcm", "羫"},
	{"tqjm", "蔧"},
	{"tqjmn", "羜"},
	{"tqjmu", "羦"},
	{"tqjo", "蓵"},
	{"tqjp", "䍫"},
	{"tqjtc", "羵"},
	{"tqka", "萶"},
	{"tqkd", "蓁"},
	{"tqki", "䓓"},
	{"tqkn", "羠"},
	{"tqkq", "菶"},
	{"tqks", "劷"},
	{"tqllp", "䍺"},
	{"tqlmo", "䍮"},
	{"tqlw", "菗"},
	{"tqm", "差"},
	{"tqmb", "菁"},
	{"tqmbb", "羺"},
	{"tqmc", "蔶"},
	{"tqmf", "㷢"},
	{"tqmfj", "䍬"},
	{"tqmhf", "羱"},
	{"tqmhm", "䍽"},
	{"tqmua", "䍼"},
	{"tqmvm", "羥"},
	{"tqmy", "䓯"},
	{"tqng", "羞"},
	{"tqnmu", "䍯"},
	{"tqnom", "羟"},
	{"tqnsd", "䍵"},
	{"tqnwf", "鮺"},
	{"tqnwm", "鲝"},
	{"tqo", "芙"},
	{"tqog", "蓷"},
	{"tqoii", "羚"},
	{"tqok", "䍩"},
	{"tqomd", "䍱"},
	{"tqomn", "羭"},
	{"tqomo", "羷"},
	{"tqpu", "菢"},
	{"tqqo", "荴"},
	{"tqrd", "𧂈"},
	{"tqrj", "䔱"},
	{"tqruc", "䍻"},
	{"tqs", "苇"},
	{"tqsmm", "翔"},
	{"tqsr", "萔"},
	{"tqsyq", "𦎾"},
	{"tqtqq", "羴"},
	{"tqumf", "羰"},
	{"tqwj", "蘀"},
	{"tqwk", "䍰"},
	{"tqwyi", "䍭"},
	{"tqyrr", "譱"},
	{"tqyt", "菈"},
	{"tqywm", "羶"},
	{"tr", "𦬅"},
	{"trau", "䓃"},
	{"trbc", "蒷"},
	{"trhr", "莒"},
	{"trjd", "菋"},
	{"trji", "蕺"},
	{"trjl", "蘄 䕤"},
	{"trln", "剳"},
	{"trlr", "苢"},
	{"trmi", "䕽"},
	{"trmr", "蕗"},
	{"trnl", "鄀 鄯"},
	{"trno", "歚"},
	{"trob", "莴"},
	{"trog", "蓶"},
	{"trok", "敬"},
	{"tron", "荶"},
	{"trrg", "雚"},
	{"trrj", "蕇"},
	{"trrk", "䕾"},
	{"trrr", "虈 䓵 䖀"},
	{"trrs", "萼 蕚"},
	{"trsj", "葺"},
	{"trsn", "莂"},
	{"trtrr", "䖃"},
	{"tru", "𦬊"},
	{"trvk", "茣"},
	{"trvp", "苠"},
	{"trye", "葭 㪨"},
	{"tryo", "莡"},
	{"tsc", "苉"},
	{"tsec", "藖"},
	{"tsem", "蘙"},
	{"tseo", "藂"},
	{"tsfi", "蔚"},
	{"tsh", "芀"},
	{"tshh", "茘"},
	{"tshr", "苕"},
	{"tshu", "荱"},
	{"tsic", "蕻"},
	{"tsim", "䔼"},
	{"tsip", "荵 藯"},
	{"tsiq", "蕼"},
	{"tsit", "藍"},
	{"tsj", "茸"},
	{"tsja", "蘵"},
	{"tsjb", "䔜"},
	{"tsjd", "蘗"},
	{"tsje", "菆"},
	{"tsjl", "𦳃"},
	{"tsk", "芛"},
	{"tskr", "莙"},
	{"tsl", "节"},
	{"tslc", "䕚"},
	{"tsle", "菣"},
	{"tsll", "茝 茞"},
	{"tsm", "䒒"},
	{"tsmb", "菷"},
	{"tsmg", "藋 䒰"},
	{"tsmh", "蓼"},
	{"tsmi", "蕁"},
	{"tsmj", "䕜"},
	{"tsmv", "萇"},
	{"tso", "𦬨"},
	{"tsoy", "荩"},
	{"tsp", "懃 苨"},
	{"tsqf", "䔍"},
	{"tsql", "𦰡"},
	{"tsrf", "蔒"},
	{"tsrj", "薜"},
	{"tsrr", "蓲"},
	{"tss", "苣"},
	{"tsu", "芑"},
	{"tsuu", "䓛"},
	{"tt", "井 卌 并"},
	{"ttbc", "䓦"},
	{"ttbn", "葥"},
	{"ttbuu", "䚊"},
	{"ttc", "並"},
	{"ttce", "䕺"},
	{"ttcf", "藄"},
	{"ttcg", "蘣 蘳 𦸀"},
	{"ttcl", "䔮"},
	{"ttcnh", "豑"},
	{"tte", "汬"},
	{"ttg", "坓"},
	{"ttgb", "冓"},
	{"ttgf", "蓔 䖄"},
	{"ttgi", "薱 䕏"},
	{"ttgk", "䓺"},
	{"ttgv", "葁"},
	{"tthaf", "鵧 鷁"},
	{"tthhh", "㣋"},
	{"tti", "丼"},
	{"ttjd", "蘜"},
	{"ttjl", "龩"},
	{"ttks", "㔙"},
	{"ttlm", "蓳"},
	{"ttln", "荆 㓝"},
	{"ttm", "苷"},
	{"ttmbc", "頩"},
	{"ttmc", "萁"},
	{"ttmd", "𦳑"},
	{"ttmv", "葚"},
	{"ttmvn", "瓶"},
	{"ttnau", "艵 艶 䒎"},
	{"ttnl", "郱"},
	{"ttof", "䕿"},
	{"ttog", "䕼"},
	{"ttp", "㤣"},
	{"ttpym", "鹢"},
	{"ttq", "𦭵"},
	{"ttqm", "蒫"},
	{"ttshi", "刱 剙"},
	{"ttt", "荓"},
	{"tttt", "㐩"},
	{"ttub", "蒴"},
	{"ttvb", "蘛"},
	{"ttw", "䒼"},
	{"ttwa", "蓸"},
	{"ttwi", "䔿"},
	{"ttwli", "蠲"},
	{"ttwv", "蕽"},
	{"ttxc", "蒹"},
	{"tu", "屰"},
	{"tub", "朔"},
	{"tuce", "葼"},
	{"tufe", "䔴"},
	{"tuirm", "馘"},
	{"tujt", "蘴"},
	{"tumbc", "䭭"},
	{"tumt", "䔇"},
	{"tumvn", "㼹"},
	{"tunau", "䒐"},
	{"tuno", "欮"},
	{"turu", "䒻"},
	{"tuu", "茁"},
	{"tvfa", "𦻖"},
	{"tvfb", "蒳"},
	{"tvfd", "虊"},
	{"tvfe", "藧"},
	{"tvff", "蕬"},
	{"tvfh", "尠 蒶 䔋 𦯷"},
	{"tvfi", "葤 葯"},
	{"tvfj", "蘕"},
	{"tvfm", "葒"},
	{"tvfp", "𧄉"},
	{"tvfq", "䖂"},
	{"tvfr", "𦹄 𦿟"},
	{"tvft", "蘊"},
	{"tvfu", "蒓 蕝"},
	{"tvfv", "䕑 𧃒"},
	{"tvfy", "蔠"},
	{"tvhe", "䕅"},
	{"tvhg", "䔨"},
	{"tvhi", "𦶥"},
	{"tvhl", "薌"},
	{"tvhp", "䒲"},
	{"tvi", "戡"},
	{"tvid", "孳 孶 藥"},
	{"tvif", "鶿 䒺"},
	{"tvih", "䓼"},
	{"tvii", "兹 茲"},
	{"tvin", "甆"},
	{"tvio", "苡"},
	{"tvip", "慈 慈"},
	{"tvis", "苭 䒛"},
	{"tvj", "卙"},
	{"tvjd", "𦳀"},
	{"tvje", "𦺋"},
	{"tvjr", "菇"},
	{"tvju", "𦹅"},
	{"tvks", "勘 㔦"},
	{"tvlbu", "㽎"},
	{"tvlk", "荍"},
	{"tvmbc", "䫖"},
	{"tvmd", "䕈"},
	{"tvmg", "莊"},
	{"tvmi", "药 蔣 薅"},
	{"tvmm", "荭"},
	{"tvmt", "蕴"},
	{"tvmu", "莼"},
	{"tvmw", "葘 蘠"},
	{"tvnd", "䒵"},
	{"tvne", "菉"},
	{"tvnin", "夦"},
	{"tvno", "歁"},
	{"tvr", "茹"},
	{"tvrf", "蕠"},
	{"tvrq", "蒘"},
	{"tvsl", "𦶦"},
	{"tvsp", "𦲁"},
	{"tvuk", "𦾡"},
	{"tvvh", "芗"},
	{"tvvj", "䓸"},
	{"tvvv", "葌"},
	{"tvvw", "菑"},
	{"tvye", "㪛"},
	{"tvyj", "斟"},
	{"tvyv", "𦴣"},
	{"tw", "曲 苗"},
	{"twa", "曹"},
	{"twbi", "蠆 䘍"},
	{"twbo", "躉 𧄌"},
	{"twcb", "莔"},
	{"twd", "菓"},
	{"twdi", "尊"},
	{"twf", "㷕"},
	{"twfr", "䕸"},
	{"twfu", "蔨"},
	{"twg", "荲"},
	{"twgv", "薗"},
	{"twhaf", "鶓"},
	{"twhd", "菌"},
	{"twik", "猷"},
	{"twiku", "𨠫"},
	{"twim", "蔮"},
	{"twirm", "䤋"},
	{"twjr", "䓢"},
	{"twk", "奠 茵"},
	{"twkp", "蒽"},
	{"twks", "莮"},
	{"twla", "薯"},
	{"twlb", "萬"},
	{"twlc", "蕒"},
	{"twle", "蘉"},
	{"twlg", "蘿"},
	{"twli", "蔑 薎"},
	{"twlii", "蠤"},
	{"twlj", "䕉"},
	{"twln", "夢 甍 藅 蘮"},
	{"twlo", "䠢"},
	{"twlp", "薨 藣"},
	{"twlu", "瞢"},
	{"twmgi", "㻃"},
	{"twmmv", "農"},
	{"twmrt", "豊"},
	{"twmv", "葨"},
	{"two", "苬"},
	{"twot", "蒕"},
	{"twp", "葸 㤟"},
	{"twpym", "鹋"},
	{"twr", "茴"},
	{"twtc", "䔬"},
	{"twtj", "蓽"},
	{"twv", "𦮗"},
	{"twvf", "蔂"},
	{"twwd", "蘽"},
	{"twwf", "虆"},
	{"twwg", "蘲"},
	{"twww", "藟"},
	{"twyi", "苺"},
	{"txc", "兼"},
	{"tyaj", "䓬"},
	{"tybb", "蒂 薖"},
	{"tybg", "蘺"},
	{"tybo", "藃"},
	{"tybp", "蘢"},
	{"tybs", "蒡"},
	{"tybu", "𦾾"},
	{"tycb", "蔏 蔐"},
	{"tycj", "𧅵"},
	{"tyck", "茭"},
	{"tycu", "萒"},
	{"tycv", "蔉 𦶧"},
	{"tydg", "䕹"},
	{"tydk", "䔻"},
	{"tydl", "薪 䔎"},
	{"tydo", "藗"},
	{"tydu", "藽"},
	{"tyed", "薒"},
	{"tyfd", "蒾"},
	{"tyfe", "菽"},
	{"tygq", "薘"},
	{"tygv", "薳"},
	{"tyhc", "蘋"},
	{"tyhj", "蓬"},
	{"tyhl", "菦"},
	{"tyhn", "苀"},
	{"tyhr", "䔏"},
	{"tyhs", "芳"},
	{"tyhv", "䒾"},
	{"tyib", "𦱀"},
	{"tyij", "䔞"},
	{"tyiu", "茺"},
	{"tyiv", "䕂"},
	{"tyjj", "蓮"},
	{"tyk", "芠"},
	{"tykl", "荠"},
	{"tykq", "莲"},
	{"tylh", "荹"},
	{"tylm", "芷"},
	{"tyln", "㔈"},
	{"tym", "䒙"},
	{"tymd", "蘃"},
	{"tymf", "茮"},
	{"tymh", "薉"},
	{"tymm", "蕋"},
	{"tymo", "蓫"},
	{"tymp", "茈"},
	{"tymr", "䓂"},
	{"tymu", "䓕"},
	{"tynb", "蓪"},
	{"tynf", "䕖"},
	{"tynv", "䕦"},
	{"tyoe", "藙"},
	{"tyog", "𦻗"},
	{"tyoj", "萃"},
	{"typd", "䓱"},
	{"type", "𧃍"},
	{"typf", "䔝"},
	{"typm", "蔖"},
	{"typp", "藘"},
	{"typt", "蘆"},
	{"typu", "萀"},
	{"tyr", "苫"},
	{"tyra", "藷"},
	{"tyrb", "蒿 𧀎"},
	{"tyrd", "藁 藳"},
	{"tyre", "蔎 蕸 蘐 䕶 𦻑"},
	{"tyrj", "䔓"},
	{"tyrl", "蔀"},
	{"tyrn", "葶"},
	{"tyro", "䕛"},
	{"tyrp", "薧"},
	{"tyru", "䓽"},
	{"tyrv", "藹 蘘"},
	{"tysd", "葹"},
	{"tysk", "蔟"},
	{"tysm", "虀"},
	{"tyso", "蔙"},
	{"tysp", "𦴪"},
	{"tysy", "菸"},
	{"tyt", "苙"},
	{"tyta", "萻"},
	{"tytb", "𦽴"},
	{"tytg", "蕫"},
	{"tyti", "𦲂 𦵑"},
	{"tytj", "莘"},
	{"tytp", "薏"},
	{"tytr", "菩 蒟"},
	{"tytu", "䔔"},
	{"tytv", "菨"},
	{"tyub", "蓠"},
	{"tyue", "𡖂 䕫"},
	{"tyv", "芒"},
	{"tyvb", "䕍"},
	{"tyvg", "蕹"},
	{"tyvo", "荄"},
	{"tyvp", "莣"},
	{"tyvu", "荒"},
	{"tyvw", "蓄"},
	{"tywi", "蓾"},
	{"tywm", "䕊"},
	{"tywv", "蓑"},
	{"tyx", "薺"},
	{"tyy", "苄"},
	{"tyyb", "藡"},
	{"tyyo", "蘧"},
	{"u", "山"},
	{"ua", "㞱"},
	{"uagi", "嵵"},
	{"uahu", "嵋"},
	{"uamh", "崵"},
	{"uamo", "崼"},
	{"uana", "𡼏"},
	{"uang", "㠈"},
	{"uapp", "崐 崑"},
	{"uapv", "嵑"},
	{"uau", "岜"},
	{"uav", "峎"},
	{"ub", "岄"},
	{"ubac", "㟰"},
	{"ubb", "崩"},
	{"ubcn", "崱"},
	{"ubcv", "巊"},
	{"ubhaf", "䳪"},
	{"ubhu", "岘"},
	{"ubjj", "㟦"},
	{"ubk", "岗"},
	{"ubln", "剬 剻 㔒"},
	{"ubm", "岨"},
	{"ubmbc", "顓"},
	{"ubmbo", "颛"},
	{"ubme", "嵈"},
	{"ubmp", "嶾"},
	{"ubmr", "峒"},
	{"ubmvn", "㼷"},
	{"ubnd", "㟊"},
	{"ubnl", "酅 䣙"},
	{"ubno", "歂"},
	{"ubqr", "㟘"},
	{"ubsd", "崢"},
	{"ubtu", "崗 㟠"},
	{"ubuu", "峴 𡷹"},
	{"ubv", "㟎"},
	{"ubvk", "嵠"},
	{"ubye", "㪜"},
	{"uc", "崟 崯"},
	{"uche", "㚇"},
	{"uchh", "㟗"},
	{"ucim", "嵡"},
	{"ucno", "嶔"},
	{"ucor", "峪"},
	{"ucru", "㟋"},
	{"ucsh", "岎 㞣"},
	{"ucwa", "嶒"},
	{"udam", "嵖"},
	{"udci", "崧 㟣"},
	{"udd", "崊"},
	{"uddi", "㠨"},
	{"udhe", "岥"},
	{"udii", "嶘"},
	{"udmq", "𡺨"},
	{"udoo", "崍"},
	{"udsmg", "糶"},
	{"udt", "崃"},
	{"udw", "崠 崬"},
	{"udyg", "嵀"},
	{"ue", "凼 汖"},
	{"uea", "崉"},
	{"ueg", "埊"},
	{"ueq", "峄"},
	{"ufb", "峭"},
	{"ufcb", "嵴"},
	{"ufdq", "嶙"},
	{"ufdv", "嵝"},
	{"uffd", "嶸"},
	{"uffr", "巆"},
	{"uffs", "嶗"},
	{"ufgi", "巀"},
	{"ufhaf", "䳳"},
	{"ufku", "㞊"},
	{"ufln", "㓽"},
	{"ufmk", "巌"},
	{"ufno", "㱁"},
	{"ufok", "𪑛"},
	{"ufqu", "㟡"},
	{"ufru", "䄐"},
	{"ufua", "𡾡"},
	{"ug", "凷"},
	{"ugce", "崚"},
	{"ugdi", "峙"},
	{"uggi", "崶"},
	{"uggu", "嶢 嶤"},
	{"ughaf", "䳽"},
	{"ugk", "㞿"},
	{"ugni", "嶹"},
	{"ugno", "崁"},
	{"uh", "匕"},
	{"uha", "岶"},
	{"uhae", "㟫"},
	{"uhaf", "嶋"},
	{"uhag", "崲"},
	{"uhaj", "㟸"},
	{"uhbk", "㠗"},
	{"uhdj", "嵙"},
	{"uhdn", "峲"},
	{"uhdp", "嵊"},
	{"uhdv", "崣"},
	{"uhdw", "嶓"},
	{"uhe", "岅"},
	{"uhej", "峯 峰"},
	{"uheq", "𡶶"},
	{"uher", "峈 峉"},
	{"uhey", "峂"},
	{"uhgr", "峼"},
	{"uhhe", "㠟"},
	{"uhhj", "崥"},
	{"uhhl", "峁"},
	{"uhhw", "嵧"},
	{"uhi", "嵬"},
	{"uhiv", "㠢"},
	{"uhjm", "崜"},
	{"uhk", "岆"},
	{"uhkb", "嶠 㠐"},
	{"uhkl", "峤"},
	{"uhmb", "巋"},
	{"uhml", "岓"},
	{"uhn", "㞦"},
	{"uhnb", "𡶺"},
	{"uhni", "嵐 㞩 𡺤"},
	{"uhnk", "岚"},
	{"uhoe", "㠅"},
	{"uhoi", "崻"},
	{"uhok", "嶶 𡽪"},
	{"uhoo", "嵷 嵸"},
	{"uhoq", "嵂"},
	{"uhpa", "崏"},
	{"uhqi", "峨 峩"},
	{"uhrf", "嵨"},
	{"uhrj", "嶭"},
	{"uhs", "岝 岞"},
	{"uhuc", "巑"},
	{"uhud", "嵲"},
	{"uhui", "㟴"},
	{"uhvi", "巍"},
	{"uhvl", "岇"},
	{"uhvp", "㞴"},
	{"uhxc", "嶼 㠘"},
	{"uhxe", "㟬"},
	{"uhxu", "𡸣"},
	{"uiav", "崀 㟍"},
	{"uice", "峻"},
	{"uidy", "㠧"},
	{"uihaf", "䳥"},
	{"uihf", "𡻕"},
	{"uihh", "嵗"},
	{"uihr", "嵅"},
	{"uihs", "峸 𡷫"},
	{"uihv", "崴"},
	{"uii", "㟞"},
	{"uiih", "嵾 㠁"},
	{"uijb", "峬"},
	{"uije", "㟈"},
	{"uikh", "㟥"},
	{"uilb", "㟾"},
	{"uile", "嵻"},
	{"uilr", "嵣"},
	{"uimbc", "䫜"},
	{"uimo", "𡷑"},
	{"uino", "㞫"},
	{"uip", "鬯"},
	{"uit", "峅"},
	{"uiuh", "㟌"},
	{"uiv", "㞽"},
	{"ujbc", "嵮"},
	{"ujbd", "㟑"},
	{"ujbm", "𡸜 𡸽"},
	{"ujc", "岤"},
	{"ujcc", "巔"},
	{"ujck", "㟮"},
	{"ujcm", "崆"},
	{"ujco", "巅"},
	{"ujcr", "嵱"},
	{"ujd", "櫱"},
	{"uje", "岐"},
	{"ujfd", "糱"},
	{"ujhq", "㟉"},
	{"ujhr", "㟯"},
	{"ujig", "嶻"},
	{"ujjl", "嶄"},
	{"ujki", "峵"},
	{"ujkp", "峔"},
	{"ujlmi", "蠥"},
	{"ujlo", "崨"},
	{"ujmf", "崇"},
	{"ujmrt", "豐"},
	{"ujnd", "孼"},
	{"ujp", "岮"},
	{"ujpu", "峣"},
	{"ujr", "岵"},
	{"ujsh", "㔎"},
	{"ujv", "峖"},
	{"uk", "凶"},
	{"ukb", "峟"},
	{"ukcf", "嶚 嶛"},
	{"ukd", "岽"},
	{"ukg", "峚"},
	{"ukhk", "嶽"},
	{"ukhu", "兇"},
	{"ukjj", "輋"},
	{"ukkb", "崤 㟓"},
	{"uklu", "崦"},
	{"ukmr", "崎 㟢"},
	{"ukn", "峓"},
	{"ukoo", "峽"},
	{"ukpb", "嵽"},
	{"ukql", "崭"},
	{"uks", "屴"},
	{"uksr", "𡶐"},
	{"ukt", "峡"},
	{"ul", "屮 㞲 屮"},
	{"ulbk", "岟"},
	{"ulln", "岪"},
	{"ulls", "岿"},
	{"ullv", "㟺"},
	{"ulq", "峍"},
	{"ulw", "岫"},
	{"ulwv", "嶁"},
	{"um", "屸 㞢 㞬"},
	{"uma", "旹"},
	{"umam", "峘"},
	{"umbb", "嶿"},
	{"umbc", "崸"},
	{"umbl", "峏 耑"},
	{"umbs", "嶀"},
	{"umce", "巎"},
	{"umf", "炭 㞸"},
	{"umfj", "岼"},
	{"umfm", "岯"},
	{"umfn", "㠒"},
	{"umg", "㞷"},
	{"umgg", "崕 崖"},
	{"umgt", "㟖"},
	{"umhf", "㟲 㟶"},
	{"umhl", "峫"},
	{"umhm", "㠣"},
	{"umig", "峌"},
	{"umj", "屽"},
	{"umli", "蚩"},
	{"umlk", "峺"},
	{"umm", "亗"},
	{"ummj", "岸 㟁"},
	{"ummr", "峿"},
	{"ummu", "岏"},
	{"umnc", "嵿"},
	{"umnn", "峛"},
	{"umnr", "岢 㞹"},
	{"umog", "嵟"},
	{"umoo", "豳"},
	{"umr", "岩"},
	{"umrt", "豈"},
	{"umt", "岍"},
	{"umtb", "巁"},
	{"umtj", "崋"},
	{"umto", "嶡"},
	{"umu", "屼"},
	{"umua", "嶜"},
	{"umv", "妛"},
	{"umvh", "岈"},
	{"umvn", "㼘"},
	{"umwd", "㟳"},
	{"umwf", "㟽"},
	{"umwg", "𡺉"},
	{"umwv", "崾"},
	{"unao", "嶑"},
	{"unbq", "嶰"},
	{"uncr", "嶦"},
	{"und", "㞨"},
	{"unhe", "岋 岌"},
	{"unhs", "屷 㞧"},
	{"uni", "岁 㞮"},
	{"unii", "嵹"},
	{"unl", "邖"},
	{"unli", "㠕"},
	{"unlm", "嶐"},
	{"unln", "刿"},
	{"unmbc", "䫈"},
	{"unme", "㟤"},
	{"unmm", "嵶"},
	{"unmu", "峗 峞"},
	{"unne", "凾"},
	{"unnf", "㟜"},
	{"uno", "㰞"},
	{"unot", "嶝"},
	{"unqd", "嵥"},
	{"unri", "巉"},
	{"unsd", "峥"},
	{"unsmm", "翙"},
	{"uo", "㞤 㞥"},
	{"uog", "崔"},
	{"uogb", "巂 雟"},
	{"uogd", "㠍 㠎"},
	{"uogf", "嶕"},
	{"uogs", "嶲 𡼕"},
	{"uoic", "嶺"},
	{"uoii", "岭 岺"},
	{"uoin", "岑 岒"},
	{"uoir", "嵢 㟏 㟔"},
	{"uoj", "㞰"},
	{"uok", "㞺"},
	{"uolk", "峳"},
	{"uoll", "岕"},
	{"uom", "岴"},
	{"uomb", "崘 崙"},
	{"uomg", "峑"},
	{"uomm", "崄"},
	{"uomn", "崳 嵛"},
	{"uomo", "嶮"},
	{"uomr", "峆 峇"},
	{"uon", "屹"},
	{"uoog", "㟇"},
	{"uopj", "㟆"},
	{"uorm", "嶖"},
	{"uoym", "峜"},
	{"upa", "峋"},
	{"upcc", "巓"},
	{"uphh", "岉"},
	{"upko", "嶷 㠜"},
	{"upr", "岣"},
	{"uqj", "𡵞"},
	{"uqkd", "𡻈"},
	{"uqmb", "崝"},
	{"uqoc", "㠝"},
	{"uqog", "嶊"},
	{"uqsk", "㟼 㠂"},
	{"uqtm", "㟛"},
	{"urhu", "岲"},
	{"urji", "嶯"},
	{"urms", "㞻"},
	{"urog", "嶉"},
	{"urpa", "㟭"},
	{"urrj", "㠆"},
	{"urrk", "巖 巗"},
	{"urrr", "嵓"},
	{"urrs", "崿 㟧 㠋"},
	{"uru", "𡵆"},
	{"urvp", "岷"},
	{"uryj", "㟕"},
	{"urytj", "辥"},
	{"usfi", "嶎"},
	{"ush", "屶"},
	{"ushi", "屻 岃"},
	{"ushr", "岧"},
	{"usjl", "㟹"},
	{"usjr", "崌"},
	{"usk", "岖"},
	{"uskr", "峮 㟒"},
	{"usma", "嶍 㠄"},
	{"usmh", "嵺"},
	{"usmr", "㟃"},
	{"usp", "㞾"},
	{"usrj", "㠔"},
	{"usrr", "嶇"},
	{"uss", "岠"},
	{"usu", "屺 岂"},
	{"usuu", "崛"},
	{"uta", "㟙"},
	{"utav", "嶱"},
	{"utbd", "嵘"},
	{"utbo", "㠓"},
	{"utbs", "崂"},
	{"utbuu", "覬"},
	{"utcd", "嶪 嶫"},
	{"utce", "巙"},
	{"utcnh", "豒"},
	{"utco", "㠌"},
	{"utcu", "㟟"},
	{"utcw", "崷"},
	{"utgf", "㟱"},
	{"utgi", "嶬 㠖 㠚"},
	{"utgit", "豔"},
	{"utgk", "嵄"},
	{"utgs", "𡾞"},
	{"uthn", "凱"},
	{"uthni", "颽"},
	{"uthv", "巕"},
	{"utik", "獃"},
	{"utit", "㟿"},
	{"utjd", "巈"},
	{"utkit", "豓"},
	{"utln", "剴"},
	{"utmbc", "顗"},
	{"utmc", "𡸷"},
	{"utmj", "㠏"},
	{"utmo", "嵌"},
	{"utmv", "嵁"},
	{"utnau", "艷"},
	{"utnl", "酆"},
	{"utoe", "㠛"},
	{"utok", "敳"},
	{"utor", "㟷"},
	{"utq", "㟄"},
	{"utqm", "嵯"},
	{"utrg", "巏"},
	{"utvi", "嵫"},
	{"utwa", "嶆"},
	{"utwi", "嶟"},
	{"utwv", "嶩"},
	{"utxc", "嵰"},
	{"utye", "敱"},
	{"utyv", "㟐"},
	{"uu", "出 屾 艸"},
	{"uubhu", "觊"},
	{"uuce", "嵕"},
	{"uufd", "粜"},
	{"uuhml", "㪿"},
	{"uuhn", "凯"},
	{"uujt", "㠦"},
	{"uuks", "㔘"},
	{"uuku", "㟅"},
	{"uuln", "剀"},
	{"uumb", "㟨"},
	{"uumbc", "䪼"},
	{"uummf", "祟"},
	{"uumt", "嵦"},
	{"uune", "崡"},
	{"uunl", "䢺"},
	{"uuno", "欪"},
	{"uuok", "𣁋"},
	{"uuu", "芔"},
	{"uuuu", "茻"},
	{"uuyhs", "芳"},
	{"uuypu", "䖓"},
	{"uvii", "幽"},
	{"uvis", "岰"},
	{"uvmi", "嶈"},
	{"uvvw", "崰"},
	{"uwjr", "崓 崮"},
	{"uwl", "岬"},
	{"uwlb", "嵎"},
	{"uwlj", "嶧"},
	{"uwlm", "㟵"},
	{"uwly", "嶵 㠑"},
	{"uwmv", "嵔 㟪"},
	{"uwp", "崽"},
	{"uwwg", "㠥"},
	{"uwyi", "㟂"},
	{"uya", "峕"},
	{"uybb", "崹"},
	{"uybk", "巘"},
	{"uybp", "巃"},
	{"uybs", "嵭"},
	{"uybt", "巐"},
	{"uycb", "㠃"},
	{"uyck", "峧"},
	{"uyfu", "㠇"},
	{"uyhh", "嵃"},
	{"uyhm", "嵼"},
	{"uyj", "㞳"},
	{"uyk", "㓙 㞵 㞶"},
	{"uymr", "訔"},
	{"uymy", "峠"},
	{"uyoj", "崒"},
	{"uypm", "㠊"},
	{"uypt", "㠠"},
	{"uyr", "岾"},
	{"uyrb", "嵩"},
	{"uyrd", "崞"},
	{"uyrn", "嵉"},
	{"uyro", "㠙"},
	{"uyrv", "㠤"},
	{"uysd", "崺"},
	{"uysm", "屿"},
	{"uysv", "㠡"},
	{"uyt", "岦"},
	{"uytg", "㠉"},
	{"uyti", "巇"},
	{"uytj", "峷 嶂"},
	{"uytr", "嵜 㟝 﨑"},
	{"uyvo", "峐"},
	{"v", "女"},
	{"vaa", "娼"},
	{"vab", "𡝭"},
	{"vabt", "媪"},
	{"vabu", "媢"},
	{"vahm", "𡟙"},
	{"vahu", "媚"},
	{"vam", "妲"},
	{"vamh", "婸"},
	{"vamj", "娨"},
	{"vamo", "媞"},
	{"vana", "𡢃"},
	{"vanb", "嫺"},
	{"vand", "嫻"},
	{"vank", "𡢄"},
	{"vanw", "孄"},
	{"vaph", "㛫"},
	{"vapp", "婫"},
	{"vau", "妑"},
	{"vawe", "嫚"},
	{"vayf", "𡡡"},
	{"vbac", "嫇"},
	{"vbbe", "嬡"},
	{"vbbm", "姗"},
	{"vbbq", "𡡞"},
	{"vbbr", "媧"},
	{"vbcv", "孆"},
	{"vbd", "婇"},
	{"vbgb", "㛵"},
	{"vbgr", "婤"},
	{"vbhf", "嬀"},
	{"vbhg", "婬"},
	{"vbhn", "㚮"},
	{"vbhx", "嫍"},
	{"vbjj", "媈"},
	{"vbkf", "㜣"},
	{"vbm", "姐"},
	{"vbme", "媛"},
	{"vbmm", "㚩"},
	{"vbmr", "姛"},
	{"vbnd", "娐"},
	{"vbou", "媱"},
	{"vbq", "𡛾"},
	{"vbsd", "婙"},
	{"vbt", "姍"},
	{"vbuc", "㛝"},
	{"vbug", "㜹"},
	{"vbuu", "娊"},
	{"vbuv", "𡢞"},
	{"vbv", "娞"},
	{"vbvk", "㜎"},
	{"vbvnb", "㣈"},
	{"vbwd", "𢑥"},
	{"vby", "𡛓"},
	{"vci", "妐"},
	{"vcim", "𡟸"},
	{"vcnh", "娣"},
	{"vcru", "娧"},
	{"vcsh", "妢"},
	{"vcwj", "婵"},
	{"vdam", "㜁"},
	{"vdbu", "㜀"},
	{"vdd", "㛦"},
	{"vddf", "𡢾"},
	{"vddo", "𡢟"},
	{"vdhml", "断"},
	{"vdj", "妺"},
	{"vdk", "妜"},
	{"vdks", "勦"},
	{"vdl", "娕"},
	{"vdlc", "嬾"},
	{"vdlk", "嫩"},
	{"vdln", "剿"},
	{"vdlo", "嫰"},
	{"vdmf", "𡞫"},
	{"vdmq", "媁"},
	{"vdnl", "鄛"},
	{"vdoo", "婡"},
	{"vdp", "恏"},
	{"vdr", "𡜺"},
	{"vdw", "娻"},
	{"vdwf", "媡"},
	{"ve", "奴"},
	{"vea", "㛥"},
	{"vebt", "盝"},
	{"vebuu", "䚄"},
	{"vec", "𨥬"},
	{"veee", "娺"},
	{"vehaf", "鴑"},
	{"veks", "努"},
	{"velb", "帑"},
	{"veln", "剝"},
	{"vemr", "砮"},
	{"ven", "弩 㐐"},
	{"vend", "孥"},
	{"venvm", "驽"},
	{"veobo", "胬"},
	{"vep", "怒"},
	{"veq", "拏"},
	{"vesqf", "駑"},
	{"vevif", "䋈"},
	{"veye", "㪖"},
	{"vfa", "曫"},
	{"vfabs", "𦄡"},
	{"vfabt", "緼"},
	{"vfafu", "縨"},
	{"vfam", "䋎"},
	{"vfamo", "緹"},
	{"vfanb", "繝"},
	{"vfanx", "䌪"},
	{"vfaph", "緆"},
	{"vfapp", "緄"},
	{"vfapv", "䋵"},
	{"vfase", "繓"},
	{"vfasm", "䌈"},
	{"vfau", "紦"},
	{"vfawe", "縵"},
	{"vfb", "娋"},
	{"vfbb", "嫦 綳"},
	{"vfbbb", "縎"},
	{"vfbbe", "綬"},
	{"vfbbr", "緺"},
	{"vfbbu", "䌐"},
	{"vfbcr", "綗"},
	{"vfbcv", "纓"},
	{"vfbd", "綵 𡡢"},
	{"vfbg", "𡠠"},
	{"vfbgr", "綢"},
	{"vfbhx", "縚"},
	{"vfbjj", "緷"},
	{"vfbk", "䋄"},
	{"vfbkf", "繎"},
	{"vfbkk", "䋞"},
	{"vfbm", "組"},
	{"vfbme", "緩"},
	{"vfbmp", "䌥"},
	{"vfbmr", "絧"},
	{"vfbnd", "綒"},
	{"vfbof", "縩"},
	{"vfbou", "䌊"},
	{"vfbr", "絅"},
	{"vfbsh", "絼"},
	{"vfbtu", "綱"},
	{"vfbtv", "網"},
	{"vfbu", "矕"},
	{"vfbuh", "緲"},
	{"vfbuo", "繉"},
	{"vfbuu", "絸"},
	{"vfbv", "綏 𡣖"},
	{"vfbvk", "縘"},
	{"vfbw", "㜭"},
	{"vfc", "鑾 䋮"},
	{"vfcip", "総"},
	{"vfcnh", "綈"},
	{"vfcor", "綌"},
	{"vfcrp", "縂"},
	{"vfcru", "綐"},
	{"vfcsh", "紛"},
	{"vfcwa", "繒"},
	{"vfd", "欒 䊾"},
	{"vfdbu", "緗"},
	{"vfdd", "綝"},
	{"vfddf", "䌝"},
	{"vfdh", "䊷"},
	{"vfdhe", "紴"},
	{"vfdi", "紂"},
	{"vfdk", "䊽"},
	{"vfdl", "綀"},
	{"vfdm", "絊"},
	{"vfdmq", "緯"},
	{"vfdoo", "䋱"},
	{"vfdq", "嫾"},
	{"vfdv", "𡞱"},
	{"vfdwf", "練"},
	{"vfe", "灓"},
	{"vfeed", "縔"},
	{"vfeee", "綴"},
	{"vfeg", "経"},
	{"vff", "婒 𤓖"},
	{"vffb", "綃"},
	{"vffbn", "䌃"},
	{"vffbr", "緔"},
	{"vffd", "嬫 䋛"},
	{"vffdq", "繗"},
	{"vfff", "緂"},
	{"vffff", "𦇝"},
	{"vffh", "紗"},
	{"vffmu", "絖"},
	{"vffq", "絆"},
	{"vffqu", "綣"},
	{"vffv", "䋝"},
	{"vfgbu", "続"},
	{"vfgce", "綾"},
	{"vfgg", "絓"},
	{"vfggi", "䋽"},
	{"vfggu", "繞"},
	{"vfgi", "紶"},
	{"vfgni", "䌧"},
	{"vfgow", "繬"},
	{"vfgp", "綕"},
	{"vfgr", "結"},
	{"vfgrc", "纈"},
	{"vfgrr", "繥"},
	{"vfgtj", "緈"},
	{"vfgwc", "續"},
	{"vfh", "妙"},
	{"vfha", "絈"},
	{"vfhab", "綿"},
	{"vfhae", "線"},
	{"vfhaf", "鷥 鸞 𪆓"},
	{"vfhce", "繌"},
	{"vfhdf", "䋺"},
	{"vfhdj", "䌀"},
	{"vfhds", "綉"},
	{"vfhdv", "緌"},
	{"vfhdw", "繙"},
	{"vfhej", "綘"},
	{"vfheq", "絳"},
	{"vfher", "絡"},
	{"vfhey", "終"},
	{"vfhg", "紝"},
	{"vfhgf", "纁"},
	{"vfhhj", "綼"},
	{"vfhj", "䊹"},
	{"vfhjd", "絑"},
	{"vfhje", "緞"},
	{"vfhjg", "緟"},
	{"vfhjm", "綞"},
	{"vfhjr", "絬 䌣"},
	{"vfhju", "䋸"},
	{"vfhkb", "繑"},
	{"vfhml", "紤"},
	{"vfhon", "絎"},
	{"vfhoo", "縰 縱"},
	{"vfhor", "綹"},
	{"vfhpa", "緍"},
	{"vfhq", "䋅"},
	{"vfhqo", "紩"},
	{"vfhqu", "䋃"},
	{"vfhsb", "編"},
	{"vfhsk", "綟 繳"},
	{"vfhuc", "纘"},
	{"vfhui", "䌆"},
	{"vfhvp", "紙"},
	{"vfhwp", "總"},
	{"vfhxu", "䋩"},
	{"vfibi", "縛"},
	{"vfid", "絉"},
	{"vfidd", "䌕"},
	{"vfihf", "縬"},
	{"vfihr", "緘"},
	{"vfihs", "絾"},
	{"vfihv", "縅"},
	{"vfii", "綫"},
	{"vfiih", "縿"},
	{"vfij", "絨"},
	{"vfijb", "䋠"},
	{"vfije", "絿"},
	{"vfik", "紁 紎"},
	{"vfikk", "紱"},
	{"vfiku", "紌"},
	{"vfill", "絒"},
	{"vfilr", "䌅"},
	{"vfimo", "絘"},
	{"vfir", "紿"},
	{"vfirm", "緎"},
	{"vfirp", "緿"},
	{"vfis", "䋆"},
	{"vfish", "𦆲"},
	{"vfitc", "纊"},
	{"vfiv", "䋐"},
	{"vfiwg", "纏"},
	{"vfixp", "䌒"},
	{"vfj", "卛"},
	{"vfjbc", "縝"},
	{"vfjbd", "綍"},
	{"vfjbf", "䌇"},
	{"vfjbj", "䋻"},
	{"vfjc", "䋉"},
	{"vfjcm", "𦁈"},
	{"vfjic", "繊"},
	{"vfjii", "縳"},
	{"vfjim", "纎"},
	{"vfjip", "繐"},
	{"vfjka", "緒"},
	{"vfjki", "綋"},
	{"vfjlo", "緁"},
	{"vfjlv", "緀"},
	{"vfjmc", "縯 繽"},
	{"vfjmf", "綜"},
	{"vfjmm", "縇"},
	{"vfjmn", "紵 𦅜"},
	{"vfjmo", "綻"},
	{"vfjmu", "綄"},
	{"vfjnu", "綩"},
	{"vfjoa", "縮"},
	{"vfjp", "紽"},
	{"vfjpn", "𦆭"},
	{"vfjpu", "䌏"},
	{"vfjqr", "縖"},
	{"vfjrr", "綰"},
	{"vfjyj", "縡"},
	{"vfk", "奱"},
	{"vfkb", "絠"},
	{"vfkcf", "繚"},
	{"vfki", "紘"},
	{"vfkk", "䋂"},
	{"vfkkb", "絺"},
	{"vfkmr", "綺"},
	{"vfkms", "絝"},
	{"vfkn", "䊵"},
	{"vfkni", "紈"},
	{"vfknj", "紣"},
	{"vfknn", "䋾"},
	{"vfkoo", "綊"},
	{"vfkpb", "𦄂"},
	{"vfks", "糼"},
	{"vflb", "㡩"},
	{"vflbi", "𥿢"},
	{"vflbk", "紻"},
	{"vflbu", "紞"},
	{"vflgm", "繣"},
	{"vflll", "紃"},
	{"vflln", "紼"},
	{"vflmc", "繢"},
	{"vflmi", "蠻"},
	{"vflmo", "絩"},
	{"vflmy", "緋"},
	{"vflpb", "䋳"},
	{"vflq", "䋖"},
	{"vflw", "紬"},
	{"vflwl", "紳"},
	{"vflwp", "絏"},
	{"vflwv", "縷"},
	{"vflx", "繡"},
	{"vfm", "紅"},
	{"vfma", "絔"},
	{"vfmam", "絙"},
	{"vfmbb", "繻"},
	{"vfmbc", "䋶"},
	{"vfmbe", "纋 䌄"},
	{"vfmbi", "繧 䌢 䌳"},
	{"vfmbk", "緛 𦅙"},
	{"vfmbm", "絚"},
	{"vfmbu", "䌮"},
	{"vfmcw", "絤"},
	{"vfmd", "紆"},
	{"vfmf", "紑"},
	{"vfmfb", "䌤"},
	{"vfmfm", "䋔"},
	{"vfmgk", "緻"},
	{"vfmhf", "縓"},
	{"vfmia", "縉"},
	{"vfmig", "絰"},
	{"vfmkp", "䋬"},
	{"vfmlb", "緉"},
	{"vfmlk", "綆"},
	{"vfmmi", "紜"},
	{"vfmmp", "纚"},
	{"vfmms", "䊸"},
	{"vfmn", "糽"},
	{"vfmnr", "䋍"},
	{"vfmob", "䋑"},
	{"vfmre", "𦂥"},
	{"vfmrw", "䋹"},
	{"vfmu", "姯"},
	{"vfmvi", "縟"},
	{"vfmvm", "經 䊺"},
	{"vfmvn", "㽋"},
	{"vfmwd", "䌚"},
	{"vfmwf", "縹"},
	{"vfmwg", "緸 緾 纒"},
	{"vfmwl", "緬"},
	{"vfmwm", "繮"},
	{"vfmwv", "䌁"},
	{"vfmym", "䋊"},
	{"vfn", "彎"},
	{"vfnau", "絶 絻"},
	{"vfnbq", "繲"},
	{"vfnd", "孿"},
	{"vfndd", "㝈"},
	{"vfng", "紐"},
	{"vfnhb", "繘"},
	{"vfnhd", "䋴"},
	{"vfnhe", "級"},
	{"vfni", "紭"},
	{"vfnih", "䋒"},
	{"vfnii", "繈"},
	{"vfnin", "紓"},
	{"vfnkf", "繺"},
	{"vfnkg", "綎"},
	{"vfnkm", "綖"},
	{"vfnl", "紖"},
	{"vfnlr", "䋪"},
	{"vfnme", "緑"},
	{"vfnmo", "縁"},
	{"vfno", "䊻"},
	{"vfnob", "縃"},
	{"vfnri", "纔"},
	{"vfnsd", "䋫"},
	{"vfnsm", "䋓"},
	{"vfnst", "䋼"},
	{"vfoae", "緮"},
	{"vfob", "納"},
	{"vfobo", "臠"},
	{"vfodi", "紨"},
	{"vfog", "維"},
	{"vfogd", "䌖"},
	{"vfohg", "絍"},
	{"vfohh", "紾"},
	{"vfoii", "紷"},
	{"vfoik", "絥"},
	{"vfoim", "纖"},
	{"vfoin", "紟"},
	{"vfoip", "𦁤"},
	{"vfok", "變"},
	{"vfold", "縧"},
	{"vfoll", "紒"},
	{"vfoma", "繪"},
	{"vfomb", "綸"},
	{"vfomd", "䋡"},
	{"vfomg", "絟"},
	{"vfomi", "絵"},
	{"vfomk", "緶"},
	{"vfomn", "緰"},
	{"vfomo", "䌞"},
	{"vfomr", "給"},
	{"vfon", "紇"},
	{"vfonk", "緱"},
	{"vfooo", "緃"},
	{"vfopd", "絁"},
	{"vford", "緥"},
	{"vfos", "䋏"},
	{"vfotf", "䌗"},
	{"vfoto", "纀"},
	{"vfowy", "䋦"},
	{"vfp", "戀"},
	{"vfpa", "絢"},
	{"vfpd", "䊶"},
	{"vfpi", "約"},
	{"vfpkp", "緫"},
	{"vfpmm", "緪"},
	{"vfpou", "綯"},
	{"vfpp", "紕"},
	{"vfpr", "絇"},
	{"vfpt", "紲"},
	{"vfptd", "緤"},
	{"vfpu", "純"},
	{"vfpuu", "縐"},
	{"vfq", "姅 攣"},
	{"vfqd", "䋘"},
	{"vfqjl", "綁"},
	{"vfqkd", "縥"},
	{"vfqmb", "綪"},
	{"vfqmc", "績"},
	{"vfqmf", "縤"},
	{"vfqo", "䊿"},
	{"vfqoc", "纉"},
	{"vfqu", "婘 𡡀"},
	{"vfr", "轡 㘘"},
	{"vfrb", "絹"},
	{"vfrbc", "縜"},
	{"vfrhr", "絽"},
	{"vfrlu", "䋲"},
	{"vfrpa", "緡"},
	{"vfrrd", "繰"},
	{"vfrrj", "繟"},
	{"vfrse", "縀"},
	{"vfrsj", "緝"},
	{"vfruc", "繏"},
	{"vfrvp", "䋋"},
	{"vfrxu", "繩"},
	{"vfseg", "䌑"},
	{"vfsei", "䌵"},
	{"vfsh", "糿"},
	{"vfshi", "紉"},
	{"vfshr", "紹"},
	{"vfshu", "絕"},
	{"vfsip", "綛"},
	{"vfsit", "繿"},
	{"vfsiu", "䌫"},
	{"vfsj", "䋙"},
	{"vfsje", "緅 𦀩"},
	{"vfsjj", "䌰"},
	{"vfsjr", "䋧"},
	{"vfsll", "䋗"},
	{"vfsma", "䌌"},
	{"vfsme", "綅"},
	{"vfsmg", "䌂 䌦"},
	{"vfsmh", "繆"},
	{"vfsmi", "𦅛"},
	{"vfsmm", "䋚"},
	{"vfso", "䋇"},
	{"vfsp", "𥿡"},
	{"vfsrj", "䌟"},
	{"vfsrr", "䌔"},
	{"vfss", "䋌"},
	{"vfstt", "𦂤"},
	{"vfsu", "紀"},
	{"vfsup", "䋟"},
	{"vfswu", "纜"},
	{"vftak", "縸"},
	{"vftbf", "䌨"},
	{"vftbk", "繖"},
	{"vftcd", "䌜"},
	{"vftct", "縊"},
	{"vftcw", "緧"},
	{"vftgr", "繕"},
	{"vfthf", "䌲"},
	{"vftlj", "緙"},
	{"vftlk", "緓"},
	{"vftlm", "䌍"},
	{"vftm", "紺"},
	{"vftmc", "綨 䌙"},
	{"vftof", "䌭"},
	{"vftor", "䌋"},
	{"vftpp", "繱"},
	{"vftq", "絴"},
	{"vftqm", "縒"},
	{"vftrg", "䌯"},
	{"vftsj", "縙"},
	{"vftt", "絣"},
	{"vftw", "緢"},
	{"vftwi", "繜 䌩"},
	{"vftwt", "䌡"},
	{"vftwv", "繷"},
	{"vftxc", "縑"},
	{"vftyj", "纄"},
	{"vfu", "巒"},
	{"vfubb", "繃"},
	{"vfuce", "緵"},
	{"vfufk", "𦆮"},
	{"vfuob", "纗"},
	{"vfuog", "繀"},
	{"vfuu", "絀"},
	{"vfv", "孌"},
	{"vfvfd", "継"},
	{"vfvfp", "纞"},
	{"vfvid", "纅"},
	{"vfvif", "絲"},
	{"vfvl", "糾"},
	{"vfvne", "綠"},
	{"vfvno", "緣"},
	{"vfvvd", "繅"},
	{"vfvvi", "繼"},
	{"vfvvw", "緇"},
	{"vfw", "細"},
	{"vfwb", "緭"},
	{"vfwd", "綑"},
	{"vfwg", "䋥"},
	{"vfwgg", "纆"},
	{"vfwk", "絪"},
	{"vfwlg", "纙"},
	{"vfwlj", "繹"},
	{"vfwlm", "䌉"},
	{"vfwlu", "縄"},
	{"vfwlv", "繯"},
	{"vfwml", "綥"},
	{"vfwmv", "䋿"},
	{"vfwot", "縕"},
	{"vfwp", "緦"},
	{"vfwr", "絗"},
	{"vfwtj", "縪"},
	{"vfwvf", "縲"},
	{"vfwwf", "纝"},
	{"vfyaj", "綽"},
	{"vfybb", "締"},
	{"vfybc", "緽"},
	{"vfybp", "䌬"},
	{"vfybs", "縍"},
	{"vfyck", "絞"},
	{"vfyg", "紸"},
	{"vfygq", "繨"},
	{"vfyhj", "縫"},
	{"vfyhn", "䋁"},
	{"vfyhr", "縋"},
	{"vfyhs", "紡"},
	{"vfyia", "織"},
	{"vfyib", "䋭"},
	{"vfyij", "繂"},
	{"vfyiu", "統"},
	{"vfyj", "紏 㪻"},
	{"vfyjj", "縺"},
	{"vfyk", "紋"},
	{"vfykc", "纐"},
	{"vfykl", "緕"},
	{"vfylm", "䊼"},
	{"vfylr", "繾"},
	{"vfymp", "紪"},
	{"vfynq", "䌴"},
	{"vfynt", "䌱"},
	{"vfyoj", "綷"},
	{"vfypt", "纑"},
	{"vfyrb", "縞"},
	{"vfyrd", "綧"},
	{"vfyrf", "綡 䜌"},
	{"vfyrn", "𦂃"},
	{"vfyro", "㱍"},
	{"vfyru", "綂"},
	{"vfyrv", "纕"},
	{"vfyso", "縼"},
	{"vfyto", "繸"},
	{"vfytp", "繶"},
	{"vfytr", "䋨"},
	{"vfytu", "縌"},
	{"vfyub", "縭"},
	{"vfyvi", "絃"},
	{"vfyvo", "絯"},
	{"vfyvq", "縴"},
	{"vfywm", "繵"},
	{"vfywv", "縗"},
	{"vfyx", "纃"},
	{"vgb", "姌"},
	{"vgbt", "嬄"},
	{"vgc", "銺"},
	{"vgce", "婈"},
	{"vgcg", "㛬"},
	{"vgcw", "嫱"},
	{"vgf", "焋"},
	{"vgg", "娃"},
	{"vggp", "㜇"},
	{"vggu", "嬈"},
	{"vgk", "奊 奘"},
	{"vglmi", "䗽"},
	{"vgni", "嬦"},
	{"vgow", "嬙"},
	{"vgp", "娡 㥨"},
	{"vgr", "姞"},
	{"vgrg", "嬯"},
	{"vgrr", "嬉 𡣗"},
	{"vgrt", "㛸"},
	{"vgrv", "媴"},
	{"vgsk", "㜜"},
	{"vgt", "弉"},
	{"vgtj", "婞"},
	{"vgv", "娤"},
	{"vgwc", "嬻"},
	{"vgyhv", "裝"},
	{"vhab", "婂"},
	{"vhaf", "𡡅"},
	{"vhag", "媓"},
	{"vhail", "郷"},
	{"vhat", "孂"},
	{"vhau", "㛂"},
	{"vhav", "嬝"},
	{"vhbk", "㜩"},
	{"vhbr", "姠"},
	{"vhbu", "𡜍"},
	{"vhcn", "嬼"},
	{"vhcq", "𡤒"},
	{"vhd", "姀"},
	{"vhdn", "娳"},
	{"vhds", "㛢"},
	{"vhdv", "婑"},
	{"vhdw", "嬏"},
	{"vhej", "㛔"},
	{"vhey", "㚵"},
	{"vhg", "妊"},
	{"vhgu", "姺"},
	{"vhhj", "婢"},
	{"vhhl", "㚹"},
	{"vhhpl", "鄕"},
	{"vhhw", "媹"},
	{"vhi", "媿 𡚸"},
	{"vhiil", "鄉"},
	{"vhio", "姂"},
	{"vhj", "奷"},
	{"vhjd", "姝"},
	{"vhjg", "媑"},
	{"vhjm", "娷"},
	{"vhjr", "姡"},
	{"vhjx", "㛼"},
	{"vhk", "妖"},
	{"vhkb", "嬌"},
	{"vhkl", "娇"},
	{"vhkp", "婖"},
	{"vhlc", "㜱"},
	{"vhlmi", "蚃"},
	{"vhml", "妡"},
	{"vhmr", "姤"},
	{"vhnb", "姵"},
	{"vhnd", "㛊"},
	{"vhnh", "𡠨"},
	{"vhni", "㜄"},
	{"vhnk", "㚯"},
	{"vhoiv", "飨"},
	{"vhok", "㜫"},
	{"vhoo", "㜡"},
	{"vhp", "奼"},
	{"vhpa", "婚"},
	{"vhqi", "娥"},
	{"vhqm", "姓"},
	{"vhqo", "妷"},
	{"vhqu", "㚪"},
	{"vhs", "妒 妰"},
	{"vhsb", "媥"},
	{"vhsjl", "鄊"},
	{"vhsk", "嬓"},
	{"vhuc", "㜺"},
	{"vhul", "嬶"},
	{"vhup", "媳"},
	{"vhwp", "媲"},
	{"vhxc", "嬹"},
	{"vhxe", "嫂"},
	{"vhxh", "㛛"},
	{"vhxs", "𡞲"},
	{"vhxt", "㜒"},
	{"vhxu", "婗"},
	{"vi", "厶 幺 㚧 ⼳"},
	{"viapv", "㡫"},
	{"viav", "娘"},
	{"vib", "姢"},
	{"vibul", "䵼"},
	{"vic", "𨫥"},
	{"vice", "㛖"},
	{"vid", "槳 樂"},
	{"vidd", "嫲"},
	{"vidi", "嬤 嬷"},
	{"vidy", "孊"},
	{"vie", "漿"},
	{"vif", "糸 糹 𢇁 𢇃"},
	{"vifd", "䊢"},
	{"vig", "墏 㛇"},
	{"vihe", "发"},
	{"vihi", "幾 𡜐"},
	{"vihml", "斷"},
	{"vihq", "㛌"},
	{"vihr", "㛾"},
	{"vihs", "娍 㡬"},
	{"vihv", "媙"},
	{"viih", "㜗"},
	{"viik", "獎"},
	{"viil", "嫏"},
	{"vij", "娀"},
	{"vije", "㛏"},
	{"vik", "奬"},
	{"vikf", "媯"},
	{"vikk", "妭"},
	{"viks", "幼"},
	{"viksf", "鴢"},
	{"viku", "㚭"},
	{"vilb", "嫞"},
	{"vile", "嫝"},
	{"vilmi", "螿"},
	{"viln", "劙"},
	{"vilr", "㜍"},
	{"vimcw", "醬"},
	{"vine", "𡛻"},
	{"vio", "以"},
	{"viok", "娭"},
	{"viomn", "㡮"},
	{"vip", "㚤"},
	{"vir", "始"},
	{"vis", "幻"},
	{"vish", "㓜"},
	{"vit", "㢡"},
	{"vitc", "嬚"},
	{"vitf", "嫬"},
	{"viu", "乣"},
	{"viuh", "娏"},
	{"viv", "𡛟"},
	{"viw", "畿"},
	{"vixp", "㜙"},
	{"vjb", "姉"},
	{"vjbc", "嫃"},
	{"vjbd", "㛘"},
	{"vjbj", "婻"},
	{"vjbm", "𡝮"},
	{"vjcb", "𡢠"},
	{"vjcr", "嫆"},
	{"vjd", "妹 𡜻"},
	{"vje", "妓"},
	{"vjfd", "㛽"},
	{"vjfe", "㛮"},
	{"vjhp", "姹"},
	{"vjhw", "嬸"},
	{"vjii", "嫥"},
	{"vjjo", "㜛"},
	{"vjka", "媎"},
	{"vjkp", "姥"},
	{"vjks", "㛈"},
	{"vjll", "婶"},
	{"vjlo", "婕"},
	{"vjmc", "嬪 𡤧"},
	{"vjmf", "婃"},
	{"vjmi", "𡝬"},
	{"vjmm", "媗"},
	{"vjmo", "婝 嫁"},
	{"vjmu", "㛡"},
	{"vjnu", "婉"},
	{"vjoa", "㜚"},
	{"vjoc", "嫔"},
	{"vjpn", "嬣"},
	{"vjpu", "娆"},
	{"vjr", "姑"},
	{"vjrb", "媩"},
	{"vjrj", "嫴"},
	{"vjrr", "婠"},
	{"vjru", "娔"},
	{"vjtc", "𡤐"},
	{"vjuc", "𡣑"},
	{"vjv", "姲"},
	{"vk", "夨"},
	{"vkb", "姷"},
	{"vkbt", "盭"},
	{"vkcf", "嫽"},
	{"vke", "𡛀"},
	{"vkgg", "㛻"},
	{"vki", "𡛕"},
	{"vkk", "𡘾"},
	{"vkkb", "㛓"},
	{"vklb", "㚴"},
	{"vklu", "㛪"},
	{"vkmb", "媠"},
	{"vkmr", "婍"},
	{"vkms", "姱"},
	{"vkn", "姨"},
	{"vkni", "𡚺"},
	{"vkok", "嫉"},
	{"vkoo", "㛍"},
	{"vkpb", "𡠹"},
	{"vksr", "㚳"},
	{"vl", "凵 妕"},
	{"vlbk", "姎"},
	{"vlbu", "妉"},
	{"vle", "収 𡝯"},
	{"vlgm", "嫿"},
	{"vlhbr", "嚮"},
	{"vlllm", "丱"},
	{"vllmi", "蠁"},
	{"vlm", "爿"},
	{"vlmc", "嬇"},
	{"vlmo", "姚"},
	{"vlmt", "嬧"},
	{"vlmy", "婔"},
	{"vloiv", "饗"},
	{"vlok", "收"},
	{"vlr", "㗽"},
	{"vlsa", "㛠"},
	{"vlsd", "娴"},
	{"vlw", "妯"},
	{"vlwl", "妽"},
	{"vlws", "娉"},
	{"vlwv", "㜢"},
	{"vlxh", "姊"},
	{"vlxl", "婣"},
	{"vlyta", "響"},
	{"vm", "妅"},
	{"vmabt", "缊"},
	{"vmam", "姮"},
	{"vmamo", "缇"},
	{"vmapp", "绲"},
	{"vmawe", "缦"},
	{"vmbb", "嬬 㛤"},
	{"vmbbe", "绶"},
	{"vmbc", "㛲"},
	{"vmbd", "䌽"},
	{"vmbdi", "將"},
	{"vmbe", "𡤕"},
	{"vmbgr", "绸"},
	{"vmbi", "𡢅"},
	{"vmbk", "媆 纲"},
	{"vmbl", "䎟"},
	{"vmbm", "组 𡠭"},
	{"vmbme", "缓"},
	{"vmbov", "缨"},
	{"vmbr", "䌹"},
	{"vmbs", "嫮"},
	{"vmbu", "孀"},
	{"vmbuh", "缈"},
	{"vmbv", "绥"},
	{"vmbwd", "彙"},
	{"vmcnh", "绨"},
	{"vmcor", "绤"},
	{"vmcru", "䌼"},
	{"vmcsh", "纷"},
	{"vmcwa", "缯"},
	{"vmd", "牀 㚥"},
	{"vmdbu", "缃"},
	{"vmdh", "䌶"},
	{"vmdi", "纣"},
	{"vmeee", "缀"},
	{"vmeq", "绎"},
	{"vmf", "妚"},
	{"vmfb", "嬭"},
	{"vmfbr", "绱"},
	{"vmfdv", "缕"},
	{"vmfft", "彝"},
	{"vmfh", "纱"},
	{"vmfhk", "𢑱"},
	{"vmfht", "彜"},
	{"vmfj", "㛁"},
	{"vmfm", "㚰"},
	{"vmfq", "绊"},
	{"vmfqu", "绻"},
	{"vmfr", "娝"},
	{"vmg", "壯"},
	{"vmgce", "绫"},
	{"vmgg", "娾"},
	{"vmgi", "𡛼"},
	{"vmgk", "𡟹"},
	{"vmgow", "牆"},
	{"vmgr", "结"},
	{"vmgro", "缬"},
	{"vmgt", "㛞"},
	{"vmhab", "绵"},
	{"vmhae", "缐"},
	{"vmhds", "绣"},
	{"vmhed", "绦"},
	{"vmheq", "绛"},
	{"vmher", "络"},
	{"vmhey", "终"},
	{"vmhf", "嫄"},
	{"vmhg", "纴"},
	{"vmhj", "纤"},
	{"vmhje", "缎"},
	{"vmhjm", "缍"},
	{"vmhml", "斨"},
	{"vmhon", "绗"},
	{"vmhsk", "缴"},
	{"vmhuo", "缵"},
	{"vmhvp", "纸"},
	{"vmhyr", "绺"},
	{"vmi", "戕 纩"},
	{"vmibi", "缚"},
	{"vmig", "姪 𤕸"},
	{"vmihr", "缄"},
	{"vmij", "线"},
	{"vmik", "狀"},
	{"vmike", "绂"},
	{"vmilb", "牅"},
	{"vmir", "绐"},
	{"vmisb", "编"},
	{"vmiwg", "缠"},
	{"vmj", "奸"},
	{"vmjbc", "缜"},
	{"vmjbj", "䌾"},
	{"vmjcm", "㸜"},
	{"vmjj", "姸"},
	{"vmjka", "绪"},
	{"vmjm", "纻"},
	{"vmjmf", "综"},
	{"vmjmo", "绽"},
	{"vmjnk", "续"},
	{"vmjoa", "缩"},
	{"vmjoc", "缤"},
	{"vmjpu", "绕"},
	{"vmjrr", "绾"},
	{"vmkcf", "缭"},
	{"vmki", "纮"},
	{"vmkmr", "绮"},
	{"vmkms", "绔"},
	{"vmkni", "纨"},
	{"vmku", "妩"},
	{"vmkvc", "练"},
	{"vml", "㚦"},
	{"vmlii", "蠿"},
	{"vmlit", "䍀"},
	{"vmliu", "缆"},
	{"vmlk", "㛐"},
	{"vmlln", "绋"},
	{"vmlm", "婭"},
	{"vmlmo", "缋"},
	{"vmlmy", "绯"},
	{"vmlw", "㛉 䌷"},
	{"vmlwl", "绅"},
	{"vmm", "红"},
	{"vmmca", "缙"},
	{"vmmd", "纡"},
	{"vmmi", "妘"},
	{"vmmig", "绖"},
	{"vmmlk", "绠"},
	{"vmmmi", "纭"},
	{"vmmnr", "牁"},
	{"vmmp", "孋"},
	{"vmmr", "娪"},
	{"vmmrw", "䌿"},
	{"vmmu", "妧"},
	{"vmmv", "娠"},
	{"vmmvi", "缛"},
	{"vmmwf", "缥"},
	{"vmmwl", "缅"},
	{"vmmwm", "缰"},
	{"vmn", "奵"},
	{"vmnau", "绝"},
	{"vmng", "纽"},
	{"vmnhe", "级"},
	{"vmnin", "纾"},
	{"vmnl", "纼"},
	{"vmnme", "绿"},
	{"vmnom", "经"},
	{"vmnr", "妸"},
	{"vmnsm", "绉"},
	{"vmob", "纳 𡛦"},
	{"vmog", "维"},
	{"vmoir", "牄"},
	{"vmomi", "绘"},
	{"vmomk", "缏"},
	{"vmomr", "给"},
	{"vmon", "纥"},
	{"vmonk", "缑"},
	{"vmoo", "纵"},
	{"vmop", "纶"},
	{"vmpa", "绚"},
	{"vmpi", "约"},
	{"vmpm", "娬"},
	{"vmpop", "彘"},
	{"vmpou", "绹"},
	{"vmpp", "纰"},
	{"vmpt", "绁"},
	{"vmptd", "牃"},
	{"vmpu", "纯"},
	{"vmqjl", "绑"},
	{"vmqmo", "绩"},
	{"vmqni", "䌸"},
	{"vmqs", "纬"},
	{"vmr", "妬"},
	{"vmrb", "绢"},
	{"vmrc", "织"},
	{"vmrlu", "绳"},
	{"vmrpa", "缗"},
	{"vmrr", "𡟵"},
	{"vmrrd", "缲"},
	{"vmrsj", "缉"},
	{"vmrt", "㛒"},
	{"vmshi", "纫"},
	{"vmshr", "绍 㸛"},
	{"vmsj", "䌺"},
	{"vmsmh", "缪"},
	{"vmsmm", "䌻"},
	{"vmsu", "纪"},
	{"vmt", "妍"},
	{"vmtc", "娅"},
	{"vmtct", "缢"},
	{"vmtlj", "缂"},
	{"vmtlk", "绬"},
	{"vmtm", "绀"},
	{"vmto", "㜧"},
	{"vmtq", "牂"},
	{"vmttr", "缮"},
	{"vmtxc", "缣"},
	{"vmue", "𡟺"},
	{"vmuu", "绌"},
	{"vmuw", "婳"},
	{"vmv", "妝"},
	{"vmvfd", "继"},
	{"vmvi", "媷"},
	{"vmvl", "纠"},
	{"vmvm", "娙"},
	{"vmvno", "缘"},
	{"vmvvd", "缫"},
	{"vmvvw", "缁"},
	{"vmw", "细"},
	{"vmwf", "嫖"},
	{"vmwj", "㜤"},
	{"vmwl", "媔"},
	{"vmwlv", "缳"},
	{"vmwp", "缌"},
	{"vmwv", "婹"},
	{"vmwvf", "缧"},
	{"vmyaj", "绰"},
	{"vmybb", "缔"},
	{"vmyck", "绞"},
	{"vmyf", "嫣"},
	{"vmyhj", "缝"},
	{"vmyhr", "缒"},
	{"vmyhs", "纺"},
	{"vmyiu", "统"},
	{"vmyk", "纹"},
	{"vmylr", "缱"},
	{"vmym", "姃"},
	{"vmyrb", "缟"},
	{"vmyto", "䍁"},
	{"vmyub", "缡"},
	{"vmywv", "缞"},
	{"vnai", "婏"},
	{"vnau", "娩"},
	{"vnbc", "媍"},
	{"vnbk", "㛟 𡞵"},
	{"vnbp", "嫓"},
	{"vncr", "㜬"},
	{"vnd", "好"},
	{"vnf", "妳"},
	{"vng", "妞"},
	{"vnhd", "媃"},
	{"vnhe", "㚫"},
	{"vnhs", "奶"},
	{"vnib", "㛚"},
	{"vnin", "妤 姼"},
	{"vnir", "姳"},
	{"vnj", "㚨"},
	{"vnjk", "㜟"},
	{"vnkg", "娗"},
	{"vnkm", "娫"},
	{"vnl", "邚"},
	{"vnlb", "嫷"},
	{"vnlr", "婀"},
	{"vnm", "彑"},
	{"vnmb", "㣇"},
	{"vnme", "彔"},
	{"vnmm", "嫋"},
	{"vnmo", "彖"},
	{"vnmu", "姽"},
	{"vno", "奺"},
	{"vnob", "婿"},
	{"vnok", "𡞳"},
	{"vnot", "嬁"},
	{"vnri", "㜶"},
	{"vnsd", "㚺 㛆"},
	{"vnsm", "㛀"},
	{"vnst", "𡟚"},
	{"vnum", "嬎 嬔"},
	{"vnus", "㛯"},
	{"vnvm", "妈"},
	{"vnxu", "䶯"},
	{"vnyi", "娹"},
	{"vo", "乆"},
	{"vob", "妠"},
	{"vobt", "盠"},
	{"vof", "㚷"},
	{"vog", "婎"},
	{"voge", "孇"},
	{"vogf", "嫶"},
	{"vohaf", "鶨"},
	{"vohg", "姙"},
	{"vohh", "𡛧"},
	{"voii", "姈"},
	{"voim", "孅"},
	{"voin", "妗"},
	{"voir", "娢"},
	{"voiw", "㜝"},
	{"volii", "蠡"},
	{"voll", "妎"},
	{"volmi", "䗍"},
	{"voln", "剶"},
	{"vom", "㚱"},
	{"voma", "嬒"},
	{"vomb", "婨"},
	{"vomc", "娦"},
	{"vomg", "姾"},
	{"vomk", "㛹"},
	{"vomn", "媮"},
	{"vomo", "嬐"},
	{"vomr", "姶"},
	{"vomt", "媕"},
	{"vomv", "婾"},
	{"voog", "㛗"},
	{"vop", "㛋"},
	{"voq", "姩"},
	{"vord", "媬"},
	{"vorm", "嬆"},
	{"votf", "嫵"},
	{"vovo", "娰"},
	{"vowy", "娒"},
	{"voyr", "㜃"},
	{"vp", "㣽"},
	{"vpa", "姰"},
	{"vpd", "她"},
	{"vpfd", "婅"},
	{"vph", "妼"},
	{"vphh", "𡛁"},
	{"vpi", "妁"},
	{"vpim", "㚬"},
	{"vpkp", "𡟟"},
	{"vpp", "妣"},
	{"vppa", "媘"},
	{"vpr", "姁"},
	{"vpru", "㚿"},
	{"vptd", "媟"},
	{"vpuu", "媰"},
	{"vqj", "妦"},
	{"vqjp", "𡣺"},
	{"vqka", "媋"},
	{"vqkd", "嫀"},
	{"vqmb", "婧"},
	{"vqmc", "嫧"},
	{"vqmf", "嫊"},
	{"vqmv", "婊"},
	{"vqo", "妋"},
	{"vqyt", "𡝰"},
	{"vr", "如"},
	{"vrau", "㛕"},
	{"vrb", "娟"},
	{"vrbc", "㜏"},
	{"vrbo", "㛣"},
	{"vrd", "桇"},
	{"vrhaf", "鴽"},
	{"vrhu", "㚾"},
	{"vrlb", "帤"},
	{"vrlr", "㚶"},
	{"vrmk", "娱"},
	{"vrob", "娲"},
	{"vrp", "恕"},
	{"vrpa", "㛰"},
	{"vrq", "挐 𢳉"},
	{"vrr", "㛎"},
	{"vrrd", "嬠"},
	{"vrrj", "嬋"},
	{"vrrk", "孍"},
	{"vrrp", "㖲 㗠"},
	{"vrvc", "娯"},
	{"vrvif", "絮"},
	{"vrvk", "娛"},
	{"vrvp", "姄"},
	{"vrye", "婽"},
	{"vryhv", "䘫"},
	{"vryo", "娖"},
	{"vsbt", "𥁒"},
	{"vseg", "𡠩"},
	{"vseq", "㜨"},
	{"vshaf", "鶭"},
	{"vshr", "妱"},
	{"vshu", "娓"},
	{"vsit", "㜮"},
	{"vsj", "㛅"},
	{"vsje", "娵"},
	{"vsjr", "婮"},
	{"vsk", "妪 𡛂"},
	{"vskp", "嫕"},
	{"vskr", "𡝗"},
	{"vsll", "姫 姬"},
	{"vsm", "妇"},
	{"vsmb", "婦"},
	{"vsmg", "嬥"},
	{"vsmh", "嫪"},
	{"vsmi", "㜦"},
	{"vsmr", "㚸"},
	{"vsnd", "孧"},
	{"vsp", "妮"},
	{"vsqf", "媽"},
	{"vsql", "娜"},
	{"vsrp", "嬺"},
	{"vsrq", "𡢡"},
	{"vsrr", "嫗"},
	{"vss", "姖"},
	{"vstr", "嫟"},
	{"vstt", "𡟛"},
	{"vstv", "㜊"},
	{"vsu", "妃"},
	{"vsuf", "㜯"},
	{"vsyi", "孎"},
	{"vta", "㛭"},
	{"vtab", "𡤃"},
	{"vtad", "𡤄"},
	{"vtak", "嫫"},
	{"vtaw", "孏"},
	{"vtbc", "婰"},
	{"vtbn", "媊"},
	{"vtc", "娂"},
	{"vtch", "𡝱"},
	{"vtcl", "𡡒"},
	{"vtco", "𡣘"},
	{"vtct", "㜋"},
	{"vtcw", "媨"},
	{"vtge", "𡡷"},
	{"vtgi", "嬟"},
	{"vtgk", "媄"},
	{"vtgr", "嫸"},
	{"vtgu", "㛨"},
	{"vtgv", "𡟜"},
	{"vtgw", "𡤑"},
	{"vthg", "嬞"},
	{"vtio", "𡝳"},
	{"vtjb", "㛿"},
	{"vtkr", "婼"},
	{"vtlb", "𡠪"},
	{"vtlf", "嬿"},
	{"vtlk", "媖"},
	{"vtlm", "嫤"},
	{"vtlo", "嫨"},
	{"vtm", "姏"},
	{"vtmc", "娸 嫹"},
	{"vtmd", "媒"},
	{"vtmj", "嬅 𡞴"},
	{"vtmu", "𡝴"},
	{"vtmv", "媅"},
	{"vtnu", "𡟃"},
	{"vtoe", "嬳"},
	{"vtop", "婲"},
	{"vtor", "㜓"},
	{"vtpd", "𡡣"},
	{"vtqm", "嫅"},
	{"vtrg", "孉"},
	{"vtsj", "媶"},
	{"vtt", "姘"},
	{"vttb", "媾"},
	{"vtvi", "𡞰"},
	{"vtvp", "嬨"},
	{"vtw", "媌"},
	{"vtwa", "㜖"},
	{"vtwk", "𡟻"},
	{"vtwu", "㜴"},
	{"vtwv", "𡢿"},
	{"vtxc", "嫌"},
	{"vu", "奾"},
	{"vuau", "𡡻"},
	{"vugk", "嬍"},
	{"vuhi", "𡟶"},
	{"vuhml", "㫁"},
	{"vuks", "㔢"},
	{"vumb", "媏"},
	{"vumf", "㛶"},
	{"vumi", "媸"},
	{"vumj", "婩"},
	{"vumr", "㛧"},
	{"vumt", "㜐"},
	{"vuob", "孈"},
	{"vuog", "雝 㜠"},
	{"vush", "㔃"},
	{"vuuk", "媺"},
	{"vv", "奻 㚣"},
	{"vvf", "災"},
	{"vvfb", "嬵"},
	{"vvff", "𡤻"},
	{"vvfp", "㜻"},
	{"vvh", "乡"},
	{"vvid", "㜰"},
	{"vvii", "㡭 𡡤"},
	{"vvio", "姒"},
	{"vvm", "丝 纟"},
	{"vvmbu", "𩠐"},
	{"vvmj", "姧"},
	{"vvmpm", "鸶"},
	{"vvnd", "㜽"},
	{"vvne", "娽"},
	{"vvno", "𡟇 𡟼"},
	{"vvrau", "邕"},
	{"vvv", "姦 巛"},
	{"vvvu", "㜉"},
	{"vvvw", "㛴"},
	{"vvw", "甾"},
	{"vvwd", "巢"},
	{"vvwkv", "巤"},
	{"vw", "㚼"},
	{"vwb", "媦"},
	{"vwd", "婐"},
	{"vwg", "娌"},
	{"vwgf", "嫼"},
	{"vwhaf", "鶅"},
	{"vwjlo", "疀"},
	{"vwjr", "婟"},
	{"vwk", "姻"},
	{"vwkp", "𡟯"},
	{"vwks", "娚"},
	{"vwlb", "媀"},
	{"vwlc", "㜥"},
	{"vwlg", "𡤢"},
	{"vwlj", "嬕"},
	{"vwlk", "嬽"},
	{"vwln", "㓯"},
	{"vwlv", "嬛"},
	{"vwmv", "㛱"},
	{"vwnl", "䣎"},
	{"vwot", "媼"},
	{"vwp", "媤"},
	{"vwsv", "嫐"},
	{"vwvf", "嫘"},
	{"vwwm", "㜼"},
	{"vwyi", "姆"},
	{"vwyl", "𡜼"},
	{"vx", "卐"},
	{"vyaj", "婥"},
	{"vybb", "媂"},
	{"vybc", "媜"},
	{"vybs", "嫎"},
	{"vycb", "嫡"},
	{"vyck", "姣"},
	{"vycv", "嬢"},
	{"vydu", "𡤅"},
	{"vyfd", "㜆"},
	{"vyfe", "婌"},
	{"vyg", "妵"},
	{"vyhn", "妔"},
	{"vyhr", "𡠻"},
	{"vyhs", "妨"},
	{"vyhv", "㛄"},
	{"vyia", "嬂"},
	{"vyib", "㛩"},
	{"vyiw", "㜅"},
	{"vyjj", "㜕"},
	{"vyk", "妏"},
	{"vymr", "娮"},
	{"vymy", "𡛨"},
	{"vypd", "嫭"},
	{"vypk", "𡢢"},
	{"vypm", "㜘"},
	{"vypu", "婋"},
	{"vyr", "㚲"},
	{"vyrf", "婛"},
	{"vyrn", "婷 㜲"},
	{"vyrv", "孃"},
	{"vyso", "媫 嫙"},
	{"vysv", "㜵"},
	{"vyta", "㛺"},
	{"vytd", "媇"},
	{"vytj", "嫜 㛙"},
	{"vyto", "嬘"},
	{"vytp", "嬑"},
	{"vytr", "婄"},
	{"vytu", "㜔"},
	{"vyvi", "妶"},
	{"vyvo", "姟"},
	{"vywm", "嬗"},
	{"vywv", "㜳"},
	{"vyx", "𡣙"},
	{"w", "田"},
	{"wamh", "畼"},
	{"wb", "胃"},
	{"wbb", "朙"},
	{"wbbm", "畳"},
	{"wbdi", "㽟"},
	{"wbmbc", "顒"},
	{"wbmbo", "颙"},
	{"wbmvn", "㼴"},
	{"wbp", "愚"},
	{"wbuf", "㘥"},
	{"wc", "四"},
	{"wcb", "囧"},
	{"wcbuu", "䚑"},
	{"wcg", "囶"},
	{"wchaf", "鷶"},
	{"wche", "畟"},
	{"wcmw", "圙"},
	{"wcwa", "㽪"},
	{"wcys", "圀"},
	{"wd", "困 果"},
	{"wdh", "团"},
	{"wdhv", "褁"},
	{"wdi", "団"},
	{"wdmbc", "顆"},
	{"wdmbo", "颗"},
	{"wdmq", "圍"},
	{"wdmvn", "㼫"},
	{"wdnin", "夥"},
	{"wdok", "㪙"},
	{"wdye", "敤"},
	{"we", "囦 㘝"},
	{"weee", "瑆 畷"},
	{"well", "㘤"},
	{"wfam", "䵣"},
	{"wfamh", "䵮"},
	{"wfapp", "䵪"},
	{"wfdq", "疄"},
	{"wfea", "䵬"},
	{"wfemd", "䵦"},
	{"wfgr", "黠"},
	{"wfgrr", "䵱"},
	{"wfgwc", "黷"},
	{"wfhaf", "䳴"},
	{"wfhjg", "䵯"},
	{"wfice", "黢"},
	{"wfihr", "黬"},
	{"wfiih", "黲"},
	{"wfik", "默"},
	{"wfikh", "黪 䵨"},
	{"wfip", "黓"},
	{"wfjbc", "黰"},
	{"wfjd", "䵢"},
	{"wfjka", "䵭"},
	{"wfjnk", "黩"},
	{"wfjnu", "黦"},
	{"wfklu", "黤"},
	{"wflbu", "黕"},
	{"wfln", "䵞"},
	{"wfmj", "䵟"},
	{"wfmu", "㘢"},
	{"wfmvu", "黖"},
	{"wfmwg", "黫"},
	{"wfnau", "䵥"},
	{"wfncr", "黵"},
	{"wfnin", "黟"},
	{"wfno", "㱄 㱎"},
	{"wfoah", "䵰"},
	{"wfoin", "黔"},
	{"wfoma", "䵳"},
	{"wfomt", "黭"},
	{"wfowy", "黣"},
	{"wfpi", "䵠"},
	{"wfpu", "黗"},
	{"wfq", "畔"},
	{"wfqg", "畻"},
	{"wfqu", "圈"},
	{"wfrrd", "䵲"},
	{"wfrxu", "䵴"},
	{"wftm", "黚"},
	{"wftmv", "黮"},
	{"wfu", "䵝"},
	{"wfuu", "黜"},
	{"wfvis", "黝"},
	{"wfyg", "𪐴"},
	{"wfypt", "黸"},
	{"wfyr", "點"},
	{"wfyrf", "黥"},
	{"wfyta", "黯"},
	{"wg", "里"},
	{"wgb", "畘"},
	{"wgdi", "畤"},
	{"wgf", "黑"},
	{"wgfg", "墨"},
	{"wgg", "畦"},
	{"wgit", "圔"},
	{"wgni", "疇"},
	{"wgnin", "野"},
	{"wgrv", "園"},
	{"wgtj", "圉"},
	{"whaf", "鴫"},
	{"whd", "囷"},
	{"whe", "畈"},
	{"wher", "略 畧"},
	{"whey", "图"},
	{"whgi", "𤴆"},
	{"whjg", "畽"},
	{"whnd", "𡇙"},
	{"whq", "㽚"},
	{"whvo", "畖"},
	{"whwj", "㽡"},
	{"wi", "囜"},
	{"wibc", "圎"},
	{"wibi", "圑"},
	{"wice", "畯"},
	{"wihaf", "鸀"},
	{"wihu", "㽙"},
	{"wiih", "㽩"},
	{"wijb", "圃"},
	{"wijw", "圗"},
	{"wik", "畎"},
	{"wiln", "劅"},
	{"wimbc", "䫳"},
	{"wino", "歜"},
	{"wiog", "塁"},
	{"wiom", "疂"},
	{"wir", "囼"},
	{"wirm", "國 㽣"},
	{"wiye", "斀"},
	{"wiyj", "斣"},
	{"wj", "毋 毌"},
	{"wjbo", "贯"},
	{"wjbuc", "貫"},
	{"wjhaf", "鷝 鸅"},
	{"wjii", "團"},
	{"wjno", "歝"},
	{"wjnu", "瑂 畹"},
	{"wjok", "斁 㪤"},
	{"wjr", "固"},
	{"wk", "因 龱"},
	{"wkb", "囿"},
	{"wkbt", "盢"},
	{"wkbu", "䁿"},
	{"wkf", "黙"},
	{"wklu", "㽢"},
	{"wkmr", "畸"},
	{"wkno", "欭"},
	{"wkoo", "㽠"},
	{"wkp", "恩"},
	{"wks", "男 㘞 㽖"},
	{"wl", "甲"},
	{"wlbi", "禺"},
	{"wlbm", "罝"},
	{"wlbnd", "罦"},
	{"wlbuc", "買"},
	{"wlcnh", "罤"},
	{"wlcwa", "罾"},
	{"wld", "䍒"},
	{"wldd", "罧"},
	{"wlea", "䍝"},
	{"wleee", "罬"},
	{"wlfd", "䍘"},
	{"wlff", "眔"},
	{"wlga", "圕"},
	{"wlgg", "罣"},
	{"wlggy", "罫"},
	{"wlgi", "罢"},
	{"wlgif", "罴"},
	{"wlgrv", "瞏"},
	{"wlgtj", "睪"},
	{"wlhaf", "鴨"},
	{"wlhhw", "罶"},
	{"wlhui", "㝶"},
	{"wlhvi", "䍕"},
	{"wlhvo", "罛"},
	{"wliav", "䍚"},
	{"wlibp", "罷"},
	{"wlipf", "羆"},
	{"wlirm", "罭"},
	{"wlivn", "罚"},
	{"wlixp", "䍡"},
	{"wljbj", "罱"},
	{"wljbm", "置"},
	{"wljka", "署"},
	{"wljr", "罟"},
	{"wlki", "䍔"},
	{"wlklu", "罨"},
	{"wll", "罒"},
	{"wlll", "甽"},
	{"wllmy", "罪"},
	{"wlln", "𠝹"},
	{"wlmbw", "䍣"},
	{"wlmc", "圚"},
	{"wlmf", "罘"},
	{"wlmfn", "罽"},
	{"wlmhm", "䍥"},
	{"wlmj", "䍐"},
	{"wlmrv", "睘"},
	{"wlmvh", "䍓"},
	{"wlmym", "罡"},
	{"wlni", "罗"},
	{"wlnih", "罞"},
	{"wlog", "䍜"},
	{"wloi", "罖"},
	{"wlooo", "眾"},
	{"wlotf", "䍢"},
	{"wlowy", "䍙"},
	{"wlpli", "蜀"},
	{"wlpog", "罹"},
	{"wlpru", "䍖"},
	{"wlpym", "鸭"},
	{"wlrb", "罥"},
	{"wlrvp", "罠"},
	{"wlsfi", "罻"},
	{"wlsmm", "翈"},
	{"wlsqf", "罵"},
	{"wltab", "羃"},
	{"wltjf", "羈"},
	{"wltjm", "羁"},
	{"wltjr", "羇"},
	{"wluce", "䍟"},
	{"wlvfb", "羂"},
	{"wlvff", "羉"},
	{"wlvfg", "羅"},
	{"wlvfj", "羄"},
	{"wlvvd", "罺"},
	{"wlwjr", "䍛"},
	{"wlwp", "罳"},
	{"wlwtj", "罼"},
	{"wlwwk", "奰"},
	{"wlwww", "𦌵"},
	{"wlyaj", "罩"},
	{"wlybg", "䍦"},
	{"wlyg", "罜"},
	{"wlymr", "詈"},
	{"wlyri", "罸"},
	{"wlyrn", "罰"},
	{"wlyta", "罯"},
	{"wlytg", "罿"},
	{"wlyub", "䍠"},
	{"wlyvi", "䍗"},
	{"wlyx", "䍤"},
	{"wmbb", "㽭"},
	{"wmf", "囨"},
	{"wmg", "囯"},
	{"wmgi", "国"},
	{"wmhaf", "䴑"},
	{"wmhlo", "爴"},
	{"wmhqu", "氎 㲲"},
	{"wml", "畀"},
	{"wmln", "㓻"},
	{"wmmi", "囩"},
	{"wmmr", "圄"},
	{"wmmu", "园"},
	{"wmn", "町"},
	{"wmso", "圂"},
	{"wmv", "畏"},
	{"wmwm", "疅"},
	{"wmym", "囸"},
	{"wnd", "囝"},
	{"wng", "墅 㙒"},
	{"wnhd", "㽥"},
	{"wno", "畂"},
	{"wo", "囚 㽗"},
	{"wohh", "畛"},
	{"woii", "囹"},
	{"wok", "畋"},
	{"woll", "界 畍"},
	{"womb", "圇"},
	{"womd", "畭"},
	{"wop", "囮 囵 慁"},
	{"wowy", "畮"},
	{"wp", "思"},
	{"wpfd", "㽤"},
	{"wph", "㘠"},
	{"wphh", "囫"},
	{"wpim", "畇"},
	{"wpks", "㔥"},
	{"wpmbc", "顋"},
	{"wpp", "毗 毘"},
	{"wpr", "㽛"},
	{"wpu", "囤"},
	{"wqki", "畴"},
	{"wqmb", "圊 𤲟"},
	{"wqo", "畉"},
	{"wqs", "围"},
	{"wr", "回"},
	{"wrb", "㘣"},
	{"wrbc", "圓"},
	{"wrbo", "圆"},
	{"wrf", "㸃"},
	{"wrq", "㨼"},
	{"wrvif", "䌎"},
	{"wrvp", "囻"},
	{"wryw", "圖"},
	{"ws", "囙"},
	{"wshqm", "㽒"},
	{"wsl", "囬"},
	{"wsmh", "疁"},
	{"wsp", "㤙"},
	{"wsvws", "嬲"},
	{"wt", "㘟"},
	{"wtc", "異"},
	{"wthvo", "㼔"},
	{"wtj", "畢"},
	{"wtju", "𤳙"},
	{"wtlo", "𤳉"},
	{"wtqm", "㽨"},
	{"wtt", "囲 畊"},
	{"wtvi", "㽧"},
	{"wumb", "圌"},
	{"wuob", "㽯"},
	{"wv", "囡 㚻"},
	{"wvfd", "圞"},
	{"wvff", "圝"},
	{"wvhaf", "䴉"},
	{"wvif", "累"},
	{"wvpym", "鹮"},
	{"wvsmm", "翾"},
	{"ww", "畕"},
	{"wwhaf", "鸓"},
	{"wwks", "㔣"},
	{"wwl", "㘡"},
	{"wwlj", "圛"},
	{"wwls", "圐"},
	{"wwlv", "圜"},
	{"www", "畾"},
	{"wwwc", "𨯔"},
	{"wwwd", "櫐"},
	{"wwwf", "纍 䴎"},
	{"wwwg", "壘"},
	{"wwwm", "疊 㽮"},
	{"wwwr", "礨"},
	{"wwwu", "罍"},
	{"wwwwg", "壨"},
	{"wybuc", "貫"},
	{"wyhaf", "䳇"},
	{"wyhn", "囥 㽘"},
	{"wyhv", "畩"},
	{"wyi", "母"},
	{"wyk", "図"},
	{"wymr", "圁"},
	{"wynd", "㝀 𡥘"},
	{"wypd", "毑"},
	{"wytg", "疃"},
	{"wyv", "甿"},
	{"wyvo", "畡"},
	{"wyyhv", "袰"},
	{"xaaa", "晿"},
	{"xaaam", "曐"},
	{"xab", "冐"},
	{"xabbe", "暧"},
	{"xabkq", "晖"},
	{"xahqm", "甠"},
	{"xaihs", "晠"},
	{"xaj", "旪"},
	{"xajka", "暏"},
	{"xalmo", "晀"},
	{"xambi", "曧"},
	{"xamru", "鼌"},
	{"xancr", "閲"},
	{"xatc", "晎"},
	{"xatmj", "曅"},
	{"xb", "冂 冖 爫 ⺆ ⺝ ⺥ ⺼"},
	{"xbb", "肎"},
	{"xbbm", "冝"},
	{"xbbyk", "髄"},
	{"xbcok", "贁"},
	{"xbcsh", "肦"},
	{"xbdi", "寽"},
	{"xbfqu", "膡"},
	{"xbgi", "戵"},
	{"xbkf", "脄"},
	{"xbkn", "肍"},
	{"xblwl", "腗"},
	{"xbmm", "冃"},
	{"xboij", "贱"},
	{"xbulm", "瞆"},
	{"xbund", "觃"},
	{"xbv", "肗"},
	{"xbybb", "腣"},
	{"xc", "丷"},
	{"xcaa", "锠"},
	{"xcahu", "镅"},
	{"xcam", "钽"},
	{"xcami", "锝"},
	{"xcaph", "锡"},
	{"xcapp", "锟"},
	{"xcau", "钯"},
	{"xcawe", "镘"},
	{"xcb", "钥"},
	{"xcbdi", "锊"},
	{"xcbme", "锾"},
	{"xcbms", "锄"},
	{"xcbu", "钼"},
	{"xcc", "釡"},
	{"xccnh", "锑"},
	{"xccru", "锐"},
	{"xcdhe", "铍"},
	{"xcdm", "钵"},
	{"xcei", "钗"},
	{"xcf", "钬"},
	{"xcfb", "销"},
	{"xcfbc", "鑜"},
	{"xcfbg", "镗"},
	{"xcfbu", "镋"},
	{"xcff", "锬"},
	{"xcfh", "钞"},
	{"xcfqu", "锩"},
	{"xcg", "钍"},
	{"xcha", "铂"},
	{"xchab", "锦"},
	{"xchag", "锽"},
	{"xchdf", "锹"},
	{"xchds", "锈"},
	{"xche", "钣"},
	{"xchej", "锋"},
	{"xcher", "铬"},
	{"xchgi", "铥"},
	{"xchgr", "锆"},
	{"xchgu", "铣"},
	{"xchhh", "钐"},
	{"xchhl", "铆"},
	{"xchhw", "镏"},
	{"xchj", "钎"},
	{"xchjd", "铢"},
	{"xchje", "锻"},
	{"xchjg", "锺"},
	{"xchjm", "锤"},
	{"xchjr", "铦"},
	{"xchjx", "锸"},
	{"xchni", "钒"},
	{"xchnr", "铅"},
	{"xchqi", "锇"},
	{"xchud", "镍"},
	{"xchxe", "锼"},
	{"xci", "鈛"},
	{"xciav", "锒"},
	{"xcibi", "镈"},
	{"xcihs", "铖"},
	{"xcihu", "兊"},
	{"xcii", "鉱"},
	{"xcijb", "铺"},
	{"xcike", "钹"},
	{"xcilb", "镛"},
	{"xcipf", "镳"},
	{"xcipp", "铽"},
	{"xcitc", "镰"},
	{"xcite", "镀"},
	{"xciv", "钺"},
	{"xcj", "针"},
	{"xcjcr", "镕"},
	{"xcjka", "锗"},
	{"xcjkp", "铑"},
	{"xcjks", "铐"},
	{"xcjp", "铊"},
	{"xcjr", "钴"},
	{"xcjv", "铵"},
	{"xckb", "铕"},
	{"xckcf", "镣"},
	{"xckjt", "锛"},
	{"xcklb", "钸"},
	{"xckmr", "锜"},
	{"xclll", "钏"},
	{"xclmi", "锵"},
	{"xclmo", "铫"},
	{"xcln", "钊"},
	{"xclw", "铀"},
	{"xcmbw", "镭"},
	{"xcmf", "钚"},
	{"xcmfe", "錽"},
	{"xcmgi", "钰"},
	{"xcmhl", "铘"},
	{"xcmig", "铚"},
	{"xcmmr", "铻"},
	{"xcmn", "钉"},
	{"xcmnr", "钶"},
	{"xcmrb", "镉"},
	{"xcmt", "钘"},
	{"xcmtn", "铏"},
	{"xcmto", "镢"},
	{"xcmwf", "镖"},
	{"xcmwj", "镡"},
	{"xcmym", "钲"},
	{"xcmys", "钙"},
	{"xcn", "钇"},
	{"xcnau", "铯"},
	{"xcndt", "锰"},
	{"xcng", "钮"},
	{"xcnhe", "钑"},
	{"xcnir", "铭"},
	{"xcnkg", "铤"},
	{"xcnkq", "键"},
	{"xcnlr", "锕"},
	{"xcnn", "钌"},
	{"xcno", "钦"},
	{"xcnot", "镫"},
	{"xcnri", "镵"},
	{"xcnsd", "铮"},
	{"xcnwa", "镥"},
	{"xcob", "钠"},
	{"xcog", "锥"},
	{"xcoin", "钤"},
	{"xcomg", "铨"},
	{"xcomr", "铪"},
	{"xcoog", "锉"},
	{"xcop", "鈋"},
	{"xcorq", "镎"},
	{"xcph", "铋"},
	{"xcphp", "锪"},
	{"xcpi", "钓"},
	{"xcpim", "钧"},
	{"xcppa", "锴"},
	{"xcpru", "铇"},
	{"xcpu", "钝"},
	{"xcqhk", "锲"},
	{"xcqki", "铸"},
	{"xcqmb", "锖"},
	{"xcrhu", "兑"},
	{"xcrlb", "铞"},
	{"xcrmg", "锃"},
	{"xcrr", "铝"},
	{"xcrrs", "锷"},
	{"xcsj", "铒"},
	{"xcsje", "镊"},
	{"xcsjr", "锯"},
	{"xcsme", "锓"},
	{"xcsmh", "镠"},
	{"xcsp", "铌"},
	{"xcsr", "钷"},
	{"xcss", "钜"},
	{"xcssr", "锔"},
	{"xcta", "错"},
	{"xctak", "镆"},
	{"xctca", "镨"},
	{"xctco", "镤"},
	{"xctct", "镒"},
	{"xctgk", "镁"},
	{"xctkr", "锘"},
	{"xctlk", "锳"},
	{"xctm", "钳"},
	{"xctoe", "镬"},
	{"xctvi", "镃"},
	{"xctw", "锚"},
	{"xctwi", "鑖"},
	{"xctyv", "铓"},
	{"xcu", "钆"},
	{"xcubb", "镚"},
	{"xcuce", "鑁"},
	{"xcuok", "敚"},
	{"xcv", "钕"},
	{"xcvr", "铷"},
	{"xcvvv", "镴"},
	{"xcvvw", "锱"},
	{"xcw", "钿"},
	{"xcwa", "曽"},
	{"xcwd", "锞"},
	{"xcwg", "锂"},
	{"xcwjr", "锢"},
	{"xcwk", "铟"},
	{"xcwl", "钾"},
	{"xcwli", "镯"},
	{"xcwlv", "镮"},
	{"xcwp", "锶"},
	{"xcwvf", "镙"},
	{"xcy", "钋"},
	{"xcybs", "镑"},
	{"xcycb", "镝"},
	{"xcyck", "铰"},
	{"xcydk", "镦"},
	{"xcyhn", "钪"},
	{"xcyhs", "钫"},
	{"xcyhv", "铱"},
	{"xcyiu", "锍"},
	{"xcyj", "钭"},
	{"xcylb", "铈"},
	{"xcyr", "钻"},
	{"xcyrb", "镐"},
	{"xcyrv", "镶"},
	{"xcysk", "镞"},
	{"xcyso", "镟"},
	{"xcytj", "锌"},
	{"xcytp", "镱"},
	{"xcytr", "锫"},
	{"xcytu", "镜"},
	{"xcyvi", "铉"},
	{"xdb", "枂"},
	{"xdc", "朩"},
	{"xdci", "枩"},
	{"xdcru", "棁"},
	{"xddbu", "鬰"},
	{"xddf", "燓"},
	{"xddg", "壄"},
	{"xdffr", "檆"},
	{"xdhap", "梍"},
	{"xdhsk", "棙"},
	{"xdje", "叏"},
	{"xdjpu", "桡"},
	{"xdmbb", "欛"},
	{"xdmbs", "樰"},
	{"xdn", "朰"},
	{"xdnau", "梚"},
	{"xdnlb", "椭"},
	{"xdno", "杦"},
	{"xdnwa", "橹"},
	{"xdo", "杁"},
	{"xdogs", "槜"},
	{"xdomo", "検"},
	{"xdoo", "枞"},
	{"xdrrr", "楍"},
	{"xdsmi", "桪"},
	{"xdsp", "愸"},
	{"xdtbo", "赉"},
	{"xdtge", "様"},
	{"xdtwi", "櫗"},
	{"xdu", "杣"},
	{"xdytu", "槞"},
	{"xe", "氵 氺"},
	{"xeapp", "渇"},
	{"xebp", "懑"},
	{"xebuu", "覌"},
	{"xecru", "涚"},
	{"xeeee", "涰"},
	{"xehe", "汷"},
	{"xehf", "烫"},
	{"xehq", "汼"},
	{"xehxf", "澙"},
	{"xeikh", "浝"},
	{"xejjn", "瀭"},
	{"xelg", "壍"},
	{"xelmo", "溃"},
	{"xemwd", "潥"},
	{"xenbk", "涣"},
	{"xend", "汓"},
	{"xeno", "汣"},
	{"xenwa", "澛"},
	{"xeo", "氼"},
	{"xeqmb", "淸"},
	{"xesim", "涩"},
	{"xesmb", "瀥"},
	{"xesmi", "浔"},
	{"xesmj", "瀈"},
	{"xetlx", "潇"},
	{"xetub", "満"},
	{"xewlo", "潈"},
	{"xeycb", "滳"},
	{"xeyg", "塰"},
	{"xeykl", "済"},
	{"xeylh", "渉"},
	{"xeypp", "滤"},
	{"xeytu", "滰"},
	{"xf", "灬 ⺌ ⺍"},
	{"xfbha", "鴬"},
	{"xfbpy", "鸴"},
	{"xfcq", "挙"},
	{"xfdmb", "糥"},
	{"xfdok", "敩"},
	{"xfdtc", "粠"},
	{"xfdv", "娄"},
	{"xfff", "尛"},
	{"xffno", "歘"},
	{"xfg", "尘"},
	{"xfhby", "炿"},
	{"xfklb", "幤"},
	{"xfmbc", "熕"},
	{"xfnbk", "焕"},
	{"xfqsu", "巻"},
	{"xftwi", "爡"},
	{"xfw", "畄"},
	{"xfwd", "焑"},
	{"xfyrd", "燺"},
	{"xgbdi", "埓"},
	{"xgblm", "壷"},
	{"xgbmc", "壸"},
	{"xgcwa", "増"},
	{"xggg", "壵"},
	{"xggks", "劸"},
	{"xgi", "圹"},
	{"xgig", "堼"},
	{"xgilb", "幇"},
	{"xgisq", "驇"},
	{"xgmwg", "壥"},
	{"xgtdh", "皼"},
	{"xgu", "圸"},
	{"xgyk", "垯"},
	{"xh", "𠂆 ⺮"},
	{"xhahu", "篃"},
	{"xhap", "皀"},
	{"xhbks", "勪"},
	{"xhbnd", "筟"},
	{"xhdcr", "税"},
	{"xhdnw", "穞"},
	{"xhdwd", "稇"},
	{"xhfks", "鳨"},
	{"xhfnl", "鄥"},
	{"xhhha", "鵢"},
	{"xhhoo", "篵"},
	{"xhipy", "鸱"},
	{"xhir", "啔"},
	{"xhjd", "筞"},
	{"xhjha", "鷱"},
	{"xhka", "晵"},
	{"xhlmo", "篑"},
	{"xhln", "乺"},
	{"xhlx", "箫"},
	{"xhmbg", "籱"},
	{"xhnbm", "飓"},
	{"xhnff", "飚"},
	{"xhnhh", "飗"},
	{"xhnhx", "飕"},
	{"xhnik", "颰"},
	{"xhnma", "凬"},
	{"xhnp", "悡"},
	{"xhnpr", "飑"},
	{"xhnry", "躛"},
	{"xhnwp", "飔"},
	{"xhnym", "讏"},
	{"xhnyr", "飐"},
	{"xhocm", "衔"},
	{"xhoir", "筨"},
	{"xhojw", "徳"},
	{"xhomg", "彺"},
	{"xhoug", "徴"},
	{"xhpmb", "顖"},
	{"xhqi", "牫"},
	{"xhqr", "吿"},
	{"xhrks", "劶"},
	{"xhrok", "敌"},
	{"xhrpy", "鸹"},
	{"xhsk", "戻"},
	{"xhsyj", "簈"},
	{"xhunw", "氇"},
	{"xhuu", "臫"},
	{"xhvio", "笖"},
	{"xhvp", "憄"},
	{"xhwmv", "粤"},
	{"xhyhn", "舧"},
	{"xhyhs", "舮"},
	{"xhysc", "簱"},
	{"xhywv", "簔"},
	{"xi", "丶 广"},
	{"xiebt", "盋"},
	{"xiedh", "皳"},
	{"xifwd", "祵"},
	{"xihhq", "毵"},
	{"xihi", "庅"},
	{"xiiim", "亝"},
	{"xij", "戋"},
	{"xiklu", "奙"},
	{"xiod", "楽"},
	{"xiogr", "噟"},
	{"xipg", "垄"},
	{"xir", "戓"},
	{"xirnl", "鄌"},
	{"xivop", "讹"},
	{"xivpa", "诣"},
	{"xj", "宀"},
	{"xjcmb", "顮"},
	{"xjcqo", "窥"},
	{"xjeq", "撃"},
	{"xjevi", "繋"},
	{"xjju", "乹"},
	{"xjjyj", "輧"},
	{"xjmmu", "崈"},
	{"xjpbn", "寜"},
	{"xjt", "卋"},
	{"xjtbu", "宽"},
	{"xjtd", "枽"},
	{"xjuha", "鴧 鵍"},
	{"xjuks", "勊"},
	{"xk", "疒 𠂇"},
	{"xkau", "夿"},
	{"xkbb", "奟"},
	{"xkd", "杀"},
	{"xkdi", "疛"},
	{"xkdln", "刹"},
	{"xkdlo", "癞"},
	{"xkhha", "獆"},
	{"xkhnd", "狲"},
	{"xkhup", "瘪"},
	{"xkhvi", "奃"},
	{"xki", "厷"},
	{"xkk", "夶"},
	{"xklg", "堑"},
	{"xknbk", "痪"},
	{"xknha", "鴺"},
	{"xknlp", "瘾"},
	{"xkog", "奞"},
	{"xkoo", "疭"},
	{"xkr", "夻"},
	{"xkyvo", "奒"},
	{"xl", "丨 丿 肀 衤"},
	{"xlb", "帇"},
	{"xlibh", "蚬"},
	{"xlibt", "蛊"},
	{"xlicr", "蜕"},
	{"xlihw", "螕"},
	{"xlioi", "蛿"},
	{"xlitl", "蟏"},
	{"xlitw", "蠴"},
	{"xlnis", "牑"},
	{"xlsyk", "闼"},
	{"xltgi", "襨"},
	{"xlx", "肃"},
	{"xlykq", "裢"},
	{"xmbhh", "彨 鬸"},
	{"xmblm", "蠒"},
	{"xmbnl", "郦"},
	{"xmbo", "贡"},
	{"xmbog", "靏"},
	{"xmbpy", "鹝"},
	{"xmf", "灭"},
	{"xmg", "圧"},
	{"xmgbb", "瑷"},
	{"xmgc", "兲"},
	{"xmghe", "臵"},
	{"xmgi", "压"},
	{"xmh", "丆"},
	{"xmhaf", "鳫"},
	{"xmibb", "叆"},
	{"xmiyl", "叇"},
	{"xmjok", "攼"},
	{"xmklm", "蝅"},
	{"xmkq", "厍"},
	{"xmks", "历"},
	{"xml", "丅"},
	{"xmllm", "亜"},
	{"xmllw", "畱"},
	{"xmmln", "刯"},
	{"xmmmb", "頙"},
	{"xmmp", "悪"},
	{"xmmuu", "鼋"},
	{"xmmvs", "亏"},
	{"xmnc", "銐"},
	{"xmnf", "烮"},
	{"xmnhj", "歼"},
	{"xmnnl", "邷"},
	{"xmo", "乀"},
	{"xmod", "橜"},
	{"xmop", "憠"},
	{"xmri", "戨"},
	{"xmrii", "砿"},
	{"xmrsf", "礟"},
	{"xms", "戸"},
	{"xmsks", "劢"},
	{"xmtln", "剅"},
	{"xmumb", "頋 顽"},
	{"xmwmb", "酾"},
	{"xn", "乛 亅 ⺄"},
	{"xnbha", "鵤"},
	{"xnbk", "奂"},
	{"xnfll", "魸"},
	{"xnfo", "魞"},
	{"xnfoi", "鮘"},
	{"xnlfh", "隲"},
	{"xnloi", "阾"},
	{"xnlom", "険"},
	{"xnm", "弖"},
	{"xnmei", "鳋"},
	{"xnmik", "鲹"},
	{"xnmir", "鲐"},
	{"xnmis", "鳊"},
	{"xnmlm", "鳉"},
	{"xnmmb", "鲡"},
	{"xnmmw", "鳔"},
	{"xnmod", "鲋"},
	{"xnmsu", "鱾"},
	{"xnmtm", "鲯"},
	{"xnmyi", "巯"},
	{"xnnm", "孒"},
	{"xnno", "弞"},
	{"xnog", "坠"},
	{"xnpd", "櫽"},
	{"xnsbt", "盁"},
	{"xnsf", "熃"},
	{"xnsll", "弫"},
	{"xo", "亻 ㇏"},
	{"xob", "内"},
	{"xobhu", "伣"},
	{"xofd", "侎"},
	{"xoghq", "犫"},
	{"xogog", "雦"},
	{"xogp", "俧"},
	{"xoi", "仏"},
	{"xoiln", "刢"},
	{"xoini", "侌"},
	{"xoinl", "郐"},
	{"xoino", "贪"},
	{"xojbv", "値"},
	{"xojcr", "僒"},
	{"xojd", "俕"},
	{"xokkb", "倄"},
	{"xombb", "俪"},
	{"xomg", "仼"},
	{"xommm", "佱"},
	{"xommp", "僫"},
	{"xomnn", "侴"},
	{"xomno", "欫"},
	{"xomr", "佦"},
	{"xomvm", "仾"},
	{"xonln", "刏"},
	{"xonno", "欦"},
	{"xoo", "仌"},
	{"xoof", "燞"},
	{"xooln", "剣"},
	{"xoomo", "倹"},
	{"xoomr", "倽"},
	{"xoop", "怂"},
	{"xoosk", "剱"},
	{"xopbo", "贷"},
	{"xorij", "舗"},
	{"xormb", "颌"},
	{"xorsj", "聟"},
	{"xorsm", "翖"},
	{"xosk", "伛"},
	{"xov", "兦"},
	{"xoy", "仒"},
	{"xoyjj", "倂"},
	{"xoyks", "勄"},
	{"xp", "勹 忄 㣺"},
	{"xpaha", "鴲"},
	{"xpcru", "悦"},
	{"xpfmb", "颎"},
	{"xpfqu", "慻"},
	{"xpijb", "悑"},
	{"xpnin", "忬"},
	{"xpo", "勽"},
	{"xpomn", "忾"},
	{"xpomr", "匌"},
	{"xpp", "匂"},
	{"xppd", "忚"},
	{"xpr", "吢"},
	{"xptbo", "贳"},
	{"xpvvw", "匘"},
	{"xpyv", "匄"},
	{"xq", "扌"},
	{"xqapp", "掲"},
	{"xqbou", "摇"},
	{"xqc", "捦"},
	{"xqcno", "揿"},
	{"xqcru", "捝"},
	{"xqfbu", "撹"},
	{"xqhjl", "揷"},
	{"xqhuo", "攒"},
	{"xqi", "扩"},
	{"xqif", "焘"},
	{"xqjcn", "摉"},
	{"xqjco", "攨"},
	{"xqke", "抜"},
	{"xqkn", "扏"},
	{"xqks", "劧"},
	{"xqlf", "烲"},
	{"xqlln", "扸"},
	{"xqnbk", "换"},
	{"xqnri", "摾"},
	{"xqnsd", "挅"},
	{"xqnwa", "撸"},
	{"xqo", "扖"},
	{"xqogs", "擕"},
	{"xqpmm", "搄"},
	{"xqsje", "摄"},
	{"xqsmi", "挦"},
	{"xqtkl", "掷"},
	{"xqud", "椝"},
	{"xqumr", "鬶"},
	{"xqyk", "挞"},
	{"xqymy", "挊"},
	{"xqypp", "摅"},
	{"xqyps", "掳"},
	{"xrbbe", "嗳"},
	{"xrbln", "剈"},
	{"xrbo", "呗"},
	{"xrhaj", "噑"},
	{"xrjbo", "嚔"},
	{"xrlx", "啸"},
	{"xrmlm", "唖"},
	{"xrmmp", "囇"},
	{"xrmsj", "蹑"},
	{"xrmtk", "踯"},
	{"xrnbk", "唤"},
	{"xrnwa", "噜"},
	{"xrob", "呐"},
	{"xrpa", "昬"},
	{"xrr", "吅"},
	{"xrrmc", "嚻"},
	{"xrrwm", "鼍"},
	{"xrsh", "叧"},
	{"xrsln", "别"},
	{"xrspy", "鸮"},
	{"xrtmj", "哶"},
	{"xrvfi", "嚩"},
	{"xryk", "哒"},
	{"xrymu", "啮"},
	{"xs", "𠃌"},
	{"xsfe", "叞"},
	{"xsfom", "験"},
	{"xshov", "屦"},
	{"xsito", "彟"},
	{"xsjha", "鵈"},
	{"xsjlm", "聎"},
	{"xsjvi", "聨 聮"},
	{"xskhn", "殹"},
	{"xsrbu", "覠"},
	{"xsrlb", "帬"},
	{"xsrno", "欩"},
	{"xssn", "巪"},
	{"xt", "卝 艹 䒑 ⺾"},
	{"xtbg", "茔"},
	{"xtbks", "荕"},
	{"xtbmi", "蒄"},
	{"xtbuf", "繤"},
	{"xtclm", "蜝"},
	{"xtese", "薓"},
	{"xtf", "炗"},
	{"xtgf", "羙"},
	{"xthai", "莵"},
	{"xthdf", "蘓"},
	{"xthdj", "薭"},
	{"xthgf", "薫"},
	{"xthni", "葻"},
	{"xtihs", "蔵"},
	{"xtj", "丗"},
	{"xtjbl", "帯"},
	{"xtjmc", "薲"},
	{"xtjnd", "茡"},
	{"xtjpi", "藌"},
	{"xtjpu", "荛"},
	{"xtknl", "郑"},
	{"xtlx", "萧"},
	{"xtmce", "虁"},
	{"xtmks", "苈"},
	{"xtmms", "芌"},
	{"xtmmv", "莀"},
	{"xtndf", "荪"},
	{"xtni", "芕"},
	{"xtoir", "莟"},
	{"xtomm", "莶"},
	{"xtop", "芲"},
	{"xtq", "芈"},
	{"xtrok", "敾"},
	{"xtsmi", "荨"},
	{"xttnl", "鄷"},
	{"xttsh", "剏"},
	{"xtvfe", "蘰"},
	{"xtvft", "藴"},
	{"xtvno", "蒃"},
	{"xtwln", "萝"},
	{"xtycv", "蓘"},
	{"xtyk", "荙"},
	{"xtykl", "萕"},
	{"xtytj", "蔁"},
	{"xu", "乚"},
	{"xubmr", "峝"},
	{"xucno", "嵚"},
	{"xuhaf", "嶌"},
	{"xuhoo", "嵸"},
	{"xuhvi", "岻"},
	{"xujjl", "嶃"},
	{"xulw", "峀"},
	{"xum", "屵"},
	{"xummu", "嶏"},
	{"xumnn", "峢"},
	{"xumog", "嶳"},
	{"xumto", "嶥"},
	{"xunbq", "崅"},
	{"xuogf", "嶣"},
	{"xushr", "岹"},
	{"xusuu", "崫"},
	{"xutqm", "嵳"},
	{"xuuce", "嵏"},
	{"xuybk", "巚"},
	{"xuybp", "巄"},
	{"xuyoj", "崪"},
	{"xuyrb", "嵪"},
	{"xvbbe", "嫒"},
	{"xvend", "媣"},
	{"xvfii", "絋"},
	{"xvfjk", "緖"},
	{"xvfll", "繍"},
	{"xvfmc", "綇"},
	{"xvfnr", "繦"},
	{"xvfpm", "縆"},
	{"xvfu", "糺"},
	{"xvfwd", "綶"},
	{"xvhxc", "嬩"},
	{"xviks", "妫"},
	{"xvmbb", "绷"},
	{"xvmfb", "绡"},
	{"xvmij", "绒"},
	{"xvmr", "辔"},
	{"xvnf", "煭"},
	{"xvsmg", "媉"},
	{"xvtt", "妌"},
	{"xvv", "巜"},
	{"xwfqu", "圏"},
	{"xwgf", "黒"},
	{"xwmn", "甼"},
	{"xwwwm", "疉"},
	{"xxana", "晩"},
	{"xxano", "閄"},
	{"xxbub", "瞐"},
	{"xxccr", "鋭"},
	{"xxchl", "锨"},
	{"xxcjb", "镲"},
	{"xxcki", "钛"},
	{"xxcnl", "鈟"},
	{"xxcog", "镌"},
	{"xxcsh", "兺"},
	{"xxdkp", "慭"},
	{"xxdmw", "樮"},
	{"xxdyt", "櫣"},
	{"xxeee", "渁"},
	{"xxeg", "汢"},
	{"xxfbr", "尙"},
	{"xxgi", "圡"},
	{"xxgnh", "殻"},
	{"xxgok", "垁"},
	{"xxhbt", "笽"},
	{"xxhcl", "劕"},
	{"xxhdh", "穒"},
	{"xxhjs", "翶"},
	{"xxhnd", "凩"},
	{"xxhop", "惥"},
	{"xxhrm", "頶"},
	{"xxhro", "敋"},
	{"xxhsm", "箼"},
	{"xxhuf", "焈"},
	{"xxhuu", "笜"},
	{"xxhwp", "恖"},
	{"xxii", "厸"},
	{"xxikp", "懯"},
	{"xxip", "応"},
	{"xxipf", "熋"},
	{"xxjch", "鴪"},
	{"xxjju", "軕"},
	{"xxkf", "夵"},
	{"xxki", "厺"},
	{"xxku", "乄"},
	{"xxmbh", "鳾"},
	{"xxmbp", "鸸"},
	{"xxmgc", "玐"},
	{"xxmgh", "鸖"},
	{"xxmkp", "懕"},
	{"xxmks", "亐"},
	{"xxmmh", "鵶"},
	{"xxmmp", "忈"},
	{"xxmo", "乁"},
	{"xxmrm", "碽"},
	{"xxnbg", "堕"},
	{"xxnbk", "勈"},
	{"xxnn", "弜"},
	{"xxog", "玍"},
	{"xxogr", "舎"},
	{"xxoi", "亽"},
	{"xxoj", "仐"},
	{"xxop", "仑"},
	{"xxosk", "仭"},
	{"xxqi", "払"},
	{"xxqpm", "抣"},
	{"xxrha", "唕"},
	{"xxrob", "呙"},
	{"xxrom", "哬"},
	{"xxrym", "噛"},
	{"xxsk", "刄"},
	{"xxsm", "匞"},
	{"xxsrl", "剾"},
	{"xxtk", "芖"},
	{"xxtwl", "薥"},
	{"xxvfh", "縦"},
	{"xxvl", "丩"},
	{"xxxbf", "鰧"},
	{"xxxcj", "镓"},
	{"xxxcn", "镪"},
	{"xxxcp", "钩"},
	{"xxxcy", "铳 锿"},
	{"xxxdk", "慗"},
	{"xxxmm", "忢 鴊"},
	{"xxxmr", "頢"},
	{"xxxof", "仦"},
	{"xxxtg", "羐"},
	{"xxxtv", "荮"},
	{"xxxua", "乢"},
	{"xxxuu", "岀"},
	{"xy", "亠 辶 ⺀ ⺊ ⻌ ⻍"},
	{"y", "卜"},
	{"ya", "𨑨"},
	{"yaayf", "𩐿"},
	{"yad", "桌"},
	{"yaf", "亰"},
	{"yahaf", "鶕"},
	{"yahag", "韹"},
	{"yahe", "㚆"},
	{"yahej", "韸"},
	{"yai", "戠"},
	{"yaitc", "𩑈"},
	{"yaj", "卓"},
	{"yajbd", "䪬"},
	{"yalb", "𢂚"},
	{"yam", "䪦"},
	{"yambc", "𩐳"},
	{"yamh", "逿"},
	{"yamlb", "韴"},
	{"yamo", "遈"},
	{"yamvm", "䪫"},
	{"yano", "歆"},
	{"yaog", "暹"},
	{"yaoin", "䪩"},
	{"yaok", "㪟"},
	{"yap", "恴"},
	{"yapd", "䪧"},
	{"yaph", "逷"},
	{"yapi", "䪨"},
	{"yapim", "韵"},
	{"yapr", "𩐝"},
	{"yapuu", "䪮"},
	{"yapv", "遏"},
	{"yarbc", "韻"},
	{"yashr", "韶"},
	{"yasm", "遢"},
	{"yatc", "𩐠"},
	{"yatlk", "韺"},
	{"yatoe", "頀"},
	{"yauu", "韷"},
	{"yav", "退"},
	{"yayhj", "韼"},
	{"yayta", "䪭"},
	{"yaytp", "䪰"},
	{"yb", "迌"},
	{"ybaht", "髜"},
	{"ybau", "䯩"},
	{"ybb", "肻"},
	{"ybbq", "䢬"},
	{"ybbr", "卨 過"},
	{"ybcr", "䢛"},
	{"ybd", "槀"},
	{"ybe", "㕟"},
	{"ybelm", "䪟"},
	{"ybffs", "髝"},
	{"ybg", "㙜"},
	{"ybgr", "週"},
	{"ybhaf", "鶙 鶮"},
	{"ybhd", "稾"},
	{"ybhg", "望"},
	{"ybhne", "毃"},
	{"ybhu", "邈"},
	{"ybik", "獻"},
	{"ybikp", "𢅛"},
	{"ybjj", "運"},
	{"ybk", "䯨"},
	{"ybkb", "𥜽"},
	{"yblb", "帝"},
	{"yblbr", "啻"},
	{"yblbv", "㛳"},
	{"ybm", "䢐"},
	{"ybmbc", "䫕 䯪"},
	{"ybmcr", "䜭"},
	{"ybmcu", "睿"},
	{"ybmo", "遯"},
	{"ybmr", "迵"},
	{"ybmvn", "甋 甗"},
	{"ybnl", "鄗"},
	{"ybno", "欳 歊 歒"},
	{"ybo", "贞"},
	{"ybog", "離"},
	{"ybok", "敵 㪣"},
	{"ybou", "遙 遥"},
	{"ybr", "迥"},
	{"ybrf", "邎"},
	{"ybrrd", "髞"},
	{"ybskn", "髛"},
	{"ybt", "盀"},
	{"ybuc", "貞 䢙"},
	{"ybue", "䢲"},
	{"ybye", "敲"},
	{"ybyhn", "髚"},
	{"ybyhs", "旁"},
	{"ybypp", "龖"},
	{"ybysp", "龍 㡣"},
	{"yc", "六"},
	{"ycbhu", "觑"},
	{"ycbr", "商 啇"},
	{"ycbt", "䀍"},
	{"ycc", "銮"},
	{"ycd", "栾"},
	{"yce", "变 㕢"},
	{"ycelm", "䪥"},
	{"ychaf", "鵉 鶐"},
	{"yche", "変"},
	{"ychhj", "顰"},
	{"yci", "戯"},
	{"yciu", "兖"},
	{"yciv", "衮"},
	{"yck", "交 奕"},
	{"yclb", "帟"},
	{"yclmi", "蛮"},
	{"ycmo", "亪"},
	{"ycn", "弯"},
	{"ycnd", "孪"},
	{"ycnh", "递"},
	{"ycnl", "𨜓"},
	{"ycobo", "脔"},
	{"ycor", "逧"},
	{"ycorv", "䘱"},
	{"ycp", "恋 戅 戇 𢥫"},
	{"ycpym", "鸾"},
	{"ycq", "挛"},
	{"ycrhu", "兗"},
	{"ycrhv", "袞"},
	{"yct", "弈"},
	{"ycttv", "㐮"},
	{"ycu", "峦"},
	{"ycv", "娈"},
	{"ydbuc", "䞄"},
	{"ydbuu", "親"},
	{"ydcwj", "亸"},
	{"ydd", "䢞"},
	{"ydhaf", "鶉"},
	{"ydhhh", "虨 㣓"},
	{"ydhml", "新"},
	{"ydi", "过"},
	{"ydkni", "孰"},
	{"ydl", "速"},
	{"ydlk", "遫"},
	{"ydlmi", "䗐"},
	{"ydlo", "遬"},
	{"ydmq", "違"},
	{"ydnl", "郭"},
	{"ydno", "歑"},
	{"ydod", "𨔼"},
	{"ydog", "雜"},
	{"ydok", "敦 敹"},
	{"ydoo", "逨"},
	{"ydpu", "㝄"},
	{"ydpym", "鹑"},
	{"ydrrj", "嚲"},
	{"ydyrd", "㝇"},
	{"ye", "攴"},
	{"yebu", "督"},
	{"yebuc", "䝳"},
	{"yec", "錖"},
	{"yed", "梷"},
	{"yeee", "逫"},
	{"yefd", "粲"},
	{"yefh", "逤"},
	{"yeg", "壑"},
	{"yelmm", "韰"},
	{"yenwf", "䱗"},
	{"yeoiv", "餐"},
	{"yep", "惄"},
	{"yev", "㛑"},
	{"yeyhv", "裻"},
	{"yfb", "逍"},
	{"yfd", "迷"},
	{"yfdq", "遴"},
	{"yfe", "叔"},
	{"yffq", "䢯"},
	{"yfhaf", "鶁"},
	{"yfiku", "就"},
	{"yfks", "勍"},
	{"yfln", "剠"},
	{"yfok", "䱷"},
	{"yfr", "㕻"},
	{"yft", "䢠"},
	{"yfye", "敊"},
	{"yg", "主"},
	{"ygbuu", "䚒"},
	{"ygcg", "逵"},
	{"yge", "﨎"},
	{"ygg", "䜃"},
	{"yggu", "遶"},
	{"yghaf", "䴀"},
	{"yghne", "殶"},
	{"yghqu", "氃"},
	{"ygi", "迲"},
	{"ygiv", "褻 䙝"},
	{"ygks", "勭"},
	{"ygmms", "虧"},
	{"ygmvn", "㼿"},
	{"ygpd", "逇"},
	{"ygr", "迼"},
	{"ygrv", "遠"},
	{"ygsk", "遨"},
	{"ygsmm", "𦒍"},
	{"ygtj", "逹"},
	{"ygtq", "達"},
	{"ygvv", "逺"},
	{"ygwc", "䢱"},
	{"yha", "迫"},
	{"yhaf", "鳪"},
	{"yhag", "遑"},
	{"yhbm", "亹"},
	{"yhbr", "逈"},
	{"yhdd", "䢤"},
	{"yhds", "透"},
	{"yhdv", "褎 襃 逶"},
	{"yhe", "返"},
	{"yhee", "邍"},
	{"yhej", "逢"},
	{"yheq", "逄"},
	{"yhg", "𨑳"},
	{"yhgr", "造 𨘥"},
	{"yhgu", "选"},
	{"yhgv", "𨘻"},
	{"yhhe", "邌"},
	{"yhhhh", "彥 彦"},
	{"yhhqm", "產 産"},
	{"yhhv", "裦"},
	{"yhhw", "遛"},
	{"yhiv", "褢"},
	{"yhj", "迁"},
	{"yhjr", "适"},
	{"yhju", "遁"},
	{"yhk", "迗"},
	{"yhkb", "䢪"},
	{"yhln", "劌"},
	{"yhmbc", "頻 顏 顔 顪"},
	{"yhmbo", "频 颜"},
	{"yhml", "近"},
	{"yhmo", "遾"},
	{"yhmr", "逅"},
	{"yhn", "亢"},
	{"yhoo", "䢨"},
	{"yhqb", "逓"},
	{"yhqo", "迭"},
	{"yhqv", "袠"},
	{"yhrr", "追"},
	{"yhs", "方 迮"},
	{"yhsb", "遍"},
	{"yhsd", "𨘋"},
	{"yhsk", "邀"},
	{"yhsmm", "翽"},
	{"yhur", "邉"},
	{"yhus", "邊"},
	{"yhv", "衣"},
	{"yhvi", "䢑"},
	{"yhvj", "䘚"},
	{"yhvl", "迎"},
	{"yhwv", "褏"},
	{"yhxc", "亷"},
	{"yhxe", "遚"},
	{"yhxv", "裒"},
	{"yhym", "𨒂"},
	{"yhyu", "遞"},
	{"yib", "育"},
	{"yice", "逡"},
	{"yif", "熟"},
	{"yifh", "玅"},
	{"yig", "塾"},
	{"yihaf", "䲻"},
	{"yihm", "䢕"},
	{"yihu", "充 㐬"},
	{"yihxo", "斔 螤"},
	{"yiih", "遪"},
	{"yijb", "逋"},
	{"yijc", "述"},
	{"yije", "逑"},
	{"yik", "迖"},
	{"yimr", "䃞"},
	{"yiohv", "玈"},
	{"yioj", "率"},
	{"yiok", "逘"},
	{"yir", "迨"},
	{"yirv", "袬"},
	{"yit", "弃"},
	{"yitd", "棄"},
	{"yitf", "遮"},
	{"yiwn", "夣"},
	{"yiyvi", "玆"},
	{"yj", "斗 辻"},
	{"yjb", "䢌"},
	{"yjbj", "遖"},
	{"yjco", "邃"},
	{"yjdi", "䢘"},
	{"yjdl", "辣"},
	{"yjeyj", "㵷"},
	{"yjf", "㷭"},
	{"yjhaf", "鵫"},
	{"yjhec", "贛"},
	{"yjhee", "竷"},
	{"yjheo", "赣"},
	{"yjhhh", "彰"},
	{"yjhoj", "瓣"},
	{"yjhqu", "㲔 㲞"},
	{"yji", "㦸"},
	{"yjilj", "辨"},
	{"yjivj", "辩"},
	{"yjksj", "辦"},
	{"yjlii", "蠭"},
	{"yjllj", "㸤"},
	{"yjlmi", "䗬"},
	{"yjmbc", "贑 顇"},
	{"yjmd", "䢓"},
	{"yjmy", "𠁎"},
	{"yjn", "乧 㪲"},
	{"yjnl", "鄣"},
	{"yjno", "㰵"},
	{"yjp", "迱 㦁"},
	{"yjpyj", "㦚"},
	{"yjr", "㪳"},
	{"yjrp", "㖍"},
	{"yjrr", "逭"},
	{"yjrrj", "䯬"},
	{"yjshj", "辧"},
	{"yju", "乵"},
	{"yjvfj", "辮"},
	{"yjvmj", "辫"},
	{"yjwj", "連"},
	{"yjye", "㪕"},
	{"yjyj", "幷"},
	{"yjyjj", "𣁾"},
	{"yjyjn", "甁"},
	{"yjykj", "辬"},
	{"yjyrj", "辯"},
	{"yjytj", "辡"},
	{"yk", "头 文 达"},
	{"ykanw", "斕"},
	{"ykb", "迶"},
	{"ykbuc", "䝺"},
	{"ykbuu", "斍"},
	{"ykc", "鐜"},
	{"ykcf", "遼"},
	{"ykdhe", "㿰"},
	{"ykdi", "対"},
	{"ykfd", "㪰"},
	{"ykg", "墪"},
	{"ykhaf", "鳼 鴍 鵁 鵺 鷟 鸆"},
	{"ykhbm", "斖"},
	{"ykhf", "逖"},
	{"ykhg", "逛"},
	{"ykhhh", "彣"},
	{"ykhq", "𣁄"},
	{"ykhsb", "斒"},
	{"yki", "迏"},
	{"ykiav", "斏"},
	{"ykjt", "逩"},
	{"ykks", "効"},
	{"yklii", "螡 䘇"},
	{"ykll", "齐"},
	{"yklll", "齑"},
	{"yklm", "斉"},
	{"yklmi", "蚉"},
	{"yklml", "斎"},
	{"ykln", "刘 㓺"},
	{"yklsw", "斓"},
	{"ykmb", "遀"},
	{"ykmbc", "頝"},
	{"ykmbl", "斋"},
	{"ykmpm", "斌"},
	{"ykmr", "䃦"},
	{"ykn", "㐎"},
	{"yknbk", "㪱"},
	{"yknd", "斈"},
	{"yknl", "郊"},
	{"ykok", "效"},
	{"ykp", "忞 憝"},
	{"ykpb", "遰"},
	{"ykpym", "䴔"},
	{"ykq", "撉 连 㪯"},
	{"ykr", "吝"},
	{"yks", "边"},
	{"yksj", "斊"},
	{"yksmm", "𦐑"},
	{"yksr", "迦"},
	{"ykvif", "紊"},
	{"ykymu", "齾"},
	{"ykypu", "虠"},
	{"yl", "迚"},
	{"ylb", "市"},
	{"yle", "逮"},
	{"ylhv", "衷"},
	{"yll", "亣"},
	{"ylln", "剂 剤"},
	{"yllv", "遱"},
	{"ylm", "止"},
	{"ylmc", "遺"},
	{"ylmh", "步 歩"},
	{"ylmo", "歨 逃 遗"},
	{"ylmr", "遣"},
	{"ylmv", "裵"},
	{"ylnc", "亦"},
	{"ylq", "䢖"},
	{"ylv", "㜪"},
	{"ylw", "迪"},
	{"ylwl", "迧"},
	{"ylyc", "䥆"},
	{"ym", "上 辷"},
	{"yma", "㫖"},
	{"ymb", "肯"},
	{"ymbb", "逦"},
	{"ymbo", "赟"},
	{"ymbuc", "贇"},
	{"ymbuu", "覰 覷"},
	{"ymbw", "䢮"},
	{"ymcu", "𥈠"},
	{"ymcw", "迺 逎"},
	{"ymd", "迂"},
	{"ymdhe", "皻 皽"},
	{"ymf", "尗 还"},
	{"ymfb", "邇"},
	{"ymg", "迋"},
	{"ymgc", "𨘀"},
	{"ymgdi", "歭"},
	{"ymhaf", "鸇"},
	{"ymhby", "歬"},
	{"ymhjg", "歱"},
	{"ymhqu", "氈"},
	{"ymhuk", "㱗"},
	{"ymhv", "衺"},
	{"ymi", "戱"},
	{"ymihf", "歳"},
	{"ymihh", "歲"},
	{"ymj", "迀"},
	{"ymje", "歧"},
	{"ymks", "勯"},
	{"yml", "䢋"},
	{"ymlb", "迊"},
	{"ymlk", "䢚"},
	{"ymlm", "䢝"},
	{"ymln", "剷 㔊"},
	{"ymmbc", "頉 顫"},
	{"ymmbo", "颤"},
	{"ymmi", "运"},
	{"ymmnr", "㱒"},
	{"ymmp", "悥 邐"},
	{"ymmr", "言 訁 逜"},
	{"ymms", "迃"},
	{"ymmu", "远 䢥"},
	{"ymni", "㱑"},
	{"ymnl", "䣜"},
	{"ymnn", "迾"},
	{"ymno", "欤 歔"},
	{"ymo", "仧"},
	{"ymog", "䧳"},
	{"ymoii", "㱓"},
	{"ymok", "䲣"},
	{"ymomg", "𣁦"},
	{"ymp", "忐 此"},
	{"ymphf", "䳄"},
	{"ympno", "㰣"},
	{"ympog", "雌"},
	{"ympym", "鹯"},
	{"ymqmc", "歵"},
	{"ymrk", "䢩"},
	{"ymrt", "逗"},
	{"ymrw", "逼"},
	{"yms", "迈"},
	{"ymsmb", "㱕"},
	{"ymso", "逐"},
	{"ymss", "歫"},
	{"ymt", "䢎"},
	{"ymufd", "歯"},
	{"ymuo", "齿"},
	{"ymuoo", "齒"},
	{"ymvh", "迓"},
	{"ymvm", "逕"},
	{"ymwu", "遷"},
	{"ymy", "卡"},
	{"ymye", "㪥"},
	{"ymymm", "歮"},
	{"ymyoj", "㱖"},
	{"ynbo", "赢"},
	{"ynbq", "邂"},
	{"ynd", "䢊"},
	{"yndf", "逊 遜"},
	{"ynf", "迩"},
	{"ynfd", "䊨"},
	{"ynhaf", "䲳"},
	{"ynhb", "遹"},
	{"ynhe", "﨤"},
	{"ynhs", "辸"},
	{"ynhv", "袤"},
	{"yni", "歺"},
	{"ynib", "通"},
	{"ynin", "迻"},
	{"ynir", "䢣"},
	{"yniv", "袲"},
	{"yniy", "迯"},
	{"ynj", "迅"},
	{"ynks", "劥"},
	{"ynlb", "䢫"},
	{"ynmbc", "頏"},
	{"ynmbo", "颃"},
	{"ynmvn", "㼚"},
	{"ynn", "辽"},
	{"ynnl", "邟"},
	{"ynno", "㰠"},
	{"ynom", "迳"},
	{"ynot", "邆"},
	{"ynqd", "椉"},
	{"ynui", "逸"},
	{"ynyt", "䇔"},
	{"yo", "込 龰"},
	{"yoam", "亱"},
	{"yobuc", "賌"},
	{"yodv", "褒"},
	{"yof", "㸂"},
	{"yog", "進"},
	{"yohne", "毅 㱾 𣫛"},
	{"yohwj", "颦"},
	{"yoir", "䢢"},
	{"yoj", "迕"},
	{"yokr", "㖱"},
	{"yoks", "劾 勮"},
	{"yolmi", "䗠"},
	{"yoln", "刻 劇"},
	{"yombc", "頦 顡"},
	{"yombo", "颏"},
	{"yomd", "途"},
	{"yomn", "逾"},
	{"yomr", "䢔"},
	{"yon", "迄"},
	{"yonk", "夜"},
	{"yonl", "郂"},
	{"yono", "欬"},
	{"yooj", "卒"},
	{"yop", "戆"},
	{"yopd", "迤"},
	{"you", "㐪"},
	{"yov", "嬜"},
	{"yp", "虍"},
	{"ypa", "迿 㫮"},
	{"ypbm", "虘"},
	{"ypbo", "赀"},
	{"ypbu", "眥"},
	{"ypbuc", "貲"},
	{"ypc", "鈭"},
	{"ypd", "柴 迆 㰍"},
	{"ypdb", "㭰"},
	{"ypg", "壟 㘹"},
	{"yphaf", "鴜 鷾 鸗"},
	{"yphen", "處"},
	{"yphfd", "虖"},
	{"yphne", "㲃"},
	{"yphu", "虎"},
	{"ypihr", "䖗"},
	{"ypks", "勴 虏"},
	{"yplb", "㠿"},
	{"yplmi", "蠪 䖪"},
	{"ypmd", "䖉"},
	{"ypmk", "龑"},
	{"ypmm", "些"},
	{"ypmmf", "祡 龒"},
	{"ypmr", "砦 礱"},
	{"ypmrb", "骿"},
	{"ypmrt", "䖒"},
	{"ypmso", "豦"},
	{"ypnbg", "觜"},
	{"ypni", "㱔"},
	{"ypnwf", "鮆"},
	{"ypobo", "胔"},
	{"ypog", "雐"},
	{"ypoiv", "飺"},
	{"ypok", "䖍"},
	{"ypom", "虗"},
	{"ypp", "虑 䖈"},
	{"ypph", "虙"},
	{"yppkk", "䖏"},
	{"ypq", "㧘"},
	{"ypr", "呰"},
	{"yprr", "啙"},
	{"yprvk", "虞"},
	{"ypsj", "聾"},
	{"ypsm", "虐"},
	{"ypsqf", "驡"},
	{"ypt", "衧 龏"},
	{"yptc", "虚 龔"},
	{"yptd", "䢡"},
	{"yptm", "虛"},
	{"yptmc", "虡"},
	{"ypu", "迍"},
	{"ypuv", "袌"},
	{"ypv", "姕"},
	{"ypvif", "紫"},
	{"ypwb", "膚"},
	{"ypwbt", "盧"},
	{"ypwks", "虜"},
	{"ypwlb", "歶"},
	{"ypwp", "慮"},
	{"ypybp", "龘"},
	{"ypyhv", "襲"},
	{"ypyk", "虔"},
	{"ypymr", "訾 讋"},
	{"yqhl", "逝"},
	{"yqiv", "亵"},
	{"yqmcw", "䤗"},
	{"yqod", "逰"},
	{"yqs", "违"},
	{"yr", "占"},
	{"yra", "亯"},
	{"yraa", "誯"},
	{"yrahm", "謃"},
	{"yram", "詚"},
	{"yramh", "諹"},
	{"yramj", "䛞"},
	{"yramo", "諟"},
	{"yrana", "𧬘"},
	{"yranb", "譋"},
	{"yranw", "讕"},
	{"yranx", "讇"},
	{"yrapp", "䛰"},
	{"yrapv", "謁"},
	{"yrav", "裛 詪"},
	{"yravf", "䜙"},
	{"yrawe", "謾"},
	{"yrb", "䚴"},
	{"yrbb", "膏 䯧"},
	{"yrbbe", "䛵"},
	{"yrbbn", "贏"},
	{"yrbbr", "諣"},
	{"yrbcd", "𧨾"},
	{"yrbd", "稁"},
	{"yrbgr", "調"},
	{"yrbhn", "鸁"},
	{"yrbhu", "觇"},
	{"yrbhx", "謟"},
	{"yrbjj", "諢"},
	{"yrbln", "蠃"},
	{"yrbm", "詛"},
	{"yrbme", "諼"},
	{"yrbmm", "䛁"},
	{"yrbmr", "詷"},
	{"yrbn", "亭 亴"},
	{"yrbo", "豪"},
	{"yrbou", "謠 謡"},
	{"yrbp", "亳"},
	{"yrbr", "詗 高"},
	{"yrbsd", "諍"},
	{"yrbsn", "驘"},
	{"yrbtn", "羸"},
	{"yrbtv", "誷"},
	{"yrbu", "亮 毫"},
	{"yrbuu", "覘 誢"},
	{"yrbvk", "謑"},
	{"yrbvn", "嬴"},
	{"yrbwn", "臝"},
	{"yrci", "訟"},
	{"yrcms", "䚷"},
	{"yrcmt", "諡"},
	{"yrcor", "䛦"},
	{"yrcru", "說 説"},
	{"yrcsh", "訜"},
	{"yrcwa", "譄"},
	{"yrdd", "諃"},
	{"yrdhe", "詖"},
	{"yrdi", "討"},
	{"yrdk", "訣"},
	{"yrdl", "誎"},
	{"yrdmq", "諱"},
	{"yrdoe", "䜉"},
	{"yrdoo", "誺"},
	{"yrdw", "諌"},
	{"yrdwf", "諫"},
	{"yre", "㕡"},
	{"yrea", "誻"},
	{"yreee", "諁"},
	{"yrei", "訍"},
	{"yrf", "京 点 䚱"},
	{"yrfb", "誚"},
	{"yrfbf", "讜"},
	{"yrfbg", "㙶"},
	{"yrfbw", "譡"},
	{"yrfd", "詸"},
	{"yrff", "談"},
	{"yrffs", "䜎"},
	{"yrfh", "訬"},
	{"yrfq", "詊"},
	{"yrfqr", "𧬸"},
	{"yrgbu", "読"},
	{"yrgcr", "讟"},
	{"yrgdi", "詩"},
	{"yrgg", "詿"},
	{"yrggu", "譊"},
	{"yrgi", "詓"},
	{"yrgni", "譸"},
	{"yrgp", "誌"},
	{"yrgr", "詰"},
	{"yrgrr", "譆"},
	{"yrgtj", "䛭"},
	{"yrgwc", "讀"},
	{"yrhab", "䛲"},
	{"yrhaf", "䳝"},
	{"yrhag", "諻"},
	{"yrhaj", "䜂"},
	{"yrhbk", "䜒"},
	{"yrhbu", "詯"},
	{"yrhd", "訸"},
	{"yrhdn", "誗 謻 䛢"},
	{"yrhds", "誘"},
	{"yrhdv", "諉"},
	{"yrhdw", "譒"},
	{"yrhe", "䛀"},
	{"yrhej", "𧧽"},
	{"yrher", "詻"},
	{"yrhg", "逞 䚾"},
	{"yrhge", "譭"},
	{"yrhgr", "誥"},
	{"yrhgu", "詵"},
	{"yrhhh", "㣌 䚲"},
	{"yrhhi", "謝"},
	{"yrhhj", "諀"},
	{"yrhjd", "誅"},
	{"yrhjg", "諥"},
	{"yrhjm", "諈"},
	{"yrhjr", "話"},
	{"yrhju", "䛻"},
	{"yrhjx", "䛽"},
	{"yrhk", "訞"},
	{"yrhkb", "譑"},
	{"yrhlc", "䜠"},
	{"yrhml", "訢"},
	{"yrhmr", "詬"},
	{"yrhmy", "訴"},
	{"yrhne", "設"},
	{"yrhni", "訉 諷"},
	{"yrhnr", "䛇"},
	{"yrhor", "譗"},
	{"yrhp", "託"},
	{"yrhpa", "諙"},
	{"yrhpm", "詆"},
	{"yrhpr", "䛡"},
	{"yrhqi", "誐"},
	{"yrhqo", "詄"},
	{"yrhqu", "䚽"},
	{"yrhs", "詐"},
	{"yrhsb", "諞"},
	{"yrhsk", "譤"},
	{"yrhsm", "謆"},
	{"yrht", "䛂"},
	{"yrhuc", "讚"},
	{"yrhui", "謉"},
	{"yrhv", "哀"},
	{"yrhwk", "䛜"},
	{"yrhwp", "謥"},
	{"yrhxe", "謏"},
	{"yrhxm", "䛼"},
	{"yrhxo", "諛"},
	{"yrhxu", "誽"},
	{"yrhyr", "䛮"},
	{"yrhyu", "謕"},
	{"yri", "战"},
	{"yriav", "誏"},
	{"yrice", "誜"},
	{"yrih", "䛋"},
	{"yrihr", "諴"},
	{"yrihs", "誠"},
	{"yrii", "諓"},
	{"yriih", "謲"},
	{"yrijb", "誧"},
	{"yrijc", "訹"},
	{"yrikf", "譌"},
	{"yrikk", "詙"},
	{"yriku", "訧"},
	{"yrill", "詶"},
	{"yrine", "詠"},
	{"yriok", "誒"},
	{"yrior", "諮"},
	{"yripm", "試"},
	{"yrir", "詒"},
	{"yrirp", "䜗"},
	{"yrit", "誡"},
	{"yritc", "譧"},
	{"yritf", "謶"},
	{"yriyr", "䛸"},
	{"yrj", "計"},
	{"yrjbc", "謓"},
	{"yrjbd", "誖"},
	{"yrjbj", "諵"},
	{"yrjbm", "誼"},
	{"yrjc", "䛎"},
	{"yrjcn", "䛪"},
	{"yrje", "䚳"},
	{"yrjhp", "詫"},
	{"yrjhw", "讅"},
	{"yrjim", "䜟"},
	{"yrjip", "譓"},
	{"yrjjb", "謿"},
	{"yrjka", "諸"},
	{"yrjkd", "誟"},
	{"yrjlo", "誱"},
	{"yrjmf", "誴"},
	{"yrjmm", "諠"},
	{"yrjmn", "詝"},
	{"yrjmo", "諚"},
	{"yrjmu", "𧨎"},
	{"yrjnu", "䛷"},
	{"yrjp", "詑"},
	{"yrjpn", "𧭈"},
	{"yrjqp", "䜢"},
	{"yrjr", "詁"},
	{"yrk", "奌"},
	{"yrkb", "詴"},
	{"yrkcf", "䜍"},
	{"yrkf", "詼"},
	{"yrkhg", "誑"},
	{"yrkja", "譇"},
	{"yrkk", "訤"},
	{"yrkkb", "誵 䛥"},
	{"yrklu", "䛳"},
	{"yrkmr", "䛴"},
	{"yrkms", "誇"},
	{"yrkn", "訅"},
	{"yrkni", "訙"},
	{"yrkoo", "䛟"},
	{"yrks", "勏"},
	{"yrl", "訲"},
	{"yrlbk", "詇"},
	{"yrlbu", "訦"},
	{"yrlll", "訓"},
	{"yrlln", "䛍"},
	{"yrlmc", "䜋"},
	{"yrlmo", "誂"},
	{"yrlmy", "誹"},
	{"yrln", "剖 㓠 䚯"},
	{"yrlp", "䛱"},
	{"yrlw", "䛆"},
	{"yrlwk", "䛕"},
	{"yrlwl", "訷"},
	{"yrlwp", "䛖"},
	{"yrlws", "䛣"},
	{"yrlwv", "謱"},
	{"yrm", "訌"},
	{"yrmbb", "譳"},
	{"yrmbc", "頕 䫓"},
	{"yrmbe", "䜡"},
	{"yrmbl", "䛔"},
	{"yrmbs", "謣"},
	{"yrmca", "𧪽"},
	{"yrmd", "訏"},
	{"yrmdm", "讈"},
	{"yrmfj", "評"},
	{"yrmgr", "讍"},
	{"yrmhf", "謜"},
	{"yrmhs", "𧨊"},
	{"yrmig", "誈"},
	{"yrmj", "訐"},
	{"yrmjj", "詽"},
	{"yrmjk", "譀"},
	{"yrmk", "䚶"},
	{"yrmlm", "䛩"},
	{"yrmmh", "𧧝"},
	{"yrmmp", "䜑"},
	{"yrmmr", "語"},
	{"yrmmu", "䛃"},
	{"yrmmv", "誫"},
	{"yrmn", "訂"},
	{"yrmnr", "訶"},
	{"yrmoo", "誣"},
	{"yrmrb", "䛿"},
	{"yrmrr", "謌"},
	{"yrmrt", "䛠"},
	{"yrmrw", "諨"},
	{"yrmso", "諑"},
	{"yrmsu", "𧦠"},
	{"yrmt", "訮"},
	{"yrmua", "譖"},
	{"yrmvh", "訝"},
	{"yrmvm", "誙"},
	{"yrmvn", "瑀"},
	{"yrmwc", "䜖"},
	{"yrmwf", "謤"},
	{"yrmwg", "諲"},
	{"yrmwj", "譚"},
	{"yrmym", "証"},
	{"yrn", "㐔"},
	{"yrnbe", "讂"},
	{"yrncr", "譫"},
	{"yrnd", "享"},
	{"yrndf", "𧪾"},
	{"yrnf", "烹"},
	{"yrng", "䚼"},
	{"yrngu", "䛝"},
	{"yrnhb", "譎"},
	{"yrnhe", "訯"},
	{"yrnhs", "䚮"},
	{"yrnhx", "諂"},
	{"yrnib", "誦"},
	{"yrnin", "誃"},
	{"yrnir", "詺"},
	{"yrniu", "䛄"},
	{"yrnj", "訊"},
	{"yrnkg", "誔"},
	{"yrnkm", "誕 𧩙"},
	{"yrnl", "訠 部"},
	{"yrnlb", "䜏"},
	{"yrnlp", "讔"},
	{"yrnmu", "詭"},
	{"yrnn", "亨"},
	{"yrno", "㰴 䚿"},
	{"yrnob", "諝"},
	{"yrnoe", "𧬋"},
	{"yrnot", "證"},
	{"yrnqd", "謋"},
	{"yrnri", "讒"},
	{"yrnuu", "䜛"},
	{"yrnyi", "誸"},
	{"yrob", "訥"},
	{"yrod", "䛙"},
	{"yrodi", "詂"},
	{"yrog", "誰"},
	{"yroge", "謢"},
	{"yrogf", "譙"},
	{"yrohg", "䛘"},
	{"yrohh", "診"},
	{"yroii", "詅"},
	{"yroim", "讖"},
	{"yroin", "訡"},
	{"yroip", "諗"},
	{"yroir", "誝 謒"},
	{"yroj", "許"},
	{"yrok", "敨 䚺 䛈"},
	{"yroll", "䚸"},
	{"yroma", "譮"},
	{"yromb", "論 讑"},
	{"yromg", "詮"},
	{"yromn", "諭"},
	{"yromo", "譣"},
	{"yromr", "詥"},
	{"yron", "訖"},
	{"yrop", "訛"},
	{"yrotf", "譕"},
	{"yrovu", "詤"},
	{"yrowy", "誨"},
	{"yroyr", "𧪄"},
	{"yrp", "訫 㤐 䚰"},
	{"yrpa", "詢 詣"},
	{"yrpd", "訑"},
	{"yrpfd", "諊"},
	{"yrph", "䛑"},
	{"yrphp", "𧩓"},
	{"yrpht", "謐"},
	{"yrpi", "訋"},
	{"yrpim", "𧥺"},
	{"yrpko", "譺"},
	{"yrpou", "䛬"},
	{"yrpp", "䚹"},
	{"yrppa", "諧"},
	{"yrpr", "訽"},
	{"yrpru", "䛌"},
	{"yrpt", "詍"},
	{"yrptd", "諜"},
	{"yrpu", "訰"},
	{"yrpuk", "詾"},
	{"yrpuu", "謅"},
	{"yrqd", "誄"},
	{"yrqjd", "䛶"},
	{"yrqjp", "譿"},
	{"yrqmb", "請"},
	{"yrqmc", "謮"},
	{"yrqmf", "䛾"},
	{"yrqmv", "諘"},
	{"yrqoa", "譛"},
	{"yrqoc", "讃"},
	{"yrqsk", "謸"},
	{"yrra", "㐯"},
	{"yrrau", "郶"},
	{"yrrc", "䛊"},
	{"yrrhu", "詋"},
	{"yrrp", "㖜"},
	{"yrrrd", "譟"},
	{"yrrrj", "譂"},
	{"yrrrk", "讝"},
	{"yrrrs", "諤"},
	{"yrrs", "遌"},
	{"yrrsj", "諿"},
	{"yrru", "遻 𨕬"},
	{"yrruc", "譔"},
	{"yrrv", "襄"},
	{"yrrvk", "誤"},
	{"yrrvp", "䛉"},
	{"yrrxu", "譝"},
	{"yrryo", "䛤"},
	{"yrseq", "䜄"},
	{"yrshi", "訒"},
	{"yrshr", "詔"},
	{"yrsim", "譅 䜀"},
	{"yrsip", "認"},
	{"yrsj", "誀"},
	{"yrsje", "諏"},
	{"yrsjj", "讘"},
	{"yrsjr", "䛯"},
	{"yrsma", "謵"},
	{"yrsme", "誛"},
	{"yrsmg", "誆"},
	{"yrsmh", "謬"},
	{"yrsmm", "詡"},
	{"yrsmr", "詞"},
	{"yrsmv", "䛫"},
	{"yrso", "訳"},
	{"yrsp", "䛏"},
	{"yrsrr", "謳"},
	{"yrss", "詎"},
	{"yrsu", "記"},
	{"yrsup", "誋"},
	{"yrsuu", "誳"},
	{"yrsyj", "謘"},
	{"yrta", "諎"},
	{"yrtak", "謨"},
	{"yrtam", "𧫴"},
	{"yrtav", "譪"},
	{"yrtbh", "謭"},
	{"yrtbm", "譾"},
	{"yrtca", "譜"},
	{"yrtct", "謚"},
	{"yrtgi", "議 譵 讛"},
	{"yrtgr", "𧬆"},
	{"yrtkr", "諾"},
	{"yrtlf", "讌"},
	{"yrtlj", "諽"},
	{"yrtlm", "謹"},
	{"yrtm", "詌"},
	{"yrtmc", "諆"},
	{"yrtmd", "謀"},
	{"yrtmj", "譁"},
	{"yrtmv", "諶"},
	{"yrtoe", "護"},
	{"yrtop", "誮"},
	{"yrtpd", "䜓"},
	{"yrtq", "詳"},
	{"yrtrg", "讙"},
	{"yrtrk", "䜘"},
	{"yrtt", "誁"},
	{"yrttb", "講"},
	{"yrttc", "諩"},
	{"yrtwa", "䜊"},
	{"yrtwb", "䜕"},
	{"yrtwi", "譐"},
	{"yrtwt", "𧬹"},
	{"yrtwv", "譨"},
	{"yrtxc", "謙"},
	{"yrtyb", "𧬺"},
	{"yrtyu", "謊"},
	{"yru", "乩 訕"},
	{"yruc", "選"},
	{"yrue", "詜"},
	{"yruk", "訩"},
	{"yrumb", "諯"},
	{"yruob", "讗"},
	{"yruog", "䜅"},
	{"yruu", "詘"},
	{"yrve", "詉"},
	{"yrvfd", "䛧"},
	{"yrvgk", "䜁"},
	{"yrvii", "譏"},
	{"yrvis", "詏"},
	{"yrvl", "訆"},
	{"yrvno", "䛹"},
	{"yrvvd", "䜈"},
	{"yrvvi", "䜝"},
	{"yrw", "畗"},
	{"yrwb", "謂"},
	{"yrwc", "訵"},
	{"yrwce", "謖"},
	{"yrwd", "課"},
	{"yrwjc", "謴"},
	{"yrwl", "䛅"},
	{"yrwlj", "譯"},
	{"yrwlv", "譞"},
	{"yrwol", "䛺"},
	{"yrwp", "諰"},
	{"yrwr", "䛛"},
	{"yrwww", "讄"},
	{"yry", "訃"},
	{"yrybb", "諦"},
	{"yrybk", "讞"},
	{"yrybs", "謗"},
	{"yrybu", "䜜"},
	{"yrycb", "謪 謫"},
	{"yryck", "詨"},
	{"yrycv", "譲 䜇"},
	{"yrydk", "譈"},
	{"yrye", "敁 遐 㪗"},
	{"yryfd", "謎"},
	{"yryfe", "諔"},
	{"yryg", "註"},
	{"yryhh", "諺"},
	{"yryhs", "訪"},
	{"yryia", "識"},
	{"yryj", "䚵"},
	{"yryjj", "謰"},
	{"yrykb", "䜔"},
	{"yrylc", "讉"},
	{"yrylm", "訨"},
	{"yrylr", "譴"},
	{"yrymp", "訿"},
	{"yrymr", "誩"},
	{"yryoj", "誶"},
	{"yrypd", "謼"},
	{"yrypm", "謔 謯 譃"},
	{"yrypu", "諕"},
	{"yryr", "詀"},
	{"yryrb", "謞"},
	{"yryrd", "諄"},
	{"yryrf", "諒"},
	{"yryrn", "諪"},
	{"yryro", "譹"},
	{"yryrr", "譶"},
	{"yryrv", "讓"},
	{"yrysd", "𧩹"},
	{"yryta", "諳"},
	{"yrytj", "辪 䛨"},
	{"yryto", "譢"},
	{"yrytp", "譩"},
	{"yryub", "謧"},
	{"yryvi", "詃"},
	{"yryvo", "該"},
	{"yrywf", "䜚"},
	{"yrywm", "譠"},
	{"yryx", "䜞"},
	{"yryyb", "讁"},
	{"ys", "卢 迉"},
	{"ysbuu", "覫"},
	{"ysdhe", "㿶"},
	{"ysfv", "褭"},
	{"ysg", "堃 𡑔"},
	{"ysh", "辺"},
	{"yshaf", "鴋"},
	{"yshdw", "旙"},
	{"yshr", "迢"},
	{"ysif", "旀"},
	{"yskmr", "旑"},
	{"yskrc", "䫯"},
	{"yslb", "髙"},
	{"ysm", "与"},
	{"ysmb", "䢜"},
	{"ysmbo", "颅"},
	{"ysmg", "䢰"},
	{"ysmh", "䢧"},
	{"ysmvn", "瓬"},
	{"ysnau", "䒍"},
	{"ysnkq", "旔"},
	{"ysnl", "邡"},
	{"ysnmu", "㫉"},
	{"yso", "迟 㫃"},
	{"ysob", "䐡"},
	{"ysobj", "㫎"},
	{"ysoby", "旃"},
	{"ysode", "旇"},
	{"ysof", "㫆"},
	{"ysofb", "旓"},
	{"ysogb", "㫋"},
	{"ysohc", "旟"},
	{"ysohl", "旂"},
	{"ysohm", "旌"},
	{"ysohn", "斻"},
	{"ysohu", "旄"},
	{"ysohv", "旅"},
	{"ysohw", "旛"},
	{"ysojb", "旆"},
	{"ysok", "放"},
	{"ysokr", "旖"},
	{"ysolb", "斾"},
	{"ysoll", "斺"},
	{"ysolo", "旐"},
	{"ysomf", "旚"},
	{"ysoml", "㫅"},
	{"ysomm", "㫌"},
	{"ysomn", "旊"},
	{"ysomr", "㫊"},
	{"ysomv", "㫏"},
	{"ysond", "斿"},
	{"ysono", "旋"},
	{"ysooa", "旝"},
	{"ysooi", "旍"},
	{"ysook", "族 㫍"},
	{"ysopd", "施"},
	{"ysosp", "旎"},
	{"ysotc", "旗"},
	{"ysoy", "於"},
	{"ysoym", "旜"},
	{"ysoyu", "旒"},
	{"ysp", "迡"},
	{"yspym", "鸬"},
	{"ysqf", "遤"},
	{"ysrj", "避"},
	{"ystmc", "𣄃"},
	{"ystq", "遅"},
	{"ysyhn", "𣃚"},
	{"ysyia", "旘"},
	{"ysyiu", "旈"},
	{"ysyj", "遟"},
	{"ysyoo", "旞"},
	{"ysyq", "遲"},
	{"yt", "立 𨑬"},
	{"yta", "暜 逪 音"},
	{"ytahu", "竟"},
	{"ytaj", "章"},
	{"ytap", "意"},
	{"ytapv", "竭"},
	{"ytbsd", "竫"},
	{"ytbuu", "覻"},
	{"ytcsh", "竕"},
	{"ytcw", "遒"},
	{"ytcwa", "竲"},
	{"ytd", "亲"},
	{"ytdl", "竦"},
	{"ytdq", "𨗨"},
	{"yteg", "䇈"},
	{"ytfb", "䇌"},
	{"ytfh", "竗"},
	{"ytggu", "𥪯"},
	{"ytgo", "䢭"},
	{"yth", "产"},
	{"ythaf", "鴗 鸕"},
	{"ythdl", "𥪕"},
	{"ythj", "竏"},
	{"ythlb", "竬"},
	{"ythn", "竌"},
	{"ythne", "竐"},
	{"ythni", "颯"},
	{"ythnk", "飒"},
	{"ythqu", "竓"},
	{"ytht", "竔"},
	{"ythu", "道"},
	{"ythwj", "䇑"},
	{"ythxh", "竧"},
	{"yti", "戲 䇅"},
	{"ytice", "竣"},
	{"ytid", "蒁"},
	{"ytii", "䇊"},
	{"ytiok", "竢"},
	{"ytj", "竍 辛"},
	{"ytjbm", "竩"},
	{"ytje", "攱"},
	{"ytjii", "竱"},
	{"ytjki", "竤"},
	{"ytjmn", "竚"},
	{"ytjr", "㖖"},
	{"ytk", "送"},
	{"ytki", "竑"},
	{"ytkr", "逽 𨔽"},
	{"ytks", "㔧"},
	{"ytl", "䇂"},
	{"ytle", "䇐"},
	{"ytma", "竡"},
	{"ytmbb", "䇕"},
	{"ytmbc", "顱"},
	{"ytmr", "䇉"},
	{"ytmrb", "竵"},
	{"ytmwg", "竰"},
	{"ytnin", "䇋"},
	{"ytnl", "𨚪"},
	{"ytno", "㱆"},
	{"ytnot", "竳"},
	{"ytnr", "竒"},
	{"ytog", "遳"},
	{"ytoii", "竛"},
	{"yton", "䇄"},
	{"ytpo", "豙 遂"},
	{"ytpr", "竘"},
	{"ytqmb", "靖"},
	{"ytr", "咅"},
	{"ytrhu", "竞"},
	{"ytru", "䇃"},
	{"ytrvp", "䇇"},
	{"ytryo", "䇍"},
	{"ytsmm", "翊"},
	{"ytstt", "竮"},
	{"ytt", "竎 进 迸"},
	{"ytta", "䇎"},
	{"yttb", "遘"},
	{"yttwi", "竴"},
	{"ytu", "逆"},
	{"ytub", "遡"},
	{"ytumb", "端"},
	{"ytv", "妾"},
	{"ytw", "䢗"},
	{"ytwa", "遭"},
	{"ytwb", "邁"},
	{"ytwg", "童"},
	{"ytwi", "遵"},
	{"ytwu", "竜"},
	{"ytyaj", "竨"},
	{"ytye", "㪭"},
	{"ytyj", "䇆"},
	{"ytyr", "站"},
	{"ytyrd", "䇏"},
	{"ytyrn", "𥪜"},
	{"ytyt", "竝"},
	{"ytytj", "𥪮"},
	{"yu", "辿"},
	{"yua", "䖑 䖜"},
	{"yuau", "䶕"},
	{"yuav", "齦 龈"},
	{"yubbb", "䶤"},
	{"yubcn", "䶡"},
	{"yubjj", "齳"},
	{"yubm", "齟 龃 䖕"},
	{"yubuc", "贙"},
	{"yubuu", "覤"},
	{"yuddf", "齽"},
	{"yuddo", "齼"},
	{"yudi", "導"},
	{"yue", "叡 𠮏"},
	{"yueg", "壡"},
	{"yuemi", "𤫀"},
	{"yuggu", "䶧"},
	{"yuhaf", "鷲"},
	{"yuhd", "䆃"},
	{"yuhgr", "䶜"},
	{"yuhhh", "彪"},
	{"yuhlb", "齲 龋"},
	{"yuhml", "齗 龂"},
	{"yuhne", "㲊"},
	{"yuhni", "䬌"},
	{"yuhrf", "䖚"},
	{"yuhs", "齚"},
	{"yuhsl", "齭"},
	{"yuhx", "齨"},
	{"yuhxu", "齯"},
	{"yuihr", "䶢"},
	{"yuii", "虥"},
	{"yuir", "齝"},
	{"yujbc", "齻"},
	{"yujbf", "䖛"},
	{"yujbm", "𪘲"},
	{"yujig", "䶪"},
	{"yuk", "㐫"},
	{"yukb", "离"},
	{"yukmr", "齮"},
	{"yukoo", "䶝"},
	{"yulmi", "䶚"},
	{"yuln", "䖌"},
	{"yulwp", "齥"},
	{"yumb", "遄"},
	{"yummr", "齬 龉"},
	{"yumnr", "䶗"},
	{"yumvh", "齖"},
	{"yunai", "䖘"},
	{"yunhx", "䶟"},
	{"yuo", "䖋"},
	{"yuoii", "齡 齢 龄"},
	{"yuoin", "䶖"},
	{"yuolf", "虪"},
	{"yuoll", "齘"},
	{"yuomo", "䶨"},
	{"yuomr", "𪘁"},
	{"yuon", "齕 龁"},
	{"yup", "齔 龀"},
	{"yupd", "䶔"},
	{"yuphh", "虝"},
	{"yupr", "齣"},
	{"yupru", "齙 龅"},
	{"yupt", "齛"},
	{"yupuu", "齺"},
	{"yupym", "鹫"},
	{"yuqmc", "䶦"},
	{"yur", "噵"},
	{"yurc", "齞"},
	{"yurp", "㘏"},
	{"yurrk", "䶫"},
	{"yurrs", "齶"},
	{"yuryo", "蹵 齪 龊"},
	{"yushr", "齠 龆"},
	{"yusje", "齱"},
	{"yusmg", "齷 龌"},
	{"yuss", "䶙"},
	{"yustr", "𪙛"},
	{"yuta", "齰"},
	{"yutct", "齸"},
	{"yutm", "瑎 甝"},
	{"yutmc", "䶞"},
	{"yutxc", "𪙊"},
	{"yuu", "齓"},
	{"yuumt", "䶣"},
	{"yuvml", "鼑"},
	{"yuwd", "齫"},
	{"yuwl", "䖖"},
	{"yuwlb", "齵"},
	{"yuyck", "齩"},
	{"yuye", "㪫"},
	{"yuyhh", "齴"},
	{"yuymp", "齜 龇"},
	{"yuypm", "䶥"},
	{"yuypu", "虤"},
	{"yuyt", "䶘"},
	{"yuytu", "競 竸"},
	{"yuyx", "䶩"},
	{"yv", "亡"},
	{"yvab", "朚"},
	{"yvb", "肓 膂"},
	{"yvbcr", "裔"},
	{"yvbq", "牽"},
	{"yvbu", "盲"},
	{"yvd", "杗"},
	{"yvgg", "壅"},
	{"yvgi", "㻾 䗸"},
	{"yvgn", "甕"},
	{"yvgu", "罋"},
	{"yvgv", "饔"},
	{"yvgw", "㽫"},
	{"yvhbt", "衁"},
	{"yvhg", "雍"},
	{"yvhlu", "巟"},
	{"yvho", "亥 𠀅"},
	{"yvhqu", "㲤"},
	{"yvhvo", "瓤"},
	{"yvi", "玄"},
	{"yviw", "畜"},
	{"yvks", "勷"},
	{"yvlb", "㠵"},
	{"yvlii", "蝱"},
	{"yvlmi", "䖟"},
	{"yvne", "逯"},
	{"yvnl", "邙"},
	{"yvobo", "膐"},
	{"yvp", "忘"},
	{"yvr", "吂"},
	{"yvrvp", "氓"},
	{"yvsl", "𠨑"},
	{"yvv", "妄"},
	{"yvvv", "巡 邋"},
	{"yw", "亩"},
	{"ywase", "䴝"},
	{"ywbuu", "䚃"},
	{"ywd", "㮚"},
	{"ywdv", "裹"},
	{"ywfb", "䴛"},
	{"ywgv", "裏"},
	{"ywhui", "䴜"},
	{"ywi", "畆"},
	{"ywihr", "鹹"},
	{"ywii", "鹵"},
	{"ywjc", "遦"},
	{"ywk", "卤"},
	{"ywkb", "禼"},
	{"ywkk", "卥"},
	{"ywlb", "遇"},
	{"ywle", "遝"},
	{"ywlg", "邏 𨗴"},
	{"ywln", "逻"},
	{"ywlv", "褱 還"},
	{"ywmmf", "禀"},
	{"ywmv", "衰"},
	{"ywni", "𠧧"},
	{"ywnl", "鄐"},
	{"ywno", "畝"},
	{"ywo", "畒"},
	{"ywoii", "鹷"},
	{"ywoin", "鹶"},
	{"ywomo", "鹸 鹼"},
	{"ywr", "迴 㐭 㔽"},
	{"ywrd", "稟"},
	{"ywrm", "亶"},
	{"yws", "卣"},
	{"ywsl", "逥"},
	{"ywsmg", "䴞"},
	{"ywtqm", "鹺 鹾"},
	{"ywtxc", "鹻"},
	{"ywyhn", "䴚"},
	{"yx", "齊"},
	{"yxbt", "齍"},
	{"yxbuc", "齎"},
	{"yxf", "齋 齌"},
	{"yxlmm", "韲 齏"},
	{"yxln", "劑"},
	{"yxv", "䶒"},
	{"yxyhv", "𪗋"},
	{"yy", "卞"},
	{"yyaj", "逴"},
	{"yybb", "遆"},
	{"yybc", "遉"},
	{"yycb", "適"},
	{"yyck", "䢒"},
	{"yyg", "迬"},
	{"yyhh", "遃"},
	{"yyhn", "迒"},
	{"yyhs", "䢍"},
	{"yyib", "逳"},
	{"yyij", "䢦"},
	{"yyj", "䢏"},
	{"yyjj", "逬"},
	{"yyk", "这"},
	{"yylc", "迹"},
	{"yymr", "這"},
	{"yyn", "乻 㫇"},
	{"yypo", "遽"},
	{"yyr", "迠 㫈"},
	{"yyrp", "旕"},
	{"yysd", "遊"},
	{"yysk", "䢟"},
	{"yytj", "遧"},
	{"yywm", "邅"},
	{"yywn", "𨔁"},
	{"yyws", "逌"},
	{"yyyhv", "𧜏"},
	{NIL_PTR}
};
