; DUALMON.ASM
;
; Created: 12-16.04.95 by Axel C. Frinke (ACFRINKE@UNI-BONN.DE)
; Improved:   05.05.95 (DUALMON returns ERROR on read accesses)
;
; Basing on two drivers written in 1990 by
;       Alan Barclay <ukpoit!alan@relay.EU.net>
;       this adress is obviously obsolete, so I could not contact Alan :-(
;
; this driver requires both VGA and Hercules monitor connected to the system
; after installation
; output send to file 'COLOR' will be displayed at the VGA monitor,
; output send to file 'MONO'  will be displayed at the Hercules monitor
;
; NO WARRANTIES, PARTICULARY WHEN USING DUALMON ON A COMPUTER WITH ONLY
; MONITOR CONNECTED!

; some conventions I often use in my programs

        Jmps    EQU     JMP SHORT
        DWO     EQU     DWORD PTR
        WO      EQU     WORD PTR
        BY      EQU     BYTE PTR

XPush MACRO RegList ; MACRO to Push several Registers
.XLIST
IRP RegName, <RegList>
.LIST
IFIDNI <Regname>,<FLAGS>      ; flag register to handle?
        PUSHF
ELSE
        PUSH    RegName
ENDIF
.XLIST
ENDM
.LIST
ENDM

XPop MACRO RegList ; MACRO to Pop several Registers
.XLIST
IRP RegName, <RegList>
.LIST
IFIDNI <Regname>,<FLAGS>      ; flag register to handle?
        POPF
ELSE
        POP     RegName
ENDIF
.XLIST
ENDM
.LIST
ENDM

  
        CR            EQU     0Dh
        LF            EQU     0Ah
        TAB           EQU     09H
        BS            EQU     08H

        Line2         EQU     WO [160]
        LastLine      EQU     WO [3840]
        EndOfScreen   EQU     4000
        ScrollSize    EQU     1920
        YellowSpace   EQU     720h

; the following equates work after a "LDS BX, DWO CS:RequestHeader" instruction
        RHDrvLen      EQU     BY [BX]      ; length of request header
        RHUnitCode    EQU     BY [BX+01h]  ; unit code; not used in K3PLUS
        RHComm        EQU     BY [BX+02h]  ; specified
        RHRespond     EQU     WO [BX+03h]  ; respond from driver
        RHReserved    EQU     BY [BX+05h]  ; reserved (what for?)
        RHRecChar     EQU     BY [BX+0Dh]  ;
        RHXferPTR     EQU    DWO [BX+0Eh]  ; pointer to transfer area
        RHBreakOffs   EQU     WO [BX+0Eh]  ;
        RHBreakSegm   EQU     WO [BX+10h]  ;
        RHXferCount   EQU     WO [BX+12h]  ; no. of chars/blocks to transfer
        RHCmdLine     EQU    DWO [BX+12h]  ; used for installation

        StateError    EQU      8000h       ; state bit for ERROR
        StateBusy     EQU      0200h       ; state bit for BUSY
        StateDone     EQU      0100h       ; state bit for DONE
        UnknownUnit   EQU       01h        ; code for UNKNOWN UNIT
        WriteFault    EQU       0Ah        ; code for WRITE FAULT
        ReadFault     EQU       0BAh       ; code for READ FAULT

        DualSeg         SEGMENT BYTE PUBLIC USE16
                        ASSUME  CS:DualSeg,  DS:Nothing, ES: Nothing
                        ORG     0
        MonHeader       DW      OFFSET ColHeader, 0FFFFH
        MonAttributes   DW      8800H
        MonPointers     DW      OFFSET Strategy
                        DW      OFFSET Installation
        MonChar_dev     DB      'MONO    '

Strategy        PROC    FAR                        ;
                MOV     CS:RequestHeader+2,  ES    ;
                MOV     CS:RequestHeader,  BX      ;
Strategy_:      RETF                               ;
Strategy        ENDP

        ColHeader       DW      0FFFFH, 0FFFFH
        ColAttributes   DW      8800H
        ColPointers     DW      OFFSET Strategy
                        DW      OFFSET ColrEntry
        ColChar_dev     DB      'COLOR   '

        ColorPart       LABEL BYTE
        WritePTR        LABEL DWORD
        WriteOffset     DW      0F00H               ;
                        DW      0B800H
        CRTPort         DW      03D4h
        CsrStart        DW      060Ah
        CsrEnd          DW      070Bh

        MonoPart        LABEL BYTE
                        DW      0F00H              ;
                        DW      0B000H
                        DW      03B4h
                        DW      0B0Ah
                        DW      0C0Bh

        RequestHeader   DW      0,  37A5H           ;

Commands        PROC    FAR
MonoEntry:      PUSH    BP
                MOV     BP, MonoPart-ColorPart
                Jmps    CommEntry

ColrEntry:      PUSH    BP
                MOV     BP, 0   ; keep flags alive

CommEntry:      XPush   <Flags, DS, ES, AX, BX, CX, DX, DI, SI>
                CLD
                LDS     BX, DWORD PTR CS:RequestHeader
                MOV     AL, RHComm
                CMP     AL, 13
                JE      OpenDevice
                CMP     AL, 9
                JA      DrvDone
                CMP     AL, 7
                JA      CON_OUT
                JE      DrvDone
                CMP     AL, 4
                JB      DrvDone

                MOV     RHXferCount, 0
                OR      RHRespond, StateError+ReadFault
                Jmps    DrvExit

OpenDevice :    MOV     DX, CS:[BP+CrtPort]     ; load address of CRT (6845) index register (EGA/VGA)
                MOV     AX, CS:[BP+CsrStart]    ; load "cursor size start"
                OUT     DX, AX                  ; set lower border of cursor
                MOV     AX, CS:[BP+CsrEnd]      ; load "cursor size end"
                OUT     DX, AX                  ; set upper border of cursor


DrvDone:        LDS     BX, DWO CS:RequestHeader
                OR      WO  RHRespond, StateBusy; set busy flag
DrvExit:        XPop    <SI, DI, DX, CX, BX, AX, ES, DS, Flags, BP>
                RETF                            ; Return far

CON_OUT:        LES     DI, CS:[BP+WritePTR]    ; get target address
                MOV     CX, RHXferCount         ; get counter for transfer
                LDS     SI, RHXferPTR           ; get pointer to DTA

StartTrnsfr:    LODSB                           ; get char to transfer
                CMP     AL, CR                  ; carriage return?
                JE      HandleCR                ; yes: jmp
                CMP     AL, LF                  ; line feed ?
                JE      DoScroll                ; yes: jmp
                CMP     AL, TAB                 ; TAB ?
                JE      HandleTAB               ; yes: jmp
                CMP     AL, BS                  ; backspace?
                JE      HandleBS                ; yes: jmp
                                                ; Handle normal char:
                STOSB                           ; store char
                INC     DI                      ; skip attribute
                CMP     DI, EndOfScreen         ; end of screen reached?
                JB      XFerred                 ; no: scrolling unnecessary

DoScroll:       XPush   <DS, SI, CX>            ; save registers used in DoScroll
                MOV     AX, ES                  ; copy ES...
                MOV     DS, AX                  ; ... to DS
                XOR     DI, DI                  ; target offset: zero
                MOV     SI, OFFSET Line2        ; source offset: line two
                MOV     CX, ScrollSize          ; get no. of chars to scroll
                REP     MOVSW                   ; perform scroll
                MOV     AX, YellowSpace         ; load char for empty line
                MOV     CX, 80                  ; get no. of chars per line
                REP     STOSW                   ; perform insert of new line
                XPop    <CX, SI, DS>            ; restore used registers
                Jmps    HandleCR

HandleBS:       CMP     DI, EndOfScreen         ; last line reached?
                JE      XFerred                 ; yes: done
                DEC     DI                      ; no: adjust target pointer
                DEC     DI
                Jmps    XFerred                 ; done

HandleTAB:      OR      DI, 0FH                 ; tab: round up
                INC     DI                      ; to next multiple of 16
                Jmps    XFerred                 ; done

HandleCR:       MOV     DI, OFFSET LastLine
XFerred:        LOOP    StartTrnsfr             ; go on transferring

                MOV     CS:[BP+WriteOffset], DI ; store target index
                MOV     DX, CS:[BP+CrtPort]     ; load address of CRT (6845) index register (EGA/VGA)
                SHR     DI, 1                   ; calc. target index to position
                MOV     AX, DI                  ; copy position to AX
                MOV     AL, 0Eh                 ; use "cursor position high"
                OUT     DX, AX                  ; set high position of cursor
                MOV     AX, DI                  ; copy position to AX
                MOV     AH, AL                  ; prepare
                MOV     AL, 0Fh                 ; use "cursor position low"
                OUT     DX, AX                  ; set low position of cursor
                JMP     DrvDone                 ; done
Commands     ENDP

                        ASSUME  CS:DualSeg,  DS:DualSeg
Installation:   MOV     CS:MonPointers+2, OFFSET MonoEntry
                MOV     CS:ColHeader+2, CS
                XPush   <AX, BX, DS, Flags>
                PUSH    CS
                POP     DS
                MOV     DX, OFFSET DualMsg
                MOV     AH, 09
                INT     21h
                        ASSUME  CS:DualSeg,  DS:Nothing
                LDS     BX, DWO RequestHeader
                MOV     RHBreakSegm, CS         ; store upper adress of driver
                MOV     RHBreakOffs, OFFSET Installation;
                OR      WO  RHRespond, StateBusy; set busy flag
                XPop    <Flags, DS, BX, AX>
                RETF                            ; Return far

DualMsg         DB      'DUALMON 1.0 installed (c) 1995 by Axel C. Frinke',13,10,36
DualSeg         ENDS

                END
