/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
** This program clears the screen and optionally sets the color.
**
** author: James Hall
** modifications: Marty Peritsky ("mmp")
**
*/

#include <stdio.h>
#include <bios.h>		/* mmp */
#include "freedos.h"
#include "getopt.c"

#define MONO 7			/* mmp */
#define CO80 3			/* mmp */

int ansi_mode, attr_only, attr_flag, cls_fgcolor, cls_bgcolor, cls_attr;

int ansi_forced = FALSE;	/* mmp */

char *ATTRS[] = 
{"normal", "bright", NULL, NULL, "underlined", "blinking", NULL, "reversed", "invisible"};

int b_mono_ats[] =
{  0x07,     0x0E,   0x07, 0x07,    0x01,         0x87,    0x07,    0x70, 0x00};
/* mmp - bios attributes for mono monitor, corresp. to ATTRS[] */ 

int b_attrs[] =
{  0x00,     0x08,   0x00, 0x00,    0x00,         0x80,    0x00,    0x00, 0x00};
/* mmp - bios mask bits for color monitor, corresp. to ATTRS[] */

char *COLORS[] = 
{"black", "red", "green", "yellow", "blue", "magenta", "cyan", "white"};

int b_colors[] =
{  0,       4,      2,       6,       1,        5,       3,       7   };
/* mmp - bios color values corresponding to COLORS[] */

void usage (void);

void cls (void);

void b_cls(void);		/* mmp */

int ansi_loaded(void);		/* mmp */

main (int argc, char **argv)

{
int i, j;

ansi_mode = TRUE;
attr_only = FALSE;
attr_flag = FALSE;
cls_attr = 0;
cls_fgcolor = 7;
cls_bgcolor = 0;

/* Scan the command line */
while ((i = getopt (argc, argv, "ABRS", NULL)) != EOF)
	{
	switch (i)
		{
		case 'A':
			ansi_mode = TRUE;
			ansi_forced = TRUE;	/* mmp */
			break;

		case 'B':
			ansi_mode = FALSE;
			break;

		/* We are only setting attributes */
		/* mmp - this switch is ignored if ansi.sys isn't
		   being used; bios doesn't save attributes */

		case 'S':
			attr_only = TRUE;
			break;

		case 'R':
			attr_flag = TRUE;
			break;

		/* Usage */
		default:
			usage ();
			break;
		}
	}

if ((argv[optind] == NULL) || (attr_flag == TRUE))
	cls ();

i = optind;

/* See if the first arg is an attribute */
if ( i < argc ) { /* mmp - bug fix */
for (j = 0; j < 10; j++)
	if ((strstr (ATTRS[j], argv[i]) == ATTRS[j]) && (ATTRS[j] != NULL))
		{
		cls_attr = j;
		attr_flag = TRUE;
		i++;
		break;
		};
} /* mmp - end if */

	/* See if current arg is a color */
if ( i < argc ) { /* mmp - bug fix */
for (j = 0; j < 9; j++)
	{
	if (strstr (COLORS[j], argv[i]) == COLORS[j])
		{
		cls_fgcolor = j;
		attr_flag = TRUE;
		break;
		}
	if (j == 8)
		usage ();
	}
} /* mmp - end if */

/* See if the next arg is a color and not NULL, skip "on" if found */
i++;
if ( i < argc ) { /* mmp - bug fix */
 if (argv[i] != NULL)
	for (j = 0; j < 9; j++)
		{
		if (!strcmp ("on", argv[i]))
			i++;
		if (strstr (COLORS[j], argv[i]) == COLORS[j])
			{
			cls_bgcolor = j;
			attr_flag = TRUE;
			break;
			}
		if (j == 8)
			usage ();
		}
} /* mmp - end if */

cls ();
}

void cls ()

{
if (ansi_mode)
	{
	/* begin mmp added code */
	/* do bios cls if ansi.sys not loaded */
	if ( attr_flag || (!attr_only) ) {
		if ( !ansi_loaded() ) {
			b_cls();
			if ( ansi_forced ) exit(2);
			else exit(0);
		}
	}
	/* end mmp added code */

	if (attr_flag)
		printf ("\033[%d;%d;%dm", cls_attr, 
			cls_fgcolor+30, cls_bgcolor+40);
	if (!attr_only)
		printf ("\033[2J");
	}
else
	b_cls();	/* mmp */

	exit (0);
}

/**** Print usage statement */
void usage(void)
{
    printp ("CLSX","Clears the video monitor and sets colors."); /* mmp */
    printc ("1996", "M. Toal, P. Mikalajunas, J. Hall et al."); /* mmp */
    printu ("CLSX", "[attribute] [color] [on] [color]"); /* mmp */
    printo ("A", "Force ANSI mode");
    printo ("B", "Force BIOS mode");
    printo ("R", "Restore screen to normal white on black");
    printo ("S", "Set attributes and colors only, do not clear screen.");
    fprintf (stderr, "       Attributes: Normal Bright Underlined Blinking Reversed Invisible\n");
    fprintf (stderr, "       Colors: Black Red Green Yellow Blue Magenta Cyan White\n");
    exit (1);
}

/* begin new functions added by mmp */

int ansi_loaded(void)
{
    int r, c;
    r = cursrow();
    c = curscol();

    /* Use ansi.sys to save, then restore the cursor position.
       If the driver isn't loaded, the cursor will have moved. */

    printf ("\033[s\033[u");     

    return (( r == cursrow() ) && ( c == curscol() ));
}

void b_cls(void)
{
    int b, v;

    /* if necessary, set to a clearable video mode */
    if ( (v = getvmode()) > MONO ) setvmode(v = CO80);

    if (!attr_flag) clrscrn();
    else {
        if ( v == MONO ) {
            clrscrn2( b_mono_ats[ cls_attr ] );
        }
        else {
            if ( cls_attr < 7 )
                b = ( b_colors[ cls_bgcolor ] << 4 )
                  + ( b_colors[ cls_fgcolor ] )
                  | ( b_attrs[ cls_attr ] );
            if ( cls_attr == 7 )
                b = 0x70; /* reverse */
            if ( cls_attr == 8 )
                b = 0x00; /* invisible */

            clrscrn2(b);
        }
    }
}

/* end new functions added by mmp */