;
; EMS system implemented by
;
; David Lindauer
;
; gclind01@ulkyvx.louisville.edu
;
; August, 1995 
;
; As part of the FREE-DOS project
;
;
; Rundown.asm
;
;   Function: Rundown the emu86 program and free its memory.
;
	.model small
absdat	segment	at 0
	org	2ch
envp	dw	?
	org 15h*4
i15o	dw	?
i15s	dw	?
absdat	ends
	.stack
	.data
msg	db	"emu86 not loaded yet",10,13,'$'
	.code
start:
	mov	ax,DGROUP
	mov	ds,ax
	in	al,84h		; Check for emu86 running
	cmp	al,0c4h
	jnz	exit		; Nope- get out
	mov	ax,0 		; Get segment 0 to ES
	mov	es,ax		;
	mov	ax,es:[i15s]	; Get prog segment from the int 15h hook
	sub	ax,10h		; Point at PSP
	mov	ds,ax		;
	mov	es,ds:[envp]    ; Read the environment seg
	mov	ah,49h		; Free it
	int	21h		;
	push	ds		; Get the prog segment
	pop	es   		; in ES
	mov	ah,49h		; Free it
	int	21h		;
	mov	al,2		; Command emu86 system to run down
	out	84h,al		;
	mov	al,0c4h		;
	out	85h,al		;
	jmp	$		; emu86 wasn't running if we get here...
exit:
	mov	ax,DGROUP
	mov	ds,ax
	mov	dx,offset msg	; Tell them it wasn't loaded
	mov	ah,9		;
	int	21h		;
	mov	ah,4ch		;
	int	21h
	end	start
	