   /* ---------- COPYSUBS.C - copy-related functions ------- */
/* 

   Copyright (c) 1996 M. M. Peritsky.  All rights reserved.
   This program is part of the Free-DOS Project.
   See COPY.TXT or XCOPY.TXT for more details.

*/
   /* ---------- include files ----------------------------- */

#include <stdio.h>
#include "copy.h"

   /* ---------- definition of symbolic constants ---------- */

#define BUF_SIZE 8192
#define BIN_SW 0
#define ASC_SW 1
#define TRUE 1
#define FALSE 0

   /* ---------- start of copy1 function ------------------- */

void copy1(char *file_in, int ab_in,
   char *file_out, int ab_out, int appnd, int z_switch)
{
   char buf[BUF_SIZE];   
   FILE *fpin;
   FILE *fpout;
   size_t n;
   size_t i;

   int asc_eof = FALSE;

   fpin = fopen(file_in, "rb");
   if (fpin == NULL) {
      printf("Unable to open %s\n", file_in);
      main_exit(1);
   }

   fpout = fopen(file_out, ( appnd ? "ab" : "wb" ));
   if (fpout == NULL) {
      printf("Unable to open %s\n", file_out);
      main_exit(1);
   }

   do {
      n = fread(buf, sizeof(char), BUF_SIZE, fpin);

      if (ab_in == ASC_SW) {
         for (i = 0; i < n; i++) {
            if (buf[i] == 0x1A) {
               asc_eof = TRUE;
               break;
            }
         }
         n = i;
      }

      if (z_switch) {
         for (i = 0; i < n; i++) {
            buf[i] = (buf[i] & 0x7F);         
         }
      }

      if ( n > 0 ) {
         if (fwrite(buf, sizeof(char), n, fpout) != n) {
            printf("Error writing %s\n", file_out);
            main_exit(1);
         }
      }

   }
   while ( !(( n == 0) || asc_eof || ((!ab_in) && ( n != BUF_SIZE ))) );

/* The "while" statement above tests for three possible eof indicators:
   first, n==0, which happens when copying from CON and the user presses
   ctrl-z; second, asc_eof, which happens when there is an embedded ctrl-z
   in a source file and /a is turned on for the source file; and third,
   a binary copy is being performed and less than a full buffer is read.
*/

   if (ab_out == ASC_SW) {
      buf[0] = 0x1A;
      if (fwrite(buf, sizeof(char), 1, fpout) != 1) {
            printf("Error writing %s\n", file_out);
            main_exit(1);
      }
   }

   if (fclose(fpin) != 0) {
            printf("Error closing %s\n", file_in);
            main_exit(1);
   }

   if (fclose(fpout) != 0) {
            printf("Error closing %s\n", file_out);
            main_exit(1);
   }

}

   /* ---------- end of copy1 function --------------------- */

