/* diskname.c - Constructs a disk name, for use in describing a
   portion of the install series. */

/* Copyright (C) 1997, James Hall <jhall1@isd.net> */

/* This is free software.  See the file COPYING for details. */


#include <stdio.h>
#include "fs.h"

#define STRLEN 256

char *
diskname (const char *path, const char *base, int n)
{
  /* Construct a name from the base name, and the number 'n' in the
     series. */

  static char ret[STRLEN];

  sprintf (ret, "%s%c%s.%d", path, FS_DIR_SEP, base, n);
  return (ret);
}
