/* $Id: getkey.c,v 1.5 1997/11/15 21:43:00 jhall Exp $ */

/* Copyright (C) 1997, James Hall, <jhall1@isd.net> */

/* This is free software.  See the file COPYING for details. */


#include <stdio.h>
#include <string.h>				/* for index() */
#include <ctype.h>				/* for toupper, tolower */

#if !defined (unix)
#  include <conio.h>				/* for building on DOS */
#endif

#include "cindex.h"


/* Retrieves the next key pressed (from the keyboard) */

int
getkey (void)
{
#if defined (unix) && !defined (linux)
  fpurge (stdin);				/* clears the input stream */
#endif /* Linux does not support fpurge */

#if defined (unix)
  return (fgetc (stdin));			/* simple hack for UNIX */
#else
  return (getche());				/* graceful fix for DOS */
#endif
}

/* Retrieves the next key.  Returns the key only when the key is found
   in a list. */

int
getkeyl (const char *list)
{
  int key;

  do {
    key = getkey ();
  } while (!cindex (list, key));

  return (key);
}

/* Retrieves the next key.  Returns the key only when the key is found
   in a list, without regard to case. */

int
getkeyli (const char *list)
{
  int key;

  do {
    key = getkey ();
  } while (!cindex (list, toupper(key)) && !cindex (list, tolower(key)));

  return (key);
}
