/*
 * *      ctrl_c.h *
 * 
 *      Author:  John Galvin *      Date:    25-Jul-1988 *      Purpose: trap
 * Ctrl-C and Ctrl-Break without printing anything. *
 * 
 *      Note: *          Use of these routines will prevent Ctrl-C and
 * Ctrl-Break *          from terminating your program.  They will also
 * prevent *          Ctrl-P, Ctrl-S, and Ctrl-Z from being interpreted by *
 * MS-DOS as they normally are.  Your program will be able *          to read
 * *all* of these characters, so if you don't want *          them in your
 * input stream, you will have to do something *          about them
 * yourself.  This code was written to work in *          all standard memory
 * models of the Microsoft C compiler *          version 5.1.  Do not use
 * getch() or getche() with these *          routines. *
 * 
 *      $Id: ctrl_c.h 1.1 88/07/25 22:04:48 galvin Exp $ *
 * 
 *      Copyright (c) 1988 by John W. Galvin.  All Rights Reserved. *
 * 
 *      Permission is hereby granted by the author for anyone to use this *
 * code in their own programs provided the following conditions are met: *
 * This copyright notice is left intact.  Any changes to this text/code *
 * must be commented and credited to the correct author somewhere *      in
 * this file. *
 * 
 *      $Log:   ctrl_c.h $ *      Revision 1.1  88/07/25  22:04:48  galvin *
 * Initial revision *
 * 
 *
 */

#ifndef __CTRL_C_H
#define __CTRL_C_H

#ifndef TRUE
#define TRUE     1
#endif

#ifndef FALSE
#define FALSE    0
#endif

#define INTERCEPT       0
#define RELEASE         1
#define GET             0x00
#define SET             0x01
#define CHKON           0x01
#define CHKOFF          0x00


extern int      ctrl_c(int op);
extern int      get_ctrl_c_chk(void);
extern int      set_ctrl_c_chk(int value);
extern int      rawio(int handle, int raw);
extern word     ioctl(int handle, int op, word value);

#endif
