/*
 * FD.C	version 1.0	by Darren Bane (c) 1995 All rights reserved.
 * 
 * Legal Stuff
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 675
 * Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#include <stdio.h>
#include <file.h>
#include <window.h>
#include <freedos.h>
#include "yerror.h"	// This line must come before ctrl_c.h so that word is
// declared
#include "ctrl_c.h"

#define DRVE			0x0001	/* Masks for isolating status bits */
#define DRV_MASK		0x00c0	/* Bits to mask off no of disk drives */
#define DRV_SHIFT	   0x06
#define PRN_SHIFT	   0x0E
#define EQUIPCK		 0x11	/* Check equipment function */
#define VIDEO		   0x0030	/* Mask to find initial video mode */
#define EGA			 0x0000	/* Determines EGA monitor fitted */
#define BW4025		  0x0010/* Determines if Black/White 40x25 */
#define BW8025		  0x0020/* Determines if Black/White 80x25 */
#define HERC			0x0030	/* Determines if Monochrome Hercules */
#define MAXPATH		 0x51	/* Maximum path length */
#define TRUE 1

/*
 * Default LONG number size is 4 bytes (32 bits). If you wish to change this
 * (up to 256 bits), edit the 'LSIZE EQU 4' in the LONGMATH.ASM file in the
 * library. You also have to adjust the sizes of all array declarations which
 * are to contain LONG numbers. For this demo, just adjust the constant
 * defined below.
 */

#define	LSIZE	4		/* 32 bit numbers */

/* Color index's for different window types */
#define	MENU	0
#define	TEXT	1
#define	PAUSE	2

void            cleanup(void);
void            long_to_string();
void            System_Information(void);
void            Disk_Information(void);
void            title();
void            pause(void);
word            biosmemory(void);
word            get_equip(void);
byte            test_drive(byte drive);

/*
 * This temporary variable used by the LONGMATH functions is useful, because
 * it will contain the remainder after a division.
 */
extern char     Longreg[];

char           *Main_Menu[] =
{
    NULL,
    NULL,
    NULL
};

/* Pointer to active color selections, and default values */
unsigned       *color, m_colors[] =
{REVERSE, REVERSE, NORMAL},	/* Monochrome defaults */
                c_colors[] =
{B_GREEN | F_RED, B_BLUE | F_RED | F_GREEN | F_BLUE, B_RED |
 F_GREEN};			/* Color defaults */

/* Pointer for access to title window */
struct WINDOW  *titlewin;

main(int argc, char *argv[])
{
    int             Option;

    msgInit();
    if (argc > 1)
	hlpScreen();
    ctrl_c(INTERCEPT);
    titlewin = wopen(0, 0, 80, 3, WBOX2 | WCOPEN | B_RED | F_RED | F_GREEN |
		     F_BLUE);
    color = (W_BASE == 0xB000) ? m_colors : c_colors;
    wopen(0, 3, 80, 22, WSAVE | WBOX1 | WCOPEN | B_GREEN | B_BLUE);
    wcursor_off();
    Main_Menu[0] = msgLock(M_sysinfo);
    msgUnlock(M_sysinfo);
    Main_Menu[1] = msgLock(M_diskinfo);
    msgUnlock(M_diskinfo);
    for (;;) {
	title(msgLock(M_title));
	msgUnlock(M_title);
	if (wmenu(10, 10, WCOPEN | WBOX2 | color[MENU],
		  Main_Menu, &Option))
	    break;
	switch (Option) {
	case 0:
	    System_Information();
	    break;
	case 1:
	    Disk_Information();
	}
    }
    title(msgLock(M_goodbye));
    msgUnlock(M_goodbye);
    wclose();
    wclose();
    wcursor_line();
    ctrl_c(RELEASE);
}				/* End of main() */

void 
System_Information(void)
{
    USEREGS
    struct WINDOW  *sys_info;
    int             hour, minute, second, day, month, year, OS_Version,
                    number, hdrives;
    word            equip;
    byte            i;

    title(msgLock(M_sysinfo));
    msgUnlock(M_sysinfo);
    sys_info = wopen(5, 4, 70, 16, WSAVE | WBOX2 | WCOPEN | color[TEXT]);

    /* Print time and todays date */

    get_time(&hour, &minute, &second);
    get_date(&day, &month, &year);
    wprintf(msgLock(M_time), hour, minute,
	    second, day, month, year);
    msgUnlock(M_time);

    /* Print version of MS-DOS */

    OS_Version = version();
    wprintf(msgLock(M_os), msgLock(M_msdos), OS_Version >> 8, OS_Version & 0x00FF);
    msgUnlock(M_os);
    msgUnlock(M_msdos);

    /* Get equipment status value */

    equip = get_equip();

    /* Find and print number of disk drives attached */

    number = ((equip & DRV_MASK) >> DRV_SHIFT) + 1;
    wprintf(msgLock(M_drives), (equip & DRVE) != DRVE ? 0 : number);
    msgUnlock(M_drives);

    /* Print number of printers attached */

    number = equip >> PRN_SHIFT;
    wprintf(msgLock(M_printers), "", number);
    msgUnlock(M_printers);

    /* Print number of comms cards attached */

    number = ((equip & 0x0e00) >> 9);
    wprintf(msgLock(M_comms), "", number);
    msgUnlock(M_comms);

    /* Print initial video mode */

    wprintf(msgLock(M_initvideo), "");
    msgUnlock(M_initvideo);
    switch (equip & VIDEO) {
    case HERC:
	wputs(msgLock(M_herc));
	msgUnlock(M_herc);
	break;
    case BW8025:
	wputs(msgLock(M_cga80));
	msgUnlock(M_cgac80);
	break;
    case BW4025:
	wputs(msgLock(M_cga40));
	msgUnlock(M_cgac40);
	break;
    case EGA:
	wputs(msgLock(M_ega));
	msgUnlock(M_ega);
    }
    wprintf(msgLock(M_currvideo), "");
    msgUnlock(M_currvideo);

    /* Find and print current video mode */

    _AX = 0x0F00;
    geninterrupt(0x10);
    switch (_AL) {
    case 0:
	wputs(msgLock(M_cga40));
	msgUnlock(M_cga40);
	break;
    case 1:
	wputs(msgLock(M_cga40c));
	msgUnlock(M_cga40c);
	break;
    case 2:
	wputs(msgLock(M_cga80));
	msgUnlock(M_cga80);
	break;
    case 3:
	wputs(msgLock(M_cga80c));
	msgUnlock(M_cga80c);
	break;
    case 4:
	wputs(msgLock(M_cga320));
	msgUnlock(M_cga320);
	break;
    case 5:
	wputs(msgLock(M_cga320c));
	msgUnlock(M_cga320c);
	break;
    case 6:
	wputs(msgLock(M_cga640));
	msgUnlock(M_cga640);
	break;
    default:
	wputs(msgLock(M_herc));
	msgUnlock(M_herc);
    }

    /* Print whether co-processor attached */

    wputs(msgLock(M_copro));
    msgUnlock(M_copro);
    if (((equip & 0x0002) >> 1) == 1) {
	wputs(msgLock(M_yes));
	msgUnlock(M_yes);
    } else {
	wputs(msgLock(M_no));
	msgUnlock(M_no);
    }

    /* Print whether game card installed */

    wprintf(msgLock(M_game), "");
    msgUnlock(M_game);
    number = ((equip & 0x1000) >> 12);
    switch (number) {
    case 0:
	wputs(msgLock(M_no));
	msgUnlock(M_no);
	break;
    case 1:
	wputs(msgLock(M_yes));
	msgUnlock(M_yes);
    }

    /* Print whether mouse is installed */

    wprintf(msgLock(M_mouse), "");
    _AX = 0x0000;
    geninterrupt(0x33);
    if (_AL == 0) {
	wputs(msgLock(M_no));
	msgUnlock(M_no);
    } else {
	wputs(msgLock(M_yes));
	msgUnlock(M_yes);
    }

    /* Print size of motherboard memory */

    wprintf(msgLock(M_mothermem), "", (((equip & 0x000c) >> 2) * 16) + 16);
    msgUnlock(M_mothermem);

    /* Print size of main memory */

    wprintf(msgLock(M_mainmem), "", biosmemory());
    msgUnlock(M_mainmem);

    /* Print location of program segment */

    wprintf(msgLock(M_psp), "", PSP);
    msgUnlock(M_psp);

    //Print the number of hard drives installed

	hdrives = 0;
	for (i = 0x80; i < 0x80 + 26; i++)
    	if (!test_drive(i))
			hdrives++;
    wprintf(msgLock(M_hdrives), "", hdrives);
    msgUnlock(M_hdrives);
    pause();
    wclose();
}

void 
Disk_Information(void)
{
    USEREGS
    int             done, number;
    struct FF_block ffblk;
    struct WINDOW  *disk_info;
    char            diskused[LSIZE], diskcap[LSIZE], diskfree[LSIZE], curdir[PATH_SIZE];

    title(msgLock(M_diskinfo));
    msgUnlock(M_diskinfo);
    disk_info = wopen(5, 6, 70, 11, WSAVE | WBOX2 | WCOPEN | color[TEXT]);

    /* Print current directory */

    getdir(curdir);
    wprintf(msgLock(M_curdir), "", curdir);
    msgUnlock(M_curdir);

    /* Print number of files in current directory */

    number = 0;
    done = findfirst("*.*", ffblk, 0);
    while (!done) {
	number++;
	done = findnext(ffblk);
    }
    wprintf(msgLock(M_nofiles), number);
    msgUnlock(M_nofiles);

    /* Find information about disk */

    _AX = 0x3600;
    _DX = 0x0000;
    geninterrupt(0x21);

    /* Print information about disk */

    wprintf(msgLock(M_maxclusters), "", _DX);
    msgUnlock(M_maxclusters);
    wprintf(msgLock(M_unusedclusters), "", _BX);
    msgUnlock(M_unusedclusters);
    wprintf(msgLock(M_sectorscluster), "", _AX);
    msgUnlock(M_sectorscluster);
    wprintf(msgLock(M_bytessector), "", _CX);
    msgUnlock(M_bytessector);

    /* Calculate information about disk */

    longset(diskused, _BX);	/* Temporarily store BX here */
    longset(diskcap, _CX);	/* And store CX here */
    longset(diskfree, _AX);	/* diskfree = AX */
    longmul(diskfree, diskcap);	/* diskfree *= CX */
    longcpy(diskcap, diskfree);	/* diskcap = AX * CX */
    longmul(diskfree, diskused);/* diskfree *= BX */
    longset(diskused, _DX);	/* Temporary storage for DX now */
    longmul(diskcap, diskused);	/* diskcap *= DX */
    longcpy(diskused, diskcap);	/* diskused = diskcap */
    longsub(diskused, diskfree);/* diskused -= diskfree */

    /* Print MAX disk capacity */

    long_to_string(curdir, diskcap, 10);
    wprintf(msgLock(M_maxcap), "", curdir);
    msgUnlock(M_maxcap);

    /* Print SPACE used */

    long_to_string(curdir, diskused, 10);
    wprintf(msgLock(M_used), "", curdir);
    msgUnlock(M_used);

    /* Print SPACE unused */

    long_to_string(curdir, diskfree, 10);
    wprintf(msgLock(M_free), "", curdir);
    msgUnlock(M_free);
    pause();
    wclose();
}

/*
 * biosmemory(void) Returns memory size
 */

word 
biosmemory(void)
{
    USEREGS

    geninterrupt(0x12);		/* Call memory interrupt */
    return _AX;			/* Get value from AX register */
}

word 
get_equip(void)
{
    USEREGS

    geninterrupt(0x11);		/* Get equipment */
    return _AX;
}

/*
 * Convert a LONG number into a printable string
 */
void 
long_to_string(unsigned char *string, unsigned char *n1, unsigned char base)
{
    unsigned        sp;
    unsigned char   c, stack[(LSIZE * 25) / 10 + 1];

    /*
     * Long number registers
     */

    char            temp1[LSIZE], temp2[LSIZE];

    longcpy(temp2, n1);
    longset(temp1, base);

    /* Stack up digits in reverse order */
    sp = 0;
    do {
	longdiv(temp2, temp1);
	stack[sp++] = ((c = *Longreg) > 9) ? c + '7' : c + '0';
    }
    while (longtst(temp2));

    /* Unstack digits into output buffer */
    do
	*string++ = stack[--sp];
    while (sp);
    *string = 0;
}

/*
 * Draw a title on the title window
 */
void 
title(char *string)
{
    w_clwin(titlewin);
    w_gotoxy((78 / 2) - (strlen(string) / 2), 0, titlewin);
    w_puts(string, titlewin);
}

/*
 * Pause for a key to be pressed
 */
void 
pause(void)
{
    wopen(40, 20, 37, 3, WSAVE | WBOX2 | WCOPEN | color[PAUSE]);
    wcursor_off();
    wgotoxy(5, 1);
    wputs(msgLock(M_press));
    msgUnlock(M_press);
    wgetc();
    wclose();
}

/*
 * Test for existance of a hard drive
 */

byte 
test_drive(byte drive) asm
{
	MOV        DL, 4[BP]        ; Get drive ID
	MOV        AH, 10h          ; Drive status function
	INT        13h              ; Ask BIOS
	MOV        AL, AH           ; Get value
	XOR        AH, AH           ; Zero high
}
