;
;     Free DOS Alternative Kernel;  FDBOOT v. 1.00 (06-27-95)
;
;     =           Kernel Heading Sector (Loader)            =
;
;     by Yury Semenov (yury@petre.odessa.ua, Fidonet#2:467/2)
;

INCLUDE		FDBOOT.INC
INCLUDE		FDFUNC.INC

BOOT SEGMENT AT 0
ASSUME CS:BOOT, DS:BOOT
        ORG 0
        jmp near ptr BEGIN

BootRecord BOOTR <"FDLOADER",512,1,1,2,224,2880,0f0h,9,18,2,0,0,0,29h,0,"Free DOS","FAT12">

BEGIN:  DB 2 DUP(0)
        ; Align to paragraph boundary :-(
        ; If this segment ends not just at paragraph boundary then VAL
        ; makes incorrect data relocation fixups

BOOT ENDS

HEAD		SEGMENT
	ASSUME	CS:HEAD,DS:BOOT
        	ORG	0
              	;jmp	START
                DB	0eah
                DW	DATAWIN + START, 0

 FileSys_FAT12	DB	"FAT12   "
 FileSys_FAT16	DB	"FAT16   "
 FAT12_Flag	DB	0
 REG_CLUST	DW	0fff0h
 FATSector	DW	-1
 HIPTR		LABEL	DWORD
 HIPTRlo	DW	0fffeh
 HIPTRhi	DW	0

 START:
; * Query for File System ID
                cmp	BootRecord.ExtBoot[LOADED],0
                jz	NoExt
                mov	si,offset BootRecord.FileSysID[LOADED]
                mov	di,offset FileSys_FAT16[DATAWIN]
                mov	cx,8
                cld
                push	si
                push	cx
                rep	cmpsb
                pop	cx
                pop	si
                jz	ID_16
                mov	di,offset FileSys_FAT12[DATAWIN]
                rep	cmpsb
                jz	ID_12
 NoExt:		cmp	BootRecord.TotSec[LOADED],20740
                ja	ID_16
	ASSUME	DS:HEAD
 ID_12:         mov	FAT12_Flag[DATAWIN],1
                and	byte ptr REG_CLUST[DATAWIN+1],0fh
        ASSUME	DS:BOOT
 ID_16:
; * Initializing pointers to upper conventional memory 64k segment
                int	12h
                sub	ax,40h
                jc	NoMem
                mov	cl,6
                shl	ax,cl
                cmp	ax,80h
                jae	MemOk
 NoMem:		int	19h
	ASSUME	DS:HEAD
 MemOk:         mov	HIPTRhi[DATAWIN],ax
	ASSUME	DS:BOOT
 		mov	bx,KernOfs
                mov	ax,[bx].F_cluster
; * Cluster Chain processing; AX - starting cluster
 Cont:
                push	ax
                mov	si,TransLS
                push	[si]                      ;-( Damned hacking burden
                mov	byte ptr [si], 0c3h       ; RETN
                call	TransCl                   ; *Now* TransCl returns
                pop	[si]                      ; logical sector in DX:AX
                mov	cl,BootRecord.ClustSz[LOADED]
                xor	ch,ch
 ClustLoop:     push	cx
                push	dx
                push	ax
                call	TransLS
                push	es
	ASSUME	DS:HEAD
                les	di,HIPTR[DATAWIN]
                std
                mov	ax,cx
                stosw
                mov	ax,dx
                stosw
                mov	HIPTRlo[DATAWIN],di
                xor	ax,ax
                stosw
	ASSUME	DS:BOOT
                pop	es

                pop	ax
                pop	dx
                add	ax,1
                adc	dx,0
                pop	cx
                loop	ClustLoop
                pop	ax
                call	GetFAT
	ASSUME	DS:HEAD
                cmp	ax,REG_CLUST[DATAWIN]
                jb	Cont

                mov	si,offset LOADER_BEG[DATAWIN]
                les	di,HIPTR[DATAWIN]
                mov	dx,es
                sub	di, 2 + LOADER_END - LOADER_BEG
                mov	ax,di
                and	ax,0fffeh
                mov	ss,dx
                mov	sp,ax
                push	es
                push	di
                mov	cx, LOADER_END - LOADER_BEG
                cld
                rep	movsb
                retf

	ASSUME	DS:BOOT

; * FAT processing procedures

GetFAT		PROC NEAR             ; AX - Cluster #
		cmp	FAT12_Flag[DATAWIN],0
                jz	Prep16
                push	ax
                shr	ax,1
                pop	ax
                pushf
                mov	cx,3
                mul	cx
                dec	cx
                div	cx
                xor	dx,dx
                jmp	OffsOk
 Prep16:        mov	cx,2
                mul	cx
 OffsOk:        div	BootRecord.SectSz[LOADED]
                call	GetFATPage
                mov	bx,dx
                cmp	bx,1ffh
                jnz	NoOverrun
                mov	cl,byte ptr [bx + DIRWIN]
                push	cx
                inc	ax
                call	GetFATPage
                pop	ax
                mov	ah,byte ptr ds:[DIRWIN]
 Norm12:        popf
 		jc	OddCluster
                and	ah,0fh
                ret
 OddCluster:    mov	cl,4
 		shr	ax,cl
                ret
 NoOverrun:     mov	ax,[bx + DIRWIN]
 		cmp	FAT12_Flag[DATAWIN],0
                jnz	Norm12
		ret
GetFAT		ENDP

GetFATPage	PROC NEAR             ; AX - FAT sector
		cmp	ax,FATSector[DATAWIN]
                jz	PageOk
                mov	FATSector[DATAWIN],ax
                push	ax
                push	dx
                mov	ax,word ptr BootRecord.Hidden[LOADED]
                mov	dx,word ptr BootRecord.Hidden[LOADED+2]
                add	ax,word ptr BootRecord.ResSec[LOADED]
                adc	dx,0
                add	ax,FATSector[DATAWIN]
                adc	dx,0
                call	TransLS
                mov	bx,DIRWIN
                call	ReadSector
                pop	dx
                pop	ax
 PageOk:	ret
GetFATPage	ENDP


LOADER_BEG:

INCLUDE		KRNLOAD.INC

LOADER_END:

COMMENT |
INCLUDE PREPBYTE.INC

printbyte PROC
                call	prepbyte
                push	ax
                mov	al,ah
                mov	ah,0eh
                int	10h
                pop	ax
                mov	ah,0eh
                int	10h
                ret
printbyte ENDP

printword PROC
                push	ax
                push	ax
                mov	al,ah
                call	printbyte
                pop	ax
                call	printbyte
                mov	ax,0e20h
                int	10h
                pop	ax
		ret
printword ENDP
        |

		ORG 511     ; Yet Another VAL bug :-(
		DB  0       ; ORG as last directive in source truncate dest.
                            ; file at N-th byte instead appending N zeros

HEAD		ENDS

	END 	START
