;
;     Free DOS Alternative Kernel;  FDBOOT v. 1.00 (06-27-95)
;
;     =        Upper Loader Procedure for DOS-C 0.90        =
;                    (Upper Loader Demo Example)
;     by Yury Semenov (yury@petre.odessa.ua, Fidonet#2:467/2)
;

  FIRST		EQU	1              ; 1 based number of starting sector
                                       ; of kernel (sector 0 - KRNLHEAD sector
                                       ; itself
  LAST		EQU	78h            ; Number of last sector to load
                                       ; (or number of sectors to load)
  STARTSEG	EQU	2000h          ; Kernel entry point
  STARTOFS	EQU	2Fh            ;-( Legal entry point is at 2000:0
                                       ; but code between 0..2f seems to me
                                       ; as incorrect
  LOADSEG	EQU	2000h          ; Kernel will be loaded here
  LOADOFS	EQU	0


		MOV	AX,LOADSEG
                MOV	ES,AX
                MOV	BX,LOADOFS
                PUSH	CS
		POP	DS
                MOV	SI,0FFFEH
                SUB	SI, FIRST * 4
                MOV	CX, LAST - FIRST + 1
LOADLOOP:       PUSH	CX
                STD
		LODSW
                MOV	CX,AX
                LODSW
                MOV	DX,AX
                MOV	AX,201H
		mov	bp,DRV_TRY
 DRVretry:
		push	ax
                INT	13H
                pop	ax
                JC	DRVreset
                ADD	BX,200H
                POP	CX
                LOOP	LOADLOOP
                MOV	DS,CX
                MOV	ES,CX
		MOV	BL,DL
		XOR	BH,BH
                CLI
                DB	0EAH           ; Far jump to Kernel Entry Point
                DW	STARTOFS
                DW	STARTSEG

DRVreset:	dec	bp
		jnz	DRVretry
ERROR:
		POP	CX
		CALL	ERRORMSG
		DB	"Boot Failed",13,10,0
		INT	19H

ERRORMSG	PROC NEAR
		POP	BX
 NEXTCH:	MOV	AL,CS:[BX]
                INC	BX
                OR	AL,AL
                JZ	WKEY
                MOV	AH,0EH
                INT	10H
                JMP	NEXTCH
 WKEY:		PUSH	BX
 		XOR	AH,AH
                INT	16H
                RET
ERRORMSG	ENDP
