;
;     Free DOS Alternative Kernel;  FDBOOT v. 1.00 (06-21-95)
;
;     =              Extended  Bootstrap                    =
;
;     by Yury Semenov (yury@petre.odessa.ua, Fidonet#2:467/2)
;

INCLUDE FDBOOT.INC

putch	MACRO ch
        mov	ax,0e00h OR ch
        call	int10
        ENDM

DELAY         EQU 30h

BootRecord    EQU 3

INCLUDE FDFUNC.INC

XBOOT SEGMENT
ASSUME CS:XBOOT
        int	19h      ; Somebody tries to load XBOOT.SYS as Kernel ;-)
	DB	"XB"     ; Extended Boot Signature
 START:                  ; XBoot entry point
	mov	bx,offset BootRecord.OEM[LOADED]
        mov	cx,8
        call	putn
        putc	' '
        mov	di,TIMER_LOW
        mov	ax,es:[di]
        add	ax,DELAY
 Wait3: test	byte ptr es:[di+SHIFT_STATUS-TIMER_LOW],0fh
 	jnz	SelKern
 	cmp	ax,es:[di]
        jae	Wait3            ; Waiting approximately 3 sec or any shift key
        call	MkBootMes
        mov	bx,DefaultKernel
        mov	cx,8
        call	putn
        putc	'.'
        mov	cx,3
        call	putn
        call	newline
        jmp	DefKernLoad      ; Nothing to do: starting default kernel

 SelKern:
        call	MkBootMes

        mov	di,DATAWIN       ; Preparing buffer for filename editor
        push	di
        mov	cx,11
        push	cx
        mov	al," "
        cld
        rep	stosb
        pop	cx
        pop	si
        inc	cx
        xor	bx,bx
; * Simple Filename Editor ;-)
;   Control keys: ESC,BS,ENTER,'.'
 gloop: xor	ah,ah
 	int	16h
        cmp	al,27
        jnz	not27
        call	newline
        jmp	START            ; ESC action: XBOOT restart

B_Sp:   or	bx,bx            ; BS  action: delete left char
	jz	gloop
        cmp	bl,8
        jnz	nodot1
        putc	8
 nodot1:push	bx
 	push	cx
        mov	bx,offset BkSp[XBOOTADDR]
        call	puts
        pop	cx
        pop	bx
        dec	bx
        inc	cx
        cmp	byte ptr [si+bx],' '
        mov	byte ptr [si+bx],' '
        jz	B_Sp
        jmp	gloop

ToExt:  cmp	cl,4             ; .   action: jump to extention
	jbe	gloop
        sub	cl,4
 xloop: putc	' '
 	loop	xloop
        mov	cl,5
        mov	bl,8
	jmp	mkdot

 not27: cmp	al,8
 	jz	B_Sp
        cmp	al,13
        jz	X_gl
        cmp	cl,1
        jz	gloop
        cmp	al,'.'
        jz	ToExt
        cmp	al,' '
        jbe	gloop
        cmp	al,127
        jae	gloop
        cmp	al,'a'
        jb	chok
        cmp	al,'z'
        ja	chok
        sub	al,20h
 chok:  mov	byte ptr [si+bx],al
 	inc	bx
        put_al
        cmp	bl,8
        jnz	nodot
 mkdot: putc	'.'
 nodot: loop	gloop
  X_gl:	call	newline          ; ENTER action: accept filename
        ; Now Kernel "FCB" in DS:SI
        mov	di,DefaultKernel
        mov	cx,11
        rep	movsb
        call	newline
        mov	word ptr ds:[XBOOTADDR+2],'bx'  ; Change "XB" to "xb" signature
        jmp	RESCAN

MkBootMes PROC NEAR
        mov	bx,offset BootMes[XBOOTADDR]
putavt	LABEL NEAR
	mov	cx,-1
putn    LABEL NEAR
	push	bp
 putn0:
        push	cx
	mov	al,[bx]
        or	al,al
        jz	putz
        inc	bx
        cmp	al,25
        jz	counter
	push	bx
        put_al
toloop:
        pop	bx
        pop	cx
        loop	putn0
        pop	bp
        ret
putz:	pop	cx
	pop	bp
	ret
counter:
	mov	ax,[bx]
        mov	cl,ah
        xor	ch,ch
        add	bx,2
        push	bx
 yloop:
        push	cx
        push	ax
        put_al
        pop	ax
        pop	cx
        loop	yloop
        jmp	short toloop
MkBootMes ENDP

newline PROC NEAR
        mov	bx,offset CRLF[XBOOTADDR]
        jmp	puts
newline ENDP

int10	PROC
	push	bp
        int	10h
        pop	bp
        ret
int10	ENDP

BootMes	 DB	"Boot: [",25," ",8,".   ]",25,8,13,0
BkSp	 DB 8,' ',8,0
CRLF     DB     13,10,0

XBOOT ENDS

	END START
