/*
    SWSUBST: Alternate CDS manipulator for MS-DOS
    Copyright (C) 1995 Steffen Kaiser

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/


/* $RCSfile: remove.c $
   $Locker: ska $	$Name: version3 $	$State: Rel $

	perform a "SUBST X: -"	(break SUBST/JOIN, relocate DPB)
	for either all SUBST'ed, or JOIN'ed  or all drives.

   $Log: remove.c $
   Revision 1.3  1995/06/30 11:54:24  ska
   sg

   Revision 1.2  1995/05/24 09:31:11  ska
   add: support for message compiler.

   Revision 1.1  1995/03/09 07:10:13  ska
   Initial revision

*/
#pragma hdrfile "simple.csm"

#include <string.h>

#include "swsubst.h"
#include "yerror.h"

#ifndef lint
static char rcsid[] = "$Id: remove.c 1.3 1995/06/30 11:54:24 ska Rel ska $";
#endif

void removeAll(int all)
/* all: == 0: process only SUBST'ed or JOIN'ed drives
        != 0: process all non-NETWORK'ed drives
*/
{	int dr;
    CDS FAR* dir;
    char buf[sizeof(dummyDrvA)];
	/* swsubst ? - for all SUBST'ed or JOIN'ed drives */

	strcpy(buf, dummyDrvA);
	for(dr = 0; dr < lastdrv; ++dr)
		if((dir = cds(dr)) == NULL) warning(E_cds, 'A' + dr);
		else if(all && (dir->flags & NETWORK) == 0 
		  || (dir->flags & (SUBST | JOIN))) {
			buf[0] = 'A' + dr;
			switchSubst(dr, buf, 0);
		}
}

