/*
*    RMDIR - Remove directories
*    Copyright  1995  Jim Lynch
*
*    This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* this program was developed with Turbo C 2.0. */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <errno.h>
#include <dir.h>
#include <dos.h>
#include "rmdir.h"
#include "freedos.h"
/* global variables */
extern int      optind, optchar;
extern          errno;
extern char    *optarg;
int             err = 0;
int             Loose = 0;

/* function prototypes */
void            usage(void);
int getopt (int argc, char *argv[], char *options, char *argoptions);

/* functions */
char           *
get_full_name(char *name)
{
    static char     patha[MAXPATH];
    char     path[MAXPATH];
    char     Dir[MAXDIR];
    char d;
    int             i, l;

    l = strlen(name);
    for(i=0;i<l;i++) {
        if(name[i]=='/')
	    path[i]='\\';
	else
	    path[i]=name[i];
    }
    path[i]='\0';
    strlwr(path);
    Dir[0]='\\';
    if(path[1]==':') {
       	d=path[0];
	getcurdir(d - 'a' + 1,Dir+1);
	memmove(path,path+2,l-1);
	l -= 2;
    }
    else {
	getcurdir(0,Dir+1);
	d=getdisk() +'a';
    }
    strlwr(Dir);
    patha[0]=d;
    patha[1]=':';
    if(path[0]=='\\') {
        strcpy(patha+2,path);
    }
    else {
        strcpy(patha+2,Dir);
	if(patha[strlen(patha)-1]!='\\') {
	    strcat(patha,"\\");
	}
	strcat(patha,path);
    }
    return patha;
}

char           *
get_path(char *name)
{
    static char     path[MAXPATH];
    int             i, l;

    l = strlen(name);
    strcpy(path, name);
    for (i = l - 1; i >= 0; i--) {
	if (path[i] == '\\' || path[i] == '/')	/* find last [back]slash */
	    break;
    }
    if (i == -1) {		/* no path, just a file name */
	if(name[1]==':') { /* path is just a drive name */
    		path[2] = '\0';
    		return path;
	}
	path[0] = '\0';
	return path;
    }
    path[i + 1] = '\0';
    return path;
}

int 
main(int argc, char **argv)
{
    char            cmd[MAXPATH];
    char            line[MAXPATH];
    char           *path;	/* path part of file name */
    int             nr = argc;
    int             l, i;
    int             st;
    int             nf=0;		/* number of directories removed */
    int             help = 0;
    int             first;
    int		    verbose=FALSE;
    struct ffblk    ffblk;


    nf = 0;
    while ((i = getopt(argc, argv, "hVH?", NULL)) != EOF) {
	switch (i) {
	case 'v':
	case 'V':
	    verbose = TRUE;
	    break;
	case 'h':
	case '?':
	case 'H':
	    help = TRUE;
	    break;
	default:
	    err++;
	}
    }
    if (err || help) {
	usage();
	exit(1);
    }
    /* nf has position of first file name in argv */
    /* argc has count of files */
    for (i = optind; i < argc; i++) {
	path = get_path(argv[i]);
	first = TRUE;
	nr=0;
	while (1) {
	    if (first) {
		st = findfirst(argv[i], &ffblk, 0xff);
		first = FALSE;
	    } else {
		st = findnext(&ffblk);
	    }
	    if (st == -1 ) {
		if (!nr && (errno != ENMFILE)) {
		    sprintf(cmd,"RMDIR %s",get_full_name(argv[i]));
		    perror(cmd);
		}
		break;
	    }
	    l=strlen(ffblk.ff_name);
	    if(ffblk.ff_name[l-1]=='.')
	        continue;
	    nr++;
	    strcpy(cmd, path);
	    strcat(cmd, ffblk.ff_name);
            strcpy(cmd,get_full_name(cmd));
	    if (!(ffblk.ff_attrib & FA_DIREC)) {
		fprintf(stderr, "RMDIR %s isn't a directory\n", cmd);
		fflush(stderr);
	    } else {
#ifdef DO
		st=rmdir(cmd);
#else
		st=0;
#endif
		if(st==-1) {
		    sprintf(line,"RMDIR %s",cmd);
		    perror(line);
		} else  {
		    if (verbose) {
		        printf("RMDIR %s\n", cmd);
		    }
		    nf++;
	        }
	    }
	}
    }
    if (!nf) {
	fprintf(stderr, "No directory files found\nRMDIR /h for help\n");
	exit(1);
    } else
    {
        if(verbose)
	    fprintf(stderr,"%d directories removed\n",nf);
    }
    return 0;
}

void 
usage()
{
    printp("RMDIR: V1.0 R0", "Remove directory");
    printu("RMDIR", "[/H] [/V] [/?] directory [directory ...]");
    printo("H", "Help");
    printo("?", "Help");
    printo("V", "Verbose");
}
