/*
* Structures used in FDISK
*/

#include <stdio.h>
#include <window.h>
#include <video.h>

#define 	UCHAR	unsigned char
#define		WORD	unsigned int
#define		UINT	unsigned int

#define		LSIZE	4	/* Size of a long int in bytes */

#define		NOTHING	{}	/* Do nothing routine */

#define		TRUE	1
#define		FALSE	0

#define		UNUSED	0	/* Unused partition */
#define		DOS12	1	/* DOS partition with 12-bit FAT */
#define		DOS16	4	/* DOS partition with 16-bit FAT */
#define		EXTEND	5	/* Extended partition table identifier */
#define		BIGDOS	6	/* DOS partition >32 Mb */

#define		ACTIVE		0x80	/* Active (bootable) partition value */
#define		INACTIVE	0		/* Inactive partition value */

#define		INVALID			0
#define		MAKE_BOOTABLE	1
#define		CHANGE_DRIVE	2
#define		CREATE			3
#define		DELETE			4
#define		UP				5
#define		DOWN			6

#define		SCR_WIDTH		80	/* Assume an 80x25 display size */
#define		SCR_HEIGHT		25

#define		WIN_COL			B_GREEN | B_BLUE	/* Default window colour */
#define		SEL_COL			B_GREEN | B_RED		/* Selected window colour */

/*
* Format of the drive parameters structure
* as returned by INT 13/AH=48
*/

struct drive_params
{
	WORD	size;				/* Size of buffer or amount of returned data */
	WORD	flags;				/* Information flags */
	char	cyls[LSIZE];		/* Number of cylinders */
	char	heads[LSIZE];		/* Number of heads */
	char	spt[LSIZE];			/* Number of sectors per track (cylinder) */
	char	tot_secs_h[LSIZE];	/* Total number of sectors on drive (high word) */
	char	tot_secs_l[LSIZE];	/* As above (low word) */
	WORD	bps;				/* Number of bytes per sector */
	char	params[LSIZE];		/* Configuration parameters */
};


/*
* Format of a partition table entry
*/

struct partable
{
	UCHAR	status;				/* partition status (0 = normal, 0x80 = active) */
	UCHAR	head_start;			/* Start head */
	WORD	cylsec_start;		/* Start cylinder & sector (combined) */
	UCHAR	type;				/* OS type */
	UCHAR	head_end;			/* End head */
	WORD	cylsec_end;			/* End cylinder & sector (combined) */
	char	offset[LSIZE];		/* Offset to start of boot sector */
	char	total_secs[LSIZE];	/* Total sectors in partition */
};


/*
* Format of the master boot record
*/

struct mbrec
{
	UCHAR			code[446];		/* Boot code */
	struct partable	table[4];		/* Master partition tables (1-4) */
	WORD			signature;		/* Should always be 55AA */
};


/*
* Drive map
* One of these per installed drive
*/

struct drive_map
{
	struct drive_params		dp;			/* Drive parameters */
	struct mbrec			**mbr;		/* Table of mbrs */
};

struct par_details
{
	UINT start_head,	/* Starting head */
		 start_cyl,		/* Starting cylinder */
		 start_sec,		/* Starting sector */
		 end_head,		/* End head */
		 end_cyl,		/* End cylinder */
		 end_sec,		/* End sector */
		 mbr_head,		/* Head containing MBR */
		 mbr_cyl,		/* Cylinder containing MBR */
		 mbr_sec;		/* Sector containing MBR */
};


/******************************************
* List of sectors that need to be cleared *
******************************************/

struct del_list
{
	UINT drive,				/* Location of sector */
		 head,
		 cyl,
		 sec;
	struct del_list *next;	/* Pointer to next entry */
};

/*
* Function declarations
* Sadly not ANSI compliant, but that appears to be another feature of Micro-C
*/

WORD tocylsec();
UINT cylsectosec();
UINT cylsectocyl();
int read_sector();
int do_read_sector();
int write_sector();
int get_drive_params();
get_drive_params();
int create_partition();
int set_active_partition();
int delete_partition();
int display_partition_info();
int change_drive();


int longprint();
int message_box();
