/*
 * cls.c
 *  The following code is distilled from SNIPPETS.
 *  The original modules in SNIPPEPTS are
 *  vidport.c   by Bob Stout
 *  scroll.c    by Bob Stout
 *  scrnmac.h   by Jerry Houston
 *
 *  SNIPPETS is a set of public domain source code.
 *  Many thanks to Bob Stout and all the programmers
 *  on the Fido International C Echo.
 *
 *  In keeping with the original dos cls command, there
 *  are no options available for cls.c
 *
 *  Just some short notes:
 *  This code relies on 2 factors
 *  1) That the C compiler has the int86 function available
 *  2) The video bios is at INT 10
 *
 *  Peter Mikalajunas 02/05/95
 */


#include <stdio.h>
#include <dos.h>

#if defined(__TURBOC__)
#define FAR far
#else
#define FAR _far
#endif

#ifndef MK_FP
#define MK_FP(seg,off) ((void far *)(((long)(seg) << 16)|(unsigned)(off)))
#endif

#define VIDPAGE    (*((unsigned char far *)0x0462))
#define SCREENCOLS (*(int FAR *)0x044A)
#define SCREENROWS ((*(char FAR *)0x0484)?1+(*(char FAR *)0x0484):25)
#define SCREENSEG  ((unsigned)((COLORMODE)?0xB800:0xB000))
#define COLORMODE  ((*(char FAR *)0x0449) != 7)

void GotoXY (int col, int row);
void ClrScrn (int vattrib);
void GetCurPos (int *col, int *row);
int GetCurAtr (void);
void scroll (int vattrib, int lrrow, int lrcolumn);
int main (void);

int main ()
{
   int vatr = GetCurAtr ();

   ClrScrn (vatr);
   GotoXY (0, 0);
   return 0;
}
void scroll (int vattrib, int lrrow, int lrcolumn)
{
   union REGS regs;

   regs.h.al = (unsigned char) 0x00;      /* number of lines */
   regs.h.bh = (unsigned char) vattrib;   /* attribute */
   regs.h.ch = (unsigned char) 0x00;      /* upper left row */
   regs.h.cl = (unsigned char) 0x00;      /* upper left col */
   regs.h.dh = (unsigned char) lrrow;     /* lower right row */
   regs.h.dl = (unsigned char) lrcolumn;  /* lower right col */
   regs.h.ah = 0x06;                      /* scroll up 0x07 for down */

   int86 (0x10, &regs, &regs);  /* call the video bios function */
}

void GotoXY (int col, int row)
{
   union REGS regs;

   setbuf (stdout, NULL);
   regs.h.dh = (unsigned) row;
   regs.h.dl = (unsigned) col;
   regs.h.bh = VIDPAGE;
   regs.h.ah = 0x02;        /* video bios function to position cursor */
   int86 (0x10, &regs, &regs);
}

void ClrScrn (int vattrib)
{
   scroll (vattrib, SCREENROWS, SCREENCOLS);
   GotoXY (0, 0);
}


int GetCurAtr (void)
{
   int row, col;
   unsigned short chat;

   GetCurPos (&col, &row);
   chat = *((unsigned FAR *) MK_FP (SCREENSEG,
				    (row * SCREENCOLS + col) << 1));
   return (chat >> 8);
}

void GetCurPos (int *col, int *row)
{
   union REGS regs;

 regs.h.ah = 0x03;   /* video bios function to get the current cursor pos */
 regs.h.bh = VIDPAGE;
 int86 (0x10, &regs, &regs);
 *row = regs.h.dh;
 *col = regs.h.dl;
}
