#include <stdio.h>
#include <stdlib.h>
#include <dir.h>
#include <direct.h>
#include <shextctl.h>

static char *Modes[]=
{
    "COMPATIBILITY",
    "EXCLUSIVE (DENY ALL)",
    "DENY WRITE",
    "DENY READ",
    "DENY NONE"
};

void GetInfo(void)
{
    unsigned char ReadOnly, ReadWrite;
    char     ExtService;
    char     LastDrive;
    char     i;
    char     LoVer, HiVer;
    int      CurDrive;

    asm {
        mov     al, 00h
        mov     ah, MuxNo
        int     2Fh
        cmp     ah, 0FFh
        je      Ver2
        mov     HiVer, 1
        mov     LoVer, 0
        jmp     All
    }
    Ver2:
    _asm {
        mov     HiVer, cl
        mov     LoVer, ch
    }
    All:
    _asm {
        mov     ReadOnly, bl
        mov     ReadWrite, bh
        mov     ExtService, dl
    }
    if (_AL!=0xFF)
    {
        printf("Error: SHARE extender does not respond.\n");
        exit(0);
    }
    printf("ESFSS Ver. %d.%d found.\n", HiVer, LoVer);
    if (HiVer==1)
        printf("ESFS support is %s\n\n"
               "Read-only files are to be opened in \"%s\" (%Xh) sharing mode\n"
               "Read-write files are to be opened in \"%s\" (%Xh) sharing mode\n\n",
               ExtService ? "ON" : "OFF",
               Modes[ReadOnly>>4], ReadOnly,
               Modes[ReadWrite>>4], ReadWrite);
    else
    {
        printf("Ŀ\n"
               " Drive    Read-only files      Read-write files  \n"
               "Ĵ\n");
        for (i=0, LastDrive=(char)setdisk(CurDrive=getdisk()); i<LastDrive; i++)
        {
            if (!_chdrive(i+1))
            {
                _asm {
                     mov    al, 6h
                     mov    ah, MuxNo
                     mov    bh, i
                     xor    bl, bl
                     int    2Fh
                     mov    ReadOnly, al
                     mov    ReadWrite, ah
                }
                printf("   %c:   %-20s %-20s\n", i+'A', Modes[ReadOnly>>4], Modes[ReadWrite>>4]);
            }
        }
        printf("\n\n"
               "ESFS support is %s\n\n", ExtService ? "ON" : "OFF");
        setdisk(CurDrive);
    }
}