#include <stdio.h>
#include <stdlib.h>
#include <shextctl.h>

void CurMux(char *Value)
{
    unsigned int NewMux;

    NewMux=(unsigned char)StrToNum(Value);
    if ((NewMux >= 0x80) && (NewMux <= 255))
        MuxNo=NewMux;
    else
        printf("Error: Invalid multiplex number: %s\n", Value);
}

void SetMux(char *Value)
{
    unsigned int NewMux;
    unsigned char ExtService;

    NewMux=(unsigned char)StrToNum(Value);
    if ((NewMux >= 0x80) && (NewMux <= 255))
    {
        asm {
            mov     al, 00h
            mov     ah, MuxNo
            int     2Fh
            mov     ExtService, dl
        }
        if (_AL!=0xFF)
        {
            printf("Error: SHARE extender does not respond.\n");
            exit(0);
        }
        asm {
            mov     ah, MuxNo
            mov     al, 1
            mov     bl, ExtService
            mov     cx, NewMux
            mov     ch, 0FFh
            int     2Fh
        }
        MuxNo=NewMux;
    }
    else
        printf("Error: Invalid multiplex number: %s\n", Value);

}