#include <stddef.h>
#include <shextctl.h>

extern void TurnON(void);
extern void TurnOFF(void);
extern void GetInfo(void);
extern void SetDrive(char *Drive);
extern void SetReadPat(char *Value);
extern void SetWritePat(char *Value);
extern void SetMux(char *Value);
extern void CurMux(char *Value);

CMD_OPTION Options[]=
{   {"/ON",     (void (*)(char *))TurnON,       NO_VAL  },
    {"/OFF",    (void (*)(char *))TurnOFF,      NO_VAL  },
    {"/I",      (void (*)(char *))GetInfo,      NO_VAL  },
    {"/DRIVE",  (void (*)(char *))SetDrive,     STRING  },
    {"/RPAT",   (void (*)(char *))SetReadPat,   NUMERIC },
    {"/WPAT",   (void (*)(char *))SetWritePat,  NUMERIC },
    {"/MUX",    (void (*)(char *))CurMux,       NUMERIC },
    {"/SETMUX", (void (*)(char *))SetMux,       NUMERIC },
    {"/?",      (void (*)(char *))Help,         NO_VAL  },
    {"/H",      (void (*)(char *))Help,         NO_VAL  },
    {NULL,      NULL,                           0       }
};

