#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <shextctl.h>

static char *StrModes[]=
{
    "COMPAT",
    "EXCLUSIVE",
    "DENYALL",
    "DENYWRITE",
    "DENYREAD",
    "DENYNONE",
    NULL
};

static unsigned char Modes[]={0x00, 0x10, 0x10, 0x20, 0x30, 0x40};

unsigned char TranslateMode(char *StrMode)
{
    int i;

    for (i=0; StrModes[i]; i++)
        if (!strcmp(StrMode, StrModes[i]))
            return Modes[i];
    return -1;
}

void SetReadPat(char *Value)
{
    asm {
        mov     al, 00h
        mov     ah, MuxNo
        int     2Fh
    }
    if (_AL!=0xFF)
    {
        printf("Error: SHARE extender does not respond.\n");
        exit(0);
    }
    if (Error)
        return;
    if ((ReadPattern=TranslateMode(Value))!=0xFF)
    {
        if (Drive==0xFF)
        {
            asm {
               mov      ah, MuxNo
               mov      al, 2
               mov      bl, ReadPattern
               int      2Fh
            }
            printf("Read-only files on all drives will be opened in %s mode.\n", Value);
        }
        else
        {
            asm {
               mov      ah, MuxNo
               mov      al, 4
               mov      bh, Drive
               mov      bl, ReadPattern
               int      2Fh
            }
            printf("Read-only files on drive %c: will be opened in %s mode.\n", Drive+'A', Value);
        }

    }
    else
        printf("Error: Invalid sharing mode: %s\n", Value);
}

void SetWritePat(char *Value)
{
    asm {
        mov     al, 00h
        mov     ah, MuxNo
        int     2Fh
    }
    if (_AL!=0xFF)
    {
        printf("Error: SHARE extender does not respond.\n");
        exit(0);
    }
    if (Error)
        return;
    if ((WritePattern=TranslateMode(Value))!=0xFF)
    {
        if (Drive==0xFF)
        {
            asm {
               mov      ah, MuxNo
               mov      al, 3
               mov      bl, WritePattern
               int      2Fh
            }
            printf("Read-write files on all drives will be opened in %s mode.\n", Value);
        }
        else
        {
            asm {
               mov      ah, MuxNo
               mov      al, 5
               mov      bh, Drive
               mov      bl, WritePattern
               int      2Fh
            }
            printf("Read-write files on drive %c: will be opened in %s mode.\n", Drive+'A', Value);
        }
    }
    else
        printf("Error: Invalid sharing mode: %s\n", Value);
}