#ifndef __SHEXTCTL_H
#define __SHEXTCTL_H

typedef struct
{
    char *Keyword;                      //  Keyword
    void (*KeywordProc)(char *Value);   //  Function that proceeds keyword (value starts exactly after keyword)
    char Flags;                         //  Flags
} CMD_OPTION;

#define NO_VAL      0   //  - just a key, no value
#define NUMERIC     1   //  - numeric value required
#define STRING      2   //  - string value required

#ifdef __cplusplus
extern "C" {
#endif

extern unsigned char MuxNo,
                     ReadPattern,
                     WritePattern,
                     Drive,
                     Error;

void ProcOption(char *Option, CMD_OPTION *OptList);
void Help(void);
void GetInfo(void);
void RemoveSpaces(char *Str);
unsigned short StrToNum(char *Value);

#ifdef __cplusplus
}
#endif

#endif