/*
*    MKDIR - Make directories
*    Copyright  1995  Jim Lynch
*
*    This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* this program was developed with Turbo C 2.0. */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <errno.h>
#include <dir.h>
#include <dos.h>
#include <sys/stat.h>
#include "freedos.h"
#include "rmdir.h"
/* global variables */
extern int      optind, optchar;
extern          errno;
extern char    *optarg;
int             err = 0;
int             Loose = 0;

/* function prototypes */
void            usage(void);
int getopt (int argc, char *argv[], char *options, char *argoptions);
int mkd(char *name, int MkAll);

/* functions */
char           *
get_full_name(char *name)
{
    static char     patha[MAXPATH];
    char            path[MAXPATH];
    char            Dir[MAXDIR];
    char            d;
    int             i, l;

    l = strlen(name);
    for (i = 0; i < l; i++) {
	if (name[i] == '/')
	    path[i] = '\\';
	else
	    path[i] = name[i];
    }
    path[i] = '\0';
    strlwr(path);
    Dir[0] = '\\';
    if (path[1] == ':') {
	d = path[0];
	getcurdir(d - 'a' + 1, Dir + 1);
	memmove(path, path + 2, l - 1);
	l -= 2;
    } else {
	getcurdir(0, Dir + 1);
	d = getdisk() + 'a';
    }
    strlwr(Dir);
    patha[0] = d;
    patha[1] = ':';
    if (path[0] == '\\') {
	strcpy(patha + 2, path);
    } else {
	strcpy(patha + 2, Dir);
	if (patha[strlen(patha) - 1] != '\\') {
	    strcat(patha, "\\");
	}
	strcat(patha, path);
    }
    return patha;
}

char           *
get_path(char *name)
{
    static char     path[MAXPATH];
    int             i, l;

    l = strlen(name);
    strcpy(path, name);
    for (i = l - 1; i >= 0; i--) {
	if (path[i] == '\\' || path[i] == '/')	/* find last [back]slash */
	    break;
    }
    if (i == -1) {		/* no path, just a file name */
	if (name[1] == ':') {	/* path is just a drive name */
	    path[2] = '\0';
	    return path;
	}
	path[0] = '\0';
	return path;
    }
    path[i + 1] = '\0';
    return path;
}

int
main(int argc, char **argv)
{
    char           *path;	/* path part of file name */
    int             i;
    int             help = 0;
    int             MkAll = FALSE;

    while ((i = getopt(argc, argv, "PH?", NULL)) != EOF) {
	switch (i) {
	case '?':
	case 'h':
	case 'H':
	    help = TRUE;
	    break;
	case 'P':
	case 'p':
	    MkAll = TRUE;
	    break;
	default:
	    err++;
	}
    }
    if (err || help) {
	usage();
	exit(1);
    }
    /* argc has count of files */
    for (i = optind; i < argc; i++) {
	path = get_full_name(argv[i]);
	mkd(path, MkAll);
    }
    return 0;
}

int
mkd(char *name, int MkAll)
{
    char           *path = get_full_name(name);
    char           *p;
    char            line[MAXPATH];
    int             st;
    struct stat     sb;

    strcpy(line, path);
    if (MkAll) {
	p = strchr(line, '\\');	/* find first */
	if (p)
	    p = strchr(p + 1, '\\');	/* find next */
	while (p) {
	    *p = '\0';
	    st = stat(line, &sb);
	    if (st == EOF) {
		/* this path might not exist, so lets try to make it */
		st = mkdir(line);
		fprintf(stderr, "mkdir %s\n", line);
		if (st == EOF) {
		    fprintf(stderr, "Didn't mkdir %s\n", line);
		    return;
		}
	    }
	    if (!(sb.st_mode && S_IFDIR)) {
		/* this file exists, but isn't a directory */
		fprintf(stderr, "%s isn't a directory\n", line);
		return;
	    }
	    strcpy(line, path);
	    p = strchr(p + 1, '\\');
	}
	st = stat(line, &sb);
	if (st == EOF) {
	    /* this path might not exist, so lets try to make it */
	    st = mkdir(line);
	    fprintf(stderr, "mkdir %s\n", line);
	    if (st == EOF) {
		fprintf(stderr, "Didn't mkdir %s\n", line);
		return;
	    }
	}
    } else {
	st = mkdir(line);
	fprintf(stderr, "mkdir %s\n", line);
	if (st == EOF) {
	    fprintf(stderr, "Didn't mkdir %s\n", line);
	    return;
	}
    }
    return;
}

void
usage()
{
    printp("MKDIR: V1.0 R0", "Make directory");
    printu("MKDIR", "[/P] [/H] [/?] directory [directory ...]");
    printo("P", "Make all elements of the path if necessary");
    printo("H", "Help");
    printo("?", "Help");
}
