/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

/**********************************************************************
 * This program displays a message to the screen and then wait for the
 * user to press a key before quitting.
 *
 * author: James Hall
 */

#include <stdio.h>
#include "getopt.h"
#include "freedos.h"


void usage (void);


main (int argc, char **argv)
{
  int i, iRtn;

  /* Scan the command line */

  while ((i = getopt (argc, argv, "rR?")) != EOF)
    {
      switch (i)
	{
	case 'r':
	case 'R':		/* Return the keypress */
	  iRtn = 1;
	  break;
	default:
	  usage ();
	}
    }

  /* Print the user's message, if any */

  if ((argc - optind) > 0)
    echov (argc, argv, optind, stderr);

  else
    fprintf (stderr, "Press any key to continue");

  /* Return the keypress */
  /* NOTE: The Beta release of 'pause' returned the keypress by A=1,
     Z=26.  I have changed that here.. it is now the ASCII code. */

  if (iRtn)
    exit (getkey ());

  else
    {
      getkey ();
      exit (0);
    }
}

void 
usage (void)
{
  printp ("PAUSE", "Displays a message and waits for the user to press a key");
  printu ("PAUSE", "[/R] [message..]");
  exit (1);
}
