;
; File:
;			   rdatclk.asm
; Description:
;		  read the AT style clock from bios
;
;			Copyright (c) 1995
;			Pasquale J. Villani
;			All Rights Reserved
;
; This file is part of DOS-C.
;
; DOS-C is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version
; 2, or (at your option) any later version.
;
; DOS-C is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
; the GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public
; License along with DOS-C; see the file COPYING.  If not,
; write to the Free Software Foundation, 675 Mass Ave,
; Cambridge, MA 02139, USA.
;
; $Logfile:   C:/dos-c/src/drivers/rdatclk.asv  $
;
; $Header:   C:/dos-c/src/drivers/rdatclk.asv   1.1   01 Sep 1995 18:50:40   patv  $
;
; $Log:   C:/dos-c/src/drivers/rdatclk.asv  $
;
;   Rev 1.1   01 Sep 1995 18:50:40   patv
;Initial GPL release.
;
;   Rev 1.0   02 Jul 1995  8:00:16   patv
;Initial revision.
;

		page	60,132
		title	read the AT style clock from bios

IFDEF ??version
_TEXT		segment	byte public 'CODE'
DGROUP		group	_DATA,_BSS,_BSSEND		; small model
		assume	cs:_TEXT,ds:DGROUP,ss:DGROUP
_TEXT		ends

_DATA		segment word public 'DATA'
_DATA		ends

_BSS		segment word public 'BSS'
_BSS		ends

_BSSEND		segment byte public 'STACK'
_BSSEND		ends

ELSE
_TEXT		segment	byte public 'CODE'
_TEXT		ends

_DATA		segment word public 'DATA'
_DATA		ends

CONST		segment word public 'CONST'
CONST		ends

_BSS		segment word public 'BSS'
_BSS		ends

_BSSEND		segment byte public 'STACK'
_BSSEND		ends

DGROUP		group	CONST,_DATA,_BSS,_BSSEND	; small/tiny model
		assume	ds:DGROUP, ss:DGROUP
ENDIF

;
;
		page	60,132
		title	ReadATClock - sysclock support

IFDEF ??version
_TEXT		segment	byte public 'CODE'
DGROUP		group	_DATA,_BSS,_BSSEND		; small model
		assume	cs:DGROUP,ds:DGROUP,ss:DGROUP
_TEXT		ends

_DATA		segment word public 'DATA'
_DATA		ends

_BSS		segment word public 'BSS'
_BSS		ends

_BSSEND		segment byte public 'STACK'
_BSSEND		ends

ELSE
_TEXT		segment	byte public 'CODE'
_TEXT		ends

_DATA		segment word public 'DATA'
_DATA		ends

CONST		segment word public 'CONST'
CONST		ends

_BSS		segment word public 'BSS'
_BSS		ends

_BSSEND		segment byte public 'STACK'
_BSSEND		ends

DGROUP		group	CONST,_DATA,_BSS,_BSSEND	; small/tiny model
		assume	ds:DGROUP, ss:DGROUP
ENDIF

_TEXT		segment	byte public 'CODE'
		assume	cs:_TEXT


;
;COUNT ReadATClock(bcdDays, bcdHours, bcdMinutes, bcdSeconds)
;BYTE *bcdDays;
;BYTE *bcdHours;
;BYTE *bcdMinutes;
;BYTE *bcdSeconds;
;
		PUBLIC	_ReadATClock
_ReadATClock	PROC NEAR
		push	bp
		mov	bp,sp
		sub	sp,10
;		Days = -6
;		Hours = -2
;		Minutes = -8
;		Seconds = -10
;		bcdSeconds = 10
;		bcdMinutes = 8
;		bcdHours = 6
;		bcdDays = 4
		mov	cx,-1
		mov	ah,2
		int	26
		cmp	cx,-1
		jne	$RdAT1140
		mov	ax,cx
		mov	sp,bp
		pop	bp
		ret	
		nop	
$RdAT1140:
		mov	BYTE PTR [bp-2],ch	;Hours
		mov	BYTE PTR [bp-8],cl	;Minutes
		mov	BYTE PTR [bp-10],dh	;Seconds
		mov	ah,4
		int	26
		mov	WORD PTR [bp-6],dx	;Days
		mov	WORD PTR [bp-4],cx
		mov	ax,WORD PTR [bp-6]	;Days
		mov	dx,WORD PTR [bp-4]
		mov	bx,WORD PTR [bp+4]	;bcdDays
		mov	WORD PTR [bx],ax
		mov	WORD PTR [bx+2],dx
		mov	al,BYTE PTR [bp-2]	;Hours
		mov	bx,WORD PTR [bp+6]	;bcdHours
		mov	BYTE PTR [bx],al
		mov	al,BYTE PTR [bp-8]	;Minutes
		mov	bx,WORD PTR [bp+8]	;bcdMinutes
		mov	BYTE PTR [bx],al
		mov	al,BYTE PTR [bp-10]	;Seconds
		mov	bx,WORD PTR [bp+10]	;bcdSeconds
		mov	BYTE PTR [bx],al
		sub	ax,ax
		mov	sp,bp
		pop	bp
		ret	
		nop	

_ReadATClock	ENDP
_TEXT		ENDS
		END
