/* movemail -- convert from Unix mailbox format to Freemacs RMAIL format. */

#include <stdio.h>
#include <stdlib.h>
#include <dir.h>
#include <stdarg.h>
#include <string.h>

char mailbox[64];

/* convenience function to make up a filename */
char *makefn(char *ext)
{
	static char fn[64];

	sprintf(fn, "%s.%s", mailbox, ext);
	return fn;
}

void error(char *format,...)
{
	va_list argptr;

	va_start(argptr, format);
	vfprintf(stderr, format, argptr);
	va_end(argptr);
	exit(1);
}


void exit1(void)
{
	/* now delete our lock file */
	rmdir(makefn("lck"));
}


main(int argc, char *argv[])
{
	int msgcount;
	struct ffblk ffblk;
	FILE *inf, *outf;

	if (argc < 2) error("usage: movemail mailbox");

	/* Prepare the mailbox name.  Strip off the extension so we have */
	/*   a known state.  Make sure that the extension is really the */
	/*   extension of the filename and not the extension of the subdir. */
	strcpy(mailbox, argv[1]);
	{ char *cp = strrchr(mailbox,'.');
		if (cp && !strchr(cp, '\\') && !strchr(cp, '/'))
			*cp = '\0';
	}

	/* Create our lock file.  Do a single retry after five seconds. */
	if (mkdir(makefn("lck")) < 0) {
		sleep(5);
		if (mkdir(makefn("lck")) < 0) error("movemail: lock file in use");
	}

	/* be sure to remove our lock file */
	atexit(exit1);

	/* find the highest existing file number */
	msgcount = 0;
	if (!findfirst(makefn("*"),&ffblk,0)) do {
		char *cp = strchr(ffblk.ff_name,'.');

		if (cp) {
			int i = atoi(cp+1);

			msgcount = max(msgcount, i);
		}
	} while (!findnext(&ffblk));

	/* open our mailbox */
	inf = fopen(makefn("txt"), "r");
	if (inf) {

		/* start with no output file */
		outf = NULL;

		/* for each message in the Unix mailbox, create an output file. */
		for (;;) {
			char inl[512];	/* our input buffer */
			char path[64];	/* our output file name */

			if (!fgets(inl, sizeof(inl), inf))
				break;
			if (!strncmp(inl, "From ", 5)) {
				if (outf && fclose(outf) < 0)
diskfull:
					error("movemail: disk full in file %s", path);
				sprintf(path, "%s.%03u", mailbox, ++msgcount);
				outf = fopen(path, "w");
				if (!outf)
					goto diskfull;
				continue;
			}
			if (fputs(inl, outf)<0)
				goto diskfull;
		}

		/* close the output file (if any) */
		if (outf && fclose(outf) < 0)
			goto diskfull;

		fclose(inf);
	}
	/* now set our mailbox to zero size */
	fclose(fopen(makefn("txt"), "w"));
}
