/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

/***********************************************************************
 * This program clears the screen and optionally sets the color.
 * Requires ANSI.SYS to be loaded.
 *
 * author: James Hall
 */


#include <stdio.h>
#include <string.h>
#include "getopt.h"
#include "freedos.h"

/* Define the colors */

#define BOLD 1
#define NORMAL 0
#define FOREGROUND 30
#define BACKGROUND 40
#define BLACK 0
#define WHITE 8


void usage (void);


main (int argc, char **argv)
{
  int i, iBold = NORMAL, iFore = WHITE, iBack = BLACK, iSet = FALSE;

  /* Scan the command line */

  while ((i = getopt (argc, argv, "sS?")) != EOF)
    {
      switch (i)
	{
	case 's':
	case 'S':
	  iSet = TRUE;
	  break;
	default:
	  usage ();
	  break;
	}
    }

  /* How many args are left? */

  i = optind;
  if ((argc - i) > 0)
    {

      /* Check if "bright" foreground */

      if (strcmpi (argv[i], "bright") == 0)
	{
	  iBold = BOLD;
	  i++;
	}

      /* Check the foreground */

      if (i >= argc)
	usage ();

      if ((iFore = color (argv[i++])) < 0)
	usage ();

      /* Skip an argument for the "on" */

      if (i >= argc)
	usage ();

      if (strcmpi (argv[i++], "on") != 0)
	usage ();

      /* Check the background */

      if (i >= argc)
	usage ();

      if ((iBack = color (argv[i])) < 0)
	usage ();

      /* Print the color string */

      printf ("\033[%d;%d;%dm", iBold, iFore + 30, iBack + 40);
    }

  /* Clear the screen */

  if (!iSet)
    printf ("\033[2J");

  exit (0);
}

void 
usage (void)
{
  printp ("CLS", "Clears the screen and optionally sets the color.");
  printu ("CLS", "[/S] [[BRIGHT] foreground ON background]");
  printo ("/S", "Only set the screen colors.. do not clear the screen.");
  exit (1);
}
