#include <string.h>

char *pColor[8] =
{"black", "red", "green", "yellow", "blue", "magenta", "cyan", "white"};

/************************************************************************
 * This function returns the index of the color contained in szColor,
 * as defined in pColor.  Returns -1 if not found.
 * maintainer: James Hall
 */

int 
color (const char *szColor)
{
  int i;

  /* Locate the color in the array if possible. */

  for (i = 0; i < 8; i++)
    if (strcmpi (szColor, pColor[i]) == 0)
      return (i);

  return (-1);
}
