#include <stdio.h>
#include "freedos.h"

/************************************************************************
 * This function paginates a file, displaying only a page at a time.
 * maintainer: James Hall
 */

unsigned long 
pagef (FILE * p, int iLines)
{
  unsigned long ul;
  char sz[MAX_STR];

  /* Read from the input stream and paginate the output. */

  for (ul = 0; fgets (sz, MAX_STR, p) != (char *) NULL; ul++)
    {
      if (ul == iLines)
	{
	  ul = 0;
	  puts (PAGEF_PR);
	  bioskey ();
	}

      printf ("%s", sz);
    }

  puts (PAGEF_END);
  bioskey ();

  return (ul);
}
