/*********************************************************************
 * This program reboots the computer, either a cold or warm boot.
 *
 * Much of the code was written by Mike O'Carroll,
 * lena!mike@relay.EU.net, and later adapted by James Hall for use in
 * Free-DOS.
 *
 * Since no copyright was placed on the original code, I am assuming
 * that this entire program is in the public domain.
 */

#include <stdio.h>
#include "getopt.h"
#include "freedos.h"

#define COLD 0			/* for cold restart */
#define WARM 0x1234		/* for warm restart */

#define BOOT_SEG        0xffffL
#define BOOT_OFF        0x0000L
#define BOOT_ADR        ((BOOT_SEG << 16) | BOOT_OFF)

#define DOS_SEG         0x0040L
#define RESET_FLAG      0x0072L
#define RESET_ADR       ((DOS_SEG << 16) | RESET_FLAG)


void usage (void);


main (int argc, char **argv)
{
  int c, magic = COLD;
  void ((far * fp) ()) = (void (far *) ()) BOOT_ADR;

  /* Scan the command line */

  while ((c = getopt (argc, argv, "cCwW?")) != EOF)
    {
      switch (c)
	{
	case 'c':
	case 'C':
	  magic = COLD;
	  break;

	case 'w':
	case 'W':
	  magic = WARM;
	  break;

	default:
	  usage ();
	  break;
	}
    }

  if (optind < argc)
    usage ();

  /* Reboot */

  *(int far *) RESET_ADR = magic;
  (*fp) ();

  /* Never gets here, but keeps compiler happy */

  exit (0);
}


void 
usage (void)
{
  printp ("REBOOT", "Reboots the computer.. either a cold or warm boot.");
  printu ("REBOOT", "[/W | /C]");
  printo ("/W", "Warm boot");
  printo ("/C", "Cold boot");
  exit (1);
}
