/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

/**************************************************************************
 * This program displays a text file or files.  The back-end sports several
 * options for the user.
 *
 * Author: James Hall
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "getopt.h"
#include "freedos.h"


void usage (void);


main (int argc, char **argv)
{
  int i, iNum = 0, iBlank = 0, iControl = 0, iEnds = 0, iTabs = 0, iUpc = 0,
    iDownc = 0;
  FILE *p;

  /* Scan the command line */

  while ((i = getopt (argc, argv, "nNsScCeEtTuUlLaA?")) != EOF)
    {
      switch (i)
	{
	case 'n':
	case 'N':		/* Number output lines */
	  iNum = 1;
	  break;
	case 's':
	case 'S':		/* Squeeze together non-blank lines */
	  iBlank = 1;
	  break;
	case 'c':
	case 'C':		/* Display control characters using the '^' */
	  iControl = iTabs = 1;
	  break;
	case 'e':
	case 'E':		/* Display end-of-lines using '$' */
	  iEnds = 1;
	  break;
	case 't':
	case 'T':		/* Display tabs using '^I' */
	  iTabs = 1;
	  break;
	case 'u':
	case 'U':		/* Convert the file to uppercase */
	  iUpc = 1;
	  iDownc = 0;
	  break;
	case 'l':
	case 'L':		/* Convert the file to lowercase */
	  iDownc = 1;
	  iUpc = 0;
	  break;
	case 'a':
	case 'A':		/* Show all */
	  iNum = iControl = iTabs = iEnds = 1;
	  break;
	default:
	  usage ();
	  break;
	}
    }

  /* Display the files */

  if ((argc - optind) < 1)
    fcat (stdin, iNum, iBlank, iControl, iEnds, iTabs,
	  iUpc, iDownc);

  for (i = optind; i < argc; i++)
    {
      if ((p = fopen (argv[i], "r")) != NULL)
	{
	  fcat (p, iNum, iBlank, iControl, iEnds, iTabs, iUpc, iDownc);
	  fclose (p);
	}

      else
	fprintf (stderr, "Cannot open file: %s\n", argv[i]);
    }

  exit (0);
}


void 
usage (void)
{
  printp ("TYPE", "Displays a text file or files");
  printu ("TYPE", "[/N] [/S] [/C] [/E] [/T] [/U] [/L] [/A] [file..]");
  printo ("/N", "Number the output, starting with 1");
  printo ("/S", "Squeeze together non-blank lines");
  printo ("/C", "Show control characters using \'^\'");
  printo ("/E", "Show the ends of lines using \'$\'");
  printo ("/T", "Show tabs using \'^I\'");
  printo ("/U", "Convert file to uppercase");
  printo ("/L", "Convert file to lowercase");
  printo ("/A", "Show everything (same as /N /C /E /T)");
  exit (1);
}
