/*
 *
 * DeleteBut(DelBut) Header File -- Defines, structures, etc.
 * Copyright (C) 1998 Robert Lake
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * 
 * Robert Lake can be contacted at
 * email: rlake@cs.mun.ca
 *
 */

#if !defined(__DELBUT_H)
#define __DELBUT_H

#include <dos.h>
#include <dir.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <io.h>

#define DB_VERSION      "DeleteBut v1.2b"
#define DB_AUTHOR       "Rob Lake (rlake@cs.mun.ca)"

#define ERROR           (-1)    /* Error has occured            */
#define SETATTRIB       1       /* Used in _chmod to set attrib */
#define GETATTRIB       0       /* Used in _chmod to get attrib */
#define NORMAL          0x00    /* Normal attribute flag        */
#define RDONLY          0x01    /* Read only attribute flag     */
#define HIDDEN          0x02    /* Hidden file flag             */
#define SYSTEM          0x04    /* System flag                  */
#define VOL             0x08    /* Volume label flag            */
#define SUBDIR          0x10    /* Subdirectory flag            */
#define ARCHIVE         0x20    /* Archive flag                 */

#define FLG_ERR		0x01
#define FLG_QUIET	0x02
#define	FLG_ALL		0x04

typedef struct nodellist {
    char *file;
    struct nodellist *another_list;
} NoDeleteList;

typedef struct deletebut {
    int flags;
    char drive[MAXDRIVE], subdir[MAXPATH], path[MAXPATH];
    NoDeleteList *List, *Start, *Last;
} DB;

typedef DB DeleteBut;

#endif
