/*
 *  DATE.C - date internal command
 *
 *  Comments:
 *
 *  08 Jul 1998 (John P. Price)
 *    started.
 *
 *  20 Jul 1998 (John P. Price)
 *  - corrected number of days for December from 30 to 31.
 *    (Thanx to Steffen Kaiser for bug report)
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 * 29-Jul-1998 (Rob Lake)
 * - fixed stand-alone mode.  Added Pacific C compatible dos_getdate functions
 *
 */

#include "config.h"

#ifdef INCLUDE_CMD_DATE

#include <stdio.h>
#include <dos.h>
#include <ctype.h>
#include <string.h>

#include "command.h"
#include "datefunc.h"

static unsigned char months[2][13] =
{
  {0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},
  {0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}
};

#ifdef DEBUG_STANDALONE
const char *day_strings[] = {
        "Sun", "Mon", "Tues", "Wed", "Thur", "Fri", "Sat"
        };

#else
extern const char *day_strings[];
#endif

int parsedate(char *s)
{
  struct dosdate_t d;
  unsigned char leap;

  if (!*s)
    return 1;

  d.year = 0;
  d.day = 0;
  d.month = 0;

  // first get mon
  if (isdigit(*s))
  {
    while (isdigit(*s))
      d.month = d.month * 10 + (*s++) - '0';
  }
  else
    return 0;

  // get divider
  if (*s == '/' || *s == '-')
    s++;
  else
    return 0;

  // now get day
  if (isdigit(*s))
  {
    while (isdigit(*s))
      d.day = d.day * 10 + (*s++) - '0';
  }
  else
    return 0;

  // get divider
  if (*s == '/' || *s == '-')
    s++;
  else
    return 0;

  // now get year
  if (isdigit(*s))
  {
    while (isdigit(*s))
      d.year = d.year * 10 + (*s++) - '0';
  }
  else
    return 0;

  //if only entered two digits, assume 1900's
  if (d.year <= 99)
    d.year = 1900 + d.year;

  leap = (!(d.year % 4) && (d.year % 100)) || !(d.year % 400);

  if ((d.month >= 1 && d.month <= 12) &&
      (d.day >= 1 && d.day <= months[leap][d.month]) &&
      (d.year >= 1980 && d.year <= 2099))
  {
    _dos_setdate(&d);
    return 1;
  }

  return 0;
}

#pragma argsused
int
cmd_date(char *first, char *rest)
{
  char s[40];

  if (strcmp(rest, "/?") == 0)
  {
    puts(
          "Displays or sets the date.\n\n"
          "DATE [date]\n\n"
    "Type DATE without parameters to display the current date setting and\n"
          "a prompt for a new one.  Press ENTER to keep the same date."
        );
    return 0;
  }

  if (!*rest)
  {
    struct dosdate_t d;

    _dos_getdate(&d);

    printf("Current date is %s %02d-%02d-%d\n",
           day_strings[d.dayofweek], d.month, d.day, d.year);
  }

  while (1)                     //forever loop

  {
    if (!*rest)
    {
      printf("Enter new date (mm-dd-yy): ");
      fgets(s, sizeof(s), stdin);
      while (*s && s[strlen(s) - 1] < ' ')
        s[strlen(s) - 1] = '\0';
      if (parsedate(s))
        return 0;
    }
    else
    {
      if (parsedate(rest))
        return 0;
      // force input the next time around.
      *rest = '\0';
    }
    puts("Invalid date.");
  }
}
#endif

#ifdef DEBUG_STANDALONE
int main(void)
{
        cmd_date("date", "");
        return 1;
}
#endif
