/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: READDIR.C $
   $Locker:  $	$Name:  $	$State: Exp $

	struct dirent *readdir(DIR *dirp)

	Return the next entry of the directory.
	The return value is a pointer into DIR*, any useage of DIR* might
	cause a change of the values of the dirent* structure.

	The only portable member of dirent is: d_name.

	Input:
		dirp != NULL, must be a pointer returned by opendir()

	Return:
		NULL: on failure
		else: on success

	Note:
		dirent is the same structure as ffblk, except that the member
		ff_name is named d_name.

	Conforms to:
		POSIX

	See also:
		opendir

	Target compilers:
		Any C compiler

	Origin:
		Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.1  1997/10/27 05:43:49  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <dirent.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: READDIR.C 1.1 1997/10/27 05:43:49 ska Exp $";
#endif

_CLibFunc struct dirent *
readdir(DIR * const dirp)
{	
	if(dirp->dd_stat)					/* error or at end of directory */
		return NULL;

	if(!dirp->dd_filled)	/* DIR structure is not filled */
		/* read sequentially */
		dirp->dd_stat = findnext(&dirp->dd_dta);
	else
		dirp->dd_filled = false;		/* already filled entry gets used */

	return dirp->dd_stat? NULL: (struct dirent*)&dirp->dd_dta;
}
