/*
    This file is part of the CLib sub-project of the FreeDOS project
    Copyright (C) 1997 by the author see below

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: RENAME.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int rename(char *fold, char *fnew)

	Rename file fold into fnew. Both name may contain even different
	paths, but they must lay onto the same physically device.
	No wildcards allowed.

	Input:
		fold != NULL
		fnew != NULL

	Return:
		0: on success
		else: on failure

	Note:
		<none>

	Conforms to:
		ANSI

	See also:
		open, close, remove

	Target compilers:
		Any C compiler

	Origin:
		1997/10/10 Steffen Kaiser (ska)

	Revised by:
		<none>

	File Revision:    Revision 1.2  1997/10/27 05:43:49  ska
*/

#include <_clib.h>			/* standard include, must be the first! */
#include <dir.h>
#include <dos.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: RENAME.C 1.2 1997/10/27 05:43:49 ska Exp $";
#endif

_CLibFunc int
rename(char const * const fold
      ,char const * const fnew)
{	struct REGPACK r;

	assert(fold != NULL);
	assert(fnew != NULL);

	r.r_ds = FP_SEG(fold);
	r.r_dx = FP_OFF(fold);
	r.r_es = FP_SEG(fnew);
	r.r_di = FP_OFF(fnew);
	r.r_si = 0;
	r.r_cx = 0;
	return _callLFN(0x56, &r);
}
